﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			棒タイトル表示ウインド処理										//
//																												//
//**************************************************************************************************************//

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(BarStr);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		BarWndProcBarStr()
{
	return AJC_WNDPROC_NAME(BarStr);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	棒タイトル表示ウインドプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_CREATE		)
{
	LRESULT			rc = -1;
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)((LPCREATESTRUCT)lParam)->lpCreateParams;

	do {
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		rc = 0;

	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_DESTROY	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_SIZE		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	HDC				hdc;

	pW->BarStrW = LOWORD(lParam);
	pW->BarStrH = HIWORD(lParam);

	//----- ビットマップオブジェクト再生成 ---------------//
	if (pW->hBmpBarStr != NULL) {
		DeleteObject(pW->hBmpBarStr);
	}
	hdc = GetDC(hwnd);
	pW->hBmpBarStr = CreateCompatibleBitmap(hdc, pW->BarStrW, pW->BarStrH);
	ReleaseDC(hwnd, hdc);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_HSCROLL	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	SCROLLINFO		si;
	SL				svPos;
	UW				knd = LOWORD(wParam);

	if (knd != SB_ENDSCROLL && knd != SB_THUMBPOSITION) {		//	スクロールバーを掴んだ？
		pW->fScrBar = TRUE;										//		「スクロール中モード」設定
	}
	else {														//	スクロールバーを離した？
		pW->fScrBar = FALSE;									//		「スクロール中モード」解除
		BarSetScrollInfo(pW);
	}

	si.cbSize = sizeof(SCROLLINFO);								//	横スクロール情報取得
	si.fMask  = SIF_ALL;										//	・
	GetScrollInfo(hwnd, SB_HORZ, &si);							//	・
	svPos = si.nPos;											//	現在の横方向位置を退避

	switch (knd) {
		case SB_LINELEFT:	si.nPos -= 1;			break;		//	○ →１桁左へ移動
		case SB_LINERIGHT:	si.nPos += 1;			break;		//	○ →１桁右へ移動
		case SB_PAGELEFT:	si.nPos -= si.nPage;	break;		//	○ →１項左へ移動
		case SB_PAGERIGHT:	si.nPos += si.nPage;	break;		//	○ →１項右へ移動
		case SB_THUMBTRACK:	si.nPos = si.nTrackPos;	break;		//	○ →スクロールバーを離した位置へ移動
	}
	si.fMask = SIF_POS;											//	スクロール位置設定
	SetScrollInfo(hwnd, SB_HORZ, &si, TRUE);					//	・
	GetScrollInfo(hwnd, SB_HORZ, &si);							//	スクロール位置取得
	if (si.nPos != svPos) {										//	スクロール位置に変化あり／スクロール終了？
		int	dix	   = si.nPos / pW->BarField;					//		先頭データインデクス
		int rem	   = (si.nPos % pW->BarField);					//		左端端数
		UI	nMax   = (pW->BarStrW / pW->BarField) + (rem != 0);	//		最大表示可能個数
		pW->rxView = -rem;										//		ウインド左端はみ出し部分の長さ
		pW->ixView = BarDixToBix(pW, dix);							//		表示開始バッファ・インデクス
		pW->pxView = si.nPos;									//		ウインド左端に対応するイメージ位置
		pW->nView  = pW->nBuf - dix;							//		表示個数
		pW->nView  = __min(pW->nView, nMax);					//		・

		BarReDraw(pW, FALSE);										//		ウィンドゥ描画

		pW->NtcScrPos = si.nPos;
		SendMessage(GetParent(pW->hBack), WM_COMMAND,			//		スクロール位置通知
					MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCBARN_SCRPOS),
					fCmdWithHdl ? (LPARAM)pW->hBack : si.nPos);

	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_PAINT		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT		ps;
	HDC				hdc, mdc;
	RECT			r;
	HFONT			hFont;
	int				bx, x, y;
	UI				ix, i, six, stl;
	SIZE			sz;
	WCP				p;
	WC				str[AJCBAR_MAXSTR];

	hdc	  = BeginPaint(hwnd, &ps);

	mdc	  = CreateCompatibleDC(hdc);
	if (mdc != NULL) {
		hFont = (HFONT)SelectObject(mdc, BarhMyFont);
		if (pW->hBmpBarStr == NULL) {
			pW->hBmpBarStr = CreateCompatibleBitmap(hdc, pW->BarStrW, pW->BarStrH);
		}
		if (pW->hBmpBarStr != NULL) {
			SelectObject(mdc, pW->hBmpBarStr);
			//----- 描画クリアー ---------------//
			GetClientRect(hwnd, &r);
			if (pW->fEnable) FillRect(mdc, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
			else			 FillRect(mdc, &r, hBruBtnFace);
			//----- 棒タイトル描画 -------------//
			ix = pW->ixView;
			bx = pW->rxView;
			for (i = 0; i < pW->nView; i++) {
				six = 0;
				y	= 0;
				p	= pW->pBuf[ix].str;
				for (;;) {
					if (*p == L'\n'	||	*p == 0) {
						str[six] = 0;
						stl = (UI)wcslen(str);
						GetTextExtentPoint32W(mdc, str, stl, &sz);
						x	= (bx + (pW->BarField - sz.cx) / 2);
						TextOutW(mdc, x, y, str, stl);
						six = 0;
						y += pW->cyNormal;
					}
					else {
						if (!iscntrl((UB)*p)) {
							str[six++] = *p;
						}
					}
					if (*p == 0) break;
					p++;
				}
				ix = ((ix + 1) % pW->prop.MaxBuf);
				bx += pW->BarField;
			}
			//----- ウインド表示 ---------------//
			BitBlt(hdc, 0, 0, pW->BarStrW, pW->BarStrH, mdc, 0, 0, SRCCOPY);
		}
		SelectObject(mdc, hFont);
		DeleteDC(mdc);
	}

	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_MOUSEMOVE	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_MOUSEMOVE を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_LBUTTONDOWN	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_LBUTTONDOWN を通知
	SendMessage(pW->hBack, WM_LBUTTONDOWN, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_MBUTTONDOWN	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_MBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_RBUTTONDOWN	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用＆右クリック通知用に バックウインドへ WM_RBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(BarStr, WM_RBUTTONUP	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用＆右クリック通知用に バックウインドへ WM_RBUTTONUP を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(BarStr)
	AJC_WNDMAP_MSG(BarStr, WM_CREATE		)
	AJC_WNDMAP_MSG(BarStr, WM_DESTROY		)
	AJC_WNDMAP_MSG(BarStr, WM_SIZE			)
	AJC_WNDMAP_MSG(BarStr, WM_HSCROLL		)
	AJC_WNDMAP_MSG(BarStr, WM_PAINT			)
	AJC_WNDMAP_MSG(BarStr, WM_MOUSEMOVE		)
	AJC_WNDMAP_MSG(BarStr, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(BarStr, WM_MBUTTONDOWN	)
	AJC_WNDMAP_MSG(BarStr, WM_RBUTTONDOWN	)
	AJC_WNDMAP_MSG(BarStr, WM_RBUTTONUP		)
AJC_WNDMAP_END
