﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			フィィルタウインド処理											//
//																												//
//**************************************************************************************************************//

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Filt);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		BarWndProcFilt()
{
	return AJC_WNDPROC_NAME(Filt);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	フィルタウインドプロシージャ																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Filt, WM_CREATE		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)((LPCREATESTRUCT)lParam)->lpCreateParams;
	int			i;

	MAjcSetWindowLong(hwnd, 0, (UX)pW);

	for (i=0; i<AJCBAR_MAXITEM; i++) {
		pW->hChkFilt[i] = CreateWindow(L"BUTTON",					// window class name
									 L"",							// window caption
									 WS_CHILD | BS_AUTOCHECKBOX,	// window style
									 2 + (BAR_FLT_WIDTH + 4) * i,	// initial x position
									 2,								// initial y position
									 BAR_FLT_WIDTH,					// initial x size
									 BAR_FLT_HEIGHT,				// initial y size
									 hwnd,							// parent window handle
									 (HMENU)((UX)i + BAR_IDC_CHK_BASE),	// window menu handle
									 hDllInst,						// program instance handle
									 NULL);							// creation parameters
		if (pW->hChkFilt[i] != NULL) {
			ShowWindow(pW->hChkFilt[i], SW_SHOW);
			SendMessage(pW->hChkFilt[i], BM_SETCHECK, BST_CHECKED, 0);
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Filt, WM_DESTROY	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	int			i;

	for (i=0; i<AJCBAR_MAXITEM; i++) {
		if (pW->hChkFilt[i] != NULL) {
			DestroyWindow(pW->hChkFilt[i]);
			pW->hChkFilt[i] = NULL;
		}
	}
	
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Filt, WM_COMMAND	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	UI			ix;

	ix = LOWORD(wParam) - BAR_IDC_CHK_BASE;
	if (ix >= 0	 &&	 ix < AJCBAR_MAXITEM  &&  HIWORD(wParam) == BN_CLICKED) {
		//----- フィルタ設定状態フラグ設定 -------------------------------------------//
		if (SendMessage(pW->hChkFilt[ix], BM_GETCHECK, 0, 0)) pW->MskFilt |=  (1 << ix);
		else												  pW->MskFilt &= ~(1 << ix);
		//----- 有効な表示項目数設定 -------------------------------------------------//
		BarSetValidItems(pW);
		//----- 棒表示域の長さ再計算 -------------------------------------------------//
		BarSetBarFieldLen(pW);
		//----- 現在位置からの表示項目数再設定 ---------------------------------------//
		SetViewInfoCurrent(pW);
		//----- スクロール情報更新 ---------------------------------------------------//
		BarSetScrollInfo(pW);
		//----- 再描画 ---------------------------------------------------------------//
		BarReDraw(pW, FALSE);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Filt, WM_PAINT		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;
	HBRUSH		hBrush;
	HPEN		hPen;
	UI			i;

	hdc	  = BeginPaint(hwnd, &ps);
	hBrush = (HBRUSH)SelectObject(hdc, (HBRUSH)GetStockObject(NULL_BRUSH));
	for (i=0; i<pW->prop.MaxItem; i++) {
		hPen = (HPEN)SelectObject(hdc, CreatePen(PS_SOLID, 1, pW->prop.rgb[i]));
		Rectangle(hdc,	1 + (BAR_FLT_WIDTH + 4) * i,
						1,
						1 + (BAR_FLT_WIDTH + 4) * i + BAR_FLT_WIDTH + 2,
						1 + BAR_FLT_HEIGHT + 2);
		DeleteObject(SelectObject(hdc, hPen));
	}
	SelectObject(hdc, hBrush);

	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Filt)
	AJC_WNDMAP_MSG(Filt, WM_CREATE	)
	AJC_WNDMAP_MSG(Filt, WM_DESTROY	)
	AJC_WNDMAP_MSG(Filt, WM_PAINT	)
	AJC_WNDMAP_MSG(Filt, WM_COMMAND	)
AJC_WNDMAP_END

