﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			グラフイメージ表示ウインド処理									//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Image);

static	VO		PaintText		  (PWRK_BARGRAPH pW, HDC hdc);
static	BOOL CALLBACK cbNtcNode(UX key, VOP pNodeData, UI len, UI nest, UX cbp);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		BarWndProcImage()
{
	return AJC_WNDPROC_NAME(Image);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	棒グラフイメージ表示ウインドプロシージャ																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_CREATE		)
{
	LRESULT			rc = -1;
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)((LPCREATESTRUCT)lParam)->lpCreateParams;

	do {
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//----- フィルタウインド生成 ---------------------------------------------------------------------------//
		pW->hFilter = CreateWindow((WCP)BarClassFilter,					// window class name
								L"",									// window caption
								WS_CHILD,								// window style
								0,										// initial x position
								0,										// initial y position
								(BAR_FLT_WIDTH + 4) * AJCBAR_MAXITEM,	// initial x size
								(BAR_FLT_HEIGHT + 4),					// initial y size
								hwnd,									// parent window handle
								NULL,									// window menu handle
								hDllInst,								// program instance handle
								pW);									// creation parameters
		if (pW->hFilter == NULL) {
			break;
		}

		//----- テキスト描画情報初期化 -------------------------------------------------------------------------//
		pW->hFontTxo = AjcGetStockFont(AJCFID_VAR12);
		pW->kAvlTxo = 1;		//	ＡＶＬキー
		if ((pW->hAvlTxo = AjcAvlCreate(0, NULL, NULL)) == NULL) {
			break;
		}

		//----- フィルタ／ボタン表示監視タイマ起動 -------------------------------------------------------------//
		SetTimer(hwnd, 1, 200, NULL);

		rc = 0;

	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_DESTROY	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	if (pW->hFilter != NULL) {
		//	テキスト描画ＡＶＬ消去
		if (pW->hAvlTxo != NULL) {
			AjcAvlDelete(pW->hAvlTxo);
			pW->hAvlTxo = NULL;
		}
		//	フィルタウインド破棄
		DestroyWindow(pW->hFilter);
		pW->hFilter = NULL;
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_SIZE		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	HDC				hdc;

	pW->ImageW = LOWORD(lParam);
	pW->ImageH = HIWORD(lParam);

	//----- ビットマップオブジェクト再生成 ---------------//
	if (pW->hBmpImage != NULL) {
		DeleteObject(pW->hBmpImage);
	}
	hdc = GetDC(hwnd);
	pW->hBmpImage = CreateCompatibleBitmap(hdc, pW->ImageW, pW->ImageH);
	ReleaseDC(hwnd, hdc);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_TIMER		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	BOOL		fShowFilt = FALSE;
	RECT		r;
	POINT		cp;

	//----- ポップアップボタン（フィルタ）表示／非表示の監視 ----------------//
	do {
		//--- ポップアップボタン非表示ならば何もしない ---//
		if (pW->style & AJCBARS_NOFILTER) break;
		//--- カーソル位置，ウインド位置取得 -------------//
		GetCursorPos(&cp);
		GetWindowRect(hwnd, &r);
		MapWindowPoints(NULL, hwnd, (LPPOINT)&cp, 1);
		MapWindowPoints(NULL, hwnd, (LPPOINT)&r , 2);
		//--- フィルタボタン表示／非表示 -----------------//
		if (cp.x >= 0 && cp.x < (BAR_FLT_WIDTH  + 4) * (int)pW->prop.MaxItem &&
			cp.y >= 0 && cp.y < (BAR_FLT_HEIGHT + 4)) {
			ShowWindow(pW->hFilter , SW_SHOW);
			fShowFilt = TRUE;
		}
		else {
			ShowWindow(pW->hFilter, SW_HIDE);
			fShowFilt = FALSE;
		}
	} while (0);
	return 0;


	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_PAINT		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT		ps;
	HDC				hdc, mdc;
	HPEN			hPen;
	RECT			r;
	HBRUSH			hBru;
	double			yr, step, min, max;
	int				x, y;
	UI				i, j, digit, prec, cxChar, cyChar, cyUnit;

	hdc	  = BeginPaint(hwnd, &ps);

	mdc	  = CreateCompatibleDC(hdc);
	if (mdc != NULL) {
		if (pW->hBmpImage == NULL) {
			pW->hBmpImage = CreateCompatibleBitmap(hdc, pW->ImageW, pW->ImageH);
		}
		if (pW->hBmpImage != NULL) {
			SelectObject(mdc, pW->hBmpImage);
			//----- 描画クリアー ---------------//
			GetClientRect(hwnd, &r);
			if (pW->fEnable) FillRect(mdc, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
			else			 FillRect(mdc, &r, hBruBtnFace);
			//----- スケール情報設定 -----------//
			cxChar = pW->cxNormal;
			cyChar = pW->cyNormal;
			cyUnit = cyChar + (cyChar / 2);
			min = __min(pW->prop.RngL, pW->prop.RngH);
			max = __max(pW->prop.RngL, pW->prop.RngH);
			if (pW->ScaleH != 0) {
				step = AjcCalcRangeStep(fabs(max - min), 6.0, ((double)pW->ScaleH / (double)cyUnit), &digit, &prec);
			}
			else {
				step = fabs(max - min);
			}
			min -= fmod(min, step);
			max -= fmod(max, step);
			//----- スケールライン描画 ---------//
			hPen = (HPEN)SelectObject(mdc, hPenScale);
			for (yr = min + step; yr < max; yr += step) {
				y = BarDatToYPos(pW, yr);
				MoveToEx(mdc, 0			, y, NULL);
				LineTo	(mdc, pW->ImageW, y);
			}
			hPen = (HPEN)SelectObject(mdc, hPen);
			//----- 横線描画 -------------------//
			for (i = 0; i < MAX_HLINE; i++) {
				if (pW->HLineTbl[i].fEnable	 &&	 pW->HLineTbl[i].hPen != NULL) {
					hPen = (HPEN)SelectObject(mdc, pW->HLineTbl[i].hPen);
					y = BarDatToYPos(pW, pW->HLineTbl[i].pos);
					MoveToEx(mdc, 0			, y, NULL);
					LineTo	(mdc, pW->ImageW, y);
					hPen = (HPEN)SelectObject(mdc, hPen);
				}
			}
			//----- 折れ線グラフ描画 -----------------------------------------------//
			if (pW->style & AJCBARS_LINEGRAPH) {
				int		bx, ix, msk;
				int		dix = BarBixToDix(pW, pW->ixView);
				UI		num = pW->nView;
				int		bix;

				//--- バッファインデクス，ベースＸ位置設定 -----------------//
				ix = pW->ixView;
				bx = pW->rxView;
				//--- 以前にデータがある場合は、データ項目を１つ戻す -------//
				if (dix > 0) {
					ix	= ((ix == 0) ? pW->prop.MaxBuf - 1 : ix	 - 1);
					bx -= pW->BarField;
					num++;
				}
				//--- 後部にデータがまだある場合は、表示項目を増やす -------//
				if (dix + num < (int)pW->nBuf) num++;
				if (dix + num < (int)pW->nBuf) num++;
				//--- 折れ線グラフ表示 -------------------------------------//
				for (i = 0, msk = 0x01; i < pW->prop.MaxItem; i++, msk <<= 1) {
					if (pW->MskFilt & msk) {
						hBru = (HBRUSH)SelectObject(mdc, CreateSolidBrush(pW->prop.rgb[i]));
						hPen = (HPEN  )SelectObject(mdc, CreatePen(PS_SOLID, 1, pW->prop.rgb[i]));
						bix = ix;
						for (j = 0, x = bx + (pW->BarField / 2); j < num; j++, x += pW->BarField) {
							y	 = BarDatToYPos(pW, pW->pBuf[bix].val[i]);
							if (j == 0) {
								MoveToEx(mdc, x, y, NULL);
							}
							else {
								LineTo(mdc, x, y);
							}
							Ellipse(mdc, x - 2, y - 2, x + 2, y + 2);
							bix	 = ((bix + 1) % pW->prop.MaxBuf);
						}
						DeleteObject(SelectObject(hdc, hBru));
						DeleteObject(SelectObject(hdc, hPen));
					}
				}
			}
			//----- 棒グラフ描画 ---------------------------------------------------//
			else {
				int		yb, bx, ix, msk;
				ix = pW->ixView;
				bx = pW->rxView;
				yb = BarDatToYPos(pW, pW->prop.Base);
				yb = __max(yb, 0);
				yb = __min(yb, (int)pW->ImageH);
				for (i = 0; i < pW->nView; i++) {
					x  = bx + ((pW->BarField - (pW->prop.BarWidth * pW->ValidItems)) / 2);
					for (j = 0, msk = 0x01; j < pW->prop.MaxItem; j++, msk <<= 1) {
						if (pW->MskFilt & msk) {
							if (hBru = (HBRUSH)SelectObject(mdc, CreateSolidBrush(pW->prop.rgb[j]))) {
								y  = BarDatToYPos(pW, pW->pBuf[ix].val[j]);
								y  = __max(y, 0);
								y  = __min(y, (int)pW->ImageH);
								if (y <= yb) Rectangle(mdc, x, y , x + pW->prop.BarWidth, yb);
								else		 Rectangle(mdc, x, yb, x + pW->prop.BarWidth, y );
								DeleteObject(SelectObject(hdc, hBru));
							}
							x += pW->prop.BarWidth;
						}
					}
					ix = ((ix + 1) % pW->prop.MaxBuf);
					bx += pW->BarField;
				}
			}
			//----- テキスト描画 ---------------//
			PaintText(pW, mdc);
			//----- タイトル描画 ---------------//
			SubTtlBmpDraw(&pW->TtlInfo, hwnd, mdc, 2, 0, pW->fEnable);
			//----- ウインド表示 ---------------//
			BitBlt(hdc, 0, 0, pW->ImageW, pW->ImageH, mdc, 0, 0, SRCCOPY);
		}
		DeleteDC(mdc);
	}

	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_MOUSEMOVE	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_MOUSEMOVE を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_LBUTTONDOWN)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_LBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_MBUTTONDOWN)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_MBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_RBUTTONDOWN)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用＆右クリック通知用に バックウインドへ WM_RBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_RBUTTONUP	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用＆右クリック通知用に 最上位ウインドへ WM_RBUTTONUP を通知
	SendMessage(pW->hBack, WM_RBUTTONUP, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_LBUTTONDBLCLK	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	int				x = (SW)LOWORD(lParam);
	int				y = (SW)HIWORD(lParam);

	SendMessage(GetParent(pW->hBack), WM_COMMAND,
				MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCBARN_DBLCLK),
				fCmdWithHdl ? (LPARAM)pW->hBack : MAKELONG(x, y));

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Image, WM_DROPFILES	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	HWND			hParent = GetParent(pW->hBack);
	HDROP	hDrop;
	UI		i, n, bytes;
	WC		path[MAX_PATH];

	//----- 前回のドロップデータ破棄 ----------------------------------//
	AjcRngPurge(pW->hRngDir);
	AjcRngPurge(pW->hRngFile);

	//----- カウンタクリアー ------------------------------------------//
	pW->NtcDirs = pW->NtcFiles = 0;
	//----- ドロップディレクトリ名／ファイル名取得 --------------------//
	hDrop = (HDROP)wParam;														//	ドロップハンドル設定
	n	  = DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);							//	ドロップファイル数取得
	for (i=0; i < n; i++) {														//	ドロップパス数ループ
		DragQueryFileW(hDrop, i, path, MAX_PATH);								//	ドロップパス名取得
		if (AjcPathExistsW(path)) {												//	有効なパス？
			bytes = (UI)wcslen(path) * 2 + 2;									//		パス名の長さ設定
			if (AjcPathIsDirectoryW(path)) {									//		ディレクトリ？
				pW->NtcDirs++;													//				DIR数更新
				AjcRngPutData(pW->hRngDir, (VOP)&bytes, sizeof bytes);			//				DIR名退避
				AjcRngPutData(pW->hRngDir, (VOP)path, bytes);					//				・
			}
			else {																//		ファイル？
				pW->NtcFiles++;													//				FILE数更新
				AjcRngPutData(pW->hRngFile, (VOP)&bytes, sizeof bytes);			//				ファイル名退避
				AjcRngPutData(pW->hRngFile, (VOP)path, bytes);					//				・
			}
		}
	}
	DragFinish(hDrop);															//	ドロップ終了

	//----- ディレクトリドロップイベント通知 --------------------------//
	if (pW->NtcDirs) {
		SendMessage(hParent, WM_COMMAND, MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCBARN_DROPDIR) ,
										fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcDirs);
	}
	//----- ファイルドロップイベント通知 ------------------------------//
	if (pW->NtcFiles) {
		SendMessage(hParent, WM_COMMAND, MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCBARN_DROPFILE),
										fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcFiles);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Image)
	AJC_WNDMAP_MSG(Image, WM_CREATE			)
	AJC_WNDMAP_MSG(Image, WM_DESTROY		)
	AJC_WNDMAP_MSG(Image, WM_SIZE			)
	AJC_WNDMAP_MSG(Image, WM_TIMER			)
	AJC_WNDMAP_MSG(Image, WM_PAINT			)
	AJC_WNDMAP_MSG(Image, WM_MOUSEMOVE		)
	AJC_WNDMAP_MSG(Image, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(Image, WM_MBUTTONDOWN	)
	AJC_WNDMAP_MSG(Image, WM_RBUTTONDOWN	)
	AJC_WNDMAP_MSG(Image, WM_RBUTTONUP		)
	AJC_WNDMAP_MSG(Image, WM_LBUTTONDBLCLK	)
	AJC_WNDMAP_MSG(Image, WM_DROPFILES		)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	テキスト描画																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
VO		PaintText(PWRK_BARGRAPH pW, HDC hdc)
{
	UI	i;

	if (AjcAvlGetCount(pW->hAvlTxo) != 0) {
		HFONT	hFontSv;
		if (hFontSv = SelectObject(hdc, pW->hFontTxo)) {
			if (pW->hTxo = AjcTxoCreate(hdc, 0, 0, -10)) {
				for (i = 0; i < 8; i++) {
					AjcTxoSetPaletteItem(pW->hTxo, i, pW->prop.rgb[i]);
				}
				AjcTxoSetDcBmpSize(pW->hTxo, pW->ImageW, pW->ImageH);
				AjcAvlEnumNodesEx(pW->hAvlTxo, (UX)pW, cbNtcNode, FALSE);
				AjcTxoDelete(pW->hTxo, TRUE);
				pW->hTxo = NULL;
			}
			SelectObject(hdc, hFontSv);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ＡＶＬノード通知																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbNtcNode(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	PWRK_BARGRAPH	pW    = (PWRK_BARGRAPH)cbp;
	PBARTXO			pNode = (PBARTXO)pNodeData;

	AjcTxoTextOutEx(pW->hTxo, pNode->pt.x, pNode->pt.y, pNode->txt);

	return TRUE;
}

