﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			スケール値表示ウインド処理										//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Scale);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		BarWndProcScale()
{
	return AJC_WNDPROC_NAME(Scale);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	スケール値表示ウインドプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Scale, WM_CREATE		)
{
	LRESULT			rc = -1;
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)((LPCREATESTRUCT)lParam)->lpCreateParams;

	do {
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		rc = 0;

	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Scale, WM_DESTROY	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Scale, WM_SIZE		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	HDC				hdc;

	pW->ScaleW = LOWORD(lParam);
	pW->ScaleH = HIWORD(lParam);

	//----- ビットマップオブジェクト再生成 ---------------//
	if (pW->hBmpScale != NULL) {
		DeleteObject(pW->hBmpScale);
	}
	hdc = GetDC(hwnd);
	pW->hBmpScale = CreateCompatibleBitmap(hdc, pW->ScaleW, pW->ScaleH);
	ReleaseDC(hwnd, hdc);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Scale, WM_PAINT		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT		ps;
	HDC				hdc, mdc;
	RECT			r;
	HFONT			hFont;
	double			y, step, min, max;
	int				x;
	UI				stl, digit, prec, cxChar, cyChar, cyUnit, maxstl;
	WC				txt[64];

	hdc	  = BeginPaint(hwnd, &ps);

	mdc	  = CreateCompatibleDC(hdc);
	if (mdc != NULL) {
		hFont = (HFONT)SelectObject(mdc, BarhMyFont);
		if (pW->hBmpScale == NULL) {
			pW->hBmpScale = CreateCompatibleBitmap(hdc, pW->ScaleW, pW->ScaleH);
		}
		if (pW->hBmpScale != NULL) {
			SelectObject(mdc, pW->hBmpScale);
			//----- 描画クリアー ---------------//
			GetClientRect(hwnd, &r);
			if (pW->fEnable) FillRect(mdc, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
			else			 FillRect(mdc, &r, hBruBtnFace);
			//----- 縦軸単位名描画 -------------//
			stl = (UI)wcslen(pW->VUnitStr);
			TextOutW(mdc, 1, 1, pW->VUnitStr, stl);
			//----- スケール情報設定 -----------//
			cxChar = pW->cxNormal;
			cyChar = pW->cyNormal;
			cyUnit = cyChar + (cyChar / 2);
			min = __min(pW->prop.RngL, pW->prop.RngH);
			max = __max(pW->prop.RngL, pW->prop.RngH);
			if (pW->ScaleH != 0) {
				step = AjcCalcRangeStep(fabs(max - min), 6.0, ((double)pW->ScaleH / (double)cyUnit), &digit, &prec);
			}
			else {
				step = fabs(max - min);
			}
			min -= fmod(min, step);
			max -= fmod(max, step);
			//----- スケール値描画 -------------//
			maxstl = 0;
			SetBkMode(hdc, TRANSPARENT);
			if (pW->fEnable) SetTextColor(hdc, RGB(	 0,	  0,   0));
			else			 SetTextColor(hdc, GetSysColor(COLOR_GRAYTEXT));
			for (y = min + step; y < max; y += step) {
				if (digit + prec <= 10) AjcSnPrintF(txt, AJCTSIZE(txt), L"%.*f", prec, y);
				else					AjcSnPrintF(txt, AJCTSIZE(txt), L"%.*G", digit + prec, y);
				stl = (UI)wcslen(txt);
				x = pW->ScaleW - (cxChar * stl + 4);
				TextOut(mdc, x, BarDatToYPos(pW, y) - (cyChar / 2), txt, stl);
				maxstl = __max(maxstl, stl);
			}
			//----- ウインド表示 ---------------//
			BitBlt(hdc, 0, 0, pW->ScaleW, pW->ScaleH, mdc, 0, 0, SRCCOPY);
		}
		SelectObject(mdc, hFont);
		DeleteDC(mdc);
	}

	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Scale, WM_MOUSEMOVE	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ  WM_MOUSEMOVE を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Scale, WM_LBUTTONDOWN)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_LBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Scale, WM_MBUTTONDOWN)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ  WM_MBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Scale, WM_RBUTTONDOWN)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用＆右クリック通知用に バックウインドへ  WM_RBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Scale, WM_RBUTTONUP	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用＆右クリック通知用に バックウインドへ  WM_RBUTTONUP を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Scale)
	AJC_WNDMAP_MSG(Scale, WM_CREATE			)
	AJC_WNDMAP_MSG(Scale, WM_DESTROY		)
	AJC_WNDMAP_MSG(Scale, WM_SIZE			)
	AJC_WNDMAP_MSG(Scale, WM_PAINT			)
	AJC_WNDMAP_MSG(Scale, WM_MOUSEMOVE		)
	AJC_WNDMAP_MSG(Scale, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(Scale, WM_MBUTTONDOWN	)
	AJC_WNDMAP_MSG(Scale, WM_RBUTTONDOWN	)
	AJC_WNDMAP_MSG(Scale, WM_RBUTTONUP		)
AJC_WNDMAP_END

