﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			棒タイトル名表示ウインド処理									//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(TtlStr);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		BarWndProcTtlStr()
{
	return AJC_WNDPROC_NAME(TtlStr);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	棒タイトル名表示ウインドプロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TtlStr, WM_CREATE		)
{
	LRESULT			rc = -1;
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)((LPCREATESTRUCT)lParam)->lpCreateParams;

	do {
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		rc = 0;

	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TtlStr, WM_DESTROY	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TtlStr, WM_SIZE		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	HDC				hdc;

	pW->TtlStrW = LOWORD(lParam);
	pW->TtlStrH = HIWORD(lParam);

	//----- ビットマップオブジェクト再生成 ---------------//
	if (pW->hBmpTtlStr != NULL) {
		DeleteObject(pW->hBmpTtlStr);
	}
	hdc = GetDC(hwnd);
	pW->hBmpTtlStr = CreateCompatibleBitmap(hdc, pW->TtlStrW, pW->TtlStrH);
	ReleaseDC(hwnd, hdc);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TtlStr, WM_PAINT		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT		ps;
	HDC				hdc, mdc;
	HFONT			hFont;
	RECT			r;
	int				x, y;
	UI				six, stl;
	WCP				p;
	SIZE			sz;
	WC				str[128];

	hdc	  = BeginPaint(hwnd, &ps);

	mdc	  = CreateCompatibleDC(hdc);
	if (mdc != NULL) {
		hFont = (HFONT)SelectObject(mdc, BarhMyFont);
		if (pW->hBmpTtlStr == NULL) {
			pW->hBmpTtlStr = CreateCompatibleBitmap(hdc, pW->TtlStrW, pW->TtlStrH);
		}
		if (pW->hBmpTtlStr != NULL) {
			SelectObject(mdc, pW->hBmpTtlStr);
			//----- 描画クリアー ---------------//
			GetClientRect(hwnd, &r);
			if (pW->fEnable) FillRect(mdc, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
			else			 FillRect(mdc, &r, hBruBtnFace);
			//----- 棒タイトル名描画 -----------//
			six = 0;
			y  = 0;
			p  = pW->TtlStr;
			for (;;) {
				if (*p == L'\n'	||	*p == 0) {
					str[six] = 0;
					stl = (UI)wcslen(str);
					GetTextExtentPoint32W(mdc, str, stl, &sz);
					x	= (pW->TtlStrW - (sz.cx)) / 2;
					TextOutW(mdc, x, y, str, stl);
					six = 0;
					y += pW->cyNormal;
				}
				else {
					if (!iswcntrl((UW)*p)) {
						str[six++] = *p;
					}
				}
				if (*p == 0) break;
				p++;
			}
			//----- ウインド表示 ---------------//
			BitBlt(hdc, 0, 0, pW->ImageW, pW->ImageH, mdc, 0, 0, SRCCOPY);
		}
		SelectObject(mdc, hFont);
		DeleteDC(mdc);
	}

	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TtlStr, WM_MOUSEMOVE	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_MOUSEMOVEを通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TtlStr, WM_LBUTTONDOWN	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_LBUTTONDOWN を通知
	SendMessage(pW->hBack, WM_LBUTTONDOWN, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TtlStr, WM_MBUTTONDOWN	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用に バックウインドへ WM_LBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TtlStr, WM_RBUTTONDOWN	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用＆右クリック通知用に バックウインドへ WM_RBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TtlStr, WM_RBUTTONUP	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	//	チップテキストコントロール用＆右クリック通知用に バックウインドへ WM_RBUTTONUP を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(TtlStr)
	AJC_WNDMAP_MSG(TtlStr, WM_CREATE		)
	AJC_WNDMAP_MSG(TtlStr, WM_DESTROY		)
	AJC_WNDMAP_MSG(TtlStr, WM_SIZE			)
	AJC_WNDMAP_MSG(TtlStr, WM_PAINT			)
	AJC_WNDMAP_MSG(TtlStr, WM_MOUSEMOVE		)
	AJC_WNDMAP_MSG(TtlStr, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(TtlStr, WM_MBUTTONDOWN	)
	AJC_WNDMAP_MSG(TtlStr, WM_RBUTTONDOWN	)
	AJC_WNDMAP_MSG(TtlStr, WM_RBUTTONUP		)
AJC_WNDMAP_END

