﻿#include	"AjcInternal.h"
#include	"AjcCtrlInpValDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（数値入力）			ＡＰＩ															//
//																												//
//**************************************************************************************************************//

#define	IS_MY_INST(P)	(P != NULL && P->InstID == IV_INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
ATOM	IvClassMain		= 0;
ATOM	IvClassForMSIL	= 0;
HFONT	IvhFontBtnFace	= NULL;

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcCtrlInpValInit(VO)
{
	BOOL		rc = FALSE;
	WNDCLASS	wndclass;
	LOGFONT		lf;

	do {
		lf.lfHeight			= -8;
		lf.lfWidth			= 0;
		lf.lfEscapement		= 0;
		lf.lfOrientation	= 0;
		lf.lfWeight			= 0;
		lf.lfItalic			= 0;
		lf.lfUnderline		= 0;
		lf.lfStrikeOut		= 0;
		lf.lfCharSet		= 0;
		lf.lfOutPrecision	= 0;
		lf.lfClipPrecision	= 0;
		lf.lfQuality		= 0;
		lf.lfPitchAndFamily	= VARIABLE_PITCH;
		wcscpy(lf.lfFaceName, L"Century");
		if ((IvhFontBtnFace = CreateFontIndirect(&lf)) == NULL) break;

		//----- メインウインドクラス -------------------------//
		wndclass.style			= CS_GLOBALCLASS;
		wndclass.lpfnWndProc	= IvWndProcMain();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRKINPVAL);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= hBruBtnFace;
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcCtrlInpVal";
		if ((IvClassMain = RegisterClass(&wndclass)) == 0) break;

		//----- ＭＳＩＬコードサポート用 ---------------------//
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= IvWndProcMSIL();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(VOP);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcIvForMSIL";
		if ((IvClassForMSIL = RegisterClass(&wndclass)) == 0) break;

		rc = TRUE;
	} while(0);

	if (rc == FALSE) {
		AjcCtrlInpValEnd();
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcCtrlInpValEnd (VO)
{
	if (IvClassMain 	!= 0)	 {UnregisterClass((WCP)IvClassMain	 , hDllInst); IvClassMain	  = 0;	 }
	if (IvClassForMSIL	!= 0)	 {UnregisterClass((WCP)IvClassForMSIL, hDllInst); IvClassForMSIL  = 0;	 }
	if (IvhFontBtnFace	!= NULL) {DeleteObject	 (IvhFontBtnFace				   ); IvhFontBtnFace	  = NULL;}
}
//==============================================================================================================//
//	テキスト表示形式の設定																						//
//																												//
//	引　数	：	hwnd	  - 数値入力コントロールのハンドル														//
//				width	  - テキストボックスの大きさ（幅）を、文字の桁数で指定します。							//
//				precision - 正の数値の場合は、少数部の桁数を指定します。(書式指定「“%.*f”」 の「*」の部分の値)//
//							負数の場合は、有効数字の桁数を指定します。	(書式指定「“%.*G”」 の「*」の部分の値)//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetTextFormat	(HWND hwnd, int width, UI precision)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_SETTEXTFORMAT, width, precision);
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロパティの取得																							//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//				pBuf	- 取得したプロパティを格納するバッファのアドレス										//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvGetProp			(HWND hwnd, PAJCIVPROP pBuf)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_GETPROP, (WPARAM)pBuf, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロパティの設定																							//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//				pProp	- 設定するプロパティデータのアドレス													//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetProp			(HWND hwnd, PCAJCIVPROP pProp)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_SETPROP, (WPARAM)pProp, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	コントロール外枠の表示色取得																				//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	≠-1 - 成功（外枠の表示色(COLORREF値)）															//
//				＝-1 - 失敗																						//
//==============================================================================================================//
AJCEXPORT	COLORREF	WINAPI AjcIvGetBorderColor	(HWND hwnd)
{
	COLORREF	rc = -1;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (COLORREF)SendMessage(hwnd, AJCIVM_GETBORDERCOLOR, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	コントロール外枠の表示色設定																				//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//				color	- 外枠の表示色																			//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetBorderColor	(HWND hwnd, COLORREF color)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_SETBORDERCOLOR, color, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	数値入力時のブリンク色取得																					//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	≠-1 - 成功（数値入力時のブリンク色）															//
//				＝-1 - 失敗																						//
//==============================================================================================================//
AJCEXPORT	COLORREF	WINAPI AjcIvGetBlinkColor	(HWND hwnd)
{
	COLORREF	rc = -1;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (COLORREF)SendMessage(hwnd, AJCIVM_GETBLINKCOLOR, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	数値入力時のブリンク色設定																					//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//				color	- 数値入力時のブリンク色																//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetBlinkColor	(HWND hwnd, COLORREF color)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_SETBLINKCOLOR, color, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	スライダのウインドハンドル取得																				//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	≠NULL - 成功（スライダのウインドハンドル）														//
//				＝NULL - 失敗																					//
//==============================================================================================================//
AJCEXPORT	HWND		WINAPI AjcIvGetSilderHandle	(HWND hwnd)
{
	HWND	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (HWND)SendMessage(hwnd, AJCIVM_GETSLDHANDLE, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ボタンのウインドハンドル取得																				//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	≠NULL - 成功（スピンボタンのウインドハンドル）													//
//				＝NULL - 失敗																					//
//==============================================================================================================//
AJCEXPORT	HWND		WINAPI AjcIvGetBtnHandle	(HWND hwnd)
{
	HWND	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (HWND)SendMessage(hwnd, AJCIVM_GETBTNHANDLE, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキストボックスのウインドハンドル取得																		//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	≠NULL - 成功（テキストボックスのウインドハンドル）												//
//				＝NULL - 失敗																					//
//==============================================================================================================//
AJCEXPORT	HWND		WINAPI AjcIvGetTxtHandle	(HWND hwnd)
{
	HWND	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (HWND)SendMessage(hwnd, AJCIVM_GETTXTHANDLE, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	スピンボタンのウインドハンドル取得																			//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	≠NULL - 成功（スピンボタンのウインドハンドル）													//
//				＝NULL - 失敗																					//
//==============================================================================================================//
AJCEXPORT	HWND		WINAPI AjcIvGetSpnHandle	(HWND hwnd)
{
	HWND	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (HWND)SendMessage(hwnd, AJCIVM_GETSPNHANDLE, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキストボックスのサイズ（桁数）取得																		//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	≠0 - 現在設定されているテキストボックスのサイズ（桁数）										//
//				＝0 - 失敗																						//
//==============================================================================================================//
AJCEXPORT	UI			WINAPI AjcIvGetTxtLen		(HWND hwnd)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (UI)SendMessage(hwnd, AJCIVM_GETTXTLEN, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキストボックスのサイズ（桁数）設定																		//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//				len 	- テキストボックスのサイズ（桁数）														//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetTxtLen		(HWND hwnd, UI len)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_SETTXTLEN, len, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	右ボタン操作通知設定																						//
//																												//
//	引　数	：	hwnd		 - 数値入力コントロールのハンドル													//
//				fNtcRClk	 - TRUE : 右ボタンのDOWN/UPを通知する，FALSE: 右ボタンのDOWN/UPを通知しない			//
//				msgRBtnDown  - 右ボタン押下時の通知メッセージコード　　（０指定時は非通知）						//
//				msgRBtnUp	 - 右ボタンを離した時の通知メッセージコード（０指定時は非通知）						//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetNtcRClk		(HWND hwnd, BOOL fNtcRClk, UI msgRBtnDown, UI msgRBtnUp)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_SETNTCRCLK, fNtcRClk, MAKELONG(msgRBtnDown, msgRBtnUp));
		}
	}
	return rc;
}
//==============================================================================================================//
//	値の取得																									//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	実数値																							//
//==============================================================================================================//
AJCEXPORT	double		WINAPI AjcIvGetValue	(HWND hwnd)
{
	double	rc = 0;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			SendMessage(hwnd, AJCIVM_R_GETVALUE, (WPARAM)&rc, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	値の取得（整数）																							//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	実数値																							//
//==============================================================================================================//
AJCEXPORT	int		WINAPI AjcIvGetValueInt	(HWND hwnd)
{
	int		rc = 0;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (int)SendMessage(hwnd, AJCIVM_I_GETVALUE, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	値の設定																									//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//				value	- 設定する値																			//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetValue	(HWND hwnd, double value)
{
	BOOL	rc = FALSE;

	rc = AjcIvSetValueEx(hwnd, value, FALSE);

	return rc;
}
//==============================================================================================================//
//	値の設定（イベントフラグ指定）																				//
//																												//
//	引　数	：	hwnd	- 数値入力コントロールのハンドル														//
//				value	- 設定する値																			//
//				fNtc	- 値の通知イベント発生フラグ															//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetValueEx	(HWND hwnd, double value, BOOL fNtc)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_R_SETVALUE, (WPARAM)&value, fNtc);
		}
	}
	return rc;
}
//==============================================================================================================//
//	数値範囲の設定																								//
//																												//
//	引　数	：	hwnd	 - 数値入力コントロールのハンドル														//
//				minValue - 最小値																				//
//				maxValue - 最大値																				//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetRange	(HWND hwnd, double minValue, double maxValue)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_R_SETRANGE, (WPARAM)&minValue, (LPARAM)&maxValue);
		}
	}
	return rc;
}
//==============================================================================================================//
//	数値最小単位値の設定																						//
//																												//
//	引　数	：	hwnd	 - 数値入力コントロールのハンドル														//
//				unit	 - 数値の最小単位値																		//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetSldUnit	(HWND hwnd, double unit)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_R_SETSLDUNIT, (WPARAM)&unit, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	スライダ・ページサイズの設定																				//
//																												//
//	引　数	：	hwnd	 - 数値入力コントロールのハンドル														//
//				page	 - スライダ・ページサイズ																//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetSldPage	(HWND hwnd, double page)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_R_SETSLDPAGE, (WPARAM)&page, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	スピンボタンによる増減値設定																				//
//																												//
//	引　数	：	hwnd	 - 数値入力コントロールのハンドル														//
//				step	 - スピンボタン操作時の増減値															//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetSpnStep	(HWND hwnd, double step)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_R_SETSPNSTEP, (WPARAM)&step, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	数値の精度設定																								//
//																												//
//	引　数	：	hwnd	 - 数値入力コントロールのハンドル														//
//				prec	 - 小数部の桁数（正数）、あるいは、数値の有効桁数（負数）								//
//							正の数値の場合は、少数部の桁数を指定します。(書式指定「“%.*f”」 の「*」の部分の値)//
//							負数の場合は、有効数字の桁数を指定します。	(書式指定「“%.*G”」 の「*」の部分の値)//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvSetPrecision	(HWND hwnd, int prec)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage(hwnd, AJCIVM_R_SETPREC, (WPARAM)&prec, 0);
		}
	}
	return rc;
}

//==============================================================================================================//
//	ツールチップ文字列の設定																					//
//																												//
//	引　数	：	hwnd	 - 数値入力コントロールのハンドル														//
//				pTipTxt  - ツールチップ文字列のアドレス（NULLを指定した場合は、ツールチップを表示しません）		//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI AjcIvSetTipTextA		(HWND hwnd, C_BCP pTipTxt)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage (hwnd, AJCIVM_SETTIPTEXTA, (WPARAM)pTipTxt, 0);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI AjcIvSetTipTextW		(HWND hwnd, C_WCP pTipTxt)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (BOOL)SendMessage (hwnd, AJCIVM_SETTIPTEXTW, (WPARAM)pTipTxt, 0);
		}
	}
	return rc;
}

//==============================================================================================================//
//	ツールチップ文字列の取得																					//
//																												//
//	引　数	：	hwnd	 - 数値入力コントロールのハンドル														//
//				pBuf	 - ツールチップ文字列を格納するバッファのアドレス										//
//				lBuf	 - ツールチップ文字列を格納するバッファのバイト数／文字数								//
//																												//
//	戻り値	：	ツールチップ文字列のバイト数／文字数（pBuf=NULLの場合は、文字列終端(‘\0’)を含む）				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI			WINAPI AjcIvGetTipTextA		(HWND hwnd, BCP pBuf, UI lBuf)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (UI)SendMessage(hwnd, AJCIVM_GETTIPTEXTA, (WPARAM)pBuf, lBuf);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI			WINAPI AjcIvGetTipTextW		(HWND hwnd, WCP pBuf, UI lBuf)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (UI)SendMessage(hwnd, AJCIVM_GETTIPTEXTW, (WPARAM)pBuf, lBuf);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト表示条件設定																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				fShowAlways	 - ツールチップ・テキスト表示条件													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcIvSetTipShowAlways(HWND hwnd, BOOL fShowAlways)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pW->fShowAlways = fShowAlways;
			AjcTipTextSetShowAlways(hwnd, pW->fShowAlways);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト表示条件取得																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	ツールチップ・テキスト表示条件																	//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcIvGetTipShowAlways(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->fShowAlways;
		}
	}
	return rc;
}
//==============================================================================================================//
//	デフォルトツールチップテキストの許可／禁止																	//
//																												//
//	引　数	：	hwnd	 - 数値入力コントロールのハンドル														//
//				fEnable	 - TRUE:許可，FALSE:禁止																//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvEnaDefTipText (HWND hwnd, BOOL fEnable)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (fEnable) {
				//	各コントロールのチップテキスト設定 ＆ 最上位ウインドのチップテキスト消去
				IvSetDefaultTipText(pW);
			}
			else {
				//	各コントロールのチップテキスト消去 ＆ 最上位ウインドのチップテキスト設定
				IvClrDefaultTipText(pW);
			}
			pW->fEnaDefTip = fEnable;
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルから永続情報読み出し																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//				pKey		 - キー名称																			//
//				fNtc		 - イベント通知フラグ																//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcIvLoadPermInfoA		(HWND hwnd, C_BCP pProfileSect, C_BCP pKey, BOOL fNtc)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmpSec = NULL;
	WCP		pTmpKey = NULL;

	if (pProfileSect != NULL && pKey != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
		if (len != 0 && (pTmpSec = AjcTAllocW(len))) {
			MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmpSec, len);

			len = MultiByteToWideChar(CP_ACP, 0, pKey, -1, NULL, 0);
			if (len != 0 && (pTmpKey = AjcTAllocW(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKey, -1, pTmpKey, len);
				rc = AjcIvLoadPermInfoW(hwnd, pTmpSec, pTmpKey, fNtc);
			}
		}
		if (pTmpSec != NULL) free(pTmpSec);
		if (pTmpKey != NULL) free(pTmpKey);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcIvLoadPermInfoW		(HWND hwnd, C_WCP pProfileSect, C_WCP pKey, BOOL fNtc)
{
	BOOL		rc = FALSE;
	double		val;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL && pKey != NULL) {
			//----- セクション名，キー接頭語退避 ---------------------------------------------------------------//
			AjcIvSetPermAttW(hwnd, pProfileSect, pKey);
			//----- 設定値読み出し -----------------------------------------------------------------------------//
			val = AjcGetProfileRealW(pW->PermSect, pW->PermKey, AjcIvGetValue(hwnd));
			rc = (BOOL)SendMessage(hwnd, AJCIVM_R_SETVALUE, (WPARAM)&val, fNtc);
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルへ永続情報書き込み																				//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcIvSavePermInfo		(HWND hwnd)
{
	return 	AjcIvSavePermInfoExW(hwnd, NULL, NULL);
}
//==============================================================================================================//
//	プロファイルへ永続情報書き込み（セクション指定）															//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pSect		 - セクション名へのポインタ															//
//				pKey		 - キー名称																			//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcIvSavePermInfoExA(HWND hwnd, C_BCP pProfileSect, C_BCP pKey)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmpSec = NULL;
	WCP		pTmpKey = NULL;

	do {
		if (pProfileSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
			if (len != 0 && (pTmpSec = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmpSec, len);
			}
			else break;
		}
		if (pKey != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pKey, -1, NULL, 0);
			if (len != 0 && (pTmpKey = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKey, -1, pTmpKey, len);
			}
			else break;
		}
		rc = AjcIvSavePermInfoExW(hwnd, pTmpSec, pTmpKey);
	} while(0);

	if (pTmpSec != NULL) free(pTmpSec);
	if (pTmpKey != NULL) free(pTmpKey);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcIvSavePermInfoExW(HWND hwnd, C_WCP pProfileSect, C_WCP pKey)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//	セクション指定無しならば、ロード時に設定したセクション名とする
			if (pProfileSect == NULL) pProfileSect = pW->PermSect;
			if (pKey		 == NULL) pKey		   = pW->PermKey;
			//	プロファイルセーブ
			if (*pProfileSect != 0 && *pKey != 0) {
				rc = AjcPutProfileRealW(pProfileSect, pKey, pW->Value);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	永続化の属性（セクション名，キー接頭語）設定																//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//				pKey		 - キー名称																			//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcIvSetPermAttA		(HWND hwnd, C_BCP pProfileSect, C_BCP pKey)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmpSec = NULL;
	WCP		pTmpKey = NULL;

	do {
		if (pProfileSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
			if (len != 0 && (pTmpSec = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmpSec, len);
			}
			else break;
		}
		if (pKey	   != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pKey, -1, NULL, 0);
			if (len != 0 && (pTmpKey = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKey, -1, pTmpKey, len);
			}
			else break;
		}
		rc = AjcIvSetPermAttW(hwnd, pTmpSec, pTmpKey);
	} while(0);

	if (pTmpSec != NULL) free(pTmpSec);
	if (pTmpKey != NULL) free(pTmpKey);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcIvSetPermAttW		(HWND hwnd, C_WCP pProfileSect, C_WCP pKey)
{
	BOOL		rc = FALSE;
	WC			szid[16];

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL && pKey != NULL) {
			//----- ＩＤ文字列設定 -----------------------------------------------------------------------------//
			AjcSnPrintFW(szid, AJCTSIZE(szid), L"%06u", (UW)MAjcGetWindowLong(pW->hBack, GWL_ID));
			//----- セクション名設定 ---------------------------------------------------------------------------//
			if (pProfileSect != NULL) AjcSnPrintFW(pW->PermSect, AJCTSIZE(pW->PermSect) 	, L"%s" 	, pProfileSect);
			else					  AjcSnPrintFW(pW->PermSect, AJCTSIZE(pW->PermSect) 	, L"SInp%s" , szid		  );
			//----- キー接頭語設定 -----------------------------------------------------------------------------//
			if (pKey	  	 != NULL) AjcSnPrintFW(pW->PermKey , AJCTSIZE(pW->PermKey ) - 32, L"%s"    , pKey);	// 32:後続キー名称の最大値
			else					  AjcSnPrintFW(pW->PermKey , AJCTSIZE(pW->PermKey ) - 32, L"Inp_%s", szid);
			//----- 戻り値＝ＯＫ -------------------------------------------------------------------------------//
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	数値編集状態の取得																							//
//																												//
//	引　数	：	hwnd	 - 数値入力コントロールのハンドル														//
//																												//
//	戻り値	：	TRUE  - 数値の編集中																			//
//				FALSE - 数値の編集中以外																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcIvGetEditState (HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->fBlkBusy;
		}
	}
	return rc;
}
//==============================================================================================================//
//	メインウインドのハンドル取得																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pBkWnd		- ウインド背景色を格納するバッファへのポインタ（不要時はNULL）						//
//																												//
//	戻り値	：	≠NULL : メインウインドのハンドル																//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT	HWND	WINAPI		AjcIvGetMainWindow(HWND hwnd, COLORREF *pBkGnd)
{
	HWND	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pBkGnd != NULL) {
				*pBkGnd = RGB(255, 255, 255);
			}
			rc = pW->hBack;
		}
	}
	return rc;
}

//==============================================================================================================//
//																												//
//	通知情報取得																								//
//																												//
//==============================================================================================================//
//	右クリック通知情報
AJCEXPORT	PAJCIVRCLK			WINAPI	AjcIvGetNtcRClk	(HWND hwnd)
{
	PAJCIVRCLK	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
		rc = &pW->NtcRClk;
	}
	return rc;
}
