﻿//**************************************************************************************************************//
//																												//
//	カスタムコントロール（数値入力）			共通定義														//
//																												//
//**************************************************************************************************************//

#define	IV_CTRLS		4
#define	IV_IDC_SLD	1000
#define	IV_IDC_TXT	1001
#define	IV_IDC_BTN	1002
#define	IV_IDC_SPN	1003

#define	IV_TID_BLINK		1

#define	IV_INST_ID			0x926FDC51


//--------------------------------------------------------------------------------------------------------------//
//	コントロールの情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HWND	hwnd;						//	ウインドハンドル
	int		x, cx;						//	表示Ｘ位置と幅
	WNDPROC	WndProc;					//	オリジナルのウインドプロシージャ
} IVCTRLINFO, *PIVCTRLINFO;

//--------------------------------------------------------------------------------------------------------------//
//	ウインドワーク																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			InstID;						//	インスタンス識別ＩＤ
	HWND		hBack;						//	バックウインドハンドル
	int			ww, wh;						//	ウインドの幅，高さ
	int			style;						//	ウインドスタイル
	int			y, cy;						//	コントロールのＹ位置と高さ
	BOOL		fDrawCtrls;					//	コントロール再描画フラグ
	BOOL		fFirstGetText;				//	最初のWM_GETTEXTを示すフラグ
	BOOL		fEnable;					//	コントロールの有効状態を示すフラグ
	double		Value;						//	現在の値
	BOOL		fPendingNtcReal;			//	実数値通知保留中フラグ
	BOOL		fPendingNtcInt;				//	整数値通知保留中フラグ
	//----- 値とプロパティ情報 ---------------------------------------------------------------------------------//
	UI			SldWidth;					//	スライダ設定範囲（０～SldWidth）
	UI			SldPgWid;					//	スライダ・ページサイズ設定値
	double		MinVal;						//	min/maxの小さい方の数
	double		MaxVal;						//	min/maxの大きい方の数
	double		ValWidth;					//	値の範囲（最大－最小）
	AJCIVPROP	prop;						//	プロパティ
	AJCIVPROP	SvProp;						//	プロパティ退避
	//----- 各コントロールの情報 -------------------------------------------------------------------------------//
	union {
		struct {IVCTRLINFO sld, txt, btn, spn;} s;
		IVCTRLINFO								arr[4];
	} ctrls;
	//----- ブリンク情報（テキスト入力中はブリンクする）--------------------------------------------------------//
	BOOL		fBlkBusy;					//	ブリンク中を示すフラグ
	BOOL		fBlkDraw;					//	ブリンク描画フラグ
	BOOL		fBlkOn;						//	ブリンク描画極性
	int			BlkSvTick;					//	経過時間算出用ベースタイマ
	WC			SvText[64];					//	数値テキスト退避
	//----- 色コード -------------------------------------------------------------------------------------------//
	COLORREF	RgbBorder;					//	ボーダー色
	COLORREF	RgbBlink;					//	ブリンク色
	HPEN		hPenBorder;					//	ボーダー描画ペン
	HPEN		hPenBlink;					//	ブリンク描画ペン
	//----- 右クリック通知情報 ---------------------------------------------------------------------------------//
	BOOL		fNtcRClk;					//	右クリック通知フラグ（TRUE:通知する，FALSE:通知しない）
	UI			MsgRBDown;					//	右ボタンダウン時の通知メッセージコード
	UI			MsgRBUp;					//	右ボタンアップ時の通知メッセージコード
	//----- ツールチップ情報 -----------------------------------------------------------------------------------//
	BOOL		fEnaDefTip;					//	デフォルトツールチップ許可／禁止
	BOOL		fSetDefTip;					//	デフォルトツールチップ設定済フラグ
	WCP			pToolTipTxt;				//	テキストボックスのツールヒントメッセージ

	BOOL		fShowAlways;				//	ツールヒント表示条件
	//----- 通知情報 -------------------------------------------------------------------------------------------//
	AJCIVRCLK	NtcRClk;					//	右クリック通知情報
	//----- 永続化用ワーク -------------------------------------------------------------------------------------//
	WC			PermSect[256];				//	永続化情報記録用セクション名
	WC			PermKey [256];				//	永続化情報記録用キーの接頭語
} WRKINPVAL, *PWRKINPVAL;

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
extern	ATOM	IvClassMain;
extern	ATOM	IvClassForMSIL;
extern	HFONT	IvhFontBtnFace;

//--------------------------------------------------------------------------------------------------------------//
//	グローバルサブ関数																							//
//--------------------------------------------------------------------------------------------------------------//
extern	WNDPROC		IvWndProcMain();
extern	WNDPROC		IvWndProcMSIL();
extern	BOOL		IvSetSubClass(PWRKINPVAL pW);

extern	VO		IvSetDefaultTipText(PWRKINPVAL pW);
extern	VO		IvClrDefaultTipText(PWRKINPVAL pW);

