﻿#include	"AjcInternal.h"
#include	"AjcCtrlInpValDef.h"
#include	"resource.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（数値入力）			ＭＳＩＬ(.NET Framework)対応処理								//
//																												//
//**************************************************************************************************************//
AJC_WNDPROC_DEF(MSIL);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
#define	IDC_PARENT	5000
#define	IDC_CTRL	5001

//----- ワーク形式 ---------------------------------------------------------------------------------------------//
typedef struct {
	HWND	hCtrl;			//	数値入力コントロールウインド
	VO (CALLBACK *cbNtcIntValue )(int	 value);
	VO (CALLBACK *cbNtcRealValue)(double value);
	VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl);
} WKMSIL, *PWKMSIL;
//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		IvWndProcMSIL()
{
	return AJC_WNDPROC_NAME(MSIL);
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	コントロールウインド生成																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HWND WINAPI AjcIvCreateForMSIL(HWND hOwner, VO (CALLBACK *cbNtcIntValue )(int    value),
													  VO (CALLBACK *cbNtcRealValue)(double value),
													  VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl))
{
	HWND		hBack = NULL;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk = NULL;
	RECT		rect;

	do {
		//----- 親ウインドハンドルチェック ---------------------------------------------------------------------//
		if (!IsWindow(hOwner)) break;
		//----- ワーク領域確保 ---------------------------------------------------------------------------------//
		if ((pWk = (PWKMSIL)AJCMEM(sizeof(WKMSIL))) == NULL) break;
		memset(pWk, 0, sizeof(WKMSIL));
		pWk->cbNtcIntValue	= cbNtcIntValue ;
		pWk->cbNtcRealValue = cbNtcRealValue;
		pWk->cbRClick		= cbRClick;
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hOwner, &rect);
		//----- バックウインド生成 -----------------------------------------------------------------------------//
		hBack = CreateWindow((WCP)IvClassForMSIL,			// window class name
								L"",						// window caption
								WS_CHILD,					// window style
								0,							// initial x position
								0,							// initial y position
								rect.right - rect.left,		// initial x size
								rect.bottom - rect.top,		// initial y size
								hOwner,						// parent window handle
								(HMENU)IDC_PARENT,			// window menu handle
								hDllInst,					// program instance handle
								(VOP)pWk);					// creation parameters
		if (hBack == NULL) break;
		//----- 戻り値（コントロールハンドル）設定 -------------------------------------------------------------//
		hCtrl = pWk->hCtrl;
		//----- チップコントロール対象ウインド設定 -------------------------------------------------------------//
		AJCTIPCTRL_SETHWNDA(hOwner, hCtrl);
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hBack, SW_SHOW);
	} while(0);

	//----- エラーならばリソース解放 ---------------------------------------------------------------------------//
	if (hBack == NULL) {
		if (pWk != NULL) free(pWk);
	}
	return hCtrl;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	親ウインドプロシージャ																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJC_WNDPROC(MSIL, WM_CREATE		)
{
	LRESULT		rc	  = -1;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = ((LPCREATESTRUCT)lParam)->lpCreateParams;
	PWRKINPVAL	pW;
	RECT		rect;

	do {
		//----- ワークポインタ退避 -----------------------------------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pWk);
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hwnd, &rect);
		//----- 数値入力ウインド生成 ---------------------------------------------------------------------------//
		hCtrl = CreateWindow(L"AjcCtrlInpVal",										// window class name
							L"",													// window caption
							WS_CHILD | WS_VISIBLE | AJCIVS_AUTOEDIT,				// style
							0,														// initial x position
							0,														// initial y position
							rect.right - rect.left,									// initial x size
							rect.bottom - rect.top,									// initial y size
							hwnd,													// parent window handle
							(HMENU)IDC_CTRL,										// window menu handle
							hDllInst,												// program instance handle
							NULL);													// creation parameters
		if (hCtrl == NULL) break;
		//----- 右ボタン操作通知設定 ---------------------------------------------------------------------------//
		AjcIvSetNtcRClk(hCtrl, TRUE, WM_RBUTTONDOWN, WM_RBUTTONUP);
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hCtrl, SW_SHOW);
		//----- コントロールのハンドル退避 ---------------------------------------------------------------------//
		pWk->hCtrl = hCtrl;
		//----- プロパティ値退避 -------------------------------------------------------------------------------//
		pW = (PWRKINPVAL)MAjcGetWindowLong(hCtrl, 0);
		memcpy(&pW->SvProp, &pW->prop, sizeof pW->SvProp);
		//----- 戻り値=正常 ------------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_DESTROY	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk != NULL) {
		if (pWk->hCtrl != NULL) {
			DestroyWindow(pWk->hCtrl);
			pWk->hCtrl = NULL;
		}
		free(pWk);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_SIZE		)
{
	PWKMSIL		pWk = (PWKMSIL	 )MAjcGetWindowLong(hwnd, 0);
	PWRKINPVAL	pW	= (PWRKINPVAL)MAjcGetWindowLong(pWk->hCtrl, 0);
	int			width  = LOWORD(lParam);
	int			height = HIWORD(lParam);
	LOGFONT		lf;
	HFONT		hFont = NULL;

	//----- 数値入力コントロールサイズ設定 -----------------------------------------------//
	SetWindowPos(pWk->hCtrl, NULL, 0, 0, width, height, SWP_NOMOVE);

	//----- 数値入力コントロールのフォント設定 -------------------------------------------//
	lf.lfHeight			= (height - 4) * 90 / 100;
	lf.lfStrikeOut		= 0;
	lf.lfWidth			= 0;	lf.lfCharSet		= 0;
	lf.lfEscapement		= 0;	lf.lfOutPrecision	= 0;
	lf.lfOrientation	= 0;	lf.lfClipPrecision	= 0;
	lf.lfWeight			= 0;	lf.lfQuality		= 0;
	lf.lfItalic			= 0;	lf.lfPitchAndFamily	= FIXED_PITCH;
	lf.lfUnderline		= 0;	wcscpy(lf.lfFaceName, L"Arial");

	if ((hFont = CreateFontIndirect(&lf)) != NULL) {
		SendMessage(pW->ctrls.s.txt.hwnd, WM_SETFONT, (LPARAM)hFont, TRUE);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_RBUTTONDOWN	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk->cbRClick != NULL) {
		pWk->cbRClick((int)LOWORD(lParam), (int)HIWORD(lParam), ((wParam & MK_SHIFT) != 0), ((wParam & MK_CONTROL) != 0));
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, IDC_CTRL		)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (LOWORD(wParam) == IDC_CTRL) {
		switch (HIWORD(wParam)) {
			case AJCIVN_INTVALUE:
				if (pWk->cbNtcIntValue != NULL) {
					pWk->cbNtcIntValue((int)lParam);
				}
				break;

			case AJCIVN_REALVALUE:
				if (pWk->cbNtcRealValue != NULL) {
					pWk->cbNtcRealValue(*((double *)lParam));
				}
				break;
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MSIL)
	AJC_WNDMAP_MSG(MSIL, WM_CREATE			)
	AJC_WNDMAP_MSG(MSIL, WM_DESTROY			)
	AJC_WNDMAP_MSG(MSIL, WM_SIZE			)
	AJC_WNDMAP_MSG(MSIL, WM_RBUTTONDOWN		)

	AJC_WNDMAP_CMD(MSIL, IDC_CTRL			)
AJC_WNDMAP_END
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	スタイルの設定／取得関数																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- スタイル取得マクロ -------------------------------------------------------------------------------------//
#define	MGET_STY(NAME)	AJCEXPORT BOOL WINAPI AjcIvGetSty_##NAME(HWND hwnd) {									\
	return (BOOL)((MAjcGetWindowLong(hwnd, GWL_STYLE) & AJCIVS_##NAME) != 0);									\
}
//----- スタイル設定マクロ -------------------------------------------------------------------------------------//
#define	MSET_STY(NAME)	AJCEXPORT VO WINAPI AjcIvSetSty_##NAME(HWND hwnd, BOOL f) {								\
	if (f) MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) |	AJCIVS_##NAME);				\
	else   MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) & ~AJCIVS_##NAME);				\
}

//----- フォーカスによる自動編集			(AJCIVS_AUTOEDIT) --------------------------------------------------//
MGET_STY(AUTOEDIT)
MSET_STY(AUTOEDIT)

//----- １６進表示							(AJCIVS_SHOWHEX) ---------------------------------------------------//
MGET_STY(SHOWHEX)
MSET_STY(SHOWHEX)

//----- 数値の入力時にブリンクしない		(AJCIVS_NOBLINK) ---------------------------------------------------//
MGET_STY(NOBLINK)
MSET_STY(NOBLINK)

//----- コントロール外枠非表示				(AJCTCS_NOBORDER) --------------------------------------------------//
MGET_STY(NOBORDER)
MSET_STY(NOBORDER)

//----- スライダ非表示						(AJCIVS_NOSLD) -----------------------------------------------------//
MGET_STY(NOSLD)
MSET_STY(NOSLD)

//----- ボタン非表示						(AJCIVS_NOBTN) -----------------------------------------------------//
MGET_STY(NOBTN)
MSET_STY(NOBTN)

//----- スピンボタン非表示					(AJCIVS_NOSPN) -----------------------------------------------------//
MGET_STY(NOSPN)
MSET_STY(NOSPN)

//----- 整数部を３桁毎にカンマで区切る		(AJCIVS_SEPARATE) --------------------------------------------------//
MGET_STY(SEPARATE)
MSET_STY(SEPARATE)

//----- 実数モード							(AJCIVS_REALMODE) --------------------------------------------------//
MGET_STY(REALMODE)
MSET_STY(REALMODE)


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	プロパティの設定／取得関数																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- プロパティ取得マクロ -----------------------------------------------------------------------------------//
#define	MGET_PROP(TYPE, NAME)		AJCEXPORT TYPE WINAPI AjcIvGetProp_##NAME(HWND hwnd) {						\
	AJCIVPROP	p;																								\
	SendMessage(hwnd, AJCIVM_GETPROP, (WPARAM)&p, 0);															\
	return p.NAME;																								\
}
//----- プロパティ設定マクロ -----------------------------------------------------------------------------------//
#define	MSET_PROP(TYPE, NAME)		AJCEXPORT VO WINAPI AjcIvSetProp_##NAME(HWND hwnd, TYPE n) {				\
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);													\
	pW->SvProp.NAME = n;																						\
	SendMessage(hwnd, AJCIVM_SETPROP, (WPARAM)&pW->SvProp, 0);													\
}
//----- 数値の最少値 			(min) --------------------------------------------------------------------------//
MGET_PROP(double, min)
MSET_PROP(double, min)

//----- 数値の最大値 			(max) --------------------------------------------------------------------------//
MGET_PROP(double, max)
MSET_PROP(double, max)

//----- 数値の最小単位			(SldUnit) ----------------------------------------------------------------------//
MGET_PROP(double, SldUnit)
MSET_PROP(double, SldUnit)

//----- スライダのページサイズ 	(SldPage) ----------------------------------------------------------------------//
MGET_PROP(double, SldPage)
MSET_PROP(double, SldPage)

//----- スピンボタンの増減値 	(SpnStep) ----------------------------------------------------------------------//
MGET_PROP(double, SpnStep)
MSET_PROP(double, SpnStep)

//----- テキストの桁数 			(TextLen) ----------------------------------------------------------------------//
MGET_PROP(UI, TextLen)
MSET_PROP(UI, TextLen)

//----- 小数部の桁数			(Precision) --------------------------------------------------------------------//
MGET_PROP(SI, Precision)
MSET_PROP(SI, Precision)

//----- 16進数の桁数			(HexLen   ) --------------------------------------------------------------------//
MGET_PROP(SI, HexLen)
MSET_PROP(SI, HexLen)

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcIvSetProp_WndSize(HWND hwnd, UI width, UI height)
{
	HWND		hParent;

	if (hParent = GetParent(hwnd)) {
		SetWindowPos(hParent , NULL, 0, 0, width, height, SWP_NOMOVE);
	}
}
//----- コントロール外枠の表示色取得 ---------------------------------------------------------------------------//
AJCEXPORT int WINAPI AjcIvGetProp_BorderColor(HWND hwnd)
{
	return (int)SendMessage(hwnd, AJCIVM_GETBORDERCOLOR, 0, 0);
}
//----- コントロール外枠の表示色設定 ---------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcIvSetProp_BorderColor(HWND hwnd, int rgb)
{
	SendMessage(hwnd, AJCIVM_SETBORDERCOLOR, rgb, 0);
}


//----- 整数値取得 ---------------------------------------------------------------------------------------------//
AJCEXPORT int WINAPI	AjcIvGetIntValue	(HWND hwnd)
{
	return (int)SendMessage(hwnd, AJCIVM_I_GETVALUE, 0, 0);
}
//----- 整数値設定 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcIvSetIntValue		(HWND hwnd, int value, BOOL fNtc)
{
	SendMessage(hwnd, AJCIVM_I_SETVALUE, (SX)value, fNtc);
}
//----- 実数値取得 ---------------------------------------------------------------------------------------------//
AJCEXPORT double WINAPI	AjcIvGetRealValue	(HWND hwnd)
{
	double	dat;
	SendMessage(hwnd, AJCIVM_R_GETVALUE, (WPARAM)&dat, 0);
	return dat;
}
//----- 実数値設定 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcIvSetRealValue		(HWND hwnd, double value, BOOL fNtc)
{
	SendMessage(hwnd, AJCIVM_R_SETVALUE, (WPARAM)&value, fNtc);
}
//----- テキストの取得 -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcIvGetText		(HWND hwnd, WCP pText, int lText)
{
	GetWindowTextW(hwnd, pText, lText);
}
//----- テキストの設定 -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcIvSetText		(HWND hwnd, C_WCP pText)
{
	SetWindowTextW(hwnd, pText);
}
//----- ツールチップ文字列の設定 -------------------------------------------------------------------------------//
AJCEXPORT	BOOL WINAPI	AjcIvSetTipTextForMSIL	(HWND hwnd, C_WCP pTxt)
{
	BOOL	rc = FALSE;
	UI		stl;
	WCP		pTmp;

	if (pTxt == NULL) pTxt = L"";

	stl = (UI)wcslen(pTxt);
	if (pTmp = (WCP)AJCMEM((stl + 1) * 2)) {
		AjcCLangStrToBinW(pTxt, pTmp, stl + 1);
		SendMessage(hwnd, AJCIVM_SETTIPTEXTW, (WPARAM)pTmp, 0);
		free(pTmp);
	}
	return rc;
}
//----- ツールチップ文字列の取得 -------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcIvGetTipTextForMSIL	(HWND hwnd, WCP pBuf, int lBuf)
{
	UI		rc = 0;
	WCP		pTmp;

	if (pTmp = (WCP)AJCMEM(lBuf * 2)) {
		SendMessage(hwnd, AJCIVM_GETTIPTEXTW, (WPARAM)pTmp, lBuf);
		rc = AjcBinToCLangStrW(pTmp, pBuf, lBuf);
		free(pTmp);
	}
	return rc;
}

//----- 少数部桁数と１６進数桁数 取得用ダイアログボックス ------------------------------------------------------//
//	１０進数の０～１桁：少数部桁数（負数の場合は、有効桁数）
//	　　　　　２～３桁：１６進数の桁数

AJC_DLGPROC_DEF(GetPrec);

AJCEXPORT int WINAPI AjcIvGetProp_PrecisionDlg(int value)
{
	int		rc = value;

	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_INP_PREC_AND_HEXLEN), NULL, AJC_DLGPROC_NAME(GetPrec), (LPARAM)&rc);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	実数精度と１６進数桁数 取得ダイアログプロシージャ 															//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(GetPrec, WM_INITDIALOG )
{
	int		value = *((int*)lParam);
	int		prec, hlen;

	//	戻り値へのポインタ設定
	SetProp(hDlg, L"rc", (HANDLE)lParam);

	//	精度種別表示
	if (value >= 0) {
		AjcSetDlgItemChk(hDlg, IDC_RBT_POINT	 , TRUE);
	}
	else {
		AjcSetDlgItemChk(hDlg, IDC_RBT_SIGNFICANT, TRUE);
		value *= -1;
	}

	//	精度と１６進数桁数の分離
	prec  = value % 100;
	hlen  = value / 100;
	hlen %= 100;

	//	値表示
	AjcSetDlgItemUInt(hDlg, IDC_INP_PREC, prec);
	AjcSetDlgItemUInt(hDlg, IDC_INP_HLEN, hlen);

	return TRUE;
}
//----- ＯＫ ---------------------------------------------------------------------------------------------------//
AJC_DLGPROC(GetPrec, IDOK			 )
{
	int		*pRc = (int*)GetProp(hDlg, L"rc");
	int		value, prec, hlen;

	prec = AjcGetDlgItemUInt(hDlg, IDC_INP_PREC);
	hlen = AjcGetDlgItemUInt(hDlg, IDC_INP_HLEN);

	//	合成値生成
	value = (hlen * 100) + prec;
	if (AjcGetDlgItemChk(hDlg, IDC_RBT_SIGNFICANT)) {
		value *= -1;
	}

	//	値を呼び出し元の戻り値「rc」に設定
	*pRc = value;

	RemoveProp(hDlg, L"rc");
	EndDialog(hDlg, IDOK);
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(GetPrec, IDCANCEL		)
{
	RemoveProp(hDlg, L"rc");
	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(GetPrec)
	AJC_DLGMAP_MSG(GetPrec, WM_INITDIALOG	)
	AJC_DLGMAP_CMD(GetPrec, IDOK			)
	AJC_DLGMAP_CMD(GetPrec, IDCANCEL		)
AJC_DLGMAP_END
