﻿#include	"AjcInternal.h"
#include	"AjcCtrlInpValDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（数値入力）			サブクラスメインウインド										//
//																												//
//**************************************************************************************************************//
AJC_WNDPROC_DEF(SubProc);

//==============================================================================================================//
//																												//
//	コントロールのサブクラス化																					//
//																												//
//==============================================================================================================//
BOOL	IvSetSubClass(PWRKINPVAL pW)
{
	BOOL	rc = FALSE;
	do {
		if (MAjcMmpSetSubclass(SubProc, pW->ctrls.s.sld.hwnd) == NULL) break;
		if (MAjcMmpSetSubclass(SubProc, pW->ctrls.s.txt.hwnd) == NULL) break;
		if (MAjcMmpSetSubclass(SubProc, pW->ctrls.s.btn.hwnd) == NULL) break;
		if (MAjcMmpSetSubclass(SubProc, pW->ctrls.s.spn.hwnd) == NULL) break;
		rc = TRUE;
	} while (0);
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロール群のサブクラスウインドプロシージャ																//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_LBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SubProc, WM_LBUTTONDOWN		)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);
	LRESULT		rc=0;

	//	チップテキストコントロール用に バックウインドへ WM_LBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	//	EDITコントロール？
	if (hwnd == pW->ctrls.s.txt.hwnd) {
		//	自動編集モードならば？
		if (pW->style & AJCIVS_AUTOEDIT) {
			//	テキスト非編集中？
			if (!pW->fBlkBusy) {
				//	「...」ボタン押下し、テキスト編集中へ移行
				SendMessage(pW->hBack, WM_COMMAND, MAKELONG(IV_IDC_BTN, BN_CLICKED), 0);
			}
		}
		//	オリジナルウインドプロシージャ実行（テキストボックスクリック）
		rc = MAjcMmpCallOrgWndProc(SubProc);
	}
	//	スライダ／スピンボタン？
	else if (hwnd == pW->ctrls.s.sld.hwnd || hwnd == pW->ctrls.s.spn.hwnd) {
		//	テキスト編集中？
		if (pW->fBlkBusy) {
			//	「ok」ボタン押下し、入力を確定する
			SendMessage(pW->hBack, WM_COMMAND, MAKELONG(IV_IDC_BTN, BN_CLICKED), 0);
		}
		//	オリジナルウインドプロシージャ実行（スライダ／スピンによる値増減）
		rc = MAjcMmpCallOrgWndProc(SubProc);
	}
	//	「...」or「ok」ボタン押下・・
	else {
		//	オリジナルウインドプロシージャ実行（ボタン押下）
		rc = MAjcMmpCallOrgWndProc(SubProc);
	}

	return rc;
}
//----- WM_KILLFOCUS -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubProc, WM_KILLFOCUS			)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);

	//	EDITコントロールのフォーカス喪失時は、ＯＫボタン押下実行
	if (hwnd == pW->ctrls.s.txt.hwnd) {
		//	チップコントロールにフォーカウスを奪われた場合は、ＯＫボタンを押さないようにするため
		//	フォーカスが戻るのを20ms待つ
		SetTimer(hwnd, 123, 20, NULL);
	}

	return MAjcMmpCallOrgWndProc(SubProc);
}
//----- WM_SETFOCUS --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubProc, WM_SETFOCUS			)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);

	//	チップコントロールにフォーカウスを奪われた場合は、すぐにフォーカスが戻り、編集を継続する
	if (hwnd == pW->ctrls.s.txt.hwnd) {
		KillTimer(hwnd, 123);
	}
	return MAjcMmpCallOrgWndProc(SubProc);
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubProc, WM_TIMER				)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);

	//	EDITコントロールのフォーカス喪失時時の遅延後、ＯＫボタン押下実行
	if (hwnd == pW->ctrls.s.txt.hwnd) {
		if (wParam == 123) {
			KillTimer(hwnd, 123);
		//	if (pW->style & AJCIVS_AUTOEDIT) {
				if (pW->fBlkBusy) {
					if (GetFocus() != pW->ctrls.s.btn.hwnd) {
						SendMessage(pW->hBack, WM_COMMAND, MAKELONG(IV_IDC_BTN, BN_CLICKED), 0);
					}
				}
		//	}
		}
	}
	return MAjcMmpCallOrgWndProc(SubProc);
}
//----- WM_KEYDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SubProc, WM_KEYDOWN			)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);

	//	EDITコントロール編集中は、CTRLキーで入力を確定（ＯＫボタン押下実行）
	if (hwnd == pW->ctrls.s.txt.hwnd) {
		//	SPACEキー押下
		if (wParam == VK_SPACE) {
			//	数値編集中ならば、入力確定
			if (pW->fBlkBusy) {
				SendMessage(pW->hBack, WM_COMMAND, MAKELONG(IV_IDC_BTN, BN_CLICKED), 0);
			}
		}
		else if (wParam == VK_ESCAPE) {
			//	数値編集中ならば、入力テキストを元に戻す
			if (pW->fBlkBusy) {
				AjcSetCtrlStr(pW->ctrls.s.txt.hwnd, pW->SvText);
				SendMessage(pW->hBack, WM_COMMAND, MAKELONG(IV_IDC_BTN, BN_CLICKED), 0);
			}
		}
	}
	return MAjcMmpCallOrgWndProc(SubProc);
}
//----- WM_RBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SubProc, WM_RBUTTONDOWN			)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);

	//	チップテキストコントロール用＆右クリック通知用に バックウインドへ WM_RBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;	//	右クリックはインターセプトする
}
//----- WM_RBUTTONUP -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubProc, WM_RBUTTONUP			)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);

	//	チップテキストコントロール用＆右クリック通知用に バックウインドへ WM_RBUTTONUP を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return 0;	//	右クリックはインターセプトする
}
//----- WM_MOUSEMOVE -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubProc, WM_MOUSEMOVE			)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);

	//	チップテキストコントロール用に バックウインドへ WM_MOUSEMOVE を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return MAjcMmpCallOrgWndProc(SubProc);
}
//----- WM_MBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SubProc, WM_MBUTTONDOWN		)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);

	//	チップテキストコントロール用に バックウインドへ WM_MBUTTONDOWN を通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return MAjcMmpCallOrgWndProc(SubProc);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SubProc)
	AJC_WNDMAP_MSG(SubProc, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(SubProc, WM_KILLFOCUS	)
	AJC_WNDMAP_MSG(SubProc, WM_SETFOCUS		)
	AJC_WNDMAP_MSG(SubProc, WM_TIMER		)
	AJC_WNDMAP_MSG(SubProc, WM_KEYDOWN		)
	AJC_WNDMAP_MSG(SubProc, WM_RBUTTONDOWN	)
	AJC_WNDMAP_MSG(SubProc, WM_RBUTTONUP	)
	AJC_WNDMAP_MSG(SubProc, WM_MOUSEMOVE	)
	AJC_WNDMAP_MSG(SubProc, WM_MBUTTONDOWN	)
AJC_WNDMAP_END
