﻿#include	"AjcInternal.h"
#include	"AjcCtrlInpValDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（数値入力）			メインウインド													//
//																												//
//**************************************************************************************************************//

#define	IS_MY_INST(P)	(P != NULL && P->InstID == IV_INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Main);
static	VO		SetPropByText	  (PWRKINPVAL pW, WCP pTxt, PAJCIVPROP pProp);
static	VO		SetCtrlProp		  (PWRKINPVAL pW, PCAJCIVPROP pProp);
static	VO		BlinkStart		  (PWRKINPVAL pW);
static	VO		BlinkEnd		  (PWRKINPVAL pW);
static	VO		BlinkCancel		  (PWRKINPVAL pW);
static	VO		SetValueText	  (PWRKINPVAL pW, double val);
static	UI		MakeValueText	  (PWRKINPVAL pW, WCP pBuf, UI lBuf);
static	VO		SetControlPosition(PWRKINPVAL pW);
static	double	SldPosToValue	  (PWRKINPVAL pW, int pos);
static	int		ValueToSldPos	  (PWRKINPVAL pW, double val);
static	VO		NotifyValue		  (PWRKINPVAL pW);
static	VO		EnableCtrls		  (PWRKINPVAL pW, BOOL fEnable);
static	VO		SetCurrentValue	  (PWRKINPVAL pW, double NewVal);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		IvWndProcMain()
{
	return AJC_WNDPROC_NAME(Main);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メインウインドプロシージャ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE		)
{
	LRESULT			rc = -1;
	PWRKINPVAL		pW = NULL;
	AJCIVPROP		prop;
	HFONT			hFont;
	WC				PropTxt[256];

	do {
		//----- ワーク初期化 -----------------------------------------------------------------------------------//
		if ((pW = (PWRKINPVAL)AJCMEM(sizeof(WRKINPVAL))) == NULL) break;
		memset(pW, 0, sizeof(WRKINPVAL));

		//----- インスタンス識別ＩＤ設定 -----------------------------------------------------------------------//
		pW->InstID = IV_INST_ID;

		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);

		//----- ウインドキャプション（文字列パラメタ）取得 -----------------------------------------------------//
		pW->fFirstGetText = TRUE;
		GetWindowText(hwnd, PropTxt, AJCTSIZE(PropTxt));

		//----- ウインドハンドル／スタイル設定 -----------------------------------------------------------------//
		pW->hBack  = hwnd;
		pW->style  = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);

		//----- デフォルトプロパティ設定 -----------------------------------------------------------------------//
		prop.min	   = 0.0;
		prop.max	   = 100.0;
		prop.SldUnit   = 1.0;
		prop.SldPage   = 10;
		prop.SpnStep   = 1.0;
		prop.TextLen   = 6;
		prop.Precision = 3;
		prop.HexLen    = 0;

		//----- 描画色情報初期化 -------------------------------------------------------------------------------//
		pW->RgbBorder  = RGB(  0,	0,	 0);
		pW->RgbBlink   = RGB(255,	0, 255);
		if ((pW->hPenBorder = CreatePen(PS_SOLID, 1, pW->RgbBorder			  )) == NULL) break;
		if ((pW->hPenBlink	= CreatePen(PS_SOLID, 1, pW->RgbBlink			  )) == NULL) break;

		//----- スライダ・コントロール生成 ---------------------------------------------------------------------//
		pW->ctrls.s.sld.hwnd = CreateWindowEx(0, TRACKBAR_CLASS,	NULL,
											  WS_CHILD | WS_VISIBLE | WS_TABSTOP | TBS_HORZ | TBS_NOTICKS | TBS_BOTH,
											  0, 0, 0, 0, hwnd, (HMENU)IV_IDC_SLD, hDllInst, NULL);
		if (pW->ctrls.s.sld.hwnd == NULL) break;
		AJCTIP_SETFRIENDA(pW->ctrls.s.sld.hwnd);
		pW->ctrls.s.sld.WndProc = (WNDPROC)MAjcGetWindowLong(pW->ctrls.s.sld.hwnd, GWLP_WNDPROC);

		//----- エディット・コントロール生成 -------------------------------------------------------------------//
		pW->ctrls.s.txt.hwnd = CreateWindowEx(WS_EX_CLIENTEDGE, L"EDIT", NULL,
											  WS_CHILD | WS_VISIBLE | WS_TABSTOP | ES_CENTER | ES_READONLY,
											  0, 0, 0, 0, hwnd, (HMENU)IV_IDC_TXT, hDllInst, NULL);
		if (pW->ctrls.s.txt.hwnd == NULL) break;
		AJCTIP_SETFRIENDA(pW->ctrls.s.txt.hwnd);
		pW->ctrls.s.txt.WndProc = (WNDPROC)MAjcGetWindowLong(pW->ctrls.s.txt.hwnd, GWLP_WNDPROC);

		//----- ボタン・コントロール生成 -----------------------------------------------------------------------//
		pW->ctrls.s.btn.hwnd = CreateWindowEx(0, L"BUTTON",	NULL,
											  WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_PUSHBUTTON | BS_VCENTER | BS_CENTER,
											  0, 0, 0, 0, hwnd, (HMENU)IV_IDC_BTN, hDllInst, NULL);
		if (pW->ctrls.s.btn.hwnd == NULL) break;
		AJCTIP_SETFRIENDA(pW->ctrls.s.btn.hwnd);
		pW->ctrls.s.btn.WndProc = (WNDPROC)MAjcGetWindowLong(pW->ctrls.s.btn.hwnd, GWLP_WNDPROC);

		//----- スピン・コントロール生成 -----------------------------------------------------------------------//
		pW->ctrls.s.spn.hwnd = CreateUpDownControl(WS_CHILD | WS_BORDER | WS_VISIBLE | WS_TABSTOP | UDS_ARROWKEYS,
												   0, 0, 0, 0, hwnd, IV_IDC_SPN, hDllInst, NULL, 0x7FFFFFFF, 0x80000000, 0);
		if (pW->ctrls.s.spn.hwnd == NULL) break;
		AJCTIP_SETFRIENDA(pW->ctrls.s.spn.hwnd);
		pW->ctrls.s.spn.WndProc = (WNDPROC)MAjcGetWindowLong(pW->ctrls.s.spn.hwnd, GWLP_WNDPROC);

		//----- テキストボックスに親ウインドと同一フォント設定 -------------------------------------------------//
		hFont = (HFONT)SendMessage(GetParent(pW->hBack), WM_GETFONT, 0, 0);
		SendMessage(pW->ctrls.s.txt.hwnd, WM_SETFONT, (WPARAM)hFont, TRUE);

		//----- ボタンフェースとフォント設定--------------------------------------------------------------------//
		SendMessage	 (pW->ctrls.s.btn.hwnd, WM_SETFONT, (WPARAM)IvhFontBtnFace, TRUE);
		SetWindowText(pW->ctrls.s.btn.hwnd, L"...");

		//----- プロパティ設定 ---------------------------------------------------------------------------------//
		SetPropByText(pW, PropTxt, &prop);
		SetCtrlProp	 (pW, &prop);

		//----- テキスト初期値表示 -----------------------------------------------------------------------------//
		SetValueText(pW, pW->Value);
		AjcSetCtrlSldPos(pW->ctrls.s.sld.hwnd, ValueToSldPos(pW, pW->Value));

		//----- コントロール配置 -------------------------------------------------------------------------------//
		SetControlPosition(pW);

		//----- コントロールの有効状態設定 ---------------------------------------------------------------------//
		EnableCtrls(pW, pW->fEnable = !(pW->style & WS_DISABLED));

		//----- コントロールをサブクラス化 ---------------------------------------------------------------------//
		IvSetSubClass(pW);

		//----- デフォルトツールチップテキスト設定 -------------------------------------------------------------//
		if (pW->style & AJCIVS_DEFTIP) {
			IvSetDefaultTipText(pW);
		}

		//----- チップテキスト表示条件 -------------------------------------------------------------------------//
		pW->fShowAlways = TRUE;

		//----- ツールチップ・サブクラス化通知設定 -------------------------------------------------------------//
		if (!AjcTipTextSetNtcSubclass(pW->hBack, hwnd, AJCIVN_TIP_SUBCLASS, 0)) break;

		//----- 戻り値＝正常 -----------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	if (rc == -1) {
		if (pW != NULL) {
			int		i;
			for (i=0; i<IV_CTRLS; i++) {
				if (pW->ctrls.arr[i].hwnd) DestroyWindow(pW->ctrls.s.sld.hwnd);
			}
			if (pW->hPenBorder != NULL) DeleteObject(pW->hPenBorder);
			if (pW->hPenBlink  != NULL) DeleteObject(pW->hPenBlink );
			free(pW);
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	int			i;
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);

	//	子コントロール群クローズ
	for (i=0; i<IV_CTRLS; i++) {
		if (pW->ctrls.arr[i].hwnd) DestroyWindow(pW->ctrls.s.sld.hwnd);
	}
	//	チップテキスト解放
	if (pW->pToolTipTxt != NULL) {
		free(pW->pToolTipTxt);
		pW->pToolTipTxt = NULL;
	}
	//	ツールチップ・サブクラス化通知解除
	AjcTipTextClrNtcSubclass(pW->hBack);
	//	インスタンスワーク解放
	free(pW);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);

	pW->fDrawCtrls = TRUE;
	InvalidateRect(hwnd, NULL, TRUE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	int			tc = GetTickCount() / 1000;

	if (pW->BlkSvTick != tc) {
		pW->BlkSvTick = tc;
		pW->fBlkDraw = TRUE;
		pW->fBlkOn	 = (tc & 1);
		InvalidateRect(hwnd, NULL, FALSE);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_HSCROLL	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	int			pos;

	if (wParam != SB_ENDSCROLL) {
		BlinkCancel(pW);
		pos = AjcGetCtrlSldPos(pW->ctrls.s.sld.hwnd);
		SetCurrentValue(pW, SldPosToValue(pW, pos));
		SetValueText(pW, pW->Value);	//	テキスト表示
		NotifyValue(pW);				//	通知
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_PAINT		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;
	HPEN		hPen  = NULL;
	HBRUSH		hBrush= NULL;

	hdc = BeginPaint(hwnd, &ps);

	hBrush = (HBRUSH)SelectObject(hdc, (HBRUSH)GetStockObject(NULL_BRUSH));

	//----- コントロール配置 ----------------//
	if (pW->fDrawCtrls) {
		pW->fDrawCtrls = FALSE;
		SetControlPosition(pW);
	}
	//----- 外枠表示 ------------------------//
	if (!(pW->style & AJCIVS_NOBORDER)) {
		if (pW->fEnable) hPen = (HPEN)SelectObject(hdc, pW->hPenBorder);
		else			 hPen = (HPEN)SelectObject(hdc, hPenGrayText);
	}
	else {
		hPen = (HPEN)SelectObject(hdc, hPenBtnFace);
	}
	RoundRect(hdc, 0, 0, pW->ww, pW->wh, 6, 6);
	hPen = (HPEN)SelectObject(hdc, hPen);
	//----- ブリンク表示 --------------------//
	if (pW->fBlkDraw) {
		int		x1 = pW->ctrls.s.txt.x - 1;
		int		y1 = pW->y - 1;
		int		x2 = pW->ctrls.s.btn.x + pW->ctrls.s.btn.cx + 1;
		int		y2 = pW->y + pW->cy + 1;
		if (pW->fBlkOn && !(pW->style & AJCIVS_NOBLINK)) hPen = (HPEN)SelectObject(hdc, pW->hPenBlink  );
		else											 hPen = (HPEN)SelectObject(hdc,	  hPenBtnFace);
		Rectangle(hdc, x1, y1, x2, y2);
		hPen = (HPEN)SelectObject(hdc, hPen);
		pW->fBlkDraw = FALSE;
	}
	if (hPen   != NULL) SelectObject(hdc, hPen	);
	if (hBrush != NULL) SelectObject(hdc, hBrush);
	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_GETTEXTLENGTH)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;
	WC			tmp[512];

	if (pW->fFirstGetText) {
		rc = AjcDefWindowProc(hwnd, msg, wParam, lParam);
	}
	else {
		rc = MakeValueText(pW, tmp, AJCTSIZE(tmp));
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_GETTEXT	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	if (pW->fFirstGetText) {
		pW->fFirstGetText = FALSE;
		rc = AjcDefWindowProc(hwnd, msg, wParam, lParam);
	}
	else {
		rc = MakeValueText(pW, (WCP)lParam, (UI)wParam);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SETTEXT	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	WCP			p, pTmp;
	int			pos;

	if ((pTmp = (WCP)AjcTAlloc((UI)wcslen((WCP)lParam) + 1)) != NULL) {
		BlinkCancel(pW);
		//----- 値設定 -----------------------//
		wcscpy(pTmp, (WCP)lParam);
		AjcStrRmvSepChar(pTmp);
		for (p=pTmp; MAjcIsBlankW(*p); p++);
		if (*p==L'0' && towupper(*(p+ 1)) == L'X')	SetCurrentValue(pW, AjcHexToUI(p));
		else										SetCurrentValue(pW, _wtof(pTmp));
		//----- コントロールへ値表示 ---------//
		SetValueText(pW, pW->Value);
		//----- スライダ位置設定 -------------//
		pos = ValueToSldPos(pW, pW->Value);
		AjcSetCtrlSldPos(pW->ctrls.s.sld.hwnd, pos);
		//----- 作業ワーク開放 ---------------//
		free(pTmp);
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_GETFONT	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	HFONT		hFont;
	
	hFont = (HFONT)SendMessage(pW->ctrls.s.txt.hwnd, WM_GETFONT, 0, 0);
	
	return (LRESULT)hFont;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SETFONT	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);

	SendMessage(pW->ctrls.s.txt.hwnd, WM_SETFONT, wParam, lParam);

	pW->fDrawCtrls = TRUE;
	InvalidateRect(hwnd, NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_STYLECHANGED)
{
	PWRKINPVAL		pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LPSTYLESTRUCT	p = (LPSTYLESTRUCT)lParam;
	int				sty;
	AJCIVPROP		prop;

	if (wParam == GWL_STYLE) {
		//----- 新スタイル値設定 --------------------------------//
		pW->style		= p->styleNew;
		//----- 整数／実数モード反映の為、プロパティ再設定 ------//
		memcpy(&prop, &pW->prop, sizeof prop);
		SetCtrlProp(pW, &prop);
		//----- 値を表示 ----------------------------------------//
		SetValueText(pW, pW->Value);
		//----- テキストアライン設定 ----------------------------//
		sty = (int)MAjcGetWindowLong(pW->ctrls.s.txt.hwnd, GWL_STYLE) & ~(ES_CENTER | ES_LEFT | ES_RIGHT);
		switch (pW->style & AJCIVS_ALIGN) {
			case AJCIVS_CENTER:	MAjcSetWindowLong(pW->ctrls.s.txt.hwnd, GWL_STYLE, sty | ES_CENTER); break;
			case AJCIVS_LEFT:	MAjcSetWindowLong(pW->ctrls.s.txt.hwnd, GWL_STYLE, sty | ES_LEFT  ); break;
			case AJCIVS_RIGHT:	MAjcSetWindowLong(pW->ctrls.s.txt.hwnd, GWL_STYLE, sty | ES_RIGHT ); break;
		}
		//----- コントロール再配置 ------------------------------//
		pW->fDrawCtrls	= TRUE;
		InvalidateRect(hwnd, NULL, FALSE);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_ENABLE)
{
	PWRKINPVAL		pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	EnableCtrls(pW, pW->fEnable = (BOOL)wParam);
	InvalidateRect(hwnd, NULL, FALSE);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_RBUTTONDOWN)
{
	PWRKINPVAL		pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);

	if (pW->fNtcRClk) {
		if (pW->MsgRBDown != 0) {
			pW->NtcRClk.x		= (SW)LOWORD(lParam);
			pW->NtcRClk.y		= (SW)HIWORD(lParam);
			pW->NtcRClk.fShift	= ((wParam & MK_SHIFT  ) != 0);
			pW->NtcRClk.fCtrl	= ((wParam & MK_CONTROL) != 0);
			SendMessage(GetParent(hwnd), pW->MsgRBDown, wParam, lParam);
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_RBUTTONUP)
{
	PWRKINPVAL		pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);

	if (pW->fNtcRClk) {
		if (pW->MsgRBUp != 0) {
			SendMessage(GetParent(hwnd), pW->MsgRBUp, wParam, lParam);
		}
	}
	else {
		pW->NtcRClk.x		= (SW)LOWORD(lParam);
		pW->NtcRClk.y		= (SW)HIWORD(lParam);
		pW->NtcRClk.fShift	= ((wParam & MK_SHIFT  ) != 0);
		pW->NtcRClk.fCtrl	= ((wParam & MK_CONTROL) != 0);
		SendMessage(GetParent(hwnd), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCIVN_RCLICK),
						fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)&pW->NtcRClk);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, IV_IDC_TXT	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, IV_IDC_BTN	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	double		SvVal = pW->Value;

	if (HIWORD(wParam) == BN_CLICKED) {
		if (!pW->fBlkBusy) {
			//	数値テキスト退避
			memset(pW->SvText, 0, AJCTSIZE(pW->SvText));
			AjcGetCtrlStr(pW->ctrls.s.txt.hwnd, pW->SvText, AJCTSIZE(pW->SvText) - 1);
			//	数値入力モードへ
			BlinkStart(pW);
		}
		else {
			//	数値入力確定
			BlinkEnd(pW);
			//	通知
			NotifyValue(pW);
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, IV_IDC_SPN	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LPNMUPDOWN	pUd = (LPNMUPDOWN)lParam;
	int			pos;

	if (pUd->hdr.code == UDN_DELTAPOS) {
		//----- ブリンク中止 ---------------------//
		BlinkCancel(pW);
		//----- 値更新 ---------------------------//
		SetCurrentValue(pW, pW->Value + (pUd->iDelta * pW->prop.SpnStep));
		//----- コントロールへ値表示 -------------//
		SetValueText(pW, pW->Value);
		//----- スライダ位置設定 -----------------//
		pos = ValueToSldPos(pW, pW->Value);
		AjcSetCtrlSldPos(pW->ctrls.s.sld.hwnd, pos);
		//----- 値通知 ---------------------------//
		NotifyValue(pW);
	}
	
	return TRUE;	// スピンボタン位置の変更を禁止
}
//----- 書式設定（テキスト長，小数部の桁数）--------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_SETTEXTFORMAT		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW)) {
		//----- プロパティ値設定 ---------------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.TextLen   = (UI)wParam;
		prop.Precision = (SW)lParam;
		//----- プロパティ更新処理 -------------------//
		SetCtrlProp(pW, &prop);
		//----- 再描画／再配置 -----------------------//
		pW->fDrawCtrls = TRUE;
		InvalidateRect(hwnd, NULL, TRUE);
		rc = TRUE;
	}
	return rc;
}
//----- プロパティ取得（PAJCIVPROP，－）------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETPROP			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;

	if (IS_MY_INST(pW) && wParam != 0) {
		memcpy((VOP)wParam, &pW->prop, sizeof(AJCIVPROP));
		rc = TRUE;
	}
	return rc;
}
//----- プロパティ設定（PAJCIVPROP，－）------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_SETPROP			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;

	if (IS_MY_INST(pW) && wParam != 0) {
		//----- プロパティ設定 ---------------//
		SetCtrlProp(pW, (PAJCIVPROP)wParam);
		//----- コントロールへ値表示 ---------//
		SetValueText(pW, pW->Value);
		//----- スライダ位置設定 -------------//
		AjcSetCtrlSldPos(pW->ctrls.s.sld.hwnd, ValueToSldPos(pW, pW->Value));
		//----- 再描画／再配置 -------------------//
		pW->fDrawCtrls = TRUE;
		InvalidateRect(hwnd, NULL, TRUE);
		rc = TRUE;
	}
	return rc;
}
//----- ボーダー色取得（－，－）--------------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETBORDERCOLOR		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	COLORREF	rc = -1;

	if (IS_MY_INST(pW)) {
		rc = pW->RgbBorder;
	}
	return rc;
}
//----- ボーダー色設定（色コード，－）--------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_SETBORDERCOLOR		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	HPEN		hPen;

	if (IS_MY_INST(pW)) {
		if (hPen = CreatePen(PS_SOLID, 1, (COLORREF)wParam)) {
			if (pW->hPenBorder != NULL) DeleteObject(pW->hPenBorder);
			pW->RgbBorder  = (COLORREF)wParam;
			pW->hPenBorder = hPen;
			InvalidateRect(hwnd, NULL, FALSE);
			rc = TRUE;
		}
	}
	return rc;
}
//----- ブリンク色取得（－，－）--------------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETBLINKCOLOR		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	COLORREF	rc = -1;

	if (IS_MY_INST(pW)) {
		rc = pW->RgbBlink;
	}
	return rc;
}
//----- ブリンク色設定（色コード，－）--------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_SETBLINKCOLOR		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	HPEN		hPen;

	if (IS_MY_INST(pW)) {
		if (hPen = CreatePen(PS_SOLID, 1, (COLORREF)wParam)) {
			if (pW->hPenBlink != NULL) DeleteObject(pW->hPenBlink);
			pW->RgbBlink  = (COLORREF)wParam;
			pW->hPenBlink = hPen;
			InvalidateRect(hwnd, NULL, FALSE);
			rc = TRUE;
		}
	}
	return rc;
}
//----- スライダハンドル取得（－，－）--------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETSLDHANDLE		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	HWND		rc = NULL;

	if (IS_MY_INST(pW)) {
		rc = pW->ctrls.s.sld.hwnd;
	}
	return (LRESULT)rc;
}
//----- テキストハンドル取得（－，－）--------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETTXTHANDLE		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	return (LRESULT)pW->ctrls.s.txt.hwnd;
}
//----- ボタンハンドル取得（－，－）----------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETBTNHANDLE		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	HWND		rc = NULL;

	if (IS_MY_INST(pW)) {
		rc = pW->ctrls.s.btn.hwnd;
	}
	return (LRESULT)rc;
}
//----- スピンハンドル取得（－，－）----------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETSPNHANDLE		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	HWND		rc = NULL;

	if (IS_MY_INST(pW)) {
		rc = pW->ctrls.s.spn.hwnd;
	}
	return (LRESULT)rc;
}
//----- テキスト長取得（－，－）--------------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETTXTLEN			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	UI			rc = 0;

	if (IS_MY_INST(pW)) {
		rc = pW->prop.TextLen;
	}
	return (LRESULT)rc;
}
//----- テキスト長設定（テキスト長，－）------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_SETTXTLEN			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW)) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.TextLen = (UI)wParam;
		SetCtrlProp(pW, &prop);
		rc = TRUE;
	}
	return rc;
}
//----- 整数値取得（－，－）------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_I_GETVALUE			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	int			rc = 0;

	if (IS_MY_INST(pW)) {
		rc = (int)pW->Value;
	}
	return rc;
}
//----- 整数値設定（整数値，－）--------------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_I_SETVALUE			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	int			pos;

	if (IS_MY_INST(pW)) {
		//----- ブリンク停止 -----------------//
		BlinkCancel(pW);
		//----- 値設定 -----------------------//
		SetCurrentValue(pW, (int)wParam);
		//----- コントロールへ値表示 ---------//
		SetValueText(pW, pW->Value);
		//----- スライダ位置設定 -------------//
		pos = ValueToSldPos(pW, pW->Value);
		AjcSetCtrlSldPos(pW->ctrls.s.sld.hwnd, pos);
		//----- 値通知 -----------------------//
		if (lParam != 0) {
			NotifyValue(pW);
		}
		rc = TRUE;
	}
	return rc;
}
//----- 整数：レンジ設定（最小値，最大値）----------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_I_SETRANGE			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW)) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.min = (double)((int)wParam);
		prop.max = (double)((int)lParam);
		SetCtrlProp(pW, &prop);
		//----- コントロールへ値表示 ---------//
		SetValueText(pW, pW->Value);
		//----- スライダ位置設定 -------------//
		AjcSetCtrlSldPos(pW->ctrls.s.sld.hwnd, ValueToSldPos(pW, pW->Value));
		rc = TRUE;
	}
	return rc;
}
//----- 整数：数値の最小単位（最小単位，－）-------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_I_SETSLDUNIT		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW)) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.SldUnit = (UI)wParam;
		SetCtrlProp(pW, &prop);
		rc = TRUE;
	}
	return rc;
}
//----- 整数：スライダページ（ページサイズ，－）----------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_I_SETSLDPAGE		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW)) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.SldPage = (UI)wParam;
		SetCtrlProp(pW, &prop);
		rc = TRUE;
	}
	return rc;
}
//----- 整数：スピンのステップ（ステップサイズ，－）------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_I_SETSPNSTEP		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW)) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.SpnStep = (UI)wParam;
		SetCtrlProp(pW, &prop);
		rc = TRUE;
	}
	return rc;
}
//----- 実数値取得（&実数，－）--------------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_R_GETVALUE			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;

	if (IS_MY_INST(pW) && wParam != 0) {
		*((double *)wParam) = pW->Value;
		rc = TRUE;
	}
	return rc;
}
//----- 実数値設定（&実数，－）--------------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_R_SETVALUE			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	int			pos;

	if (IS_MY_INST(pW) && wParam != 0) {
		//----- ブリンク停止 -----------------//
		BlinkCancel(pW);
		//----- 値設定 -----------------------//
		SetCurrentValue(pW, *((double *)wParam));
		//----- コントロールへ値表示 ---------//
		SetValueText(pW, pW->Value);
		//----- スライダ位置設定 -------------//
		pos = ValueToSldPos(pW, pW->Value);
		AjcSetCtrlSldPos(pW->ctrls.s.sld.hwnd, pos);
		//----- 値通知 -----------------------//
		if (lParam != 0) {
			NotifyValue(pW);
		}
		rc = TRUE;
	}
	return rc;
}
//----- 実数：レンジ設定（&最小値，&最大値）--------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_R_SETRANGE			)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW) && wParam != 0 && lParam != 0) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.min = *((double *)wParam);
		prop.max = *((double *)lParam);
		SetCtrlProp(pW, &prop);
		//----- コントロールへ値表示 ---------//
		SetValueText(pW, pW->Value);
		//----- スライダ位置設定 -------------//
		AjcSetCtrlSldPos(pW->ctrls.s.sld.hwnd, ValueToSldPos(pW, pW->Value));
		rc = TRUE;
	}
	return rc;
}
//----- 実数：数値の最小単位（&最小単位，－）-------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_R_SETSLDUNIT		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW) && wParam != 0) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.SldUnit = *((double *)wParam);
		SetCtrlProp(pW, &prop);
		rc = TRUE;
	}
	return rc;
}
//----- 実数：スライダページ（&ページサイズ，－）---------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_R_SETSLDPAGE		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW) && wParam != 0) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.SldPage = *((double *)wParam);
		SetCtrlProp(pW, &prop);
		rc = TRUE;
	}
	return rc;
}
//----- 実数：スピンのステップ（&ステップサイズ，－）-----------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_R_SETSPNSTEP		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW) && wParam != 0) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.SpnStep = *((double *)wParam);
		SetCtrlProp(pW, &prop);
		rc = TRUE;
	}
	return rc;
}
//----- 実数：数値精度（精度，－）------------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_R_SETPREC		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;
	AJCIVPROP	prop;

	if (IS_MY_INST(pW)) {
		//----- プロパティ値設定 -----------------//
		memcpy(&prop, &pW->prop, sizeof(AJCIVPROP));
		prop.Precision = (SW)wParam;
		SetCtrlProp(pW, &prop);
		rc = TRUE;
	}
	return rc;
}

//----- 右クリック通知設定 -------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_SETNTCRCLK		)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;

	if (IS_MY_INST(pW)) {
		pW->fNtcRClk  = (BOOL)wParam;
		pW->MsgRBDown = LOWORD(lParam);
		pW->MsgRBUp	  = HIWORD(lParam);
		rc = TRUE;
	}
	return rc;
}

//----- 整数値通知要イベント(By PostMessage) -------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_NEEDNTC_INTVALUE)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);

	if (IS_MY_INST(pW)) {
		pW->fPendingNtcInt = FALSE;
		SendMessage(GetParent(pW->hBack),
					WM_COMMAND,
					MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCIVN_INTVALUE),
					fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)pW->Value);
	}
	return 0;
}
//----- 実数値通知要イベント(By PostMessage) -------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_NEEDNTC_REALVALUE)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);

	if (IS_MY_INST(pW)) {
		pW->fPendingNtcReal = FALSE;
		SendMessage(GetParent(pW->hBack),
					WM_COMMAND,
					MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCIVN_REALVALUE),
					fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)&pW->Value);
	}
	return 0;
}
//----- ツールチップテキスト設定（バイト文字）------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_SETTIPTEXTA	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (!pW->fEnaDefTip) {
			if (rc = SubSetTipTextA(&pW->pToolTipTxt, 0, (C_BCP)wParam)) {
				AjcTipTextAddW		   (pW->hBack, pW->pToolTipTxt);
				AjcTipTextSetCallBackA (pW->hBack, 0, NULL, NULL);
				AjcTipTextSetShowAlways(pW->hBack, pW->fShowAlways);
			}
		}
	}
	return rc;
}
//----- ツールチップテキスト設定（ワイド文字）------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_SETTIPTEXTW	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (!pW->fEnaDefTip) {
			if (rc = SubSetTipTextW(&pW->pToolTipTxt, 0, (C_WCP)wParam)) {
				AjcTipTextAddW		   (pW->hBack, pW->pToolTipTxt);
				AjcTipTextSetCallBackA (pW->hBack, 0, NULL, NULL);
				AjcTipTextSetShowAlways(pW->hBack, pW->fShowAlways);
			}
		}
	}
	return rc;
}
//----- ツールチップテキスト取得（バイト文字）------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETTIPTEXTA	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = 0;

	if (IS_MY_INST(pW)) {
		if (wParam != 0	 &&	 lParam != 0) {
			rc = SubGetTipTextA(&pW->pToolTipTxt, 0, (BCP)wParam, (UI)lParam);
		}
	}
	return rc;
}
//----- ツールチップテキスト取得（ワイド文字）------------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVM_GETTIPTEXTW	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (wParam != 0 && lParam != 0) {
			rc = SubGetTipTextW(&pW->pToolTipTxt, 0, (WCP)wParam, (UI)lParam);
		}
	}
	return rc;
}
//----- ツールチップテキストからのサブクラス化通知 -------------------------------------------------------------//
AJC_WNDPROC(Main, AJCIVN_TIP_SUBCLASS	)
{
	PWRKINPVAL	pW = (PWRKINPVAL)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc = FALSE;

	//	サブクラス化通知
	if (wParam) {
		//	各サブコントロールのツールチップ非表示
		IvClrDefaultTipText(pW);
	}
	//	サブクラス化解除通知
	else {
		if (pW->fEnaDefTip) {
			//	各サブコントロールのツールチップ表示
			IvSetDefaultTipText(pW);
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE				)
	AJC_WNDMAP_MSG(Main, WM_DESTROY				)
	AJC_WNDMAP_MSG(Main, WM_SIZE				)
	AJC_WNDMAP_MSG(Main, WM_TIMER				)
	AJC_WNDMAP_MSG(Main, WM_HSCROLL				)
	AJC_WNDMAP_MSG(Main, WM_PAINT				)
	AJC_WNDMAP_MSG(Main, WM_GETTEXTLENGTH		)
	AJC_WNDMAP_MSG(Main, WM_GETTEXT				)
	AJC_WNDMAP_MSG(Main, WM_SETTEXT				)
	AJC_WNDMAP_MSG(Main, WM_GETFONT				)
	AJC_WNDMAP_MSG(Main, WM_SETFONT				)
	AJC_WNDMAP_MSG(Main, WM_STYLECHANGED		)
	AJC_WNDMAP_MSG(Main, WM_ENABLE				)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONDOWN			)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONUP			)

	AJC_WNDMAP_CMD(Main, IV_IDC_TXT			)
	AJC_WNDMAP_CMD(Main, IV_IDC_BTN			)
	AJC_WNDMAP_NTC(Main, IV_IDC_SPN			)

	AJC_WNDMAP_MSG(Main, AJCIVM_SETTEXTFORMAT	)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETPROP			)
	AJC_WNDMAP_MSG(Main, AJCIVM_SETPROP			)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETBORDERCOLOR	)
	AJC_WNDMAP_MSG(Main, AJCIVM_SETBORDERCOLOR	)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETBLINKCOLOR	)
	AJC_WNDMAP_MSG(Main, AJCIVM_SETBLINKCOLOR	)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETSLDHANDLE	)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETTXTHANDLE	)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETBTNHANDLE	)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETSPNHANDLE	)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETTXTLEN		)
	AJC_WNDMAP_MSG(Main, AJCIVM_SETTXTLEN		)
	AJC_WNDMAP_MSG(Main, AJCIVM_I_GETVALUE		)
	AJC_WNDMAP_MSG(Main, AJCIVM_I_SETVALUE		)
	AJC_WNDMAP_MSG(Main, AJCIVM_I_SETRANGE		)
	AJC_WNDMAP_MSG(Main, AJCIVM_I_SETSLDUNIT	)
	AJC_WNDMAP_MSG(Main, AJCIVM_I_SETSLDPAGE	)
	AJC_WNDMAP_MSG(Main, AJCIVM_I_SETSPNSTEP	)
	AJC_WNDMAP_MSG(Main, AJCIVM_R_GETVALUE		)
	AJC_WNDMAP_MSG(Main, AJCIVM_R_SETVALUE		)
	AJC_WNDMAP_MSG(Main, AJCIVM_R_SETRANGE		)
	AJC_WNDMAP_MSG(Main, AJCIVM_R_SETSLDUNIT	)
	AJC_WNDMAP_MSG(Main, AJCIVM_R_SETSLDPAGE	)
	AJC_WNDMAP_MSG(Main, AJCIVM_R_SETSPNSTEP	)
	AJC_WNDMAP_MSG(Main, AJCIVM_R_SETPREC		)

	AJC_WNDMAP_MSG(Main, AJCIVM_SETNTCRCLK		)

	AJC_WNDMAP_MSG(Main, AJCIVM_NEEDNTC_INTVALUE )
	AJC_WNDMAP_MSG(Main, AJCIVM_NEEDNTC_REALVALUE)

	AJC_WNDMAP_MSG(Main, AJCIVM_SETTIPTEXTA		)
	AJC_WNDMAP_MSG(Main, AJCIVM_SETTIPTEXTW		)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETTIPTEXTA		)
	AJC_WNDMAP_MSG(Main, AJCIVM_GETTIPTEXTW		)

	AJC_WNDMAP_MSG(Main, AJCIVN_TIP_SUBCLASS	)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	文字列パラメタからプロパティ設定																			//
//																												//
//	引　数	：	pTxt  - パラメタ文字列																			//
//				pProp - 現在のプロパティ値（プロパティ変更時は上書き）											//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetPropByText(PWRKINPVAL pW, WCP pTxt, PAJCIVPROP pProp)
{
	WCP			p  = NULL;
	AJCIVPROP	prop;

	if (wcsnicmp(pTxt, L"I:", 2) == 0	 ||	 wcsnicmp(pTxt, L"R:", 2) == 0) {
		//----- 現プロパティ値コピー -------------------------------------------//
		memcpy(&prop, pProp, sizeof(AJCIVPROP));
		//----- スタイル設定 ---------------------------------------------------//
		if	 (wcsnicmp(pTxt, L"I:", 2) == 0) pW->style &= ~AJCIVS_REALMODE;
		else								 pW->style |=  AJCIVS_REALMODE;
		//----- パラメタ解析 ---------------------------------------------------//
		p = pTxt + 2;
		if (p = AjcStrTokW(p, L",")) {
			do {
				while (MAjcIsBlankW(*p)) p++;
				if		(wcsnicmp(p, L"L=" , 2) == 0) prop.min		 = AjcAscToReal(p+2);
				else if (wcsnicmp(p, L"R=" , 2) == 0) prop.max		 = AjcAscToReal(p+2);
				else if (wcsnicmp(p, L"U=" , 2) == 0) prop.SldUnit	 = AjcAscToReal(p+2);
				else if (wcsnicmp(p, L"G=" , 2) == 0) prop.SldPage	 = AjcAscToReal(p+2);
				else if (wcsnicmp(p, L"S=" , 2) == 0) prop.SpnStep	 = AjcAscToReal(p+2);
				else if (wcsnicmp(p, L"T=" , 2) == 0) prop.TextLen	 = AjcAscToInt(p+2);
				else if (wcsnicmp(p, L"P=" , 2) == 0) prop.Precision = (SW)AjcAscToInt(p+2);
				else if (wcsnicmp(p, L"H=" , 2) == 0) prop.HexLen	 = (SW)AjcAscToInt(p+2);
				else if (wcsnicmp(p, L"BC=", 3) == 0) SendMessage(pW->hBack, AJCIVM_SETBORDERCOLOR, AjcAscToInt(p+3), 0);
				else if (wcsnicmp(p, L"LC=", 3) == 0) SendMessage(pW->hBack, AJCIVM_SETBLINKCOLOR , AjcAscToInt(p+3), 0);
			} while(p = AjcStrTokW(NULL, L","));
		}
		//----- ウインドスタイル設定 -------------------------------------------//
		MAjcSetWindowLong(pW->hBack, GWL_STYLE, pW->style);

		//----- コントロールのプロパティ設定 -----------------------------------//
		memcpy(pProp, &prop, sizeof(AJCIVPROP));
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	プロパティ設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetCtrlProp(PWRKINPVAL pW, PCAJCIVPROP pProp)
{
	//----- 数値最小単位設定 -----------------------------------------------------------------------------------//
	pW->prop.SldUnit = fabs(pProp->SldUnit);
	//----- 整数モードならば、数値の最小単位を１以上に訂正 -----------------------------------------------------//
	if (!(pW->style & AJCIVS_REALMODE)) {
		if (pW->prop.SldUnit < 1.0) pW->prop.SldUnit = 1.0;
	}
	else if (pW->prop.SldUnit == 0.0) {
		pW->prop.SldUnit = 0.000001;
	}
	//----- 最大／最小と増減値設定 -----------------------------------------------------------------------------//
	pW->prop.min	 = pProp->min;
	pW->prop.max	 = pProp->max;
	pW->prop.SldPage = AjcAdjustMultValue(fabs(pProp->SldPage), pW->prop.SldUnit);
	pW->prop.SpnStep = AjcAdjustMultValue(fabs(pProp->SpnStep), pW->prop.SldUnit);
	//----- 最大値と最小値の差が数値最小単位未満の場合は、最大値＝最小値±数値最小単位とする -------------------//
	if (fabs(pW->prop.min - pW->prop.max) < pW->prop.SldUnit) {
		if (pProp->min < pProp->max) pW->prop.max = pW->prop.min + pW->prop.SldUnit;
		else						 pW->prop.max = pW->prop.min - pW->prop.SldUnit;
	}
	//----- 整数モードならば、最小／最大値を INT_MIN～INT_MAX 範囲内に訂正 -------------------------------------//
	if (!(pW->style & AJCIVS_REALMODE)) {
		if		(pW->prop.min < (double)INT_MIN) pW->prop.min = (double)INT_MIN;
		else if (pW->prop.min > (double)INT_MAX) pW->prop.min = (double)INT_MAX;
		if		(pW->prop.max < (double)INT_MIN) pW->prop.max = (double)INT_MIN;
		else if (pW->prop.max > (double)INT_MAX) pW->prop.max = (double)INT_MAX;
	}
	//----- テキスト桁数，精度設定 -----------------------------------------------------------------------------//
	pW->prop.TextLen   = __max(1, (SI)pProp->TextLen);
	pW->prop.Precision =		  (SI)pProp->Precision;
	pW->prop.HexLen    = __max(0, (SI)pProp->HexLen);

	//----- 数値範囲の最小値と最大値設定 -----------------------------------------------------------------------//
	pW->MinVal	 = __min(pProp->max, pProp->min);
	pW->MaxVal	 = __max(pProp->max, pProp->min);
	//----- 数値範囲値設定 -------------------------------------------------------------------------------------//
	pW->ValWidth = fabs(pProp->max - pProp->min);
	//----- スライダ可動範囲値を INT_MAX 以下に補正 ------------------------------------------------------------//
	if ((pW->ValWidth	  / pW->prop.SldUnit) <= (double)INT_MAX) pW->SldWidth = (UI)(pW->ValWidth	   / pW->prop.SldUnit);
	else														  pW->SldWidth = INT_MAX;
	//----- スライダページ値を INT_MAX 以下に補正 --------------------------------------------------------------//
	if ((pW->prop.SldPage / pW->prop.SldUnit) <= (double)INT_MAX) pW->SldPgWid = (UI)(pW->prop.SldPage / pW->prop.SldUnit);
	else														  pW->SldPgWid = INT_MAX;
	//----- スピンボタンの増減方向を設定 -----------------------------------------------------------------------//
	if (pProp->min < pProp->max) {
		AjcSetCtrlSpnRange(pW->ctrls.s.spn.hwnd, -1,  1);
	}
	else {
		AjcSetCtrlSpnRange(pW->ctrls.s.spn.hwnd,  1, -1);
	}
	//----- スライダのレンジとページサイズ設定 -----------------------------------------------------------------//
	AjcSetCtrlSldRange(pW->ctrls.s.sld.hwnd, 0, pW->SldWidth, pW->SldPgWid);
	//----- 現在の数値を数値最小単位の倍数に補正 ---------------------------------------------------------------//
	SetCurrentValue(pW, pW->Value);
	//----- 現在の数値テキストを表示 ---------------------------------------------------------------------------//
	SetValueText(pW, pW->Value);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ブリンク（テキスト入力）開始																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		BlinkStart(PWRKINPVAL pW)
{
	RECT	r;
	int		w, h;

	pW->fBlkBusy  = TRUE;
	pW->fBlkDraw  = FALSE;
	pW->fBlkOn	  = FALSE;
	pW->BlkSvTick = GetTickCount() / 1000;
	SendMessage(pW->ctrls.s.txt.hwnd, EM_SETREADONLY, FALSE, 0);
	SetFocus   (pW->ctrls.s.txt.hwnd);
	SendMessage(pW->ctrls.s.txt.hwnd, EM_SETSEL, 0, -1);
	SetTimer(pW->hBack, IV_TID_BLINK, 30, NULL);

	if (!(pW->style & AJCIVS_NOBTN)) {
		GetWindowRect(pW->ctrls.s.btn.hwnd, &r);
		w = r.right - r.left;
		h = r.bottom - r.top;
		if ((h * 100 / w) < 200) {
			MAjcSetWindowLong(pW->ctrls.s.btn.hwnd, GWL_STYLE, MAjcGetWindowLong(pW->ctrls.s.btn.hwnd, GWL_STYLE) & ~BS_MULTILINE);
			SetWindowText(pW->ctrls.s.btn.hwnd, L"ok");
		}
		else {
			MAjcSetWindowLong(pW->ctrls.s.btn.hwnd, GWL_STYLE, MAjcGetWindowLong(pW->ctrls.s.btn.hwnd, GWL_STYLE) | BS_MULTILINE);
			SetWindowText(pW->ctrls.s.btn.hwnd, L"O\nK");
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ブリンク（テキスト入力）終了																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		BlinkEnd(PWRKINPVAL pW)
{
	int		pos, i;
	double	val;
	WC		txt[256];

	if (pW->fBlkBusy) {
		pW->fBlkBusy  = FALSE;
		pW->fBlkDraw  = TRUE;
		pW->fBlkOn	  = FALSE;
		SendMessage(pW->ctrls.s.txt.hwnd, EM_SETREADONLY, TRUE, 0);
		KillTimer(pW->hBack, IV_TID_BLINK);
		//----- 値設定 -----------------------//
		AjcGetCtrlStr(pW->ctrls.s.txt.hwnd, txt, AJCTSIZE(txt));
		for (i=0; i< AJCTSIZE(txt) - 1 && MAjcIsBlankW(txt[i]); i++);
		if (wcsnicmp(&txt[i], L"0x", 2) == 0) val = AjcGetCtrlHex (pW->ctrls.s.txt.hwnd);
		else								  val = AjcGetCtrlReal(pW->ctrls.s.txt.hwnd);
		SetCurrentValue(pW, val);
		//----- コントロールへ値表示 ---------//
		SetValueText(pW, pW->Value);
		//----- スライダ位置設定 -------------//
		pos = ValueToSldPos(pW, pW->Value);
		AjcSetCtrlSldPos(pW->ctrls.s.sld.hwnd, pos);
		//----- ボタンフェース ---------------//
		SetWindowText(pW->ctrls.s.btn.hwnd, L"...");
		//----- 再描画 -----------------------//
		InvalidateRect(pW->hBack, NULL, FALSE);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ブリンク（テキスト入力）キャンセル																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		BlinkCancel(PWRKINPVAL pW)
{
	if (pW->fBlkBusy) {
		pW->fBlkBusy  = FALSE;
		pW->fBlkDraw  = TRUE;
		pW->fBlkOn	  = FALSE;
		SendMessage(pW->ctrls.s.txt.hwnd, EM_SETREADONLY, TRUE, 0);
		KillTimer(pW->hBack, IV_TID_BLINK);
		SetValueText(pW, pW->Value);
		SetWindowText(pW->ctrls.s.btn.hwnd, L"...");
		InvalidateRect(pW->hBack, NULL, FALSE);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	テキスト設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetValueText(PWRKINPVAL pW, double val)
{
	if (pW->style & AJCIVS_SHOWHEX) {			//	１６進表示？
		if (pW->prop.HexLen <= 0) AjcSetCtrlHex(pW->ctrls.s.txt.hwnd, (UI)val);
		else					  AjcSepCtrlHex(pW->ctrls.s.txt.hwnd, (UI)val, pW->prop.HexLen);
	}
	else {										//	１０進表示？
		if (pW->style & AJCIVS_SEPARATE) {
			if (pW->style & AJCIVS_REALMODE) AjcSepCtrlReal(pW->ctrls.s.txt.hwnd,	  val, pW->prop.Precision);
			else							 AjcSepCtrlSInt(pW->ctrls.s.txt.hwnd, (SI)val);
		}
		else {
			if (pW->style & AJCIVS_REALMODE) AjcSetCtrlReal(pW->ctrls.s.txt.hwnd,	  val, pW->prop.Precision);
			else							 AjcSetCtrlSInt(pW->ctrls.s.txt.hwnd, (SI)val);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	表示文字列生成																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	UI	MakeValueText(PWRKINPVAL pW, WCP pBuf, UI lBuf)
{
	if (pW->style & AJCIVS_SHOWHEX) {			//	１６進表示？
		if (pW->prop.HexLen <= 0) AjcSnPrintF(pBuf, lBuf, L"0x%X"	, (int)pW->Value);
		else					  AjcSnPrintF(pBuf, lBuf, L"0x%0*X"	, pW->prop.HexLen, (int)pW->Value);
	}
	else {										//	１０進表示？
		if (pW->style & AJCIVS_SEPARATE) {		//		区切り記号あり？
			if (pW->style & AJCIVS_REALMODE) {
				if (pW->prop.Precision >= 0) AjcSnPrtSep(pBuf, lBuf, L"%.*f", abs(pW->prop.Precision), pW->Value);
				else						 AjcSnPrtSep(pBuf, lBuf, L"%.*G", abs(pW->prop.Precision), pW->Value);
			}
			else {
				AjcSnPrtSep(pBuf, lBuf, L"%d"  , (int)pW->Value);
			}
		}
		else {									//		区切り記号なし？
			if (pW->style & AJCIVS_REALMODE) {
				if (pW->prop.Precision >= 0) AjcSnPrintF(pBuf, lBuf, L"%.*f", abs(pW->prop.Precision), pW->Value);
				else						 AjcSnPrintF(pBuf, lBuf, L"%.*G", abs(pW->prop.Precision), pW->Value);
			}
			else {
				AjcSnPrintF(pBuf, lBuf, L"%d"  , (int)pW->Value);
			}
		}
	}
	return (UI)wcslen(pBuf);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロール配置																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetControlPosition(PWRKINPVAL pW)
{
	TEXTMETRIC	tm;
	RECT		r;
	HDC			hdc;
	SIZE		sz1, sz2;
	int			x, cxChar, cyChar, lTxt;
	HFONT		hFont;

	//----- テキストボックスの桁数設定 -------------------------------------------------------------------------//
	lTxt = pW->prop.TextLen;
	lTxt = __max(1, lTxt);
	//----- ウインドサイズ設定 ---------------------------------------------------------------------------------//
	GetClientRect(pW->hBack, &r);
	pW->ww = r.right - r.left;
	pW->wh = r.bottom - r.top;
	//----- テキストフォントの文字幅設定 -----------------------------------------------------------------------//
	hFont = (HFONT)SendMessage(pW->ctrls.s.txt.hwnd, WM_GETFONT, 0, 0);
	hdc   = GetDC(pW->hBack);
	hFont = (HFONT)SelectObject(hdc, hFont);
	GetTextMetrics(hdc, &tm);
	SelectObject(hdc, hFont);
	ReleaseDC(pW->hBack, hdc);
	cxChar = tm.tmAveCharWidth;
	cyChar = tm.tmHeight;
	//----- ボタン表示幅設定 -----------------------------------------------------------------------------------//
	hdc = GetDC(pW->ctrls.s.btn.hwnd);
	GetTextExtentPoint32(hdc, L"...", 1, &sz1);
	GetTextExtentPoint32(hdc, L"ok" , 1, &sz2);
	ReleaseDC(pW->ctrls.s.btn.hwnd, hdc);
	//----- コントロールのＹ位置と高さ設定 ---------------------------------------------------------------------//
	pW->y			   = 2;
	pW->cy			   = pW->wh - 4;
	//----- 各コントロールの表示幅設定 -------------------------------------------------------------------------//
	pW->ctrls.s.btn.cx = pW->ctrls.s.spn.cx = pW->ctrls.s.txt.cx = pW->ctrls.s.sld.cx = 0;
	if (!(pW->style & AJCIVS_NOBTN)) pW->ctrls.s.btn.cx = __max(sz1.cx, sz2.cx) + 6;
									 pW->ctrls.s.txt.cx = cxChar * (lTxt + 1);
	if (!(pW->style & AJCIVS_NOSPN)) pW->ctrls.s.spn.cx = cyChar;
	if (!(pW->style & AJCIVS_NOSLD)) pW->ctrls.s.sld.cx = pW->ww - (pW->ctrls.s.btn.cx + pW->ctrls.s.spn.cx + pW->ctrls.s.txt.cx + 9);
	else							 pW->ctrls.s.txt.cx = pW->ww - (pW->ctrls.s.btn.cx + pW->ctrls.s.spn.cx						 + 9);
	//----- 各コントロールの表示Ｘ位置設定 ---------------------------------------------------------------------//
	x = 3;
	if (!(pW->style & AJCIVS_NOSLD)) {pW->ctrls.s.sld.x = x; x += (pW->ctrls.s.sld.cx + 1);}
									 {pW->ctrls.s.txt.x = x; x += (pW->ctrls.s.txt.cx + 1);}
	if (!(pW->style & AJCIVS_NOBTN)) {pW->ctrls.s.btn.x = x; x += (pW->ctrls.s.btn.cx + 1);}
	if (!(pW->style & AJCIVS_NOSPN)) {pW->ctrls.s.spn.x = x;							   }
	//----- 各コントロールを配置 -------------------------------------------------------------------------------//
	if (!(pW->style & AJCIVS_NOSLD)) {
		if (pW->cy <= 24) {
			MoveWindow(pW->ctrls.s.sld.hwnd, pW->ctrls.s.sld.x, 1, pW->ctrls.s.sld.cx, pW->cy, TRUE);
		}
		else {
			MoveWindow(pW->ctrls.s.sld.hwnd, pW->ctrls.s.sld.x, 1 + ((pW->cy - 24) / 2), pW->ctrls.s.sld.cx, 24, TRUE);
		}
	}
									 MoveWindow(pW->ctrls.s.txt.hwnd, pW->ctrls.s.txt.x, 2, pW->ctrls.s.txt.cx, pW->cy, TRUE);
	if (!(pW->style & AJCIVS_NOBTN)) MoveWindow(pW->ctrls.s.btn.hwnd, pW->ctrls.s.btn.x, 2, pW->ctrls.s.btn.cx, pW->cy, TRUE);
	if (!(pW->style & AJCIVS_NOSPN)) MoveWindow(pW->ctrls.s.spn.hwnd, pW->ctrls.s.spn.x, 2, pW->ctrls.s.spn.cx, pW->cy, TRUE);
	//----- 各コントロールを表示／非表示 -----------------------------------------------------------------------//
	if (!(pW->style & AJCIVS_NOSLD)) ShowWindow(pW->ctrls.s.sld.hwnd, SW_SHOW); else ShowWindow(pW->ctrls.s.sld.hwnd, SW_HIDE);
									 ShowWindow(pW->ctrls.s.txt.hwnd, SW_SHOW);
	if (!(pW->style & AJCIVS_NOBTN)) ShowWindow(pW->ctrls.s.btn.hwnd, SW_SHOW); else ShowWindow(pW->ctrls.s.btn.hwnd, SW_HIDE);
	if (!(pW->style & AJCIVS_NOSPN)) ShowWindow(pW->ctrls.s.spn.hwnd, SW_SHOW); else ShowWindow(pW->ctrls.s.spn.hwnd, SW_HIDE);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	スライダ位置→値 変換																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	double	SldPosToValue(PWRKINPVAL pW, int pos)
{
	double	rc;
	
	if (pW->prop.min < pW->prop.max) {
		rc = pW->prop.min + (pW->ValWidth * (double)pos / (double)pW->SldWidth);
	}
	else {
		rc = pW->prop.min - (pW->ValWidth * (double)pos / (double)pW->SldWidth);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	値→スライダ位置 変換																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	int		ValueToSldPos(PWRKINPVAL pW, double val)
{
	int		rc;
	
	if (pW->prop.min < pW->prop.max) {
		rc = (int)((val - pW->MinVal) * (double)pW->SldWidth / pW->ValWidth);
	}
	else {
		rc = (int)((pW->MaxVal - val) * (double)pW->SldWidth / pW->ValWidth);
	}
	
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドへ値通知																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		NotifyValue(PWRKINPVAL pW)
{
	if (pW->style & AJCIVS_REALMODE) {
		if (!pW->fPendingNtcReal) {
			pW->fPendingNtcReal = TRUE;
			PostMessage(pW->hBack, AJCIVM_NEEDNTC_REALVALUE, 0, 0);
		}
	}
	else {
		if (!pW->fPendingNtcInt) {
			pW->fPendingNtcInt = TRUE;
			PostMessage(pW->hBack, AJCIVM_NEEDNTC_INTVALUE, 0, 0);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロールの有効状態設定																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		EnableCtrls(PWRKINPVAL pW, BOOL fEnable)
{
	EnableWindow(pW->ctrls.s.sld.hwnd, fEnable);
	EnableWindow(pW->ctrls.s.txt.hwnd, fEnable);
	EnableWindow(pW->ctrls.s.btn.hwnd, fEnable);
	EnableWindow(pW->ctrls.s.spn.hwnd, fEnable);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	現在の数値設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SetCurrentValue(PWRKINPVAL pW, double NewVal)
{
	//----- 数値を最小単位の倍数に補正 --------------------------//
	pW->Value = AjcAdjustMultValue(NewVal, pW->prop.SldUnit);

	//----- 最大値カット ----------------------------------------//
	if		(pW->Value >= pW->MaxVal) {
		pW->Value = pW->MaxVal;
	}
	//----- 最小値カット ----------------------------------------//
	else if (pW->Value <= pW->MinVal) {
		pW->Value = pW->MinVal;
	}
}

