﻿#include	"AjcInternal.h"
#include	"AjcCtrlInpValDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（数値入力）			共通サブ関数													//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	C_WCP CALLBACK cbSldGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp);
static	C_WCP CALLBACK cbTxtGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp);
static	C_WCP CALLBACK cbBtnGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp);
static	C_WCP CALLBACK cbSpnGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp);


//==============================================================================================================//
//																												//
//	デフォルトチップテキスト表示（最上位ウインドのチップテキスト非表示）										//
//																												//
//==============================================================================================================//
VO	IvSetDefaultTipText(PWRKINPVAL pW)
{
	if (!pW->fSetDefTip) {
		//----- バックウインドのチップテキスト消去 -------------------------------------//
		AjcTipTextRemove(pW->hBack);
		//----- 各コントロールのチップテキスト設定 -------------------------------------//
		//	スライダ
		AjcTipTextAdd		 (pW->ctrls.s.sld.hwnd, L"");
		AjcTipTextSetCallBack(pW->ctrls.s.sld.hwnd, 0, NULL, cbSldGetTipText);
		//	テキストボックス
		AjcTipTextAdd		 (pW->ctrls.s.txt.hwnd, L"");
		AjcTipTextSetCallBack(pW->ctrls.s.txt.hwnd, 0, NULL, cbTxtGetTipText);
		//	ボタン
		AjcTipTextAdd		 (pW->ctrls.s.btn.hwnd, L"");
		AjcTipTextSetCallBack(pW->ctrls.s.btn.hwnd, 0, NULL, cbBtnGetTipText);
		//	スピンボタン
		AjcTipTextAdd		 (pW->ctrls.s.spn.hwnd, L"");
		AjcTipTextSetCallBack(pW->ctrls.s.spn.hwnd, 0, NULL, cbSpnGetTipText);

		pW->fSetDefTip = TRUE;
	}
}

//==============================================================================================================//
//																												//
//	デフォルトチップテキスト非表示（最上位ウインドのチップテキスト表示）										//
//																												//
//==============================================================================================================//
VO	IvClrDefaultTipText(PWRKINPVAL pW)
{
	if (pW->fSetDefTip) {
		//----- 各コントロールのチップテキスト消去 -------------------------------------//
		//	スライダ
		AjcTipTextRemove	  (pW->ctrls.s.sld.hwnd);
		//	テキストボックス
		AjcTipTextRemove	  (pW->ctrls.s.txt.hwnd);
		//	ボタン
		AjcTipTextRemove	  (pW->ctrls.s.btn.hwnd);
		//	スピンボタン
		AjcTipTextRemove	  (pW->ctrls.s.spn.hwnd);
		//----- バックウインドのチップテキスト設定 -------------------------------------//
		if (pW->pToolTipTxt != NULL && *pW->pToolTipTxt != 0) {
			AjcTipTextAddW(pW->hBack, pW->pToolTipTxt);
		}

		pW->fSetDefTip = FALSE;
	}
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	チップテキスト要求（コールバック）																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- チップテキスト要求（スライダ）--------------------------------------------------------------------------//
static	C_WCP CALLBACK cbSldGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);
	WC			szMin[32], szMax[32];

	if (pW->style & AJCIVS_REALMODE) {
		AjcSnPrintF(szMin, AJCTSIZE(szMin), L"%.*f", pW->prop.Precision, pW->prop.min);
		AjcSnPrintF(szMax, AJCTSIZE(szMax), L"%.*f", pW->prop.Precision, pW->prop.max);
	}
	else {
		AjcSnPrintF(szMin, AJCTSIZE(szMin), L"%.0f",					 pW->prop.min);
		AjcSnPrintF(szMax, AJCTSIZE(szMax), L"%.0f",					 pW->prop.max);
	}

	AjcSnPrintF(pBuf, lBuf, LNGSEL(L"設定値をスライドします。（%s ～ %s）", L"Slide the setting value from %s to %s"), szMin, szMax);

	return pBuf;
}
//----- チップテキスト要求（テキストボックス）------------------------------------------------------------------//
static	C_WCP CALLBACK cbTxtGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);
	WC			szMin[32], szMax[32];

	if (pW->style & AJCIVS_REALMODE) {
		AjcSnPrintF(szMin, AJCTSIZE(szMin), L"%.*f", pW->prop.Precision, pW->prop.min);
		AjcSnPrintF(szMax, AJCTSIZE(szMax), L"%.*f", pW->prop.Precision, pW->prop.max);
	}
	else {
		AjcSnPrintF(szMin, AJCTSIZE(szMin), L"%.0f",					 pW->prop.min);
		AjcSnPrintF(szMax, AJCTSIZE(szMax), L"%.0f",					 pW->prop.max);
	}

	if (pW->style & AJCIVS_AUTOEDIT) {						//		自動編集モード？
		if (pW->fBlkBusy) {									//			数値編集中？
			if (pW->style & AJCIVS_NOBTN) {					//				ボタン無し？
				AjcSnPrintF(pBuf, lBuf,
					LNGSEL(L"以下の操作で入力を確定します。\n"
						   L"   ・SPACEキーを押下する。\n"
						   L"   ・フォーカスを移動する。（他のウインドやコントロールをクリックしたり、このコントロールを含むウインドを終了します）",
						   L"Determine the input by the following operation. \n"
						   L"   - Press the SPACE key.\n"
						   L"   - Move the focus.(Click on another window or control or exit the window containing this control)"
					));
			}
			else {											//				ボタン有り？
				AjcSnPrintF(pBuf, lBuf,
					LNGSEL(L"以下の操作で入力を確定します。\n"
						   L"   ・右の ok ボタンを押す。\n"
						   L"   ・SPACEキーを押下する。\n"
						   L"   ・フォーカスを移動する。（他のウインドやコントロールをクリックしたり、このコントロールを含むウインドを終了します）",
						   L"Determine the input by the following operation.\n"
						   L"   - Press the right 'ok' button.\n"
						   L"   - Press the SPACE key.\n"
						   L"   - Move the focus.(Click on another window or control or exit the window containing this control)"
					));
			}
		}
		else {												//			数値未編集中？
			if (pW->style & AJCIVS_NOBTN) {					//				ボタン無し？
				AjcSnPrintF(pBuf, lBuf,
					LNGSEL(L"設定値（%s ～ %s）を直接入力するには、ここをクリックします。",
						   L"To enter the settings(%s to %s) directly, click here."),
					szMin, szMax
				);
			}
			else {											//				ボタン有り？
				AjcSnPrintF(pBuf, lBuf,
					LNGSEL(L"設定値（%s ～ %s）を直接入力するには、ここをクリックするか、右の '...' ボタンを押します。",
						   L"To enter the settings(%s to %s) directly, click here or press the '...' button on the right."),
					szMin, szMax
				);
			}
		}
	}
	else {													//		通常編集モード？
		if (pW->fBlkBusy) {									//			数値編集中？
			if (pW->style & AJCIVS_NOBTN) {					//				ボタン無し？
				AjcSnPrintF(pBuf, lBuf,
					LNGSEL(L"以下の操作で入力を確定します。\n"
						   L"   ・SPACEキーを押下する。\n"
						   L"   ・フォーカスを移動する。（他のウインドやコントロールをクリックしたり、このコントロールを含むウインドを終了します）",
						   L"Determine the input by the following operation. Pressed ESC key return to original value.\n"
						   L"   - Press the SPACE key.\n"
						   L"   - Move the focus.(Click on another window or control or exit the window containing this control)"
					));
			}
			else {											//				ボタン有り？
				AjcSnPrintF(pBuf, lBuf,
					LNGSEL(L"以下の操作で入力を確定します。\n"
						   L"   ・右の ok ボタンを押す。\n"
						   L"   ・SPACEキーを押下する。\n"
						   L"   ・フォーカスを移動する。（他のウインドやコントロールをクリックしたり、このコントロールを含むウインドを終了します）",
						   L"Determine the input by the following operation. Pressed ESC key return to original value.\n"
						   L"   - Press the right 'ok' button.\n"
						   L"   - Press the SPACE key.\n"
						   L"   - Move the focus.(Click on another window or control or exit the window containing this control)"
					));
			}
		}
		else {												//			数値未編集中？
			if (pW->style & AJCIVS_NOBTN) {					//				ボタン無し？
				AjcSnPrintF(pBuf, lBuf,
					LNGSEL(L"設定値（%s ～ %s）",
						   L"The set value (%s to %s)."),
					szMin, szMax
				);
			}
			else {											//				ボタン有り？
				AjcSnPrintF(pBuf, lBuf,
					LNGSEL(L"設定値（%s ～ %s）を直接入力するには、右の '...' ボタンを押します。",
						   L"To enter the setting value (%s to %s) directly, press the '...' button on the right."),
					szMin, szMax
				);
			}
		}
	}
	return pBuf;
}
//----- チップテキスト要求（ボタン）----------------------------------------------------------------------------//
static	C_WCP CALLBACK cbBtnGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);

	if (pW->fBlkBusy)	//	数値編集中？
		AjcSnPrintF(pBuf, lBuf, LNGSEL(L"入力した設定値を確定します"				  , L"Determine the entered setting value."		));
	else				//	数値未編集中？
		AjcSnPrintF(pBuf, lBuf, LNGSEL(L"設定値を直接入力するにはここをクリックします", L"Click here to directly enter setting value."));

	return pBuf;
}

//----- チップテキスト要求（スピンボタン）----------------------------------------------------------------------//
static	C_WCP CALLBACK cbSpnGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp)
{
	HWND		hParent = GetParent(hwnd);
	PWRKINPVAL	pW		= (PWRKINPVAL)MAjcGetWindowLong(hParent, 0);
	WC			szVal[32];

	if (pW->style & AJCIVS_REALMODE) AjcSnPrintF(szVal, AJCTSIZE(szVal), L"%.*f", pW->prop.Precision, pW->prop.SpnStep);
	else							 AjcSnPrintF(szVal, AJCTSIZE(szVal), L"%.0f",					  pW->prop.SpnStep);

	AjcSnPrintF(pBuf, lBuf, LNGSEL(L"設定値を増減します。(±%s)",
								   L"Increase or decrease by %s."), szVal);
	return pBuf;
}

