﻿#include	"AjcInternal.h"
#include	"AjcCtrlListBoxDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（リストボックス）					ＡＰＩ												//
//																												//
//**************************************************************************************************************//

#define	IS_MY_INST(P)	(P != NULL && P->InstID == LBX_INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
ATOM	LbxClassBack	= 0;
ATOM	LbxClassMain	= 0;

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcCtrlListBoxInit(VO)
{
	BOOL		rc = FALSE;
	WNDCLASS	wndclass;

	do {
		//----- バックウインドクラス --------------------------//
		wndclass.style			= CS_GLOBALCLASS;
		wndclass.lpfnWndProc	= LbxWndProcBack();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRKLISTBOX);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= hBruBtnFace;
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcCtrlListBox";
		if ((LbxClassBack = RegisterClass(&wndclass)) == 0) break;

		rc = TRUE;
	} while(0);

	if (rc == FALSE) {
		AjcCtrlListBoxEnd();
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcCtrlListBoxEnd (VO)
{
	if (LbxClassBack	!= 0) {UnregisterClass((WCP)LbxClassBack   , hDllInst); LbxClassBack	= 0;}
	if (LbxClassMain	!= 0) {UnregisterClass((WCP)LbxClassMain   , hDllInst); LbxClassMain	= 0;}
}

//==============================================================================================================//
//	全リストボックス項目の取得																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pCount		 - 全リストボックス項目数を格納するバッファのアドレス（不要時はNULL)				//
//																												//
//	戻り値	：	≠NULL：全リストボックス項目の配列の先頭アドレス												//
//				＝NULL：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT PAJCLBXITEMA	WINAPI	AjcLbxGetAllItemsA	(HWND hwnd, UIP pCount)
{
	PWRKLISTBOX		pW;
	PAJCLBXITEMA	rc = NULL;
	PAJCLBXITEMA	pTbl;
	int				n, i, stl;
	int				cnt = 0;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		n = (int)SendMessageA(pW->hLbx, LB_GETCOUNT, 0, 0);
		if (rc = (PAJCLBXITEMA)AJCMEM(sizeof(AJCLBXITEMA) * (n + 1))) {
			pTbl = rc;
			for (i = 0; i < n; i++) {
				if ((stl = (int)SendMessageA(pW->hLbx, LB_GETTEXTLEN, i, 0)) >= 0) {
					if (pTbl->pStr = AjcTAllocA(stl + 1)) {
						SendMessageA(pW->hLbx, LB_GETTEXT, i, (LPARAM)pTbl->pStr);
						pTbl->data = (UX)SendMessageA(pW->hLbx, LB_GETITEMDATA, i, 0);
						cnt++;
						pTbl++;
					}
				}
			}
			pTbl->pStr = NULL;
			pTbl->data = 0;
		}
	}
	if (pCount != NULL) *pCount = cnt;

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT PAJCLBXITEMW	WINAPI	AjcLbxGetAllItemsW	(HWND hwnd, UIP pCount)
{
	PWRKLISTBOX		pW;
	PAJCLBXITEMW	rc = NULL;
	PAJCLBXITEMW	pTbl;
	int				n, i, stl;
	int				cnt = 0;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		n = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0);
		if (rc = (PAJCLBXITEMW)AJCMEM(sizeof(AJCLBXITEMW) * (n + 1))) {
			pTbl = rc;
			for (i = 0; i < n; i++) {
				if ((stl = (int)SendMessage(pW->hLbx, LB_GETTEXTLEN, i, 0)) >= 0) {
					if (pTbl->pStr = AjcTAlloc(stl + 1)) {
						SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)pTbl->pStr);
						pTbl->data = (UX)SendMessage(pW->hLbx, LB_GETITEMDATA, i, 0);
						cnt++;
						pTbl++;
					}
				}
			}
			pTbl->pStr = NULL;
			pTbl->data = 0;
		}
	}
	if (pCount != NULL) *pCount = cnt;

	return rc;
}
//==============================================================================================================//
//	取得した全リストボックス項目のメモリ解放																	//
//																												//
//	引　数	：	pAllItemBuf	 - 全リストボックス項目の配列のアドレス												//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT VO			WINAPI	AjcLbxRelAllItems	(VOP pAllItemBuf)
{
	PAJCLBXITEMW	pTbl;

	if (pAllItemBuf != NULL) {
		pTbl = pAllItemBuf;
		while (pTbl->pStr != NULL) {
			free(pTbl->pStr);
			pTbl++;
		}
		free(pAllItemBuf);
	}
}

//==============================================================================================================//
//	選択されているリストボックス項目の取得																		//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pCount		 - 選択されているリストボックス項目数を格納するバッファのアドレス（不要時はNULL)	//
//																												//
//	戻り値	：	≠NULL：選択されているリストボックス項目の配列の先頭アドレス									//
//				＝NULL：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT PAJCLBXITEMA	WINAPI	AjcLbxGetSelectedItemsA	(HWND hwnd, UIP pCount)
{
	PWRKLISTBOX		pW;
	PAJCLBXITEMA	rc = NULL;
	PAJCLBXITEMA	pTbl;
	int				n, i, stl;
	int				cnt = 0;
	int				selcnt;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if ((n = (int)SendMessageA(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
			//----- 選択項目数カウント -----------------------------//
			selcnt = 0;
			for (i = 0; i < n; i++) {
				if (SendMessageA(pW->hLbx, LB_GETSEL, i, 0) > 0) {
					selcnt++;
				}
			}
			//----- 情報設定 ---------------------------------------//
			if (selcnt > 0) {
				if (rc = (PAJCLBXITEMA)AJCMEM(sizeof(AJCLBXITEMA) * (selcnt + 1))) {
					pTbl = rc;
					for (i = 0; i < n; i++) {
						if (SendMessageA(pW->hLbx, LB_GETSEL, i, 0) > 0) {
							if ((stl = (int)SendMessageA(pW->hLbx, LB_GETTEXTLEN, i, 0)) >= 0) {
								if (pTbl->pStr = AjcTAllocA(stl + 1)) {
									SendMessageA(pW->hLbx, LB_GETTEXT, i, (LPARAM)pTbl->pStr);
									pTbl->data = (UX)SendMessageA(pW->hLbx, LB_GETITEMDATA, i, 0);
									cnt++;
									pTbl++;
								}
							}
						}
					}
					pTbl->pStr = NULL;
					pTbl->data = 0;
				}
			}
		}
	}
	if (pCount != NULL) *pCount = cnt;

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT PAJCLBXITEMW	WINAPI	AjcLbxGetSelectedItemsW	(HWND hwnd, UIP pCount)
{
	PWRKLISTBOX		pW;
	PAJCLBXITEMW	rc = NULL;
	PAJCLBXITEMW	pTbl;
	int				n, i, stl;
	int				cnt = 0;
	int				selcnt;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if ((n = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
			//----- 選択項目数カウント -----------------------------//
			selcnt = 0;
			for (i = 0; i < n; i++) {
				if (SendMessage(pW->hLbx, LB_GETSEL, i, 0)) {
					selcnt++;
				}
			}
			//----- 情報設定 ---------------------------------------//
			if (selcnt > 0) {
				if (rc = (PAJCLBXITEMW)AJCMEM(sizeof(AJCLBXITEMA) * (selcnt + 1))) {
					pTbl = rc;
					for (i = 0; i < n; i++) {
						if (SendMessage(pW->hLbx, LB_GETSEL, i, 0)) {
							if ((stl = (int)SendMessage(pW->hLbx, LB_GETTEXTLEN, i, 0)) >= 0) {
								if (pTbl->pStr = AjcTAlloc(stl + 1)) {
									SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)pTbl->pStr);
									pTbl->data = (UX)SendMessage(pW->hLbx, LB_GETITEMDATA, i, 0);
									cnt++;
									pTbl++;
								}
							}
						}
					}
					pTbl->pStr = NULL;
					pTbl->data = 0;
				}
			}
		}
	}
	if (pCount != NULL) *pCount = cnt;

	return rc;
}
//==============================================================================================================//
//	取得した選択済リストボックス項目のメモリ解放																//
//																												//
//	引　数	：	pSelectedItemBuf - 選択されているリストボックス項目の配列のアドレス								//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT VO			WINAPI	AjcLbxRelSelectedItems	(VOP pSelectedItemBuf)
{
	PAJCLBXITEMW	pTbl;

	if (pSelectedItemBuf != NULL) {
		pTbl = pSelectedItemBuf;
		while (pTbl->pStr != NULL) {
			free(pTbl->pStr);
			pTbl++;
		}
		free(pSelectedItemBuf);
	}
}
//==============================================================================================================//
//	永続化情報のロード																							//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pSect		 - プロファイルセクション名															//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxLoadPermInfoA  (HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmpSec = NULL;
	WCP		pTmpKey = NULL;

	do {
		if (pProfileSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
			if (len != 0 && (pTmpSec = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmpSec, len);
			}
			else break;
		}
		if (pKeyPrefix != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0);
			if (len != 0 && (pTmpKey = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pTmpKey, len);
			}
			else break;
		}
		rc = AjcLbxLoadPermInfoW(hwnd, pTmpSec, pTmpKey);
	} while(0);

	if (pTmpSec != NULL) free(pTmpSec);
	if (pTmpKey != NULL) free(pTmpKey);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxLoadPermInfoW  (HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix)
{
	PWRKLISTBOX	pW;
	BOOL		rc	  = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		//	セクション名，キー接頭語退避
		AjcLbxSetPermAttW(hwnd, pProfileSect, pKeyPrefix);
		//	全リスト項目のロード
		rc = AjcLbxLoadItems(hwnd, pProfileSect, pKeyPrefix);
	}
	return rc;
}

//==============================================================================================================//
//	永続化情報のセーブ																							//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
AJCEXPORT BOOL			WINAPI	AjcLbxSavePermInfo(HWND hwnd)
{
	return AjcLbxSavePermInfoExW(hwnd, NULL, NULL);
}
//==============================================================================================================//
//	永続化情報のセーブ（セクション指定）																		//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - セクション名へのポインタ															//
//				pKeyPrefix	 - キー名接頭語名へのポインタ														//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxSavePermInfoExA(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmpSec = NULL;
	WCP		pTmpKey = NULL;

	do {
		if (pProfileSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
			if (len != 0 && (pTmpSec = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmpSec, len);
			}
			else break;
		}
		if (pKeyPrefix != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0);
			if (len != 0 && (pTmpKey = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pTmpKey, len);
			}
			else break;
		}
		rc = AjcLbxSavePermInfoExW(hwnd, pTmpSec, pTmpKey);
	} while(0);

	if (pTmpSec != NULL) free(pTmpSec);
	if (pTmpKey != NULL) free(pTmpKey);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxSavePermInfoExW(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		//----- セクション，キー指定無しならば、ロード時に設定した名称とする -------------------------------//
		if (pProfileSect == NULL) pProfileSect = pW->PermSect;
		if (pKeyPrefix	 == NULL) pKeyPrefix   = pW->PermKey;
		//----- プロファイルセーブ -------------------------------------------------------------------------//
		if (*pProfileSect != 0) {
			rc = AjcLbxSaveItems(hwnd, pProfileSect, pKeyPrefix);
		}
	}
	return rc;
}

//==============================================================================================================//
//	永続化の属性（セクション名，キー接頭語）設定																//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - セクション名へのポインタ															//
//				pKeyPrefix	 - キー名接頭語名へのポインタ														//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxSetPermAttA  (HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmpSec = NULL;
	WCP		pTmpKey = NULL;

	do {
		if (pProfileSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
			if (len != 0 && (pTmpSec = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmpSec, len);
			}
			else break;
		}
		if (pKeyPrefix != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0);
			if (len != 0 && (pTmpKey = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pTmpKey, len);
			}
			else break;
		}
		rc = AjcLbxSetPermAttW(hwnd, pTmpSec, pTmpKey);
	} while(0);

	if (pTmpSec != NULL) free(pTmpSec);
	if (pTmpKey != NULL) free(pTmpKey);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxSetPermAttW  (HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix)
{
	PWRKLISTBOX	pW;
	BOOL		rc	  = FALSE;
	WC			szid[16];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		//----- ＩＤ文字列設定 -----------------------------------------------------------------------------//
		AjcSnPrintFW(szid, AJCTSIZE(szid), L"%06u", (UW)MAjcGetWindowLong(hwnd, GWL_ID));
		//----- セクション名設定 ---------------------------------------------------------------------------//
		if (pProfileSect != NULL) AjcSnPrintFW(pW->PermSect, AJCTSIZE(pW->PermSect) 	, L"%s" 	, pProfileSect);
		else					  AjcSnPrintFW(pW->PermSect, AJCTSIZE(pW->PermSect) 	, L"SLbx%s" , szid		  );
		//----- キー接頭語設定 -----------------------------------------------------------------------------//
		if (pKeyPrefix	 != NULL) AjcSnPrintFW(pW->PermKey , AJCTSIZE(pW->PermKey ) - 32, L"%s" 	, pKeyPrefix);	// 32:後続キー名称の最大値
		else					  AjcSnPrintFW(pW->PermKey , AJCTSIZE(pW->PermKey ) - 32, L"Lbx_%s_", szid		);
	}
	return rc;
}

//==============================================================================================================//
//	全リスト項目のロード																						//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pSect		 - プロファイルセクション名															//
//				pKeyPrefix	 - プロファイルキー名称の先頭部分													//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxLoadItemsA	(HWND hwnd, C_BCP pSect, C_BCP pKeyPrefix)
{
	BOOL		rc	  = FALSE;
	UI			len   = 0;
	WCP			pTmpS = NULL;
	WCP			pTmpK = NULL;

	if (pSect != NULL && pKeyPrefix != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmpS = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmpS, len);
			len = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0);
			if (len != 0 && (pTmpK = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pTmpK, len);
				rc = AjcLbxLoadItemsW(hwnd, pTmpS, pTmpK);
			}
		}
		if (pTmpS != NULL) free(pTmpS);
		if (pTmpK != NULL) free(pTmpK);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxLoadItemsW	(HWND hwnd, C_WCP pSect, C_WCP pKeyPrefix)
{
	PWRKLISTBOX	pW;
	BOOL		rc	 = FALSE;
	int			i	 = 0;
	int			ix, nList;
	BOOL		fSel	= FALSE;
	UX			data	= 0;
	WCP			pszSel	= NULL;
	WCP			pszData = NULL;
	WC			szSec[256];
	WC			key[256];
	WC			txt[LBX_MAXLEN * 2 + 1];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pSect != NULL && pKeyPrefix != NULL) {
			//	プロファイルセクション名コピー
			AjcSnPrintFW(szSec, AJCTSIZE(szSec), L"%s", pSect);
			//	リスト項目数取得
			AjcSnPrintF(key , AJCTSIZE(key), L"%s_Cnt", pKeyPrefix);
			nList = AjcGetProfileUInt(szSec, key, -1);
			if (nList != -1) {
				//	リストボックスリセット
				SendMessage(pW->hLbx, LB_RESETCONTENT, 0, 0);
				//	最初の項目読み出し
				AjcSnPrintF(key, AJCTSIZE(key), L"%s_%06d",  pKeyPrefix, i++);
				AjcGetProfileStr(szSec, key, L"@@NONE@@", txt, LBX_MAXLEN);
				//	項目がある間ループ
				while (wcscmp(txt, L"@@NONE@@") != 0) {
					pszSel = AjcStrStripEnclose(txt);
					if (pszSel	!= NULL) pszSel  = AjcStrTokW(pszSel, L",");
					if (pszSel	!= NULL) pszData = AjcStrTokW(NULL	, L",");
					if (pszSel	!= NULL) fSel = _wtoi(pszSel);
					if (pszData != NULL) data = (UX)AjcHexToULL(pszData);
					if (pW->style & AJCLBXS_TRIM) AjcStrTrim(txt, txt, AJCTSIZE(txt));
					ix = (int)SendMessage(pW->hLbx, LB_ADDSTRING, 0, (LPARAM)txt);
					if (fSel) {
						if (pW->style & AJCLBXS_SINGLE) SendMessage(pW->hLbx, LB_SETCURSEL, ix	, 0 );
						else							SendMessage(pW->hLbx, LB_SETSEL   , TRUE, ix);
					}
					SendMessage(pW->hLbx, LB_SETITEMDATA, ix, (LPARAM)data);
					//	次の項目読み出し
					AjcSnPrintF(key, AJCTSIZE(key), L"%s_%06d",  pKeyPrefix, i++);
					AjcGetProfileStr(szSec, key, L"@@NONE@@", txt, LBX_MAXLEN);
				}
			}
			//----- 最大横幅設定 --------------------//
			LbxSetHoriExtentByAllItem(pW);

			rc = TRUE;
		}
	}

	return rc;
}
//==============================================================================================================//
//	全リスト項目のセーブ（セクション，キープリフィックス指定）													//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pSect		 - プロファイルセクション名															//
//				pKeyPrefix	 - プロファイルキー名称の先頭部分													//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxSaveItemsA(HWND hwnd, C_BCP pSect, C_BCP pKeyPrefix)
{
	BOOL		rc	  = FALSE;
	UI			len   = 0;
	WCP			pTmpS = NULL;
	WCP			pTmpK = NULL;

	if (pSect != NULL && pKeyPrefix != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (len != 0 && (pTmpS = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmpS, len);
			len = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0);
			if (len != 0 && (pTmpK = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pTmpK, len);
				rc = AjcLbxSaveItemsW(hwnd, pTmpS, pTmpK);
			}
		}
		if (pTmpS != NULL) free(pTmpS);
		if (pTmpK != NULL) free(pTmpK);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL			WINAPI	AjcLbxSaveItemsW(HWND hwnd, C_WCP pSect, C_WCP pKeyPrefix)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;
	int			nList, i, n;
	BOOL		fSel;
	ULL			data;
	WC			key[256];
	WC			tmp[LBX_MAXLEN * 2 + 1];
	WC			txt[LBX_MAXLEN * 2 + 16];
	WC			szSec[256];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pSect != NULL && pKeyPrefix != NULL) {
			//	プロファイルセクション名コピー
			AjcSnPrintFW(szSec, AJCTSIZE(szSec), L"%s", pSect);
			//	リストボックス項目数取得
			nList = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0);
			if (nList != LB_ERR) {
				//	リストボックス項目数セーブ
				AjcSnPrintF(key, AJCTSIZE(key), L"%s_Cnt", pKeyPrefix);
				AjcPutProfileUInt(pSect, key, nList);
				//	リストボックス項目セーブ
				if ((n = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
					for (i = 0; i < n; i++) {
						fSel = (BOOL)(SendMessage(pW->hLbx, LB_GETSEL	  , i, 0) != 0);
						data =	(ULL) SendMessage(pW->hLbx, LB_GETITEMDATA, i, 0);
						SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)txt);
						AjcStrEnclose(txt, tmp, AJCTSIZE(tmp), '\'');
						AjcSnPrintF(txt, AJCTSIZE(txt), L"%s%d,%llx", tmp, fSel != 0, data);
						AjcSnPrintF(key, AJCTSIZE(key), L"%s_%06d", pKeyPrefix, i);
						AjcPutProfileStr(pSect, key, txt);
					}
				}
				//	リストボックス項目が無い場合は、プロファイルの全項目削除
				else {
					i = 0;
				}
				//----- 現項目数以上のプロファイルキーを削除 ------------//
				AjcSnPrintF(key, AJCTSIZE(key), L"%s_%06d", pKeyPrefix, i);
				AjcGetProfileStr(pSect, key, L"$$AJCLBX_NONE$$", txt, AJCTSIZE(txt));
				while (wcscmp(txt, L"$$AJCLBX_NONE$$") != 0) {
					AjcDelProfileKey(pSect, key);
					i++;
					AjcSnPrintF(key, AJCTSIZE(key), L"%s_%06d", pKeyPrefix, i);
					AjcGetProfileStr(pSect, key, L"$$AJCLBX_NONE$$", txt, AJCTSIZE(txt));
				}
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト設定																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pTxt		 - ツールチップ・テキスト文字列のアドレス											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcLbxSetTipTextA (HWND hwnd, C_BCP pTxt)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (rc = SubSetTipTextA(&pW->pToolTipTxt, 0, pTxt)) {
			AjcTipTextAddW		   (hwnd, pW->pToolTipTxt);
			AjcTipTextSetShowAlways(hwnd, pW->fShowAlways);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcLbxSetTipTextW (HWND hwnd, C_WCP pTxt)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (rc = SubSetTipTextW(&pW->pToolTipTxt, 0, pTxt)) {
			AjcTipTextAddW		   (hwnd, pW->pToolTipTxt);
			AjcTipTextSetShowAlways(hwnd, pW->fShowAlways);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト取得																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pBuf		 - ツールチップ・テキスト文字列を格納するバッファのアドレス							//
//				lBuf		 - ツールチップ・テキスト文字列を格納するバッファの文字数							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcLbxGetTipTextA (HWND hwnd, BCP pBuf, UI lBuf)
{
	PWRKLISTBOX	pW;
	BOOL	rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = SubGetTipTextA(&pW->pToolTipTxt, 0, pBuf, lBuf);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcLbxGetTipTextW (HWND hwnd, WCP pBuf, UI lBuf)
{
	PWRKLISTBOX	pW;
	BOOL	rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = SubGetTipTextW(&pW->pToolTipTxt, 0, pBuf, lBuf);
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト表示条件設定																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				fShowAlways	 - ツールチップ・テキスト表示条件													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcLbxSetTipShowAlways(HWND hwnd, BOOL fShowAlways)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKLISTBOX	pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pW->fShowAlways = fShowAlways;
			AjcTipTextSetShowAlways(hwnd, pW->fShowAlways);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト表示条件取得																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	ツールチップ・テキスト表示条件																	//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcLbxGetTipShowAlways(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKLISTBOX	pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->fShowAlways;
		}
	}
	return rc;
}

//==============================================================================================================//
//	リストボックス項目の追加（ソートあり，同一文字列は追加不可）												//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pStr		 - 追加するリストボックス項目文字列のアドレス										//
//																												//
//	戻り値	：	≧０：追加したリストボックス項目のインデクス（０～）											//
//				＜０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxAddStringA		(HWND hwnd, C_BCP pStr)
{
	BOOL		rc	  = -1;
	UI			len   = 0;
	WCP			pTmp  = NULL;

	if (pStr != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pStr, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pStr, -1, pTmp, len);
			rc = AjcLbxAddStringW(hwnd, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxAddStringW		(HWND hwnd, C_WCP pStr)
{
	PWRKLISTBOX	pW;
	int			rc = -1;
	WC			str[LBX_MAXLEN];
	WC			txt[LBX_MAXLEN];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pStr != NULL) {
			AjcSnPrintF(str, LBX_MAXLEN, L"%s", pStr);
			if (AjcLbxFindString(hwnd, 0, str) < 0) {
				if ((pW->style & AJCLBXS_SORT ) && (pW->style & AJCLBXS_COMP_EXACT)) {	//	ソートあり＆英大小区別あり？
					int	n, i, ix;
					//	挿入位置検索
					n  = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0);
					ix = -1;
					for (i = 0; i < n; i++) {
						if (SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)txt) >= 0) {
							if (pW->style & AJCLBXS_SORT_EXACT) {	
								if (wcscmp(str, txt) < 0) {
									ix = i;
									break;
								}
							}
							else {
								if		(wcsicmp(str, txt) == 0) {
									ix = i + (wcscmp(str, txt) > 0);
									break;
								}
								else if (wcsicmp(str, txt) <= 0) {
									ix = i;
									break;
								}
							}
						}
					}
					//	項目挿入
					if (pW->style & AJCLBXS_TRIM) AjcStrTrimW(str, str, AJCTSIZE(str));
					rc = (int)SendMessage(pW->hLbx, LB_INSERTSTRING, ix, (LPARAM)str);
				}
				else {																	//	ソート無し／英大小区別無し？
					//	項目追加
					if (pW->style & AJCLBXS_TRIM) AjcStrTrimW(str, str, AJCTSIZE(str));
					rc = (int)SendMessage(pW->hLbx, LB_ADDSTRING, 0, (LPARAM)str);
				}
				LbxUpdHoriExtentByStrW(pW, str);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス項目の挿入（ソートなし，同一文字列は挿入不可）												//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 挿入位置のインデクス																//
//				pStr		 - 追加するリストボックス項目文字列のアドレス										//
//																												//
//	戻り値	：	≧０：挿入したリストボックス項目のインデクス（０～）											//
//				＜０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxInsertStringA		(HWND hwnd, UI ix, C_BCP pStr)
{
	PWRKLISTBOX	pW;
	int			rc = -1;
	BC			str[LBX_MAXLEN];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pStr != NULL) {
			AjcSnPrintFA(str, LBX_MAXLEN, "%s", pStr);
			if (AjcLbxFindStringA(hwnd, 0, str) < 0) {
				if (pW->style & AJCLBXS_TRIM) AjcStrTrimA(str, str, AJCTSIZE(str));
				rc = (int)SendMessageA(pW->hLbx, LB_INSERTSTRING, ix, (LPARAM)str);
				LbxUpdHoriExtentByStrA(pW, str);
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxInsertStringW		(HWND hwnd, UI ix, C_WCP pStr)
{
	PWRKLISTBOX	pW;
	int			rc = -1;
	WC			str[LBX_MAXLEN];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pStr != NULL) {
			AjcSnPrintFW(str, LBX_MAXLEN, L"%s", pStr);
			if (AjcLbxFindStringW(hwnd, 0, str) < 0) {
				if (pW->style & AJCLBXS_TRIM) AjcStrTrimW(str, str, AJCTSIZE(str));
				rc = (int)SendMessage(pW->hLbx, LB_INSERTSTRING, ix, (LPARAM)str);
				LbxUpdHoriExtentByStrW(pW, str);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	リストボックスのリスト初期化																				//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 挿入位置のインデクス																//
//				pList		 - 初期化するリスト群のアドレス（多重文字列）										//
//																												//
//	戻り値	：	TRUE ：指定項目は選択状態																		//
//				FALSE：指定項目は非選択状態																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxSetListA		(HWND hwnd, C_BCP pList)
{
	PWRKLISTBOX	pW;
	int			rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		//	リストリセット
		SendMessage(pW->hLbx, LB_RESETCONTENT, 0, 0);
		//	リスト追加
		if (pList != NULL) {
			C_BCP	p = pList;
			while (*p != 0) {
				AjcLbxAddStringA(pW->hBack, p);
				p += strlen(p);
				p++;
			}
		}
		rc = TRUE;
	}
	return rc;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxSetListW		(HWND hwnd, C_WCP pList)
{
	PWRKLISTBOX	pW;
	int			rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		//	リストリセット
		SendMessage(pW->hLbx, LB_RESETCONTENT, 0, 0);
		//	リスト追加
		if (pList != NULL) {
			C_WCP	p = pList;
			while (*p != 0) {
				AjcLbxAddStringW(pW->hBack, p);
				p += wcslen(p);
				p++;
			}
		}
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	リストボックス項目の削除																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 削除するリスト項目のインデクス（０～）											//
//																												//
//	戻り値	：	≧０：残ったリストボックス項目の個数															//
//				＜０：エラー																					//
//==============================================================================================================//
AJCEXPORT int	 WINAPI	AjcLbxDeleteString		(HWND hwnd, UI ix)
{
	PWRKLISTBOX	pW;
	int			rc = -1;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = (int)SendMessage(pW->hLbx, LB_DELETESTRING, ix, 0);
	}
	return rc;
}

//==============================================================================================================//
//	リストボックス項目の検索																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 検索を開始するインデクス（－１の場合は先頭から検索）								//
//				pStr		 - 検索する文字列のアドレス															//
//																												//
//	戻り値	：	≧０：見つかったリストボックス項目のインデクス（０～）											//
//				＜０：指定文字列が見つからない／エラー															//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxFindStringA		(HWND hwnd, UI ix, C_BCP pStr)
{
	BOOL		rc	  = -1;
	UI			len   = 0;
	WCP			pTmp  = NULL;

	if (pStr != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pStr, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pStr, -1, pTmp, len);
			rc = AjcLbxFindStringW(hwnd, ix, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxFindStringW		(HWND hwnd, UI ix, C_WCP pStr)
{
	PWRKLISTBOX	pW;
	int			rc = -1;
	int			n, i, j;
	BOOL		fFind;
	WC			txt[LBX_MAXLEN];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pStr != NULL) {
			if ((n = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
				for (i = 0, j = (((int)ix < 0 || (int)ix >= n) ? 0 : (int)ix); i < n; i++, j = ((j + 1) % n)) {
					if (SendMessage(pW->hLbx, LB_GETTEXT, j, (LPARAM)txt) >= 0) {
						if (pW->style & AJCLBXS_COMP_EXACT) fFind = (wcscmp (txt, pStr) == 0);
						else								fFind = (wcsicmp(txt, pStr) == 0);
						if (fFind) {rc = j; break;}
					}
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス項目の項目数取得																				//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	≧０：リストボックスの項目数（０～）															//
//				＜０：エラー																					//
//==============================================================================================================//
AJCEXPORT int	 WINAPI	AjcLbxGetCount			(HWND hwnd)
{
	PWRKLISTBOX	pW;
	int		rc = -1;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0);
	}

	return rc;
}
//==============================================================================================================//
//	選択されているリストボックス項目のインデクス取得（単一選択時のみ）											//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	≧０：選択されている項目のインデクス															//
//				＜０：エラー																					//
//==============================================================================================================//
AJCEXPORT int	 WINAPI	AjcLbxGetCurSel			(HWND hwnd)
{
	PWRKLISTBOX	pW;
	int			rc = -1;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = (int)SendMessage(pW->hLbx, LB_GETCURSEL, 0, 0);
	}

	return rc;
}
//==============================================================================================================//
//	リストボックス項目の選択状態取得																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - リストボックス項目のインデクス													//
//																												//
//	戻り値	：	TRUE ：指定項目は選択状態																		//
//				FALSE：指定項目は非選択状態																		//
//				＜０：エラー																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcLbxGetSel			(HWND hwnd, UI ix)
{
	PWRKLISTBOX	pW;
	int			rc = -1;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if ((rc = (int)SendMessage(pW->hLbx, LB_GETSEL, ix, 0)) > 0) {
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	選択されているリストボックス項目の個数取得（複数選択モード時のみ）											//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	≧０：選択されているリストボックス項目の個数													//
//				＜０：単一選択モード／エラー																	//
//==============================================================================================================//
AJCEXPORT int	 WINAPI	AjcLbxGetSelCount		(HWND hwnd)
{
	PWRKLISTBOX	pW;
	int			rc = -1;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pW->style & AJCLBXS_SINGLE) {
			rc = (int)(SendMessage(pW->hLbx, LB_GETCURSEL, 0, 0) >= 0);
		}
		else {
			rc = (int)SendMessage(pW->hLbx, LB_GETSELCOUNT, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス項目の取得																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 取得するリストボックス項目のインデクス（０～）									//
//				pBuf		 - 取得したリストボックス項目を格納するバッファのアドレス							//
//				lBuf		 - 取得したリストボックス項目を格納するバッファの文字数								//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcLbxGetTextA		(HWND hwnd, UI ix, BCP pBuf, UI lBuf)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;
	WC			txt[LBX_MAXLEN];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pBuf != NULL && lBuf > 0) {
			if (rc = AjcLbxGetTextW(hwnd, ix, txt, AJCTSIZE(txt))) {
				WideCharToMultiByte(CP_ACP, 0, txt, -1, pBuf, lBuf, NULL, NULL);
				pBuf[lBuf - 1] = 0;
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcLbxGetTextW		(HWND hwnd, UI ix, WCP pBuf, UI lBuf)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;
	int			len;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pBuf != NULL && lBuf > 0) {
			len = (int)SendMessage(pW->hLbx, LB_GETTEXTLEN, ix, 0);
			if (len >= 0 && len < (int)lBuf) {
				rc = ((int)SendMessage(pW->hLbx, LB_GETTEXT, ix, (LPARAM)pBuf) != LB_ERR);
				pBuf[lBuf - 1] = 0;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス項目の文字数取得																				//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 取得するリストボックス項目のインデクス（０～）									//
//																												//
//	戻り値	：	≧０：リストボックス項目の文字数																//
//				＜０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxGetTextLenA		(HWND hwnd, UI ix)
{
	PWRKLISTBOX	pW;
	int			rc = -1;
	BC			txt[LBX_MAXLEN];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (AjcLbxGetTextA(hwnd, ix, txt, AJCTSIZE(txt))) {
			rc = (int)strlen(txt);
		}
	}

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxGetTextLenW		(HWND hwnd, UI ix)
{
	PWRKLISTBOX	pW;
	int			rc = -1;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc =  (int)SendMessage(pW->hLbx, LB_GETTEXTLEN, ix, 0);
	}

	return rc;
}
//==============================================================================================================//
//	全リストボックス項目の消去																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcLbxResetContent		(HWND hwnd)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		SendMessage(pW->hLbx, LB_RESETCONTENT, 0, 0);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス項目の選択（文字列指定）																		//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 選択開始インデクス（－１の場合は全検索）											//
//				pStr		 - 検索する文字列のアドレス															//
//																												//
//	戻り値	：	≧０：見つかったリストボックス項目のインデクス（０～）											//
//				＜０：指定文字列が見つからない／エラー															//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxSelectStringA		(HWND hwnd, UI ix, C_BCP pStr)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;
	int			len;
	WCP			pTmp = NULL;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pStr != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pStr, -1, NULL, 0);
			if (len != 0 && (pTmp = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pStr, -1, pTmp, len);
				rc = AjcLbxSelectStringW(hwnd, ix, pTmp);
			}
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI	AjcLbxSelectStringW		(HWND hwnd, UI ix, C_WCP pStr)
{
	PWRKLISTBOX	pW;
	int			rc = -1;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pStr != NULL) {
			if ((rc = AjcLbxFindStringW(hwnd, ix, pStr)) >= 0) {
				if (pW->style & AJCLBXS_SINGLE) {
					SendMessage(pW->hLbx, LB_SETCURSEL, rc, 0);
				}
				else {
					SendMessage(pW->hLbx, LB_SETSEL, TRUE, rc);
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス項目数の設定																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				count		 - 設定する項目数																	//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcLbxSetCount			(HWND hwnd, UI count)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = ((int)SendMessage(pW->hLbx, LB_SETCOUNT, count, 0) >= 0);
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス項目の選択（インデクス指定）																	//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 選択状態にするリストボックス項目のインデクス（－１の場合は選択無し状態に設定）	//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcLbxSetCurSel			(HWND hwnd, UI ix)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pW->style & AJCLBXS_SINGLE) {
			rc = ((int)SendMessage(pW->hLbx, LB_SETCURSEL, ix, 0) != LB_ERR);
		}
		else {
			rc = ((int)SendMessage(pW->hLbx, LB_SETSEL, TRUE, ix) != LB_ERR);
		}
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス項目の選択／非選択状態設定																	//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 選択状態にするリストボックス項目のインデクス										//
//				fSelect		 - TRUE:選択状態に設定，FALSE:非選択状態に設定										//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcLbxSetSel			(HWND hwnd, UI ixItem, BOOL fSelect)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;
	int			ix = (int)ixItem;
	int			n;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (fSelect) {													//	選択状態にする？
			if (pW->style & AJCLBXS_SINGLE) {							//		単一選択モード？
				n = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0);		//			項目数取得
				if (ix >= 0 && ix < n) {								//			インデクスは範囲内？
					rc = ((int)SendMessage(pW->hLbx, LB_SETCURSEL, ix, 0) != LB_ERR);
				}
			}
			else {														//		複数選択モード？
				rc = ((int)SendMessage(pW->hLbx, LB_SETSEL, TRUE, ix) != LB_ERR);
			}
		}
		else {															//	非選択状態にする
			if (pW->style & AJCLBXS_SINGLE) {							//		単一選択モード？
				SendMessage(pW->hLbx, LB_SETCURSEL, -1, 0);
				rc = TRUE;
			}
			else {														//		複数選択モード？
				rc = ((int)SendMessage(pW->hLbx, LB_SETSEL, FALSE, ix) != LB_ERR);
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	リストボックス項目に数値を関連付ける																		//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 選択状態にするリストボックス項目のインデクス（－１の場合は選択無し状態に設定）	//
//				data		 - リストボックス項目に関連付ける数値												//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcLbxSetItemData		(HWND hwnd, UI ix, UX data)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = ((int)SendMessage(pW->hLbx, LB_SETITEMDATA, ix, data) != LB_ERR);
	}
	return rc;
}
//==============================================================================================================//
//	リストボックス項目に関連付けられた数値の取得																//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				ix			 - 選択状態にするリストボックス項目のインデクス（－１の場合は選択無し状態に設定）	//
//																												//
//	戻り値	：	リストボックス項目に関連付けられた数値															//
//==============================================================================================================//
AJCEXPORT UX	 WINAPI	AjcLbxGetItemData		(HWND hwnd, UI ix)
{
	PWRKLISTBOX	pW;
	UX			rc = -1;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = (UX)SendMessage(pW->hLbx, LB_GETITEMDATA, ix, 0);
	}
	return rc;
}
//==============================================================================================================//
//	相対アドレス変換時のベースディレクトリパス設定																//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pBasePath	 - ベースディレクトリパス（相対パス変換を使用しない場合はNULL）						//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcLbxSetBasePathA		(HWND hwnd, C_BCP pBasePath)
{
	PWRKLISTBOX	pW;
	BOOL		rc	 = FALSE;
	WCP			pTmp = NULL;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pBasePath != NULL  &&  *pBasePath != 0) {
			int len = MultiByteToWideChar(CP_ACP, 0, pBasePath, -1, NULL, 0);
			if (len != 0 && (pTmp = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pBasePath, -1, pTmp, len);
				rc = AjcLbxSetBasePathW(hwnd, pTmp);
			}
			if (pTmp != NULL) free(pTmp);
		}
		else {
			pW->BasePath[0] = 0;
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcLbxSetBasePathW		(HWND hwnd, C_WCP pBasePath)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;
	WC			path[MAX_PATH];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pBasePath != NULL  &&  *pBasePath != 0) {
			AjcSnPrintF(path, MAX_PATH, L"%s", pBasePath);
			if (AjcPathIsDirectory(path)) {
				AjcSnPrintF(pW->BasePath, MAX_PATH, L"%s", path);
				rc = TRUE;
			}
		}
		else {
			pW->BasePath[0] = 0;
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	右クリックによるポップアップメニュー有効項目の設定															//
//																												//
//	引　数	：	hwnd		  - ウインドハンドル																//
//				sel			  - 有効とする項目（AJCVTHMM_XXXXX）												//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcLbxSelMenuItems(HWND hwnd, UI sel)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKLISTBOX pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//	全て無効ならば、右クリック禁止
			if ((AJCVTHMM_ALL & sel) == 0) {
				AjcTchEnablePopupMenu(hwnd, FALSE);
			}
			//	有効とする項目設定
			else {
				pW->PopupMask = (AJCVTHMM_ALL & sel);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	右クリックによるポップアップメニュー除外項目の設定															//
//																												//
//	引　数	：	hwnd		  - ウインドハンドル																//
//				exc			  - 除外する項目（AJCVTHMM_XXXXX）													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcLbxExcMenuItems(HWND hwnd, UI exc)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKLISTBOX pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//	全て除外ならば、右クリック禁止
			if ((exc & AJCVTHMM_ALL) == AJCVTHMM_ALL) {
				AjcTchEnablePopupMenu(hwnd, FALSE);
			}
			//	一部除外ならば、除外項目設定
			else {
				pW->PopupMask = (AJCVTHMM_ALL & ~exc);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	右クリックによるポップアップメニューの許可／禁止															//
//																												//
//	引　数	：	hwnd		  - ウインドハンドル																//
//				fEnable		  - ポップアップメニューの許可／禁止												//
//									TRUE  : 許可（右クリック非通知，Shuft/Ctrl+右クリック通知）					//
//									FALSE : 禁止（全ての右クリック通知）										//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcLbxEnablePopupMenu(HWND hwnd, BOOL fEnable)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKLISTBOX pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			AjcLbxSetNtcRClk(hwnd, !fEnable, WM_RBUTTONDOWN, WM_RBUTTONUP);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	右クリック通知設定																							//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				fRClk		 - 右クリック通知フラグ（TRUE:通知する，FALSE:通知しない）							//
//				MsgRBDown	 - 右ボタン押下時の通知メッセージコード　（０の場合は非通知）						//
//				MSgRBUp		 - 右ボタン離され時の通知メッセージコード（０の場合は非通知）						//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcLbxSetNtcRClk	(HWND hwnd, BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		pW->fNtcRClk  = fNtcRClk;
		pW->MsgRBDown = MsgRBDown;
		pW->MsgRBUp	  = MsgRBUp;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ファイル選択時のフィルタ，デフォルト拡張子の設定															//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pFilter		 - フィルタ文字列のアドレス		（不要時はNULL）									//
//				pDefExt		 - デフォルト拡張子のアドレス	（不要時はNULL)										//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcLbxSetFileFilterA(HWND hwnd, C_BCP pFilter, C_BCP pDefExt)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pFilter != NULL) {
			MultiByteToWideChar(CP_ACP, 0, pFilter, -1, pW->FileFilter, AJCTSIZE(pW->FileFilter));
			pW->FileFilter[AJCTSIZE(pW->FileFilter) - 1] = 0;
		}
		if (pDefExt != NULL) {
			MultiByteToWideChar(CP_ACP, 0, pDefExt, -1, pW->FileDefExt, AJCTSIZE(pW->FileDefExt));
			pW->FileDefExt[AJCTSIZE(pW->FileDefExt) - 1] = 0;
		}
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcLbxSetFileFilterW(HWND hwnd, C_WCP pFilter, C_WCP pDefExt)
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pFilter != NULL) AjcSnPrintF(pW->FileFilter, AJCTSIZE(pW->FileFilter), L"%s", pFilter);
		if (pDefExt != NULL) AjcSnPrintF(pW->FileDefExt, AJCTSIZE(pW->FileDefExt), L"%s", pDefExt);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ドロップされたファイル名取得																				//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//				buf	  - ファイル名を格納するバッファのアドレス													//
//																												//
//	戻り値	：	TRUE:ファイル名あり，FALSE:ファイル名なし														//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedFileA (HWND hwnd, BC buf[MAX_PATH])
{
	BOOL	rc = FALSE;
	WC		tmp[MAX_PATH];

	if (buf != NULL) {
		if (rc = AjcLbxGetDroppedFileW(hwnd, tmp)) {
			WideCharToMultiByte(CP_ACP, 0, tmp, -1, buf, MAX_PATH, NULL, NULL);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedFileW (HWND hwnd, WC buf[MAX_PATH])
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;
	UI			bytes;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (buf != NULL) {
			if (AjcRngGetData(pW->hRngFile, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
				rc = (AjcRngGetData(pW->hRngFile, (VOP)buf, bytes) == bytes);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ドロップされたディレクトリ名取得																			//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//				buf	  - ディレクトリ名を格納するバッファのアドレス												//
//																												//
//	戻り値	：	TRUE:ディレクトリ名あり，FALSE:ディレクトリ名なし												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedDirA  (HWND hwnd, BC buf[MAX_PATH])
{
	BOOL	rc = FALSE;
	WC		tmp[MAX_PATH];

	if (buf != NULL) {
		if (rc = AjcLbxGetDroppedDirW(hwnd, tmp)) {
			WideCharToMultiByte(CP_ACP, 0, tmp, -1, buf, MAX_PATH, NULL, NULL);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedDirW  (HWND hwnd, WC buf[MAX_PATH])
{
	PWRKLISTBOX	pW;
	BOOL		rc = FALSE;
	UI			bytes;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (buf != NULL) {
			if (AjcRngGetData(pW->hRngDir, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
				rc = (AjcRngGetData(pW->hRngDir, (VOP)buf, bytes) == bytes);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ドロップされたディレクトリ名取得（末尾の「￥」付加指定付き）												//
//																												//
//	引　数	：	pW				 - インスタンスワークアドレス													//
//				buf				 - ディレクトリ名を格納するバッファのアドレス									//
//				fTailIsDelimiter - TRUE  : ディレクトリパスの末尾に「\」を付ける								//
//								   FALSE : ディレクトリパスの末尾に「\」を付けない								//
//																												//
//	戻り値	：	TRUE:ディレクトリ名あり，FALSE:ディレクトリ名なし												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedDirExA	(HWND hwnd, BC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	BOOL		rc = FALSE;
	WC			dir[MAX_PATH];

	if (rc = AjcLbxGetDroppedDirW(hwnd, dir)) {
		WideCharToMultiByte(CP_ACP, 0, dir, -1, buf, MAX_PATH, NULL, NULL);
		buf[MAX_PATH - 1] = 0;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLbxGetDroppedDirExW	(HWND hwnd, WC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	BOOL		rc = FALSE;

	if (rc = AjcLbxGetDroppedDirW(hwnd, buf)) {
		if (fTailIsDelimiter) AjcPathCat(buf, L"", MAX_PATH);
		else				  PathRemoveBackslashW(buf);
	}
	return rc;
}
//==============================================================================================================//
//	削除した項目の文字列取得																					//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//				buf	  - ディレクトリ名を格納するバッファのアドレス												//
//																												//
//	戻り値	：	TRUE:削除項目あり，FALSE:削除項目名なし（終端）													//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLbxGetRemovedItemA  (HWND hwnd, BCP pBuf, UI lBuf)
{
	PWRKLISTBOX	pW;
	BOOL		rc	  = FALSE;
	UI			bytes = 0;
	WC			txt[LBX_MAXLEN];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pBuf != NULL && lBuf != 0) {
			if (AjcRngGetData(pW->hRngDel, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
				if (rc = (AjcRngGetData(pW->hRngDel, (VOP)txt, bytes) == bytes)) {
					WideCharToMultiByte(CP_ACP, 0, txt, -1, pBuf, lBuf, NULL, NULL);
					pBuf[lBuf - 1] = 0;
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLbxGetRemovedItemW  (HWND hwnd, WCP pBuf, UI lBuf)
{
	PWRKLISTBOX	pW;
	BOOL		rc	  = FALSE;
	UI			bytes = 0;
	BC			txt[LBX_MAXLEN];

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pBuf != NULL && lBuf != 0) {
			if (AjcRngGetData(pW->hRngDel, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
				if (rc = (AjcRngGetData(pW->hRngDel, (VOP)txt, bytes) == bytes)) {
					AjcSnPrintF(pBuf, lBuf, L"%s", txt);
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	項目の高さ設定																								//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//				ix	  - リスト項目のインデクス																	//
//				height- 項目の高さ（ピクセル数，０：フォント高さ＋２）											//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI		AjcLbxSetItemHeight(HWND hwnd, UI ix, UI height)
{
	PWRKLISTBOX	pW;
	BOOL	rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = AjcSetCtrlLstHeight(pW->hLbx, ix, height);
	}
	return rc;
}
//==============================================================================================================//
//	項目の高さ取得																								//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//				ix	  - リスト項目のインデクス																	//
//																												//
//	戻り値：	≠－１：項目の高さ（ピクセル数）																//
//				＝－１：エラー																					//
//==============================================================================================================//
AJCEXPORT	UI	WINAPI		AjcLbxGetItemHeight(HWND hwnd, UI ix)
{
	PWRKLISTBOX	pW;
	BOOL	rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = AjcGetCtrlLstHeight(pW->hLbx, ix);
	}
	return rc;
}

//==============================================================================================================//
//	リストボックスのハンドル取得																				//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//																												//
//	戻り値：	≠－１：リストボックスのハンドル																//
//				＝－１：エラー																					//
//==============================================================================================================//
AJCEXPORT	HWND	WINAPI		AjcLbxGetLstHandle(HWND hwnd)
{
	PWRKLISTBOX	pW;
	HWND	rc = NULL;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = pW->hLbx;
	}
	return rc;
}
//==============================================================================================================//
//	リストボックスのＩＤ取得																					//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//																												//
//	戻り値：	≠0：リストボックスのＩＤ																		//
//				＝0：エラー																						//
//==============================================================================================================//
AJCEXPORT	UI	WINAPI		AjcLbxGetLstID(HWND hwnd)
{
	PWRKLISTBOX	pW;
	UI	rc = 0;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = IDC_LISTBOX;
	}
	return rc;
}


//==============================================================================================================//
//	メインウインドのハンドル取得																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pBkWnd		- ウインド背景色を格納するバッファへのポインタ（不要時はNULL）						//
//																												//
//	戻り値	：	≠NULL : メインウインドのハンドル																//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT	HWND	WINAPI		AjcLbxGetMainWindow(HWND hwnd, COLORREF *pBkGnd)
{
	PWRKLISTBOX	pW;
	HWND		rc = NULL;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		if (pBkGnd != NULL) {
			*pBkGnd = RGB(255, 255, 255);
		}
		rc = pW->hBack;
	}
	return rc;
}

//==============================================================================================================//
//																												//
//	通知情報取得																								//
//																												//
//==============================================================================================================//
//	リストボックスのスタイル
AJCEXPORT PAJCLBXLSTSTY	WINAPI	AjcLbxGetListStyle	(HWND hwnd)
{
	PWRKLISTBOX	pW;
	PAJCLBXLSTSTY	rc = NULL;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = &pW->LstSty;
	}
	return rc;
}
//	右クリック情報
AJCEXPORT PAJCLBXRCLK	WINAPI	AjcLbxGetNtcRClk	(HWND hwnd)
{
	PWRKLISTBOX	pW;
	PAJCLBXRCLK	rc = NULL;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = &pW->NtcRClk;
	}
	return rc;
}
//	ドロップしたディレクトリ数
AJCEXPORT UI			WINAPI	AjcLbxGetNtcDirs	(HWND hwnd)
{
	PWRKLISTBOX	pW;
	UI			rc = 0;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = pW->NtcDirs;
	}
	return rc;
}
//	ドロップしたファイル数
AJCEXPORT UI			WINAPI	AjcLbxGetNtcFiles	(HWND hwnd)
{
	PWRKLISTBOX	pW;
	UI			rc = 0;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = pW->NtcFiles;
	}
	return rc;
}

//	削除した項目数
AJCEXPORT UI			WINAPI	AjcLbxGetNtcRemovedItems(HWND hwnd)
{
	PWRKLISTBOX	pW;
	UI			rc = 0;

	if (IsWindow(hwnd) && (pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0)) && pW->InstID == LBX_INST_ID) {
		rc = pW->NtcDelItems;
	}
	return rc;
}
