﻿//**************************************************************************************************************//
//																												//
//	カスタムコントロール（リストボックス）					共通定義											//
//																												//
//**************************************************************************************************************//

#define		LBX_PROPNAME		L"AJCLISTBOX"
#define		LBX_INST_ID			0xCDEFA6A4
#define		IDC_LISTBOX			5000


//--------------------------------------------------------------------------------------------------------------//
//	最大文字列長																								//
//--------------------------------------------------------------------------------------------------------------//
#define		LBX_MAXLEN		AJCLBX_MAXSTL		//	リストボックス項目の最大長（文字列終端を含む）

//--------------------------------------------------------------------------------------------------------------//
//	ウインドワーク																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			InstID;						//	インスタンス識別ＩＤ
	//----- バックウインドハンドル／ウインドサイズ -------------------------------------------------------------//
	HWND		hBack;						//	バックウインドハンドル
	UI			bw, bh;						//	バックウインドの幅と高さ
	//----- リストボックスのサブクラス化情報 -------------------------------------------------------------------//
	HWND		hLbx;						//	リストボックス・ハンドル
	WNDPROC		WndProc;					//	オリジナルのウインドプロシージャ
	//----- オーナーウインドのフォント -------------------------------------------------------------------------//
	HFONT		hFont;
	//----- 状態変数 -------------------------------------------------------------------------------------------//
	UI			style;						//	コントロールのウインドスタイル
	BOOL		fEnable;					//	コントロールの有効状態
	BOOL		fFocus;						//	フォーカス状態フラグ
	//----- リストボックスへの設定スタイル ---------------------------------------------------------------------//
	AJCLBXLSTSTY LstSty;
	//----- ツールチップ情報 -----------------------------------------------------------------------------------//
	WCP			pToolTipTxt;				//	テキストボックスのツールヒントメッセージ
	BOOL		fShowAlways;				//	ツールヒント表示条件
	//----- 右クリックメニュー時の追加／編集項目情報 -----------------------------------------------------------//
	BOOL		fEdit;						//	ダイアログによる項目編集／追加の識別
	BOOL		fSort;						//	SORT属性
	int			ixEdit;						//	編集項目のインデクス
	WC			SvAddItem[LBX_MAXLEN];		//	追加／編集テキスト
	//----- 右クリック通知情報 ---------------------------------------------------------------------------------//
	BOOL		fNtcRClk;					//	右クリック通知フラグ（TRUE:通知する，FALSE:通知しない）
	UI			MsgRBDown;					//	右ボタンダウン時の通知メッセージコード
	UI			MsgRBUp;					//	右ボタンアップ時の通知メッセージコード
	UI			PopupMask;					//	ポップアップメニューのマスク
	//----- 文字列の最大横ピクセル数 ---------------------------------------------------------------------------//
	int			MaxHoriExt;
	//----- 相対パス変換時のベースパス（ディレクトリパス）------------------------------------------------------//
	WC			BasePath[MAX_PATH];
	//----- ファイル選択情報 -----------------------------------------------------------------------------------//
	WC			FilePath  [MAX_PATH];		//	初期表示ファイルパス
	WC			FileFilter[256];			//	フィルタ
	WC			FileDefExt[_MAX_EXT];		//	デフォルト拡張子
	//----- 通知情報 -------------------------------------------------------------------------------------------//
	AJCLBXRCLK	NtcRClk;					//	右クリック情報
	UI			NtcDirs;					//	ドロップしたディレクトリ数
	UI			NtcFiles;					//	ドロップしたファイル数
	UI			NtcDelItems;				//	削除した項目数
	//----- ドロップファイル名一時保留バッファ情報 -------------------------------------------------------------//
	HAJCRNG		hRngFile;					//	リングバッファハンドル
	UB			StaRngFile[1024];			//	スタティックリングバッファ
	//----- ドロップＤＩＲ名一時保留バッファ情報 ---------------------------------------------------------------//
	HAJCRNG		hRngDir;					//	リングバッファハンドル
	UB			StaRngDir[1024];			//	スタティックリングバッファ
	//----- 削除項目一時保留バッファ情報 -----------------------------------------------------------------------//
	HAJCRNG		hRngDel;					//	リングバッファハンドル
	UB			StaRngDel[1024];			//	スタティックリングバッファ
	//----- 永続化用ワーク -------------------------------------------------------------------------------------//
	WC			PermSect[256];				//	永続化情報記録用セクション名
	WC			PermKey [256];				//	永続化情報記録用キープリフィックス名
	//----------------------------------------------------------------------------------------------------------//
	BOOL		fErr;						//	エラーフラグワーク
} WRKLISTBOX, *PWRKLISTBOX;

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
extern	ATOM	LbxClassBack;
extern	ATOM	LbxClassMain;

//--------------------------------------------------------------------------------------------------------------//
//	グローバル サブ関数																							//
//--------------------------------------------------------------------------------------------------------------//
extern	WNDPROC		LbxWndProcBack();
extern	BOOL		LbxSetSubClass		(PWRKLISTBOX pW);
extern	VO			LbxDialogBoxEditItem(PWRKLISTBOX pW);
extern	VO			LbxDialogBoxAddItem (PWRKLISTBOX pW);

extern	int		LbxRepString			 (PWRKLISTBOX pW, WCP pTxt, int ixRep);
extern	UI		LbxSetHoriExtentByAllItem(PWRKLISTBOX pW);
extern	UI		LbxUpdHoriExtentByStrA	 (PWRKLISTBOX pW, C_BCP pStr);
extern	UI		LbxUpdHoriExtentByStrW	 (PWRKLISTBOX pW, C_WCP pStr);
extern	UI		LbxGetHoriExtentByStrA	 (HDC hdc, C_BCP pStr);
extern	UI		LbxGetHoriExtentByStrW	 (HDC hdc, C_WCP pStr);

