﻿#include	"AjcInternal.h"
#include	"AjcCtrlListBoxDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（リストボックス）					項目追加ダイアログ									//
//																												//
//**************************************************************************************************************//
AJC_DLGPROC_DEF(AddItem);

//==============================================================================================================//
//																												//
//	項目編集ダイアログボックス生成																				//
//																												//
//==============================================================================================================//
VO		LbxDialogBoxEditItem(PWRKLISTBOX pW)
{
	//	項目編集の旨、フラグ設定
	pW->fEdit = TRUE;
	//	ダイアログによる項目編集
	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_LBX_ADDITEM), pW->hBack, AJC_DLGPROC_NAME(AddItem), (LPARAM)pW);
}
//==============================================================================================================//
//																												//
//	項目追加ダイアログボックス生成																				//
//																												//
//==============================================================================================================//
VO		LbxDialogBoxAddItem(PWRKLISTBOX pW)
{
	//	項目追加の旨、フラグ設定
	pW->fEdit = FALSE;
	//	ダイアログによる項目追加
	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_LBX_ADDITEM), pW->hBack, AJC_DLGPROC_NAME(AddItem), (LPARAM)pW);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	リストボックス項目追加ダイアログプロシージャ																//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(AddItem, WM_INITDIALOG		)
{
	PWRKLISTBOX	pW	  = (PWRKLISTBOX)lParam;

	SetProp(hDlg, L"LbxAddItem", pW);

	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);

	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_ADDITEM, LBX_MAXLEN -1);

	AjcSetDlgItemStr(hDlg, IDC_CMD_DIRPATH , LNGSEL(L"ディレクトリ選択", L"Select folder"		));
	AjcSetDlgItemStr(hDlg, IDC_CMD_FILEPATH, LNGSEL(L"ファイル選択"	   , L"Select file"		));
	AjcSetDlgItemStr(hDlg, IDC_CMD_RELATIVE, LNGSEL(L"相対パスに変換"  , L"Change to relative"));

	if (pW->style & AJCLBXS_FILE) {
		if (!(pW->style & AJCLBXS_DIRPATH )) AjcEnableDlgItem(hDlg, IDC_CMD_DIRPATH , FALSE);
		if (!(pW->style & AJCLBXS_FILEPATH)) AjcEnableDlgItem(hDlg, IDC_CMD_FILEPATH, FALSE);
		if (!(pW->style & (AJCLBXS_DIRPATH | AJCLBXS_FILEPATH)) || pW->BasePath[0] == 0) {
			AjcEnableDlgItem(hDlg, IDC_CMD_RELATIVE, FALSE);
		}
	}
	else {
		ShowWindow(GetDlgItem(hDlg, IDC_CMD_DIRPATH ), SW_HIDE);
		ShowWindow(GetDlgItem(hDlg, IDC_CMD_FILEPATH), SW_HIDE);
		ShowWindow(GetDlgItem(hDlg, IDC_CMD_RELATIVE), SW_HIDE);
	}

	if (pW->fEdit) {
		SetWindowText(hDlg, LNGSEL(L"項目の編集", L"Edit selected item"));
		AjcSetDlgItemStr(hDlg, IDOK, LNGSEL(L"更 新", L"Update"));
		SendMessage(pW->hLbx, LB_GETTEXT, pW->ixEdit, (LPARAM)pW->SvAddItem);
		AjcSetDlgItemStr(hDlg, IDC_TXT_ADDITEM, pW->SvAddItem);
		SendMessage(GetDlgItem(hDlg, IDC_TXT_ADDITEM), EM_SETSEL, 0, -1);
	}
	else {
		SetWindowText(hDlg, LNGSEL(L"項目の追加", L"Add item"));
		AjcSetDlgItemStr(hDlg, IDOK, LNGSEL(L"追加", L"Add"));
		AjcSetDlgItemStr(hDlg, IDC_TXT_ADDITEM, pW->SvAddItem);
		SendMessage(GetDlgItem(hDlg, IDC_TXT_ADDITEM), EM_SETSEL, 0, -1);
	}
	SetFocus(GetDlgItem(hDlg, IDC_TXT_ADDITEM));

	return TRUE;
}
//----- ディレクトリ選択ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(AddItem, IDC_CMD_DIRPATH	)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hDlg, L"LbxAddItem");
	WC		path[MAX_PATH];

	if (AjcGetFolderName(hDlg, LNGSEL(L"フォルダ選択", L"Select a folder"), L"", path, (pW->style & AJCLBXS_DIRTAIL) != 0)) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_ADDITEM, path);
	}

	return TRUE;
}
//----- ファイル選択ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(AddItem, IDC_CMD_FILEPATH	)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hDlg, L"LbxAddItem");
	static WC	path[MAX_PATH] = {0};

	if (AjcGetOpenFile(hDlg, LNGSEL(L"ファイル選択", L"Select a file"), pW->FileFilter, pW->FileDefExt, path, MAX_PATH)) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_ADDITEM, path);
	}
	return TRUE;
}
//----- 相対パス変換ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(AddItem, IDC_CMD_RELATIVE	)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hDlg, L"LbxAddItem");
	WC		txt[LBX_MAXLEN];
	WC		relp[MAX_PATH];

	AjcGetDlgItemStr(hDlg, IDC_TXT_ADDITEM, txt, AJCTSIZE(txt));
	if (AjcPathExists(txt)) {
		DWORD	att;
		if (AjcPathIsDirectory(txt)) att = FILE_ATTRIBUTE_DIRECTORY;
		else						 att = FILE_ATTRIBUTE_NORMAL;
		if (PathRelativePathTo(relp, pW->BasePath, FILE_ATTRIBUTE_DIRECTORY, txt, att)) {
			relp[AJCTSIZE(relp) - 1] = 0;
			AjcSetDlgItemStr(hDlg, IDC_TXT_ADDITEM, relp);
		}
		else {
			MessageBoxW(hDlg, LNGSEL(L"相対パスに変換できません",
										  L"Do not change to relative path"), AppName, MB_ICONERROR);
		}
	}
	else {
		MessageBoxW(hDlg, LNGSEL(L"パスが存在しません",
									  L"Path does not exist"), AppName, MB_ICONERROR);
	}
	return TRUE;
}
//----- OK -----------------------------------------------------------------------------------------------------//
AJC_DLGPROC(AddItem, IDOK				)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hDlg, L"LbxAddItem");
	WC			txt[LBX_MAXLEN];

	AjcGetDlgItemStr(hDlg, IDC_TXT_ADDITEM, txt, AJCTSIZE(txt));
	if (AjcLbxFindString(pW->hBack, -1, txt) < 0) {
		//--- 項目編集 ----------------------------------------//
		if (pW->fEdit) {
			//--- 編集項目挿入 --------------------------------//
			LbxRepString(pW, txt, pW->ixEdit);
			//--- ダイアログ終了 ------------------------------//
			EndDialog(hDlg, IDCANCEL);
		}
		//--- 項目追加 ----------------------------------------//
		else {
			AjcGetDlgItemStr(hDlg, IDC_TXT_ADDITEM, txt, AJCTSIZE(txt));
			AjcLbxAddString(pW->hBack, txt);
			SendMessage(GetDlgItem(hDlg, IDC_TXT_ADDITEM), EM_SETSEL, 0, -1);
			SetFocus(GetDlgItem(hDlg, IDC_TXT_ADDITEM));
			//--- 最大横幅再設定 ------------------------------//
			LbxUpdHoriExtentByStrW(pW, txt);
		}
	}
	else {
		MessageBoxW(hDlg, LNGSEL(L"既に同一項目が登録されています",
								 L"The same item has already been registered."), AppName, MB_ICONERROR);
		SendMessage(GetDlgItem(hDlg, IDC_TXT_ADDITEM), EM_SETSEL, 0, -1);
		SetFocus(GetDlgItem(hDlg, IDC_TXT_ADDITEM));
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(AddItem, IDCANCEL			)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hDlg, L"LbxAddItem");

	AjcGetDlgItemStr(hDlg, IDC_TXT_ADDITEM, pW->SvAddItem, AJCTSIZE(pW->SvAddItem));

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(AddItem)
	AJC_DLGMAP_MSG(AddItem, WM_INITDIALOG		)

	AJC_DLGMAP_CMD(AddItem, IDC_CMD_DIRPATH		)
	AJC_DLGMAP_CMD(AddItem, IDC_CMD_FILEPATH	)
	AJC_DLGMAP_CMD(AddItem, IDC_CMD_RELATIVE	)
	AJC_DLGMAP_CMD(AddItem, IDOK				)
	AJC_DLGMAP_CMD(AddItem, IDCANCEL			)
AJC_DLGMAP_END
