﻿#include	"AjcInternal.h"
#include	"AjcCtrlListBoxDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（リストボックス）					グローバル サブ関数									//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//	項目置換																									//
//																												//
//	引	数	pW		- インスタンスワーク																		//
//			pTxt	- 置換文字列																				//
//			ixRep	- 置換項目のインデクス（－１：置換しないで追加／末尾に挿入）								//
//																												//
//	戻り値	≧0  - 置換した項目のインデクス（SORTスタイル時は、置換元項目のインデクスと異なる）					//
//			＜0  - 失敗																							//
//==============================================================================================================//
int		LbxRepString(PWRKLISTBOX pW, WCP pTxt, int ixRep)
{
	BOOL	rc		= ixRep;
	BOOL	fSelect = FALSE;
	UX		data	= 0;

	//--- 同一項目有無チェック ----------------------------//
	if (AjcLbxFindString(pW->hBack, -1, pTxt) < 0) {
		//--- 置換項目削除 --------------------------------//
		if (ixRep != -1) {
			//	置換項目のデータ退避
			data = SendMessage(pW->hLbx, LB_GETITEMDATA, ixRep, 0);
			//	置換項目の選択状態退避
			fSelect = (BOOL)(SendMessage(pW->hLbx, LB_GETSEL, ixRep, 0) > 0);
			//	置換項目削除
			SendMessage(pW->hLbx, LB_DELETESTRING, ixRep, 0);
		}
		//--- テキスト両端の空白除去 ----------------------//
		if (pW->style & AJCLBXS_TRIM) AjcStrTrim(pTxt, pTxt, (UI)wcslen(pTxt));
		//--- SORTスタイルならば編集項目追加 --------------//
		if (pW->fSort) {
			AjcLbxAddString(pW->hBack, pTxt);
			if ((rc = AjcLbxFindString(pW->hBack, -1, pTxt)) >= 0) {
				//	データ値設定
				SendMessage(pW->hLbx, LB_SETITEMDATA, rc, data );
				//	選択状態設定
				if (fSelect) {
					if (pW->style & AJCLBXS_SINGLE) SendMessage(pW->hLbx, LB_SETCURSEL, rc	, 0 );
					else							SendMessage(pW->hLbx, LB_SETSEL   , TRUE, rc);
				}
			}
		}
		//--- SORTスタイル以外ならば編集項目挿入 ---------//
		else {
			if ((rc = AjcLbxInsertString(pW->hBack, ixRep, pTxt)) > 0) {
				//	データ値設定
				SendMessage(pW->hLbx, LB_SETITEMDATA, rc, data );
				//	選択状態設定
				if (fSelect) {
					if (pW->style & AJCLBXS_SINGLE) SendMessage(pW->hLbx, LB_SETCURSEL, rc	 , 0	);
					else							SendMessage(pW->hLbx, LB_SETSEL   , TRUE , rc	);
				}
			}
		}
		//--- 最大横幅再設定 ------------------------------//
		LbxSetHoriExtentByAllItem(pW);

		rc = TRUE;
	}

	return rc;
}

//==============================================================================================================//
//																												//
//	リストボックス項目中の文字列の最大表示ビット数設定															//
//																												//
//==============================================================================================================//
UI		LbxSetHoriExtentByAllItem(PWRKLISTBOX pW)
{
	int		rc = 0;
	int		ext;
	HDC		hdc;
	int		i, n;
	HFONT	svFont = NULL;
	WC		txt[LBX_MAXLEN];

	hdc = GetDC(pW->hLbx);
	svFont = (HFONT)SelectObject(hdc, pW->hFont);
	if ((n = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
		for (i = 0; i < n; i++) {
			SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)txt);
			ext = LbxGetHoriExtentByStrW(hdc, txt);
			rc = __max(rc, ext);
		}
	}
	SelectObject(hdc, svFont);
	ReleaseDC(pW->hLbx, hdc);

	pW->MaxHoriExt = rc;
	SendMessage(pW->hLbx, LB_SETHORIZONTALEXTENT, pW->MaxHoriExt, 0);

	return rc;
}
//==============================================================================================================//
//																												//
//	追加文字列による最大表示ビット数更新																		//
//																												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
UI		LbxUpdHoriExtentByStrA(PWRKLISTBOX pW, C_BCP pStr)
{
	int		rc = 0;
	HDC		hdc;
	HFONT	svFont = NULL;

	hdc = GetDC(pW->hLbx);
	svFont = (HFONT)SelectObject(hdc, pW->hFont);
	rc	= LbxGetHoriExtentByStrA(hdc, pStr);
	if (rc > pW->MaxHoriExt) {
		pW->MaxHoriExt = rc;
		SendMessageA(pW->hLbx, LB_SETHORIZONTALEXTENT, pW->MaxHoriExt, 0);
	}
	SelectObject(hdc, svFont);
	ReleaseDC(pW->hLbx, hdc);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
UI		LbxUpdHoriExtentByStrW(PWRKLISTBOX pW, C_WCP pStr)
{
	int		rc = 0;
	HDC		hdc;
	HFONT	svFont = NULL;

	hdc = GetDC(pW->hLbx);
	svFont = (HFONT)SelectObject(hdc, pW->hFont);
	rc	= LbxGetHoriExtentByStrW(hdc, pStr);
	if (rc > pW->MaxHoriExt) {
		pW->MaxHoriExt = rc;
		SendMessage(pW->hLbx, LB_SETHORIZONTALEXTENT, pW->MaxHoriExt, 0);
	}
	SelectObject(hdc, svFont);
	ReleaseDC(pW->hLbx, hdc);

	return rc;
}
//==============================================================================================================//
//																												//
//	文字列の表示ビット数取得																					//
//																												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
UI		LbxGetHoriExtentByStrA(HDC hdc, C_BCP pStr)
{
	SIZE		sz, cw;

	//	'W'１文字分マージン
	cw.cx = 0;
	GetTextExtentPoint32A(hdc, "W", 1, &cw);
	//	文字列のビット数取得
	sz.cx = 0;
	GetTextExtentPoint32A(hdc, pStr, (int)strlen(pStr), &sz);

	return sz.cx + cw.cx;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
UI		LbxGetHoriExtentByStrW(HDC hdc, C_WCP pStr)
{
	SIZE		sz, cw;

	//	'W'１文字分マージン
	cw.cx = 0;
	GetTextExtentPoint32(hdc, L"W", 1, &cw);
	//	文字列のビット数取得
	sz.cx = 0;
	GetTextExtentPoint32(hdc, pStr, (int)wcslen(pStr), &sz);

	return sz.cx + cw.cx;
}


