﻿#include	"AjcInternal.h"
#include	"AjcCtrlListBoxDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（リストボックス）					バックウインド										//
//																												//
//**************************************************************************************************************//

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
extern	UI		WMSG_CTLCOLOR_LSI;		//	AJCM_CTLCOLOR_LSI メッセージコード
extern	UI		WMSG_CTLDRAW_LSI;		//	AJCM_CTLDRAW_LSI  メッセージコード
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);
static	VO		DeleteAllResource	  (PWRKLISTBOX pW);
static	VO		EnableCtrls			  (PWRKLISTBOX pW, BOOL fEnable);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		LbxWndProcBack()
{
	return AJC_WNDPROC_NAME(Back);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	バックウインドプロシージャ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE		)
{
	PWRKLISTBOX		pW;
	BOOL			rc = -1;
	RECT			r;

	do {
		//----- ウインドワーク生成 -----------------------------------------------------------------------------//
		if ((pW = (PWRKLISTBOX)AJCMEM(sizeof(WRKLISTBOX))) == NULL) break;
		memset(pW, 0, sizeof(WRKLISTBOX));
		//----- インスタンス識別ＩＤ設定 -----------------------------------------------------------------------//
		pW->InstID = LBX_INST_ID;
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//----- オーナーウインドのフォント取得 -----------------------------------------------------------------//
		pW->hFont = (HFONT)SendMessage(GetParent(hwnd), WM_GETFONT, 0, 0);
		//----- バックウインドハンドル／ウインドサイズ初期化 ---------------------------------------------------//
		pW->hBack = hwnd;													//	バックウインドハンドル
		GetClientRect(hwnd, &r);
		pW->bw = r.right - r.left;											//	バックウインドの幅
		pW->bh = r.bottom - r.top;											//	バックウインドの高さ
		//----- 状態変数初期化 ---------------------------------------------------------------------------------//
		pW->style		  		= (int)MAjcGetWindowLong(hwnd, GWL_STYLE);	//	ウインドスタイル
		pW->fEnable		  		= !(pW->style & WS_DISABLED);				//	コントロールの有効状態
		pW->fFocus		  		= FALSE;									//	フォーカス状態フラグ
		pW->FilePath[0]			= 0;										//	ファイル選択時の初期表示パス
		wcscpy(pW->FileFilter, L"Text(+.txt)/*.txt/All files(*.*)/*.*");	//	フィルタ
		wcscpy(pW->FileDefExt, L"txt");										//	デフォルト拡張子
		
		pW->PopupMask = AJCLBXMM_ALL;										//	ポップアップメニュー項目

		//----- ドロップファイル名一時保留バッファ生成 ---------------------------------------------------------//
		pW->hRngFile = AjcRngCreate(&pW->StaRngFile, sizeof pW->StaRngFile, 4096);
		if (pW->hRngFile == NULL) break;
		//----- ドロップＤＩＲ名一時保留バッファ生成 -----------------------------------------------------------//
		pW->hRngDir	 = AjcRngCreate(&pW->StaRngDir , sizeof pW->StaRngDir , 4096);
		if (pW->hRngDir	 == NULL) break;
		//----- 削除項目一時保留バッファ生成 -------------------------------------------------------------------//
		pW->hRngDel	 = AjcRngCreate(&pW->StaRngDel , sizeof pW->StaRngDel , 4096);
		if (pW->hRngDel	 == NULL) break;
		//----- リストボックス生成 -----------------------------------------------------------------------------//
		pW->LstSty.exs = 0;
		if (pW->style & AJCLBXS_ACCEPTALL) pW->LstSty.exs |= WS_EX_ACCEPTFILES;
		if (pW->style & AJCLBXS_RIGHT	 ) pW->LstSty.exs |= WS_EX_RIGHT;

		pW->LstSty.sty = WS_CHILD | WS_VISIBLE | WS_HSCROLL | LBS_STANDARD | LBS_EXTENDEDSEL | LBS_HASSTRINGS;
		if (pW->style & AJCLBXS_SORT  ) pW->LstSty.sty |=  LBS_SORT;
		else							pW->LstSty.sty &= ~LBS_SORT;
		if (pW->style & AJCLBXS_SINGLE) pW->LstSty.sty &= ~(LBS_EXTENDEDSEL | LBS_MULTIPLESEL);
		else							pW->LstSty.sty |=  (LBS_EXTENDEDSEL | LBS_MULTIPLESEL);

		//	リストボックススタイル問い合わせ
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCLBXN_LISTSTYLE),
						fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)&pW->LstSty);

		//	リストボックスウインド生成
		pW->hLbx = CreateWindowEx(pW->LstSty.exs,
								  L"listbox",
								  NULL,
								  pW->LstSty.sty,
								  0,
								  0,
								  pW->bw,
								  pW->bh,
								  hwnd,
								  (HMENU)IDC_LISTBOX,
								  hDllInst,
								  NULL);
		AJCTIP_SETFRIENDA(pW->hLbx);
		SendMessage 	 (pW->hLbx, WM_SETFONT, (WPARAM)pW->hFont, 0);
		//----- リストボックスへ、拡張リストボックスのハンドルを登録 -------------------------------------------//
		SetProp(pW->hLbx, L"_AJCPROP_LBX_HANDLE_", (HANDLE)hwnd);
		//----- チップテキスト表示条件 -------------------------------------------------------------------------//
		pW->fShowAlways = TRUE;

		//----- リストボックスにインスタンスワークを関連付ける -------------------------------------------------//
		SetProp(pW->hLbx, LBX_PROPNAME, (HANDLE)pW);

		//----- リストボックスのサブクラス化 -------------------------------------------------------------------//
		if (!LbxSetSubClass(pW)) break;

		//----- コントロールの有効状態設定 ---------------------------------------------------------------------//
		EnableCtrls(pW, pW->fEnable = !(pW->style & WS_DISABLED));

		//----- ツールチップテキスト初期化（右クリック禁止時は、該当しないため、ツールチップ初期化は行わない）--//
//		if		((pW->style & AJCLBXS_ACCEPTALL) == AJCLBXS_ACCEPTALL) {
//			AjcTipTextAdd(hwnd, LNGSEL(L"ディレクトリやファイルをドロップするか、右クリックによるポップアップメニューで項目を追加／編集できます",
//									   L"You can drop a directory or file, or add / edit items with a right-click popup menu."));
//		}
//		else if (pW->style & AJCLBXS_ACCEPTDIRS) {
//			AjcTipTextAdd(hwnd, LNGSEL(L"ディレクトリをドロップするか、右クリックによるポップアップメニューで項目を追加／編集できます",
//									   L"You can drop the directory, or add / edit items in the right-click popup menu."));
//		}
//		else if (pW->style & AJCLBXS_ACCEPTFILES) {
//			AjcTipTextAdd(hwnd, LNGSEL(L"ファイルをドロップするか、右クリックによるポップアップメニューで項目を追加／編集できます",
//									   L"You can drop the file, or add / edit items in the right-click popup menu."));
//		}
//		else {
//			AjcTipTextAdd(hwnd, LNGSEL(L"右クリックによるポップアップメニューで項目を追加／編集できます",
//									   L"You can add / edit items with right-click popup menu."));
//		}

		//----- 戻り値＝正常終了 -------------------------------------------------------------------------------//
		rc = 0;

	} while(0);

	if (rc == -1) {
		DeleteAllResource(pW);
		MAjcSetWindowLong(hwnd, 0, (UX)NULL);
	}

	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY	)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);

	if (pW != NULL) {
		DeleteAllResource(pW);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZE		)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);

	//----- ウインドサイズ設定 -----------------------------//
	pW->bw = LOWORD(lParam);
	pW->bh = HIWORD(lParam);
	MoveWindow(pW->hLbx, 0, 0, pW->bw, pW->bh, TRUE);
	InvalidateRect(hwnd, NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXTLENGTH)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
	int			rc = 0;

	rc = GetWindowTextLength(pW->hBack);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_ENABLE)
{
	PWRKLISTBOX		pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);

	pW->fEnable = (BOOL)wParam;
	EnableCtrls(pW, (BOOL)wParam);
	InvalidateRect(hwnd, NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETFOCUS)
{
	PWRKLISTBOX		pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);

	if (pW->hLbx) {
		SetFocus(pW->hLbx);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETFONT)
{
	PWRKLISTBOX		pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);

	if (pW->hLbx) {
		pW->hFont = (HFONT)wParam;
		SendMessage(pW->hLbx, WM_SETFONT, wParam, lParam);
		LbxSetHoriExtentByAllItem(pW);
		InvalidateRect(hwnd, NULL, TRUE);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_COMMAND)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
	UI			id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);

	switch (HIWORD(wParam)) {
		case LBN_DBLCLK:	SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_DBLCLK)	 , (LPARAM)pW->hBack); break;
		case LBN_ERRSPACE:	SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_ERRSPACE) , (LPARAM)pW->hBack); break;
		case LBN_KILLFOCUS:	SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_KILLFOCUS), (LPARAM)pW->hBack); break;
		case LBN_SELCANCEL:	SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_SELCANCEL), (LPARAM)pW->hBack); break;
		case LBN_SELCHANGE:	SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_SELCHANGE), (LPARAM)pW->hBack); break;
		case LBN_SETFOCUS:	SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_SETFOCUS) , (LPARAM)pW->hBack); break;
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_STYLECHANGED)
{
	PWRKLISTBOX		pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
	LPSTYLESTRUCT	p  = (LPSTYLESTRUCT)lParam;

	switch (wParam) {
		case GWL_EXSTYLE:
			break;

		case GWL_STYLE:
		{	int		sty;

			//	新スタイル設定（AJCLBXS_RIGHT, AJCLBXS_SORT, AJCLBXS_SINGLE はウインド生成時のみ有効である為、元の値を維持）
			sty = (pW->style & (AJCLBXS_RIGHT | AJCLBXS_SORT | AJCLBXS_SINGLE));
			pW->style  = p->styleNew;
			pW->style &= ~(AJCLBXS_RIGHT | AJCLBXS_SORT | AJCLBXS_SINGLE);
			pW->style |= sty;

			//	WS_EX_ACCEPTFILES 拡張スタイル設定
			sty = (int)MAjcGetWindowLong(pW->hLbx, GWL_EXSTYLE);
			if (pW->style & AJCLBXS_ACCEPTALL) sty |=  WS_EX_ACCEPTFILES;
			else							   sty &= ~WS_EX_ACCEPTFILES;
			MAjcSetWindowLong(pW->hLbx, GWL_EXSTYLE, sty);

			break;
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_PAINT)
{
	PAINTSTRUCT		ps;
	HDC				hdc;
	RECT			cr;
	AJCDLGCOLORS	Colors;
	HBRUSH			hBrush;
	HPEN			hPen;

	hdc	  = BeginPaint(hwnd, &ps);
	//	ダイアログカラー設定時は、背景描画
	if (AjcDgcGetColorInfo(&Colors, NULL)) {
		hBrush = (HBRUSH)SelectObject(hdc, CreateSolidBrush(Colors.ccBkGnd));
		hPen   = (HPEN	)SelectObject(hdc, GetStockObject  (NULL_PEN));
		GetClientRect(hwnd, &cr);
		Rectangle(hdc, cr.left, cr.top, cr.right, cr.bottom);
		DeleteObject(SelectObject(hdc, hBrush));
		SelectObject(hdc, hPen);
	}
	EndPaint(hwnd, &ps);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_MEASUREITEM	)	//	このファンクションは実行されません
{
	PWRKLISTBOX		pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
	SendMessage(GetParent(pW->hBack), WM_MEASUREITEM, wParam, lParam);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DRAWITEM		)	//	このファンクションは実行されません
{
	PWRKLISTBOX		pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
	SendMessage(GetParent(pW->hBack), WM_DRAWITEM, wParam, lParam);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, AJCM_CTLCOLOR_LSI	)
{
	PWRKLISTBOX		pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
	LRESULT			rc = SendMessage(GetParent(pW->hBack), RegisterWindowMessage(AJCM_CTLCOLOR_LSI_STR), wParam, lParam);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, AJCM_CTLDRAW_LSI	)
{
	PWRKLISTBOX		pW = (PWRKLISTBOX)MAjcGetWindowLong(hwnd, 0);
	LRESULT			rc = SendMessage(GetParent(pW->hBack), RegisterWindowMessage(AJCM_CTLDRAW_LSI_STR), wParam, lParam);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE			)
	AJC_WNDMAP_MSG(Back, WM_DESTROY			)
	AJC_WNDMAP_MSG(Back, WM_SIZE			)
	AJC_WNDMAP_MSG(Back, WM_GETTEXTLENGTH	)
	AJC_WNDMAP_MSG(Back, WM_ENABLE			)
	AJC_WNDMAP_MSG(Back, WM_SETFOCUS		)
	AJC_WNDMAP_MSG(Back, WM_SETFONT			)
	AJC_WNDMAP_MSG(Back, WM_COMMAND			)
	AJC_WNDMAP_MSG(Back, WM_STYLECHANGED	)
	AJC_WNDMAP_MSG(Back, WM_PAINT			)

//	AJC_WNDMAP_MSG(Back, WM_MEASUREITEM		)	//	このメッセージはデフォルトのウインドプロシージャ実行の為、パス不要
//	AJC_WNDMAP_MSG(Back, WM_DRAWITEM		)	//	このメッセージは、最上位のウインドへ送信される為、パス不要
	AJC_WNDMAP_CLI(Back, AJCM_CTLCOLOR_LSI	)
	AJC_WNDMAP_DLI(Back, AJCM_CTLDRAW_LSI	)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	全リソース開放																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DeleteAllResource(PWRKLISTBOX pW)
{
	if (pW != NULL) {
		RemoveProp(pW->hLbx, L"_AJCPROP_LBX_HANDLE_");
		if (pW->hRngFile	!= NULL) {AjcRngDelete(pW->hRngFile);	pW->hRngFile	= NULL;}
		if (pW->hRngDir		!= NULL) {AjcRngDelete(pW->hRngDir );	pW->hRngDir		= NULL;}
		if (pW->hRngDel		!= NULL) {AjcRngDelete(pW->hRngDel );	pW->hRngDel		= NULL;}
		if (pW->hLbx		!= NULL) {DestroyWindow(pW->hLbx);		pW->hLbx	 	= NULL;}
		if (pW->pToolTipTxt != NULL) {free(pW->pToolTipTxt);		pW->pToolTipTxt	= NULL;}
		free(pW);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロールの有効状態設定																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		EnableCtrls(PWRKLISTBOX pW, BOOL fEnable)
{
	EnableWindow(pW->hBack, fEnable);
	if (pW->hLbx) {
		EnableWindow(pW->hLbx , fEnable);
	}
	InvalidateRect(pW->hBack, NULL, FALSE);
}

