﻿#include	"AjcInternal.h"
#include	"AjcCtrlListBoxDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（リストボックス）					リストボックス（サブクラス）						//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(ListBox);

//	ポップアップメニュー・アクション
static	VO	IdmEditItem		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmAddItem		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmSelAll		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmDeSelAll		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmDelete		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmClear		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmCopyAll		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmCopySel		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmPaste		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmAddFiles		(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmToRelative	(PWRKLISTBOX pW, HWND hwnd);
static	VO	IdmToAbsolute	(PWRKLISTBOX pW, HWND hwnd);

//==============================================================================================================//
//																												//
//	コントロールのサブクラス化																					//
//																												//
//==============================================================================================================//
BOOL	LbxSetSubClass(PWRKLISTBOX pW)
{
	BOOL	rc = FALSE;

	if (MAjcMmpSetSubclass(ListBox, pW->hLbx) != NULL) {
		rc = TRUE;
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	リストボックス・ウインドプロシージャ（サブクラス）															//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- 左クリック ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(ListBox, WM_LBUTTONDOWN		)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hwnd, LBX_PROPNAME);

	//----- ツールチップ制御用にメインウインドへ通知 ----------------------------------//
	SendMessage(pW->hBack, msg, wParam, lParam);

	return MAjcMmpCallOrgWndProc(ListBox);
}
//----- 中クリック ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(ListBox, WM_MBUTTONDOWN		)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hwnd, LBX_PROPNAME);

	//----- ツールチップ制御用にメインウインドへ通知 ----------------------------------//
	SendMessage(pW->hBack, msg, wParam, lParam);

	return MAjcMmpCallOrgWndProc(ListBox);
}
//----- 右クリック ---------------------------------------------------------------------------------------------//
enum {
	IDM_EDTITEM	=	5001,		//	項目編集
	IDM_ADDITEM			,		//	項目追加
	IDM_SELALL			,		//	全て選択
	IDM_DESELALL		,		//	選択解除
	IDM_DELETE			,		//	選択項目削除
	IDM_CLEAR			,		//	リセット
	IDM_COPYALL			,		//	全てコピー
	IDM_COPYSEL			,		//	選択項目コピー
	IDM_PASTE			,		//	貼り付け
	IDM_ADDFILES		,		//	ファイル追加
	IDM_TO_RELATIVE		,		//	相対パスに変化
	IDM_TO_ABSOLUTE		,		//	絶対パスに変化
};

AJC_WNDPROC(ListBox, WM_RBUTTONDOWN		)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hwnd, LBX_PROPNAME);
	HMENU		hMenu;
	int			id;
	POINT		pt;
	int			sty 	  = (int)MAjcGetWindowLong(pW->hLbx, GWL_STYLE);
	BOOL		fFile	  =  (pW->style & AJCLBXS_FILE	  );
	BOOL		fMult	  = !(pW->style & AJCLBXS_SINGLE  );
	BOOL		fFilePath =  (pW->style & AJCLBXS_FILEPATH);
	BOOL		fSel;

	//----- ツールチップ制御用にメインウインドへ通知 ----------------------------------//
	SendMessage(pW->hBack, msg, wParam, lParam);

	//----- SORT属性フラグ設定 --------------------------------------------------------//
	pW->fSort = ((sty & LBS_SORT) != 0);
	//----- 選択項目の有無フラグ設定 --------------------------------------------------//
	fSel  = (sty & LBS_MULTIPLESEL) ? ((int)SendMessage(pW->hLbx, LB_GETSELCOUNT, 0, 0) > 0) :
									  ((int)SendMessage(pW->hLbx, LB_GETCURSEL	, 0, 0) != LB_ERR);

	//	右クリック通知設定時（親ウインドへ専用メッセージ通知）
	if (pW->fNtcRClk) {
		if (pW->MsgRBDown != 0) {
			PostMessage(GetParent(pW->hBack), pW->MsgRBDown, wParam, lParam);
		}
	}
	//	CTRL/SHIFT 押下時（親ウインドへWM_COMMAND(AJCLBXN_RCLICK)通知）
	else if (wParam & (MK_CONTROL | MK_SHIFT)) {
		pW->NtcRClk.x		= (SW)LOWORD(lParam);
		pW->NtcRClk.y		= (SW)HIWORD(lParam);
		pW->NtcRClk.fShift	= ((wParam & MK_SHIFT  ) != 0);
		pW->NtcRClk.fCtrl	= ((wParam & MK_CONTROL) != 0);
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCLBXN_RCLICK),
						fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)&pW->NtcRClk);
	}
	//	CTRL/SHIFT 未押下時（ポップアップメニュー）
	else {
		//	ポップアップメニュー表示
		hMenu = CreatePopupMenu();
		//	クリック地点の項目インデクス取得
		pW->ixEdit = (int)SendMessage(pW->hLbx, LB_ITEMFROMPOINT, 0, lParam);
		//	●項目編集，項目追加
		if (pW->PopupMask & AJCOPT2(AJCLBXMM_, EDTITEM, ADDITEM)) {
			BOOL	fSep = FALSE;
			//	・項目編集
			if (pW->PopupMask & AJCLBXMM_EDTITEM) {
				if (pW->ixEdit >= 0 && pW->ixEdit < (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) {
					AppendMenu	(hMenu, MFT_STRING, IDM_EDTITEM , LNGSEL(L"項目編集(&E)"		, L"Edit item(&E)"));
					fSep = TRUE;
				}
			}
			if (pW->PopupMask & AJCLBXMM_ADDITEM) {
				AppendMenu		(hMenu, MFT_STRING, IDM_ADDITEM , LNGSEL(L"項目追加(&N)\t^N"	, L"Add item(&N)\t^N"));
				fSep = TRUE;
			}
			//	・セパレータ
			if (fSep) {
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			}
		}
		//	●すべて選択，選択解除
		if (pW->PopupMask & AJCOPT2(AJCLBXMM_, SELALL, DESELALL)) {
			BOOL	fSep = FALSE;
			//	・すべて選択
			if (pW->PopupMask & AJCLBXMM_SELALL) {
				if (fMult		 )	{AppendMenu(hMenu, MFT_STRING, IDM_SELALL  , LNGSEL(L"全て選択(&A)\t"	, L"Select all(&A)\t^A"));			fSep = TRUE;}
			}
			//	・選択解除
			if (pW->PopupMask & AJCLBXMM_DESELALL) {
				if (		 fSel)	{AppendMenu(hMenu, MFT_STRING, IDM_DESELALL, LNGSEL(L"選択解除(&K)\t^K"	, L"Selection Release(&K(\t^K"));	fSep = TRUE;}
			}
			//	・セパレータ
			if (fSep) {
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			}
		}
		//	●選択項目削除、リセット
		if (pW->PopupMask & AJCOPT2(AJCLBXMM_, DELETE, CLEAR)) {
			BOOL	fSep = FALSE;
			//	・選択項目削除
			if (pW->PopupMask & AJCLBXMM_DELETE) {
				if (fSel)	{AppendMenu	(hMenu, MFT_STRING, IDM_DELETE , LNGSEL(L"選択項目削除(&D)"	, L"Delete all selected items(&D)"));	fSep = TRUE;}
			}
			//	・リセット
			if (pW->PopupMask & AJCLBXMM_CLEAR) {
				AppendMenu				(hMenu, MFT_STRING, IDM_CLEAR	, LNGSEL(L"リセット(&R)"		, L"Reset(&R)"));					fSep = TRUE;
			}
			//	・セパレータ
			if (fSep) {
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			}
		}
		//	●全てコピー、選択項目コピー、貼り付け
		if (pW->PopupMask & AJCOPT3(AJCLBXMM_, COPYALL, COPYSEL, PASTE)) {
			BOOL	fSep = FALSE;
			//	・全てコピー
			if (pW->PopupMask & AJCLBXMM_COPYALL) {
				AppendMenu				(hMenu, MFT_STRING, IDM_COPYALL , LNGSEL(L"全てコピー(&I)\t^I" 	, L"Copy all(&I)\t^I"));				fSep = TRUE;
			}
			//	・選択項目コピー
			if (pW->PopupMask & AJCLBXMM_COPYSEL) {
				if (fSel)	{AppendMenu	(hMenu, MFT_STRING, IDM_COPYSEL , LNGSEL(L"選択項目コピー(&C)\t^C", L"Copy selected Items(&C)\t^C"));	fSep = TRUE;}
			}
			//	・貼り付け
			if (pW->PopupMask & AJCLBXMM_PASTE) {
				AppendMenu				(hMenu, MFT_STRING, IDM_PASTE	, LNGSEL(L"貼り付け(&V)\t^V"	  	, L"Paste(&V)\t^V"));				fSep = TRUE;
			}
			//	・セパレータ
			if (fSep) {
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			}
		}
		//	●ファイル追加
		if (pW->PopupMask & AJCLBXMM_ADDFILES) {
			BOOL	fSep = FALSE;
			//	・ファイル追加
			if (		!fSel) {
				if (fFile && fFilePath) {
					AppendMenu(hMenu, MFT_STRING, IDM_ADDFILES, LNGSEL(L"ファイル追加(&F)\t^F"	, L"Insert Files(&F)\t^F"));	fSep = TRUE;
				}
			}
			//	・セパレータ
			if (fSep) {
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			}
		}
		//	●相対／絶対パスに変換
		if (pW->PopupMask & AJCOPT2(AJCLBXMM_, TO_RELATIVE, TO_ABSOLUTE)) {
			BOOL	fSep = FALSE;
			if (fFile && fSel) {
				if (pW->BasePath[0] != 0) {
					//	・相対パスに変換
					if (pW->PopupMask & AJCLBXMM_TO_RELATIVE) {
						AppendMenu(hMenu, MFT_STRING, IDM_TO_RELATIVE, LNGSEL(L"選択項目を相対パスに変換(&L)", L"Change to relative path(&L)"));
						fSep = TRUE;
					}
					//	・絶対パスに変換
					if (pW->PopupMask &AJCLBXMM_TO_ABSOLUTE) {
						AppendMenu(hMenu, MFT_STRING, IDM_TO_ABSOLUTE, LNGSEL(L"選択項目を絶対パスに変換(&T)", L"Change to absolute path(&T)"));
						fSep = TRUE;
					}
				}
			}
		}
		//	メニューの最後がセパレータである場合削除
		{	int	n;
			if ((n = GetMenuItemCount(hMenu)) > 0) {
				if (GetMenuItemID(hMenu,  n - 1) == 0) {
					DeleteMenu(hMenu,  n - 1, MF_BYPOSITION);
				}
			}
		}
		//	メニュー表示
		GetCursorPos(&pt);
		id = AjcDgcTrackPopupMenuEx(hMenu, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, pW->hBack, NULL);
		DestroyMenu(hMenu);

		//	メニューアクション
		switch (id) {
			case IDM_EDTITEM:		IdmEditItem		(pW, hwnd);		break;		//	項目編集
			case IDM_ADDITEM:		IdmAddItem		(pW, hwnd);		break;		//	項目追加
			case IDM_SELALL:		IdmSelAll		(pW, hwnd);		break;		//	全て選択
			case IDM_DESELALL:		IdmDeSelAll		(pW, hwnd);		break;		//	選択解除
			case IDM_DELETE:		IdmDelete		(pW, hwnd);		break;		//	全選択項目の削除
			case IDM_CLEAR:			IdmClear		(pW, hwnd);		break;		//	クリアー
			case IDM_COPYALL:		IdmCopyAll		(pW, hwnd);		break;		//	全項目のコピー
			case IDM_COPYSEL:		IdmCopySel		(pW, hwnd);		break;		//	選択項目のコピー
			case IDM_PASTE:			IdmPaste		(pW, hwnd);		break;		//	貼り付け
			case IDM_ADDFILES:		IdmAddFiles		(pW, hwnd);		break;		//	複数ファイル追加
			case IDM_TO_RELATIVE:	IdmToRelative	(pW, hwnd);		break;		//	相対パスに変換
			case IDM_TO_ABSOLUTE:	IdmToAbsolute	(pW, hwnd);		break;		//	絶対パスに変換
		}
	}
	return 0;		//	右クリックはインターセプトする
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(ListBox, WM_RBUTTONUP		)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hwnd, LBX_PROPNAME);

	if (pW->fNtcRClk) {
		if (pW->MsgRBUp != 0) {
			PostMessage(GetParent(pW->hBack), pW->MsgRBUp, wParam, lParam);
		}
	}

	return 0;		//	右クリックはインターセプトする
}
//----- キー入力 -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(ListBox, WM_CHAR			   )
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hwnd, LBX_PROPNAME);
	int			sty 	  = (int)MAjcGetWindowLong(pW->hLbx, GWL_STYLE);
	BOOL		fMult	  = !(sty & AJCLBXS_SINGLE);
	BOOL		fSel;

	//----- 選択項目の有無フラグ設定 --------------------------------------------------//
	fSel  = (sty & LBS_MULTIPLESEL) ? ((int)SendMessage(pW->hLbx, LB_GETSELCOUNT, 0, 0) > 0) :
									  ((int)SendMessage(pW->hLbx, LB_GETCURSEL	, 0, 0) != LB_ERR);

	//----- キーファンクション実行 ----------------------------------------------------//
	switch (wParam) {
		case CC_CTRL_N:	if (pW->PopupMask & AJCLBXMM_ADDITEM) {					//	CTRL + N : 項目追加
							IdmAddItem		(pW, hwnd);	
						}
						break;

		case CC_CTRL_A:	if (pW->PopupMask & AJCLBXMM_SELALL) {					//	CTRL + A : 全て選択
							if (fMult) IdmSelAll(pW, hwnd);
						}
						break;

		case CC_CTRL_K:	if (pW->PopupMask & AJCLBXMM_DESELALL) {				//	CTRL + K : 選択解除
							if (fSel) IdmDeSelAll(pW, hwnd);
						}
						break;

		case CC_CTRL_C:	if (pW->PopupMask & AJCLBXMM_COPYSEL) {					//	CTRL + C :選択項目コピー
							if (fSel) IdmCopySel(pW, hwnd);
						}
						break;

		case CC_CTRL_I:	if (pW->PopupMask & AJCLBXMM_COPYALL) {					//	CTRL + I : 全てコピー
							IdmCopyAll(pW, hwnd);
						}
						break;

		case CC_CTRL_V:	if (pW->PopupMask & AJCLBXMM_PASTE) {					//	CTRL + V : 貼り付け
							IdmPaste(pW, hwnd);
						}
						break;
	}
	return 0;	//	WM_CHARはインターセプトする
}
//----- ファイル／ディレクトリ ドロップ ------------------------------------------------------------------------//
AJC_WNDPROC(ListBox, WM_DROPFILES	)
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hwnd, LBX_PROPNAME);
	HDROP	hDrop;
	UI		i, n, bytes;
	WC		path[MAX_PATH];

	//----- 前回のドロップデータ破棄 -----------------------//
	AjcRngPurge(pW->hRngDir);
	AjcRngPurge(pW->hRngFile);

	//----- カウンタクリアー -------------------------------//
	pW->NtcDirs = pW->NtcFiles = 0;
	//----- ドロップしたディレクトリ名／ファイル名追加 -----//
	hDrop = (HDROP)wParam;														//	ドロップハンドル設定
	n	  = DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);							//	ドロップファイル数取得
	for (i=0; i < n; i++) {														//	ドロップパス数ループ
		DragQueryFile(hDrop, i, path, MAX_PATH);								//		ドロップパス名取得
		path[MAX_PATH - 1] = 0;
		if (AjcPathExists(path)) {												//	有効なパス？
			if (AjcPathIsDirectory(path)) {										//		ディレクトリ？
				if (pW->style & AJCLBXS_ACCEPTDIRS) {							//			ディレクトリ ドロップ可？
					if (pW->style & AJCLBXS_ADDITEMINDROP) {					//				ドロップ時リスト項目追加？
						if (pW->style & AJCLBXS_DIRTAIL) AjcPathCat(path, L"", MAX_PATH);
						AjcLbxAddString(pW->hBack, path);						//					リストボックスへ追加
					}
					pW->NtcDirs++;												//				ディレクトリ数更新
					bytes = (UI)(wcslen(path) + 1) * 2;
					AjcRngPutData(pW->hRngDir, (VOP)&bytes, sizeof bytes);		//				ディレクトリ名退避
					AjcRngPutData(pW->hRngDir, (VOP)path, bytes);				//				・
				}
			}
			else {																//		ファイル？
				if (pW->style & AJCLBXS_ACCEPTFILES) {							//			ファイル ドロップ可？
					if (pW->style & AJCLBXS_ADDITEMINDROP) {					//				ドロップ時リスト項目追加？
						AjcLbxAddString(pW->hBack, path);						//					リストボックスへ追加
					}
					pW->NtcFiles++;												//				ファイル数更新
					bytes = (UI)(wcslen(path) + 1) * 2;
					AjcRngPutData(pW->hRngFile, (VOP)&bytes, sizeof bytes);		//				ファイル名退避
					AjcRngPutData(pW->hRngFile, (VOP)path, bytes);				//				・
				}
			}
		}
	}
	DragFinish(hDrop);															//	ドロップ終了

	//	ディレクトリドロップ通知
	if (pW->NtcDirs != 0) {
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCLBXN_DROPDIR),
						fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)pW->NtcDirs);
	}
	//	ファイルドロップ通知
	if (pW->NtcFiles != 0) {
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCLBXN_DROPFILE),
						fCmdWithHdl ? (LPARAM)pW->hBack :  (LPARAM)pW->NtcFiles);
	}

	return 0;	//	WM_DROPFILESはインターセプトする
}
//----- WM_MOUSEMOVE -------------------------------------------------------------------------------------------//
AJC_WNDPROC(ListBox, WM_MOUSEMOVE 		   )
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hwnd, LBX_PROPNAME);

	//	チップテキストコントロール用に バックウインドへ通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	return MAjcMmpCallOrgWndProc(ListBox);
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(ListBox, WM_DESTROY 		   )
{
	PWRKLISTBOX	pW = (PWRKLISTBOX)GetProp(hwnd, LBX_PROPNAME);

	RemoveProp(hwnd, LBX_PROPNAME);

	return MAjcMmpCallOrgWndProc(ListBox);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(ListBox)
	AJC_WNDMAP_MSG(ListBox, WM_LBUTTONDOWN		)
	AJC_WNDMAP_MSG(ListBox, WM_MBUTTONDOWN		)
	AJC_WNDMAP_MSG(ListBox, WM_RBUTTONDOWN		)
	AJC_WNDMAP_MSG(ListBox, WM_RBUTTONUP		)
	AJC_WNDMAP_MSG(ListBox, WM_CHAR				)
	AJC_WNDMAP_MSG(ListBox, WM_DROPFILES		)
	AJC_WNDMAP_MSG(ListBox, WM_MOUSEMOVE		)
	AJC_WNDMAP_MSG(ListBox, WM_DESTROY			)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ポップアップメニュー・アクション																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- 項目編集 -----------------------------------------------------------------------------------------------//
static	VO		IdmEditItem(PWRKLISTBOX pW, HWND hwnd)
{
	if (pW->ixEdit >= 0 && pW->ixEdit < (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) {
		LbxDialogBoxEditItem(pW);
	}
}
//----- 項目追加 -----------------------------------------------------------------------------------------------//
static	VO		IdmAddItem(PWRKLISTBOX pW, HWND hwnd)
{
	LbxDialogBoxAddItem(pW);
}
//----- 全て選択 -----------------------------------------------------------------------------------------------//
static	VO		IdmSelAll(PWRKLISTBOX pW, HWND hwnd)
{
	UI	id = (UI)MAjcGetWindowLong(pW->hBack, GWL_ID);

	SendMessage(pW->hLbx, LB_SETSEL, TRUE , -1);
	//	選択変更通知
	SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_SELCHANGE), (LPARAM)pW->hBack);
}
//----- 選択解除 -----------------------------------------------------------------------------------------------//
static	VO		IdmDeSelAll(PWRKLISTBOX pW, HWND hwnd)
{
	UI	id = (UI)MAjcGetWindowLong(pW->hBack, GWL_ID);

	if (pW->style & AJCLBXS_SINGLE) SendMessage(pW->hLbx, LB_SETCURSEL, -1	 ,	0);
	else							SendMessage(pW->hLbx, LB_SETSEL   , FALSE, -1);
	//	選択変更通知
	SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_SELCHANGE), (LPARAM)pW->hBack);
}
//----- 全選択項目の削除 ---------------------------------------------------------------------------------------//
static	VO		IdmDelete(PWRKLISTBOX pW, HWND hwnd)
{
	int		i, nItems;
	UI		id = (UI)MAjcGetWindowLong(pW->hBack, GWL_ID);


	if ((nItems = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
		if (MessageBoxW(pW->hBack, LNGSEL(L"選択されている項目を削除しますか？",
										  L"Do you remove all selected items?"), AppName, MB_YESNO) == IDYES) {
			UI		bytes = 0;
			WC		txt[LBX_MAXLEN];

			//	前回の通知データ破棄
			AjcRngPurge(pW->hRngDel);
			//	カウンタクリアー
			pW->NtcDelItems = 0;
			//	削除項目文字列設定とリストボックスから項目削除
			for (i = nItems - 1; i >= 0; i--) {
				if (SendMessage(pW->hLbx, LB_GETSEL, i, 0) > 0) {
					//	削除する項目の文字列取得とリングバッファへ退避
					SendMessageA(pW->hLbx, LB_GETTEXT, i, (LPARAM)txt);
					bytes = (UI)(wcslen(txt) + 1) * 2;
					AjcRngPutData(pW->hRngDel, (VOP)&bytes, sizeof bytes);
					AjcRngPutData(pW->hRngDel, (VOP)txt, bytes);
					//	リストボックスから項目削除
					SendMessage(pW->hLbx, LB_DELETESTRING, i, 0);
					//	削除項目数更新
					pW->NtcDelItems++;
				}
			}
			LbxSetHoriExtentByAllItem(pW);
			//	削除通知
			SendMessage(GetParent(pW->hBack), WM_COMMAND,
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCLBXN_REMOVED),
						fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)pW->NtcDelItems);
		}
		//	選択変更通知
		SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_SELCHANGE), (LPARAM)pW->hBack);
	}
}
//----- クリアー -----------------------------------------------------------------------------------------------//
static	VO	IdmClear(PWRKLISTBOX pW, HWND hwnd)
{
	int		i, nItems;
	UI		id = (UI)MAjcGetWindowLong(pW->hBack, GWL_ID);
	UI		sty;
	BOOL	fSel;

	if ((nItems = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
		if (MessageBoxW(pW->hBack, LNGSEL(L"全ての項目を削除しますか？",
										  L"Do you remove all items?"), AppName, MB_YESNO) == IDYES) {
			UI		bytes = 0;
			UI		SvSelCount = 0;
			WC		txt[LBX_MAXLEN];

			//	選択状態退避
			sty   = (UI)MAjcGetWindowLong(pW->hLbx, GWL_STYLE);
			fSel  = (sty & LBS_MULTIPLESEL) ? ((int)SendMessage(pW->hLbx, LB_GETSELCOUNT, 0, 0) > 0) :
									  		  ((int)SendMessage(pW->hLbx, LB_GETCURSEL	, 0, 0) != LB_ERR);
			//	前回の通知データ破棄
			AjcRngPurge(pW->hRngDel);
			//	カウンタクリアー
			pW->NtcDelItems = 0;
			//	削除項目文字列設定とリストボックスから項目削除
			for (i = nItems - 1; i >= 0; i--) {
				//	削除する項目の文字列取得とリングバッファへ退避
				SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)txt);
				bytes = (UI)(wcslen(txt) + 1) * 2;
				AjcRngPutData(pW->hRngDel, (VOP)&bytes, sizeof bytes);
				AjcRngPutData(pW->hRngDel, (VOP)txt, bytes);
				//	削除項目数更新
				pW->NtcDelItems++;
			}
			//	リストボックスから全項目削除
			SendMessage(pW->hLbx, LB_RESETCONTENT, 0, 0);
			SendMessage(pW->hLbx, LB_SETHORIZONTALEXTENT, 0, 0);
			//	削除通知
			SendMessage(GetParent(pW->hBack), WM_COMMAND,
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCLBXN_REMOVED),
						fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)pW->NtcDelItems);
		}
		//	選択変更通知
		if (fSel) {
			SendMessage(GetParent(pW->hBack), WM_COMMAND, MAKELONG(id, AJCLBXN_SELCHANGE), (LPARAM)pW->hBack);
		}
	}
}
//----- 全項目のコピー -----------------------------------------------------------------------------------------//
static	VO	IdmCopyAll(PWRKLISTBOX pW, HWND hwnd)
{
	int		i, nItems, len, stl, max_stl;
	HGLOBAL	hGlobal;
	WCP		pBlk, pStr;
	//----- テキストサイズ算出 -------------------------------//
	if ((nItems = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
		max_stl = 0;
		len = 0;
		for (i = 0; i < nItems; i++) {
			stl = (int)SendMessage(pW->hLbx, LB_GETTEXTLEN, i, 0);
			if (stl >= 0) {
				max_stl = __max(stl, max_stl);
				len += (stl + 4);  // L"\r\n"分加算
			}
		}
		len++;
	}
	//----- クリップボードへテキストコピー -------------------//
	if (pStr = (WCP)AjcTAlloc(max_stl + 1)) {
		if (hGlobal = GlobalAlloc(GHND | GMEM_SHARE, len * 2)) {
			pBlk = (WCP)GlobalLock(hGlobal);
			for (i = 0; i < nItems; i++) {
				if ((stl = (int)SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)pStr)) >= 0) {
					wcscpy(pBlk, pStr	); pBlk += stl;
					wcscpy(pBlk, L"\r\n"); pBlk += 2;
				}
			}
			*pBlk = 0;
			GlobalUnlock(hGlobal);
			OpenClipboard(pW->hBack);
			EmptyClipboard();
			SetClipboardData(CF_UNICODETEXT, hGlobal);
			CloseClipboard();
		}
		free(pStr);
	}
}
//----- 選択項目のコピー ---------------------------------------------------------------------------------------//
static	VO	IdmCopySel(PWRKLISTBOX pW, HWND hwnd)
{
	int		i, len, stl, max_stl, nItems;
	HGLOBAL	hGlobal;
	WCP		pBlk, pStr;
	//----- テキストサイズ算出 -------------------------------//
	if ((nItems = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
		max_stl = 0;
		len = 0;
		for (i = 0; i < nItems; i++) {
			if (SendMessage(pW->hLbx, LB_GETSEL, i, 0) > 0) {
				stl = (int)SendMessage(pW->hLbx, LB_GETTEXTLEN, i, 0);
				if (stl >= 0) {
					max_stl = __max(stl, max_stl);
					len += (stl + 4);  // L"\r\n"分加算
				}
			}
		}
		len++;
	}
	//----- クリップボードへテキストコピー -------------------//
	if (pStr = AjcTAlloc(max_stl + 1)) {
		if (hGlobal = GlobalAlloc(GHND | GMEM_SHARE, len * 2)) {
			pBlk = (WCP)GlobalLock(hGlobal);
			for (i = 0; i < nItems; i++) {
				if (SendMessage(pW->hLbx, LB_GETSEL, i, 0) > 0) {
					if ((stl = (int)SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)pStr)) >= 0) {
						wcscpy(pBlk, pStr	); pBlk += stl;
						wcscpy(pBlk, L"\r\n"); pBlk += 2;
					}
				}
			}
			*pBlk = 0;
			GlobalUnlock(hGlobal);
			OpenClipboard(pW->hBack);
			EmptyClipboard();
			SetClipboardData(CF_UNICODETEXT, hGlobal);
			CloseClipboard();
		}
		free(pStr);
	}
}
//----- 貼り付け -----------------------------------------------------------------------------------------------//
static	VO	IdmPaste(PWRKLISTBOX pW, HWND hwnd)
{
	if (IsClipboardFormatAvailable(CF_UNICODETEXT)) {
		HGLOBAL	hGlobal;
		WCP		pBlk, pMem, pTop, pNxt;
		if (OpenClipboard(pW->hBack)) {
			if (hGlobal = GetClipboardData(CF_UNICODETEXT)) {
				if (pBlk = (WCP)GlobalLock(hGlobal)) {
					if (pMem = AjcTAlloc((UI)wcslen(pBlk) + 1)) {
						wcscpy(pMem, pBlk);
						for (pNxt = pMem; *pNxt != 0; pNxt++) {
							if (*pNxt == L'\t') *pNxt = L' ';
						}
						pTop = pNxt = pMem;
						while (*pTop != 0) {
							while (*pNxt >= 0x20) pNxt++;
							if (*pNxt != 0) {
								*pNxt = 0; pNxt++;
							}
							AjcLbxAddString(pW->hBack, pTop);
							while (*pNxt < 0x20  &&  *pNxt != 0) pNxt++;
							pTop = pNxt;
						}
						free(pMem);
					}
					GlobalUnlock(hGlobal);
				}
			}
			CloseClipboard();
		}
	}
}
//----- 複数ファイル追加 -----------------------------------------------------------------------------------//
static	VO	IdmAddFiles(PWRKLISTBOX pW, HWND hwnd)
{
	UI		n, i;
	WCP		*ppName;

	if (ppName = AjcGetOpenFiles(pW->hBack,											//	オーナーウインドハンドル
								pW->FilePath,										//	初期表示パス
								LNGSEL(L"複数ファイル選択", L"Select any files"),	//	ウインドタイトル
								pW->FileFilter,										//	フィルタ
								pW->FileDefExt,										//	デフォルト拡張子
								TRUE,												//	複数ファイル選択
								&n)) {												//	取得ファイル数格納バッファ
		for (i = 0; i < n; i++) {
			AjcLbxAddString(pW->hBack, ppName[i]);
			wcsncpy(pW->FilePath, ppName[i], AJCTSIZE(pW->FilePath));
			pW->FilePath[AJCTSIZE(pW->FilePath) - 1] = 0;
		}
		AjcReleaseOpenedFilesArray(ppName);
	}
}
//----- 文字列プールコールバック（置換実行，相対／絶対パス共用）--------------------------------------------//
static	BOOL	CALLBACK cbSplNtcStr(C_WCP pStr, UX cbp)
{
	PWRKLISTBOX pW = (PWRKLISTBOX)cbp;
	WCP			pAbs = NULL;
	WCP			pRel = NULL;
	int			ix;
	WC			svt[LBX_MAXLEN * 2 + 64];

	AjcSnPrintF(svt, AJCTSIZE(svt), L"%s", pStr);
	pAbs = AjcStrTokW(svt , L";" );
	pRel = AjcStrTokW(NULL, L"\0");
	if (pAbs != NULL && pRel != NULL) {
		ix = AjcLbxFindString(pW->hBack, -1, pAbs);
		if (LbxRepString(pW, pRel, ix) < 0) {
			pW->fErr = TRUE;
		}
	}

	return TRUE;
}
//----- 相対パスに変換 -------------------------------------------------------------------------------------//
static	VO	IdmToRelative(PWRKLISTBOX pW, HWND hwnd)
{
	HAJCSPL	hSpl = NULL;
	int		i, stl, nItems;
	int		ans 	  = IDYES;
	int		okCnt	  = 0;
	BOOL	fNeedConv = FALSE;
	BOOL	fErr	  = FALSE;
	WC		txt [LBX_MAXLEN];
	WC		relp[LBX_MAXLEN];
	WC		svt [LBX_MAXLEN * 2 + 64];

	if ((nItems = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
		if (hSpl = AjcSplCreate(AJCCMP_EXACT_WIDTH)) {
			//	置換情報退避
			for (i = nItems - 1; i >= 0; i--) {
				if (SendMessage(pW->hLbx, LB_GETSEL, i, 0) > 0) {
					if ((stl = (int)SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)txt)) >= 0) {
						if (stl > 0  &&  stl < LBX_MAXLEN) {
							DWORD	att;
							if (AjcPathIsDirectory(txt)) att = FILE_ATTRIBUTE_DIRECTORY;
							else						 att = FILE_ATTRIBUTE_NORMAL;
							if (PathRelativePathTo(relp, pW->BasePath, FILE_ATTRIBUTE_DIRECTORY, txt, att)) {
								relp[AJCTSIZE(relp) - 1] = 0;
								//	置換前後のテキストを退避
								AjcSnPrintF(svt, AJCTSIZE(svt), L"%s;%s", txt, relp);
								if (AjcSplRegist(hSpl, svt) != NULL) {
									okCnt++;
								}
								else {
									fErr = TRUE;
								}
							}
							else fErr = TRUE;
						}
						else fErr = TRUE;
					}
					else fErr = TRUE;
				}
			}
			//	変換実行フラグ設定
			if (!fErr) {
				if (okCnt != 0) fNeedConv = TRUE;
				else			fNeedConv = FALSE;
			}
			//	エラー表示
			else {
				if (okCnt != 0) {
					if (MessageBoxW(pW->hBack, LNGSEL(L"既に相対パスと同一項目が登録されているか、相対パスに変換できない項目があります。\n"
													  L"相対パスに変換できるものだけ変換を実行しますか？",
													  L"The same item as the relative path has already been registered or there are items which can not be converted to relative path.\n"
													  L"Do you only perform conversions that can be converted to relative paths?"), AppName, MB_ICONERROR | MB_YESNO) == IDYES) {
						fNeedConv = TRUE;
					}
				}
				else {
					MessageBoxW(pW->hBack, LNGSEL(L"相対パスに変換できません。", L"Cannot be converted to a relative path."), AppName, MB_ICONERROR);
					fNeedConv = FALSE;
				}
			}
			//	相対パスへの変換
			if (fNeedConv) {
				//	項目置換の実行
				AjcSplEnumStr(hSpl, (UX)pW, cbSplNtcStr, FALSE);
				//	横幅更新
				LbxSetHoriExtentByAllItem(pW);
			}
			//	文字列プール解放
			AjcSplDelete(hSpl);
		}
		else {
			MessageBoxW(pW->hBack, LNGSEL(L"メモリ不足です。 相対パスへ変換できません。",
										  L"Out of memory. Cannot convert to relative path."), AppName, MB_ICONERROR);
		}
	}
}
//----- 絶対パスに変換 -------------------------------------------------------------------------------------//
static	VO	IdmToAbsolute(PWRKLISTBOX pW, HWND hwnd)
{
	HAJCSPL	hSpl = NULL;
	int		i, stl, nItems;
	int		ans 	  = IDYES;
	int		okCnt	  = 0;
	BOOL	fNeedConv = FALSE;
	BOOL	fErr	  = FALSE;
	WC		txt[LBX_MAXLEN];
	WC		absp[LBX_MAXLEN];
	WC		svt [LBX_MAXLEN * 2 + 64];

	if ((nItems = (int)SendMessage(pW->hLbx, LB_GETCOUNT, 0, 0)) > 0) {
		if (hSpl = AjcSplCreate(AJCCMP_EXACT_WIDTH)) {
			//	置換情報退避
			for (i = nItems - 1; i >= 0; i--) {
				if (SendMessage(pW->hLbx, LB_GETSEL, i, 0) > 0) {
					if ((stl = (int)SendMessage(pW->hLbx, LB_GETTEXT, i, (LPARAM)txt)) >= 0) {
						if (stl > 0  &&  stl < LBX_MAXLEN) {
							if (PathCombine(absp, pW->BasePath, txt) != NULL) {
								absp[AJCTSIZE(absp) - 1] = 0;
								//	置換前後のテキストを退避
								AjcSnPrintF(svt, AJCTSIZE(svt), L"%s;%s", txt, absp);
								if (AjcSplRegist(hSpl, svt) != NULL) {
									okCnt++;
								}
								else {
									fErr = TRUE;
								}
							}
							else fErr = TRUE;
						}
						else fErr = TRUE;
					}
					else fErr = TRUE;
				}
			}
			//	変換実行フラグ設定
			if (!fErr) {
				if (okCnt != 0) fNeedConv = TRUE;
				else			fNeedConv = FALSE;
			}
			//	エラー表示
			else {
				if (okCnt != 0) {
					if (MessageBoxW(pW->hBack, LNGSEL(L"既に相対パスと同一項目が登録されているか、絶対パスに変換できない項目があります。\n"
													  L"絶対パスに変換できるものだけ変換を実行しますか？",
													  L"The same item as the absolute path has already been registered or there are items which can not be converted to absolute path.\n"
													  L"Do you only perform conversions that can be converted to absolute paths?"), AppName, MB_ICONERROR | MB_YESNO) == IDYES) {
						fNeedConv = TRUE;
					}
				}
				else {
					MessageBoxW(pW->hBack, LNGSEL(L"絶対パスに変換できません。", L"Cannot be converted to a absolute path."), AppName, MB_ICONERROR);
					fNeedConv = FALSE;
				}
			}
			//	絶対パスへの変換
			if (fNeedConv) {
				//	項目置換の実行
				AjcSplEnumStr(hSpl, (UX)pW, cbSplNtcStr, FALSE);
				//	横幅更新
				LbxSetHoriExtentByAllItem(pW);
			}
			//	文字列プール解放
			AjcSplDelete(hSpl);
		}
		else {
			MessageBoxW(pW->hBack, LNGSEL(L"メモリ不足です。 絶対パスへ変換できません。",
										  L"Out of memory. Cannot convert to absolute path."), AppName, MB_ICONERROR);
		}
	}
}
