﻿#include	"AjcInternal.h"
#include	"AjcCtrlLogFileDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ログファイル出力）				ＡＰＩ												//
//																												//
//**************************************************************************************************************//

#define	IS_MY_INST(P)	(P != NULL && P->InstID == LGF_INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
ATOM	LgfClassMain = 0;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO		MakeTimeStampString(PWRKLGF pW, WCP pBuf, UI lBuf);

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcCtrlLogFileInit(VO)
{
	BOOL		rc = FALSE;
	WNDCLASS	wndclass;

	do {
		//----- メイン描画ウインドクラス ---------------------//
		wndclass.style			= CS_GLOBALCLASS;
		wndclass.lpfnWndProc	= LgfWndProcMain();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRKLGF);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcCtrlLogFile";
		if ((LgfClassMain = RegisterClass(&wndclass)) == 0) break;

		rc = TRUE;
	} while(0);

	if (rc == FALSE) {
		AjcCtrlLogFileEnd();
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcCtrlLogFileEnd (VO)
{
	HINSTANCE	hModInst = GetModuleHandle(NULL);

	if (LgfClassMain != 0) {UnregisterClass((WCP)LgfClassMain, hDllInst);  LgfClassMain = 0;}
}



//==============================================================================================================//
//	ログファイル出力先ディレクトリ・パス名設定																	//
//																												//
//	引　数	：	hwnd		- コントロールのハンドル															//
//				pDirPath	- ログファイル出力先ディレクトリ・パス名のアドレス									//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfSetDirA					(HWND hwnd, C_BCP pDirPath)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pDirPath != NULL) {
			MultiByteToWideChar(CP_ACP, 0, pDirPath, -1, pW->DirPath, MAX_PATH);
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfSetDirW					(HWND hwnd, C_WCP pDirPath)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pDirPath != NULL) {
			AjcSnPrintFW(pW->DirPath, MAX_PATH, L"%s", pDirPath);
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	ログファイル出力先ディレクトリ・パス名取得																	//
//																												//
//	引　数	：	hwnd		- コントロールのハンドル															//
//				pBuf		- ディレクトリ・パス名を格納するバッファのアドレス									//
//				lBuf		- ディレクトリ・パス名を格納するバッファの文字数									//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfGetDirA					(HWND hwnd, BCP pBuf, UI lBuf)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pBuf != NULL  &&  lBuf != 0) {
			WideCharToMultiByte(CP_ACP, 0, pW->DirPath, -1, pBuf, lBuf, NULL, NULL);
			pBuf[lBuf - 1] = 0;
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfGetDirW					(HWND hwnd, WCP pBuf, UI lBuf)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pBuf != NULL  &&  lBuf != 0) {
			AjcSnPrintFW(pBuf, lBuf, L"%s", pW->DirPath);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキストファイルエンコード設定																				//
//																												//
//	引　数	：	hwnd	- コントロールのハンドル																//
//				iTec	- 入力テキストエンコード（－１指定時は未設定）											//
//				oTec	- 出力テキストエンコード（－１指定時は未設定）											//
//				fBOM	- BOM出力フラグ			（－１指定時は未設定）											//
//																												//
//	戻り値：	TRUE  - 正常																					//
//				FALSE - エラー																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcLgfSetTextEncode(HWND hwnd, EAJCTEC iTec, EAJCTEC oTec, BOOL fBOM)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (pW != NULL) {
		EAJCTEC		SvInpTec = pW->InpTec;
		EAJCTEC		SvOutTec = pW->OutTec;
		BOOL		SvfBOM	 = pW->fBOM;

		if (MAJCTEC_VALID(iTec)) {
			pW->InpTec = iTec;
		}
		if (MAJCTEC_VALID(oTec)) {
			pW->OutTec = oTec;
		}
		if (fBOM == TRUE || fBOM == FALSE) {
			pW->fBOM   = fBOM;
		}
		//	エンコード変更通知
		if (SvInpTec != pW->InpTec || SvOutTec != pW->OutTec || SvfBOM != pW->fBOM) {
			SendMessage(GetParent(pW->hMain), WM_COMMAND, 
					MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJCLGFN_ENCODE),
					fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)MAKELONG(pW->OutTec, pW->fBOM));
		}

		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	テキストファイルエンコード取得																				//
//																												//
//	引　数	：	hwnd	- コントロールのハンドル																//
//				piTec	- 入力テキストエンコードを格納するバッファのアドレス（不要時はNULL）					//
//				poTec	- 出力テキストエンコードを格納するバッファのアドレス（不要時はNULL）					//
//				pfBOM	- BOM出力フラグを格納するバッファのアドレス			（不要時はNULL）					//
//																												//
//	戻り値：	TRUE  - 正常																					//
//				FALSE - エラー																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcLgfGetTextEncode(HWND hwnd, PEAJCTEC piTec, PEAJCTEC poTec, BOOL *pfBOM)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (pW != NULL) {
		if (piTec != NULL) *piTec = pW->InpTec;
		if (poTec != NULL) *poTec = pW->OutTec;
		if (pfBOM != NULL) *pfBOM = pW->fBOM;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ログ出力の開始																								//
//																												//
//	引　数	：	hwnd		- コントロールのハンドル															//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT BOOL	   WINAPI AjcLgfStart					(HWND hwnd)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		LgfLogStart(pW);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ログ出力の停止																								//
//																												//
//	引　数	：	hwnd		- コントロールのハンドル															//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT BOOL	   WINAPI AjcLgfStop					(HWND hwnd)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		LgfLogStop(pW);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ログ出力状態の取得																							//
//																												//
//	引　数	：	hwnd		- コントロールのハンドル															//
//																												//
//	戻り値	：	TRUE  - ログ出力可能状態																		//
//				FALSE - ログ出力停止状態																		//
//==============================================================================================================//
AJCEXPORT BOOL	   WINAPI AjcLgfIsActive				(HWND hwnd)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pW->hLogFile != NULL) {
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	テキスト ログ出力																							//
//																												//
//	引　数	：	hwnd		- コントロールのハンドル															//
//				pCmd		- 識別情報文字列のアドレス															//
//				fTimeStamp	- タイムスタンプ付加フラグ															//
//				pTxt		- ログ・テキストデータのアドレス													//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcLgfPutTextA	 (HWND hwnd, C_BCP pCmd, BOOL fTimeStamp, C_BCP pTxt)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;
	WC		ts[32];

	if (IS_MY_INST(pW)) {
		if (pW->hLogFile != NULL) {
			if (pCmd != NULL) {
				AjcFPrintFA(pW->hLogFile, "%s ", pCmd);
			}
			if (fTimeStamp) {
				MakeTimeStampString(pW, ts, 32);
				AjcFPrintFA(pW->hLogFile, "%s ", ts);
			}
			if (pTxt != NULL) {
				AjcFPrintFA(pW->hLogFile, "%s", pTxt);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcLgfPutTextW	 (HWND hwnd, C_WCP pCmd, BOOL fTimeStamp, C_WCP pTxt)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;
	WC		ts[32];

	if (IS_MY_INST(pW)) {
		if (pW->hLogFile != NULL) {
			if (pCmd != NULL) {
				AjcFPrintFW(pW->hLogFile, L"%s ", pCmd);
			}
			if (fTimeStamp) {
				MakeTimeStampString(pW, ts, 32);
				AjcFPrintFW(pW->hLogFile, L"%s ", ts);
			}
			if (pTxt != NULL) {
				AjcFPrintFW(pW->hLogFile, L"%s", pTxt);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	書式テキスト ログ出力																						//
//																												//
//	引　数	：	hwnd		- コントロールのハンドル															//
//				pCmd		- 識別情報文字列のアドレス															//
//				fTimeStamp	- タイムスタンプ付加フラグ															//
//				pFmt		- 書式テキスト																		//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcLgfPrintFA	   (HWND hwnd, C_BCP pCmd, BOOL fTimeStamp, C_BCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	BC	buf[1024];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf(buf, 1024, pFmt, vls);
		buf[1023] = 0;
		va_end	(vls);
		rc = AjcLgfPutTextA(hwnd, pCmd, fTimeStamp, buf);
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcLgfPrintFW	   (HWND hwnd, C_WCP pCmd, BOOL fTimeStamp, C_WCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	UW	buf[1024];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf(buf, 1024, pFmt, vls);
		buf[1023] = 0;
		va_end	(vls);
		rc = AjcLgfPutTextW(hwnd, pCmd, fTimeStamp, buf);
	}
	return rc;
}
//==============================================================================================================//
//	タイムスタンプ形式設定																						//
//																												//
//	引　数	：	hwnd			- コントロールのハンドル														//
//				TimeStampFormat	- タイムスタンプ形式（AJCLGFTS_XXXXX）											//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcLgfSetTimeStampFormat(HWND hwnd, AJCLGFTS TimeStampFormat)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (TimeStampFormat >= AJCLGFTS_NO	&&	TimeStampFormat < AJCLGFTS_NUM) {
			pW->TsForm = TimeStampFormat;
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	タイムスタンプ形式取得																						//
//																												//
//	引　数	：	hwnd			- コントロールのハンドル														//
//																												//
//	戻り値	：	タイムスタンプ形式（AJCLGFTS_XXXXX）															//
//==============================================================================================================//
AJCEXPORT AJCLGFTS WINAPI AjcLgfGetTimeStampFormat(HWND hwnd)
{
	PWRKLGF		pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	AJCLGFTS	rc = AJCLGFTS_ERR;

	if (IS_MY_INST(pW)) {
		rc = pW->TsForm;
	}
	return rc;
}
//==============================================================================================================//
//	ログファイル名の接頭語設定																					//
//																												//
//	引　数	：	hwnd			- コントロールのハンドル														//
//				pPrefix			- 接頭語(文字列）のアドレス														//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfSetLogFileNamePrefixA(HWND hwnd, C_BCP pPrefix)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pPrefix != NULL) {
			MultiByteToWideChar(CP_ACP, 0, pPrefix, -1, pW->FileNamePrefix, LGF_MAX_PREFIX);
			pW->FileNamePrefix[LGF_MAX_PREFIX - 1] = 0;
		}
		else {
			pW->FileNamePrefix[0] = 0;
		}
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfSetLogFileNamePrefixW(HWND hwnd, C_WCP pPrefix)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pPrefix != NULL) {
			AjcSnPrintFW(pW->FileNamePrefix, LGF_MAX_PREFIX, L"%s", pPrefix);
		}
		else {
			pW->FileNamePrefix[0] = 0;
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ログファイル名の接頭語取得																					//
//																												//
//	引　数	：	hwnd			- コントロールのハンドル														//
//				pBuf			- 接頭語（文字列）を格納するバッファのアドレス									//
//				lBuf			- 接頭語（文字列）を格納するバッファの文字数									//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfGetLogFileNamePrefixA(HWND hwnd, BCP pBuf, UI lBuf)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pBuf != NULL  &&  lBuf != 0) {
			WideCharToMultiByte(CP_ACP, 0, pW->FileNamePrefix, -1, pBuf, lBuf, NULL, NULL);
			pBuf[lBuf - 1] = 0;
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfGetLogFileNamePrefixW(HWND hwnd, WCP pBuf, UI lBuf)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pBuf != NULL  &&  lBuf != 0) {
			AjcSnPrintFW(pBuf, lBuf, L"%s", pW->FileNamePrefix);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ログファイル名の拡張子設定																					//
//																												//
//	引　数	：	hwnd			- コントロールのハンドル														//
//				pExt			- 拡張子(文字列）のアドレス														//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfSetLogFileExtentionA(HWND hwnd, C_BCP pExt)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pExt != NULL) {
			if (pExt != NULL) {
				if (*pExt == '.') {
					MultiByteToWideChar(CP_ACP, 0, pExt, -1, pW->FileExtention    , _MAX_EXT    );
				}
				else {
					pW->FileExtention[0] = L'.';
					MultiByteToWideChar(CP_ACP, 0, pExt, -1, pW->FileExtention + 1, _MAX_EXT - 1);
				}
				pW->FileExtention[_MAX_EXT - 1] = 0;
			}
			else {
				pW->FileExtention[0] = 0;
			}
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfSetLogFileExtentionW(HWND hwnd, C_WCP pExt)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pExt != NULL) {
			if (pExt != NULL) {
				if (*pExt != 0) {
					if (*pExt == L'.') AjcSnPrintFW(pW->FileExtention, _MAX_EXT, L"%s" , pExt);
					else			   AjcSnPrintFW(pW->FileExtention, _MAX_EXT, L".%s", pExt);
				}
				else {
					pW->FileExtention[0] = 0;
				}
			}
			else {
				pW->FileExtention[0] = 0;
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ログファイル名の拡張子取得																					//
//																												//
//	引　数	：	hwnd			- コントロールのハンドル														//
//				pBuf			- 拡張子（文字列）を格納するバッファのアドレス									//
//				lBuf			- 拡張子（文字列）を格納するバッファの文字数									//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfGetLogFileExtentionA(HWND hwnd, BCP pBuf, UI lBuf)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pBuf != NULL  &&  lBuf != 0) {
			WideCharToMultiByte(CP_ACP, 0, pW->FileExtention, -1, pBuf, lBuf, NULL, NULL);
			pBuf[lBuf - 1] = 0;
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfGetLogFileExtentionW(HWND hwnd, WCP pBuf, UI lBuf)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pBuf != NULL  &&  lBuf != 0) {
			AjcSnPrintFW(pBuf, lBuf, L"%s", pW->FileExtention);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルからログ出力先プロパティ読み出し																//
//																												//
//	引　数	：	hwnd  - ウインドハンドル																		//
//				pSect - プロファイルのセクション名																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfLoadPropA	(HWND hwnd, C_BCP pSect)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;
	UI		sl;
	WCP		ps = NULL;

	if (pSect != NULL) {
		sl = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (sl != 0) {
			ps = AjcTAllocW(sl);
			if (ps != NULL) {
				MultiByteToWideChar(CP_ACP, 0, pSect, -1, ps, sl);
				rc = AjcLgfLoadPropW(hwnd, ps);
			}
		}
		if (ps != NULL) free(ps);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfLoadPropW	(HWND hwnd, C_WCP pSect)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;
	WC		temp[MAX_PATH];

	if (IS_MY_INST(pW)) {
		if (pSect != NULL) {
			//	テキストエンコード種別
			pW->InpTec = AjcGetProfileUIntW(pSect, L"LogFileInpTec", (UI)AJCTEC_MBC);
			pW->OutTec = AjcGetProfileUIntW(pSect, L"LogFileOutTec", (UI)AJCTEC_MBC);
			pW->fBOM   = AjcGetProfileUIntW(pSect, L"LogFileBOM"   , FALSE		   );
			//	出力ディレクトリパス
			if (PathIsDirectoryW(pW->DirPath)) {
				AjcSnPrintFW(temp, MAX_PATH, L"%s", pW->DirPath);
			}
			else {
				GetTempPathW(MAX_PATH, temp);
			}
			AjcGetProfileStrW(pSect, L"LogFileDir", temp, pW->DirPath, MAX_PATH);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルへログ出力先パス名書き込み																		//
//																												//
//	引　数	：	hwnd  - ウインドハンドル																		//
//				pSect - プロファイルのセクション名																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfSavePropA	(HWND hwnd, C_BCP pSect)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;
	UI		sl;
	WCP		ps = NULL;

	if (pSect != NULL) {
		sl = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
		if (sl != 0) {
			ps = AjcTAllocW(sl);
			if (ps != NULL) {
				MultiByteToWideChar(CP_ACP, 0, pSect, -1, ps, sl);
				rc = AjcLgfSavePropW(hwnd, ps);
			}
		}
		if (ps != NULL) free(ps);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcLgfSavePropW	(HWND hwnd, C_WCP pSect)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	BOOL	rc = FALSE;

	if (pSect != NULL) {
		//	テキストエンコード種別
		AjcPutProfileUIntW(pSect, L"LogFileInpTec", (UI)pW->InpTec);
		AjcPutProfileUIntW(pSect, L"LogFileOutTec", (UI)pW->OutTec);
		AjcPutProfileUIntW(pSect, L"LogFileBOM"   , (UI)pW->fBOM  );
		//	出力ディレクトリパス
		AjcPutProfileStrW(pSect, L"LogFileDir", pW->DirPath);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	メインウインドのハンドル取得																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pBkWnd		- ウインド背景色を格納するバッファへのポインタ（不要時はNULL）						//
//																												//
//	戻り値	：	≠NULL : メインウインドのハンドル																//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT	HWND	WINAPI		AjcLgfGetMainWindow(HWND hwnd, COLORREF *pBkGnd)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	HWND	rc = NULL;

	if (IS_MY_INST(pW)) {
		if (pBkGnd != NULL) {
			*pBkGnd = RGB(255, 255, 255);
		}
		rc = pW->hMain;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	タイムスタンプ文字列生成																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		MakeTimeStampString(PWRKLGF pW, WCP pBuf, UI lBuf)
{
	SYSTEMTIME		lt;
	LARGE_INTEGER	TimAfter;
	ULL				tim;
	WC				txt[32];

	if (pBuf != NULL  &&  lBuf > 0) {
		switch (pW->TsForm) {
			case AJCLGFTS_NO:					//	タイムスタンプなし
				*pBuf = 0;
				break;

			case AJCLGFTS_HMSN:					//	hh:mm:ss.nnn
				GetLocalTime(&lt);
				AjcSnPrintF(pBuf, lBuf, L"%02d:%02d:%02d.%03d", lt.wHour, lt.wMinute, lt.wSecond, lt.wMilliseconds);
				break;

			case AJCLGFTS_HMS:					//	hh:mm:ss
				GetLocalTime(&lt);
				AjcSnPrintF(pBuf, lBuf, L"%02d:%02d:%02d", lt.wHour, lt.wMinute, lt.wSecond);
				break;

			case AJCLGFTS_TICK:					//	Windows開始時からの経過時間[ms]
				AjcSnPrtSep(pBuf, lBuf, L"%10d", GetTickCount());
				break;

			case AJCLGFTS_MS:					//	ログファイル出力コントロール開始時からの経過時間[ms]
				memset(&TimAfter, 0, sizeof(LARGE_INTEGER));
				if (QueryPerformanceCounter(&TimAfter)) {
					tim = ((ULL)TimAfter.QuadPart - (ULL)pW->TimBefore.QuadPart) * (ULL)1000 / (ULL)pW->TimFreq.QuadPart;
					AjcSnPrtSep(txt, AJCTSIZE(txt), L"%I64u", tim);
					AjcSnPrintF(pBuf, lBuf, L"%10s", txt);
				}
				else {
					AjcSnPrintF(pBuf, lBuf, L"%s", "00,000,000");
				}
				break;

			case AJCLGFTS_US:					//	ログファイル出力コントロール開始時からの経過時間[us]
				memset(&TimAfter, 0, sizeof(LARGE_INTEGER));
				if (QueryPerformanceCounter(&TimAfter)) {
					tim = ((ULL)TimAfter.QuadPart - (ULL)pW->TimBefore.QuadPart) * (ULL)1000000 / (ULL)pW->TimFreq.QuadPart;
					AjcSnPrtSep(txt, AJCTSIZE(txt), L"%I64u", tim);
					AjcSnPrintF(pBuf, lBuf, L"%14s", txt);
				}
				else {
					AjcSnPrintF(pBuf, lBuf, L"%s", "00,000,000,000");
				}
				break;

			default:							//	未定義フォーマット
				*pBuf = 0;
				break;
		}
	}
}
