﻿//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ログファイル出力）				共通定義											//
//																												//
//**************************************************************************************************************//

#define	LGF_INST_ID			0x6D9B5A57

//--------------------------------------------------------------------------------------------------------------//
//	ウインドワーク																								//
//--------------------------------------------------------------------------------------------------------------//

#define	LGF_MAX_PREFIX	128

typedef struct {
	UI				InstID;						//	インスタンス識別ＩＤ
	HWND			hMain;						//	メインウインドハンドル
	HBITMAP			hBitmap1;					//	ビットマップハンドル
	HBITMAP			hBitmap2;					//	・
	HBITMAP			hBitmap3;					//	・
	HBITMAP			hBmGray;					//	・
	UI				BlinkCount;					//	ブリンクカウンタ
	UI				style;						//	ウインドスタイル
	BOOL			fEnable;					//	コントロールの有効状態
	AJCLGFTS		TsForm;						//	タイムスタンプ形式（AJCLGFTS_XXXXX）
	LARGE_INTEGER	TimFreq;					//	高精度タイマの周波数
	LARGE_INTEGER	TimBefore;					//	高精度タイマ値（コントロール開始時）
	HAJCFILE		hLogFile;					//	ログファイルハンドル
	WC				FileNamePrefix[LGF_MAX_PREFIX];	//	ログファイル名の接頭語
	WC				FileExtention[_MAX_EXT];	//	ファイル拡張子
	WC				FilePath[MAX_PATH];			//	ログファイルパス
	//----- 永続情報 -----//
	EAJCTEC			InpTec;						//	入力テキストエンコード種別
	EAJCTEC			OutTec;						//	出力テキストエンコード種別
	BOOL			fBOM;						//	ＢＯＭ出力フラグ
	WC				DirPath[MAX_PATH];			//	ログファイル出力ディレクトリパス
} WRKLGF, *PWRKLGF;

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
extern	ATOM	LgfClassMain;

//--------------------------------------------------------------------------------------------------------------//
//	グローバルサブ関数																							//
//--------------------------------------------------------------------------------------------------------------//
extern	WNDPROC		LgfWndProcMain();
extern	VO			LgfLogStart		   (PWRKLGF pW);
extern	VO			LgfLogStop		   (PWRKLGF pW);
