﻿#include	"AjcInternal.h"
#include	"AjcCtrlLogFileDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ログファイル出力）				グローバル サブ関数									//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//																												//
//	ログ出力開始																								//
//																												//
//==============================================================================================================//
VO		LgfLogStart(PWRKLGF pW)
{
	SYSTEMTIME	lt;
	WC			txt[MAX_PATH + 64];

	if (pW->hLogFile == NULL) {
		//	出力ファイルパス名設定
		GetLocalTime(&lt);
		AjcSnPrintFW(pW->FilePath, MAX_PATH, L"%s", pW->DirPath);
		AjcSnPrintFW(txt, AJCTSIZE(txt), L"%s%04d-%02d-%02d_%02d-%02d-%02d%s", pW->FileNamePrefix,
							lt.wYear, lt.wMonth, lt.wDay, lt.wHour, lt.wMinute, lt.wSecond, pW->FileExtention);
		AjcPathCatW(pW->FilePath, txt, MAX_PATH);

		if (pW->hLogFile = AjcFCreateW(pW->FilePath, pW->OutTec, pW->fBOM)) {
			//	再描画／ブリンクタイマ開始
			if (pW->style & AJCLGF_NOBLINK) {
				InvalidateRect(pW->hMain, NULL, FALSE);
			}
			else {
				SetTimer(pW->hMain, 1, 500, NULL);
			}
			//	ログ出力開始通知
			if (IsWindowUnicode(GetParent(pW->hMain))) {
				SendMessage(GetParent(pW->hMain), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJCLGFN_START),
						fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)pW->FilePath);
			}
			else {
				BC		path[MAX_PATH];
				WideCharToMultiByte(CP_ACP, 0, pW->FilePath, -1,path, AJCTSIZE(path), NULL, NULL);
				SendMessage(GetParent(pW->hMain), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJCLGFN_START),
						fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)path);
			}
		}
		else {
			AjcSnPrintFW(txt, AJCTSIZE(txt), L"%s open failure", pW->FilePath);
			MessageBoxW(pW->hMain, txt, AppName, MB_ICONERROR);
		}
	}
}
//==============================================================================================================//
//																												//
//	ログ出力停止																								//
//																												//
//==============================================================================================================//
VO		LgfLogStop(PWRKLGF pW)
{
	ULL		fsize;

	if (pW->hLogFile != NULL) {
		//	ログファイルクローズ
		AjcFClose(pW->hLogFile);
		pW->hLogFile = NULL;
		//	ファイルサイズ取得
		fsize = AjcGetFileSizeW(pW->FilePath);
		//	ログデータなしならば、ファイル削除
		if (fsize == 0) DeleteFileW(pW->FilePath);
		//	ブリンクタイマ停止
		KillTimer(pW->hMain, 1);
		//	ログ出力停止通知
		if (IsWindowUnicode(GetParent(pW->hMain))) {
			SendMessage(GetParent(pW->hMain), WM_COMMAND, 
					MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJCLGFN_STOP),
					fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)pW->FilePath);
		}
		else {
			BC		path[MAX_PATH];
			WideCharToMultiByte(CP_ACP, 0, pW->FilePath, -1,path, AJCTSIZE(path), NULL, NULL);
			SendMessage(GetParent(pW->hMain), WM_COMMAND, 
					MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJCLGFN_STOP),
					fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)path);
		}
		//	再描画
		InvalidateRect(pW->hMain, NULL, FALSE);
	}
}
