﻿#include	"AjcInternal.h"
#include	"AjcCtrlLogFileDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ログファイル出力）				メインウインド										//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Main);
static	VO		DeleteAllResource  (PWRKLGF pW);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		LgfWndProcMain()
{
	return AJC_WNDPROC_NAME(Main);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メインウインドプロシージャ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- 動的ツールテキスト取得 ---------------------------------------------------------------------------------//
C_WCP CALLBACK cbGetText (HWND hCtrl, UTP pBuf, UI lBuf, UX cbp)
{
	PWRKLGF	pW = (PWRKLGF)cbp;

	if (pW->hLogFile != NULL) {
		AjcSnPrintF(pBuf, lBuf, L"-> %s", pW->FilePath);
	}
	else {
		AjcSnPrintF(pBuf, lBuf, LNGSEL(L"ログファイル出力停止中", L"Output is stopped"));
	}
	return pBuf;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE		)
{
	PWRKLGF		pW = ((LPCREATESTRUCT)lParam)->lpCreateParams;
	LRESULT		rc = -1;

	do {
		//----- ウインドワーク生成 -----------------------------------------------------------------------------//
		if ((pW = (PWRKLGF)AJCMEM(sizeof(WRKLGF))) == NULL) break;
		memset(pW, 0, sizeof(WRKLGF));
		//----- インスタンス識別ＩＤ設定 -----------------------------------------------------------------------//
		pW->InstID = LGF_INST_ID;
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);

		//----- メインウインドハンドル設定 ---------------------------------------------------------------------//
		pW->hMain = hwnd;
		//----- ビットマップハンドル生成 -----------------------------------------------------------------------//
		if (!(pW->hBitmap1	= LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_LGF_BM1	 )))) break;
		if (!(pW->hBitmap2	= LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_LGF_BM2	 )))) break;
		if (!(pW->hBitmap3	= LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_LGF_BM3	 )))) break;
		if (!(pW->hBmGray	= LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_LGF_BMGRAY)))) break;
		//----- 状態変数初期化 ---------------------------------------------------------------------------------//
		pW->style		  = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);	//	ウインドスタイル
		pW->fEnable		  = !(pW->style & WS_DISABLED);					//	コントロールの有効状態
		//----- タイムスタンプ形式初期化 -----------------------------------------------------------------------//
		pW->TsForm = AJCLGFTS_HMSN;
		//----- 計測タイマ初期化 ---------------------------------------------//
		memset(&pW->TimFreq	 , 0, sizeof(LARGE_INTEGER));
		memset(&pW->TimBefore, 0, sizeof(LARGE_INTEGER));
		QueryPerformanceFrequency(&pW->TimFreq);
		QueryPerformanceCounter(&pW->TimBefore);
		//----- 出力フォルダ名初期化 ---------------------------------------------------------------------------//
		GetTempPathW(MAX_PATH, pW->DirPath);
		//----- テキストエンコード種別初期化 -------------------------------------------------------------------//
		pW->InpTec = AJCTEC_MBC;
		pW->OutTec = AJCTEC_MBC;
		pW->fBOM   = AJCTEC_MBC;
		//----- 出力ログファイル名の接頭語初期化 ---------------------------------------------------------------//
		wcscpy(pW->FileNamePrefix, L"LGF_");
		//----- 出力ログファイル名の拡張子初期化 ---------------------------------------------------------------//
		wcscpy(pW->FileExtention, L".log");
		//----- ツールチップ・ココールバック設定 ---------------------------------------------------------------//
		AjcTipTextAdd(hwnd, NULL);
		AjcTipTextSetCallBack(hwnd, (UX)pW, NULL, cbGetText);
		//----- 戻り値（正常） ---------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	if (rc == -1) {
		DeleteAllResource(pW);
		MAjcSetWindowLong(hwnd, 0, (UX)NULL);
	}

	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);

	DeleteAllResource(pW);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_PAINT		)
{
	PWRKLGF		pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc, mdc;
	RECT		r;
	int			ww, wh;
	HBITMAP		hBm, hBmSv;

	hdc	 = BeginPaint(hwnd, &ps);

	//----- 表示ビットマップ選択 ----------------------------------------//
	if (pW->fEnable) {
		if (pW->style & AJCLGF_NOBLINK) {
			if (pW->hLogFile) {
				hBm = pW->hBitmap2;
			}
			else {
				hBm = pW->hBitmap3;
			}
		}
		else {
			if (pW->hLogFile) {
				if (pW->BlinkCount & 1) {
					hBm = pW->hBitmap1;
				}
				else {
					hBm = pW->hBitmap2;
				}
			}
			else {
				hBm = pW->hBitmap3;
			}
		}
	}
	else {
		hBm = pW->hBmGray;
	}
	//----- ビットマップ表示 --------------------------------------------//
	GetClientRect(hwnd, &r);
	ww = r.right - r.left;
	wh = r.bottom - r.top;

	mdc = CreateCompatibleDC(hdc);
	hBmSv = (HBITMAP)SelectObject(mdc, hBm);
	StretchBlt(hdc, 0, 0, ww, wh, mdc, 0, 0, 16, 16, SRCCOPY);
	SelectObject(mdc, hBmSv);
	DeleteDC(mdc);

	EndPaint(hwnd, &ps);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONDOWN)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);

	if (pW->fEnable) {
		if (!(pW->style & AJCLGF_DISCLICK)) {
			if (pW->hLogFile == NULL) {
				LgfLogStart(pW);
			}
			else {
				LgfLogStop (pW);
			}
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
enum {
	IDM_ENCODE	=	5001,
	IDM_OUTDIR			,
};

AJC_WNDPROC(Main, WM_RBUTTONDOWN	)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	HMENU		hMenu;
	int			id;
	POINT		pt;

	if (pW->hLogFile == NULL) {
		hMenu = CreatePopupMenu();
		AppendMenu(hMenu, MFT_STRING, IDM_ENCODE, LNGSEL(L"テキストエンコード設定(&E)", L"Set Text &Encode"	   ));
		AppendMenu(hMenu, MFT_STRING, IDM_OUTDIR, LNGSEL(L"ログ出力フォルダ設定(&F)"  , L"Set Log Output &Folder"));
		GetCursorPos(&pt);
		id = AjcDgcTrackPopupMenuEx(hMenu, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, hwnd, NULL);
		DestroyMenu(hMenu);

		switch (id) {
			case IDM_ENCODE:
			{	EAJCTEC		SvInpTec = pW->InpTec;
				EAJCTEC		SvOutTec = pW->OutTec;
				BOOL		SvfBOM	 = pW->fBOM;
				AjcFTecDialogW(hwnd, LNGSEL(L"ログファイル テキストエンコード設定", L"Log file text encode"), hIcoApp, NULL, &pW->OutTec, &pW->fBOM);
				//	エンコード変更通知
				if (SvInpTec != pW->InpTec || SvOutTec != pW->OutTec || SvfBOM != pW->fBOM) {
					SendMessage(GetParent(pW->hMain), WM_COMMAND, 
							MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJCLGFN_ENCODE),
							fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)MAKELONG(pW->OutTec, pW->fBOM));
				}
				break;
			}
			case IDM_OUTDIR:
			{	WC	BoxTtl[MAX_PATH + 64];
				AjcSnPrintFW(BoxTtl, AJCTSIZE(BoxTtl), L"%s", pW->DirPath);
				AjcGetFolderNameW(hwnd, LNGSEL(L"ログファイル出力先フォルダ設定", L"Log file output destination folder."), BoxTtl, pW->DirPath, TRUE);
				break;
			}
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER)
{
	PWRKLGF	pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);

	pW->BlinkCount++;
	InvalidateRect(hwnd, NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_STYLECHANGED)
{
	PWRKLGF			pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);
	LPSTYLESTRUCT	p  = (LPSTYLESTRUCT)lParam;

	if		(wParam == GWL_STYLE) {
		pW->style = p->styleNew;
		InvalidateRect(pW->hMain , NULL, FALSE);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_ENABLE)
{
	PWRKLGF		pW = (PWRKLGF)MAjcGetWindowLong(hwnd, 0);

	pW->fEnable = (BOOL)wParam;
	if (!pW->fEnable) {
		LgfLogStop(pW);
	}
	InvalidateRect(pW->hMain , NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE			)
	AJC_WNDMAP_MSG(Main, WM_DESTROY			)
	AJC_WNDMAP_MSG(Main, WM_PAINT			)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONDOWN		)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONDOWN		)
	AJC_WNDMAP_MSG(Main, WM_TIMER			)
	AJC_WNDMAP_MSG(Main, WM_STYLECHANGED	)
	AJC_WNDMAP_MSG(Main, WM_ENABLE			)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	全リソース開放																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DeleteAllResource(PWRKLGF pW)
{
	union {
		struct {UL l, h;} s;
		ULL				  len;
	} u;

	if (pW != NULL) {
		if (pW->hLogFile != NULL) {
			//	ファイルサイズ取得
			u.s.l = GetFileSize(pW->hLogFile->hFile, &u.s.h);
			//	ファイルクローズ
			AjcFClose(pW->hLogFile);
			pW->hLogFile = NULL;
			//	ファイルデータ無しならば、ファイル削除
			if (u.len == 0) DeleteFileW(pW->FilePath);
		}
		if (pW->hBitmap1 != NULL) {DeleteObject (pW->hBitmap1);	pW->hBitmap1 = NULL;}
		if (pW->hBitmap2 != NULL) {DeleteObject (pW->hBitmap2);	pW->hBitmap2 = NULL;}
		if (pW->hBitmap3 != NULL) {DeleteObject (pW->hBitmap3);	pW->hBitmap3 = NULL;}
		if (pW->hBmGray	 != NULL) {DeleteObject (pW->hBmGray );	pW->hBmGray	 = NULL;}
		free(pW);
	}
}
