﻿#include	"AjcInternal.h"
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	AjcCtrlXXXX内 共通サブ関数																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	ツールチップ・テキスト取得（汎用サブ関数）																	//
//																												//
//	引　数	：	pTip		 - ツールチップへのポインタ配列														//
//				ix			 - 配列インデクス																	//
//				pBuf		 - ツールチップ・テキスト文字列を格納するバッファのアドレス							//
//				lBuf		 - ツールチップ・テキスト文字列を格納するバッファの文字数							//
//																												//
//	戻り値	：	チップテキストのバイト数／文字数（pBuf=NULLの場合は、文字列終端を含む）							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
UI		SubGetTipTextA (C_WCP pTip[], UI ix, BCP pBuf, UI lBuf)
{
	UI		rc = 0;
	UI		len;

	if (pTip[ix] != NULL) {
		len = WideCharToMultiByte(CP_ACP, 0, pTip[ix], -1, NULL, 0, NULL, NULL);
		if (pBuf != NULL  &&  lBuf >= len) {
			WideCharToMultiByte(CP_ACP, 0, pTip[ix], -1, pBuf, lBuf, NULL, NULL);
			rc = (UI)strlen(pBuf);
		}
		else {
			rc = len;
		}
	}
	else {
		if (pBuf != NULL) {
			if (lBuf > 0) *pBuf = 0;
			rc = 0;
		}
		else {
			rc = 1;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
UI		SubGetTipTextW (C_WCP pTip[], UI ix, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	UI		len;

	if (pTip[ix] != NULL) {
		len = (UI)wcslen(pTip[ix]);
		if (pBuf != NULL && lBuf > len) {
			wcscpy(pBuf, pTip[ix]);
			rc = len;
		}
		else {
			rc = len + 1;
		}
	}
	else {
		if (pBuf != NULL) {
			if (lBuf > 0) *pBuf = 0;
			rc = 0;
		}
		else {
			rc = 1;
		}
	}
	return rc;
}
//==============================================================================================================//
//	フィィルタ（チェックボックス）のツールチップ・テキスト設定													//
//																												//
//	引　数	：	pTip		 - ツールチップへのポインタ配列														//
//				ix			 - 配列インデクス																	//
//				pTxt		 - 設定するツールチップ・テキスト文字列のアドレス									//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
BOOL	SubSetTipTextA(WCP pTip[], UI ix, C_BCP pTxt)
{
	BOOL	rc = FALSE;
	WCP		pNew;
	UI		len;

	//	チップテキスト設定
	if (pTxt != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pTxt, -1, NULL, 0);
		if (pNew = AjcTAllocW(len)) {
			//	旧チップテキスト解放
			if (pTip[ix] != NULL) free(pTip[ix]);
			//	新チップテキスト設定
			pTip[ix] = pNew;
			MultiByteToWideChar(CP_ACP, 0, pTxt, -1, pTip[ix], len);
			rc = TRUE;
		}
	}
	else {
		//	旧チップテキスト解放
		if (pTip[ix] != NULL) free(pTip[ix]);
		//	チップテキスト＝NULL
		pTip[ix] = NULL;
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
BOOL	SubSetTipTextW(WCP pTip[], UI ix, C_WCP pTxt)
{
	BOOL	rc = FALSE;
	WCP		pNew;
	UI		len;

	//	チップテキスト設定
	if (pTxt != NULL) {
		len = (UI)wcslen(pTxt);
		if (pNew = AjcTAllocW(len + 1)) {
			//	旧チップテキスト解放
			if (pTip[ix] != NULL) free(pTip[ix]);
			//	新チップテキスト設定
			pTip[ix] = pNew;
			wcscpy(pTip[ix], pTxt);
			rc = TRUE;
		}
	}
	else {
		//	旧チップテキスト解放
		if (pTip[ix] != NULL) free(pTip[ix]);
		//	チップテキスト＝NULL
		pTip[ix] = NULL;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	タイトル・ビットマップ生成																					//
//																												//
//	引　数	：	pT			- タイトル描画情報ワークへのポインタ												//
//				hwnd		- タイトルを描画するウインドハンドル												//
//				pTtlTxt		- タイトルテキスト																	//
//				txtColor	- テキスト描画色																	//
//				bakColor	- 背景色																			//
//				hFont		- フォントハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
BOOL	SubTtlBmpMake(PCTRL_TTLINFO  pT, HWND hwnd, C_WCP pTtlTxt, COLORREF txtColor, COLORREF bakColor, HFONT hFont)
{
	BOOL	rc = FALSE;
	RECT	wr;				//	ウインド矩形
	RECT	tr;				//	タイトル矩形
	HDC		wdc;			//	ウインドＤＣ
	UI		stl;			//	タイトルテキスト長
	HDC		mdc;			//	タイトルＤＣ
	HBITMAP	hBmpSv = NULL;	//	ビットマップハンドル退避
	HBRUSH	hBru, hBruSv;
	HPEN	hPen, hPenSv;

	if (pTtlTxt != NULL && *pTtlTxt != 0) {
		//	デフォルト値設定
		if (txtColor == -1  ) txtColor = RGB(255, 255, 255);
		if (bakColor == -1  ) bakColor = RGB(128, 128, 128);
		if (hFont    == NULL) hFont    = hDefFontVar;
		//	ウインド矩形設定
		GetClientRect(hwnd, &wr);
		//	ウインドＤＣ取得
		wdc = GetDC(hwnd);
		//	タイトルテキスト長設定
		stl = (UI)wcslen(pTtlTxt);
		//	タイトルビットマップＤＣ生成
		if (mdc = CreateCompatibleDC(wdc)) {
			hFont = (HFONT)SelectObject(mdc, hFont);
			//	タイトルピクセルサイズ設定
			GetTextExtentPoint32(mdc, pTtlTxt, stl, &pT->szBmp);
			pT->szBmp.cx += 4; pT->szBmp.cy += 2;		//	左右２ピクセル，上下１ピクセル加算
			tr.left   = tr.top = 0;
			tr.right  = pT->szBmp.cx;
			tr.bottom = pT->szBmp.cy;
			//	前のウインド有効時のビットマップ消去
			if (pT->hBmpEna != NULL) {
				DeleteObject(pT->hBmpEna);
			}
			//	ウインド有効時のビットマップ生成
			if (pT->hBmpEna = CreateCompatibleBitmap(wdc, pT->szBmp.cx, pT->szBmp.cy)) {
				hBmpSv = (HBITMAP)SelectObject(mdc, pT->hBmpEna);
				FillRect(mdc, &tr, (HBRUSH)GetStockObject(WHITE_BRUSH));
				SetBkMode(mdc, TRANSPARENT);
				hBruSv = NULL;
				hPenSv = NULL;
				if ((hBru = CreateSolidBrush(bakColor)) && (hPen = CreatePen(PS_SOLID, 1, (COLORREF)bakColor))) {
					hBruSv = (HBRUSH)SelectObject(mdc, hBru);
					hPenSv = ( HPEN )SelectObject(mdc, hPen);
					RoundRect(mdc, 0, 0, pT->szBmp.cx, pT->szBmp.cy, 3, 3);
					SetTextColor(mdc, txtColor);
					TextOut(mdc, 2, 1, pTtlTxt, stl);
				}
				if (hBruSv != NULL) DeleteObject(SelectObject(mdc, hBruSv));
				if (hPenSv != NULL) DeleteObject(SelectObject(mdc, hPenSv));
				SelectObject(mdc, hBmpSv);
			}
			//	前のウインド無効時のビットマップ消去
			if (pT->hBmpDis != NULL) {
				DeleteObject(pT->hBmpDis);
			}
			//	ウインド無効時のビットマップ生成
			if (pT->hBmpDis = CreateCompatibleBitmap(wdc, pT->szBmp.cx, pT->szBmp.cy)) {
				hBmpSv = (HBITMAP)SelectObject(mdc, pT->hBmpDis);
				FillRect(mdc, &tr, (HBRUSH)GetStockObject(WHITE_BRUSH));
				SetBkMode(mdc, TRANSPARENT);
				hBruSv = NULL;
				hPenSv = NULL;
				if ((hBru = CreateSolidBrush(GetSysColor(COLOR_BTNSHADOW))) && (hPen = CreatePen(PS_SOLID, 1, GetSysColor(COLOR_BTNSHADOW)))) {
					hBruSv = (HBRUSH)SelectObject(mdc, hBru);
					hPenSv = ( HPEN )SelectObject(mdc, hPen);
					RoundRect(mdc, 0, 0, pT->szBmp.cx, pT->szBmp.cy, 3, 3);
					SetTextColor(mdc, GetSysColor(COLOR_BTNHILIGHT));
					TextOut(mdc, 2, 1, pTtlTxt, stl);
				}
				if (hBruSv != NULL) DeleteObject(SelectObject(mdc, hBruSv));
				if (hPenSv != NULL) DeleteObject(SelectObject(mdc, hPenSv));
				SelectObject(mdc, hBmpSv);
			}
			//	戻り値=設定
			rc = (pT->hBmpEna != NULL && pT->hBmpDis != NULL);
			//	フォントセレクション回復
			SelectObject(mdc, hFont);
			//	タイトルビットマップＤＣ消去
			DeleteDC(mdc);
		}
		//	ウインドＤＣ解放
		ReleaseDC(hwnd, wdc);
	}
	else {
		if (pT->hBmpEna != NULL) {DeleteObject(pT->hBmpEna); pT->hBmpEna = NULL;}
		if (pT->hBmpDis != NULL) {DeleteObject(pT->hBmpDis); pT->hBmpDis = NULL;}
		pT->szBmp.cx = pT->szBmp.cy = 0;
	}
	return rc;
}
//==============================================================================================================//
//	タイトル・ビットマップ描画																					//
//																												//
//	引　数	：	pT			- タイトル描画情報ワークへのポインタ												//
//				hwnd		- タイトルを描画するウインドハンドル												//
//				hdc			- タイトルを描画するウインドのＤＣ													//
//				y			- 縦ピクセル位置																	//
//				rMargin		- ウインド右端マージン																//
//				fEnable		- ウインド有効状態																	//
//				BkColor		- 背景色																			//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
BOOL	SubTtlBmpDraw (PCCTRL_TTLINFO pT, HWND hwnd, HDC hdc, int y, int rMargin, BOOL fEnable)
{
	return SubTtlBmpDrawC(pT, hwnd, hdc, y, rMargin, fEnable, (COLORREF)-1);
}
//--------------------------------------------------------------------------------------------------------------//
BOOL	SubTtlBmpDrawC(PCCTRL_TTLINFO pT, HWND hwnd, HDC hdc, int y, int rMargin, BOOL fEnable, COLORREF BkColor)
{
	BOOL	rc = FALSE;
	HDC		mdc;
	HBITMAP	hBmp;
	RECT	wr;

	//	タイトルビットマップＤＣ作成
	if (mdc = CreateCompatibleDC(hdc)) {
		//	ビットマップを選択
		if (fEnable) hBmp = pT->hBmpEna;
		else         hBmp = pT->hBmpDis;
		if (hBmp != NULL) {
			hBmp = SelectObject(mdc, hBmp);
			//	ビットマップの四隅に背景色設定
			if (fEnable && BkColor != (COLORREF)-1) {
				SetPixel(mdc, 0              , 0              , BkColor);
				SetPixel(mdc, pT->szBmp.cx -1, 0              , BkColor);
				SetPixel(mdc, pT->szBmp.cx -1, pT->szBmp.cy -1, BkColor);
				SetPixel(mdc, 0              , pT->szBmp.cy -1, BkColor);
			}
			//	タイトルビットマップをウインドにコピー
			GetClientRect(hwnd, &wr);
			BitBlt(hdc, wr.right - (pT->szBmp.cx + 2 + rMargin), y, pT->szBmp.cx, pT->szBmp.cy, mdc, 0, 0, SRCCOPY);
			//	ビットマップのマッピング解除
			SelectObject(mdc, hBmp);
			//	タイトルビットマップＤＣ消去
			DeleteDC(mdc);
			//	戻り値設定
			rc = TRUE;
		}
		//	ＤＣ消去
		DeleteDC(mdc);
	}
	return rc;
}
//==============================================================================================================//
//	タイトル・ビットマップ破棄																					//
//																												//
//	引　数	：	pT			- タイトル描画情報ワークへのポインタ												//
//				hwnd		- タイトルを描画するウインドハンドル												//
//				hdc			- タイトルを描画するウインドのＤＣ													//
//				rMargin		- ウインド右端マージン																//
//				fEnable		- ウインド有効状態																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
BOOL	SubTtlBmpRemv(PCTRL_TTLINFO pT)
{
	BOOL	rc = FALSE;

	if (pT->hBmpEna != NULL) {
		DeleteObject(pT->hBmpEna);
		pT->hBmpEna = NULL;
	}
	if (pT->hBmpDis != NULL) {
		DeleteObject(pT->hBmpDis);
		pT->hBmpDis = NULL;
	}
	return rc;
}

