﻿#include	"AjcInternal.h"
#include	"AjcCtrlTextEditDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		ＡＰＩ												//
//																												//
//**************************************************************************************************************//

#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	グローバル変数																								//
//--------------------------------------------------------------------------------------------------------------//
ATOM	TEdClassBack	= 0;
ATOM	TEdClassMain	= 0;
ATOM	TEdClassForMSIL	= 0;

UI		TEdErrTxtLen;
WC		TEdErrorTxt[128] = L"*** Memory allocation failure ***";

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//


//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcCtrlTextEditInit(VO)
{
	BOOL		rc = FALSE;
	WNDCLASS	wndclass;

	do {
		//----- バックウインドクラス --------------------------//
		wndclass.style			= CS_GLOBALCLASS;
		wndclass.lpfnWndProc	= TEdWndProcBack();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRKTEDIT);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcCtrlTextEdit";
		if ((TEdClassBack = RegisterClass(&wndclass)) == 0) break;

		//----- メイン描画ウインドクラス ---------------------//
		wndclass.style			= CS_DBLCLKS;
		wndclass.lpfnWndProc	= TEdWndProcMain();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRKTEDIT);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_IBEAM);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcTextEditMainClass";
		if ((TEdClassMain = RegisterClass(&wndclass)) == 0) break;

		//----- ＭＳＩＬコードサポート用 ---------------------//
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= TEdWndProcMSIL();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(VOP);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcTextEditForMSIL";
		if ((TEdClassForMSIL = RegisterClass(&wndclass)) == 0) break;

		rc = TRUE;
	} while(0);

	if (rc == FALSE) {
		AjcCtrlTextEditEnd();
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcCtrlTextEditEnd (VO)
{
	HINSTANCE	hModInst = GetModuleHandle(NULL);

	if (TEdClassBack	!= 0) {UnregisterClass((WCP)TEdClassBack   , hDllInst); TEdClassBack	= 0;}
	if (TEdClassMain	!= 0) {UnregisterClass((WCP)TEdClassMain   , hDllInst); TEdClassMain	= 0;}
	if (TEdClassForMSIL != 0) {UnregisterClass((WCP)TEdClassForMSIL, hDllInst); TEdClassForMSIL = 0;}
}

