﻿//**************************************************************************************************************//
//																												//
//	カスタムコントロール（テキストエディット）		共通定義													//
//																												//
//**************************************************************************************************************//



#define	INST_ID			0x6238FD9B

//--------------------------------------------------------------------------------------------------------------//
//	フォントの高さの最大値，最小値																				//
//--------------------------------------------------------------------------------------------------------------//
#define		MAX_FONT_PIXELS		192
#define		MIN_FONT_PIXELS		8

#define		MAX_FONT_POINTS		144
#define		MIN_FONT_POINTS		6

//--------------------------------------------------------------------------------------------------------------//
//	ウインド余白サイズ																							//
//--------------------------------------------------------------------------------------------------------------//
#define		VMRG	4		//	上下余白
#define		HMRG	4		//	左右余白

//--------------------------------------------------------------------------------------------------------------//
//	処理モード(Mode)																							//
//--------------------------------------------------------------------------------------------------------------//
#define		MD_NORMAL	0x0000					//	通常モード
#define		MD_SCROLL	0x0002					//	スクロール中
#define		MD_DRAG_L	0x0004					//	行単位ドラッグ中
#define		MD_DRAG_C	0x0008					//	文字単位ドラッグ中
#define		MD_SELECT	0x0010					//	範囲選択状態

#define	MD_DRAG		(MD_DRAG_L | MD_DRAG_C)

//--------------------------------------------------------------------------------------------------------------//
//	ウインドワーク																								//
//--------------------------------------------------------------------------------------------------------------//
#define		MAX_MBC_BUF		256
typedef struct {
	UI			InstID;						//	インスタンス識別ＩＤ
	//----- バックウインドハンドル／ウインドサイズ -------------------------------------------------------------//
	HWND		hBack;						//	バックウインドハンドル
	UI			bw, bh;						//	バックウインドの幅と高さ
	//----- メインウインドハンドル／ウインドサイズ -------------------------------------------------------------//
	HWND		hMain;						//	メインウインドハンドル
	UI			ww, wh;						//	メインウインドの幅と高さ
	//----- 状態変数 -------------------------------------------------------------------------------------------//
	UI			style;						//	ウインドスタイル
	BOOL		fEnable;					//	コントロールの有効状態
	BOOL		fFocus;						//	フォーカス状態フラグ
	BOOL		fFirstGetText;				//	最初のWM_GETTEXTを示すフラグ
	//----- 最初の WM_SETFONT をスキップするための情報 ---------------------------------------------------------//
	BOOL		fFirstWmSetFont;			//	最初のWM_SETFONTを示すフラグ
	BOOL		fSkipFirstWmSetFont;		//	最初のWM_SETFONTを無視することを示すフラグ
	//----- プロパティ -----------------------------------------------------------------------------------------//
	AJCTEDPROPW	IniProp;					//	ウインド生成時のプロパティ値
	AJCTEDPROPW	prop;						//	現在のプロパティ値
} WRKTEDIT, *PWRKTEDIT;

//--------------------------------------------------------------------------------------------------------------//
//	グローバル変数																								//
//--------------------------------------------------------------------------------------------------------------//
extern	ATOM	TEdClassBack;
extern	ATOM	TEdClassMain;
extern	ATOM	TEdClassForMSIL;

//--------------------------------------------------------------------------------------------------------------//
//	グローバル サブ関数																							//
//--------------------------------------------------------------------------------------------------------------//
extern	WNDPROC		TEdWndProcBack();
extern	WNDPROC		TEdWndProcMain();
extern	WNDPROC		TEdWndProcMSIL();

extern	VO			TEdSetPropByText(PWRKTEDIT pW, WCP pTxt, PAJCTEDPROP pProp);
extern	UI			TEdMakePropText	  (PWRKTEDIT pW, WCP pTxt, UI lTxt);
extern	BOOL		TEdSetCtrlProp(PWRKTEDIT pW, PCAJCTEDPROP pNewProp);
extern	VO			TEdSetHScrollInfo(PWRKTEDIT pW, UI cp);
extern	VO			TEdSetVScrollInfo(PWRKTEDIT pW, UI lp);
