﻿#include	"AjcInternal.h"
#include	"AjcCtrlTextEditDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		ＭＳＩＬ(.NET Framework)対応処理					//
//																												//
//**************************************************************************************************************//
#define	IDC_PARENT	5000
#define	IDC_CTRL	5001

//--------------------------------------------------------------------------------------------------------------//
//	ワーク形式																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HWND	hCtrl;			//	TextEditウインド
	VO (CALLBACK *cbNtcDblClk )(BOOL shift, BOOL ctrl);
	VO (CALLBACK *cbNtcKeyIn  )(UI key );
	VO (CALLBACK *cbNtcVKeyIn )(UI vkey);
	VO (CALLBACK *cbNtcVKeyOut)(UI vkey);
	VO (CALLBACK *cbFileDrop  )(UI n   );
	VO (CALLBACK *cbDirDrop   )(UI n   );
	VO (CALLBACK *cbCharInfo  )(UI LineHeight);
	VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl);
} WKMSIL, *PWKMSIL;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(MSIL);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		TEdWndProcMSIL()
{
	return AJC_WNDPROC_NAME(MSIL);
}
//==============================================================================================================//
//																												//
//	コントロールウインド生成																					//
//																												//
//==============================================================================================================//
AJCEXPORT HWND WINAPI AjcTEdCreateForMSIL(HWND hOwner,	VO (CALLBACK *cbNtcDblClk )(BOOL shift, BOOL ctrl),
														VO (CALLBACK *cbNtcKeyIn  )(UI key ),
														VO (CALLBACK *cbNtcVKeyIn )(UI vkey),
														VO (CALLBACK *cbNtcVKeyOut)(UI vkey),
														VO (CALLBACK *cbFileDrop  )(UI n   ),
														VO (CALLBACK *cbDirDrop   )(UI n   ),
														VO (CALLBACK *cbCharInfo  )(UI LineHeight),
														VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl))
{
	HWND		hBack = NULL;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk = NULL;
	RECT		rect;

	do {
		//----- 親ウインドハンドルチェック ---------------------------------------------------------------------//
		if (!IsWindow(hOwner)) break;
		//----- ワーク領域確保 ---------------------------------------------------------------------------------//
		if ((pWk = (PWKMSIL)AJCMEM(sizeof(WKMSIL))) == NULL) break;
		memset(pWk, 0, sizeof(WKMSIL));
		pWk->cbNtcDblClk = cbNtcDblClk;
		pWk->cbNtcKeyIn  = cbNtcKeyIn ;
		pWk->cbNtcVKeyIn = cbNtcVKeyIn;
		pWk->cbNtcVKeyOut= cbNtcVKeyOut;
		pWk->cbFileDrop  = cbFileDrop ;
		pWk->cbDirDrop	 = cbDirDrop  ;
		pWk->cbCharInfo  = cbCharInfo ;
		pWk->cbRClick	 = cbRClick;
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hOwner, &rect);
		//----- バックウインド生成 -----------------------------------------------------------------------------//
		hBack = CreateWindow((WCP)TEdClassForMSIL,			// window class name
								L"",						// window caption
								WS_CHILD,					// window style
								0,							// initial x position
								0,							// initial y position
								rect.right - rect.left,		// initial x size
								rect.bottom - rect.top,		// initial y size
								hOwner,						// parent window handle
								(HMENU)IDC_PARENT,			// window menu handle
								hDllInst,					// program instance handle
								(VOP)pWk);					// creation parameters
		if (hBack == NULL) break;
		//----- 戻り値（コントロールハンドル）設定 -------------------------------------------------------------//
		hCtrl = pWk->hCtrl;
		//----- チップコントロール対象ウインド設定 -------------------------------------------------------------//
		AJCTIPCTRL_SETHWNDA(hOwner, hCtrl);
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hBack, SW_SHOW);
	} while(0);

	//----- エラーならばリソース解放 ---------------------------------------------------------------------------//
	if (hBack == NULL) {
		if (pWk != NULL) free(pWk);
	}
	return hCtrl;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドプロシージャ																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_CREATE		)
{
	LRESULT		rc	  = -1;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = (PWKMSIL)((LPCREATESTRUCT)lParam)->lpCreateParams;
	RECT		rect;

	do {
		//----- ワークポインタ退避 -----------------------------------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pWk);
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hwnd, &rect);
		//----- ＶＴ１００ウインド生成 -------------------------------------------------------------------------//
		hCtrl = CreateWindow(L"AjcCtrlVT100",										// window class name
							L"",													// window caption
							WS_CHILD | WS_VISIBLE, 				// style
							0,														// initial x position
							0,														// initial y position
							rect.right - rect.left,									// initial x size
							rect.bottom - rect.top,									// initial y size
							hwnd,													// parent window handle
							(HMENU)IDC_CTRL,										// window menu handle
							hDllInst,												// program instance handle
							NULL);													// creation parameters
		if (hCtrl == NULL) break;
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hCtrl, SW_SHOW);
		//----- コントロールのハンドル退避 ---------------------------------------------------------------------//
		pWk->hCtrl = hCtrl;
		//----- 戻り値=正常 ------------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_DESTROY	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk != NULL) {
		if (pWk->hCtrl != NULL) {
			DestroyWindow(pWk->hCtrl);
			pWk->hCtrl = NULL;
		}
		free(pWk);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_SIZE		)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);
	int			width  = LOWORD(lParam);
	int			height = HIWORD(lParam);

	SetWindowPos(pWk->hCtrl, NULL, 0, 0, width, height, SWP_NOMOVE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_RBUTTONDOWN	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk->cbRClick != NULL) {
		pWk->cbRClick((int)LOWORD(lParam), (int)HIWORD(lParam), ((wParam & MK_SHIFT) != 0), ((wParam & MK_CONTROL) != 0));
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, IDC_CTRL		)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (LOWORD(wParam) == IDC_CTRL) {
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MSIL)
	AJC_WNDMAP_MSG(MSIL, WM_CREATE			)
	AJC_WNDMAP_MSG(MSIL, WM_DESTROY			)
	AJC_WNDMAP_MSG(MSIL, WM_SIZE			)
	AJC_WNDMAP_MSG(MSIL, WM_RBUTTONDOWN		)

	AJC_WNDMAP_CMD(MSIL, IDC_CTRL			)
AJC_WNDMAP_END
