﻿#include	"AjcInternal.h"
#include	"AjcCtrlTextEditDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		バックウインド										//
//																												//
//**************************************************************************************************************//

#define	IDC_MAIN	5001

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);
static	VO			DeleteAllResource	  (PWRKTEDIT pW);
static	VO			StyleSetting		  (PWRKTEDIT pW);
static	VO			EnableCtrls			  (PWRKTEDIT pW, BOOL fEnable);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		TEdWndProcBack()
{
	return AJC_WNDPROC_NAME(Back);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	バックウインドプロシージャ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE		)
{
	PWRKTEDIT		pW;
	BOOL			rc = -1;
	RECT			r;
	UI				sty;

	do {
		//----- ウインドワーク生成 -----------------------------------------------------------------------------//
		if ((pW = (PWRKTEDIT)AJCMEM(sizeof(WRKTEDIT))) == NULL) break;
		memset(pW, 0, sizeof(WRKTEDIT));
		//----- インスタンス識別ＩＤ設定 -----------------------------------------------------------------------//
		pW->InstID = INST_ID;
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//----- バックウインドハンドル／ウインドサイズ初期化 ---------------------------------------------------//
		pW->hBack		= hwnd;											//	バックウインドハンドル
		GetClientRect(hwnd, &r);
		pW->bw = r.right - r.left;										//	バックウインドの幅
		pW->bh = r.bottom - r.top;										//	バックウインドの高さ
		//----- 変数初期化 -------------------------------------------------------------------------------------//
		pW->style		  = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);	//	ウインドスタイル
		pW->fEnable		  = !(pW->style & WS_DISABLED);					//	コントロールの有効状態
		pW->fFocus		  = FALSE;										//	フォーカス状態フラグ
		pW->fFirstGetText = TRUE;										//	最初のWM_GETTEXTを示すフラグ
		//----- メインウインド生成 -----------------------------------------------------------------------------//
		sty = (UI)(MAjcGetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_ACCEPTFILES);
		pW->hMain = CreateWindowEx(	sty,
									(WCP)TEdClassMain,					// window class name
									L"",								// window caption
									WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL | WS_CLIPCHILDREN,	// window style
									HMRG,								// initial x position
									VMRG,								// initial y position
									pW->bw - (HMRG * 2),				// initial x size
									pW->bh - (VMRG * 2),				// initial y size
									hwnd,								// parent window handle
									(HMENU)IDC_MAIN,					// window menu handle
									hDllInst,							// program instance handle
									pW);								// creation parameters
		if (pW->hMain == NULL) break;
		AJCTIP_SETFRIENDA(pW->hMain);
		ShowWindow		 (pW->hMain, SW_SHOW);
		//----- スタイル設定 -----------------------------------------------------------------------------------//
		StyleSetting(pW);
		//----- コントロールの有効状態設定 ---------------------------------------------------------------------//
		EnableCtrls(pW, pW->fEnable = !(pW->style & WS_DISABLED));
		//----- スクロール情報初期化 ---------------------------------------------------------------------------//
		TEdSetHScrollInfo(pW, 0);
		TEdSetVScrollInfo(pW, 0);
		//----- 戻り値＝正常終了 -------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	if (rc == -1) {
		DeleteAllResource(pW);
		MAjcSetWindowLong(hwnd, 0, (UX)NULL);
	}

	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY	)
{
	PWRKTEDIT	pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);

	if (pW != NULL) {
		//----- 全リソース解放 -------------------------------------------------//
		DeleteAllResource(pW);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZE		)
{
	PWRKTEDIT	pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);

	//----- ウインドサイズ設定 -----------------------------//
	pW->bw = LOWORD(lParam);
	pW->bh = HIWORD(lParam);
	MoveWindow(pW->hMain, HMRG, VMRG, pW->bw - (HMRG * 2), pW->bh - (VMRG * 2), TRUE);
	InvalidateRect(hwnd, NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_PAINT		)
{
	PWRKTEDIT	pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;

	//	描画開始
	hdc	  = BeginPaint(hwnd, &ps);
	//	描画終了
	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXTLENGTH)
{
	PWRKTEDIT	pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);
	WC			txt[1024] = {0};

	TEdMakePropText(pW, txt, AJCTSIZE(txt));

	return wcslen(txt);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXT	)
{
	PWRKTEDIT	pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	if (pW->fFirstGetText) {
		pW->fFirstGetText = FALSE;
		rc = AjcDefWindowProc(hwnd, msg, wParam, lParam);
	}
	else {
		rc = TEdMakePropText(pW, (WCP)lParam, (UI)wParam);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETTEXT	)
{
	PWRKTEDIT	pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;
	AJCTEDPROP	prop;

	memcpy(&prop, &pW->prop, sizeof(AJCTEDPROP));
	TEdSetPropByText(pW, (WCP)lParam, &prop);
	rc = TEdSetCtrlProp(pW, &prop);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_STYLECHANGED)
{
	PWRKTEDIT		pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);
	LPSTYLESTRUCT	p  = (LPSTYLESTRUCT)lParam;

	if		(wParam == GWL_STYLE) {
		pW->style = p->styleNew;
		StyleSetting(pW);
	}
	else if (wParam == GWL_EXSTYLE) {
		MAjcSetWindowLong(pW->hMain, GWL_EXSTYLE, p->styleNew & WS_EX_ACCEPTFILES);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_ENABLE)
{
	PWRKTEDIT		pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);

	EnableCtrls(pW, pW->fEnable = (BOOL)wParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETFOCUS)
{
	PWRKTEDIT		pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);

	if (pW->hMain) {
		SetFocus(pW->hMain);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETFONT)
{
	PWRKTEDIT		pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);
	AJCVTHPROP		prop;

	if (pW->hMain) {
		//	最初の WM_SETFONT の場合、ウインドキャプションによるプロパティ設定を行う
		//	※	ダイアログ下のコントロールである場合、ダイアログからのWM_SETFONTによりフォントが設定されるが
		//		テキストでフォント設定を優先させるため、キャプションによるフォント設定がある場合は初回のWM_SETFONTをスキップする
		//		尚、キャプション中にフォントの記述が無ければ、SET_FONTの内容がそのまま有効となる。
		if (!pW->fFirstWmSetFont || !pW->fSkipFirstWmSetFont) {	//	２回目以降のWM_SETFONT or WM_SETFONTをスキップしない？
			memcpy(&prop, &pW->prop, sizeof prop);
			if (GetObject((HFONT)wParam, sizeof(LOGFONT), &prop.LogFont) == sizeof(LOGFONT)) {
				//	プロパティ（フォント情報）設定
				AjcVthSetProp(hwnd, &prop);
				//	描画
				InvalidateRect(hwnd 	, NULL, TRUE);
			}
		}
	}
	pW->fFirstWmSetFont = FALSE;

	return 0;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETFONT)
{
	PWRKTEDIT		pW = (PWRKTEDIT)MAjcGetWindowLong(hwnd, 0);
	HFONT			hFont = NULL;

//	if (pW->hMain) {
//		hFont = pW->hFontText;
//	}

	return (LRESULT)hFont;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE				)
	AJC_WNDMAP_MSG(Back, WM_DESTROY				)
	AJC_WNDMAP_MSG(Back, WM_SIZE				)
	AJC_WNDMAP_MSG(Back, WM_PAINT				)
	AJC_WNDMAP_MSG(Back, WM_GETTEXTLENGTH		)
	AJC_WNDMAP_MSG(Back, WM_GETTEXT				)
	AJC_WNDMAP_MSG(Back, WM_SETTEXT				)
	AJC_WNDMAP_MSG(Back, WM_STYLECHANGED		)
	AJC_WNDMAP_MSG(Back, WM_ENABLE				)
	AJC_WNDMAP_MSG(Back, WM_SETFOCUS			)
	AJC_WNDMAP_MSG(Back, WM_SETFONT				)
	AJC_WNDMAP_MSG(Back, WM_GETFONT				)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	全リソース開放																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DeleteAllResource(PWRKTEDIT pW)
{
	if (pW != NULL) {
		free(pW);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	スタイル設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		StyleSetting(PWRKTEDIT pW)
{
	//	再描画
	InvalidateRect(pW->hBack , NULL, FALSE);
	//	スクロール情報設定
	TEdSetHScrollInfo(pW, -1);
	TEdSetVScrollInfo(pW, -1);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロールの有効状態設定																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		EnableCtrls(PWRKTEDIT pW, BOOL fEnable)
{
	InvalidateRect(pW->hBack, NULL, FALSE);
}
