﻿//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				共通定義												//
//																												//
//**************************************************************************************************************//

#define	TCH_FLT_WIDTH	16
#define	TCH_FLT_HEIGHT	16

#define	TCH_IDC_BTN_WIDE	4001			//	ワイドボタンＩＤ
#define	TCH_IDC_BTN_ZOOM	4002			//	ズームボタンＩＤ
#define	TCH_IDC_BTN_MESPERI	4003			//	計測周期表示ボタン

#define	TCH_IDC_SPN_BAR_L	4004			//	低位ゲージ左右移動スピンボタン
#define	TCH_IDC_SPN_BAR_H	4005			//	高位ゲージ左右移動スピンボタン
#define	TCH_IDC_BTN_SETUNIT	4006			//	単位時間設定ボタン

#define	TCH_IDC_CHK_BASE	4100			//	チェックボックスＩＤ

#define	TCH_GAUGE_COLOR		RGB(128, 128, 128)
#define	TCH_SPN_WIDTH		28			//	スピンボタン横サイズ
#define	TCH_BTN_WIDTH		20			//	ボタン横サイズ
#define	TCH_BTN_HEIGHT		23			//	ボタン縦サイズ
#define	TCH_BTN_MRG			3			//	ボタン表示のマージン

#define	TCH_INST_ID			0x254BD681

//--------------------------------------------------------------------------------------------------------------//
//	タイマＩＤ																									//
//--------------------------------------------------------------------------------------------------------------//
enum {
	TCH_TID_OBSERVE		= 1	,		//	監視タイマ
	TCH_TID_MESPERISHOW		,		//	プロット周期表示タイマ
};
//--------------------------------------------------------------------------------------------------------------//
//	横線描画情報																								//
//--------------------------------------------------------------------------------------------------------------//
#define	TCH_MAX_HLINE	8
typedef struct {
	BOOL		fEnable;		//	横線描画許可フラグ
	double		pos;			//	横線描画位置
	HPEN		hPen;			//	描画ペンオブジェクト
	COLORREF	color;			//	描画色
	int			width;			//	線の太さ
	int			style;			//	線種
} TCH_HLINEITEM, *PTCH_HLINEITEM;

//--------------------------------------------------------------------------------------------------------------//
//	プロット点，縦線描画バッファエントリ																		//
//--------------------------------------------------------------------------------------------------------------//
#define		TCH_VLIF_PLOT		0x01	//	プロット点描画フラグ
#define		TCH_VLIF_VLINE		0x02	//	縦線描画フラグ

typedef struct {
	UB			flag;					//	プロット点，縦線データ描画フラグ
	UB			r;						//	プロット点の半径
	UB			width;					//	線の太さ
	UB			style;					//	線のスタイル
	COLORREF	rgb;					//	描画色
} TCH_VLINEBUF, *PTCH_VLINEBUF;

//--------------------------------------------------------------------------------------------------------------//
//	テキスト描画ＡＶＬノード																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	POINT		pt;					//	描画位置
	WC			txt[1];				//	描画テキスト
} TCHTXO, *PTCHTXO;

//--------------------------------------------------------------------------------------------------------------//
//	ウインドワーク																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			InstID;						//	インスタンス識別ＩＤ
	HWND		hBack;						//	バックウインドハンドル
	HWND		hMain;						//	メインウインドハンドル
	HWND		hFilter;					//	フィルタウインドハンドル
	HWND		hChkFilt[AJCTC_MAXITEM];	//	フィルタ・チェックボックス
	HWND		hMeasure;					//	メジャーウインドハンドル
	HBITMAP		hBitmap;					//	グラフ表示ビットマップ
	UI			bw, bh;						//	バックウインドの幅，高さ
	UI			ww, wh;						//	メインウインドの幅，高さ
	UI			style;						//	ウインドスタイル
	UI			MskFilt;					//	フィルタマスク
	BOOL		fInitBusy;					//	初期化中を示すフラグ
	BOOL		fFirstGetText;				//	最初のGET_TEXTフラグ
	BOOL		fEnable;					//	コントロールの有効状態
	BOOL		fScrBar;					//	スクロールバーを掴んでいることを示すフラグ
	//----- データ情報 -----------------------------------------------------------------------------------------//
	BOOL		fStop;						//	停止スイッチ	（データをバッファリングしない）
	BOOL		fPause;						//	表示停止中フラグ（データはバッファリングし、表示のみ停止）
	UI			ixView;						//	バッファの表示位置
	UI			nView;						//	表示個数
	UI			nBuf;						//	バッファに格納されているデータの個数
	UI			nTotal;						//	通算データ数
	UI			ixBuf;						//	バッファに格納するデータの位置
	double		*pBuf;						//	バッファデータポインタ
	PTCH_VLINEBUF	 pVLi;					//	縦線描画情報バッファポインタ
	BOOL		 fVLiEnable;				//	縦線描画許可フラグ
	BOOL		 fPointEnable;				//	プロットポイント描画許可フラグ
	//----- 移動平均情報 ---------------------------------------------------------------------------------------//
	double		AveDat[AJCTC_MAXITEM];		//	平均データバッファ
	//----- 色コード -------------------------------------------------------------------------------------------//
	COLORREF	RgbBorder;					//	ボーダー色
	HPEN		hPenBorder;					//	ボーダー描画ペン
	//----- レンジドラッグ情報 ---------------------------------------------------------------------------------//
	BOOL		fDrag;						//	ドラッグ中フラグ
	POINT		DrgSrt, DrgEnd;				//	ドラッグ開始，終了点
	//----- プロパティ -----------------------------------------------------------------------------------------//
	AJCTCPROP	prop;
	AJCTCPROP	SvProp;
	//----- 右クリック通知情報 ---------------------------------------------------------------------------------//
	BOOL		fNtcRClk;					//	右クリック通知フラグ（TRUE:通知する，FALSE:通知しない）
	UI			MsgRBDown;					//	右ボタンダウン時の通知メッセージコード
	UI			MsgRBUp;					//	右ボタンアップ時の通知メッセージコード
	//----- ボタンハンドル -------------------------------------------------------------------------------------//
	HWND		hBtnWide;					//	ワイドボタン
	HWND		hBtnZoom;					//	ズームボタン
	HWND		hBtnMesPeri;				//	プロット周期計測表示ボタン
	HWND		hSpnBarL;					//	低位ゲージ移動スピンボタン
	HWND		hSpnBarH;					//	高位ゲージ移動スピンボタン
	HWND		hBtnGau;					//	単位時間設定ボタン
	UI			fShowBtns;					//	各ボタン表示中フラグ
	//----- ツールチップ情報 -----------------------------------------------------------------------------------//
	WCP			pToolTipTxt;						//	テキストボックスのツールヒントメッセージ
	WCP			pChkBoxTool[AJCTC_MAXITEM];			//	チェックボックスのツールヒントメッセージ
	BOOL		fShowAlways;						//	グラフィックのツールヒント表示条件
	BOOL		fChkBoxShowAlways[AJCTC_MAXITEM];	//	チェックボックスのツールヒント表示条件
	//----- 最大結線長 -----------------------------------------------------------------------------------------//
	double		MaxLineDist;				//	最大結線長（＝０：全結線，≠０：これ以上長い結線は行わない）
	//----- 横線描画情報テーブル -------------------------------------------------------------------------------//
	TCH_HLINEITEM	HLineTbl[TCH_MAX_HLINE];
	//----- ドロップファイル名一時保留バッファ情報 -------------------------------------------------------------//
	HAJCRNG		hRngFile;					//	リングバッファハンドル
	UB			StaRngFile[1024];			//	スタティックリングバッファ
	//----- ドロップＤＩＲ名一時保留バッファ情報 ---------------------------------------------------------------//
	HAJCRNG		hRngDir;					//	リングバッファハンドル
	UB			StaRngDir[1024];			//	スタティックリングバッファ
	//----- タイトル文字列描画情報 -----------------------------------------------------------------------------//
	CTRL_TTLINFO TtlInfo;						//	タイトルビットマップ情報
	//----- スプライン補間 表示情報 ----------------------------------------------------------------------------//
	AJCTCIPINFO	IpInfo;
	//----- スプライン補間 情報 --------------------------------------------------------------------------------//
	BOOL		fSplineMode;				//	スプライン補間モードフラグ
	//	インスタンス生存中は永続化
	int			SplOrgCx, SplOrgCy;			//	初期表示時のサイズ
	int			SplX , SplY;				//	ダイアログ表示位置（親クライアント領域の位置）
	int			SplCx, SplCy;				//	ダイアログサイズ  （ゼロの場合は無効）
	BOOL		fSplPtEna;					//	補間波形上のプロット点描画フラグ
	//	ワーク（スプライン・ダイアログ生成時に初期化）
	HWND		hDlgSpline;					//	スプライン・ダイアログハンドル
	HWND		hTchSpline;					//	タイムチャート・ハンドル
	BOOL		fSplCancel;					//	スプライン補間ダイアログ・キャンセル操作フラグ
	BOOL		fSplStop;					//	スプライン表示中止フラグ
	BOOL		fSplBusy;					//	スプライン幅設定ビジーフラグ
	int			SplMinCx, SplMinCy;			//	ダイアログの最小サイズ（オリジナルのダイアログサイズ）
	AJCTCPROP	SplProp;					//	プロパティ情報
	UI			nSplBuf;					//	バッファに格納されているデータの個数
	double		*pSplBuf;					//	バッファデータポインタ
	//----- 通知情報 -------------------------------------------------------------------------------------------//
	AJCTCRCLK			NtcRClk;			//	右クリック通知情報
	UI					NtcDirs;			//	ドロップしたディレクトリ数
	UI					NtcFiles;			//	ドロップしたファイル数
	AJCTC_NTC_RANGE		NtcRng;				//	グラフレンジ情報
	UI					NtcScrPos;			//	スクロール位置
	//----- 描画時間計測情報 -----------------------------------------------------------------------------------//
	BOOL				fMesDrawEnable;		//	描画時間計測ポップアップメニューの許可／禁止
	HWND				hDlgMesDraw;		//	速度情報表示ダイアログ
	HAJCMESTIME			hMesDraw;			//	描画時間計測インスタンス
	AJCMSTINFO			MesDraw;			//	描画時間計測データ
	//----- プロット周期計測情報 -------------------------------------------------------------------------------//
	BOOL			   fMesPeriShow;		//	プロット周期計測表示フラグ
	UL					MesPeriCnt;			//	プロット回数
	UL					MesPeriSetAveS;		//	「平均プロット周期[us] - 表示値」を設定するプロット回数
	UL					MesPeriAve;			//	平均プロット周期[us]
	UL					MesPeriAveS;		//	平均プロット周期[us] - 表示値
	ULL					MesPeriSrt;			//	計測開始時刻（パフォーマンスカウンタ値）
	RECT				MesPeriSvRect;		//	メインウインド位置退避
	//----- 時間計測ゲージ情報 ---------------------------------------------------------------------------------//
	BOOL				fGauEnable;			//	ゲージ許可フラグ
	UI					GauBarL;			//	ゲージ低位置
	UI					GauBarH;			//	ゲージ高位置
	BOOL				fGauUseMes;			//	単位時間＝計測値を示すフラグ
	UI					GauSetUTime;		//	単位時間（設定値）[us]
	//----- 永続化用ワーク -------------------------------------------------------------------------------------//
	UI					PermItem;			//	永続化項目
	WC					PermSect[256];		//	永続化情報記録用セクション名
	WC					PermKey [256];		//	永続化情報記録用キーの接頭語
	//----- テキスト描画情報 -----------------------------------------------------------------------------------//
	HFONT				hFontTxo;				//	テキスト描画フォント
	HAJCTXO				hTxo;					//	テキスト描画インスタンス
	UI					kAvlTxo;				//	テキスト描画ＡＶＬキー
	HAJCAVL				hAvlTxo;				//	テキス描画ＡＶＬ
} WRKTMCHART, *PWRKTMCHART;

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
extern	ATOM	TchClassBack;			//	バックウインドクラス
extern	ATOM	TchClassMain;			//	メインウインドクラス
extern	ATOM	TchClassFilter;			//	フィルタウインドクラス
extern	ATOM	TchClassMeasure;		//	メジャーウインドクラス
extern	ATOM	TchClassForMSIL;		//	ＭＳＩＬサポート
extern	HFONT	TchMyFont;				//	フォントハンドル（スケール値表示用）

extern	ULL		TchPfmFreq;				//	パフォーマンスカウンタの周波数（０：パフォーマンスカウンタ不可）
extern	HPEN	TchPenGauBar;			//	時間測定ゲージバーのペン

//--------------------------------------------------------------------------------------------------------------//
//	グローバル サブ関数																							//
//--------------------------------------------------------------------------------------------------------------//
extern	WNDPROC		TchWndProcBack();
extern	WNDPROC		TchWndProcMain();
extern	WNDPROC		TchWndProcFilt();
extern	WNDPROC		TchWndProcMSIL();

extern	BOOL	TchSetProp			(PWRKTMCHART pW, PCAJCTCPROP pNew);
extern	BOOL	TchGetProp			(PWRKTMCHART pW, PAJCTCPROP pBuf);
extern	BOOL	TchSetBorderColor	(PWRKTMCHART pW, COLORREF color);

extern	VO		TchCreateDlgSpline	(PWRKTMCHART pW);
extern	VO		TchDialogBoxSetRange(PWRKTMCHART pW);
extern	VO		TchDialogBoxOffset  (PWRKTMCHART pW);
extern	VO		TchDialogBoxSetOther(PWRKTMCHART pW);
extern	VO		TchDialogBoxSplSet  (PWRKTMCHART pW);
extern	VO		TchDialogBoxUnitTime(PWRKTMCHART pW);

extern	VO		TchSetScrollBar	  (PWRKTMCHART pW);
extern	VO		TchSetViewIndex	  (PWRKTMCHART pW);
extern	VO		TchSetViewWidth	  (PWRKTMCHART pW);
extern	UI		TchBixToDix		  (PWRKTMCHART pW, UI bix);
extern	UI		TchDixToBix		  (PWRKTMCHART pW, UI dix);
extern	VO		TchMesPeriReset	  (PWRKTMCHART pW);

