﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				オフセット設定ダイアログ								//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Offset);

//==============================================================================================================//
//																												//
//	データオフセット値設定ダイアログボックス生成																//
//																												//
//==============================================================================================================//
VO		TchDialogBoxOffset	(PWRKTMCHART pW)
{
	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_TCHOFFSET ), pW->hMain, AJC_DLGPROC_NAME(Offset), (LPARAM)pW);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	データオフセット値設定ダイアログプロシージャ																//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Offset, WM_INITDIALOG	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)lParam;
	UI			i, digit, prec, sty;
	double		RngH = fabs(pW->prop.RngH - pW->prop.RngL);
	double		RngL = -RngH;
	double		SldUnit = AjcAdjustPow10(RngH / 200.0, &digit, &prec);
	double		SldPage = SldUnit * 10.0;
	double		SpnStep = SldUnit;

	//----- ワークポインタをウインドに設定 ------------//
	SetProp(hDlg, L"AjcTchOffset", pW);
	//----- アイコン設定 ------------------------------//
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);
	//----- プロパティ退避 ----------------------------//
	memcpy(&pW->SvProp, &pW->prop, sizeof(AJCTCPROP));
	//----- ウインドタイトル設定 ----------------------//
	SetWindowText (hDlg, LNGSEL(L"データオフセット値設定", L"Set offset value"));
	SetDlgItemText(hDlg, IDC_TCHCMD_RESET, LNGSEL(L"リセット"  , L"Reset"));
	SetDlgItemText(hDlg, IDOK			 , LNGSEL(L"ＯＫ"	   , L"OK"	 ));
	SetDlgItemText(hDlg, IDCANCEL		 , LNGSEL(L"キャンセル", L"Cancel"	 ));
	//----- コントロールのレンジ設定 ------------------//
	for (i=0; i<AJCTC_MAXITEM; i++) {
		sty = (UI)MAjcGetWindowLong(GetDlgItem(hDlg, IDC_TCHINP_OFS0 + i), GWL_STYLE);
		MAjcSetWindowLong(GetDlgItem(hDlg, IDC_TCHINP_OFS0 + i), GWL_STYLE, sty | AJCIVS_REALMODE);
		SendDlgItemMessage(hDlg, IDC_TCHINP_OFS0 + i, AJCIVM_SETBORDERCOLOR, pW->prop.Item[i].rgb, 0);
		SendDlgItemMessage(hDlg, IDC_TCHINP_OFS0 + i, AJCIVM_R_SETRANGE	  , (WPARAM)&RngL, (LPARAM)&RngH);
		SendDlgItemMessage(hDlg, IDC_TCHINP_OFS0 + i, AJCIVM_R_SETSLDUNIT , (WPARAM)&SldUnit, 0);
		SendDlgItemMessage(hDlg, IDC_TCHINP_OFS0 + i, AJCIVM_R_SETSLDPAGE , (WPARAM)&SldPage, 0);
		SendDlgItemMessage(hDlg, IDC_TCHINP_OFS0 + i, AJCIVM_R_SETSPNSTEP , (WPARAM)&SpnStep, 0);
		SendDlgItemMessage(hDlg, IDC_TCHINP_OFS0 + i, AJCIVM_SETTEXTFORMAT, digit + prec + 5, prec);
		AjcSetDlgItemReal (hDlg, IDC_TCHINP_OFS0 + i, pW->prop.Item[i].ofs, prec);
		if (i >= pW->prop.MaxItem) {
			EnableWindow(GetDlgItem(hDlg, IDC_TCHINP_OFS0 + i), FALSE);
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Offset, WM_COMMAND		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchOffset");
	UI			ix	= LOWORD(wParam) - IDC_TCHINP_OFS0;
	UI			ntc = HIWORD(wParam);
	AJCTCPROP	prop;

	memcpy(&prop, &pW->prop, sizeof(AJCTCPROP));
	if (ntc == AJCIVN_REALVALUE	 &&	 ix < pW->prop.MaxItem) {
		prop.Item[ix].ofs = *((double *)lParam);
		TchSetProp(pW, &prop);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Offset, IDC_TCHCMD_RESET)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchOffset");
	UI			i;
	AJCTCPROP	prop;

	memcpy(&prop, &pW->prop, sizeof(AJCTCPROP));
	for (i=0; i<AJCTC_MAXITEM; i++) {
		prop.Item[i].ofs = 0.0;
		AjcSetDlgItemReal(hDlg, IDC_TCHINP_OFS0 + i, 0.0, 0);
	}

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Offset, IDOK			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchOffset");
	EndDialog(hDlg, IDOK);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Offset, IDCANCEL		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchOffset");

	TchSetProp(pW, &pW->SvProp);
	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Offset)
	AJC_DLGMAP_MSG(Offset, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Offset, WM_COMMAND		)
	AJC_DLGMAP_CMD(Offset, IDC_TCHCMD_RESET	)
	AJC_DLGMAP_CMD(Offset, IDOK				)
	AJC_DLGMAP_CMD(Offset, IDCANCEL			)
AJC_DLGMAP_END
