﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				その他の設定ダイアログ									//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Other);

//==============================================================================================================//
//																												//
//	その他の設定ダイアログボックス生成																			//
//																												//
//==============================================================================================================//
VO		TchDialogBoxSetOther  (PWRKTMCHART pW)
{
	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_TCHSETOTHER), pW->hMain, AJC_DLGPROC_NAME(Other), (LPARAM)pW);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	その他の設定ダイアログプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Other, WM_INITDIALOG	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)lParam;

	SetProp(hDlg, L"AjcTchOther", pW);

	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);
	SetWindowText (hDlg, LNGSEL(L"その他の設定", L"Set Others"));
	SetDlgItemText(hDlg, IDC_TCHLBL_AVENUM	  , LNGSEL(L"平均化個数"				, L"Averaging number"				));
	SetDlgItemText(hDlg, IDC_TCHLBL_TIMESCALE , LNGSEL(L"タイム・スケール幅"		, L"Time scale width"				));
	SetDlgItemText(hDlg, IDC_TCHNOTE_TIMESCALE, LNGSEL(L"（０：非表示）"			, L"(0:Hide)"						));
	SetDlgItemText(hDlg, IDC_TCHLBL_BUFSIZE	  , LNGSEL(L"バッファに格納するデータ数", L"Number of data stored in buffer"));
	SetDlgItemText(hDlg, IDOK				  , LNGSEL(L"ＯＫ"						, L"OK" 							));
	SetDlgItemText(hDlg, IDCANCEL			  , LNGSEL(L"キャンセル"				, L"Cancel" 						));

	AjcSetDlgItemUInt(hDlg, IDC_TCHTXT_AVENUM	, pW->prop.AveNum );
	AjcSetDlgItemUInt(hDlg, IDC_TCHTXT_TIMESCALE, pW->prop.TmScale);
	AjcSetDlgItemUInt(hDlg, IDC_TCHINP_BUFSIZE	, pW->prop.MaxBuf );

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Other, IDOK			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchOther");
	AJCTCPROP	prop;

	memcpy(&prop, &pW->prop, sizeof(AJCTCPROP));
	prop.AveNum	 = AjcGetDlgItemUInt(hDlg, IDC_TCHTXT_AVENUM   );
	prop.TmScale = AjcGetDlgItemUInt(hDlg, IDC_TCHTXT_TIMESCALE);
	prop.MaxBuf	 = AjcGetDlgItemUInt(hDlg, IDC_TCHINP_BUFSIZE  );
	TchSetProp(pW, &prop);
	EndDialog(hDlg, IDOK);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Other, IDCANCEL		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchOther");

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Other)
	AJC_DLGMAP_MSG(Other, WM_INITDIALOG	)
	AJC_DLGMAP_CMD(Other, IDOK			)
	AJC_DLGMAP_CMD(Other, IDCANCEL		)
AJC_DLGMAP_END
