﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				補間表示設定ダイアログプ								//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(SplSet);

//==============================================================================================================//
//																												//
//	補間表示設定ダイアログボックス生成																			//
//																												//
//==============================================================================================================//
VO		TchDialogBoxSplSet	(PWRKTMCHART pW)
{
	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_TCHSPLSET), pW->hMain, AJC_DLGPROC_NAME(SplSet), (LPARAM)pW);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	補間表示設定ダイアログプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SplSet, WM_INITDIALOG	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)lParam;

	//----- ワークポインタをウインドに設定 ------------//
	SetProp(hDlg, L"AjcTchSplSet", pW);
	//----- アイコン設定 ------------------------------//
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);
	//----- 日英テキスト ------------------------------//
	SetWindowText (hDlg, LNGSEL(L"補間表示の設定", L"Interpolation information"));
	SetDlgItemText(hDlg, IDC_GRP_DATSEL	, LNGSEL(L"補間表示するデータ"				, L"Kind of data an interpolation"));
	SetDlgItemText(hDlg, IDC_RBT_WND	, LNGSEL(L"表示されているデータ"			, L"Displayed data"));
	SetDlgItemText(hDlg, IDC_RBT_ALL	, LNGSEL(L"全データ"						, L"All data"));
	SetDlgItemText(hDlg, IDC_RBT_NEW	, LNGSEL(L"最新データ"						, L"Latest data"));
	SetDlgItemText(hDlg, IDC_LBL_DATNUM	, LNGSEL(L"データ個数"						, L"Number"));
	SetDlgItemText(hDlg, IDC_GRP_WIDTH	, LNGSEL(L"補間幅（波形を引き延ばす倍率）"	, L"Interpolation width"));
	SetDlgItemText(hDlg, IDC_LBL_WIDTH	, LNGSEL(L"( 2 ～ 100 )"					, L"(2 to 100)"));
	SetDlgItemText(hDlg, IDOK			, LNGSEL(L"ＯＫ"							, L"OK"));
	SetDlgItemText(hDlg, IDCANCEL		, LNGSEL(L"キャンセル"						, L"Cancel"));
	//----- ラジオボタンをグループ化 -----------------//
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_DATSEL));
	//----- 設定値表示 -------------------------------//
	AjcSetDlgItemUInt(hDlg, IDC_GRP_DATSEL, pW->IpInfo.IpKnd);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_DATNUM, pW->IpInfo.IpNum);
	AjcSetDlgItemUInt(hDlg, IDC_INP_SPLWID, pW->IpInfo.IpWidth);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SplSet, IDOK			)
{
	PWRKTMCHART	pW = GetProp(hDlg, L"AjcTchSplSet");

	//----- 設定値設定 --------------------------------//
	pW->IpInfo.IpKnd	= AjcGetDlgItemUInt(hDlg, IDC_GRP_DATSEL);
	pW->IpInfo.IpNum	= AjcGetDlgItemUInt(hDlg, IDC_TXT_DATNUM);
	pW->IpInfo.IpWidth	= AjcGetDlgItemUInt(hDlg, IDC_INP_SPLWID);

	pW->IpInfo.IpNum = __max(pW->IpInfo.IpNum, 10);

	EndDialog(hDlg, IDOK);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SplSet, IDCANCEL		)
{
	PWRKTMCHART	pW = GetProp(hDlg, L"AjcTchSplSet");

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(SplSet)
	AJC_DLGMAP_MSG(SplSet, WM_INITDIALOG)
	AJC_DLGMAP_CMD(SplSet, IDOK			)
	AJC_DLGMAP_CMD(SplSet, IDCANCEL		)
AJC_DLGMAP_END
