﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				スプライン補間波形・ダイアログ							//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Spline);

//==============================================================================================================//
//																												//
//	スプライン補間波形ウインド生成																				//
//																												//
//==============================================================================================================//
VO		TchCreateDlgSpline	(PWRKTMCHART pW)
{
	//	スプライン補間表示ダイアログ生成
	if (pW->hDlgSpline == NULL) {
		pW->hDlgSpline = CreateDialogParam(hDllInst, MAKEINTRESOURCE(IDD_TCHSPLINE), NULL, AJC_DLGPROC_NAME(Spline), (LPARAM)pW);
	}
	//	ダイアログ表示
	if (pW->hDlgSpline != NULL) {
		ShowWindow(pW->hDlgSpline, SW_SHOW);
		AjcMoveWndIntoMonitor(pW->hDlgSpline);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	スプライン補間波形・ダイアログプロシージャ																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#define		SPLDLGPROP		L"SplineDlg"
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Spline, WM_INITDIALOG		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)lParam;
	RECT		rcMon;
	RECT		rcDlg;
	RECT		rcCtl;
	UI			xMon, yMon, cxMon, cyMon;
	UI			i, ixTop;

	pW->hDlgSpline = hDlg;
	pW->hTchSpline = GetDlgItem(hDlg, IDC_TMCHART);
	SetProp(hDlg, SPLDLGPROP, (HANDLE)pW);

	//	アイコン設定
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);

	//	ダイアログ内のタイムチャートコントロールへ、情報設定
	{	PWRKTMCHART	p = (PWRKTMCHART)MAjcGetWindowLong(pW->hTchSpline, 0);
		//	スプライン補正モードフラグ設定
		p->fSplineMode = TRUE;
	}

	//	フラグクリアー
	pW->fSplCancel	= FALSE;
	pW->fSplBusy	= FALSE;

	//	日英テキスト
	SetWindowText(hDlg, LNGSEL(L"タイムチャート補間表示", L"TimeChart Interpolation"));
	AjcSetDlgItemStr(hDlg, IDC_LBL_WIDTH	, LNGSEL(L"補間幅 ( 2 ～ 100 )", L"Interpolation width"));
	AjcSetDlgItemStr(hDlg, IDC_CHK_SHOWPOINT, LNGSEL(L"プロット点 表示"    , L"Show plot point"));
	AjcSetDlgItemStr(hDlg, IDC_CMD_RESIZE	, LNGSEL(L"元のサイズに戻す"   , L"Original size"));

	//	ダイアログ最小サイズ設定
	GetWindowRect(hDlg, &rcDlg);
	pW->SplMinCx  = rcDlg.right - rcDlg.left;
	pW->SplMinCy  = rcDlg.bottom - rcDlg.top;

	//	オリジナルコントロールの矩形情報設定
	GetWindowRect(pW->hBack, &rcCtl);
	//	モニタサイズ設定
	AjcGetMonitorInfoOfPoint(rcCtl.left, rcCtl.top, NULL, &rcMon);
	xMon  = rcMon.left;
	yMon  = rcMon.top;
	cxMon = rcMon.right - rcMon.left;
	cyMon = rcMon.bottom - rcMon.top;

	//	ダイアログ表示位置，サイズ初期設定
	if (pW->SplCx == 0) {
		UI		cx = rcCtl.right - rcCtl.left;
		UI		cy = rcCtl.bottom - rcCtl.top;
		UI		mx, my;
		RECT	r;
		//	オリジナルのコントロールサイズ設定
		cx = rcCtl.right - rcCtl.left;
		cy = rcCtl.bottom - rcCtl.top;
		//	モニタの６０％のサイズに調整
		if (cx > (cxMon * 60 / 100)) cx = (cxMon * 60 / 100);
		if (cy > (cyMon * 60 / 100)) cy = (cyMon * 60 / 100);
		//	マージンサイズ（ダイアログとタイムチャートコントロールの差）設定
		GetWindowRect(pW->hTchSpline, &r);
		mx = pW->SplMinCx - (r.right - r.left);
		my = pW->SplMinCy - (r.bottom - r.top);
		//	ダイアログサイズ設定
		pW->SplCx = cx + mx;
		pW->SplCy = cy + my;
		//	モニタの中央に設定
		pW->SplX = xMon + (cxMon - pW->SplCx) / 2;
		pW->SplY = yMon + (cyMon - pW->SplCy) / 2;
		//	オリジナルサイズ退避
		pW->SplOrgCx = pW->SplCx;
		pW->SplOrgCy = pW->SplCy;
	}
	MoveWindow(hDlg, pW->SplX, pW->SplY, pW->SplCx, pW->SplCy, FALSE);

	//	プロパティ情報退避
	memcpy(&pW->SplProp, &pW->prop, sizeof(pW->SplProp));
	pW->SplProp.AveNum	= 1;

	//	タイムチャートコントロールの横線設定
	for (i = 0; i < TCH_MAX_HLINE; i++) {
		if (pW->HLineTbl[i].fEnable) {
			AjcTchSetHLineAtt(pW->hTchSpline, i, pW->HLineTbl[i].color, pW->HLineTbl[i].width, pW->HLineTbl[i].style);
			AjcTchSetHLinePos(pW->hTchSpline, i, pW->HLineTbl[i].pos);
		}
	}

	//	プロットデータコピー済ならば、一旦解放
	if (pW->pSplBuf != NULL) {
		free(pW->pSplBuf);
		pW->pSplBuf = NULL;
	}

	//	プロットデータの先頭インデクスとデータ数設定
	switch (pW->IpInfo.IpKnd) {
		default:
		case AJCTCIPK_WND:								//	●ウインド表示データ
			if (pW->nView >= 8) {
				ixTop		= TchBixToDix(pW, pW->ixView);
				pW->nSplBuf = pW->nView;
			}
			//	ウインド表示データが少ない場合は終了
			else {
				DestroyWindow(hDlg);
				goto spl_init_end;
			}
			break;

		case AJCTCIPK_ALL:								//	●全データ
			ixTop		= 0;
			pW->nSplBuf = pW->nBuf;
			break;

		case AJCTCIPK_NEW:								//	●最新データ
			if (pW->nBuf >= pW->IpInfo.IpNum) {
				ixTop		= pW->nBuf - pW->IpInfo.IpNum;
				pW->nSplBuf = pW->IpInfo.IpNum;
			}
			else {
				ixTop		= 0;
				pW->nSplBuf = pW->nBuf;
			}
			break;
	}

	//	プロットデータコピー
	pW->pSplBuf = (double *)AJCMEM(sizeof(double) * pW->SplProp.MaxItem * pW->nSplBuf);
	if (pW->pSplBuf != NULL) {
		UI		i, ix, ixs;
		double	*pS;
		double	*pD;

		pD = pW->pSplBuf;
		for (i = 0, ix = ixTop; i < pW->nSplBuf; i++, ix++) {
			ixs = TchDixToBix(pW, ix);
			pS	= pW->pBuf + (ixs * pW->SplProp.MaxItem);
			memcpy(pD, pS, sizeof(double) * pW->prop.MaxItem);
			pD += pW->SplProp.MaxItem;
		}
	}
	//	バッファ確保失敗ならば終了
	else {
		DestroyWindow(hDlg);
		goto spl_init_end;
	}

	//	プロット点表示／非表示設定
	AjcTchEnablePoint(pW->hTchSpline, pW->fSplPtEna);
	//	プロット点表示チェックボックス設定
	AjcSetDlgItemChk(hDlg, IDC_CHK_SHOWPOINT, pW->fSplPtEna);
	//	補間データ投与
	AjcSetDlgItemUInt(hDlg, IDC_INP_WIDTH, pW->IpInfo.IpWidth);

	//	表示開始ディレィタイマ
	SetTimer(hDlg, 1, 200, NULL);

spl_init_end:;

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Spline, WM_DESTROY			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, SPLDLGPROP);
	RECT		r;

	//	ウインド位置，サイズ退避
	GetWindowRect(hDlg, &r);
	pW->SplX  = r.left;
	pW->SplY  = r.top;
	pW->SplCx = r.right - r.left;
	pW->SplCy = r.bottom - r.top;
	//	リソース解放
	if (pW->hTchSpline != NULL) {DestroyWindow(pW->hTchSpline); pW->hTchSpline = NULL;}
	pW->hTchSpline = NULL;
	pW->hDlgSpline = NULL;

	return TRUE;
}
//----- サイズ変更中 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Spline, WM_SIZING			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, SPLDLGPROP);
	LPRECT		p = (LPRECT)lParam;
	int			w = p->right - p->left;
	int			h = p->bottom - p->top;

	if (w < pW->SplMinCx) p->right	= p->left + pW->SplMinCx;
	if (h < pW->SplMinCy) p->bottom = p->top  + pW->SplMinCy;

	return TRUE;
}
//----- サイズ変更 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Spline, WM_SIZE				)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, SPLDLGPROP);
	RECT		r;
	int			yTop;
	int			w, h;

	//	タイムチャートコントロールのＹ位置設定
	GetWindowRect(pW->hTchSpline, &r);
	ScreenToClient(hDlg, (LPPOINT)&r);
	yTop = r.top;

	//	タイムチャートコントロールのサイズ設定
	GetClientRect(hDlg, &r);
	w = r.right - r.left;
	h = r.bottom - r.top - yTop;
	MoveWindow(pW->hTchSpline, 0, yTop, w, h, TRUE);

	return TRUE;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Spline, WM_TIMER		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, SPLDLGPROP);
	BOOL		fErr = FALSE;
	UI			SvIpWidth;
	UI			i, j, e, r;
	double		v;
	double		*p;
	double		*x = NULL;
	double		*y [AJCTC_MAXITEM];
	double		*z [AJCTC_MAXITEM];
	double		dat[AJCTC_MAXITEM];
	AJCTCPROP	prop;

	if (wParam == 1) {
		//	タイマ停止
		KillTimer(hDlg, 1);

		if (!pW->fSplBusy) {
			//	ビジーフラグ設定
			pW->fSplBusy = TRUE;
			//	元の補間幅退避
			SvIpWidth = pW->IpInfo.IpWidth;
			//	補間幅設定値取得
			pW->IpInfo.IpWidth = AjcGetDlgItemUInt(hDlg, IDC_INP_WIDTH);
			//	ワークポインタクリアー
			x = NULL;
			for (i = 0; i < AJCTC_MAXITEM; i++) {
				y[i] = NULL;
				z[i] = NULL;
			}
			do {
				//	スプライン補間バッファ確保
				x = (double *)AJCMEM(sizeof(double) * pW->nSplBuf);
				if (x == NULL) {fErr = TRUE; break;}
				for (i = 0; i < pW->SplProp.MaxItem; i++) {
					y[i] = (double *)AJCMEM(sizeof(double) * pW->nSplBuf);
					z[i] = (double *)AJCMEM(sizeof(double) * pW->nSplBuf);
					if (y[i] == NULL || z[i] == NULL) {fErr = TRUE; break;}
				}
				if (fErr) break;
				//	タイムチャートコントロールの補間情報設定
				AjcTchSetIpInfo(pW->hTchSpline, &pW->IpInfo);
				//	タイムチャートコントロールのプロパティ設定
				memcpy(&prop, &pW->SplProp, sizeof prop);
				prop.TmScale = pW->SplProp.TmScale * pW->IpInfo.IpWidth;
				prop.MaxBuf  = pW->nSplBuf * pW->IpInfo.IpWidth;
				if (!AjcTchSetProp(pW->hTchSpline, &prop)) {fErr = TRUE; break;}
				//	タイムチャートコントロールのフィルタ設定
				for (i = 0; i < AJCTC_MAXITEM; i++) {
					AjcTchSetFilter(pW->hTchSpline, i, AjcTchGetFilter(pW->hBack, i)); 
				}
				//	スプライン補間データ設定
				for (j = 0, v = 0.0; j < pW->nSplBuf; j++, v += pW->IpInfo.IpWidth) {
					x[j] = v;
				}
				p = pW->pSplBuf;
				for (i = 0; i < pW->nSplBuf; i++) {
					for (j = 0; j < pW->SplProp.MaxItem; j++) {
						y[j][i] = *p++;
						z[j][i] = 0.0;
					}
				}
				//	スプライン補間テーブル作成
				for (i = 0; i < pW->SplProp.MaxItem; i++) {
					AjcSplMkTbl(pW->nSplBuf, x, y[i], z[i]);
				}
				//	タイムチャートプロパティ（タイムスケール幅）設定
				AjcTchGetProp(pW->hTchSpline, &prop);
				prop.TmScale = pW->prop.TmScale * pW->IpInfo.IpWidth;
				AjcTchSetProp(pW->hTchSpline, &prop);
				//	タイムチャート・プロットデータクリアー
				AjcTchPurge(pW->hTchSpline);
				//	スプライン補間データ投与
				if (pW->IpInfo.IpWidth <= 8) r = 1;
				else						 r = 2;
				e = pW->nSplBuf * pW->IpInfo.IpWidth - (pW->IpInfo.IpWidth - 1);
				for (i = 0; i < e && !pW->fSplCancel; i++) {
					if (pW->fSplStop) break;
					for (j = 0; j < pW->SplProp.MaxItem; j++) {
						dat[j] = AjcSplCalc(pW->nSplBuf, (double)i, x, y[j], z[j]);
					}
					AjcTchPutRealData(pW->hTchSpline, dat);
					if ((i % pW->IpInfo.IpWidth) == 0) {
						AjcTchSetPoint(pW->hTchSpline, r);
						AjcDoEventA();
					}
				}
			} while(0);
			//	スプライン補間バッファ解放
			if (x != NULL) free(x);
			for (i = 0; i < AJCTC_MAXITEM; i++) {
				if (y[i] != NULL) free(y[i]);
				if (z[i] != NULL) free(z[i]);
			}
			//	エラーメッセージ
			if (fErr) {
				MessageBoxW(NULL, LNGSEL(L"スプライン補間表示を失敗しました。", L"Spline interpolation failure."),
								 AppName, MB_ICONERROR);
				//	補間幅を元の値に戻す
				AjcSetDlgItemUInt(hDlg, IDC_INP_WIDTH, pW->IpInfo.IpWidth = SvIpWidth);
			}
			//	停止フラグ解除
			pW->fSplStop = FALSE;
			//	ビジーフラグ解除
			pW->fSplBusy = FALSE;
			//	キャンセルならば、ウインド破棄
			if (pW->fSplCancel) {
				DestroyWindow(hDlg);
			}
		}
	}

	return TRUE;
}
//----- 補間の幅設定（数値入力）--------------------------------------------------------------------------------//
AJC_DLGPROC(Spline, IDC_INP_WIDTH		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, SPLDLGPROP);

	if (HIWORD(wParam) == AJCIVN_INTVALUE) {
		int		cnt = 0;
		if (pW->fSplBusy) {
			pW->fSplStop = TRUE;
			while (pW->fSplBusy && cnt++ < 10) {
				AjcDoEventA();
				Sleep(10);
			}
		}
		SetTimer(hDlg, 1, 200, NULL);
	}
	return TRUE;
}
//----- プロット点表示チェックボックス -------------------------------------------------------------------------//
AJC_DLGPROC(Spline, IDC_CHK_SHOWPOINT	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, SPLDLGPROP);

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcTchEnablePoint(pW->hTchSpline, pW->fSplPtEna = AjcGetDlgItemChk(hDlg, IDC_CHK_SHOWPOINT));
	}
	return TRUE;
}
//----- 元のサイズへ戻す ボタン --------------------------------------------------------------------------------//
AJC_DLGPROC(Spline, IDC_CMD_RESIZE		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, SPLDLGPROP);

	if (HIWORD(wParam) == BN_CLICKED) {
		SetWindowPos(hDlg, NULL, 0, 0, pW->SplOrgCx, pW->SplOrgCy, SWP_NOMOVE);
	}
	return TRUE;
}
//----- Cancel -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Spline, IDCANCEL			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, SPLDLGPROP);

	if (pW->fSplBusy) {
		pW->fSplCancel = TRUE;
	}
	else {
		DestroyWindow(hDlg);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Spline)
	AJC_DLGMAP_MSG(Spline, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Spline, WM_DESTROY		)
	AJC_DLGMAP_MSG(Spline, WM_SIZING		)
	AJC_DLGMAP_MSG(Spline, WM_SIZE			)
	AJC_DLGMAP_MSG(Spline, WM_TIMER			)
	AJC_DLGMAP_CMD(Spline, IDC_INP_WIDTH	)
	AJC_DLGMAP_CMD(Spline, IDC_CHK_SHOWPOINT)
	AJC_DLGMAP_CMD(Spline, IDC_CMD_RESIZE	)
	AJC_DLGMAP_CMD(Spline, IDCANCEL			)
AJC_DLGMAP_END

