﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				時間計測用単位時間設定ダイアログ						//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(UnitTime);

//==============================================================================================================//
//																												//
//	時間計測用単位時間設定ダイアログボックス生成																//
//																												//
//==============================================================================================================//
VO		TchDialogBoxUnitTime  (PWRKTMCHART pW)
{
	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_TCHGAUBAR), pW->hMain, AJC_DLGPROC_NAME(UnitTime), (LPARAM)pW);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	時間計測用単位時間設定ダイアログプロシージャ																//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(UnitTime, WM_INITDIALOG	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)lParam;

	//----- ワークポインタをウインドに設定 ------------//
	SetProp(hDlg, L"AjcTchUnitTime", pW);

	//----- 日英テキスト ------------------------------//
	SetWindowText (hDlg, LNGSEL(L"時間計測用単位時間の設定", L"Setting of unit time for time measurement"));
	SetDlgItemText(hDlg, IDC_LBL_NOTE1	  , LNGSEL(L"時間計測用の単位時間（サンプリング周期）を指定します。",
												   L"Specify the unit time(sampling period) for time measurement."));
	SetDlgItemText(hDlg, IDC_LBL_NOTE2	  , LNGSEL(L"（単位時間とは横１ピクセル分の時間で、データの投与周期を意味します）",
												   L"(The unit time is the time for one pixel horizontally, which is equal to the data sampling cycle.)"));
	SetDlgItemText(hDlg, IDC_RBT_SET	  , LNGSEL(L"単位時間を指定する" 		, L"Specify the unit time"	   ));
	SetDlgItemText(hDlg, IDC_RBT_MES	  , LNGSEL(L"計測した単位時間を使用する", L"Use the measured unit time"));
	SetDlgItemText(hDlg, IDOK			  , LNGSEL(L"ＯＫ"		, L"OK"    ));
	SetDlgItemText(hDlg, IDCANCEL		  , LNGSEL(L"キャンセル", L"Cancel"));

	//----- ボタンにイメージ設定 ----------------------//
	SendMessage(GetDlgItem(hDlg, IDC_CMD_UPD), BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoReset);

	//----- チップテキスト ----------------------------//
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_UTIME), LNGSEL(L"計測済み単位時間（データ投与周期）",
														  L"Measured unit time (plot period)"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_UPD	), LNGSEL(L"計測した単位時間を更新", L"Update the measured unit time"));

	//----- 単位時間 ----------------------------------//
	AjcSetDlgItemChk (hDlg, IDC_RBT_SET  , !pW->fGauUseMes);
	AjcSetDlgItemChk (hDlg, IDC_RBT_MES  ,	pW->fGauUseMes);
	AjcSetDlgItemUInt(hDlg, IDC_INP_UTIME, (UI)pW->GauSetUTime);
	AjcSepDlgItemUInt(hDlg, IDC_TXT_UTIME, (UI)pW->MesPeriAveS);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(UnitTime, IDC_CMD_UPD	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchUnitTime");

	if (pW->MesPeriAve != 0) {
		pW->MesPeriAveS = (UI)pW->MesPeriAve;
		AjcSepDlgItemUInt(hDlg, IDC_TXT_UTIME, pW->MesPeriAveS);
	}

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(UnitTime, IDOK			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchUnitTime");

	pW->fGauUseMes	= AjcGetDlgItemChk (hDlg, IDC_RBT_MES);
	pW->GauSetUTime = AjcGetDlgItemUInt(hDlg, IDC_INP_UTIME);
	pW->MesPeriAveS = AjcGetDlgItemUInt(hDlg, IDC_TXT_UTIME);

	InvalidateRect(pW->hMain, NULL, FALSE);

	EndDialog(hDlg, IDOK);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(UnitTime, IDCANCEL		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchUnitTime");

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(UnitTime)
	AJC_DLGMAP_MSG(UnitTime, WM_INITDIALOG	)
	AJC_DLGMAP_CMD(UnitTime, IDC_CMD_UPD	)
	AJC_DLGMAP_CMD(UnitTime, IDOK			)
	AJC_DLGMAP_CMD(UnitTime, IDCANCEL		)
AJC_DLGMAP_END
