﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				ＭＳＩＬ(.NET Framework)対応処理						//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(MSIL);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
#define	IDC_PARENT	5000
#define	IDC_CTRL	5001

//----- ワーク形式 ---------------------------------------------------------------------------------------------//
typedef struct {
	HWND	hCtrl;			//	タイムチャートウインド
	VO (CALLBACK *cbRengeChanged)(double low, double high);
	VO (CALLBACK *cbNtcScrollPos)(UI pos);
	VO (CALLBACK *cbFileDrop	)(UI n	 );
	VO (CALLBACK *cbDirDrop 	)(UI n	 );
	VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl);
	BOOL	fShowScrollBar;
} WKMSIL, *PWKMSIL;
//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		TchWndProcMSIL()
{
	return AJC_WNDPROC_NAME(MSIL);
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	コントロールウインド生成																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HWND WINAPI AjcTchCreateForMSIL(HWND hOwner, BOOL fShowScrollBar, VO (CALLBACK *cbRengeChanged)(double low, double high),
																			VO (CALLBACK *cbNtcScrollPos)(UI pos),
																			VO (CALLBACK *cbFileDrop	)(UI n	 ),
																			VO (CALLBACK *cbDirDrop 	)(UI n	 ),
																			VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl))
{
	HWND		hBack = NULL;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk = NULL;
	RECT		rect;

	do {
		//----- 親ウインドハンドルチェック ---------------------------------------------------------------------//
		if (!IsWindow(hOwner)) break;
		//----- ワーク領域確保 ---------------------------------------------------------------------------------//
		if ((pWk = (PWKMSIL)AJCMEM(sizeof(WKMSIL))) == NULL) break;
		memset(pWk, 0, sizeof(WKMSIL));
		pWk->cbRengeChanged = cbRengeChanged;
		pWk->cbNtcScrollPos = cbNtcScrollPos;
		pWk->cbFileDrop		= cbFileDrop;
		pWk->cbDirDrop	 	= cbDirDrop;
		pWk->cbRClick		= cbRClick;
		pWk->fShowScrollBar = fShowScrollBar;
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hOwner, &rect);
		//----- バックウインド生成 -----------------------------------------------------------------------------//
		hBack = CreateWindow((WCP)TchClassForMSIL,			// window class name
								L"",						// window caption
								WS_CHILD,					// window style
								0,							// initial x position
								0,							// initial y position
								rect.right - rect.left,		// initial x size
								rect.bottom - rect.top,		// initial y size
								hOwner,						// parent window handle
								(HMENU)IDC_PARENT,			// window menu handle
								hDllInst,					// program instance handle
								(VOP)pWk);					// creation parameters
		if (hBack == NULL) break;
		//----- 戻り値（コントロールハンドル）設定 -------------------------------------------------------------//
		hCtrl = pWk->hCtrl;
		//----- チップコントロール対象ウインド設定 -------------------------------------------------------------//
		AJCTIPCTRL_SETHWNDA(hOwner, hCtrl);
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hBack, SW_SHOW);
	} while(0);

	//----- エラーならばリソース解放 ---------------------------------------------------------------------------//
	if (hBack == NULL) {
		if (pWk != NULL) free(pWk);
	}
	return hCtrl;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	親ウインドプロシージャ																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJC_WNDPROC(MSIL, WM_CREATE		)
{
	LRESULT		rc	  = -1;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = ((LPCREATESTRUCT)lParam)->lpCreateParams;
	RECT		rect;

	do {
		//----- ワークポインタ退避 -----------------------------------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pWk);
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hwnd, &rect);
		//----- タイムチャートウインド生成 ---------------------------------------------------------------------//
		hCtrl = CreateWindow(L"AjcCtrlTmChart",										// window class name
							L"",													// window caption
							WS_CHILD | WS_VISIBLE | (pWk->fShowScrollBar ? 0 : AJCTCS_NOSCROLLBAR), 	// style
							0,														// initial x position
							0,														// initial y position
							rect.right - rect.left,									// initial x size
							rect.bottom - rect.top,									// initial y size
							hwnd,													// parent window handle
							(HMENU)IDC_CTRL,										// window menu handle
							hDllInst,												// program instance handle
							NULL);													// creation parameters
		if (hCtrl == NULL) break;
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hCtrl, SW_SHOW);
		//----- コントロールのハンドル退避 ---------------------------------------------------------------------//
		pWk->hCtrl = hCtrl;
		//----- 戻り値=正常 ------------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_DESTROY	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk != NULL) {
		if (pWk->hCtrl != NULL) {
			DestroyWindow(pWk->hCtrl);
			pWk->hCtrl = NULL;
		}
		free(pWk);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_SIZE		)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);
	int			width  = LOWORD(lParam);
	int			height = HIWORD(lParam);

	SetWindowPos(pWk->hCtrl, NULL, 0, 0, width, height, SWP_NOMOVE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_RBUTTONDOWN	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk->cbRClick != NULL) {
		pWk->cbRClick((int)LOWORD(lParam), (int)HIWORD(lParam), ((wParam & MK_SHIFT) != 0), ((wParam & MK_CONTROL) != 0));
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, IDC_CTRL		)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (LOWORD(wParam) == IDC_CTRL) {
		switch (HIWORD(wParam)) {
			case AJCTCN_RANGE:									//	●レンジ通知
			{	PAJCTC_NTC_RANGE p = (PAJCTC_NTC_RANGE)lParam;
				if (pWk->cbRengeChanged != NULL) {
					pWk->cbRengeChanged(p->RngL, p->RngH);
				}
				break;
			}
			case AJCTCN_SCRPOS:									//	●スクロール位置通知
				if (pWk->cbNtcScrollPos != NULL) {
					pWk->cbNtcScrollPos((UI)lParam);
				}
				break;

			case AJCTCN_DROPFILE:								//	●ファイルドロップ通知
				if (pWk->cbFileDrop != NULL) {
					pWk->cbFileDrop((UI)lParam);
				}
				break;

			case AJCTCN_DROPDIR:								//	●ディレクトリドロップ通知
				if (pWk->cbDirDrop != NULL) {
					pWk->cbDirDrop((UI)lParam);
				}
				break;

			case AJCTCN_RCLICK:									//	●右クリック通知
			{	PAJCTCRCLK	p = (PAJCTCRCLK)lParam;
				if (pWk->cbRClick != NULL) {
					pWk->cbRClick(p->x, p->y, p->fShift, p->fCtrl);
				}
				break;
			}
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MSIL)
	AJC_WNDMAP_MSG(MSIL, WM_CREATE			)
	AJC_WNDMAP_MSG(MSIL, WM_DESTROY			)
	AJC_WNDMAP_MSG(MSIL, WM_SIZE			)
	AJC_WNDMAP_MSG(MSIL, WM_RBUTTONDOWN		)

	AJC_WNDMAP_CMD(MSIL, IDC_CTRL			)
AJC_WNDMAP_END
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	スタイルの設定／取得関数																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- スタイル取得マクロ -------------------------------------------------------------------------------------//
#define	MGET_STY(NAME)	AJCEXPORT BOOL WINAPI AjcTchGetSty_##NAME(HWND hwnd) {									\
	return (BOOL)((MAjcGetWindowLong(hwnd, GWL_STYLE) & AJCTCS_##NAME) != 0);									\
}
//----- スタイル設定マクロ -------------------------------------------------------------------------------------//
#define	MSET_STY(NAME)	AJCEXPORT VO WINAPI AjcTchSetSty_##NAME(HWND hwnd, BOOL f) {							\
	if (f) MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) |	AJCTCS_##NAME);				\
	else   MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) & ~AJCTCS_##NAME);				\
}

//----- コントロールの外枠・非表示／表示	(AJCTCS_NOBORDER) --------------------------------------------------//
MGET_STY(NOBORDER)
MSET_STY(NOBORDER)

//----- スケールライン非表示／表示			(AJCTCS_NOSCALELINE) -----------------------------------------------//
MGET_STY(NOSCALELINE)
MSET_STY(NOSCALELINE)

//----- スケール値・非表示／表示			(AJCTCS_NOSCALELINE) -----------------------------------------------//
MGET_STY(NOSCALEVALUE)
MSET_STY(NOSCALEVALUE)

//----- フィルタ非表示／表示				(AJCTCS_NOFILTER) --------------------------------------------------//
MGET_STY(NOFILTER)
MSET_STY(NOFILTER)

//----- スクロールバー非表示／表示			(AJCTCS_NOSCROLLBAR) -----------------------------------------------//
MGET_STY(NOSCROLLBAR)
MSET_STY(NOSCROLLBAR)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	プロパティの設定／取得関数																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- プロパティ取得マクロ -----------------------------------------------------------------------------------//
#define	MGET_PROP(TYPE, NAME)		AJCEXPORT TYPE WINAPI AjcTchGetProp_##NAME(HWND hwnd) {						\
	AJCTCPROP	p;																								\
	AjcTchGetProp(hwnd, &p);																					\
	return p.NAME;																								\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MGET_PROPIX(TYPE, NAME)	AJCEXPORT TYPE WINAPI AjcTchGetProp_##NAME(HWND hwnd, UI ix) {					\
	TYPE		rc	  = 0;																						\
	AJCTCPROP	p;																								\
	if (ix < AJCTC_MAXITEM) {																					\
		AjcTchGetProp(hwnd, &p);																				\
		rc = p.Item[ix].NAME;																					\
	}																											\
	return rc;																									\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MGET_PROPIP(TYPE, NAME, DEF)	AJCEXPORT TYPE WINAPI AjcTchGetProp_##NAME(HWND hwnd) {					\
	TYPE	rc = (TYPE)DEF;																						\
	if (IsWindow(hwnd)) {																						\
		PWRKTMCHART pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);												\
		rc = (TYPE)pW->IpInfo.NAME;																				\
	}																											\
	return rc;																									\
}
//----- プロパティ設定マクロ -----------------------------------------------------------------------------------//
#define	MSET_PROP(TYPE, NAME)		AJCEXPORT VO WINAPI AjcTchSetProp_##NAME(HWND hwnd, TYPE n) {				\
	AJCTCPROP p;																								\
	AjcTchGetProp(hwnd, &p);																					\
	p.NAME = n;																									\
	AjcTchSetProp(hwnd, &p);																					\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MSET_PROPIX(TYPE, NAME)		AJCEXPORT VO WINAPI AjcTchSetProp_##NAME(HWND hwnd, UI ix, TYPE n) {		\
	AJCTCPROP p;																								\
	if (ix < AJCTC_MAXITEM) {																					\
		AjcTchGetProp(hwnd, &p);																				\
		p.Item[ix].NAME = n;																					\
		AjcTchSetProp(hwnd, &p);																				\
	}																											\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MSET_PROPIP(TYPE, NAME)		AJCEXPORT VO WINAPI AjcTchSetProp_##NAME(HWND hwnd, UI val) {				\
	if (IsWindow(hwnd)) {																						\
		PWRKTMCHART pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);												\
		pW->IpInfo.NAME = (TYPE)val;																			\
	}																											\
}
//----- 低位レンジ値 		(RngL) -----------------------------------------------------------------------------//
MGET_PROP(double, RngL)
MSET_PROP(double, RngL)

//----- 高位レンジ値 		(RngH) -----------------------------------------------------------------------------//
MGET_PROP(double, RngH)
MSET_PROP(double, RngH)

//----- 横軸のメモリ表示幅	(TmScale) --------------------------------------------------------------------------//
MGET_PROP(UI, TmScale)
MSET_PROP(UI, TmScale)

//----- バッファ容量		(MaxBuf) ---------------------------------------------------------------------------//
MGET_PROP(UI, MaxBuf)
MSET_PROP(UI, MaxBuf)

//----- 最大データ項目数	(MaxItem) --------------------------------------------------------------------------//
MGET_PROP(UI, MaxItem)
MSET_PROP(UI, MaxItem)

//----- 平均化個数			(AveNum) ---------------------------------------------------------------------------//
MGET_PROP(UI, AveNum)
MSET_PROP(UI, AveNum)

//----- オフセット			(Item[ix].ofs) ---------------------------------------------------------------------//
MGET_PROPIX(double, ofs)
MSET_PROPIX(double, ofs)

//----- 表示色				(Item[ix].rgb) ---------------------------------------------------------------------//
MGET_PROPIX(UI, rgb)
MSET_PROPIX(UI, rgb)

//----- 波形補間表示種別 ---------------------------------------------------------------------------------------//
MGET_PROPIP(UI		  , IpKnd, AJCTCIPK_WND)
MSET_PROPIP(AJCTCIPKND, IpKnd)

//----- 最新データ補間表示時の最大データ数 ---------------------------------------------------------------------//
MGET_PROPIP(UI		  , IpNum, 500)
MSET_PROPIP(UI		  , IpNum)

//----- 補間表示幅（波形の引き伸ばし倍率） ---------------------------------------------------------------------//
MGET_PROPIP(UI		  , IpWidth, 10)
MSET_PROPIP(UI		  , IpWidth)

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcTchSetProp_WndSize(HWND hwnd, UI width, UI height)
{
	if (IsWindow(hwnd)) {
		HWND		hParent;

		if (hParent = GetParent(hwnd)) {
			SetWindowPos(hParent , NULL, 0, 0, width, height, SWP_NOMOVE);
		}
	}
}
//----- ファイル，フォルダ ドロップの許可／禁止 ----------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcTchSetProp_AcceptFiles(HWND hwnd, BOOL fEnable)
{
	if (IsWindow(hwnd)) {
		UX	ExSty = MAjcGetWindowLong(hwnd, GWL_EXSTYLE);

		if (fEnable) ExSty |=  WS_EX_ACCEPTFILES;
		else		 ExSty &= ~WS_EX_ACCEPTFILES;

		MAjcSetWindowLong(hwnd, GWL_EXSTYLE, ExSty);
	}
}
AJCEXPORT BOOL WINAPI AjcTchGetProp_AcceptFiles(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = ((MAjcGetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_ACCEPTFILES) != 0);
	}
	return rc;
}
//----- チップテキスト設定／取得 -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcTchSetTipTextForMSIL(HWND hwnd, C_WCP pTxt)
{
	BOOL	rc = FALSE;
	UI		stl;
	WCP		pTmp;

	if (pTxt == NULL) pTxt = L"";

	stl = (UI)wcslen(pTxt);
	if (pTmp = AjcTAlloc(stl + 1)) {
		AjcCLangStrToBinW(pTxt, pTmp, stl + 1);
		rc = AjcTchSetTipTextW(hwnd, pTmp);
		free(pTmp);
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	UI	WINAPI	AjcTchGetTipTextForMSIL(HWND hwnd, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	WCP		pTmp;

	if (pTmp = AjcTAlloc(lBuf)) {
		AjcTchGetTipTextW(hwnd, pTmp, lBuf);
		rc = AjcBinToCLangStrW(pTmp, pBuf, lBuf);
		free(pTmp);
	}
	return rc;
}
//----- フィルタチップテキスト設定／取得 -----------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI		AjcTchSetChkBoxTipTextForMSIL(HWND hwnd, UI n, C_WCP pTxt)
{
	BOOL	rc = FALSE;
	UI		stl;
	WCP		pTmp;

	if (pTxt == NULL) pTxt = L"";

	stl = (UI)wcslen(pTxt);
	if (pTmp = AjcTAlloc(stl + 1)) {
		AjcCLangStrToBinW(pTxt, pTmp, stl + 1);
		rc = AjcTchSetChkBoxTipTextW(hwnd, n, pTmp);
		free(pTmp);
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	UI		WINAPI		AjcTchGetChkBoxTipTextForMSIL(HWND hwnd, UI n, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	WCP		pTmp;

	if (pTmp = AjcTAlloc(lBuf)) {
		AjcTchGetChkBoxTipTextW(hwnd, n, pTmp, lBuf);
		rc = AjcBinToCLangStrW(pTmp, pBuf, lBuf);
		free(pTmp);
	}
	return rc;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	メソッド																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- データ投与 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcTchPutData1	(HWND hwnd, double dat0)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	AjcTchPutRealData(hwnd, dat);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcTchPutData2	(HWND hwnd, double dat0, double dat1)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	AjcTchPutRealData(hwnd, dat);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcTchPutData3	(HWND hwnd, double dat0, double dat1, double dat2)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	AjcTchPutRealData(hwnd, dat);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcTchPutData4	(HWND hwnd, double dat0, double dat1, double dat2, double dat3)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	AjcTchPutRealData(hwnd, dat);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcTchPutData5	(HWND hwnd, double dat0, double dat1, double dat2, double dat3, double dat4)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	dat[4] = dat4;
	AjcTchPutRealData(hwnd, dat);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcTchPutData6	(HWND hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	dat[4] = dat4;
	dat[5] = dat5;
	AjcTchPutRealData(hwnd, dat);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcTchPutData7	(HWND hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	dat[4] = dat4;
	dat[5] = dat5;
	dat[6] = dat6;
	AjcTchPutRealData(hwnd, dat);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcTchPutData8	(HWND hwnd, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6, double dat7)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	dat[4] = dat4;
	dat[5] = dat5;
	dat[6] = dat6;
	dat[7] = dat7;
	AjcTchPutRealData(hwnd, dat);
}
