﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				共通サブ関数											//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//	プロパティ設定																								//
//																												//
//	引　数	：	pNew	- 新プロパティ																			//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	TchSetProp(PWRKTMCHART pW, PCAJCTCPROP pNew)
{
	BOOL			rc = TRUE;
	double			*pTmpBuf = NULL;
	PTCH_VLINEBUF	 pTmpVLi = NULL;
	UI				NewMaxBuf = pNew->MaxBuf;

	//----- バッファサイズ＝０時は、ウインドサイズに合わせる ---------------------------------------------------//
	if (NewMaxBuf == 0) {
		NewMaxBuf = pW->ww;
	}

	if (NewMaxBuf  >= 2 && NewMaxBuf	<= AJCTC_MAXBUF		&&
		pNew->MaxItem >= 1 && pNew->MaxItem <= AJCTC_MAXITEM) {

		if (pW->prop.MaxBuf != NewMaxBuf || pW->prop.MaxItem != pNew->MaxItem) {
			if ((pTmpBuf =	(double*)AJCMEM(sizeof(double) * pNew->MaxItem * NewMaxBuf)) != NULL &&
				(pTmpVLi =	(PTCH_VLINEBUF)AJCMEM(sizeof(TCH_VLINEBUF)	   * NewMaxBuf)) != NULL) {
				memset(pTmpBuf, 0, sizeof(double) * pNew->MaxItem * NewMaxBuf);
				memset(pTmpVLi, 0, sizeof(TCH_VLINEBUF)			  * NewMaxBuf);
				if (pW->pBuf == NULL || pW->pVLi == NULL || pNew->MaxItem != pW->prop.MaxItem) {
					//----- バッファ初期化／クリアー -----//
					pW->ixView = 0;
					pW->nView  = 0;
					pW->nBuf   = 0;
					pW->nTotal = 0;
					pW->ixBuf  = 0;
					//----- バッファクリアー通知 --------//
					if (pW->pBuf != NULL) { // 初回（オープン時）以外？
						SendMessage(GetParent(pW->hBack), WM_COMMAND,
							MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCTCN_CLEAR), (LPARAM)pW->hBack);
					}
				}
				else {
					int			 n	= __min(NewMaxBuf, pW->nBuf);
					int			 ix = TchDixToBix(pW, __max(0, (int)(pW->nBuf - n)));
					int			 i;
					double		 *p = pTmpBuf;
					PTCH_VLINEBUF q = pTmpVLi;
					for (i=0; i<n; i++) {
						memcpy(p, &pW->pBuf[ix * pW->prop.MaxItem], sizeof(double) * pW->prop.MaxItem);
						memcpy(q, &pW->pVLi[ix]					  , sizeof(TCH_VLINEBUF)			 );
						ix = ((ix + 1) % pW->prop.MaxBuf);
						p += pW->prop.MaxItem;
						q += 1;
					}
					pW->ixView = __max(0, (int)(n - pW->ww));
					pW->nView  = __min(n, (int)pW->ww);
					pW->nBuf   = n;
					pW->ixBuf  = (n % NewMaxBuf);
				}
				pW->prop.MaxBuf	 = NewMaxBuf;
				pW->prop.MaxItem = pNew->MaxItem;
				if (pW->pBuf != NULL) free(pW->pBuf);
				if (pW->pVLi != NULL) free(pW->pVLi);
				pW->pBuf = pTmpBuf;
				pW->pVLi = pTmpVLi;
				TchSetScrollBar(pW);
			}
			else {
				if (pTmpBuf != NULL) free(pTmpBuf);
				if (pTmpVLi != NULL) free(pTmpVLi);
				rc = FALSE;
			}
		}
		//----- 平均化個数変化時は、平均化情報クリアー -----------------//
		if (pW->prop.AveNum != pNew->AveNum) {
			pW->prop.AveNum = 0;
			memset(pW->AveDat, 0, sizeof pW->AveDat);
		}
		//----- グラフレンジが変化した場合は、レンジを通知 -------------//
		if (pW->prop.RngL != pNew->RngL || pW->prop.RngH != pNew->RngH) {
			PostMessage(pW->hBack, AJCTCM_NEEDNTC_RANGE, 0, 0);
		}
		pW->prop.RngL	 = pNew->RngL;
		pW->prop.RngH	 = pNew->RngH;
		pW->prop.TmScale = pNew->TmScale;
		pW->prop.AveNum	 = __max(1, pNew->AveNum);
		memcpy(&pW->prop.Item, &pNew->Item, sizeof pW->prop.Item);
		//	フィルタウインドサイズ設定
		SetWindowPos(pW->hFilter, NULL, 0, 0, (TCH_FLT_WIDTH + 4) * pW->prop.MaxItem, TCH_FLT_HEIGHT + 4, SWP_NOMOVE);
		//	ウインド再表示
		InvalidateRect(pW->hBack  , NULL, FALSE);
		InvalidateRect(pW->hMain  , NULL, FALSE);
		InvalidateRect(pW->hFilter, NULL, FALSE);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	プロパティ	取得																							//
//																												//
//	引　数	：	pNew	- プロパティ格納バッファ																//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	TchGetProp(PWRKTMCHART pW, PAJCTCPROP pBuf)
{
	memcpy(pBuf, &pW->prop, sizeof(AJCTCPROP));
	return TRUE;
}
//==============================================================================================================//
//	ボーダー色設定																								//
//																												//
//	引　数	：	pNew	- プロパティ格納バッファ																//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	TchSetBorderColor(PWRKTMCHART pW, COLORREF color)
{
	BOOL	rc = FALSE;
	HPEN	hPen;

	if (hPen = CreatePen(PS_SOLID, 1, color)) {
		if (pW->hPenBorder != NULL) DeleteObject(pW->hPenBorder);
		pW->RgbBorder  = color;
		pW->hPenBorder = hPen;
		InvalidateRect(pW->hBack, NULL, FALSE);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//																												//
//	スクロールバー表示																							//
//																												//
//==============================================================================================================//
VO		TchSetScrollBar(PWRKTMCHART pW)
{
	SCROLLINFO		si;

	if (!(pW->style & AJCTCS_NOSCROLLBAR)) {

		si.cbSize = sizeof(SCROLLINFO);
		si.fMask  = SIF_PAGE | SIF_RANGE | SIF_POS;
		si.nMin	  = 0;
		si.nMax	  = pW->prop.MaxBuf - 1;
		si.nPage  = pW->ww;
		si.nPos	  = TchBixToDix(pW, pW->ixView);
		SetScrollInfo(pW->hMain, SB_HORZ, &si, TRUE);

		if (pW->prop.MaxBuf <= pW->ww) {
			ShowScrollBar(pW->hMain, SB_HORZ, FALSE);
		}
		else {
			ShowScrollBar(pW->hMain, SB_HORZ, TRUE);
		}
	}
}
//==============================================================================================================//
//																												//
//	表示開始インデクス設定																						//
//																												//
//==============================================================================================================//
VO		TchSetViewIndex(PWRKTMCHART pW)
{
	if (pW->nBuf < pW->prop.MaxBuf) {			//	バッファに格納されているデータの個数 ＜ バッファデータ数？
		if (pW->ww >= pW->nBuf) {				//		ウインド幅 ≧ バッファデータ数？
			pW->ixView = 0;
		}
		else {									//		ウインド幅 ＜ バッファデータ数？
			pW->ixView = (pW->nBuf - pW->ww);
		}
	}
	else {										//	バッファに格納されているデータの個数 ≧ バッファデータ数？
		if (pW->ww >= pW->nBuf) {				//		ウインド幅 ≧ バッファデータ数？
			pW->ixView = pW->ixBuf;
		}
		else {									//		ウインド幅 ＜ バッファデータ数？
			pW->ixView = (pW->ixBuf + (pW->prop.MaxBuf - pW->ww)) % pW->prop.MaxBuf;
		}
	}
}
//==============================================================================================================//
//																												//
//	表示データ数設定																							//
//																												//
//==============================================================================================================//
VO		TchSetViewWidth(PWRKTMCHART pW)
{
	UI		dix = TchBixToDix(pW, pW->ixView);

	if (dix < pW->nBuf) {
		pW->nView = pW->nBuf - dix;
		pW->nView = __min(pW->nView, pW->ww);
	}
	else {
		pW->nView = 0;
	}
}
//==============================================================================================================//
//																												//
//	バッファインデクス→データインデクス変換																	//
//																												//
//==============================================================================================================//
UI		TchBixToDix(PWRKTMCHART pW, UI bix)
{
	UI		rc;

	if (pW->nBuf < pW->prop.MaxBuf) {
		rc = bix;
	}
	else {
		if (bix >= pW->ixBuf) rc = bix - pW->ixBuf;
		else				  rc = ((pW->prop.MaxBuf - pW->ixBuf) + bix) % pW->prop.MaxBuf;
	}
	return rc;
}
//==============================================================================================================//
//																												//
//	データインデクス→バッファインデクス変換																	//
//																												//
//==============================================================================================================//
UI		TchDixToBix(PWRKTMCHART pW, UI dix)
{
	UI		rc;

	if (pW->nBuf < pW->prop.MaxBuf) {
		rc = dix;
	}
	else {
		rc = (pW->ixBuf + dix) % pW->prop.MaxBuf;
	}
	return rc;
}
//==============================================================================================================//
//																												//
//	プロット周期計測情報リセット																				//
//																												//
//==============================================================================================================//
VO		TchMesPeriReset(PWRKTMCHART pW)
{
	pW->MesPeriCnt	= 0;
	pW->MesPeriAve	= 0;
	pW->MesPeriSrt	= 0;
}
