﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				バックウインド											//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);
static	VO		SetPropByText	  (PWRKTMCHART pW, WCP pTxt, PAJCTCPROP pProp);
static	UI		MakePropText	  (PWRKTMCHART pW, WCP pTxt, UI lText);
static	VO		EnableCtrls		  (PWRKTMCHART pW, BOOL fEnable);
static	VO		StyleSetting	  (PWRKTMCHART pW);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		TchWndProcBack()
{
	return AJC_WNDPROC_NAME(Back);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	バックウインドプロシージャ（カスタムコントロール ウインド）													//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE		)
{
	LRESULT			rc = -1;
	PWRKTMCHART		pW = NULL;
	AJCTCPROP		prop;
	RECT			r;
	int				i;
//	UI				sty;
	WC				PropTxt[1024];
	HINSTANCE	hModuleInstance = GetModuleHandle(NULL);

	do {
		//----- ワーク初期化 -----------------------------------------------------------------------------------//
		if ((pW = (PWRKTMCHART)AJCMEM(sizeof(WRKTMCHART))) == NULL) break;
		memset(pW, 0, sizeof(WRKTMCHART));
		//----- インスタンス識別ＩＤ設定 -----------------------------------------------------------------------//
		pW->InstID = TCH_INST_ID;
		//----- フィルタマスク初期化 ---------------------------------------------------------------------------//
		pW->MskFilt = ((1 << AJCTC_MAXITEM) - 1);
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//----- バックウインドのスタイルへ「WS_CLIPCHILDREN」追加 ----------------------------------------------//
	//	sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
	//	MAjcSetWindowLong(hwnd, GWL_STYLE, sty | WS_CLIPCHILDREN);
		//----- バックウインドサイズ設定 -----------------------------------------------------------------------//
		pW->hBack = hwnd;
		GetClientRect(hwnd, &r);
		pW->bw	  = r.right - r.left;
		pW->bh	  = r.bottom - r.top;
		//----- ウインドスタイル取得 ---------------------------------------------------------------------------//
		pW->style = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
		//----- ウインドキャプション（文字列パラメタ）取得 -----------------------------------------------------//
		pW->fFirstGetText = TRUE;
		GetWindowText(hwnd, PropTxt, AJCTSIZE(PropTxt));
		//----- デフォルトプロパティ設定 -----------------------------------------------------------------------//
		memset(&prop, 0, sizeof prop);
		prop.RngL		 = -1.0;
		prop.RngH		 = +1.0;
		prop.TmScale	 = 100;
		prop.MaxBuf		 = 4096;
		prop.MaxItem	 = 3;
		prop.AveNum		 = 1;
		prop.Item[0].rgb = RGB(	 0,	  0, 255);
		prop.Item[1].rgb = RGB(255,	  0,   0);
		prop.Item[2].rgb = RGB(	 0, 192,   0);
		prop.Item[3].rgb = RGB(	 0, 224, 224);
		prop.Item[4].rgb = RGB(255,	  0, 255);
		prop.Item[5].rgb = RGB(224, 224,   0);
		prop.Item[6].rgb = RGB(128, 128, 128);
		prop.Item[7].rgb = RGB(	 0,	  0,   0);
		//----- 縦線描画許可（デフォルト）----------------------------------------------------------------------//
		pW->fVLiEnable = TRUE;
		//----- プロット点描画許可（デフォルト）----------------------------------------------------------------//
		pW->fPointEnable = TRUE;
		//----- 補間波形上のプロット点描画許可（デフォルト）----------------------------------------------------//
		pW->fSplPtEna	 = TRUE;
		//----- 描画色情報初期化 -------------------------------------------------------------------------------//
		pW->RgbBorder  = RGB(  0,	0,	 0);
		if ((pW->hPenBorder = CreatePen(PS_SOLID, 1, pW->RgbBorder)) == NULL) break;
		//----- 最大結線長初期化 -------------------------------------------------------------------------------//
		pW->MaxLineDist = 0.0;		// 0.0 : 全結線
		//----- 横線描画情報初期化 ---------------------------//
		for (i = 0; i < TCH_MAX_HLINE; i++) {
			pW->HLineTbl[i].fEnable = FALSE;
			pW->HLineTbl[i].pos		= 0.0;
			pW->HLineTbl[i].hPen	= NULL;
		}
		//----- ドロップファイル名一時保留バッファ生成 ---------------------------------------------------------//
		pW->hRngFile = AjcRngCreate(&pW->StaRngFile, sizeof pW->StaRngFile, 4096);
		if (pW->hRngFile == NULL) break;
		//----- ドロップＤＩＲ名一時保留バッファ生成 -----------------------------------------------------------//
		pW->hRngDir	 = AjcRngCreate(&pW->StaRngDir , sizeof pW->StaRngDir , 4096);
		if (pW->hRngDir	 == NULL) break;
		//----- チップテキスト表示条件 -------------------------------------------------------------------------//
		pW->fShowAlways = TRUE;
		for (i = 0; i < AJCTC_MAXITEM; i++) {
			pW->fChkBoxShowAlways[i] = TRUE;
		}
		//----- デフォルト 波形補間表示情報 --------------------------------------------------------------------//
		pW->IpInfo.IpKnd	 = AJCTCIPK_WND;
		pW->IpInfo.IpNum	 = 500;
		pW->IpInfo.IpWidth	 = 10;
		//----- プロット周期計測情報クリアー -------------------------------------------------------------------//
		pW->fMesPeriShow = FALSE;
		TchMesPeriReset(pW);
		//	プロット周期の平均を反映するタイミング（プロット回数）
		pW->MesPeriSetAveS = 20;
		//----- 計測用ゲージ情報 -------------------------------------------------------------------------------//
		pW->GauBarL		= 40;
		pW->GauBarH		= 60;
		pW->fGauUseMes	= TRUE;
		pW->GauSetUTime	= 1000;
		//----- メインウインド生成 -----------------------------------------------------------------------------//
		pW->hMain = CreateWindowEx(	MAjcGetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_ACCEPTFILES,	// extend style
									(WCP)TchClassMain,					// window class name
									L"",									// window caption
									(pW->style & AJCTCS_NOSCROLLBAR) ?	// window style
											(WS_CHILD | WS_VISIBLE |			  WS_CLIPCHILDREN) :
											(WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_CLIPCHILDREN),
									1,									// initial x position
									1,									// initial y position
									pW->bw - 2,							// initial x size
									pW->bh - 2,							// initial y size
									hwnd,								// parent window handle
									NULL,								// window menu handle
									hDllInst,							// program instance handle
									pW);								// creation parameters
		if (pW->hMain == NULL) break;
		AJCTIP_SETFRIENDA(pW->hMain);
		ShowWindow		 (pW->hMain, SW_SHOW);
		//----- 初回プロパティ設定で、レンジ変化通知を行うためのダミー値設定 -----------------------------------//
		pW->prop.RngH = pW->prop.RngL = DBL_MAX;
		//----- プロパティ設定 ---------------------------------------------------------------------------------//
		SetPropByText(pW, PropTxt, &prop);
		if (!TchSetProp(pW, &prop)) break;
		//----- スタイル設定 -----------------------------------------------------------------------------------//
		StyleSetting(pW);
		//----- コントロールの有効状態設定 ---------------------------------------------------------------------//
		EnableCtrls(pW, pW->fEnable = !(pW->style & WS_DISABLED));
		//----- ツールチップテキスト初期化 ---------------------------------------------------------------------//
		AjcTipTextAdd(pW->hBtnWide	 , LNGSEL(L"縮小表示", L"Shrink"));
		AjcTipTextAdd(pW->hBtnZoom	 , LNGSEL(L"拡大表示", L"Zoome" ));
		AjcTipTextAdd(pW->hBtnMesPeri, LNGSEL(L"プロット周期の計測値を10秒間表示します。\n"
											  L"※ プロット周期は常時計測されています。\n"
											  L"※ マウスのホイールボタンを押すとプロット周期の計測をリセットします。",
											  L"The measured value of the plot period is displayed for 10 seconds.\n"
											  L"* The plot cycle is constantly measured.\n"
											  L"* Pressing the mouse wheel button resets the plot period measurement."			));
		AjcTipTextAdd(pW->hSpnBarL	 , LNGSEL(L"時間計測 低位ゲージを移動します。", L"Move the time measurement gauge.(Low)"	));
		AjcTipTextAdd(pW->hSpnBarH	 , LNGSEL(L"時間計測 高位ゲージを移動します。", L"Move the time measurement gauge.(High)"	));
		AjcTipTextAdd(pW->hBtnGau	 , LNGSEL(L"単位時間を設定します。"			  , L"Set the unit time."						));
		//----- 戻り値＝正常 -----------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	if (rc == -1) {
		if (pW != NULL) {
			if (pW->hPenBorder != NULL) {DeleteObject(pW->hPenBorder); pW->hPenBorder = NULL;}
			if (pW->hMain	   != NULL) {DestroyWindow(pW->hMain);	   pW->hMain	  = NULL;}
			if (pW->pBuf	   != NULL) {free(pW->pBuf);			   pW->pBuf		  = NULL;}
			if (pW->pVLi	   != NULL) {free(pW->pVLi);			   pW->pVLi		  = NULL;}
			free(pW);
			MAjcSetWindowLong(hwnd, 0, (LPARAM)NULL);
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	int			i;

	if (pW != NULL) {
		//----- リソース解放 -------------------------------//
		if (pW->hPenBorder != NULL) {DeleteObject(pW->hPenBorder);		pW->hPenBorder = NULL;}
		if (pW->hDlgSpline != NULL) {DestroyWindow(pW->hDlgSpline);		pW->hDlgSpline = NULL;}
		if (pW->hMain	   != NULL) {DestroyWindow(pW->hMain);	   		pW->hMain	   = NULL;}
		if (pW->hMeasure   != NULL) {DestroyWindow(pW->hMeasure);  		pW->hMeasure   = NULL;}
		if (pW->pBuf	   != NULL) {free(pW->pBuf);			   		pW->pBuf	   = NULL;}
		if (pW->pSplBuf	   != NULL) {free(pW->pSplBuf);			   		pW->pSplBuf    = NULL;}
		if (pW->pVLi	   != NULL) {free(pW->pVLi);			   		pW->pVLi	   = NULL;}
		if (pW->hBitmap	   != NULL) {DeleteObject(pW->hBitmap);	   		pW->hBitmap    = NULL;}
		if (pW->hRngFile   != NULL) {AjcRngDelete(pW->hRngFile);   		pW->hRngFile   = NULL;}
		if (pW->hRngDir	   != NULL) {AjcRngDelete(pW->hRngDir );   		pW->hRngDir    = NULL;}
		//----- ツールチップテキスト破棄 -------------------//
		if (pW->pToolTipTxt != NULL) {
			free(pW->pToolTipTxt);
			pW->pToolTipTxt = NULL;
		}
		for (i = 0; i < AJCTC_MAXITEM; i++) {
			if (pW->pChkBoxTool[i] != NULL) {
				free(pW->pChkBoxTool[i]);
				pW->pChkBoxTool[i] = NULL;
			}
		}
		//----- 横線描画情報破棄 ---------------------------//
		for (i = 0; i < TCH_MAX_HLINE; i++) {
			if (pW->HLineTbl[i].hPen != NULL) {
				DeleteObject(pW->HLineTbl[i].hPen);
				pW->HLineTbl[i].hPen = NULL;
			}
		}
		//----- 描画時間計測インスタンス消去 ---------------//
		if (pW->hMesDraw != NULL) AjcMesTimeDelete(pW->hMesDraw);
		//----- タイトル描画オブジェクト破棄 ---------------//
		SubTtlBmpRemv(&pW->TtlInfo);
		//----- インスタンスワーク解放 ---------------------//
		free(pW);
		//----- インスタンスワークポインタ クリアー --------//
		MAjcSetWindowLong(hwnd, 0, (LPARAM)NULL);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZE		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);

	pW->bw = LOWORD(lParam);
	pW->bh = HIWORD(lParam);

	//----- イメージ描画ウインド移動 -----------------------//
	MoveWindow(pW->hMain, 1, 1, pW->bw - 2, pW->bh - 2, TRUE);
	InvalidateRect(hwnd, NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_PAINT		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;
	HBRUSH		hBrush;
	HPEN		hPen;
	RECT		r;

	hdc	  = BeginPaint(hwnd, &ps);
	hBrush = (HBRUSH)SelectObject(hdc, (HBRUSH)GetStockObject(NULL_BRUSH));
	if (pW->style & AJCTCS_NOBORDER) {
		hPen = (HPEN)SelectObject(hdc, hPenBtnFace);
	}
	else {
		if (pW->fEnable) hPen = (HPEN)SelectObject(hdc, pW->hPenBorder);
		else			 hPen = (HPEN)SelectObject(hdc, hPenGrayText);
	}
	GetClientRect(hwnd, &r);
	Rectangle(hdc, r.left, r.top, r.right, r.bottom);
	SelectObject(hdc, hBrush);
	SelectObject(hdc, hPen);
	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXTLENGTH)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	WC			txt[1024];

	MakePropText(pW, txt, AJCTSIZE(txt));

	return wcslen(txt);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXT	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	if (pW->fFirstGetText) {
		pW->fFirstGetText = FALSE;
		rc = AjcDefWindowProc(hwnd, msg, wParam, lParam);
	}
	else {
		rc = MakePropText(pW, (WCP)lParam, (UI)wParam);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETTEXT	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;
	AJCTCPROP	prop;

	memcpy(&prop, &pW->prop, sizeof(AJCTCPROP));
	SetPropByText(pW, (WCP)lParam, &prop);
	rc = TchSetProp(pW, &prop);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_STYLECHANGED)
{
	PWRKTMCHART		pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	LPSTYLESTRUCT	p  = (LPSTYLESTRUCT)lParam;

	if		(wParam == GWL_STYLE) {
		if (wParam == GWL_STYLE) {
			pW->style = p->styleNew;
			StyleSetting(pW);
		}
	}
	else if (wParam == GWL_EXSTYLE) {
		MAjcSetWindowLong(pW->hMain, GWL_EXSTYLE, p->styleNew & WS_EX_ACCEPTFILES);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_ENABLE)
{
	PWRKTMCHART		pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);

	EnableCtrls(pW, pW->fEnable = (BOOL)wParam);

	return 0;
}
//----- レンジ通知要イベント(By PostMessage) -------------------------------------------------------------------//
AJC_WNDPROC(Back, AJCTCM_NEEDNTC_RANGE)
{
	PWRKTMCHART		pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);

	if (pW->NtcRng.RngL != pW->prop.RngL || pW->NtcRng.RngH != pW->prop.RngH) {
		pW->NtcRng.RngL = pW->prop.RngL;
		pW->NtcRng.RngH = pW->prop.RngH;
		SendMessage(GetParent(pW->hBack), WM_COMMAND,
					 MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCTCN_RANGE),
					 fCmdWithHdl ? (LPARAM)pW->hBack : (WPARAM)&pW->NtcRng);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE				)
	AJC_WNDMAP_MSG(Back, WM_DESTROY				)
	AJC_WNDMAP_MSG(Back, WM_SIZE				)
	AJC_WNDMAP_MSG(Back, WM_PAINT				)
	AJC_WNDMAP_MSG(Back, WM_GETTEXTLENGTH		)
	AJC_WNDMAP_MSG(Back, WM_GETTEXT				)
	AJC_WNDMAP_MSG(Back, WM_SETTEXT				)
	AJC_WNDMAP_MSG(Back, WM_STYLECHANGED		)
	AJC_WNDMAP_MSG(Back, WM_ENABLE				)

	AJC_WNDMAP_MSG(Back, AJCTCM_NEEDNTC_RANGE)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	文字列パラメタからプロパティ設定																			//
//																												//
//	引　数	：	pTxt  - パラメタ文字列																			//
//				pProp - 現在のプロパティ値（プロパティ変更時は上書き）											//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetPropByText(PWRKTMCHART pW, WCP pTxt, PAJCTCPROP pProp)
{
	WCP			p  = NULL;
	UI			ix;
	int			fr=-1, fg=-1, fb=-1;

	if (wcsnicmp(pTxt, L"P:", 2) == 0) {
		//----- パラメタ解析 ---------------------------------------------------//
		p = pTxt + 2;
		if (p = AjcStrTokW(p, L",")) {
			do {
				while (MAjcIsBlankW(*p)) p++;
				if		(wcsnicmp(p, L"L=" , 2) == 0) pProp->RngL	 = _wtof(p+2);
				else if (wcsnicmp(p, L"H=" , 2) == 0) pProp->RngH	 = _wtof(p+2);
				else if (wcsnicmp(p, L"B=" , 2) == 0) pProp->MaxBuf	 = AjcAscToInt(p+2);
				else if (wcsnicmp(p, L"I=" , 2) == 0) pProp->MaxItem = AjcAscToInt(p+2);
				else if (wcsnicmp(p, L"A=" , 2) == 0) pProp->AveNum	 = AjcAscToInt(p+2);
				else if (wcsnicmp(p, L"BC=", 3) == 0) TchSetBorderColor(pW, (COLORREF)AjcAscToInt(p+3));
				else if (wcsnicmp(p, L"IK=", 3) == 0) {
					p += 3;
					while (MAjcIsBlankW(*p)) p++;
					if		(wcsnicmp(p, L"WND", 3) == 0) pW->IpInfo.IpKnd = AJCTCIPK_WND;
					else if (wcsnicmp(p, L"ALL", 3) == 0) pW->IpInfo.IpKnd = AJCTCIPK_ALL;
					else if (wcsnicmp(p, L"NEW", 3) == 0) pW->IpInfo.IpKnd = AJCTCIPK_NEW;
				}
				else if (wcsnicmp(p, L"IN=", 3) == 0) {
					pW->IpInfo.IpNum = AjcAscToInt(p+3);
					pW->IpInfo.IpNum = __max(pW->IpInfo.IpNum, 10);
				}
				else if (wcsnicmp(p, L"IW=", 3) == 0) {
					pW->IpInfo.IpWidth = AjcAscToInt(p+3);
					pW->IpInfo.IpWidth = __max(pW->IpInfo.IpWidth, AJCTCMIN_IPWID);
					pW->IpInfo.IpWidth = __min(pW->IpInfo.IpWidth, AJCTCMAX_IPWID);
				}
				else if (*p >= L'0' && *p <= L'7' && *(p+1) == L'=') {
					ix = (*p & 15);
					p += 2;
					AjcGetSepNumbers(p, L'/', L"fi", &pProp->Item[ix].ofs, &pProp->Item[ix].rgb);
				}
			} while(p = AjcStrTokW(NULL, L","));
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	プロパティ文字列生成																						//
//																												//
//	引　数	：	pTxt	- パラメタ文字列																		//
//				lTxt	- 文字列長																				//
//																												//
//	戻り値	：	テキスト長																						//
//--------------------------------------------------------------------------------------------------------------//
static	UI		MakePropText	  (PWRKTMCHART pW, WCP pTxt, UI lTxt)
{
	AjcSnPrintF(pTxt, lTxt, L"P: L=%G, H=%G, B=%u, I=%u, A=%u, BC=0x%X, "
							L"0=%G/0x%X, 1=%G/0x%X, 2=%G/0x%X, 3=%G/0x%X, 4=%G/0x%X, 5=%G/0x%X, 6=%G/0x%X, 7=%G/0x%X, "
							L"IK=%s, IN=%d, IW=%d",
				pW->prop.RngL,
				pW->prop.RngH,
				pW->prop.MaxBuf,
				pW->prop.MaxItem,
				pW->prop.AveNum,
				pW->RgbBorder,
				pW->prop.Item[0].ofs, pW->prop.Item[0].rgb,
				pW->prop.Item[1].ofs, pW->prop.Item[1].rgb,
				pW->prop.Item[2].ofs, pW->prop.Item[2].rgb,
				pW->prop.Item[3].ofs, pW->prop.Item[3].rgb,
				pW->prop.Item[4].ofs, pW->prop.Item[4].rgb,
				pW->prop.Item[5].ofs, pW->prop.Item[5].rgb,
				pW->prop.Item[6].ofs, pW->prop.Item[6].rgb,
				pW->prop.Item[7].ofs, pW->prop.Item[7].rgb,
				pW->IpInfo.IpKnd == AJCTCIPK_WND ? L"WND" : (pW->IpInfo.IpKnd == AJCTCIPK_ALL ? L"ALL" : L"NEW"),
				pW->IpInfo.IpNum,
				pW->IpInfo.IpWidth);
	return (UI)wcslen(pTxt);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロールの有効状態設定																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		EnableCtrls(PWRKTMCHART pW, BOOL fEnable)
{
	UI		i;

	//----- フィルタの有効状態設定 -----------------------------------//
	for (i=0; i<AJCTC_MAXITEM; i++) {
		EnableWindow(pW->hChkFilt[i], fEnable);
	}
	//---- ワイド／ズームボタンの有効状態設定 ------------------------//
	EnableWindow(pW->hBtnWide, fEnable);
	EnableWindow(pW->hBtnZoom, fEnable);
	//----- プロット周期表示ボタンの有効状態設定 ---------------------//
	EnableWindow(pW->hBtnMesPeri, fEnable);
	//----- 無効状態ならばドラッグ操作中止 ---------------------------//
	if (!fEnable && pW->fDrag) {
		pW->fDrag = FALSE;
		ReleaseCapture();
	}
	//----- 再描画 ---------------------------------------------------//
	InvalidateRect(pW->hBack, NULL, FALSE);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	スタイル設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		StyleSetting(PWRKTMCHART pW)
{
	if (pW->style & AJCTCS_NOFILTER) {
		ShowWindow(pW->hFilter , SW_HIDE);
		ShowWindow(pW->hBtnWide, SW_HIDE);
		ShowWindow(pW->hBtnZoom, SW_HIDE);
	}
	InvalidateRect(pW->hBack  , NULL, FALSE);
	InvalidateRect(pW->hMain  , NULL, FALSE);
	InvalidateRect(pW->hFilter, NULL, FALSE);
}
