﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				メインウインド											//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	ボタン表示中フラグ(fShowBtn)																				//
//--------------------------------------------------------------------------------------------------------------//
#define		fFilter			0x0001		//	フィルタvチェックボックス群
#define		fBtnWide		0x0002		//	ワイドボタン
#define		fBtnZoom		0x0004		//	ズームボタン
#define		fBtnMesPeri		0x0008		//	プロット周期計測表示ボタン
#define		fSpnBarL		0x0010		//	低位ゲージ移動スピンボタン
#define		fSpnBarH		0x0020		//	高位ゲージ移動スピンボタン
#define		fBtnGau			0x0040		//	単位時間設定ボタン

//	表示／非表示マクロ
#define	BTN_SHOW(BTN)	if (!(pW->fShowBtns & f##BTN)) {ShowWindow(pW->h##BTN, SW_SHOW); pW->fShowBtns |=  f##BTN;}
#define	BTN_HIDE(BTN)	if ( (pW->fShowBtns & f##BTN)) {ShowWindow(pW->h##BTN, SW_HIDE); pW->fShowBtns &= ~f##BTN;}

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Main);
static	VO		DrawImage		  (PWRKTMCHART pW, HDC hdc);
static	VO		DrawMesPeri		  (PWRKTMCHART pW, HDC hdc);
static	VO		DrawGauge		  (PWRKTMCHART pW, HDC hdc);
static	int		DatToYPos		  (PWRKTMCHART pW, double dat);

static	VO		PaintText		  (PWRKTMCHART pW, HDC hdc);
static	BOOL CALLBACK cbNtcNode(UX key, VOP pNodeData, UI len, UI nest, UX cbp);


//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		TchWndProcMain()
{
	return AJC_WNDPROC_NAME(Main);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メインウインドプロシージャ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE				)
{
	LRESULT			rc = -1;
	PWRKTMCHART		pW = ((LPCREATESTRUCT)lParam)->lpCreateParams;
	RECT			r;

	do {
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);

		//----- メインウインドサイズ設定 -----------------------------------------------------------------------//
		GetClientRect(hwnd, &r);
		pW->ww = r.right - r.left;
		pW->wh = r.bottom - r.top;

		//----- フィルタウインド生成 ---------------------------------------------------------------------------//
		pW->hFilter = CreateWindow((WCP)TchClassFilter,					// window class name
								L"",									// window caption
								WS_CHILD,								// window style
								0,										// initial x position
								0,										// initial y position
								(TCH_FLT_WIDTH + 4) * AJCTC_MAXITEM,	// initial x size
								(TCH_FLT_HEIGHT + 4),					// initial y size
								hwnd,									// parent window handle
								NULL,									// window menu handle
								hDllInst,								// program instance handle
								pW);									// creation parameters
		if (pW->hFilter == NULL) {
			break;
		}

		//----- ワイド／ズームボタン生成 -----------------------------------------------------------------------//
		pW->hBtnWide = CreateWindow(L"BUTTON",							// window class name
								L"",									// window caption
								WS_CHILD | BS_ICON,						// window style
								0,										// initial x position
								0,										// initial y position
								TCH_BTN_WIDTH,							// initial x size
								TCH_BTN_HEIGHT,							// initial y size
								hwnd,									// parent window handle
								(HMENU)TCH_IDC_BTN_WIDE,				// window menu handle
								hDllInst,								// program instance handle
								NULL);									// creation parameters
		if (pW->hBtnWide != NULL) {
			SendMessage(pW->hBtnWide, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoWide);
		}
		else break;

		pW->hBtnZoom = CreateWindow(L"BUTTON",							// window class name
								L"",									// window caption
								WS_CHILD | BS_ICON,						// window style
								0,										// initial x position
								0,										// initial y position
								TCH_BTN_WIDTH,							// initial x size
								TCH_BTN_HEIGHT,							// initial y size
								hwnd,									// parent window handle
								(HMENU)TCH_IDC_BTN_ZOOM,				// window menu handle
								hDllInst,								// program instance handle
								NULL);									// creation parameters
		if (pW->hBtnZoom != NULL) {
			SendMessage(pW->hBtnZoom, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoZoom);
		}
		else break;

		//----- プロット周期表示ボタン生成 ---------------------------------------------------------------------//
		pW->hBtnMesPeri = CreateWindow(L"BUTTON",						// window class name
								L"",									// window caption
								WS_CHILD | BS_ICON,						// window style
								0,										// initial x position
								0,										// initial y position
								TCH_BTN_WIDTH,							// initial x size
								TCH_BTN_HEIGHT,							// initial y size
								hwnd,									// parent window handle
								(HMENU)TCH_IDC_BTN_MESPERI,				// window menu handle
								hDllInst,								// program instance handle
								NULL);									// creation parameters
		if (pW->hBtnMesPeri != NULL) {
			SendMessage(pW->hBtnMesPeri, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoClock);
		}
		else break;

		//----- 低位ゲージ左右移動スピンボタン生成 -------------------------------------------------------------//
		pW->hSpnBarL = CreateUpDownControl(WS_CHILD | WS_BORDER | WS_VISIBLE | WS_TABSTOP | UDS_ARROWKEYS | UDS_HORZ,
								0,										// initial x position
								0,										// initial y position
								TCH_SPN_WIDTH,							// initial x size
								TCH_BTN_HEIGHT,							// initial y size
								hwnd,									// parent window handle
								TCH_IDC_SPN_BAR_L,						// window menu handle
								hDllInst,								// program instance handle
								NULL,									// buddy
								0x7FFFFFFF, 0x80000000, 0);				// range, position
		if (pW->hSpnBarL != NULL) {
			ShowWindow(pW->hSpnBarL, SW_HIDE);
		}
		else break;

		//----- 高位ゲージ左右移動スピンボタン生成 -------------------------------------------------------------//
		pW->hSpnBarH = CreateUpDownControl(WS_CHILD | WS_BORDER | WS_VISIBLE | WS_TABSTOP | UDS_ARROWKEYS | UDS_HORZ,
								0,										// initial x position
								0,										// initial y position
								TCH_SPN_WIDTH,							// initial x size
								TCH_BTN_HEIGHT,							// initial y size
								hwnd,									// parent window handle
								TCH_IDC_SPN_BAR_H,						// window menu handle
								hDllInst,								// program instance handle
								NULL,									// buddy
								0x7FFFFFFF, 0x80000000, 0);				// range, position
		if (pW->hSpnBarH != NULL) {
			ShowWindow(pW->hSpnBarH, SW_HIDE);
		}
		else break;

		//----- 単位時間設定ボタン生成 -------------------------------------------------------------------------//
		pW->hBtnGau = CreateWindow(L"BUTTON",							// window class name
								L"",									// window caption
								WS_CHILD | BS_ICON,						// window style
								0,										// initial x position
								0,										// initial y position
								TCH_BTN_WIDTH,							// initial x size
								TCH_BTN_HEIGHT,							// initial y size
								hwnd,									// parent window handle
								(HMENU)TCH_IDC_BTN_SETUNIT,				// window menu handle
								hDllInst,								// program instance handle
								NULL);									// creation parameters
		if (pW->hBtnGau != NULL) {
			SendMessage(pW->hBtnGau, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoWrench);
		}
		else break;

		//----- テキスト描画情報初期化 -------------------------------------------------------------------------//
		pW->hFontTxo = AjcGetStockFont(AJCFID_VAR12);
		pW->kAvlTxo = 1;		//	ＡＶＬキー
		if ((pW->hAvlTxo = AjcAvlCreate(0, NULL, NULL)) == NULL) {
			break;
		}

		//----- フィルタ／ボタン表示監視タイマ起動 -------------------------------------------------------------//
		SetTimer(hwnd, TCH_TID_OBSERVE, 200, NULL);

		//----- 戻り値＝正常 -----------------------------------------------------------------------------------//
		rc = 0;

	} while (0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);

	//----- 描画速度情報表示ダイアログクローズ ------------//
	if (pW->hDlgMesDraw != NULL) {AjcViewMesTimeDelete(pW->hDlgMesDraw); pW->hDlgMesDraw = NULL;}

	//----- 描画時間計測インスタンス消去 ------------------//
	if (pW->hMesDraw != NULL) AjcMesTimeDelete(pW->hMesDraw);

	//----- タイマ停止 ------------------------------------//
	KillTimer(hwnd, TCH_TID_OBSERVE    );
	KillTimer(hwnd, TCH_TID_MESPERISHOW);

	//----- テキスト描画ＡＶＬ ----------------------------------//
	if (pW->hAvlTxo != NULL) {
		AjcAvlDelete(pW->hAvlTxo);
		pW->hAvlTxo = NULL;
	}

	//----- その他のオブジェクト消去 ----------------------//
	if (pW->hBtnWide	!= NULL) {DestroyWindow(pW->hBtnWide   ); pW->hBtnWide	  = NULL;}
	if (pW->hBtnZoom	!= NULL) {DestroyWindow(pW->hBtnZoom   ); pW->hBtnZoom	  = NULL;}
	if (pW->hBtnMesPeri != NULL) {DestroyWindow(pW->hBtnMesPeri); pW->hBtnMesPeri = NULL;}
	if (pW->hFilter		!= NULL) {DestroyWindow(pW->hFilter    ); pW->hFilter	  = NULL;}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE				)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	HDC			hdc;

	pW->ww = LOWORD(lParam);
	pW->wh = HIWORD(lParam);

	//----- 描画速度情報表示ダイアログ移動 -----------------//
	if (pW->hDlgMesDraw != NULL) {
		AjcViewMesTimeMove(pW->hDlgMesDraw);
	}
	//----- 描画計測時間クリアー ---------------------------//
	memset(&pW->MesDraw, 0, sizeof pW->MesDraw);
	pW->MesDraw.Min = -1;

	//----- ワイド／ズームボタン移動 ---------------------//
	SetWindowPos(pW->hBtnWide, NULL, pW->ww - (TCH_BTN_WIDTH * 2 + TCH_BTN_MRG), TCH_BTN_MRG, 0, 0, SWP_NOSIZE);
	SetWindowPos(pW->hBtnZoom, NULL, pW->ww - (TCH_BTN_WIDTH	 + TCH_BTN_MRG), TCH_BTN_MRG, 0, 0, SWP_NOSIZE);

	//----- プロット周期表示ボタン移動 -------------------//
	SetWindowPos(pW->hBtnMesPeri, NULL, (pW->ww - TCH_BTN_WIDTH) / 2, TCH_BTN_MRG, 0, 0, SWP_NOSIZE);

	//----- ゲージ操作ボタン移動 -------------------------//
	SendMessage(pW->hSpnBarL, UDM_SETRANGE, 0, MAKELONG(pW->ww - 1, 0));
	SendMessage(pW->hSpnBarH, UDM_SETRANGE, 0, MAKELONG(pW->ww - 1, 0));
	SetWindowPos(pW->hSpnBarL, NULL, (pW->ww - (TCH_SPN_WIDTH * 2 + TCH_BTN_WIDTH)) / 2 							   , TCH_BTN_MRG, 0, 0, SWP_NOSIZE);
	SetWindowPos(pW->hBtnGau , NULL, (pW->ww - (TCH_SPN_WIDTH * 2 + TCH_BTN_WIDTH)) / 2 + TCH_SPN_WIDTH 			   , TCH_BTN_MRG, 0, 0, SWP_NOSIZE);
	SetWindowPos(pW->hSpnBarH, NULL, (pW->ww - (TCH_SPN_WIDTH * 2 + TCH_BTN_WIDTH)) / 2 + TCH_SPN_WIDTH + TCH_BTN_WIDTH, TCH_BTN_MRG, 0, 0, SWP_NOSIZE);

	//----- ゲージバーの位置調整 -------------------------//
	pW->GauBarL = __min(pW->GauBarL, pW->ww - 1);
	pW->GauBarH = __min(pW->GauBarH, pW->ww - 1);

	//----- ビットマップオブジェクト再生成 ---------------//
	if (pW->hBitmap != NULL) {
		DeleteObject(pW->hBitmap);
	}
	hdc = GetDC(hwnd);
	pW->hBitmap = CreateCompatibleBitmap(hdc, pW->ww, pW->wh);
	ReleaseDC(hwnd, hdc);

	//----- ビューインデクス設定 -------------------------//
	TchSetViewIndex(pW);

	//----- 表示データ数設定 -----------------------------//
	TchSetViewWidth(pW);

	//----- スクロールバー再表示とウインド再描画 ---------//
	TchSetScrollBar(pW);
	InvalidateRect(hwnd, NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER				)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	UI			SvShowBtns;

	switch (wParam) {
		//----- ●監視タイマ -----------------------------------------------------------------------------------//
		case TCH_TID_OBSERVE:
			SvShowBtns = pW->fShowBtns;
			//----- ポップアップボタン群表示／非表示の監視 -----------------------------//
			if (pW->fEnable) {
				RECT		r;
				POINT		cp;
				//--- カーソル位置，ウインド位置取得 -------------//
				GetCursorPos(&cp);
				GetWindowRect(hwnd, &r);
				MapWindowPoints(NULL, hwnd, (LPPOINT)&cp, 1);
				MapWindowPoints(NULL, hwnd, (LPPOINT)&r , 2);
				//--- フィルタボタン表示／非表示 -----------------//
				if (!(pW->style & AJCTCS_NOFILTER)) {
					if (cp.x >= 0 && cp.x < (TCH_FLT_WIDTH	+ 4) * (int)pW->prop.MaxItem &&
						cp.y >= 0 && cp.y < (TCH_FLT_HEIGHT + 4)) {
						BTN_SHOW(Filter);
					}
					else {
						BTN_HIDE(Filter);
					}
				}
				else {
					ShowWindow(pW->hFilter , SW_HIDE);
				}
				//--- ワイド／ズームボタン表示／非表示 -----------//
				if (!(pW->style & AJCTCS_NOFILTER)) {
					if (cp.x >= r.right - (TCH_BTN_WIDTH * 2 + TCH_BTN_MRG) &&
						cp.x <= r.right - TCH_BTN_MRG						&&
						cp.y >= r.top	+ TCH_BTN_MRG						&&
						cp.y <= r.top	+ (TCH_BTN_HEIGHT + TCH_BTN_MRG)) {
						BTN_SHOW(BtnWide);
						BTN_SHOW(BtnZoom);
					}
					else {
						BTN_HIDE(BtnWide);
						BTN_HIDE(BtnZoom);
					}
				}
				else {
					BTN_HIDE(BtnWide);
					BTN_HIDE(BtnZoom);
				}

				if (!pW->fGauEnable) {
					//--- 計測周期表示ボタン表示／非表示 -------------//
					if (cp.x >= (LONG)(pW->ww - TCH_BTN_WIDTH) / 2		&&
						cp.x <= (LONG)(pW->ww + TCH_BTN_WIDTH) / 2		&&
						cp.y >= r.top + TCH_BTN_MRG						&&
						cp.y <= r.top + (TCH_BTN_HEIGHT + TCH_BTN_MRG)) {
						BTN_SHOW(BtnMesPeri);
					}
					else {
						BTN_HIDE(BtnMesPeri);
					}
					//	ゲージ操作ボタン非表示
					BTN_HIDE(SpnBarL);
					BTN_HIDE(SpnBarH);
					BTN_HIDE(BtnGau);
				}
				else {
					//----- ゲージ操作ボタン表示／非表示 -------------//
					if (cp.x >= (LONG)(pW->ww - (TCH_SPN_WIDTH * 2 + TCH_BTN_WIDTH)) / 2				 &&
						cp.x <= (LONG)(pW->ww + (TCH_SPN_WIDTH * 2 + TCH_BTN_WIDTH)) / 2 + TCH_BTN_WIDTH &&
						cp.y >= r.top + TCH_BTN_MRG								 						 &&
						cp.y <= r.top + (TCH_BTN_HEIGHT + TCH_BTN_MRG)) {
						BTN_SHOW(SpnBarL);
						BTN_SHOW(SpnBarH);
						BTN_SHOW(BtnGau);
					}
					else {
						BTN_HIDE(SpnBarL);
						BTN_HIDE(SpnBarH);
						BTN_HIDE(BtnGau);
					}
					//	計測周期表示ボタン非表示
					ShowWindow(pW->hBtnMesPeri, SW_HIDE);
				}
			}
			//	Disable状態ならば全ボタン非表示
			else {
				BTN_HIDE(Filter    );
				BTN_HIDE(BtnWide   );
				BTN_HIDE(BtnZoom   );
				BTN_HIDE(BtnMesPeri);
				BTN_HIDE(SpnBarL   );
				BTN_HIDE(SpnBarH   );
				BTN_HIDE(BtnGau    );
			}
			//	表示が変更されたら、再描画
			if (SvShowBtns != pW->fShowBtns) {
				InvalidateRect(pW->hMain, NULL, FALSE);
			}
			break;

		//----- ●プロット周期表示タイマ -----------------------------------------------------------------------//
		case TCH_TID_MESPERISHOW:
			pW->fMesPeriShow = FALSE;
			InvalidateRect(pW->hMain, NULL, FALSE);
			break;
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_HSCROLL			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	SCROLLINFO	si;
	SL			svPos;
	UW			knd = LOWORD(wParam);

	if (knd != SB_ENDSCROLL && knd != SB_THUMBPOSITION) {		//	スクロールバーを掴んだ？
		pW->fScrBar = TRUE;										//		「スクロール中モード」設定
	}
	else {														//	スクロールバーを離した？
		pW->fScrBar = FALSE;									//		「スクロール中モード」解除
	}

	si.cbSize = sizeof(SCROLLINFO);								//	横スクロール情報取得
	si.fMask  = SIF_ALL;										//	・
	GetScrollInfo(hwnd, SB_HORZ, &si);							//	・
	svPos = si.nPos;											//	現在の横方向位置を退避

	switch (knd) {
		case SB_LINELEFT:	si.nPos -= 1;			break;		//	○ →１桁左へ移動
		case SB_LINERIGHT:	si.nPos += 1;			break;		//	○ →１桁右へ移動
		case SB_PAGELEFT:	si.nPos -= si.nPage;	break;		//	○ →１項左へ移動
		case SB_PAGERIGHT:	si.nPos += si.nPage;	break;		//	○ →１項右へ移動
		case SB_THUMBTRACK:	si.nPos = si.nTrackPos;	break;		//	○ →スクロールバーを離した位置へ移動
	}
	si.fMask = SIF_POS;											//	スクロール位置設定
	SetScrollInfo(hwnd, SB_HORZ, &si, TRUE);					//	・
	GetScrollInfo(hwnd, SB_HORZ, &si);							//	スクロール位置取得
	if (si.nPos != svPos) {										//	スクロール位置に変化あり？
		pW->ixView = TchDixToBix(pW, si.nPos);
		TchSetViewWidth(pW);
		InvalidateRect(hwnd, NULL, FALSE);						//		ウィンドゥ描画

		pW->NtcScrPos = si.nPos;
		SendMessage(GetParent(pW->hBack), WM_COMMAND,			//		スクロール位置通知
					MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCTCN_SCRPOS),
					fCmdWithHdl ? (LPARAM)pW->hBack : si.nPos);

	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_PAINT				)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc, mdc;
	RECT		r;
	BOOL		fPause = pW->fPause;

	//	ＤＣ設定
	hdc  = BeginPaint(hwnd, &ps);

	//	描画時間計測リセット
	if (pW->hMesDraw != NULL) {
		AjcMesTimeInterval(pW->hMesDraw);
	}

	//	メモリＤＣ生成
	mdc	  = CreateCompatibleDC(hdc);

	if (mdc != NULL) {
		if (pW->hBitmap == NULL) {
			pW->hBitmap = CreateCompatibleBitmap(hdc, pW->ww, pW->wh);
		}
		if (pW->hBitmap != NULL) {
			SelectObject(mdc, pW->hBitmap);
			//----- 描画クリアー ---------------//
			GetClientRect(hwnd, &r);
			if (pW->fEnable) FillRect(mdc, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
			else			 FillRect(mdc, &r, hBruBtnFace);
			//----- イメージ描画 ---------------//
			DrawImage(pW, mdc);
			//----- テキスト描画 ---------------//
			PaintText(pW, mdc);
			//----- タイトル描画 ---------------//
			SubTtlBmpDraw(&pW->TtlInfo, hwnd, mdc, 2, 0, pW->fEnable);
			//----- プロット周期描画 -----------//
			if (!pW->fGauEnable) {
				DrawMesPeri(pW, mdc);
			}
			//----- 時間計測ゲージ描画 ---------//
			else {
				DrawGauge(pW, mdc);
			}
			//----- ウインド表示 ---------------//
			BitBlt(hdc, 0, 0, pW->ww, pW->wh, mdc, 0, 0, SRCCOPY);
		}
		DeleteDC(mdc);
	}
	//	描画時間の集計
	if (pW->hMesDraw != NULL) {
		ULL		tm = AjcMesTimeInterval(pW->hMesDraw);
		pW->MesDraw.Cnt++;
		pW->MesDraw.Sum += tm;
		pW->MesDraw.Ave  = pW->MesDraw.Sum / pW->MesDraw.Cnt;
		pW->MesDraw.Max  = __max(pW->MesDraw.Max, tm);
		pW->MesDraw.Min  = __min(pW->MesDraw.Min, tm);
	}
	//	ＤＣ解放
	EndPaint(hwnd, &ps);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
//	計測情報取得コールバック
static VO CALLBACK cbMtvGetInfo  (PAJCMSTINFO pBuf, UX cbp)
{
	PWRKTMCHART	pW = (PWRKTMCHART)cbp;
	memcpy(pBuf, &pW->MesDraw, sizeof(AJCMSTINFO));
}
//	計測情報表示ダイアログクローズ通知
static VO CALLBACK cbMtvNtcClosed(UX cbp)
{
	PWRKTMCHART	pW = (PWRKTMCHART)cbp;
	//	描画時間計測インスタンス破棄
	if (pW->hMesDraw != NULL) { 
		AjcMesTimeDelete(pW->hMesDraw);
	}
	pW->hMesDraw	= NULL;
	pW->hDlgMesDraw = NULL;
}
//	ポップアップメニューＩＤ
enum {
	IDM_STOP		=	5001,
	IDM_START			,
	IDM_PAUSE			,
	IDM_RESTART			,
	IDM_COPYBMAP		,
	IDM_SETRANGE		,
	IDM_ADJUSTRANGE		,
	IDM_SETOFFSET		,
	IDM_SETOTHER		,
	IDM_SHOWFILTER		,
	IDM_HIDEFILTER		,
	IDM_SHOWSCALELINE	,
	IDM_HIDESCALELINE	,
	IDM_SHOWSCALEVALUE	,
	IDM_HIDESCALEVALUE	,
	IDM_SPLSET			,
	IDM_SPLINE			,
	IDM_CLEARDATA		,
	IDM_MESDRAW_ON		,
	IDM_MESDRAW_OFF		,
};

AJC_WNDPROC(Main, WM_RBUTTONDOWN		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	HMENU		hMenu;
	int			id;
	POINT		pt;
	int			sty;

	//	ツールチップ制御用にバックウインドへ通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	//	右クリック通知設定時（ユーザウインドへ専用メッセージ通知）
	if (pW->fNtcRClk) {
		if (pW->MsgRBDown != 0) {
			PostMessage(GetParent(pW->hBack), pW->MsgRBDown, wParam, lParam);
		}
	}
	//	CTRL/SHIFT 押下時（ユーザウインドへWM_COMMAND(AJCTCN_RCLICK)通知）
	else if (wParam & (MK_CONTROL | MK_SHIFT)) {
		pW->NtcRClk.x		= (SW)LOWORD(lParam);
		pW->NtcRClk.y		= (SW)HIWORD(lParam);
		pW->NtcRClk.fShift = ((wParam & MK_SHIFT  ) != 0);
		pW->NtcRClk.fCtrl	= ((wParam & MK_CONTROL) != 0);
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCTCN_RCLICK),
						fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)&pW->NtcRClk);
	}
	//	CTRL/SHIFT 未押下時（ポップアップメニュー）
	else {
		sty = (int)MAjcGetWindowLong(pW->hBack, GWL_STYLE);
		hMenu = CreatePopupMenu();

		//	スプライン補間モード時のポップアップメニュー
		if (pW->fSplineMode) {
			AppendMenu(hMenu, MFT_STRING, IDM_COPYBMAP	 , LNGSEL(L"コピー(&C)"			  , L"&Copy to clipboard"));
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			AppendMenu(hMenu, MFT_STRING, IDM_SETRANGE	 , LNGSEL(L"レンジ設定(&R)"		  , L"Set &Range"		));
			AppendMenu(hMenu, MFT_STRING, IDM_ADJUSTRANGE, LNGSEL(L"レンジ自動調整(&A)"	  , L"&Auto adjust range"));
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			if (pW->style & AJCTCS_NOFILTER	   ) AppendMenu(hMenu, MFT_STRING, IDM_SHOWFILTER	 , LNGSEL(L"フィルタ表示(&F)"		   , L"Show &Filter"		));
			else								 AppendMenu(hMenu, MFT_STRING, IDM_HIDEFILTER	 , LNGSEL(L"フィルタ非表示(&F)"		   , L"Hide &Filter"		));
			if (pW->style & AJCTCS_NOSCALELINE ) AppendMenu(hMenu, MFT_STRING, IDM_SHOWSCALELINE , LNGSEL(L"スケール・ライン表示(&L)"  , L"Show scale &Line"	));
			else								 AppendMenu(hMenu, MFT_STRING, IDM_HIDESCALELINE , LNGSEL(L"スケール・ライン非表示(&L)", L"Hide scale &Line"	));
			if (pW->style & AJCTCS_NOSCALEVALUE) AppendMenu(hMenu, MFT_STRING, IDM_SHOWSCALEVALUE, LNGSEL(L"スケール値表示(&V)"		   , L"Show scale &Value"	));
			else								 AppendMenu(hMenu, MFT_STRING, IDM_HIDESCALEVALUE, LNGSEL(L"スケール値非表示(&V)"	   , L"Hide scale &Value"	));
		}
		//	通常モード時のポップアップメニュー
		else {
			if (pW->fStop					   ) AppendMenu(hMenu, MFT_STRING, IDM_START		 , LNGSEL(L"スタート(&S)", L"&Start"  ));
			else								 AppendMenu(hMenu, MFT_STRING, IDM_STOP			 , LNGSEL(L"ストップ(&S)", L"&Stop"   ));
			if (pW->fPause					   ) AppendMenu(hMenu, MFT_STRING, IDM_RESTART		 , LNGSEL(L"再開(&E)"	 , L"R&eStart"));
			else								 AppendMenu(hMenu, MFT_STRING, IDM_PAUSE		 , LNGSEL(L"一時停止(&U)", L"Pa&use"  ));
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			AppendMenu(hMenu, MFT_STRING, IDM_COPYBMAP	 , LNGSEL(L"コピー(&C)"			  , L"&Copy to clipboard"));
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			AppendMenu(hMenu, MFT_STRING, IDM_SETRANGE	 , LNGSEL(L"レンジ設定(&R)"		  , L"Set &Range"		));
			AppendMenu(hMenu, MFT_STRING, IDM_ADJUSTRANGE, LNGSEL(L"レンジ自動調整(&A)"	  , L"&Automatic range adjustment"));
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			AppendMenu(hMenu, MFT_STRING, IDM_SETOFFSET	 , LNGSEL(L"オフセット設定(&T)"	  , L"Set offset(&T)"	   ));
			AppendMenu(hMenu, MFT_STRING, IDM_SETOTHER	 , LNGSEL(L"その他の設定(&O)"	  , L"Set Others(&O)"	   ));
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			if (pW->style & AJCTCS_NOFILTER	   ) AppendMenu(hMenu, MFT_STRING, IDM_SHOWFILTER	 , LNGSEL(L"フィルタ表示(&F)"		   , L"Show &Filter"		));
			else								 AppendMenu(hMenu, MFT_STRING, IDM_HIDEFILTER	 , LNGSEL(L"フィルタ非表示(&F)"		   , L"Hide &Filter"		));
			if (pW->style & AJCTCS_NOSCALELINE ) AppendMenu(hMenu, MFT_STRING, IDM_SHOWSCALELINE , LNGSEL(L"スケール・ライン表示(&L)"  , L"Show scale &Line"	));
			else								 AppendMenu(hMenu, MFT_STRING, IDM_HIDESCALELINE , LNGSEL(L"スケール・ライン非表示(&L)", L"Hide scale &Line"	));
			if (pW->style & AJCTCS_NOSCALEVALUE) AppendMenu(hMenu, MFT_STRING, IDM_SHOWSCALEVALUE, LNGSEL(L"スケール値表示(&V)"		   , L"Show scale &Value"	));
			else								 AppendMenu(hMenu, MFT_STRING, IDM_HIDESCALEVALUE, LNGSEL(L"スケール値非表示(&V)"	   , L"Hide scale &Value"	));
			if (pW->hDlgSpline == NULL && pW->nBuf >= 8) {
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
				AppendMenu(hMenu, MFT_STRING, IDM_SPLSET, LNGSEL(L"波形の補間表示設定(&P)"		, L"Inter&polation Setting"));
				AppendMenu(hMenu, MFT_STRING, IDM_SPLINE, LNGSEL(L"波形の補間表示ウインド(&I)"	, L"&Interpolation Window"));
			}
			if (pW->nBuf != 0) {
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
				AppendMenu(hMenu, MFT_STRING, IDM_CLEARDATA	 , LNGSEL(L"データクリアー(&D)"	  , L"Clear all &Data"	));
			}
			if (pW->fMesDrawEnable) {
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
				if (pW->hMesDraw == NULL) AppendMenu(hMenu, MFT_STRING, IDM_MESDRAW_ON	 , LNGSEL(L"描画時間情報 表示"	, L"Display drawing time information"));
				else					  AppendMenu(hMenu, MFT_STRING, IDM_MESDRAW_OFF	 , LNGSEL(L"描画時間情報 非表示", L"Hide drawing time informationn"));
			}
		}

		GetCursorPos(&pt);
		id = AjcDgcTrackPopupMenuEx(hMenu, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, hwnd, NULL);
		DestroyMenu(hMenu);

		switch (id) {
			case IDM_STOP:			 AjcTchStop (pW->hBack);		break;
			case IDM_START:			 AjcTchStart(pW->hBack);		break;
			case IDM_PAUSE:			 AjcTchPause(pW->hBack, TRUE);	break;
			case IDM_RESTART:		 AjcTchPause(pW->hBack, FALSE);	break;

			case IDM_SETRANGE:		 TchDialogBoxSetRange(pW);
									 break;

			case IDM_ADJUSTRANGE:	 AjcTchAdjustRange(pW->hBack);	break;

			case IDM_COPYBMAP:		 if (pW->hBitmap != NULL) {
										 HBITMAP hBm = (HBITMAP)CopyImage(pW->hBitmap, IMAGE_BITMAP, pW->ww, pW->wh, LR_COPYRETURNORG);
										 if (hBm != NULL) {
											 OpenClipboard(hwnd);
											 EmptyClipboard();
											 SetClipboardData(CF_BITMAP, hBm);
											 CloseClipboard();
										 }
									 }
									 break;

			case IDM_SETOFFSET:		 TchDialogBoxOffset(pW);
									 break;

			case IDM_SETOTHER:		 TchDialogBoxSetOther(pW);
									 break;

			case IDM_SHOWFILTER:	 MAjcSetWindowLong(pW->hBack, GWL_STYLE, sty & ~AJCTCS_NOFILTER	   );	break;
			case IDM_HIDEFILTER:	 MAjcSetWindowLong(pW->hBack, GWL_STYLE, sty |	AJCTCS_NOFILTER	   );	break;
			case IDM_SHOWSCALELINE:	 MAjcSetWindowLong(pW->hBack, GWL_STYLE, sty & ~AJCTCS_NOSCALELINE );	break;
			case IDM_HIDESCALELINE:	 MAjcSetWindowLong(pW->hBack, GWL_STYLE, sty |	AJCTCS_NOSCALELINE );	break;
			case IDM_SHOWSCALEVALUE: MAjcSetWindowLong(pW->hBack, GWL_STYLE, sty & ~AJCTCS_NOSCALEVALUE);	break;
			case IDM_HIDESCALEVALUE: MAjcSetWindowLong(pW->hBack, GWL_STYLE, sty |	AJCTCS_NOSCALEVALUE);	break;

			case IDM_SPLSET:		 TchDialogBoxSplSet(pW);	break;
			case IDM_SPLINE:		 TchCreateDlgSpline(pW);	break;

			case IDM_CLEARDATA:		if (MessageBoxW(hwnd, LNGSEL(L"データを全て破棄し、画面をクリアーします。よろしいですか？",
																 L"Discard all data and clear the screen. Is it OK?"), AppName, MB_YESNO) == IDYES) {
										AjcTchPurge(pW->hBack);
									}
									break;

			case IDM_MESDRAW_ON:	if (pW->hDlgMesDraw == NULL) {
										//	描画時間クリアー
										memset(&pW->MesDraw, 0, sizeof pW->MesDraw);
										pW->MesDraw.Min = -1;
										//	描画時間計測インスタンス生成
										pW->hMesDraw	= AjcMesTimeCreate(&pW->MesDraw.Freq);
										//	描画時間表示ダイアログク生成
										pW->hDlgMesDraw = AjcViewMesTimeCreate(hwnd, (UX)pW, cbMtvGetInfo, cbMtvNtcClosed);
									}
									break;

			case IDM_MESDRAW_OFF:	if (pW->hDlgMesDraw != NULL) {
										//	描画時間表示ダイアログクローズ
										AjcViewMesTimeDelete(pW->hDlgMesDraw);
									}
									break;
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_RBUTTONUP			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);

	//	右クリック通知設定時（ユーザウインドへ専用メッセージ通知）
	if (pW->fNtcRClk) {
		if (pW->MsgRBUp != 0) {
			PostMessage(GetParent(pW->hBack), pW->MsgRBUp, wParam, lParam);
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONDOWN		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);

	//	ツールチップ制御用にバックウインドへ通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	//	CTRL + 右クリックならば、マウスをキャプチャー
	if (wParam & MK_CONTROL) {
		if (pW->fEnable) {
			pW->fDrag = TRUE;
			SetCapture(hwnd);
			pW->DrgSrt.x = pW->DrgEnd.x = (SW)LOWORD(lParam);
			pW->DrgSrt.y = pW->DrgEnd.y = (SW)HIWORD(lParam);
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONUP			)
{
	PWRKTMCHART		pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);

	if (pW->fDrag) {
		pW->fDrag = FALSE;
		ReleaseCapture();
		if (wParam & MK_CONTROL) {
			pW->DrgEnd.x = (SW)LOWORD(lParam);
			pW->DrgEnd.y = (SW)HIWORD(lParam);
			if (pW->DrgSrt.y != pW->DrgEnd.y) {
				double SvRngL = pW->prop.RngL;
				double SvRngH = pW->prop.RngH;
				double yl = (double)pW->wh - __max(pW->DrgSrt.y, pW->DrgEnd.y);
				double yh = (double)pW->wh - __min(pW->DrgSrt.y, pW->DrgEnd.y);
				double w = fabs(pW->prop.RngH - pW->prop.RngL);
				double l = __min(pW->prop.RngL, pW->prop.RngH) + (w * yl / (double)pW->wh);
				double h = __min(pW->prop.RngL, pW->prop.RngH) + (w * yh / (double)pW->wh);
				//----- レンジ設定 ----------//
				if (pW->prop.RngL < pW->prop.RngH) {
					pW->prop.RngH = h;
					pW->prop.RngL = l;
				}
				else {
					pW->prop.RngH = l;
					pW->prop.RngL = h;
				}
				//----- レンジ変化通知 ------//
				if (SvRngL != pW->prop.RngL || SvRngH != pW->prop.RngH) {
					pW->NtcRng.RngL = pW->prop.RngL;
					pW->NtcRng.RngH = pW->prop.RngH;
					SendMessage(GetParent(pW->hBack), WM_COMMAND,
								MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCTCN_RANGE),
								fCmdWithHdl ? (LPARAM)pW->hBack : (WPARAM)&pW->NtcRng);
				}
			}
		}
		InvalidateRect(hwnd, NULL, FALSE);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_MBUTTONDOWN		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	POINT	pt;
	SIZE	sz;
	WC	tip[64];

	//	ツールチップ制御用にバックウインドへ通知
	SendMessage(pW->hBack, WM_MBUTTONDOWN, wParam, lParam);

	if (!pW->fSplineMode) {
		if (!(wParam & (MK_CONTROL | MK_SHIFT))) {		//	Shift,Ctrl未押下（プロット周期計測情報リセット）
			TchMesPeriReset(pW);
			//	チップ表示
			wcscpy(tip, AJCLNGSEL(L" プロット周期の計測をリセットしました。 ", L" The plot period measurement has been reset. "));
			GetCursorPos(&pt);
			AjcTipTextGetSize(tip, NULL, TRUE, &sz);
			AjcTipTextShow(pt.x, pt.y + 16, tip, 3000, NULL);
		}
		else if (wParam & MK_CONTROL) {					//	Ctrl押下
			if (!pW->fGauEnable) {
				//	計測済み単位間設定
				pW->MesPeriAveS = (UI)pW->MesPeriAve;
				//	メジャーゲージ有効
				pW->fGauEnable = TRUE;
			}
			else {
				//	メジャーゲージ無効
				pW->fGauEnable = FALSE;
			}
			InvalidateRect(pW->hMain, NULL, FALSE);
		}
	}
	//	スプラインモード時は、周期計測／時間計測不可
	else {
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_MBUTTONUP			)
{
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_MOUSEMOVE			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	int			x = (SW)LOWORD(lParam);
	int			y = (SW)HIWORD(lParam);

	//	ツールチップ制御用にバックウインドへ通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	//	ドラッグ範囲更新
	if (pW->fDrag) {
		pW->DrgEnd.x = x;
		pW->DrgEnd.y = y;
		InvalidateRect(hwnd, NULL, FALSE);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONDBLCLK		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	int			x = (SW)LOWORD(lParam);
	int			y = (SW)HIWORD(lParam);

	SendMessage(GetParent(pW->hBack), WM_COMMAND,
				MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCTCN_DBLCLK),
				fCmdWithHdl ? (LPARAM)pW->hBack : MAKELONG(x, y));

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DROPFILES			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	HWND		hParent = GetParent(pW->hBack);
	HDROP	hDrop;
	UI		i, n, bytes;
	WC		path[MAX_PATH];

	//----- 前回のドロップデータ破棄 ----------------------------------//
	AjcRngPurge(pW->hRngDir);
	AjcRngPurge(pW->hRngFile);

	//----- カウンタクリアー ------------------------------------------//
	pW->NtcDirs = pW->NtcFiles = 0;
	//----- ドロップディレクトリ名／ファイル名取得 --------------------//
	hDrop = (HDROP)wParam;														//	ドロップハンドル設定
	n	  = DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);							//	ドロップファイル数取得
	for (i=0; i<n; i++) {														//	ドロップパス数ループ
		DragQueryFile(hDrop, i, path, MAX_PATH);								//	ドロップパス名取得
		if (AjcPathExists(path)) {												//	有効なパス？
			bytes = (UI)wcslen(path) * 2 + 2;									//		パス名の長さ設定
			if (AjcPathIsDirectory(path)) {										//		ディレクトリ？
				pW->NtcDirs++;													//				DIR数更新
				AjcRngPutData(pW->hRngDir, (VOP)&bytes, sizeof bytes);			//				DIR名退避
				AjcRngPutData(pW->hRngDir, (VOP)path, bytes);					//				・
			}
			else {																//		ファイル？
				pW->NtcFiles++;													//				FILE数更新
				AjcRngPutData(pW->hRngFile, (VOP)&bytes, sizeof bytes);			//				ファイル名退避
				AjcRngPutData(pW->hRngFile, (VOP)path, bytes);					//				・
			}
		}
	}
	DragFinish(hDrop);															//	ドロップ終了

	//----- ディレクトリドロップイベント通知 --------------------------//
	if (pW->NtcDirs) {
		SendMessage(hParent, WM_COMMAND, MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCTCN_DROPDIR) ,
										 fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcDirs);
	}
	//----- ファイルドロップイベント通知 ------------------------------//
	if (pW->NtcFiles) {
		SendMessage(hParent, WM_COMMAND, MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCTCN_DROPFILE),
										 fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcFiles);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, TCH_IDC_BTN_WIDE		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	AJCTCPROP	prop;
	double		c, r;

	memcpy(&prop, &pW->prop, sizeof prop);
	if (HIWORD(wParam) == BN_CLICKED) {
		c = (prop.RngL + prop.RngH) / 2.0;
		r = (fabs(prop.RngH - prop.RngL) / 2.0 * 1.25);
		if (prop.RngL <= prop.RngH) {
			prop.RngL = c - r;
			prop.RngH = c + r;
		}
		else {
			prop.RngL = c + r;
			prop.RngH = c - r;
		}
		TchSetProp(pW, &prop);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, TCH_IDC_BTN_ZOOM		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	AJCTCPROP	prop;
	double		c, r;

	memcpy(&prop, &pW->prop, sizeof prop);
	if (HIWORD(wParam) == BN_CLICKED) {
		c = (prop.RngL + prop.RngH) / 2.0;
		r = (fabs(prop.RngH - prop.RngL) / 2.0 * 0.80);
		if (prop.RngL <= prop.RngH) {
			prop.RngL = c - r;
			prop.RngH = c + r;
		}
		else {
			prop.RngL = c + r;
			prop.RngH = c - r;
		}
		TchSetProp(pW, &prop);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, TCH_IDC_BTN_MESPERI	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);

	AjcTchMesPeriShow(pW->hBack, TRUE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, TCH_IDC_SPN_BAR_L		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	LPNMUPDOWN	pUd = (LPNMUPDOWN)lParam;
	UI			SvVal = pW->GauBarL;

	if (pUd->hdr.code == UDN_DELTAPOS) {
		pW->GauBarL += pUd->iDelta;
		pW->GauBarL  = __max((int)pW->GauBarL, (int)0			);
		pW->GauBarL  = __min((int)pW->GauBarL, (int)(pW->ww - 1));
		//----- 値が更新された場合の処理 ---------//
		if (pW->GauBarL != SvVal) {
			InvalidateRect(hwnd, NULL, FALSE);
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, TCH_IDC_SPN_BAR_H		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);
	LPNMUPDOWN	pUd = (LPNMUPDOWN)lParam;
	UI			SvVal = pW->GauBarH;

	if (pUd->hdr.code == UDN_DELTAPOS) {
		pW->GauBarH += pUd->iDelta;
		pW->GauBarH  = __max((int)pW->GauBarH, (int)0			);
		pW->GauBarH  = __min((int)pW->GauBarH, (int)(pW->ww - 1));
		//----- 値が更新された場合の処理 ---------//
		if (pW->GauBarH != SvVal) {
			InvalidateRect(hwnd, NULL, FALSE);
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, TCH_IDC_BTN_SETUNIT	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)MAjcGetWindowLong(hwnd, 0);

	TchDialogBoxUnitTime(pW);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE			)
	AJC_WNDMAP_MSG(Main, WM_DESTROY			)
	AJC_WNDMAP_MSG(Main, WM_SIZE			)
	AJC_WNDMAP_MSG(Main, WM_TIMER			)
	AJC_WNDMAP_MSG(Main, WM_HSCROLL			)
	AJC_WNDMAP_MSG(Main, WM_PAINT			)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONDOWN		)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONUP		)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONDOWN		)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONUP		)
	AJC_WNDMAP_MSG(Main, WM_MBUTTONDOWN		)
	AJC_WNDMAP_MSG(Main, WM_MBUTTONUP		)
	AJC_WNDMAP_MSG(Main, WM_MOUSEMOVE		)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONDBLCLK	)
	AJC_WNDMAP_MSG(Main, WM_DROPFILES		)

	AJC_WNDMAP_CMD(Main, TCH_IDC_BTN_WIDE	)
	AJC_WNDMAP_CMD(Main, TCH_IDC_BTN_ZOOM	)
	AJC_WNDMAP_CMD(Main, TCH_IDC_BTN_MESPERI)
	AJC_WNDMAP_NTC(Main, TCH_IDC_SPN_BAR_L	)
	AJC_WNDMAP_NTC(Main, TCH_IDC_SPN_BAR_H	)
	AJC_WNDMAP_CMD(Main, TCH_IDC_BTN_SETUNIT)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	イメージ描画																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DrawImage(PWRKTMCHART pW, HDC hdc)
{
	HFONT			hFont;
	HPEN			hPen;
	HBRUSH			hBru;
	RECT			r;
	double			*pDat, *pNxt;
	PTCH_VLINEBUF	 pVLi;
	double		y, step, min, max;
	UI			i, x, ix, msk, digit, prec, cxChar, cyChar, cyUnit;
	TEXTMETRIC	tm;
	LPPOINT		ptBuf;
	WC			txt[128];

	//----- フォント設定 ---------------//
	hFont = (HFONT)SelectObject(hdc, TchMyFont);
	//----- ドラッグ範囲描画 -----------//
	if (pW->fDrag) {
		r.left	 = 0;
		r.right	 = pW->ww;
		r.top	 = __min(pW->DrgSrt.y, pW->DrgEnd.y);
		r.bottom = __max(pW->DrgSrt.y, pW->DrgEnd.y);
		FillRect(hdc, &r, (HBRUSH)GetStockObject(LTGRAY_BRUSH));
	}

	//----- スケール情報設定 -----------//
	GetTextMetrics(hdc, &tm);
	cxChar = tm.tmAveCharWidth;
	cyChar = tm.tmHeight;// + tm.tmExternalLeading;
	cyUnit = cyChar + (cyChar / 2);
	min = __min(pW->prop.RngL, pW->prop.RngH);
	max = __max(pW->prop.RngL, pW->prop.RngH);
	if (pW->wh != 0) {
		step = AjcCalcRangeStep(fabs(max - min), 6.0, ((double)pW->wh / (double)cyUnit), &digit, &prec);
	}
	else {
		step = fabs(max - min);
	}
	min -= fmod(min, step);
	max -= fmod(max, step);

	//----- スケールライン描画 ---------//
	if (!(pW->style & AJCTCS_NOSCALELINE)) {
		hPen = (HPEN)SelectObject(hdc, hPenScale);
		//	横スケールライン
		if ((min >= 0.0 && max >= 0.0) || (min <=0.0 && max <= 0.0)) {	//	レンジ範囲は、正値のみ or 負値のみ？
			for (y=min; y<=max; y+=step) {
				MoveToEx(hdc, 0		, DatToYPos(pW, y), NULL);
				LineTo	(hdc, pW->ww, DatToYPos(pW, y));
			}
		}
		else {															//	レンジ範囲は、負値～正値？
			for (y=0; y<=max; y+=step) {
				MoveToEx(hdc, 0		, DatToYPos(pW, y), NULL);
				LineTo	(hdc, pW->ww, DatToYPos(pW, y));
			}
			for (y=0.0 - step; y>=min; y-=step) {
				MoveToEx(hdc, 0		, DatToYPos(pW, y), NULL);
				LineTo	(hdc, pW->ww, DatToYPos(pW, y));
			}
		}
		//	縦スケールライン
		if (pW->prop.TmScale != 0) {
			UI	dix	 = TchBixToDix(pW, pW->ixView);
			UI	lost = __max((int)0, (int)(pW->nTotal - pW->prop.MaxBuf));
			x = pW->prop.TmScale - ((dix + lost) % pW->prop.TmScale);
			while (x < pW->ww) {
				MoveToEx(hdc, x, 0	   , NULL);
				LineTo	(hdc, x, pW->wh		 );
				x += pW->prop.TmScale;
			}
		}
		hPen = (HPEN)SelectObject(hdc, hPen);
	}

	//----- 横線描画 -------------------//
	for (i = 0; i < TCH_MAX_HLINE; i++) {
		if (pW->HLineTbl[i].fEnable	 &&	 pW->HLineTbl[i].hPen != NULL) {
			hPen = (HPEN)SelectObject(hdc, pW->HLineTbl[i].hPen);
			y = DatToYPos(pW, pW->HLineTbl[i].pos);
			MoveToEx(hdc, 0		, (int)y, NULL);
			LineTo	(hdc, pW->ww, (int)y);
			hPen = (HPEN)SelectObject(hdc, hPen);
		}
	}
	//----- 縦線描画 -------------------//
	if (pW->fVLiEnable && pW->nView != 0) {
		for (x=0, ix=pW->ixView; x<pW->nView; x++, ix = (ix + 1) % pW->prop.MaxBuf) {
			pVLi = pW->pVLi + ix;
			if (pVLi->flag & TCH_VLIF_VLINE) {
				if (hPen = (HPEN)SelectObject(hdc, CreatePen(pVLi->style, pVLi->width, pVLi->rgb))) {
					MoveToEx(hdc, x, 0, NULL);
					LineTo	(hdc, x, pW->wh);
					DeleteObject(SelectObject(hdc, hPen));
				}
			}
		}
	}
	//----- 波形描画 -------------------//
	if (ptBuf = AJCMEM(sizeof(POINT) * pW->nView)) {
		if (pW->nView != 0) {
			for (i=0, msk=0x01; i<pW->prop.MaxItem; i++, msk<<=1) {
				if (pW->MskFilt & msk) {
					if (hPen = (HPEN)SelectObject(hdc, CreatePen(PS_SOLID, 1, pW->prop.Item[i].rgb))) {
						if (hBru = (HBRUSH)SelectObject(hdc, CreateSolidBrush(pW->prop.Item[i].rgb))) {
							UI ixpt;
							for (x = 0, ixpt = 0, ix = pW->ixView; x < pW->nView; x++, ix = (ix + 1) % pW->prop.MaxBuf) {
								int		y;
								pDat = pW->pBuf + ((ix * pW->prop.MaxItem) + i);
								y	 = DatToYPos(pW, *pDat + pW->prop.Item[i].ofs);
								//	線描画プロット点設定
								ptBuf[ixpt].x = x;
								ptBuf[ixpt].y = y;
								//	プロット点描画
								if (pW->fPointEnable) {
									pVLi = pW->pVLi + ix;
									if (pVLi->flag & TCH_VLIF_PLOT) {
										Ellipse (hdc, x - pVLi->r, y - pVLi->r, x + pVLi->r, y + pVLi->r);
									}
								}
								//	ポイントバッファインデクス更新
								ixpt++;
								//	次データとの結線チェック
								if (x + 1 < pW->nView && pW->MaxLineDist != 0) {
									//	次のデータ値設定
									pNxt = pW->pBuf + (((ix + 1) * pW->prop.MaxItem) + i);
									//	最大結線長を超えた場合、ここまでのライン描画
									if (fabs(*pDat - *pNxt) > pW->MaxLineDist) {
										Polyline(hdc, ptBuf, ixpt);
										//	ポイントバッファインデクスリセット
										ixpt=0;
									}
								}
							}
							Polyline(hdc, ptBuf, ixpt);
							DeleteObject(SelectObject(hdc, hBru));
						}
						DeleteObject(SelectObject(hdc, hPen));
					}
				}
			}
		}
		free(ptBuf);
	}
	else {
		AjcSnPrintF(txt, AJCTSIZE(txt), L"%s", "***** Memory error. The time chart image cannot be drawn. *****");
		TextOut(hdc, 50, 20, txt, (int)wcslen(txt));
	}
	//----- スケール値描画 -------------//
	if (!(pW->style & AJCTCS_NOSCALEVALUE)) {
		UI	maxstl = 0;
		SetBkMode(hdc, TRANSPARENT);
		if (pW->fEnable) SetTextColor(hdc, RGB(	 0,	  0,   0));
		else			 SetTextColor(hdc, GetSysColor(COLOR_GRAYTEXT));
		if ((min >= 0.0 && max >= 0.0) || (min <=0.0 && max <= 0.0)) {	//	レンジ範囲は、正値のみ or 負値のみ？
			for (y=min; y<=max; y+=step) {
				if (digit + prec <= 10) AjcSnPrintF(txt, AJCTSIZE(txt), L" %.*f", prec, y);
				else					AjcSnPrintF(txt, AJCTSIZE(txt), L" %.*G", digit + prec, y);
				TextOut(hdc, 0, DatToYPos(pW, y) - (cyChar / 2), txt, (int)wcslen(txt));
				maxstl = __max(maxstl, (UI)wcslen(txt));
			}
		}
		else {															//	レンジ範囲は、負値～正値？
			for (y=0.0; y<=max; y+=step) {
				if (digit + prec <= 10) AjcSnPrintF(txt, AJCTSIZE(txt), L" %.*f", prec, y);
				else					AjcSnPrintF(txt, AJCTSIZE(txt), L" %.*G", digit + prec, y);
				TextOut(hdc, 0, DatToYPos(pW, y) - (cyChar / 2), txt, (int)wcslen(txt));
				maxstl = __max(maxstl, (UI)wcslen(txt));
			}
			for (y=0.0; y>=min; y-=step) {
				if (digit + prec <= 10) AjcSnPrintF(txt, AJCTSIZE(txt), L" %.*f", prec, y);
				else					AjcSnPrintF(txt, AJCTSIZE(txt), L" %.*G", digit + prec, y);
				TextOut(hdc, 0, DatToYPos(pW, y) - (cyChar / 2), txt, (int)wcslen(txt));
				maxstl = __max(maxstl, (UI)wcslen(txt));
			}
		}
		if (pW->prop.TmScale != 0) {
			int		xt, xl=0;
			int		xr = cxChar * (maxstl + 2);
			UI		stl;
			UI		dix	 = TchBixToDix(pW, pW->ixView);
			UI		lost = __max((int)0, (int)(pW->nTotal - pW->prop.MaxBuf));
			x	= pW->prop.TmScale - ((dix + lost) % pW->prop.TmScale);
			dix += (lost + x); 
			while (x < pW->ww) {
				if (pW->fSplineMode) AjcSnPrintF(txt, AJCTSIZE(txt), L"%u", dix / pW->IpInfo.IpWidth);
				else				 AjcSnPrintF(txt, AJCTSIZE(txt), L"%u", dix);
				stl = (UI)wcslen(txt);
				xt = x - (stl * cxChar / 2);
				if (xt > xr && xt > xl) {
					TextOut(hdc, xt, pW->wh - (cyChar), txt, stl);
					xl = x + (stl * (cxChar + 1));
				}
				x	+= pW->prop.TmScale;
				dix += pW->prop.TmScale;
			}
		}
	}
	hFont = (HFONT)SelectObject(hdc, hFont);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	プロット周期描画																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DrawMesPeri(PWRKTMCHART pW, HDC hdc)
{
	int		stl;
	SIZE	sz;
	WC		ave[64];
	WC		txt[128];

	if (pW->fMesPeriShow) {
		SelectObject(hdc, hDefFontFix12);
		SetBkMode(hdc, TRANSPARENT);
		SetTextColor(hdc, RGB(0, 0, 0));
		if (pW->MesPeriAveS != 0) {
			AjcSnPrtSep(ave, AJCTSIZE(ave), L"%u", pW->MesPeriAveS);
			AjcSnPrintF(txt, AJCTSIZE(txt), LNGSEL(L"プロット周期・平均: %s[us]", L"Plot period - Ave.: %s[us]"), ave);
		}
		else {
			wcscpy(txt, AJCLNGSEL(L"プロット周期は まだ計測されていません。", L"The plot period has not yet been measured."));
		}
		stl = (int)wcslen(txt);
		GetTextExtentPoint32(hdc, txt, stl, &sz);
		TextOut(hdc, (pW->ww - sz.cx) / 2, 5, txt, stl);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	時間計測ゲージ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DrawGauge(PWRKTMCHART pW, HDC hdc)
{
	HPEN		hPen;
	TEXTMETRIC	tm;
	int		x = (pW->ww - (TCH_SPN_WIDTH * 2 + TCH_BTN_WIDTH)) / 2;
	int		y;
	UI		utime = (pW->fGauUseMes ? pW->MesPeriAveS : pW->GauSetUTime);
	UI		gl, ul, stl;
	WC		gtim[ 64], utim[ 64];
	WC		gtxt[128], utxt[128];

	hPen = (HPEN)SelectObject(hdc, TchPenGauBar);

	//	テキスト属性
	SelectObject(hdc, hDefFontFix12);
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, TCH_GAUGE_COLOR);
	GetTextMetrics(hdc, &tm);
	//	低位ゲージバー描画
	MoveToEx(hdc, pW->GauBarL, tm.tmHeight + 2, NULL);
	LineTo	(hdc, pW->GauBarL, pW->wh);
	TextOut (hdc, pW->GauBarL - (tm.tmAveCharWidth / 2)    , 1, L"L", 1);
	//	高位ゲージバー描画
	MoveToEx(hdc, pW->GauBarH, tm.tmHeight + 2, NULL);
	LineTo	(hdc, pW->GauBarH, pW->wh);
	TextOut (hdc, pW->GauBarH - (tm.tmAveCharWidth / 2) + 1, 1, L"H", 1);
	//	ゲージ間の時間表示
	if (utime != 0) {
		AjcSnPrtSep(gtim, AJCTSIZE(gtim), L"%i", utime * (pW->GauBarH - pW->GauBarL));
		AjcSnPrtSep(utim, AJCTSIZE(utim), L"%u", utime);
	}
	else {
		wcscpy(gtim, L"-");
		wcscpy(utim, L"-");
	}
	gl = (UI)wcslen(gtim);
	ul = (UI)wcslen(utim);
	stl = __max(gl, ul);
	AjcSnPrintF(gtxt, AJCTSIZE(gtxt), AJCLNGSEL(L"ゲージ間: %*s[us]", L"Between gauges: %*s[us]"), stl, gtim);
	AjcSnPrintF(utxt, AJCTSIZE(utxt), AJCLNGSEL(L"単位時間: %*s[us]", L"Unit Time     : %*s[us]"), stl, utim);
	//	計測時間描画
	SetTextColor(hdc, RGB(0, 0, 0));
	y = (pW->fShowBtns & fBtnGau) ? TCH_BTN_MRG + TCH_BTN_HEIGHT + 2 : tm.tmHeight + 2;
	TextOut(hdc, x, y, gtxt, (int)wcslen(gtxt)); y += tm.tmHeight;
	TextOut(hdc, x, y, utxt, (int)wcslen(utxt));

	SelectObject(hdc, hPen);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	データ値→Ｙ位置変換																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	int		DatToYPos(PWRKTMCHART pW, double dat)
{
	double	y;


	if (pW->prop.RngL <= pW->prop.RngH) {
		y = (double)pW->wh * ((dat - pW->prop.RngL) / fabs(pW->prop.RngH - pW->prop.RngL));
		y = pW->wh - y;
	}
	else {
		y = (double)pW->wh * ((dat - pW->prop.RngH) / fabs(pW->prop.RngH - pW->prop.RngL));
	}
	return (int)y;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	テキスト描画																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
VO		PaintText(PWRKTMCHART pW, HDC hdc)
{
	UI	i;

	if (AjcAvlGetCount(pW->hAvlTxo) != 0) {
		HFONT	hFontSv;
		if (hFontSv = SelectObject(hdc, pW->hFontTxo)) {
			if (pW->hTxo = AjcTxoCreate(hdc, 0, 0, -10)) {
				for (i = 0; i < 8; i++) {
					AjcTxoSetPaletteItem(pW->hTxo, i, pW->prop.Item[i].rgb);
				}
				AjcTxoSetDcBmpSize(pW->hTxo, pW->ww, pW->wh);
				AjcAvlEnumNodesEx(pW->hAvlTxo, (UX)pW, cbNtcNode, FALSE);
				AjcTxoDelete(pW->hTxo, TRUE);
				pW->hTxo = NULL;
			}
			SelectObject(hdc, hFontSv);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ＡＶＬノード通知																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbNtcNode(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	PWRKTMCHART	pW	  = (PWRKTMCHART)cbp;
	PTCHTXO		pNode = (PTCHTXO)pNodeData;

	AjcTxoTextOutEx(pW->hTxo, pNode->pt.x, pNode->pt.y, pNode->txt);

	return TRUE;
}

