﻿#include	"AjcInternal.h"
#include	"AjcCtrlVT100Def.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		ＡＰＩ												//
//																												//
//**************************************************************************************************************//

#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	グローバル変数																								//
//--------------------------------------------------------------------------------------------------------------//
ATOM	VthClassBack	= 0;
ATOM	VthClassMain	= 0;
ATOM	VthClassForMSIL	= 0;

UI		VthErrTxtLen;
WC		VthErrorTxt[128] = L"*** Memory allocation failure ***";

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL		SubPutText (PWRKVT100 pW, C_WCP pTxt, UI lTxt);

static	HGLOBAL		GetSelectedText	(PWRKVT100 pW);
static	BOOL		SaveToTextFile	(PWRKVT100 pW, HAJCFILE hFile, BOOL fAllText);
static	BOOL		SaveToHtmlFile	(PWRKVT100 pW, HAJCFILE hFile, BOOL fAllText, UI FontSize);
static	BOOL		WriteHtmlLine 	(PWRKVT100 pW, HAJCFILE hFile, PLINEPTR pL, UI ixSC, UI ixEC);
static	BOOL		WriteHtmlText 	(PWRKVT100 pW, HAJCFILE hFile, C_WCP pTxt, UI lTxt);
static	BOOL		SaveAllTextToFileWithEsc(PWRKVT100 pW, HAJCFILE hFile);


//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcCtrlVT100Init(VO)
{
	BOOL		rc = FALSE;
	WNDCLASS	wndclass;
	UI			stl;

	do {
		//----- エラーテキスト情報初期化 ----------------------//
		stl = (UI)wcslen(VthErrorTxt);
		VthMemSetA(&VthErrorTxt[stl], 0x07, stl);
		//----- バックウインドクラス --------------------------//
		wndclass.style			= CS_GLOBALCLASS;
		wndclass.lpfnWndProc	= VthWndProcBack();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRKVT100);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcCtrlVT100";
		if ((VthClassBack = RegisterClass(&wndclass)) == 0) break;

		//----- メイン描画ウインドクラス ---------------------//
		wndclass.style			= CS_DBLCLKS;
		wndclass.lpfnWndProc	= VthWndProcMain();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRKVT100);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_IBEAM);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcVT100MainClass";
		if ((VthClassMain = RegisterClass(&wndclass)) == 0) break;

		//----- ＭＳＩＬコードサポート用 ---------------------//
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= VthWndProcMSIL();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(VOP);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcVthForMSIL";
		if ((VthClassForMSIL = RegisterClass(&wndclass)) == 0) break;

		rc = TRUE;
	} while(0);

	if (rc == FALSE) {
		AjcCtrlVT100End();
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcCtrlVT100End (VO)
{
	HINSTANCE	hModInst = GetModuleHandle(NULL);

	if (VthClassBack	!= 0) {UnregisterClass((WCP)VthClassBack   , hDllInst); VthClassBack	= 0;}
	if (VthClassMain	!= 0) {UnregisterClass((WCP)VthClassMain   , hDllInst); VthClassMain	= 0;}
	if (VthClassForMSIL != 0) {UnregisterClass((WCP)VthClassForMSIL, hDllInst); VthClassForMSIL = 0;}
}

//==============================================================================================================//
//	フォーカス設定																								//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthSetFocus	   (HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (SetFocus(pW->hMain) != NULL);
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロパティ設定																								//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pProp  - 設定するプロパティデータのアドレス														//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthSetPropA	   (HWND hwnd, PCAJCVTHPROPA pProp)
{
	BOOL		rc = FALSE;
	AJCVTHPROPW	propW;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProp != NULL) {
			memcpy(&propW, pProp, sizeof propW);
			MultiByteToWideChar(CP_ACP, 0, pProp->LogFont.lfFaceName, -1, propW.LogFont.lfFaceName, AJCTSIZE(propW.LogFont.lfFaceName));
			rc = AjcVthSetPropW(hwnd, &propW);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthSetPropW	   (HWND hwnd, PCAJCVTHPROPW pProp)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProp != NULL) {
			rc = VthSetCtrlProp(pW, pProp);
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロパティ取得																								//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pProp  - 取得したプロパティデータを格納するバッファのアドレス									//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthGetPropA	   (HWND hwnd, PAJCVTHPROPA	pBuf)
{
	BOOL		rc = FALSE;
	AJCVTHPROPW	propW;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pBuf != NULL) {
			if (rc = AjcVthGetPropW(hwnd, &propW)) {
				memcpy(pBuf, &propW, sizeof(AJCVTHPROPA));
				WideCharToMultiByte(CP_ACP, 0, propW.LogFont.lfFaceName, -1, pBuf->LogFont.lfFaceName,
																AJCTSIZE(pBuf->LogFont.lfFaceName), NULL, NULL);
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthGetPropW	   (HWND hwnd, PAJCVTHPROPW	pBuf)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pBuf != NULL) {
			memcpy(pBuf, &pW->prop, sizeof(AJCVTHPROP));
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロパティ・リセット（ウインド生成時のプロパティ設定）														//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthResetProp	   (HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			VthSetCtrlProp(pW, &pW->IniProp);
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	ＶＲＡＭにフィットしたウインドサイズ取得																	//
//																												//
//	引　数	：	hwnd	- コントロールのハンドル																//
//				pWidth	- 横ピクセル数を格納するバッファのアドレス												//
//				pHeight - 縦ピクセル数を格納するバッファのアドレス												//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthGetVramFitSize(HWND hwnd, UIP pWidth, UIP pHeight)
{
	BOOL		rc = FALSE;
	RECT		r;
	UI			sty, exs;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			r.left	 = 0;
			r.right	 = pW->prop.VramW * pW->cxChar + (HMRG * 2);
			if ((pW->style & AJCVTHS_NOVSCROLL) == 0 && pW->prop.VramH < pW->LCnt) {
				r.right += GetSystemMetrics(SM_CXVSCROLL);
			}
			r.top	 = 0;
			r.bottom = pW->prop.VramH * pW->cyChar + (VMRG * 2);
			if ((pW->style & AJCVTHS_NOHSCROLL) == 0) {
				r.bottom += GetSystemMetrics(SM_CYHSCROLL);
			}

			sty = (UI)MAjcGetWindowLong(pW->hBack, GWL_STYLE);
			exs = (UI)MAjcGetWindowLong(pW->hBack, GWL_EXSTYLE);
			AdjustWindowRectEx(&r, sty, FALSE, exs);

			if (pWidth	!= NULL) *pWidth  = r.right - r.left;
			if (pHeight != NULL) *pHeight = r.bottom - r.top;

			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	１文字描画																									//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				c	   - 文字コード																				//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthPutCharA	   (HWND hwnd, UI c)
{
	BOOL	rc = FALSE;
	BC		bc = (BC)c;

	rc =  AjcVthPutTextA(hwnd, &bc, 1);

	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthPutCharW	   (HWND hwnd, UI c)
{
	BOOL	rc = FALSE;
	UW		wc = (UW)c;

	rc = AjcVthPutTextW(hwnd, &wc, 1);

	return rc;
}

//==============================================================================================================//
//	テキスト描画（自動）																						//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pTxt   - 日本語ＥＵＣテキストデータのアドレス													//
//				lTxt   - テキスト文字数（－１の場合は、自動計算する）											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
static BOOL	  SubPutTextAuto(HWND hwnd, C_BCP pTxt, UI lTxt, BOOL (WINAPI *cbPutUtf8)(HWND hwnd, C_BCP pTxt, UI lTxt))
{
	BOOL		rc = FALSE;
	BCP			pSrc;
	AJCMBCKIND	mbk;
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	//	文字列長自動設定／補正
	lTxt = AjcStrAdjustLenA(pTxt, lTxt);
	//	テキスト描画
	if (pSrc = (BCP)AJCMEM(lTxt + 1)) {
		memcpy(pSrc, pTxt, lTxt);
		pSrc[lTxt] = 0;
		if (lTxt != 0) {
			//--- 文字コード判定用データ蓄積 -----//
			AjcMbcPutData(pW->hMbc, pSrc);
			//--- 文字コード判別とテキスト出力 ---//
			mbk = AjcMbcCheck(pW->hMbc);
			if (mbk <= 0) {
				mbk = pW->SvMbk;
			}
			switch(mbk) {
				default:
				case AJCMBC_SJIS:	rc = AjcVthPutTextA  (hwnd, pTxt, lTxt);	break;
				case AJCMBC_EUC:	rc = AjcVthPutTextEUC(hwnd, pTxt, lTxt);	break;
				case AJCMBC_UTF8:	rc = cbPutUtf8		 (hwnd, pTxt, lTxt);	break;
			}
			pW->SvMbk = mbk;
		}
		else rc = TRUE;
		free(pSrc);
	}
	return rc;
}
//----- バイト文字（UTF-８はS-JISに変換して描画する）-----------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthPutTextAutoA	   (HWND hwnd, C_BCP pTxt, UI lTxt)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			rc = SubPutTextAuto(hwnd, pTxt, lTxt, AjcVthPutTextUTF8A);
		}
	}
	return rc;
}
//----- ワイド文字（他国文字も描画する）------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthPutTextAutoW	   (HWND hwnd, C_BCP pTxt, UI lTxt)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			rc = SubPutTextAuto(hwnd, pTxt, lTxt, AjcVthPutTextUTF8W);
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキスト描画（日本語ＥＵＣ）																				//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pTxt   - 日本語ＥＵＣテキストデータのアドレス													//
//				lTxt   - テキスト文字数（－１の場合は、自動計算する）											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthPutTextEUC	   (HWND hwnd, C_BCP pTxt, UI lTxt)
{
	BOOL		rc = FALSE;
	BCP			pEuc;
	BCP			pSJis;
	UI			lSJis;
	UI			lTail;
	AJCMBCINFO	mbi;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			//	文字列長自動設定／補正
			lTxt = AjcStrAdjustLenA(pTxt, lTxt);
			//	テキスト描画
			if (pEuc = (BCP)AJCMEM(lTxt + 8 + 1)) {
				//	退避されている半端バイトとテキストを合成
				if (pW->SvStl == 0) {
					memcpy(pEuc, pTxt, lTxt);
				}
				else {
					memcpy(pEuc 		   , pW->SvStr, pW->SvStl);
					memcpy(pEuc + pW->SvStl, pTxt	  , lTxt	 );
					lTxt += pW->SvStl;
					pW->SvStl = 0;
				}
				pEuc[lTxt] = 0;

				if (lTxt != 0) {
					//	末尾の半端バイト退避
					AjcStrChkEucPart(pEuc, lTxt - 1, &mbi);
					lTail = mbi.ix + 1;
					if ((UI)mbi.len != lTail) {
						lTail = __min(lTail, lTxt);
						memcpy(pW->SvStr, pEuc + (lTxt - lTail), lTail);
						pW->SvStl = lTail;
						lTxt -= lTail;
					}
					//	ＥＵＣ→ＳＪＩＳ変換し、テキスト表示
					if (lTxt != 0) {
						lSJis = AjcEucToSJisEx(pEuc, lTxt, NULL, 0);
						if (pSJis = (BCP)AJCMEM(lSJis)) {
							AjcEucToSJisEx(pEuc, lTxt, pSJis, lSJis);
							AjcVthPutTextA(hwnd, pSJis, lSJis);
							free(pSJis);
							rc = TRUE;
						}
					}
					else rc = TRUE;
				}
				else rc = TRUE;
				free(pEuc);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキスト描画（ＵＴＦ－８）																					//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pTxt   - ＵＴＦ－８テキストデータのアドレス														//
//				lTxt   - テキスト文字数（－１の場合は、自動計算する）											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//	共通サブ関数
static BOOL	  SubPutTextUTF8	   (HWND hwnd, C_BCP pTxt, UI lTxt, BOOL (*cbPutText)(HWND hwnd, C_BCP pUtf8, UI lTxt))
{
	BOOL		rc = FALSE;
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	BCP			pUtf8;
	UI			lTail;
	AJCMBCINFO	mbi;

	//	文字列長自動設定／補正
	lTxt = AjcStrAdjustLenA(pTxt, lTxt);
	//	テキスト描画
	if (pUtf8 = (BCP)AJCMEM(lTxt + 8 + 1)) {
		//	退避されている半端バイトとテキストを合成
		if (pW->SvStl == 0) {
			memcpy(pUtf8, pTxt, lTxt);
		}
		else {
			memcpy(pUtf8			, pW->SvStr, pW->SvStl);
			memcpy(pUtf8 + pW->SvStl, pTxt	   , lTxt	  );
			lTxt += pW->SvStl;
			pW->SvStl = 0;
		}
		pUtf8[lTxt] = 0;

		if (lTxt != 0) {
			//	末尾の半端バイト退避
			AjcStrChkUtf8Part(pUtf8, lTxt - 1, &mbi);
			lTail = mbi.ix + 1;
			if ((UI)mbi.len != lTail) {
				lTail = __min(lTail, lTxt);
				memcpy(pW->SvStr, pUtf8 + (lTxt - lTail), lTail);
				pW->SvStl = lTail;
				lTxt -= lTail;
			}
			//	ＵＴＦ８→UNICODE変換し、テキスト表示
			if (lTxt != 0) {
				rc = cbPutText(hwnd, pUtf8, lTxt);
			}
			else rc = TRUE;
		}
		else rc = TRUE;
		free(pUtf8);
	}
	return rc;
}
//----- バイト文字（S-JISに変換して表示）-----------------------------------------------------------------------//
//	コールバック
static	BOOL	cbPutTextUTF8A(HWND hwnd, C_BCP pUtf8, UI lTxt)
{
	BOOL		rc = FALSE;
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	BCP			pMbc = NULL;
	UI			lMbc = 0;

	if (lTxt != 0) {
		lMbc = AjcUtf8ToSJisEx(pUtf8, lTxt, NULL, 0);
		if (lMbc != 0 && (pMbc = AjcTAllocA(lMbc + 1))) {
			AjcUtf8ToSJisEx(pUtf8, lTxt, pMbc, lMbc);
			AjcVthPutTextA(hwnd, pMbc, lMbc);
			free(pMbc);
			rc = TRUE;
		}
	}
	else rc = TRUE;

	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - // 
AJCEXPORT BOOL	  WINAPI AjcVthPutTextUTF8A	   (HWND hwnd, C_BCP pTxt, UI lTxt)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			rc = SubPutTextUTF8(hwnd, pTxt, lTxt, cbPutTextUTF8A);
		}
	}
	return rc;
}
//----- ワイド文字（UNICODEに変換して表示）---------------------------------------------------------------------//
//	コールバック
static	BOOL	cbPutTextUTF8W(HWND hwnd, C_BCP pUtf8, UI lTxt)
{
	BOOL		rc = FALSE;
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	WCP			pUni = NULL;
	UI			lUni = 0;

	if (lTxt != 0) {
		lUni = MultiByteToWideChar(CP_UTF8, 0, pUtf8, lTxt, NULL, 0);
		if (pUni = AjcTAllocW(lUni)) {
			MultiByteToWideChar(CP_UTF8, 0, pUtf8, lTxt, pUni, lUni);
			AjcVthPutTextW(hwnd, pUni, lUni);
			free(pUni);
			rc = TRUE;
		}
	}
	else rc = TRUE;

	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - // 
AJCEXPORT BOOL	  WINAPI AjcVthPutTextUTF8W	   (HWND hwnd, C_BCP pTxt, UI lTxt)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			rc = SubPutTextUTF8(hwnd, pTxt, lTxt, cbPutTextUTF8W);
		}
	}
	return rc;
}

//==============================================================================================================//
//	テキスト描画（シフトＪＩＳ）																				//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pTxt   - テキストデータのアドレス																//
//				lTxt   - テキスト文字数（－１の場合は、自動計算する）											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthPutTextA	   (HWND hwnd, C_BCP pTxt, UI lTxt)
{
	BOOL		rc = FALSE;
	WCP			pTmp;
	UL			len;
	WC			wc[4];

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			do {
				//	文字列長自動設定／補正
				lTxt = AjcStrAdjustLenA(pTxt, lTxt);
				//	テキスト長チェック
				if (lTxt == 0) {rc = TRUE; break;}
				//	前回の半端バイト処理
				if (pW->SvMbc != 0) {
					BC		bc[2];
					bc[0] = pW->SvMbc;
					bc[1] = *pTxt;
					pW->SvMbc = 0;
					MultiByteToWideChar(CP_ACP, 0, bc, 2, wc, 1);
					if (!(rc = SubPutText(pW, wc, 1))) {
						break;
					}
					pTxt++;
					lTxt--;
				}
				//	テキスト長チェック
				if (lTxt == 0) {rc = TRUE; break;}
				//	末尾が全角１文字目ならば退避し、除外する
				if (mbsbtype(pTxt, lTxt - 1) == _MBC_LEAD) {
					pW->SvMbc = pTxt[lTxt - 1];
					lTxt--;
				}
				//	テキスト長チェック
				if (lTxt == 0) {rc = TRUE; break;}
				//	MBC -> UNICODE 変換し出力
				len = MultiByteToWideChar(CP_ACP, 0, pTxt, lTxt, NULL, 0);
				if (len != 0  &&  (pTmp = AjcTAlloc(len + 1))) {
					MultiByteToWideChar(CP_ACP, 0, pTxt, lTxt, pTmp, len);
					pTmp[len] = 0;
					rc = SubPutText(pW, pTmp, len);
					free(pTmp);
				}
				else rc = FALSE;
			} while(0);
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthPutTextW	   (HWND hwnd, C_WCP pTxt, UI lTxt)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			lTxt = AjcStrAdjustLenW(pTxt, lTxt);
			if (lTxt != 0) {
				rc = SubPutText(pW, pTxt, lTxt);
			}
			else rc = TRUE;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	文字列表示																									//
//																												//
//	引　数	：	pW			- 作業領域のアドレス																//
//				hFile		- ファイルハンドル																	//
//				fAllText	- TRUE:全テキスト，FALSE:選択テキスト												//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 選択中のテキストなし																	//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubPutText (PWRKVT100 pW, C_WCP pTxt, UI lTxt)
{
	BOOL	rc;
	UI		stl, bytes;

	stl  = (UI)wcslen(pTxt);
	lTxt = __min(lTxt, stl);
	bytes = lTxt * 2;
	rc = (AjcRngPutData(pW->hRngTxt, (VOP)pTxt, bytes) == bytes);		//	テキストを退避
	bytes = AjcRngGetDataSize(pW->hRngTxt);								//	bytes = 現在の表示保留バイト数
	if (bytes >= pW->prop.PendSize) {									//	最大保留サイズオーバー？
		VthSetMode(pW, MD_NORMAL);										//		範囲選択状態，表示保留解除
	}
	VthPutTextToVRAM(pW);												//	ＶＲＡＭ描画

	return rc;
}
//==============================================================================================================//
//	書式テキスト描画																							//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pFmt   - 書式テキスト																			//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthPrintFA	   (HWND hwnd, C_BCP pFmt, ...)
{
	BOOL		rc = FALSE;
	va_list 	vls;
	BC			buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf(buf, 2048, pFmt, vls);
		buf[2047] = 0;
		va_end	(vls);
		rc = AjcVthPutTextA(hwnd, buf, -1);
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthPrintFW	   (HWND hwnd, C_WCP pFmt, ...)
{
	BOOL		rc = FALSE;
	va_list 	vls;
	WC			buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf(buf, 2048, pFmt, vls);
		buf[2047] = 0;
		va_end	(vls);
		rc = AjcVthPutTextW(hwnd, buf, -1);
	}
	return rc;
}
//==============================================================================================================//
//	タイムスタンプ描画																							//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	   WINAPI AjcVthTimeStamp	(HWND hwnd)
{
	BOOL		rc = FALSE;
	SYSTEMTIME	lt;

	GetLocalTime(&lt);
	rc = AjcVthPrintFW(hwnd, L"%02d:%02d:%02d.%03d", lt.wHour, lt.wMinute, lt.wSecond, lt.wMilliseconds);

	return rc;
}
//==============================================================================================================//
//	バイナリデータの１６進ダンプ描画																			//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pDat   - バイナリデータのアドレス																//
//				lDat   - バイナリデータのバイト数																//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	   WINAPI AjcVthHexDump		(HWND hwnd, C_UBP pDat, UI lDat)
{
	BOOL	rc = TRUE;
	WCP		p, pBuf;
	UI		lBuf = lDat * 3;
	UB		l, h;

	if (pDat != NULL && lDat > 0) {
		if (pBuf = AjcTAlloc(lBuf)) {
			p = pBuf;
			while (lDat > 0) {
				h = ((UB)(*pDat) >> 4);
				l = ((UB)(*pDat) & 15);
				*p++ = L' ';
				*p++ = (WC)(h < 10 ? (h | 0x30) : (h + L'A' - 10));
				*p++ = (WC)(l < 10 ? (l | 0x30) : (l + L'A' - 10));
				pDat++;
				lDat--;
			}
			rc = AjcVthPutTextW(hwnd, pBuf, lBuf);
			free(pBuf);
		}
		else {
			while (lDat--) {
				rc &= AjcVthPrintFW(hwnd, L" %02X", *pDat++);
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	カーソル位置設定																							//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				line   - 行位置（０～）																			//
//				col	   - 桁位置（０～）																			//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthLocate	   (HWND hwnd, UI line, UI col)
{
	BOOL	rc = FALSE;

	rc = AjcVthPrintFW(hwnd, L"\x1B[%u;%uH", line + 1, col + 1);

	return rc;
}
//==============================================================================================================//
//	カーソル位置取得																							//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pLine	- 行位置（０～）を格納するバッファのアドレス											//
//				pCol	- 桁位置（０～）を格納するバッファのアドレス											//
//																												//
//	戻り値	：	行位置																							//
//==============================================================================================================//
AJCEXPORT UI	   WINAPI AjcVthGetCursorPos(HWND hwnd, UIP pLine, UIP pCol)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pLine != NULL) *pLine = pW->lp;
			if (pCol  != NULL) *pCol  = pW->cp;
			rc = pW->lp;
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキスト表示色設定																							//
//																												//
//	引　数	：	hwnd	  - コントロールのハンドル																//
//				PaletteNo - パレット番号（０～７）																//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthSetColor	   (HWND hwnd, UI PaletteNo)
{
	BOOL	rc = FALSE;

	rc = AjcVthPrintFW(hwnd, L"\x1B[%um", PaletteNo + 30);

	return rc;
}
//==============================================================================================================//
//	テキスト表示色取得																							//
//																												//
//	引　数	：	hwnd	  - コントロールのハンドル																//
//																												//
//	戻り値	：	テキスト表示色（パレット番号）																	//
//==============================================================================================================//
AJCEXPORT UI	   WINAPI AjcVthGetColor	(HWND hwnd)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (pW->att & 7);
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキスト背景色設定																							//
//																												//
//	引　数	：	hwnd	  - コントロールのハンドル																//
//				PaletteNo - パレット番号（０～７）																//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthSetBkColor  (HWND hwnd, UI PaletteNo)
{
	BOOL	rc = FALSE;

	rc = AjcVthPrintFW(hwnd, L"\x1B[%um", PaletteNo + 40);

	return rc;
}
//==============================================================================================================//
//	テキスト背景色取得																							//
//																												//
//	引　数	：	hwnd	  - コントロールのハンドル																//
//																												//
//	戻り値	：	背景色（パレット番号）																			//
//==============================================================================================================//
AJCEXPORT UI	   WINAPI AjcVthGetBkColor	(HWND hwnd)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = ((pW->att >> 4) & 7);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ウインドの背景色設定																						//
//																												//
//	引　数	：	hwnd		- コントロールのハンドル															//
//				iPaletteNo	- 背景色のパレット番号																//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	   WINAPI AjcVthSetWndBkColor(HWND hwnd, UI PaletteNo)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && PaletteNo < 8) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pW->IxBkWnd = PaletteNo;
			VthCreateBkWndObj(pW);
			InvalidateRect(pW->hBack, NULL, FALSE);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ウインドの背景色取得																						//
//																												//
//	引　数	：	hwnd	  - コントロールのハンドル																//
//																												//
//	戻り値	：	背景色のパレット番号																			//
//==============================================================================================================//
AJCEXPORT UI	WINAPI AjcVthGetWndBkColor(HWND hwnd)
{
	COLORREF	rc = (COLORREF)0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->IxBkWnd;
		}
	}
	return rc;
}
//==============================================================================================================//
//	パレットの色設定																							//
//																												//
//	引　数	：	hwnd	  - コントロールのハンドル																//
//				PaletteNo - パレット番号（０～７）																//
//				rgb		  - パレットに設定する色																//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthSetPalette  (HWND hwnd, UI PaletteNo, COLORREF rgb)
{
	BOOL		rc = FALSE;
	AJCVTHPROP	prop;

	if (IsWindow(hwnd)	&&	PaletteNo < 8) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//	ウインド背景色のペン，ブラシ生成
			VthCreateBkWndObj(pW);
			//	プロパティのパレット色更新
			memcpy(&prop, &pW->prop, sizeof prop);
			prop.rgb[PaletteNo] = rgb;
			rc = VthSetCtrlProp(pW, &prop);
		}
	}
	return rc;
}
//==============================================================================================================//
//	パレットの色取得																							//
//																												//
//	引　数	：	hwnd	  - コントロールのハンドル																//
//				PaletteNo - パレット番号（０～７）																//
//																												//
//	戻り値	：	パレットの色コード																				//
//==============================================================================================================//
AJCEXPORT COLORREF WINAPI AjcVthGetPalette	(HWND hwnd, UI PaletteNo)
{
	COLORREF	rc = (COLORREF)0;

	if (IsWindow(hwnd)	&&	PaletteNo < 8) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = (pW->prop.rgb[PaletteNo & 7]);
		}
	}
	return rc;
}

//==============================================================================================================//
//	部分選択																									//
//																												//
//	引　数	：	hwnd	 - コントロールのハンドル																//
//				slp, scp - 選択開始行位置，桁位置																//
//				elp, ecp - 選択終了行位置，桁位置																//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthSelect	(HWND hwnd, UI slp, UI scp, UI elp, UI ecp)
{
	BOOL		rc = FALSE;
	int			six, eix;
	PLINEPTR	pSL, pEL;		//	ラインポインタ
	UBP			pSA, pEA;		//	属性ポインタ

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//	選択行位置調整
			if (slp >= pW->LCnt) slp = pW->LCnt - 1;
			if (elp >= pW->LCnt) elp = pW->LCnt - 1;
			//	選択範囲の調整
			if		(slp == elp) {							//	開始行 ＝ 終了行？
				if (scp > ecp) {							//		開始桁 ＞ 終了桁？
					AjcMemSwap(&scp, &ecp, sizeof(UI));		//			開始桁と終了桁を交換
				}
			}
			else if (slp > elp) {							//	開始行 ＞ 終了行？
				AjcMemSwap(&slp, &elp, sizeof(UI));			//		開始行と終了行を交換
				AjcMemSwap(&scp, &ecp, sizeof(UI));			//		開始桁と終了桁を交換
			}
			//	行ポインタ設定
			six = VthLnoToIx(pW, slp);	pSL = pW->pLPtr + six;
			eix = VthLnoToIx(pW, elp);	pEL = pW->pLPtr + eix;
			//	桁位置調整（当該行の終端以下とする）
			if (scp > pSL->len) scp = pSL->len;
			if (ecp > pSL->len) ecp = pEL->len;
			//	開始桁位置がサロゲート２ワード目ならば、１つ戻す
			if (pSL->fVram) pSA = (UBP)(pSL->pTxt + (pW->prop.VramW)) + scp;
			else			pSA = (UBP)(pSL->pTxt + (pSL->len	   )) + scp;
			if (*pSA & VAT_SUR2) scp--;
			//	終了桁位置がサロゲート２ワード目ならば、１つ進める
			if (pEL->fVram) pEA = (UBP)(pEL->pTxt + (pW->prop.VramW)) + ecp;
			else			pEA = (UBP)(pEL->pTxt + (pEL->len 	   )) + ecp;
			if (*pEA & VAT_SUR2) ecp++;
			//	選択情報設定
			if (slp != elp || scp != ecp) {	//	選択範囲あり（行位置／桁位置のいずれかが異なる）？
				pW->SelInf.ixSL = six;
				pW->SelInf.ixSC = scp;
				pW->SelInf.ixEL = eix;
				pW->SelInf.ixEC = ecp;
				VthSetMode(pW, pW->Mode | MD_SELECT);
				InvalidateRect(hwnd 	, NULL, FALSE);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	全て選択																									//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthSelectAll   (HWND hwnd)
{
	BOOL		rc = FALSE;
	UI			ix;
	PLINEPTR	pL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pW->LCnt != 0) {
				pW->SelInf.ixSL = pW->IxSrt;
				pW->SelInf.ixSC = 0;
				ix = VthLnoToIx(pW, pW->LCnt - 1);
				pL = pW->pLPtr + ix;
				pW->SelInf.ixEL = ix;
				pW->SelInf.ixEC = pL->len;
				VthSetMode(pW, pW->Mode | MD_SELECT);
				InvalidateRect(hwnd 	, NULL, FALSE);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	コピー																										//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthCopyText	   (HWND hwnd)
{
	BOOL		rc = FALSE;
	HGLOBAL		hGlobal;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (hGlobal = GetSelectedText(pW)) {
				//	クリップボードへコピー
				GlobalUnlock(hGlobal);
				OpenClipboard(pW->hBack);
				EmptyClipboard();
				SetClipboardData(CF_UNICODETEXT, hGlobal);
				CloseClipboard();
				//	選択状態解除
				VthSetMode(pW, pW->Mode & ~MD_SELECT);
				InvalidateRect(pW->hMain, NULL, FALSE);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	フォント設定																								//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//- - - フォントダイアログ起動通知 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
static	VO CALLBACK cbAvsfInit (HWND hDlg, UX cbp)	//	hDlg = Font setting dialog
{
	AjcMoveWindowToCenterOfMonitor(hDlg);
}
//- - - 摘要ボタン押下通知 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
BOOL CALLBACK cbAvsfApply (HFONT hFont, UI lsp, UX cbp)
{
	HWND		hwnd = (HWND)cbp;
	PWRKVT100	pW	 = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	AJCVTHPROP	prop;

	AjcVthGetProp(hwnd, &prop);
	GetObjectW(hFont, sizeof prop.LogFont, &prop.LogFont);
	prop.LSpace = lsp;
	AjcVthSetProp(hwnd, &prop);

	return TRUE;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	  WINAPI AjcVthSetFont	   (HWND hwnd)
{
	BOOL		rc = FALSE;
	AJCVTHPROP	prop;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			memcpy(&prop, &pW->prop, sizeof prop);
			memcpy(&pW->DwkFontInfo.lf, &prop.LogFont, sizeof pW->DwkFontInfo.lf);
			pW->DwkFontInfo.lsp = prop.LSpace;
			if (AjcCfFontDlgW(hwnd, 0, &pW->DwkFontInfo, &pW->DwkPermInfo, (UX)hwnd, cbAvsfInit, cbAvsfApply)) {	//	フォント設定ＯＫ？
				memcpy(&prop.LogFont, &pW->DwkFontInfo.lf, sizeof prop.LogFont);	//		プロパティ情報にフォント情報設定
				prop.LSpace = pW->DwkFontInfo.lsp;
				if (!(rc = AjcVthSetProp(hwnd, &prop))) {							//		新フォントインプリメント
					MessageBoxW(hwnd, LNGSEL(L"このフォントは設定できません", L"This font can not be set !!"),
									  AppName, MB_APPLMODAL | MB_ICONERROR);
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	キャレット表示																								//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthShowCaret   (HWND hwnd, BOOL fShow)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pW->fCaret = fShow;
			VthSetCaret(pW);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	全テキストクリアー																							//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	  WINAPI AjcVthClear(HWND hwnd)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//----- 自動判別文字コードバッファ初期化 -----------------------------------------------------------//
			AjcMbcReset(pW->hMbc);
			pW->SvMbk = AJCMBC_SJIS;
			//----- 描画色リセット -----------------------------------------------------------------------------//
		//	VrmSetAtt(pW, VAT_DEFAULT);
			//----- テキストクリアー ---------------------------------------------------------------------------//
			VthClearAllText(pW);
			InvalidateRect(hwnd 	, NULL, FALSE);
			//	次回文字列検索時、検索開始位置を再設定する
			VthResetFindSrtPos(pW);

			rc = TRUE;
		}
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	  WINAPI AjcVthClearAllText(HWND hwnd)
{
	BOOL		rc = FALSE;

	rc = AjcVthClear(hwnd);

	return rc;
}

//==============================================================================================================//
//	ドロップされたファイル名取得																				//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//				buf	  - ファイル名を格納するバッファのアドレス													//
//																												//
//	戻り値	：	TRUE:ファイル名あり，FALSE:ファイル名なし														//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcVthGetDroppedFileA (HWND hwnd, BC buf[MAX_PATH])
{
	BOOL	rc = FALSE;
	WC		tmp[MAX_PATH];

	if (buf != NULL) {
		if (rc = AjcVthGetDroppedFileW(hwnd, tmp)) {
			WideCharToMultiByte(CP_ACP, 0, tmp, -1, buf, MAX_PATH, NULL, NULL);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcVthGetDroppedFileW (HWND hwnd, WC buf[MAX_PATH])
{
	BOOL		rc = FALSE;
	UI			bytes;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && buf != NULL) {
			if (AjcRngGetData(pW->hRngFile, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
				rc = (AjcRngGetData(pW->hRngFile, (VOP)buf, bytes) == bytes);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ドロップされたディレクトリ名取得																			//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//				buf	  - ディレクトリ名を格納するバッファのアドレス												//
//																												//
//	戻り値	：	TRUE:ディレクトリ名あり，FALSE:ディレクトリ名なし												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcVthGetDroppedDirA  (HWND hwnd, BC buf[MAX_PATH])
{
	BOOL	rc = FALSE;
	WC		tmp[MAX_PATH];

	if (buf != NULL) {
		if (rc = AjcVthGetDroppedDirW(hwnd, tmp)) {
			WideCharToMultiByte(CP_ACP, 0, tmp, -1, buf, MAX_PATH, NULL, NULL);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcVthGetDroppedDirW  (HWND hwnd, WC buf[MAX_PATH])
{
	BOOL		rc = FALSE;
	UI			bytes;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && buf != NULL) {
			if (AjcRngGetData(pW->hRngDir, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
				rc = (AjcRngGetData(pW->hRngDir, (VOP)buf, bytes) == bytes);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ドロップされたディレクトリ名取得（末尾の「￥」付加指定付き）												//
//																												//
//	引　数	：	pW				 - インスタンスワークアドレス													//
//				buf				 - ディレクトリ名を格納するバッファのアドレス									//
//				fTailIsDelimiter - TRUE  : ディレクトリパスの末尾に「\」を付ける								//
//								   FALSE : ディレクトリパスの末尾に「\」を付けない								//
//																												//
//	戻り値	：	TRUE:ディレクトリ名あり，FALSE:ディレクトリ名なし												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcVthGetDroppedDirExA	(HWND hwnd, BC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	BOOL	rc = FALSE;
	WC		tmp[MAX_PATH];

	if (rc = AjcVthGetDroppedDirExW(hwnd, tmp, fTailIsDelimiter)) {
		WideCharToMultiByte(CP_ACP, 0, tmp, -1, buf, MAX_PATH, NULL, NULL);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcVthGetDroppedDirExW	(HWND hwnd, WC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	BOOL		rc = FALSE;

	if (rc = AjcVthGetDroppedDirW(hwnd, buf)) {
		if (fTailIsDelimiter) AjcPathCat(buf, L"", MAX_PATH);
		else				  PathRemoveBackslashW(buf);
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルからプロパティ読み出し																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//				pDefProp	 - デフォルトプロパティ値（現在値をデフォルトとする場合はNULL)						//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthLoadPropA		(HWND hwnd, C_BCP pProfileSect, PCAJCVTHPROPA pDefProp)
{
	BOOL			rc = FALSE;
	UI				len;
	WCP				pTmp = NULL;

	if (pProfileSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			//	セクション名をワイド化
			MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmp, len);
			//	デフォルトプロパティをワイド文字化し、ワイド文字バージョンＡＰＩコール
			if (pDefProp != NULL) {
				AJCVTHPROPW	DefPropW;
				memcpy(&DefPropW, pDefProp, sizeof DefPropW);
				MultiByteToWideChar(CP_ACP, 0, pDefProp->LogFont.lfFaceName, -1, DefPropW.LogFont.lfFaceName, AJCTSIZE(DefPropW.LogFont.lfFaceName));
				rc = AjcVthLoadPropW(hwnd, pTmp, &DefPropW);
			}
			//	デフォルトプロパティなしで、ワイド文字バージョンＡＰＩコール
			else {
				rc = AjcVthLoadPropW(hwnd, pTmp, NULL);
			}
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthLoadPropW		(HWND hwnd, C_WCP pProfileSect, PCAJCVTHPROPW pDefProp)
{
	BOOL		rc = TRUE;
	AJCVTHPROP	prop;
	WC			DefFaceName[LF_FACESIZE];

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL) {
			if (pDefProp != NULL) memcpy(&prop, pDefProp, sizeof prop);
			else				  rc = AjcVthGetProp(hwnd, &prop);
			if (rc) {
				prop.VramW		  = AjcGetProfileUInt(pProfileSect, L"VramW"   , prop.VramW	  );
				prop.VramH		  = AjcGetProfileUInt(pProfileSect, L"VramH"   , prop.VramH	  );
			//	prop.CaretH		  = AjcGetProfileUInt(pProfileSect, L"CaretH"  , prop.CaretH  );
				prop.MaxLines	  = AjcGetProfileUInt(pProfileSect, L"MaxLines", prop.MaxLines);
				prop.TabStep	  = AjcGetProfileUInt(pProfileSect, L"TabStep" , prop.TabStep );
				prop.LSpace		  = AjcGetProfileUInt(pProfileSect, L"LSpace"  , prop.LSpace  );
				prop.PendSize	  = AjcGetProfileUInt(pProfileSect, L"PendSize", prop.PendSize);

				prop.LogFont.lfHeight		  = AjcGetProfileSInt(pProfileSect, L"lfHeight"		   , prop.LogFont.lfHeight		 );
				prop.LogFont.lfWidth		  = AjcGetProfileUInt(pProfileSect, L"lfWidth"		   , prop.LogFont.lfWidth		 );
				prop.LogFont.lfEscapement	  = AjcGetProfileUInt(pProfileSect, L"lfEscapement"	   , prop.LogFont.lfEscapement	 );
				prop.LogFont.lfOrientation	  = AjcGetProfileUInt(pProfileSect, L"lfOrientation"   , prop.LogFont.lfOrientation	 );
				prop.LogFont.lfWeight		  = AjcGetProfileUInt(pProfileSect, L"lfWeight"		   , prop.LogFont.lfWeight		 );
				prop.LogFont.lfItalic		  = AjcGetProfileUInt(pProfileSect, L"lfItalic"		   , prop.LogFont.lfItalic		 );
				prop.LogFont.lfUnderline	  = AjcGetProfileUInt(pProfileSect, L"lfUnderline"	   , prop.LogFont.lfUnderline	 );
				prop.LogFont.lfStrikeOut	  = AjcGetProfileUInt(pProfileSect, L"lfStrikeOut"	   , prop.LogFont.lfStrikeOut	 );
				prop.LogFont.lfCharSet		  = AjcGetProfileUInt(pProfileSect, L"lfCharSet"	   , prop.LogFont.lfCharSet		 );
				prop.LogFont.lfOutPrecision	  = AjcGetProfileUInt(pProfileSect, L"lfOutPrecision"  , prop.LogFont.lfOutPrecision );
				prop.LogFont.lfClipPrecision  = AjcGetProfileUInt(pProfileSect, L"lfClipPrecision" , prop.LogFont.lfClipPrecision);
				prop.LogFont.lfQuality		  = AjcGetProfileUInt(pProfileSect, L"lfQuality"		  , prop.LogFont.lfQuality	 );
				prop.LogFont.lfPitchAndFamily = AjcGetProfileUInt(pProfileSect, L"lfPitchAndFamily", prop.LogFont.lfPitchAndFamily);
				wcsncpy(DefFaceName, prop.LogFont.lfFaceName, LF_FACESIZE);
				DefFaceName[LF_FACESIZE - 1] = 0;
				AjcGetProfileStr(pProfileSect, L"lfFaceName", DefFaceName, prop.LogFont.lfFaceName, LF_FACESIZE);

				prop.rgb[0]		  = AjcGetProfileUInt(pProfileSect, L"rgb0"	 , prop.rgb[0]);
				prop.rgb[1]		  = AjcGetProfileUInt(pProfileSect, L"rgb1"	 , prop.rgb[1]);
				prop.rgb[2]		  = AjcGetProfileUInt(pProfileSect, L"rgb2"	 , prop.rgb[2]);
				prop.rgb[3]		  = AjcGetProfileUInt(pProfileSect, L"rgb3"	 , prop.rgb[3]);
				prop.rgb[4]		  = AjcGetProfileUInt(pProfileSect, L"rgb4"	 , prop.rgb[4]);
				prop.rgb[5]		  = AjcGetProfileUInt(pProfileSect, L"rgb5"	 , prop.rgb[5]);
				prop.rgb[6]		  = AjcGetProfileUInt(pProfileSect, L"rgb6"	 , prop.rgb[6]);
				prop.rgb[7]		  = AjcGetProfileUInt(pProfileSect, L"rgb7"	 , prop.rgb[7]);

				rc = AjcVthSetProp(hwnd, &prop);
			}

			//----- ログファイル出力先 -------------------------------------------------------------------------//
			if (pW->hWndLgf != NULL) {
				AjcLgfLoadProp(pW->hWndLgf, pProfileSect);
			}

			//----- テキストセーブ情報 -------------------------------------------------------------------------//
			pW->SvTxtFormat   = AjcGetProfileUInt(pProfileSect, L"SvTxtFormat"	, pW->SvTxtFormat  );
			pW->SvTxtEncode   = AjcGetProfileUInt(pProfileSect, L"SvTxtEncode"	, pW->SvTxtEncode  );
			pW->SvTxtOutput   = AjcGetProfileUInt(pProfileSect, L"SvTxtOutput"	, pW->SvTxtOutput  );
			pW->SvTxtFontSize = AjcGetProfileUInt(pProfileSect, L"SvTxtFontSize", pW->SvTxtFontSize);
			pW->SvBom		  = AjcGetProfileUInt(pProfileSect, L"SvBom" 		, pW->SvBom		  );
			AjcGetProfileStr(pProfileSect, L"SvTxtPath", pW->SvTxtPath, pW->SvTxtPath, AJCTSIZE(pW->SvTxtPath));
		}
		else rc = FALSE;
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	プロファイルへプロパティ書き込み																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthSavePropA		(HWND hwnd, C_BCP pProfileSect)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pProfileSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmp, len);
			rc = AjcVthSavePropW(hwnd, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthSavePropW		(HWND hwnd, C_WCP pProfileSect)
{
	BOOL		rc = FALSE;
	AJCVTHPROP	prop;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL) {
			if (rc = AjcVthGetProp(hwnd, &prop)) {
				AjcPutProfileUInt(pProfileSect, L"VramW"		   , prop.VramW	  );
				AjcPutProfileUInt(pProfileSect, L"VramH"		   , prop.VramH	  );
			//	AjcPutProfileUInt(pProfileSect, L"CaretH"		   , prop.CaretH  );
				AjcPutProfileUInt(pProfileSect, L"MaxLines"		   , prop.MaxLines);
				AjcPutProfileUInt(pProfileSect, L"TabStep"		   , prop.TabStep );
				AjcPutProfileUInt(pProfileSect, L"LSpace"		   , prop.LSpace  );
				AjcPutProfileUInt(pProfileSect, L"PendSize"		   , prop.PendSize);
	
				AjcPutProfileSInt(pProfileSect, L"lfHeight"		   , prop.LogFont.lfHeight		  );
				AjcPutProfileUInt(pProfileSect, L"lfWidth"		   , prop.LogFont.lfWidth		  );
				AjcPutProfileUInt(pProfileSect, L"lfEscapement"	   , prop.LogFont.lfEscapement	  );
				AjcPutProfileUInt(pProfileSect, L"lfOrientation"   , prop.LogFont.lfOrientation	  );
				AjcPutProfileUInt(pProfileSect, L"lfWeight"		   , prop.LogFont.lfWeight		  );
				AjcPutProfileUInt(pProfileSect, L"lfItalic"		   , prop.LogFont.lfItalic		  );
				AjcPutProfileUInt(pProfileSect, L"lfUnderline"	   , prop.LogFont.lfUnderline	  );
				AjcPutProfileUInt(pProfileSect, L"lfStrikeOut"	   , prop.LogFont.lfStrikeOut	  );
				AjcPutProfileUInt(pProfileSect, L"lfCharSet"	   , prop.LogFont.lfCharSet		  );
				AjcPutProfileUInt(pProfileSect, L"lfOutPrecision"  , prop.LogFont.lfOutPrecision  );
				AjcPutProfileUInt(pProfileSect, L"lfClipPrecision" , prop.LogFont.lfClipPrecision );
				AjcPutProfileUInt(pProfileSect, L"lfQuality"	   , prop.LogFont.lfQuality		  );
				AjcPutProfileUInt(pProfileSect, L"lfPitchAndFamily", prop.LogFont.lfPitchAndFamily);
				AjcPutProfileStr (pProfileSect, L"lfFaceName"	   , prop.LogFont.lfFaceName	  );
	
				AjcPutProfileUInt(pProfileSect, L"rgb0"			   , prop.rgb[0]);
				AjcPutProfileUInt(pProfileSect, L"rgb1"			   , prop.rgb[1]);
				AjcPutProfileUInt(pProfileSect, L"rgb2"			   , prop.rgb[2]);
				AjcPutProfileUInt(pProfileSect, L"rgb3"			   , prop.rgb[3]);
				AjcPutProfileUInt(pProfileSect, L"rgb4"			   , prop.rgb[4]);
				AjcPutProfileUInt(pProfileSect, L"rgb5"			   , prop.rgb[5]);
				AjcPutProfileUInt(pProfileSect, L"rgb6"			   , prop.rgb[6]);
				AjcPutProfileUInt(pProfileSect, L"rgb7"			   , prop.rgb[7]);
			}
	
			//----- ログファイル出力先 -------------------------------------------------------------------------//
			if (pW->hWndLgf != NULL) {
				AjcLgfSaveProp(pW->hWndLgf, pProfileSect);
			}
	
			//----- テキストセーブ情報 -------------------------------------------------------------------------//
			AjcPutProfileUInt(pProfileSect, L"SvTxtFormat"	, pW->SvTxtFormat  );
			AjcPutProfileUInt(pProfileSect, L"SvTxtEncode"	, pW->SvTxtEncode  );
			AjcPutProfileUInt(pProfileSect, L"SvTxtOutput"	, pW->SvTxtOutput  );
			AjcPutProfileUInt(pProfileSect, L"SvTxtFontSize", pW->SvTxtFontSize);
			AjcPutProfileUInt(pProfileSect, L"SvBom" 		, pW->SvBom		   );
			AjcPutProfileStr (pProfileSect, L"SvTxtPath"	, pW->SvTxtPath	   );
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルから永続情報読み出し（標準）																	//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//				pKeyPrefix	 - プロファイルキーの接頭語															//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthLoadPermInfoA		(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix)
{
	BOOL		rc = TRUE;

	rc = AjcVthLoadPermInfoExA(hwnd, pProfileSect, pKeyPrefix, AJCVTH_PERM_FONT);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthLoadPermInfoW		(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix)
{
	BOOL		rc = TRUE;

	rc = AjcVthLoadPermInfoExW(hwnd, pProfileSect, pKeyPrefix, AJCVTH_PERM_FONT);

	return rc;
}
//==============================================================================================================//
//	プロファイルから永続情報読み出し（項目指定）																//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//				pKeyPrefix	 - プロファイルキーの接頭語															//
//				PermItem	 - 永続化項目（AJCVTH_PERM_XXXXX）													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
#define			MKKEY(TAIL)		MkKey(pKeyPrefix, TAIL, szKey, AJCTSIZE(szKey))
static	C_WCP	MkKey(C_WCP pKeyPrefix, WCP pTail, WCP pKey, UI lKey)
{
	AjcSnPrintF(pKey, lKey, L"%s_%s", pKeyPrefix, pTail);
	return	pKey;
}
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthLoadPermInfoExA		(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmpSec = NULL;
	WCP		pTmpKey = NULL;

	do {
		if (pProfileSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
			if (len != 0 && (pTmpSec = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmpSec, len);
			}
			else break;
		}
		if (pKeyPrefix != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0);
			if (len != 0 && (pTmpKey = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pTmpKey, len);
			}
			else break;
		}
		rc = AjcVthLoadPermInfoExW(hwnd, pTmpSec, pTmpKey, PermItem);
	} while(0);

	if (pTmpSec != NULL) free(pTmpSec);
	if (pTmpKey != NULL) free(pTmpKey);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthLoadPermInfoExW		(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem)
{
	BOOL		rc = FALSE;
	BOOL		fNeedUpdateProp = FALSE;
	AJCVTHPROP	prop;
	WC			DefFaceName[LF_FACESIZE];
	WC			szKey[256];

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL && pKeyPrefix != NULL) {
			//----- デフォルトプロパティ値設定 -----------------------------------------------------------------//
			memcpy(&prop, &pW->prop, sizeof prop);
			//----- セクション名，永続化項目退避 ---------------------------------------------------------------//
			//	プロファイルセクション名，キー接頭語退避
			AjcVthSetPermAttW(hwnd, pProfileSect, pKeyPrefix);
			pProfileSect = pW->PermSect;
			pKeyPrefix	 = pW->PermKey;
			//	永続化項目退避
			pW->PermItem = PermItem;
			//----- 常時永続化項目 -----------------------------------------------------------------------------//
			//	他VT100への適用種別
			pW->fSetF_T = AjcGetProfileUInt(pProfileSect, MKKEY(L"fSetF_T"), pW->fSetF_T);
			//----- 改行動作 -------------------------------------------//
			if (pW->PermItem & AJCVTH_PERM_LFACT) {
				UI	sty, lfa;
				sty  = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
				lfa  = AjcGetProfileUInt(pProfileSect, MKKEY(L"Style"), sty);
				lfa &=	AJCVTHS_LFACT_MASK;
				sty &= ~AJCVTHS_LFACT_MASK;
				MAjcSetWindowLong(hwnd, GWL_STYLE, sty | lfa);
			}
			//----- フォント情報 ---------------------------------------//
			if (pW->PermItem & AJCVTH_PERM_FONT) {
				//	フォント情報
				prop.LogFont.lfHeight		  = AjcGetProfileSInt(pProfileSect, MKKEY(L"lfHeight"		 )	, prop.LogFont.lfHeight		 	);
				prop.LogFont.lfWidth		  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfWidth"		 )	, prop.LogFont.lfWidth		 	);
				prop.LogFont.lfEscapement	  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfEscapement"	 )	, prop.LogFont.lfEscapement	 	);
				prop.LogFont.lfOrientation	  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfOrientation"	 )	, prop.LogFont.lfOrientation	);
				prop.LogFont.lfWeight		  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfWeight"		 )	, prop.LogFont.lfWeight			);
				prop.LogFont.lfItalic		  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfItalic"		 )	, prop.LogFont.lfItalic			);
				prop.LogFont.lfUnderline	  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfUnderline"	 )	, prop.LogFont.lfUnderline		);
				prop.LogFont.lfStrikeOut	  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfStrikeOut"	 )	, prop.LogFont.lfStrikeOut		);
				prop.LogFont.lfCharSet		  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfCharSet"		 )	, prop.LogFont.lfCharSet		);
				prop.LogFont.lfOutPrecision	  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfOutPrecision"	 )	, prop.LogFont.lfOutPrecision	);
				prop.LogFont.lfClipPrecision  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfClipPrecision" )	, prop.LogFont.lfClipPrecision	);
				prop.LogFont.lfQuality		  = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfQuality"		 )	, prop.LogFont.lfQuality		);
				prop.LogFont.lfPitchAndFamily = AjcGetProfileUInt(pProfileSect, MKKEY(L"lfPitchAndFamily")	, prop.LogFont.lfPitchAndFamily	);
				wcsncpy(DefFaceName, prop.LogFont.lfFaceName, LF_FACESIZE);
				DefFaceName[LF_FACESIZE - 1] = 0;
				AjcGetProfileStr(pProfileSect, MKKEY(L"lfFaceName"), DefFaceName, prop.LogFont.lfFaceName, LF_FACESIZE);
				//	行間スペース
				prop.LSpace = AjcGetProfileUInt(pProfileSect, MKKEY(L"LSpace"), prop.LSpace);
				//	フォント選択ダイアログ情報
				pW->DwkPermInfo.hd.id		 = AjcGetProfileHex (pProfileSect, MKKEY(L"id"			 ), pW->DwkPermInfo.hd.id		);
				pW->DwkPermInfo.hd.fPixel	 = AjcGetProfileUInt(pProfileSect, MKKEY(L"fPixel"		 ), pW->DwkPermInfo.hd.fPixel	);
				pW->DwkPermInfo.hd.fItalic	 = AjcGetProfileUInt(pProfileSect, MKKEY(L"fItalic" 	 ), pW->DwkPermInfo.hd.fItalic	);
				pW->DwkPermInfo.hd.fBold	 = AjcGetProfileUInt(pProfileSect, MKKEY(L"fBold"		 ), pW->DwkPermInfo.hd.fBold	);
				pW->DwkPermInfo.hd.fFixed	 = AjcGetProfileUInt(pProfileSect, MKKEY(L"fFSelFixed"	 ), pW->DwkPermInfo.hd.fFixed	);
				pW->DwkPermInfo.hd.Pixels	 = AjcGetProfileUInt(pProfileSect, MKKEY(L"Pixels"		 ), pW->DwkPermInfo.hd.Pixels	);
				pW->DwkPermInfo.hd.Points	 = AjcGetProfileUInt(pProfileSect, MKKEY(L"Points"		 ), pW->DwkPermInfo.hd.Points	);
				pW->DwkPermInfo.hd.LSpace	 = AjcGetProfileUInt(pProfileSect, MKKEY(L"LSpace"		 ), pW->DwkPermInfo.hd.LSpace	);
				pW->DwkPermInfo.hd.FixAttr.v = AjcGetProfileUInt(pProfileSect, MKKEY(L"FSelFixedAttr"), pW->DwkPermInfo.hd.FixAttr.v);
				pW->DwkPermInfo.hd.AnyAttr.v = AjcGetProfileUInt(pProfileSect, MKKEY(L"FSelPropoAttr"), pW->DwkPermInfo.hd.AnyAttr.v);
				AjcGetProfileStr(pProfileSect, MKKEY(L"FSelFixedFace"), pW->DwkPermInfo.FixFace, pW->DwkPermInfo.FixFace, LF_FACESIZE);
				AjcGetProfileStr(pProfileSect, MKKEY(L"FSelPropoFace"), pW->DwkPermInfo.AnyFace, pW->DwkPermInfo.AnyFace, LF_FACESIZE);
				//	プロパティ更新の旨、フラグ設定
				fNeedUpdateProp = TRUE;
			}
			//----- ＶＲＡＭサイズ -------------------------------------//
			if (pW->PermItem & AJCVTH_PERM_VRAM) {
				prop.VramW = AjcGetProfileUInt(pProfileSect, MKKEY(L"VramW")	, prop.VramW	);
				prop.VramH = AjcGetProfileUInt(pProfileSect, MKKEY(L"VramH")	, prop.VramH	);
				//	プロパティ更新の旨、フラグ設定
				fNeedUpdateProp = TRUE;
			}
			//----- その他 ---------------------------------------------//
			if (pW->PermItem & AJCVTH_PERM_OTHER) {
			//	prop.CaretH		= AjcGetProfileUInt(pProfileSect, MKKEY(L"CaretH"	), prop.CaretH		);
				prop.MaxLines	= AjcGetProfileUInt(pProfileSect, MKKEY(L"MaxLines"	), prop.MaxLines	);
				prop.TabStep	= AjcGetProfileUInt(pProfileSect, MKKEY(L"TabStep"	), prop.TabStep		);
				prop.PendSize	= AjcGetProfileUInt(pProfileSect, MKKEY(L"PendSize"	), prop.PendSize	);
				//	プロパティ更新の旨、フラグ設定
				fNeedUpdateProp = TRUE;
			}
			//----- プロパティ更新 -----------------------------------------------------------------------------//
			rc = TRUE;
			if (fNeedUpdateProp) {
				rc = AjcVthSetProp(hwnd, &prop);
			}
		}
	}

	return rc;
}
//==============================================================================================================//
//	プロファイルへ永続情報書き込み																				//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcVthSavePermInfo		(HWND hwnd)
{
	return AjcVthSavePermInfoExW(hwnd, NULL, NULL, AJCVTH_PERM_BYLOAD);
}
//==============================================================================================================//
//	プロファイルへ永続情報書き込み																				//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect	- セクション名へのポインタ	（不要時はNULL)										//
//				pKeyPrefix		- キー名先頭部分へのポインタ（不要時はNULL)										//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthSavePermInfoExA		(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmpSec = NULL;
	WCP		pTmpKey = NULL;

	do {
		if (pProfileSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
			if (len != 0 && (pTmpSec = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmpSec, len);
			}
			else break;
		}
		if (pKeyPrefix != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0);
			if (len != 0 && (pTmpKey = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pTmpKey, len);
			}
			else break;
		}
		rc = AjcVthSavePermInfoExW(hwnd, pTmpSec, pTmpKey, PermItem);
	} while(0);

	if (pTmpSec != NULL) free(pTmpSec);
	if (pTmpKey != NULL) free(pTmpKey);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthSavePermInfoExW		(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem)
{
	BOOL		rc = FALSE;
	AJCVTHPROP	prop;
	WC			szKey[256];

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//----- セクション，キー，永続化項目 指定無しならば、ロード時に設定した名称とする ------------------//
			if (pProfileSect == NULL		 ) pProfileSect = pW->PermSect;
			if (pKeyPrefix	 == NULL		 ) pKeyPrefix	= pW->PermKey;
			if (PermItem & AJCVTH_PERM_BYLOAD) PermItem 	= pW->PermItem;
			//----- プロファイルセーブ -------------------------------------------------------------------------//
			if (*pProfileSect != 0) {
				//	現プロパティ値設定
				memcpy(&prop, &pW->prop, sizeof prop);
				//----- 常時永続化項目 ---------------------------------//
				//	他VT100への適用種別
				AjcPutProfileUInt(pProfileSect, MKKEY(L"fSetF_T"), pW->fSetF_T);
				//----- 改行動作 ---------------------------------------//
				if (PermItem & AJCVTH_PERM_LFACT) {
					AjcPutProfileHex(pProfileSect, MKKEY(L"Style"), (UI)MAjcGetWindowLong(hwnd, GWL_STYLE));
				}
				else {
					AjcDelProfileKey (pProfileSect, MKKEY(L"Style"));
				}
				//----- フォント情報 -----------------------------------//
				if (PermItem & AJCVTH_PERM_FONT) {
					//	フォント情報
					AjcPutProfileSInt(pProfileSect, MKKEY(L"lfHeight"		 	), prop.LogFont.lfHeight		);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfWidth"		 	), prop.LogFont.lfWidth			);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfEscapement"	 	), prop.LogFont.lfEscapement	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfOrientation"	 	), prop.LogFont.lfOrientation	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfWeight"		 	), prop.LogFont.lfWeight		);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfItalic"		 	), prop.LogFont.lfItalic		);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfUnderline"	 	), prop.LogFont.lfUnderline		);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfStrikeOut"		), prop.LogFont.lfStrikeOut		);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfCharSet"			), prop.LogFont.lfCharSet		);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfOutPrecision"		), prop.LogFont.lfOutPrecision	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfClipPrecision"	), prop.LogFont.lfClipPrecision	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfQuality"			), prop.LogFont.lfQuality		);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"lfPitchAndFamily"	), prop.LogFont.lfPitchAndFamily);
					AjcPutProfileStr (pProfileSect, MKKEY(L"lfFaceName"	  		), prop.LogFont.lfFaceName		);
					//	行間スペース
					AjcPutProfileUInt(pProfileSect, MKKEY(L"LSpace"				), prop.LSpace);
					//	フォント選択ダイアログ情報
					AjcPutProfileHex (pProfileSect, MKKEY(L"id" 		  		), pW->DwkPermInfo.hd.id		);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"fPixel" 	  		), pW->DwkPermInfo.hd.fPixel	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"fItalic"	  		), pW->DwkPermInfo.hd.fItalic  	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"fBold"		  		), pW->DwkPermInfo.hd.fBold	 	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"fFSelFixed"   		), pW->DwkPermInfo.hd.fFixed	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"Pixels" 	  		), pW->DwkPermInfo.hd.Pixels	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"Points" 	  		), pW->DwkPermInfo.hd.Points	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"LSpace" 	  		), pW->DwkPermInfo.hd.LSpace	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"FSelFixedAttr"		), pW->DwkPermInfo.hd.FixAttr.v );
					AjcPutProfileUInt(pProfileSect, MKKEY(L"FSelPropoAttr"		), pW->DwkPermInfo.hd.AnyAttr.v );
					AjcPutProfileStr (pProfileSect, MKKEY(L"FSelFixedFace"		), pW->DwkPermInfo.FixFace	 	);
					AjcPutProfileStr (pProfileSect, MKKEY(L"FSelPropoFace"		), pW->DwkPermInfo.AnyFace	 	);
				}
				else {
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfHeight"		 	));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfWidth"		 	));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfEscapement"	 	));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfOrientation"	 	));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfWeight"		 	));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfItalic"		 	));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfUnderline"	 	));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfStrikeOut"		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfCharSet"			));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfOutPrecision"		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfClipPrecision"	));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfQuality"			));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfPitchAndFamily"	));
					AjcDelProfileKey (pProfileSect, MKKEY(L"lfFaceName"	  		));

					AjcDelProfileKey (pProfileSect, MKKEY(L"LSpace"				));

					AjcDelProfileKey (pProfileSect, MKKEY(L"id" 		  		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"fPixel" 	  		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"fItalic"	  		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"fBold"		  		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"fFSelFixed"   		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"Pixels" 	  		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"Points" 	  		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"LSpace" 	  		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"FSelFixedAttr"		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"FSelPropoAttr"		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"FSelFixedFace"		));
					AjcDelProfileKey (pProfileSect, MKKEY(L"FSelPropoFace"		));
				}
				//----- ＶＲＡＭサイズ ---------------------------------//
				if (PermItem & AJCVTH_PERM_VRAM) {
					AjcPutProfileUInt(pProfileSect, MKKEY(L"VramW"), prop.VramW	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"VramH"), prop.VramH	);
				}
				else {
					AjcDelProfileKey (pProfileSect, MKKEY(L"VramW"));
					AjcDelProfileKey (pProfileSect, MKKEY(L"VramH"));
				}
				//----- その他 -----------------------------------------//
				if (PermItem & AJCVTH_PERM_OTHER) {
				//	AjcPutProfileUInt(pProfileSect, MKKEY(L"CaretH"	 ), prop.CaretH	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"MaxLines"), prop.MaxLines	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"TabStep" ), prop.TabStep	);
					AjcPutProfileUInt(pProfileSect, MKKEY(L"PendSize"), prop.PendSize	);
				}
				else {
					AjcDelProfileKey (pProfileSect, MKKEY(L"MaxLines"));
					AjcDelProfileKey (pProfileSect, MKKEY(L"TabStep" ));
					AjcDelProfileKey (pProfileSect, MKKEY(L"PendSize"));
				}
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	永続化の属性（セクション名，キー接頭語）設定																//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthSetPermAttA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix)
{
	return AjcVthSetPermAttExA(hwnd, pProfileSect, pKeyPrefix, AJCVTH_PERM_FONT);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthSetPermAttW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix)
{
	return AjcVthSetPermAttExW(hwnd, pProfileSect, pKeyPrefix, AJCVTH_PERM_FONT);
}

//==============================================================================================================//
//	永続化の属性（セクション名，キー接頭語）設定	（項目指定）												//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	TRUE:OK，FALSE:エラー																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthSetPermAttExA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmpSec = NULL;
	WCP		pTmpKey = NULL;

	do {
		if (pProfileSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
			if (len != 0 && (pTmpSec = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmpSec, len);
			}
			else break;
		}
		if (pKeyPrefix != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0);
			if (len != 0 && (pTmpKey = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pTmpKey, len);
			}
			else break;
		}
		rc = AjcVthSetPermAttExW(hwnd, pTmpSec, pTmpKey, PermItem);
	} while(0);

	if (pTmpSec != NULL) free(pTmpSec);
	if (pTmpKey != NULL) free(pTmpKey);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcVthSetPermAttExW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem)
{
	BOOL		rc = FALSE;
	WC			szid[16];

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL && pKeyPrefix != NULL) {
			//----- ＩＤ文字列設定 -----------------------------------------------------------------------------//
			AjcSnPrintFW(szid, AJCTSIZE(szid), L"%06u", (UW)MAjcGetWindowLong(hwnd, GWL_ID));
			//----- セクション名設定 ---------------------------------------------------------------------------//
			if (pProfileSect != NULL) AjcSnPrintFW(pW->PermSect, AJCTSIZE(pW->PermSect) 	, L"%s" 	, pProfileSect);
			else					  AjcSnPrintFW(pW->PermSect, AJCTSIZE(pW->PermSect) 	, L"SVth%s" , szid		  );
			//----- キー接頭語設定 -----------------------------------------------------------------------------//
			if (pKeyPrefix	 != NULL) AjcSnPrintFW(pW->PermKey , AJCTSIZE(pW->PermKey ) - 32, L"%s" 	, pKeyPrefix);	// 32:後続キー名称の最大値
			else					  AjcSnPrintFW(pW->PermKey , AJCTSIZE(pW->PermKey ) - 32, L"Vth_%s_", szid		);
			//---- 永続化項目設定 ------------------------------------------------------------------------------//
			pW->PermItem = PermItem;
			//----- 戻り値＝ＯＫ -------------------------------------------------------------------------------//
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	右クリックによるポップアップメニュー有効項目の設定															//
//																												//
//	引　数	：	hwnd		  - ウインドハンドル																//
//				sel			  - 有効とする項目（AJCVTHMM_XXXXX）												//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthSelMenuItems(HWND hwnd, UI sel)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//	全て無効ならば、右クリック禁止
			if ((AJCVTHMM_ALL & sel) == 0) {
				AjcTchEnablePopupMenu(hwnd, FALSE);
			}
			//	有効とする項目設定
			else {
				pW->PopupMask = (AJCVTHMM_ALL & sel);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	右クリックによるポップアップメニュー除外項目の設定															//
//																												//
//	引　数	：	hwnd		  - ウインドハンドル																//
//				exc			  - 除外する項目（AJCVTHMM_XXXXX）													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthExcMenuItems(HWND hwnd, UI exc)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//	全て除外ならば、右クリック禁止
			if ((exc & AJCVTHMM_ALL) == AJCVTHMM_ALL) {
				AjcTchEnablePopupMenu(hwnd, FALSE);
			}
			//	一部除外ならば、除外項目設定
			else {
				pW->PopupMask = (AJCVTHMM_ALL & ~exc);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	右クリックによるポップアップメニューの許可／禁止															//
//																												//
//	引　数	：	hwnd		  - ウインドハンドル																//
//				fEnable		  - ポップアップメニューの許可／禁止												//
//									TRUE  : 許可（右クリック非通知，Shuft/Ctrl+右クリック通知）					//
//									FALSE : 禁止（全ての右クリック通知）										//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthEnablePopupMenu(HWND hwnd, BOOL fEnable)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			AjcVthSetNtcRClk(hwnd, !fEnable, WM_RBUTTONDOWN, WM_RBUTTONUP);
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	右クリック通知設定																							//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				fNtcRClk	 - TRUE  : 右ボタンDOWN/UP通知	（ポップアップは禁止）								//
//							   FALSE : 右ボタンDOWN/UP非通知（ポップアップを許可）								//
//				MsgRBDown	 - 右ボタン押下時の通知メッセージコード　（０の場合は非通知）						//
//				MSgRBUp		 - 右ボタン離され時の通知メッセージコード（０の場合は非通知）						//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//																												//
//	備　考	：						<ポップアップ>	<Shift/Ctrl+右>		<右-DOWN>	<右-UP>						//
//				NtcRClk	= FALSE	 	 許可		 	 通知				 非通知		 非通知						//
//				 		= TRUE		 禁止			 非通知				 MsgRBDown	 MsgRBUp					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthSetNtcRClk	(HWND hwnd, BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pW->fNtcRClk  = fNtcRClk;
			pW->MsgRBDown = MsgRBDown;
			pW->MsgRBUp	  = MsgRBUp;
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	全テキスト取得																								//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pBuf   - テキストを格納するバッファのアドレス													//
//				lBuf   - テキストを格納するバッファの文字数														//
//																												//
//	戻り値	：	pBuf != NULL && lBuf != 0 - バッファに格納した文字数											//
//				pBuf == NULL || lBuf == 0 - 必要なバッファサイズ（文字列終端を含む文字数）						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	WINAPI AjcVthGetTextA	(HWND hwnd, BCP pBuf, UI lBuf)
{
	UI			len = 0;
	UI			i, ixL, lwc;
	PLINEPTR	pL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pBuf != NULL && lBuf > 0) {
				len = 0;
				ixL = pW->IxSrt;
				for (i = 0; i < pW->LCnt; i++) {
					pL	= pW->pLPtr + ixL;
					lwc = WideCharToMultiByte(CP_ACP, 0, pL->pTxt, pL->len, NULL, 0, NULL, NULL);
					if (lBuf >= (lwc + 3)) {
						WideCharToMultiByte(CP_ACP, 0, pL->pTxt, pL->len, pBuf, lBuf, NULL, NULL);
						pBuf += lwc;  lBuf -= lwc;
						if (!(lwc == 0 && i == pW->LCnt - 1)) {
							memcpy(pBuf, L"\r\n" , 4);
							pBuf += 2;	  lBuf -= 2;
						}
					}
					else {
						break;
					}
					len += (lwc + 2);
					ixL = ((ixL + 1) % pW->prop.MaxLines);
				}
				*pBuf = 0;
			}
			else {
				len = 0;
				ixL = pW->IxSrt;
				for (i = 0; i < pW->LCnt; i++) {
					pL = pW->pLPtr + ixL;
					lwc = WideCharToMultiByte(CP_ACP, 0, pL->pTxt, pL->len, NULL, 0, NULL, NULL);
					len += (lwc + 2);
					ixL = ((ixL + 1) % pW->prop.MaxLines);
				}
				len++;
			}
		}
	}
	return len;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	WINAPI AjcVthGetTextW	(HWND hwnd, WCP pBuf, UI lBuf)
{
	UI			len = 0;
	UI			i, ixL, stl;
	PLINEPTR	pL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pBuf != NULL && lBuf > 0) {
				len = 0;
				ixL = pW->IxSrt;
				for (i = 0; i < pW->LCnt; i++) {
					pL	= pW->pLPtr + ixL;
					stl = pL->len;
					if (lBuf >= (stl + 3)) {
						memcpy(pBuf, pL->pTxt, stl * 2); pBuf += stl;  lBuf -= stl;
						if (!(stl == 0 && i == pW->LCnt - 1)) {
							memcpy(pBuf, L"\r\n", 4);	 pBuf += 2;    lBuf -= 2;
						}
					}
					else {
						break;
					}
					len += (stl + 2);
					ixL = ((ixL + 1) % pW->prop.MaxLines);
				}
				*pBuf = 0;
			}
			else {
				len = 0;
				ixL = pW->IxSrt;
				for (i = 0; i < pW->LCnt; i++) {
					pL = pW->pLPtr + ixL;
					len += (pL->len + 2);
					ixL = ((ixL + 1) % pW->prop.MaxLines);
				}
				len++;
			}
		}
	}
	return len;
}
//==============================================================================================================//
//	選択テキスト取得（V1.1.0以降）																				//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pBuf   - 選択テキストを格納するバッファのアドレス												//
//				lBuf   - 選択テキストを格納するバッファの文字数													//
//																												//
//	戻り値	：	pBuf != NULL && lBuf != 0 - バッファに格納した文字数											//
//				pBuf == NULL || lBuf == 0 - 必要なバッファサイズ（文字数）										//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	WINAPI AjcVthGetSelectedTextA	(HWND hwnd, BCP pBuf, UI lBuf)
{
	UI			rc = 0;
	HGLOBAL		hGlobal;
	WCP			pBlk;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (hGlobal = GetSelectedText(pW)) {
				GlobalUnlock(hGlobal);
				pBlk = GlobalLock(hGlobal);
				if (pBuf != NULL  &&  lBuf != 0) {
					WideCharToMultiByte(CP_ACP, 0, pBlk, -1, pBuf, lBuf, NULL, NULL);
					pBuf[lBuf - 1] = 0;
					rc = (UI)strlen(pBuf);
				}
				else {
					rc = WideCharToMultiByte(CP_ACP, 0, pBlk, -1, NULL, 0, NULL, NULL);
				}
				GlobalUnlock(hGlobal);
				GlobalFree	(hGlobal);
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	WINAPI AjcVthGetSelectedTextW	(HWND hwnd, WCP pBuf, UI lBuf)
{
	UI			rc = 0;
	HGLOBAL		hGlobal;
	WCP			pBlk;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (hGlobal = GetSelectedText(pW)) {
				GlobalUnlock(hGlobal);
				pBlk = (WCP)GlobalLock(hGlobal);
				if (pBuf != NULL  &&  lBuf != 0) {
					wcsncpy(pBuf, pBlk, lBuf);
					pBuf[lBuf - 1] = 0;
					rc = (UI)wcslen(pBuf);
				}
				else {
					rc = (UI)wcslen(pBlk) + 1;
				}
				GlobalUnlock(hGlobal);
				GlobalFree	(hGlobal);
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	ダブルクリックした行のテキスト取得（V1.1.0以降）															//
//																												//
//	引　数	：	hwnd   - コントロールのハンドル																	//
//				pBuf   - 行テキストを格納するバッファのアドレス													//
//				lBuf   - 行テキストを格納するバッファの文字数													//
//				pLine  - ダブルクリックしたバッファ上の行位置													//
//				pCol   - ダブルクリックした桁位置																//
//																												//
//	戻り値	：	pBuf != NULL && lBuf != 0 - バッファに格納した文字数											//
//				pBuf == NULL || lBuf == 0 - 必要なバッファサイズ（文字数）										//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	WINAPI AjcVthGetDblClickedLineA	  (HWND hwnd, BCP pBuf, UI lBuf)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pW->pDblClkLine != NULL) {
				if (pBuf != NULL  &&  lBuf != 0) {
					WideCharToMultiByte(CP_ACP, 0, pW->pDblClkLine, -1, pBuf, lBuf, NULL, NULL);
					pBuf[lBuf - 1] = 0;
					rc = (UI)strlen(pBuf);
				}
				else {
					rc = WideCharToMultiByte(CP_ACP, 0, pW->pDblClkLine, -1, NULL, 0, NULL, NULL);
				}
			}
			else if (lBuf != 0) *pBuf = 0;
		}
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT UI	WINAPI AjcVthGetDblClickedLineExA  (HWND hwnd, BCP pBuf, UI lBuf, UIP pLine, UIP pCol)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

		rc = AjcVthGetDblClickedLineA(hwnd, pBuf, lBuf);

		if (pLine != NULL) *pLine = pW->DblClkLPos;
		if (pCol  != NULL) *pCol  = pW->DblClkTIdxA;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	WINAPI AjcVthGetDblClickedLineW	  (HWND hwnd, WCP pBuf, UI lBuf)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pW->pDblClkLine != NULL) {
				if (pBuf != NULL  &&  lBuf != 0) {
					wcsncpy(pBuf, pW->pDblClkLine, lBuf);
					pBuf[lBuf - 1] = 0;
					rc = (UI)wcslen(pBuf);
				}
				else {
					rc = (UI)wcslen(pW->pDblClkLine) + 1;
				}
			}
			else if (lBuf != 0) *pBuf = 0;
		}
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT UI	WINAPI AjcVthGetDblClickedLineExW  (HWND hwnd, WCP pBuf, UI lBuf, UIP pLine, UIP pCol)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

		rc = AjcVthGetDblClickedLineW(hwnd, pBuf, lBuf);

		if (pLine != NULL) *pLine = pW->DblClkLPos;
		if (pCol  != NULL) *pCol  = pW->DblClkTIdxW;
	}
	return rc;
}

//==============================================================================================================//
//	ツールチップ・テキスト設定																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pTxt		 - ツールチップ・テキスト文字列のアドレス											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcVthSetTipTextA (HWND hwnd, C_BCP pTxt)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (rc = SubSetTipTextA(&pW->pToolTipTxt, 0, pTxt)) {
				AjcTipTextAddW		   (pW->hBack, pW->pToolTipTxt);
				AjcTipTextSetShowAlways(pW->hBack, pW->fShowAlways);
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcVthSetTipTextW (HWND hwnd, C_WCP pTxt)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (rc = SubSetTipTextW(&pW->pToolTipTxt, 0, pTxt)) {
				AjcTipTextAddW		   (pW->hBack, pW->pToolTipTxt);
				AjcTipTextSetShowAlways(pW->hBack, pW->fShowAlways);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト取得																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pBuf		 - ツールチップ・テキスト文字列を格納するバッファのアドレス							//
//				lBuf		 - ツールチップ・テキスト文字列を格納するバッファの文字数							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcVthGetTipTextA (HWND hwnd, BCP pBuf, UI lBuf)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = SubGetTipTextA(&pW->pToolTipTxt, 0, pBuf, lBuf);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcVthGetTipTextW (HWND hwnd, WCP pBuf, UI lBuf)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = SubGetTipTextW(&pW->pToolTipTxt, 0, pBuf, lBuf);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト表示条件設定																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				fShowAlways	 - ツールチップ・テキスト表示条件													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthSetTipShowAlways(HWND hwnd, BOOL fShowAlways)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pW->fShowAlways = fShowAlways;
			AjcTipTextSetShowAlways(hwnd, pW->fShowAlways);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト表示条件取得																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	ツールチップ・テキスト表示条件																	//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthGetTipShowAlways(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->fShowAlways;
		}
	}
	return rc;
}

//==============================================================================================================//
//	フォント，行間スペースの設定																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pLogFont	- 設定するフォント情報へのポインタ（NULL：フォントを設定しない）					//
//				LSpace		- 設定する行間スペース（-1 : 行間スペースを設定しない）								//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSetFontInfoA(HWND hwnd, const LOGFONTA *pLogFont, UI LSpace)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pLogFont != NULL || LSpace != -1) {
				AJCVTHPROPA	prop;
				AjcVthGetPropA(hwnd, &prop);
				if (pLogFont != NULL) {
					memcpy(&prop.LogFont, pLogFont, sizeof prop.LogFont);
				}
				if (LSpace != -1) {
					prop.LSpace = LSpace;
				}
				AjcVthSetPropA(hwnd, &prop);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSetFontInfoW(HWND hwnd, const LOGFONTW *pLogFont, UI LSpace)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pLogFont != NULL || LSpace != -1) {
				AJCVTHPROPW	prop;
				AjcVthGetPropW(hwnd, &prop);
				if (pLogFont != NULL) {
					memcpy(&prop.LogFont, pLogFont, sizeof prop.LogFont);
				}
				if (LSpace != -1) {
					prop.LSpace = LSpace;
				}
				AjcVthSetPropW(hwnd, &prop);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	行間スペースの取得																							//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	ツールチップ・テキスト表示条件																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthGetFontInfoA(HWND hwnd, LPLOGFONTA *pBuf, UIP pLSpace)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pBuf != NULL || pLSpace != NULL) {
				AJCVTHPROPA	prop;
				AjcVthGetPropA(hwnd, &prop);
				if (pBuf != NULL) {
					memcpy(pBuf, &prop.LogFont, sizeof(LOGFONTA));
				}
				if (pLSpace != NULL) {
					*pLSpace = prop.LSpace;
				}
			}
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthGetFontInfoW(HWND hwnd, LPLOGFONTW *pBuf, UIP pLSpace)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pBuf != NULL || pLSpace != NULL) {
				AJCVTHPROPW	prop;
				AjcVthGetPropW(hwnd, &prop);
				if (pBuf != NULL) {
					memcpy(pBuf, &prop.LogFont, sizeof(LOGFONTW));
				}
				if (pLSpace != NULL) {
					*pLSpace = prop.LSpace;
				}
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	文字サイズ／行の高さ取得																					//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pCx			- 文字の幅　（ピクセル数）を格納するバッファのアドレス（不要時はNULL)				//
//				pCy			- 文字の高さ（ピクセル数）を格納するバッファのアドレス（不要時はNULL)				//
//				pLy			- 行の高さ　（ピクセル数）を格納するバッファのアドレス（不要時はNULL)				//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthGetCharInfo(HWND hwnd, UIP pCx, UIP pCy, UIP pLy)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pCx != NULL) *pCx = pW->cxChar;
			if (pCy != NULL) *pCy = pW->cyCharOrg;
			if (pLy != NULL) *pLy = pW->cyChar;
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ウインドに表示可能な行数の取得																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//																												//
//	戻り値	：	ウインドに表示可能な行数																		//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcVthGetLinesPerWindow(HWND hwnd)
{
	UI			rc = 0;
	RECT		r;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			GetClientRect(pW->hMain, &r);
			rc = ((r.bottom - r.top)) / pW->cyChar;
		}
	}
	return rc;
}
//==============================================================================================================//
//	バッファに格納されている有効な行数の取得	（AjcVthGetLineCount() と同じ）									//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//																												//
//	戻り値	：	ウインド先頭行の位置取得（０～）																//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcVthGetValidLines(HWND hwnd)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->LCnt;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ウインド先頭行の行位置取得（０～）																			//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//																												//
//	戻り値	：	ウインド先頭行の位置（０～）																	//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcVthGetIxOfWndTopLine(HWND hwnd)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pW->IxSrt <= pW->IxWTop) {
				rc = pW->IxWTop - pW->IxSrt;
			}
			else {
				rc = (pW->prop.MaxLines - pW->IxSrt) + pW->IxWTop;
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	タイトル文字列の設定																						//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pTitleText	- タイトルテキストへのポインタ（NULL指定時は、タイトル非表示）						//
//				TextColor	- テキスト描画色（－１指定時は前回設定値，デフォルト色＝白）						//
//				BackColor	- テキスト背景色（－１指定時は前回設定値，デフォルト色＝グレー）					//
//				hFont		- タイトルテキストのフォント（NULL指定時は前回設定値／デフォルトのフォント）		//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSetTitleTextA(HWND hwnd, C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	BOOL		rc	 = FALSE;
	WCP			pTmp = NULL;
	UL			len;

	do {
		if (pTitleText != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pTitleText, -1, NULL, 0);
			if (len != 0  &&  (pTmp = AjcTAlloc(len + 1))) {
				MultiByteToWideChar(CP_ACP, 0, pTitleText, -1, pTmp, len);
			}
			else break;
		}
		rc = AjcVthSetTitleTextW(hwnd, pTmp, TextColor, BackColor, hFont);
		if (pTmp != NULL) free(pTmp);
	} while(0);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSetTitleTextW(HWND hwnd, C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	BOOL	rc	 = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			do {
			//	タイトルテキスト・ビットマップ生成
			SubTtlBmpMake(&pW->TtlInfo, pW->hBack, pTitleText, TextColor, BackColor, hFont);
				//	戻り値＝正常
				rc = TRUE;
				//	再描画
				InvalidateRect(hwnd 	, NULL, TRUE);
			} while(0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキストをファイルへ書き込み																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pPath		- ファイルパス																		//
//				fAllText	- TRUE:全テキスト，FALSE:選択テキスト												//
//				tec			- 文字コード種別（AJCTEC_MBC / UTF_8 / EUC_J / UTF_16LE / UTF_16BE）				//
//				fBom		- ＢＯＭ出力フラグ																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー／ファイル書き込み失敗															//
//==============================================================================================================//
static	const BC	bom_utf8   [3] = {0xEF, 0xBB, 0xBF};

//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSaveTextToFileA(HWND hwnd, C_BCP pPath, BOOL fAllText, EAJCTEC tec, BOOL fBom)
{
	BOOL	rc = FALSE;
	int		len;
	WCP		pTmp;

	if (pPath != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pPath, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pPath, -1, pTmp, len);
			rc = AjcVthSaveTextToFileW(hwnd, pTmp, fAllText, tec, fBom);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSaveTextToFileW(HWND hwnd, C_WCP pPath, BOOL fAllText, EAJCTEC tec, BOOL fBom)
{
	BOOL		rc	  = FALSE;
	HAJCFILE	hFile = NULL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pPath != NULL) {
			if ((hFile = AjcFCreate(pPath, tec, fBom)) != NULL) {
				SaveToTextFile(pW, hFile, fAllText);
				AjcFClose(hFile);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキストをＨＴＭＬファイルへ書き込み																		//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pPath		- ファイルパス																		//
//				fAllText	- TRUE:全テキスト，FALSE:選択テキスト												//
//				FontSize	- フォントサイズ（１～７）															//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー／ファイル書き込み失敗															//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSaveHtmlToFileA(HWND hwnd, C_BCP pPath, BOOL fAllText, UI FontSize)
{
	BOOL	rc = FALSE;
	int		len;
	WCP		pTmp;

	if (pPath != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pPath, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pPath, -1, pTmp, len);
			rc = AjcVthSaveHtmlToFileW(hwnd, pTmp, fAllText, FontSize);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSaveHtmlToFileW(HWND hwnd, C_WCP pPath, BOOL fAllText, UI FontSize)
{
	BOOL		rc	  = FALSE;
	HAJCFILE	hFile = NULL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pPath != NULL) {
			if ((hFile = AjcFCreate(pPath, AJCTEC_UTF_8, TRUE)) != NULL) {
				SaveToHtmlFile(pW, hFile, fAllText, FontSize);
				AjcFClose(hFile);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ＥＳＣシーケンスを付加し、全テキストをファイルへ書き込み													//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pPath		- ファイルパス																		//
//				tec			- 文字コード種別（AJCTEC_MBC / UTF_8 / EUC_J / UTF_16LE / UTF_16BE）				//
//				fBom		- ＢＯＭ出力フラグ																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー／ファイル書き込み失敗															//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSaveAllTextWithEscA(HWND hwnd, C_BCP pPath, EAJCTEC tec, BOOL fBom)
{
	BOOL	rc = FALSE;
	int		len;
	WCP		pTmp;

	if (pPath != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pPath, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pPath, -1, pTmp, len);
			rc = AjcVthSaveAllTextWithEscW(hwnd, pTmp, tec, fBom);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcVthSaveAllTextWithEscW(HWND hwnd, C_WCP pPath, EAJCTEC tec, BOOL fBom)
{
	BOOL		rc	  = FALSE;
	HAJCFILE	hFile = NULL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pPath != NULL) {
			if ((hFile = AjcFCreate(pPath, tec, fBom)) != NULL) {
				SaveAllTextToFileWithEsc(pW, hFile);
				AjcFClose(hFile);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	バッファに格納されている行数の取得 		（AjcVthGetValidLines() と同じ）									//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//																												//
//	戻り値	：バッファに格納されている行数（エラー時は０を返します）											//
//==============================================================================================================//
AJCEXPORT	UI	WINAPI AjcVthGetLineCount(HWND hwnd)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->LCnt;
		}
	}
	return rc;
}
//==============================================================================================================//
//	マウスカーソル位置の行，桁位置取得																			//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pLine		- 行位置 （０～）を格納するバッファのアドレス（不要時はNULL）						//
//				pCol		- 桁位置（０～）を格納するバッファのアドレス（不要時はNULL）						//
//																												//
//	戻り値	：TRUE	- 正常																						//
//			  FALSE - カーソルはウインド範囲外																	//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI AjcVthGetCursorPosInfo(HWND hwnd, UIP pLine, UIP pCol)
{
	BOOL	rc = FALSE;
	POINT	pt;
	int		x, y;
	int		lp, cp, tix;
	WCP		pTxt = NULL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			GetCursorPos(&pt);
			MapWindowPoints(HWND_DESKTOP, hwnd, &pt, 1);
			x = pt.x;
			y = pt.y;
			if (x >= 0 && x < (int)pW->ww && y >= 0 && y < (int)pW->wh) {
				if (pTxt = VthMusToTextIdx(pW, x, y, &lp, &tix, &cp)) {
					if (lp == 0 || lp < (int)pW->LCnt) {
						if (pLine != NULL) *pLine = lp;
						if (pCol  != NULL) *pCol  = cp;
						rc = TRUE;
					}
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	指定行位置の行テキスト取得 																					//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pos			- 行位置（０～）																	//
//				pBuf		- 取得した行テキストを格納するバッファのアドレス（不要時はNULL）					//
//				lBif		- 取得した行テキストを格納するバッファの文字数										//
//																												//
//	戻り値	：	≠０：指定行位置のテキストの文字数（文字列の終端(0x00)を含む）									//
//				＝０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI AjcVthGetLineTextA(HWND hwnd, UI pos, BCP pBuf, UI lBuf)
{
	UI			rc = 0;
	UI			ix, len;
	PLINEPTR	pL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pos < pW->LCnt) {
				ix = VthLnoToIx(pW, pos);
				pL = pW->pLPtr + ix;
				if (pBuf != NULL && lBuf > 0) {
					len = __min(pL->len, lBuf - 1);
					VthMemSetA(pBuf, 0, lBuf);
					rc = WideCharToMultiByte(CP_ACP, 0, pL->pTxt, len, pBuf, lBuf - 1, NULL, NULL);
				}
				else {
					rc = WideCharToMultiByte(CP_ACP, 0, pL->pTxt, pL->len, NULL, 0, NULL, NULL) + 1;
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI AjcVthGetLineTextW(HWND hwnd, UI pos, WCP pBuf, UI lBuf)
{
	UI			rc = 0;
	UI			ix, len;
	PLINEPTR	pL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pos < pW->LCnt) {
				ix = VthLnoToIx(pW, pos);
				pL = pW->pLPtr + ix;
				if (pBuf != NULL && lBuf > 0) {
					len = __min(pL->len, lBuf - 1);
					wcsncpy(pBuf, pL->pTxt, len);
					pBuf[len] = 0;
					rc = len;
				}
				else {
					rc = pL->len + 1;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	縦スクロール位置の取得 																						//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//																												//
//	戻り値	：縦スクロール位置（０～）																			//
//==============================================================================================================//
AJCEXPORT	UI	WINAPI AjcVthGetVScrollPos(HWND hwnd)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = VthIxToLno(pW, pW->IxWTop);
		}
	}
	return rc;
}
//==============================================================================================================//
//	横スクロール位置の取得 																						//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//																												//
//	戻り値	：横スクロール位置（０～）																			//
//==============================================================================================================//
AJCEXPORT	UI	WINAPI AjcVthGetHScrollPos(HWND hwnd)
{
	UI			rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->IxOfs;
		}
	}
	return rc;
}
//==============================================================================================================//
//	縦スクロール位置の設定 																						//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pos			- スクロール位置（０～）															//
//																												//
//	戻り値	：TRUE	- OK																						//
//			  FALSE - Error																						//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI AjcVthSetVScrollPos(HWND hwnd, UI pos)
{
	BOOL		rc = FALSE;
	UI			wl;		//	ウインド行数
	UI			ov;		//	オーバー行数

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pos < pW->LCnt) {
				wl = pW->wh / pW->cyChar;
				if (pos + wl >= pW->LCnt) {
					ov = ((pos + wl) - pW->LCnt);
					if (ov < pos) pos -= ov;
					else		  pos  = 0;
				}
				VthSetVScrollInfo(pW, pos);
				InvalidateRect(pW->hMain, NULL, FALSE);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	横スクロール位置の設定 																						//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pos			- スクロール位置（０～）															//
//																												//
//	戻り値	：TRUE	- OK																						//
//			  FALSE - Error																						//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI AjcVthSetHScrollPos(HWND hwnd, UI pos)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			VthSetHScrollInfo(pW, pos);
			InvalidateRect(pW->hMain, NULL, FALSE);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ウインドサイズ（行数，文字数）の取得																		//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pSize		- ウインドサイズを格納するバッファのアドレス										//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthGetWindowSize(HWND hwnd, LPSIZE pSize)
{
	BOOL		rc = FALSE;
	RECT		r;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			GetClientRect(pW->hMain, &r);
			if (pSize != NULL) {
				pSize->cx = ((r.right - r.left)) / pW->cxChar;
				pSize->cy = ((r.bottom - r.top)) / pW->cyChar;
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	文字列の検索情報の永続化																					//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pSect		- プロファイルセクション名															//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : - エラー																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSetFindProfileSectA(HWND hwnd, C_BCP pSect)
{
	BOOL	rc = FALSE;
	WC		sect[64];

	if (IsWindow(hwnd) && pSect != NULL) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			AjcByteCharToWideChar(pSect, sect, AJCTSIZE(sect));
			AjcVthSetFindProfileSectW(hwnd, sect);
			rc = TRUE;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSetFindProfileSectW(HWND hwnd, C_WCP pSect)
{
	BOOL	rc = FALSE;
	if (IsWindow(hwnd) && pSect != NULL) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//	プロファイルセクション名設定
			MAjcStrCpy(pW->FindSect, AJCTSIZE(pW->FindSect), pSect);
			//	プロファイル読み出し
			if (pW->FindSect[0] != 0) {
				pW->fExactWidth = AjcGetProfileUInt(pW->FindSect, L"fExactWidth", pW->fExactWidth);
				pW->fSemicolon	= AjcGetProfileUInt(pW->FindSect, L"fSemicolon" , pW->fSemicolon);
				pW->fAstarisk	= AjcGetProfileUInt(pW->FindSect, L"fAstarisk " , pW->fAstarisk );
				pW->fTrim		= AjcGetProfileUInt(pW->FindSect, L"fTrim     " , pW->fTrim 	);
				pW->fClose		= AjcGetProfileUInt(pW->FindSect, L"fClose    " , pW->fClose	);
				AjcGetProfileStr(pW->FindSect, L"SrhStr", L"", pW->SrhStr, AJCTSIZE(pW->SrhStr));
				rc = TRUE;
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	文字列の検索キー設定																						//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				key			- 検索キーコード(０：キーによる検索禁止，Default:VK_F3)								//
//																												//
//	戻り値	：	≠ -1 : 前回設定値																				//
//				＝ -1 : - エラー																				//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcVthSetFindKey(HWND hwnd, UI key)
{
	UI	rc = -1;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->FindKey;
			pW->FindKey = key;
		}
	}
	return TRUE;
}
//==============================================================================================================//
//	文字列の下方向検索とスクロール																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pStr		- 検索文字列																		//
//				delimiter	- 区切り文字（０の場合は区切り文字無し）											//
//																												//
//	戻り値	：	≠ -1 : 行スクロール位置																		//
//				＝ -1 : - エラー																				//
//==============================================================================================================//
//----- バイト文字（文字列の下方向検索とスクロール） -----------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSearchBelowA(HWND hwnd, C_BCP pStr, BC delimiter)
{
	UI		rc			 = -1;
	C_BCP	pDlm		 = NULL;
	C_BCP	pAny		 = NULL;
	BOOL	fTrim		 = FALSE;
	BOOL	fIgnoreWidth = FALSE;
	BC		dlm[2]		 = {0};

	if (delimiter != 0) {
		dlm[0] = delimiter;
		pDlm = dlm;
	}
	rc = AjcVthSearchBelowExA(hwnd, pStr, pDlm, pAny, NULL, fTrim, fIgnoreWidth);

	return rc;
}
//----- バイト文字（文字列の下方向検索とスクロール（拡張）） ---------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSearchBelowExA(HWND hwnd, C_BCP pStr, C_BCP pDlm, C_BCP pAny, C_BCP pEnc, BOOL fTrim, BOOL fIgboreWidth)
{
	UI		rc = -1;
	WCP		pStrW, pDlmW, pAnyW, pEncW;

	do {
		BCF_ALLOC(pStr);
		BCF_ALLOC(pDlm);
		BCF_ALLOC(pAny);
		BCF_ALLOC(pEnc);
		rc = AjcVthSearchBelowExW(hwnd, pStrW, pDlmW, pAnyW, pEncW, fTrim, fIgboreWidth);
	} while(0);
	if (pStrW != NULL) AjcTFree(pStrW);
	if (pDlmW != NULL) AjcTFree(pDlmW);
	if (pAnyW != NULL) AjcTFree(pAnyW);
	if (pEncW != NULL) AjcTFree(pEncW);

	return rc;
}
//----- ワイド文字（文字列の下方向検索とスクロール） -----------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSearchBelowW(HWND hwnd, C_WCP pStr, WC delimiter)
{
	UI		rc			 = -1;
	C_WCP	pDlm		 = NULL;
	C_WCP	pAny		 = NULL;
	BOOL	fTrim		 = FALSE;
	BOOL	fIgnoreWidth = FALSE;
	WC		dlm[2]		 = {0};

	if (delimiter != 0) {
		dlm[0] = delimiter;
		pDlm = dlm;
	}
	rc = AjcVthSearchBelowExW(hwnd, pStr, pDlm, pAny, NULL, fTrim, fIgnoreWidth);

	return rc;
}
//----- ワイド文字（文字列の下方向検索とスクロール（拡張）） ---------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSearchBelowExW(HWND hwnd, C_WCP pStr, C_WCP pDlm, C_WCP pAny, C_WCP pEnc, BOOL fTrim, BOOL fIgnoreWidth)
{
	UI	rc = -1;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = VthFindStrBelowW(pW, pStr, pDlm, pAny, pEnc, fTrim, fIgnoreWidth);
		}
	}
	return rc;
}
//==============================================================================================================//
//	文字列の上方向検索とスクロール																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pStr		- 検索文字列																		//
//				delimiter	- 区切り文字（０の場合は区切り文字無し）											//
//																												//
//	戻り値	：	≠ -1 : 行スクロール位置																		//
//				＝ -1 : エラー																					//
//==============================================================================================================//
//----- バイト文字（文字列の上方向検索とスクロール） -----------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSearchAboveA(HWND hwnd, C_BCP pStr, BC delimiter)
{
	UI		rc			 = -1;
	C_BCP	pDlm		 = NULL;
	C_BCP	pAny		 = NULL;
	BOOL	fTrim		 = FALSE;
	BOOL	fIgnoreWidth = FALSE;
	BC		dlm[2]		 = {0};

	if (delimiter != 0) {
		dlm[0] = delimiter;
		pDlm = dlm;
	}
	rc = AjcVthSearchAboveExA(hwnd, pStr, pDlm, pAny, NULL, fTrim, fIgnoreWidth);

	return rc;
}
//----- バイト文字（文字列の上方向検索とスクロール（拡張）） ---------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSearchAboveExA(HWND hwnd, C_BCP pStr, C_BCP pDlm, C_BCP pAny, C_BCP pEnc, BOOL fTrim, BOOL fIgnoreWidth)
{
	UI		rc = -1;
	WCP		pStrW, pDlmW, pAnyW, pEncW;

	do {
		BCF_ALLOC(pStr);
		BCF_ALLOC(pDlm);
		BCF_ALLOC(pAny);
		BCF_ALLOC(pEnc);
		rc = AjcVthSearchAboveExW(hwnd, pStrW, pDlmW, pAnyW, pEncW, fTrim, fIgnoreWidth);
	} while(0);
	if (pStrW != NULL) AjcTFree(pStrW);
	if (pDlmW != NULL) AjcTFree(pDlmW);
	if (pAnyW != NULL) AjcTFree(pAnyW);
	if (pEncW != NULL) AjcTFree(pEncW);

	return rc;
}
//----- ワイド文字（文字列の上方向検索とスクロール） -----------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSearchAboveW(HWND hwnd, C_WCP pStr, WC delimiter)
{
	UI		rc			 = -1;
	C_WCP	pDlm		 = NULL;
	C_WCP	pAny		 = NULL;
	BOOL	fTrim		 = FALSE;
	BOOL	fIgnoreWidth = FALSE;
	WC		dlm[2]		 = {0};

	if (delimiter != 0) {
		dlm[0] = delimiter;
		pDlm = dlm;
	}
	rc = AjcVthSearchAboveExW(hwnd, pStr, pDlm, pAny, NULL, fTrim, fIgnoreWidth);

	return rc;
}
//----- ワイド文字（文字列の上方向検索とスクロール（拡張）） ---------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcVthSearchAboveExW(HWND hwnd, C_WCP pStr, C_WCP pDlm, C_WCP pAny, C_WCP pEnc, BOOL fTrim, BOOL fIgnoreWidth)
{
	UI	rc = -1;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = VthFindStrAboveW(pW, pStr, pDlm, pAny, pEnc, fTrim, fIgnoreWidth);
		}
	}
	return rc;
}
//==============================================================================================================//
//	表示の停止／再開																							//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				fPause		- 表示停止フラグ（TRUE:表示停止，FALSE:表示開始）									//
//																												//
//	戻り値	：	TRUE  : OK																						//
//				FALSE : - エラー																				//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthPause(HWND hwnd, BOOL fPause)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (!(pW->fPause = fPause)) {
				//	最終ページへスクロール
				if (!(pW->style & AJCVTHS_NOSCRL)) {
					VthScrollToBottom(pW);
				}
				//	スクロール情報設定
				else {
					VthSetVScrollInfo(pW, -1);
				}
				//	キャレット設定
				VthSetCaret(pW);
				//	再描画
				InvalidateRect(pW->hMain, NULL, FALSE);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	改行動作の設定をポップアップメニューに含めるか否かの設定													//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				flag		- TRUE	: 改行動作の設定をポップアップメニューに含める								//
//							  FALSE : 改行動作の設定をポップアップメニューに含めない							//
//																												//
//	戻り値	：	TRUE  : OK																						//
//				FALSE : - エラー																				//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthSetLFActInPopupMenu(HWND hwnd, BOOL flag)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (flag) MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) & ~AJCVTHS_FIXEDLF);
			else	  MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) |  AJCVTHS_FIXEDLF);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	改行動作の設定をポップアップメニューに含めるか否かの設定値取得												//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//																												//
//	戻り値	：	TRUE  : TRUE  : 改行動作の設定をポップアップメニューに含める									//
//				FALSE : 改行動作の設定をポップアップメニューに含めない ／ エラー								//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcVthGetLFActInPopupMenu(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = !(MAjcGetWindowLong(hwnd, GWL_STYLE) & AJCVTHS_FIXEDLF);
		}
	}
	return rc;
}

//==============================================================================================================//
//	文字インデクス→桁位置変換																					//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pTxt		- 行テキスト																		//
//				idx			- 文字インデクス																	//
//																												//
//	戻り値	：	文字インデクスに対応する桁位置																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI AjcVthIdxToCPosA(HWND hwnd, C_BCP pTxt, UI idx)
{
	UI		rc = 0;
	UI		lTxt;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			if (lTxt = (UI)strlen(pTxt)) {
				idx  = __min(idx, lTxt - 1);
				if (idx != 0 && mbsbtype(pTxt, idx) == _MBC_TRAIL) idx--;
				rc = idx;
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI AjcVthIdxToCPosW(HWND hwnd, C_WCP pTxt, UI idx)
{
	UI		rc = 0;
	UI		lTxt;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			if (lTxt = (UI)wcslen(pTxt)) {
				rc = VthIdxToCPos(pTxt, lTxt, idx);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	桁位置→文字インデクス変換																					//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pTxt		- 行テキスト																		//
//				pos			- 桁位置																			//
//																												//
//	戻り値	：	文字インデクスに対応する桁位置																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI AjcVthCPosToIdxA(HWND hwnd, C_BCP pTxt, UI pos)
{
	UI		rc = 0;
	UI		lTxt;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			if (lTxt = (UI)strlen(pTxt)) {
				pos  = __min(pos, lTxt - 1);
				if (pos != 0 && mbsbtype(pTxt, pos) == _MBC_TRAIL) pos--;
				rc = pos;
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI AjcVthCPosToIdxW(HWND hwnd, C_WCP pTxt, UI pos)
{
	UI		rc = 0;
	UI		lTxt;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTxt != NULL) {
			if (lTxt = (UI)wcslen(pTxt)) {
				rc = VthCPosToIdx(pTxt, lTxt, pos);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	メインウインドのハンドル取得																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pBkWnd		- ウインド背景色を格納するバッファへのポインタ（不要時はNULL）						//
//																												//
//	戻り値	：	≠NULL : メインウインドのハンドル																//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT	HWND	WINAPI		AjcVthGetMainWindow(HWND hwnd, COLORREF *pBkGnd)
{
	HWND	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pBkGnd != NULL) {
				*pBkGnd = RGB(255, 255, 255);
			}
			rc = pW->hMain;
		}
	}
	return rc;
}
//==============================================================================================================//
//																												//
//	通知情報取得																								//
//																												//
//==============================================================================================================//
//	右クリック通知情報
AJCEXPORT	PAJCVTHRCLK	WINAPI AjcVthGetNtcRClk		(HWND hwnd)
{
	PAJCVTHRCLK	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = &pW->NtcRClk;
	}
	return rc;
}
//	ダブルクリック通知情報
AJCEXPORT	UI		WINAPI AjcVthGetNtcDblClk	(HWND hwnd)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcDblClk;
	}
	return rc;
}
//	ドロップしたディレクトリ数
AJCEXPORT	UI			WINAPI AjcVthGetNtcDirs		(HWND hwnd)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcDirs;
	}
	return rc;
}
//	ドロップしたファイル数
AJCEXPORT	UI			WINAPI AjcVthGetNtcFiles	(HWND hwnd)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcFiles;
	}
	return rc;
}
//	入力キーコード
AJCEXPORT	UI			WINAPI AjcVthGetNtcKey		(HWND hwnd)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcKey;
	}
	return rc;
}
//	キー押し続け情報
AJCEXPORT	UI			WINAPI AjcVthGetNtcKeyRep	(HWND hwnd)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = pW->KeyRep;
	}
	return rc;
}
//	ダブルクリック時の仮想キー押下情報
AJCEXPORT	UI			WINAPI AjcVthGetNtcKeyFlg	(HWND hwnd)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcKeyFlg;
	}
	return rc;
}
//	文字サイズ情報の変化通知時の行の高さ
AJCEXPORT	UI			WINAPI AjcVthGetNtcCyLine	(HWND hwnd)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcCyLine;
	}
	return rc;
}
//	横スクロール通知時の左端文字位置
AJCEXPORT	UI			WINAPI AjcVthGetNtcLeft	(HWND hwnd)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcLeft;
	}
	return rc;
}
//	縦スクロール通知時の上端行位置
AJCEXPORT	UI			WINAPI AjcVthGetNtcTop	(HWND hwnd)
{
	UI	rc = 0;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcTop;
	}
	return rc;
}

//==============================================================================================================//
//	処理モード取得（デバッグ用）																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//																												//
//	戻り値	：	処理モード																						//
//==============================================================================================================//
AJCEXPORT UI	   WINAPI AjcVthGetMode(HWND hwnd)
{
	UI		rc = -1;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->Mode;
		}
	}
	return rc;
}

//==============================================================================================================//
//	デフォルトフォント設定（非公開）																			//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				hFont		- フォントハンドル																	//
//																												//
//	戻り値	：	TRUE  : OK																						//
//				FALSE : - エラー																				//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI AjcVthSetDefFont(HWND hwnd, HFONT hFont)
{
	BOOL	rc = FALSE;
	LOGFONT	lf;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (rc = (GetObject(hFont, sizeof(LOGFONT), &lf) == sizeof(LOGFONT))) {
				memcpy(&pW->lfDefFont, &lf, sizeof(LOGFONT));
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ＶＲＡＭ情報取得（非公開）																					//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pBuf		- ＶＲＡＭ情報を格納するバッファのアドレス											//
//																												//
//	戻り値	：	TRUE  : OK																						//
//				FALSE : - エラー																				//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI AjcVthGetVramInfo(HWND hwnd, PAJCVTHVRAMINFO pBuf)
{
	BOOL		rc = FALSE;
	PLINEPTR	pL;

	if (IsWindow(hwnd)) {
		PWRKVT100 pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pBuf->pVram		= pW->pVram;			//	ＶＲＡＭ先頭アドレス
			pBuf->width		= pW->prop.VramW;		//	１行当たりの文字数
			pBuf->height	= pW->prop.VramH;		//	行数
			pBuf->LineBytes	= pW->VramLSize;		//	ＶＲＡＭ１行のバイト数
			pBuf->lp		= pW->lp;				//	カーソル行位置
			pBuf->cp		= pW->cp;				//	カーソル桁位置
			pBuf->ix		= pW->cpx;				//	カーソル位置に対応するテキストインデクス
			//	ＶＲＡＭ最上行の行インデクス
			pL = pW->pLPtr + pW->IxVTop;
			pBuf->ltop = (UI)(((UX)pL->pTxt - (UX)pW->pVram) / pW->VramLSize);
			rc = TRUE;
		}
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	選択範囲のテキスト取得																						//
//																												//
//	引　数	：	pW		- 作業領域のアドレス																	//
//																												//
//	戻り値	：	≠NULL - 選択中のテキストあり（バッファにテキストを格納した）									//
//				＝NULL - 選択中のテキストなし/バッファ確保不能													//
//--------------------------------------------------------------------------------------------------------------//
static	HGLOBAL	GetSelectedText(PWRKVT100 pW)
{
	HGLOBAL		hGlobal = NULL;
	UI			ixL, ixSL, ixSC, ixEL, ixEC, len;
	PLINEPTR	pL;
	WCP			pBlk;

	if (pW->Mode & MD_SELECT) {
		VthAdjustSelectInfo(pW, &ixSL, &ixSC, &ixEL, &ixEC);
		//----- 同一行範囲の選択 ------------------------------------------------//
		if (ixSL == ixEL) {
			pL = pW->pLPtr + ixSL;
			if (ixSC < pL->len && ixSC < ixEC) {
				len = __min(ixEC, pL->len) - ixSC;
				if (hGlobal = GlobalAlloc(GHND | GMEM_SHARE, (len + 3) * 2)) {
					pBlk = GlobalLock(hGlobal);
					memcpy(pBlk, pL->pTxt + ixSC, len * 2); pBlk += len;
					if (ixEC > pL->len && 
						ixEL  != ((pW->IxSrt + (pW->LCnt - 1)) % pW->prop.MaxLines)) {
						memcpy(pBlk, L"\r\n", 4); pBlk += 2;
					}
					*pBlk = 0;
				}
			}
		}
		//----- 複数行選択 ------------------------------------------------------//
		else {
			len = 0;
			//----- 先頭行サイズ計算 ----------------------//
			ixL = ixSL;
			pL	= pW->pLPtr + ixL;
			if (ixSC < pL->len) {
				len += (pL->len - ixSC);
			}
			len += 2;
			//----- 中間行サイズ計算 ----------------------//
			ixL = ((ixL + 1) % pW->prop.MaxLines);
			while (ixL != ixEL) {
				pL = pW->pLPtr + ixL;
				len += (pL->len + 2);
				ixL = ((ixL + 1) % pW->prop.MaxLines);
			}
			//----- 最終行サイズ計算 ----------------------//
			pL = pW->pLPtr + ixL;
			if (ixEC < pL->len) len += (ixEC	   );
			else				len += (pL->len + 2);
			//----- メモリ割り当て ------------------------//
			if (hGlobal = GlobalAlloc(GHND | GMEM_SHARE, (len + 1) * 2)) {
				pBlk = GlobalLock(hGlobal);
				//----- 先頭行コピー ----------------------//
				ixL = ixSL;
				pL	= pW->pLPtr + ixL;
				if (ixSC < pL->len) {
					len = (pL->len - ixSC);
					memcpy(pBlk, pL->pTxt + ixSC, len * 2); pBlk += len;
				}
				memcpy(pBlk, L"\r\n", 4); pBlk += 2;
				//----- 中間行コピー ----------------------//
				ixL = ((ixL + 1) % pW->prop.MaxLines);
				while (ixL != ixEL) {
					pL = pW->pLPtr + ixL;
					len = pL->len;
					memcpy(pBlk, pL->pTxt, len * 2); pBlk += len;
					memcpy(pBlk, L"\r\n" , 4	  ); pBlk += 2;
					ixL = ((ixL + 1) % pW->prop.MaxLines);
				}
				//----- 最終行コピー ----------------------//
				pL = pW->pLPtr + ixL;
				if (ixEC <= pL->len) {
					memcpy(pBlk, pL->pTxt, ixEC * 2); pBlk += ixEC;
				}
				else {
					memcpy(pBlk, pL->pTxt, pL->len * 2); pBlk += pL->len;
					if (ixEL != ((pW->IxSrt + (pW->LCnt - 1)) % pW->prop.MaxLines)) {
						memcpy(pBlk, L"\r\n", 4); pBlk += 2;
					}
				}
				//----- 終端設定 --------------------------//
				*pBlk = 0;
			}
		}
	}
	return hGlobal;
}
//--------------------------------------------------------------------------------------------------------------//
//	テキストをファイルへ書き込み																				//
//																												//
//	引　数	：	pW			- 作業領域のアドレス																//
//				hFile		- ファイルハンドル																	//
//				fAllText	- TRUE:全テキスト，FALSE:選択テキスト												//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 選択中のテキストなし																	//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SaveToTextFile(PWRKVT100 pW, HAJCFILE hFile, BOOL fAllText)
{
	BOOL		rc = FALSE;
	UI			ixL, ixSL, ixSC, ixEL, ixEC, len;
	PLINEPTR	pL;

	if (pW->LCnt != 0) {
		if (fAllText || (pW->Mode & MD_SELECT)) {	//	全テキスト出力／選択テキストあり？
			if (fAllText) {							//		全テキスト出力
				ixSL  = pW->IxSrt;					//			先頭行インデクス
				ixSC  = 0;							//			先頭文字インデクス
				ixEL  = pW->IxSrt + pW->LCnt - 1;	//			最終行インデクス
				ixEL %= pW->prop.MaxLines;			//			・
				ixEC  = pW->prop.VramW;				//			最終文字インデクス
			}
			else {									//		選択テキスト出力
				VthAdjustSelectInfo(pW, &ixSL, &ixSC, &ixEL, &ixEC);
			}
			//----- 同一行範囲の選択 ------------------------------------------------//
			if (ixSL == ixEL) {
				pL = pW->pLPtr + ixSL;
				if (ixSC < pL->len && ixSC < ixEC) {
					len = __min(ixEC, pL->len) - ixSC;
					AjcFPutS(hFile, pL->pTxt + ixSC, len);
					if (ixEC > pL->len && 
						ixEL  != ((pW->IxSrt + (pW->LCnt - 1)) % pW->prop.MaxLines)) {
						AjcFPutSW(hFile, L"\n", -1);
					}
					rc = TRUE;
				}
			}
			//----- 複数行選択 ------------------------------------------------------//
			else {
				//----- 先頭行書き込み --------------------//
				ixL = ixSL;
				pL	= pW->pLPtr + ixL;
				if (ixSC < pL->len) {
					len = (pL->len - ixSC);
					AjcFPutSW(hFile, pL->pTxt + ixSC, len);
				}
				AjcFPutSW(hFile, L"\n", -1);
				//----- 中間行書き込み --------------------//
				ixL = ((ixL + 1) % pW->prop.MaxLines);
				while (ixL != ixEL) {
					pL = pW->pLPtr + ixL;
					len = pL->len;
					AjcFPutSW(hFile, pL->pTxt, len);
					AjcFPutSW(hFile, L"\n"	 , -1 );
					ixL = ((ixL + 1) % pW->prop.MaxLines);
				}
				//----- 最終行書き込み --------------------//
				pL = pW->pLPtr + ixL;
				if (ixEC <= pL->len) {
					AjcFPutSW(hFile, pL->pTxt, ixEC);
				}
				else {
					AjcFPutS(hFile, pL->pTxt, pL->len);
					if (ixEL != ((pW->IxSrt + (pW->LCnt - 1)) % pW->prop.MaxLines)) {
						AjcFPutSW(hFile, L"\n", -1);
					}
				}
				//----- 戻り値＝正常 ----------------------//
				rc = TRUE;
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	選択範囲をＨＴＭＬファイルへ書き込み																		//
//																												//
//	引　数	：	pW			- 作業領域のアドレス																//
//				hFile		- ファイルハンドル																	//
//				fAllText	- TRUE:全テキスト，FALSE:選択テキスト												//
//				FontSize	- フォントサイズ（１～７）															//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 選択中のテキストなし																	//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SaveToHtmlFile(PWRKVT100 pW, HAJCFILE hFile, BOOL fAllText, UI FontSize)
{
	BOOL		rc = FALSE;
	UI			ixL, ixSL, ixSC, ixEL, ixEC;
	PLINEPTR	pL;
	WC			txt[512];

	if (pW->LCnt != 0) {
		pW->HtmlSvAtt = 0xFF;
		if (fAllText || (pW->Mode & MD_SELECT)) {	//	全テキスト出力／選択テキストあり？
			if (fAllText) {							//		全テキスト出力
				ixSL  = pW->IxSrt;					//			先頭行インデクス
				ixSC  = 0;							//			先頭文字インデクス
				ixEL  = pW->IxSrt + pW->LCnt - 1;	//			最終行インデクス
				ixEL %= pW->prop.MaxLines;			//			・
				ixEC  = pW->prop.VramW;				//			最終文字インデクス
			}
			else {									//		選択テキスト出力
				VthAdjustSelectInfo(pW, &ixSL, &ixSC, &ixEL, &ixEC);
			}
			//----- フォントサイズ調整 ----------------------------------------------//
			FontSize = __max(1, FontSize);
			FontSize = __min(7, FontSize);
			//----- 先頭部 ----------------------------------------------------------//
			AjcFPutSA(hFile, "<html>\n", -1);
			AjcFPutSA(hFile, "<head>\n", -1);
			AjcFPutSA(hFile, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n", -1);
			AjcFPutSA(hFile, "</head>\n", -1);
			AjcFPutSA(hFile, "<body bgcolor=\"#ffffff\">\n", -1);
			AjcSnPrintF(txt, AJCTSIZE(txt), L"<font size=\"%d\" face=\"%s\">\n", FontSize, pW->prop.LogFont.lfFaceName, -1);
			AjcFPutS(hFile, txt, -1);
			//----- 同一行範囲の選択 ------------------------------------------------//
			if (ixSL == ixEL) {
				pL = pW->pLPtr + ixSL;
				if (ixSC < pL->len && ixSC < ixEC) {
					WriteHtmlLine(pW, hFile, pL, ixSC, ixEC);
					if (ixEC > pL->len && 
						ixEL  != ((pW->IxSrt + (pW->LCnt - 1)) % pW->prop.MaxLines)) {
						AjcFPutSA(hFile, "<br>\r\n", -1);
					}
					rc = TRUE;
				}
			}
			//----- 複数行選択 ------------------------------------------------------//
			else {
				//----- 先頭行書き込み --------------------//
				ixL = ixSL;
				pL	= pW->pLPtr + ixL;
				if (ixSC < pL->len) {
					WriteHtmlLine(pW, hFile, pL, ixSC, pW->prop.VramW);
				}
				AjcFPutSA(hFile, "<br>\n", -1);
				//----- 中間行書き込み --------------------//
				ixL = ((ixL + 1) % pW->prop.MaxLines);
				while (ixL != ixEL) {
					pL = pW->pLPtr + ixL;
					WriteHtmlLine(pW, hFile, pL, 0, pW->prop.VramW);
					AjcFPutSA(hFile, "<br>\n", -1);
					ixL = ((ixL + 1) % pW->prop.MaxLines);
				}
				//----- 最終行書き込み --------------------//
				pL = pW->pLPtr + ixL;
				if (ixEC <= pL->len) {
					WriteHtmlLine(pW, hFile, pL, 0, ixEC);
				}
				else {
					WriteHtmlLine(pW, hFile, pL, 0, ixEC);
					if (ixEL != ((pW->IxSrt + (pW->LCnt - 1)) % pW->prop.MaxLines)) {
						AjcFPutSA(hFile, "<br>\n", -1);
					}
				}
				//----- 戻り値＝正常 ----------------------//
				rc = TRUE;
			}
			//----- 終端部 ----------------------------------------------------------//
			if (pW->HtmlSvAtt != 0xFF)	AjcFPutSA(hFile, "</span>\n", -1);
										AjcFPutSA(hFile, "</font>\n", -1);
										AjcFPutSA(hFile, "</body>\n", -1);
										AjcFPutSA(hFile, "</html>\n", -1);
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＨＴＭＬ行書き込み																							//
//																												//
//	引　数	：	pW		- 作業領域のアドレス																	//
//				hFile	- ファイルハンドル																		//
//				pL		- 書き込むテキストへの行ポインタ														//
//				ixSC	- 先頭文字インデクス																	//
//				ixEC	- 終端文字インデクス																	//
//																												//
//	戻り値	：	TRUE  : OK																						//
//				FALSE : Error																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	WriteHtmlLine(PWRKVT100 pW, HAJCFILE hFile, PLINEPTR pL, UI ixSC, UI ixEC)
{
	BOOL	rc = FALSE;
	UI		len = 0;
	UI		i, ix, bc, fc;
	WCP		pTxt;
	UBP		pAtt;
	WC		txt[128];

	if (ixSC < ixEC) {
		pTxt = pL->pTxt;
		if (pL->fVram) pAtt = (UBP)(pL->pTxt + pW->prop.VramW);
		else		   pAtt = (UBP)(pL->pTxt + pL->len);
		len = __min(ixEC, pL->len) - ixSC;

		ix = ixSC;
		for (i = 0; i < len; i++) {
			if ((pAtt[ix] & (VAT_BC | VAT_FC)) != pW->HtmlSvAtt) {
				WriteHtmlText(pW, hFile, pTxt + ixSC, ix - ixSC);
				if (pW->HtmlSvAtt != 0xFF) AjcSnPrintF(txt, AJCTSIZE(txt), L"</span>\n");
				bc = (pAtt[ix] & VAT_BC) >> 4;
				fc = (pAtt[ix] & VAT_FC);
				bc = pW->prop.rgb[bc]; bc = ((bc & 0x00FF0000) >> 16) | (bc & 0x0000FF00) | ((bc & 0x000000FF) << 16);
				fc = pW->prop.rgb[fc]; fc = ((fc & 0x00FF0000) >> 16) | (fc & 0x0000FF00) | ((fc & 0x000000FF) << 16);
				AjcSnPrintFW(txt, AJCTSIZE(txt), L"<span style=\"background-color:#%06X;color:#%06X\">\n", bc, fc);
				AjcFPutSW(hFile, txt, -1);
				pW->HtmlSvAtt = (pAtt[ix] & (VAT_BC | VAT_FC));
				ixSC = ix++;
			}
			else ix++;
		}
		if (ixSC < ix) {
			WriteHtmlText(pW, hFile, pTxt + ixSC, ix - ixSC);
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＨＴＭＬテキストをファイルへ書き込み																		//
//																												//
//	引　数	：	pW		- 作業領域のアドレス																	//
//				hFile	- ファイルハンドル																		//
//				pTxt	- 書き込むテキストのアドレス(SJIS)														//
//				lTxt	- 書き込むテキストのバイト数															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	WriteHtmlText(PWRKVT100 pW, HAJCFILE hFile, C_WCP pTxt, UI lTxt)
{
	BOOL	rc = TRUE;
	UI		i, j;

	for (i = 0; i < lTxt;) {
		if (pTxt[i] == 0x20) {
			if (!AjcFPutSA(hFile, "&nbsp;", -1)) {
				rc = FALSE;
			}
			i++;
		}
		else {
			for (j = i; pTxt[j] != 0x20 && j < lTxt; j++);
			if (!AjcFPutSW(hFile, pTxt + i, j - i)) {
				rc = FALSE;
			}
			i = j;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＥＳＣシーケンスを付加し、全テキストをファイルへ書き込み													//
//																												//
//	引　数	：	pW			- 作業領域のアドレス																//
//				hFile		- ファイルハンドル																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SaveAllTextToFileWithEsc(PWRKVT100 pW, HAJCFILE hFile)
{
	BOOL		rc = FALSE;
	int			ixL, ixSL, ixEL, len, i, j;
	PLINEPTR	pL;
	WCP			pT;
	UBP			pA;
	UB			Tc, SvTc = -1;
	UB			Bc, SvBc = -1;
	WC			esc[32];

	if (pW->LCnt != 0) {
		ixSL  = pW->IxSrt;					//	先頭行インデクス
		ixEL  = pW->IxSrt + pW->LCnt - 1;	//	最終行インデクス
		ixEL %= pW->prop.MaxLines;			//	・
		//----- 書き込み ------------------------//
		ixL = ixSL;
		while (ixL != ixEL) {
			//	行ポインタ設定
			pL = pW->pLPtr + ixL;					//	行ポインタ配列エントリ
			pT = pL->pTxt;							//	行頭テキストポインタ
			if (pL->fVram) {						//	ＶＲＡＭ？
				pA = (UBP)(pT + pW->prop.VramW);	//		ＶＲＡＭの行頭属性ポインタ
			}
			else {
				pA = (UBP)(pT + pL->len);			//		バッファデータの行頭属性ポインタ
			}
			//	有効データ長設定
			len = pL->len;

			if (len > 0) {
				//	１行出力
				i = j = 0;
				while (j < len) {
					Bc = (UB)((pA[j] & VAT_BC) >> 4);
					Tc = (UB) (pA[j] & VAT_FC);
					if (Tc != SvTc || Bc != SvBc) {		//	表示色変化
						//	表示色変化前のテキスト出力
						AjcFPutSW(hFile, &pT[i], j - i);
						//	ＥＳＣシーケンス出力
						if (Tc != SvTc) {
							//	テキスト色
							AjcSnPrintFW(esc, AJCTSIZE(esc), L"\x1B[3%dm", Tc);
							AjcFPutSW(hFile, esc, -1);
							SvTc = Tc;
						}
						if (Bc != SvBc) {
							//	背景色
							AjcSnPrintFW(esc, AJCTSIZE(esc), L"\x1B[4%dm", Bc);
							AjcFPutSW(hFile, esc, -1);
							SvBc = Bc;
						}
						i = j;
					}
					j++;
				}
				//	行末テキスト出力
				if (i <= j) {
					AjcFPutSW(hFile, &pT[i], j - i);
				}
			}
			//	行末出力
			AjcFPutSW(hFile, L"\n", -1);
			//	次の行インデクス設定
			ixL = ((ixL + 1) % pW->prop.MaxLines);
		}
		//----- 属性リセット出力 ------------------//
		AjcFPutSW(hFile, L"\x1B[0m", -1);
		//----- 戻り値＝正常 ----------------------//
		rc = TRUE;
	}
	return rc;
}

