﻿//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		共通定義											//
//																												//
//**************************************************************************************************************//

#define		INST_ID			0x2724BB9E
#define		MAX_FINDSTR		256

//	VRAMの属性ポインタポインタ設定
#define	ATT_PTR(PTXTTOP)				(UBP)((WCP)PTXTTOP + pW->prop.VramW)

//--------------------------------------------------------------------------------------------------------------//
//	MemSet																										//
//--------------------------------------------------------------------------------------------------------------//
#define			VthMemSetA		memset

__inline VOP	VthMemSetW(VOP pMem, UI dat, UI len) {
	UWP		p = (UWP)pMem;
	while (len--) {
		*p++ = (UW)dat;
	}
	return pMem;
}

//--------------------------------------------------------------------------------------------------------------//
//	フォントの高さの最大値，最小値																				//
//--------------------------------------------------------------------------------------------------------------//
#define		MAX_FONT_PIXELS		192
#define		MIN_FONT_PIXELS		8

#define		MAX_FONT_POINTS		144
#define		MIN_FONT_POINTS		6

//--------------------------------------------------------------------------------------------------------------//
//	ウインド余白サイズ																							//
//--------------------------------------------------------------------------------------------------------------//
#define		VMRG	4		//	上下余白
#define		HMRG	4		//	左右余白

//--------------------------------------------------------------------------------------------------------------//
//	デフォルトプロパティ値																						//
//--------------------------------------------------------------------------------------------------------------//
#define	DEF_VRAMW		256					//	ＶＲＡＭの幅（文字数）
#define	DEF_VRAMH		64					//	ＶＲＡＭの高さ（行数）
#define	DEF_MAXLINES	10000				//	最大保留行数
#define	DEF_TABSTEP		4					//	ＴＡＢステップ
#define	DEF_LSPACE		0					//	行間スペース
#define	DEF_PENDSIZE	(512 * 1024)		//	テキスト最大保留バイト数

//--------------------------------------------------------------------------------------------------------------//
//	ＶＲＡＭ属性情報																							//
//--------------------------------------------------------------------------------------------------------------//
#define	VAT_SUR1	0x80					//	サロゲート１文字目
#define	VAT_BC		0x70					//	背景色
#define	VAT_SUR2	0x08					//	サロゲート２文字目
#define	VAT_FC		0x07					//	文字色

#define	VAT_DEFAULT	0x70					//	デフォルト属性

//--------------------------------------------------------------------------------------------------------------//
//	ラインポインタ情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UB		fVram :1;						//	テキストタイプ			(1:ＶＲＡＭ, 0:内部バッファリングテキスト)
	UB		fAlloc:1;						//	アロケーションメモリ識別(1:動的メモリ．0:静的メモリ)
	UB		dmy:6;							//	－
	UB		fUpd;							//	更新フラグ(TRUE:更新された，FALSE:未更新)
	UW		len;							//	有効テキスト長（ワード数）
	WCP		pTxt;							//	テキストポインタ
} LINEPTR, *PLINEPTR;

//--------------------------------------------------------------------------------------------------------------//
//	選択情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef	struct {
	UI		ixSL, ixSC;						//	選択開始行，文字インデクス
	UI		ixEL, ixEC;						//	選択終了行，文字インデクス
} SELINF, *PSELINF;

//--------------------------------------------------------------------------------------------------------------//
//	フォント選択コンボボックス関連付け情報																		//
//--------------------------------------------------------------------------------------------------------------//
typedef union {
	struct {UB PitchAndFamily, CharSet;} s;
	UI									 v;
} CBODATA, *PCBODATA;

//--------------------------------------------------------------------------------------------------------------//
//	フォント設定ダイアログワーク																				//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	//	ディスプレイ解像度
	UI			DPI;						//	ピクセル数／インチ
	UI			PPI;						//	ポイント数／インチ
	//	永続情報
	BOOL		fFSelFixed;					//	固定ピッチのみの選択フラグ
	CBODATA		FCurAttr;					//	現在のフォント属性
	WC			FCurFace[64];				//	現在のフォント名
	CBODATA		FSelFixedAttr;				//	固定ピッチフォント設定時の属性（CharSet, PitchAndFamily)
	WC			FSelFixedFace[64];			//	固定ピッチフォント設定時のフォント名
	CBODATA		FSelPropoAttr;				//	プロポーショナル  設定時の属性（CharSet, PitchAndFamily)
	WC			FSelPropoFace[64];			//	プロポーショナル  設定時のフォント名
	//	コントロールのハンドル
	HWND		hBack;						//	バックウインドハンドル
	HWND		hMain;						//	ＶＴＨ描画ウインドハンドル
	//	ワーク
	LOGFONT		FSelLf;						//	フォント情報
	UI			LSpace;						//	行間スペース
	HWND		hCboFont;					//	コンボボックス・ハンドル
	int			SvCboIx;					//	コンボボックス・インデクス退避
	BOOL		fRbtFirst;					//	初回ラジオボタン（擬似クリック）を示すフラグ
} FONTDLGWK, *PFONTDLGWK;
//--------------------------------------------------------------------------------------------------------------//
//	処理モード(Mode)																							//
//--------------------------------------------------------------------------------------------------------------//
#define		MD_NORMAL	0x0000					//	通常モード
#define		MD_SCROLL	0x0002					//	スクロール中
#define		MD_DRAG_L	0x0004					//	行単位ドラッグ中
#define		MD_DRAG_C	0x0008					//	文字単位ドラッグ中
#define		MD_SELECT	0x0010					//	範囲選択状態

#define	MD_DRAG		(MD_DRAG_L | MD_DRAG_C)

//--------------------------------------------------------------------------------------------------------------//
//	ウインドワーク																								//
//--------------------------------------------------------------------------------------------------------------//
#define		MAX_MBC_BUF		256
typedef struct {
	UI			InstID;						//	インスタンス識別ＩＤ
	LOGFONTW	lfParentFont;				//	親ウインドのフォント情報
	LOGFONTW	lfDefFont;					//	デフォルトフォント情報（キャプション指定フォント／親ウインドのフォント）
	//----- バックウインドハンドル／ウインドサイズ -------------------------------------------------------------//
	HWND		hBack;						//	バックウインドハンドル
	UI			bw, bh;						//	バックウインドの幅と高さ
	//----- メインウインドハンドル／ウインドサイズ -------------------------------------------------------------//
	HWND		hMain;						//	メインウインドハンドル
	UI			ww, wh;						//	メインウインドの幅と高さ
	//----- 画面クリアーボタン ---------------------------------------------------------------------------------//
	HWND		hBtnCls;					//	画面クリアーボタンハンドル
	//----- ウインド描画ビットマップ ---------------------------------------------------------------------------//
	HBITMAP		hBitmap;					//	表示ビットマップハンドル
	AJCDIBINFO	DibInfo;					//		〃			のＤＩＢセクション情報
	//----- 表示停止フラグ -------------------------------------------------------------------------------------//
	BOOL		fPause;						//	表示停止中フラグ
	//----- シフト，ＣＴＲＬキー押下フラグ ---------------------------------------------------------------------//
	BOOL		fShift;
	BOOL		fCtrl;
	//----- キー押す続けによる、繰り返し情報 -------------------------------------------------------------------//
	UI			KeyRep;						//	0:初回，TRUE:繰り返し回数
	//----- 状態変数 -------------------------------------------------------------------------------------------//
	UI			style;						//	ウインドスタイル
	BOOL		fEnable;					//	コントロールの有効状態
	BOOL		fFocus;						//	フォーカス状態フラグ
	BOOL		fCaret;						//	キャレット表示フラグ
	BOOL		fFirstGetText;				//	最初のWM_GETTEXTを示すフラグ
	UI			Mode;						//	処理モード
	BOOL		fFixedFont;					//	固定ピッチフォントを示すフラグ
	//----- キー情報 -------------------------------------------------------------------------------------------//
	int			SvFontHeight;				//	CTRL+ﾏｳｽhﾎｨｰﾙ によるフォント制御値（フォントの高さ）
	//----- テキスト一時保留バッファ情報 -----------------------------------------------------------------------//
	HAJCRNG		hRngTxt;					//	リングバッファハンドル
	UB			StaRngTxt[1024];			//	スタティックリングバッファ
	//----- ドロップファイル名一時保留バッファ情報 -------------------------------------------------------------//
	HAJCRNG		hRngFile;					//	リングバッファハンドル
	UB			StaRngFile[1024];			//	スタティックリングバッファ
	//----- ドロップＤＩＲ名一時保留バッファ情報 ---------------------------------------------------------------//
	HAJCRNG		hRngDir;					//	リングバッファハンドル
	UB			StaRngDir[1024];			//	スタティックリングバッファ
	//----- 文字コード判定用 -----------------------------------------------------------------------------------//
	HAJCMBC		hMbc;						//	文字コード判定用インスタンスハンドル
	AJCMBCKIND	SvMbk;						//	文字コード種別退避
	//----- ＳＪＩＳ半端バイト退避 -----------------------------------------------------------------------------//
	BC			SvMbc;
	BC			SvMbcFiller[3];
	//----- ＥＵＣ／ＵＴＦ８ 半端バイト退避 --------------------------------------------------------------------//
	UI			SvStl;						//	半端バイトの長さ
	BC			SvStr[8];					//	半端バイトデータ
	//----- 描画オブジェクト -----------------------------------------------------------------------------------//
	COLORREF	RgbBorder;					//	ボーダー色
	HPEN		hPenBorder;					//	ボーダー描画ペンハンドル
	HFONT		hFontText;					//	テキスト描画フォント
	UI			IxBkWnd;					//	ウインドの背景色（パレット番号）
	COLORREF	SvRgbBkWnd;					//	ウインド背景色退避
	HPEN		hPenBkWnd;					//	ウインド背景色のペン
	HBRUSH		hBruBkWnd;					//	ウインド背景色のブラシ
	//----- ラインポインタバッファとＶＲＡＭポインタ情報 -------------------------------------------------------//
	UI			VramLSize;					//	VRAM１行のバイト数
	WCP			pVram;						//	ＶＲＡＭ先頭ポインタ
	PLINEPTR	pLPtr;						//	ラインバッファポインタテーブル
	UI			LCnt;						//	有効ライン数
	//----- ＶＲＡＭ描画情報 -----------------------------------------------------------------------------------//
	UI			lp;							//	カーソル行位置
	UI			cp;							//	カーソル桁位置（全角文字は２桁でカウント）
	UI			cpx;						//	カーソル文字インデクス（桁に対応するインデクス値）
	UI			svlp, svcp, svcpx;			//	カーソル退避情報
	WC			sur1;						//	サロゲート１文字目退避
	UB			att;						//	表示属性
	UI			cxChar, cyChar;				//	文字サイズ（cyCharは行間スペースを含む）
	UI			cyCharOrg;					//	行間スペースを含まない文字の高さ
	//----- 選択範囲情報 ---------------------------------------------------------------------------------------//
	SELINF		SelInf;						//	選択範囲情報
	int			IxOfSelUpDnKey;				//	↑↓キーによる選択時の文字インデクス
	//----- 表示位置 -------------------------------------------------------------------------------------------//
	UI			IxSrt;						//	ラインポインタ先頭位置（最古の行テキスト）
	UI			IxVTop;						//	ＶＲＡＭ先頭位置
	UI			IxWTop;						//	表示先頭位置
	UI			IxOfs;						//	表示先頭桁位置（cxChar単位)
	//----- ＥＳＣバッファ -------------------------------------------------------------------------------------//
	UI			EscIx;						//	ＥＳＣバッファインデクス
	WC			EscBuf[32];					//	ＥＳＣバッファ
	//----- 最初の WM_SETFONT をスキップするための情報 ---------------------------------------------------------//
	BOOL		fFirstWmSetFont;			//	最初のWM_SETFONTを示すフラグ
	BOOL		fSkipFirstWmSetFont;		//	最初のWM_SETFONTを無視することを示すフラグ
	//----- プロパティ -----------------------------------------------------------------------------------------//
	AJCVTHPROPW	IniProp;					//	ウインド生成時のプロパティ値
	AJCVTHPROPW	prop;						//	現在のプロパティ値
	//----- 右クリック通知情報 ---------------------------------------------------------------------------------//
	BOOL		fNtcRClk;					//	右クリック通知フラグ（TRUE:通知する，FALSE:通知しない）
	UI			MsgRBDown;					//	右ボタンダウン時の通知メッセージコード
	UI			MsgRBUp;					//	右ボタンアップ時の通知メッセージコード
	UI			PopupMask;					//	ポップアップメニューのマスク
	//----- ダブルクリック行テキスト ---------------------------------------------------------------------------//
	WCP			pDblClkLine;				//	ダブルクリック行テキストへのポインタ
	UI			DblClkLPos;					//	ダブルクリック行位置
	UI			DblClkTIdxA;				//	ダブルクリック文字インデクス（バイト文字の桁位置）
	UI			DblClkTIdxW;				//		〃						（ワイド文字の桁位置）
	//----- ツールチップ情報 -----------------------------------------------------------------------------------//
	WCP			pToolTipTxt;				//	テキストボックスのツールヒントメッセージ
	BOOL		fShowAlways;				//	ツールヒント表示条件
	//----- ログウインドハンドル -------------------------------------------------------------------------------//
	HWND		hWndLgf;
	//----- マウスホイール情報 ---------------------------------------------------------------------------------//
	int			mhDeltaPerLine;				//	スクロールライン当たりのデルタ値（＝４０）
	int			mhAccumDelta;				//	デルタ累積値
	//----- タイトル文字列描画情報 -----------------------------------------------------------------------------//
	CTRL_TTLINFO TtlInfo;						//	タイトルビットマップ情報
	//----- テキストセーブ情報 ---------------------------------------------------------------------------------//
	UB			SvTxtFormat;				//	形式				(0:Text  , 1:HTML			)
	UB			SvTxtEncode;				//	文字コード			(0:SJIS  , 1:EUC,  2:UTF-8	)
	UB			SvTxtOutput;				//	出力				(0:ALL	 , 1:選択部分		)
	UB			SvTxtFontSize;				//	フォントサイズ		(1 - 7						)
	BOOL		SvBom;						//	ＢＯＭ出力フラグ
	WC			SvTxtPath[MAX_PATH];		//	出力ファイルパス
	//----- ＨＴＭＬファイル出力ワーク -------------------------------------------------------------------------//
	UB			HtmlSvAtt;					//	描画色退避
	UB			HtmlFiller[3];
	//----- 検索とスクロール用ワーク ---------------------------------------------------------------------------//
	BOOL		fResetPos;					//	検索開始位置リセット要フラグ
	POINT		ScrPos;						//	スクロール位置
	POINT		SrhPos;						//	検索位置
	HWND		hDlgFind;					//	検索ダイアログハンドル
	HWND		hWndCbo;					//	検索コンボボックスハンドル
	HWND		hWndTxt;					//	検索コンボボックス内のテキストボックスハンドル
	UI			FindKey;					//	文字列検索キーコード
	//	永続化項目
	WC			FindSect[64];				//	検索情報永続化用プロファイルセクション
	BOOL		fExactWidth;				//	英大小区別する
	BOOL		fSemicolon;					//	複数指定時はセミコロン( ; )で区切る
	BOOL		fAstarisk;					//	アスタリスク( * )を０桁以上の任意の文字列として扱う
	BOOL		fEnclose;					//	囲み文字(")
	BOOL		fTrim;						//	検索文字列両端空白除去
	BOOL		fClose;						//	検索したら閉じる
	WC			SrhStr[MAX_FINDSTR];		//	検索文字列
	//----- 通知情報 -------------------------------------------------------------------------------------------//
	AJCVTHRCLK	NtcRClk;					//	右クリック通知情報
	UI			NtcDblClk;					//	ダブルクリック時のShuft,Ctrlキー情報
	UI			NtcDirs;					//	ドロップしたディレクトリ数
	UI			NtcFiles;					//	ドロップしたファイル数
	UI			NtcKey;						//	入力キーコード
	UI			NtcKeyFlg;					//	ダブルクリック時の仮想キー押下情報
	UI			NtcCyLine;					//	文字サイズ情報の変化通知時の行の高さ（文字の高さ＋行間スペース）
	UI			NtcLeft;					//	横スクロール通知時の左端桁位置
	UI			NtcTop;						//	縦スクロール通知時の上端行位置
	//----- ポップアップメニュー情報 ---------------------------------------------------------------------------//
	BOOL		fSetF_T;					//	全スレッドウインドへのフォント適用フラグ
	//----- 永続化用ワーク -------------------------------------------------------------------------------------//
	UI			PermItem;					//	永続化項目
	WC			PermSect[256];				//	永続化情報記録用セクション名
	WC			PermKey [256];				//	永続化情報記録用キーの接頭語
	//----- 高速表示モードの制御情報 ---------------------------------------------------------------------------//
	BOOL		fFsDrawAll;					//	ウインド全体を描画する旨のフラグ
	WCP			pFsTxtTop;					//	前回表示したウインド先頭行のテキストポインタ
	UI			FsIxOfs;					//	前回表示の横スクロール位置
	COLORREF	FsBkColor;					//	背景色
	//----- スレッドウインド／兄弟ウインドの検索結果フラグ -----------------------------------------------------//
	BOOL		fExistWindow;
	//----- フォント設定ダイアログ情報 -------------------------------------------------------------------------//
	AJCCFFONTINFOW	DwkFontInfo;			//	LOGFONT，行間スペース
	AJCCFPERMINFOW	DwkPermInfo;			//	ダイアログ設定値
} WRKVT100, *PWRKVT100;

//--------------------------------------------------------------------------------------------------------------//
//	グローバル変数																								//
//--------------------------------------------------------------------------------------------------------------//
extern	ATOM	VthClassBack;
extern	ATOM	VthClassMain;
extern	ATOM	VthClassForMSIL;
extern	UI		VthErrTxtLen;
extern	WC		VthErrorTxt[128];

//--------------------------------------------------------------------------------------------------------------//
//	グローバル サブ関数																							//
//--------------------------------------------------------------------------------------------------------------//
extern	WNDPROC		VthWndProcBack();
extern	WNDPROC		VthWndProcMain();
extern	WNDPROC		VthWndProcMSIL();

extern	HWND		VthCreateDlgSaveToFile	(PWRKVT100 pW);
extern	HWND		VthCreateDlgSetOther	(PWRKVT100 pW);

extern	VO			VthCreateBkWndObj		(PWRKVT100 pW);
extern	BOOL		VthGetTextExtentPoint	(PWRKVT100 pW, HDC hdc, C_WCP pTxt, int len, LPSIZE pSz);
extern	VO			VthSetPropByText		(PWRKVT100 pW, WCP pTxt, PAJCVTHPROP pProp);
extern	UI			VthMakePropText			(PWRKVT100 pW, WCP pTxt, UI lTxt);
extern	BOOL		VthSetCtrlProp			(PWRKVT100 pW, PCAJCVTHPROP pNew);
extern	BOOL		VthSetBorderColor		(PWRKVT100 pW,	COLORREF color);
extern	VO			VthSetMode				(PWRKVT100 pW, UI mode);
extern	VO			VthReleaseAllLinePtrs	(PLINEPTR pL, UI n);
extern	BOOL		VthSetFontSize			(HWND hWndDmy, LPLOGFONT pLogFont, UIP pCxChar, UIP pCyChar);
extern	VO			VthAdjustScrollInfo		(PWRKVT100 pW);
extern	VO			VthSetHScrollInfo		(PWRKVT100 pW, UI cp);
extern	VO			VthSetVScrollInfo		(PWRKVT100 pW, UI lp);
extern	UI			VthLnoToIx				(PWRKVT100 pW, UI lp);
extern	UI			VthIxToLno				(PWRKVT100 pW, UI ix);
extern	VO			VthClearAllText			(PWRKVT100 pW);
extern	WCP			VthMusToTextIdx			(PWRKVT100 pW, int x, int y, int *pLp, int *pIx, int *pCp);
extern	VO			VthSetCaret				(PWRKVT100 pW);
extern	UI			VthIdxToCPos			(C_WCP pTxt, UI lTxt, UI idx);
extern	UI			VthCPosToIdx			(C_WCP pTxt, UI lTxt, UI pos);
extern	VO			VthScrollToBottom		(PWRKVT100 pW);
extern	VO			VthPutTextToVRAM		(PWRKVT100 pW);
extern	BOOL		VthAdjustSelectInfo		(PWRKVT100 pW, UIP pSL, UIP pSC, UIP pEL, UIP pEC);

extern	BOOL		VthCreateDlgFind  (PWRKVT100 pW);
extern	VO			VthDeleteDlgFind  (PWRKVT100 pW);
extern	VO			VthResetFindSrtPos(PWRKVT100 pW);
extern	VO			VthLoadStrFindInfo(PWRKVT100 pW);
extern	VO			VthSaveStrFindInfo(PWRKVT100 pW);
extern	UI			VthFindStrBelowW  (PWRKVT100 pW, C_WCP pStr, C_WCP pDlm, C_WCP pAny, C_WCP pEnc, BOOL fTrim, BOOL fIgnoreWidth);
extern	UI			VthFindStrAboveW  (PWRKVT100 pW, C_WCP pStr, C_WCP pDlm, C_WCP pAny, C_WCP pEnc, BOOL fTrim, BOOL fIgnoreWidth);

