﻿#include	"AjcInternal.h"
#include	"AjcCtrlVT100Def.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		文字列検索ダイアログ								//
//																												//
//**************************************************************************************************************//

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Find);
AJC_WNDPROC_DEF(SbcTxt);
static	VO		SubReadDialogItems(PWRKVT100 pW, HWND hDlg);
static	BOOL	SubSetNxtPoint(PWRKVT100 pW, WCP pTxt, UI lTxt, LPPOINT pPos);
static	BOOL	SubSetBfrPoint(PWRKVT100 pW, WCP pTxt, UI lTxt, LPPOINT pPos);
static	VO		SubFindScroll(PWRKVT100 pW, C_WCP pLine, int lp, int cp, int stl);

//==============================================================================================================//
//																												//
//	文字列検索ダイアログ生成																					//
//																												//
//==============================================================================================================//
BOOL	VthCreateDlgFind(PWRKVT100 pW)
{
	BOOL	rc = FALSE;

	if (pW->hDlgFind == NULL) {
		if (pW->hDlgFind = CreateDialogParam(hDllInst, MAKEINTRESOURCE(IDD_VTHFIND), pW->hBack, AJC_DLGPROC_NAME(Find), (LPARAM)pW)) {
			ShowWindow(pW->hDlgFind, SW_SHOWNORMAL);
			rc = TRUE;
		}
	}
	return	rc;
}
//==============================================================================================================//
//																												//
//	文字列検索ダイアログクローズ																				//
//																												//
//==============================================================================================================//
VO		VthDeleteDlgFind(PWRKVT100 pW)
{
	if (pW->hDlgFind != NULL) {
		//	セーブして終了
		SendMessage(pW->hDlgFind, WM_COMMAND, MAKELONG(IDCANCEL, BN_CLICKED), (LPARAM)GetDlgItem(pW->hDlgFind, IDCANCEL));
		pW->hDlgFind = NULL;
		pW->hWndCbo  = NULL;
		pW->hWndTxt  = NULL;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	文字列検索ダイアログプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static C_WCP CALLBACK cbGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp)
{
	UT	txt[MAX_FINDSTR];
	AjcGetCtrlStr(hwnd, txt, MAX_FINDSTR);
	AjcSnPrintF(pBuf, lBuf, AJCLNGSEL(TEXT("検索文字列 ：\x1B[34m%s"),
									  TEXT("Search String : \x1B[34m%s")), txt);
	return pBuf;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Find, WM_INITDIALOG	)
{
	PWRKVT100	pW = (PWRKVT100)lParam;

	SetProp(hDlg, L"AjcVthFind", pW);

	pW->hDlgFind = hDlg;
	pW->hWndCbo  = GetDlgItem(hDlg, IDC_CBO_FINDSTR);
	pW->hWndTxt  = AjcGetCtrlCboEditHandle(pW->hWndCbo);

	//	日英テキスト
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);
	SetWindowText (hDlg, LNGSEL(L"文字列検索", L"Find String"));
	SetDlgItemText(hDlg, IDC_LBL_FINDSTR	 , LNGSEL(L"検索文字列"											, L"Search String"												));
	SetDlgItemText(hDlg, IDC_CHK_SEMICOLON	 , LNGSEL(L"複数指定時は、セミコロン( ; )で区切る"				, L"When specifying multiple strings, separate them with semicolon( ; )." ));
	SetDlgItemText(hDlg, IDC_CHK_EXACTWIDTH	 , LNGSEL(L"大文字／小文字を区別する"							, L"Case sensitive"												));
	SetDlgItemText(hDlg, IDC_CHK_ASTARISK	 , LNGSEL(L"アスタリスク( * )を０桁以上の任意の文字列として扱う", L"Treat an asterisk ( * ) as any string of 0 or more digits"	));
	SetDlgItemText(hDlg, IDC_CHK_TRIM		 , LNGSEL(L"検索文字列両端の空白を無視する"						, L"Ignore spaces on both ends of search string"				));
	SetDlgItemText(hDlg, IDC_CHK_ENCLOSE	 , LNGSEL(L"ダブルクォート( \" )で囲んだ文字列は、純粋な文字列として扱う",
													  L"String enclosed in double quotes (\") is treated as a pure string."));
	SetDlgItemText(hDlg, IDC_CHK_CLOSE		 , LNGSEL(L"検索したら閉じる"									, L"Close after searching"				  						));
	if (pW->FindKey == VK_F3) {
		SetDlgItemText(hDlg, IDC_CMD_UP		 , LNGSEL(L"上検索 - Shift + F3"								, L"Search backward - Shift+F3"								));
		SetDlgItemText(hDlg, IDC_CMD_DOWN	 , LNGSEL(L"下検索 - F3"										, L"Search forward  - F3"  										));
	}
	else {
		SetDlgItemText(hDlg, IDC_CMD_UP		 , LNGSEL(L"上検索"												, L"Search backward"											));
		SetDlgItemText(hDlg, IDC_CMD_DOWN	 , LNGSEL(L"下検索"												, L"Search forward"  											));
	}
	SetDlgItemText(hDlg, IDC_CMD_CANCEL		 , LNGSEL(L"キャンセル"											, L"Cancel"  													));

	//	ツールチップ
	AjcTipTextAdd(pW->hWndTxt, TEXT(""));
	AjcTipTextSetCallBack(pW->hWndTxt, (UX)0, NULL, cbGetTipText);

	AjcTipTextAddW(GetDlgItem(hDlg, IDC_CHK_EXACTWIDTH),AJCLNGSEL (TEXT("英字の大文字と小文字を区別して比較する（”AAA”≠”aaa”）"),
																   TEXT("Case-sensitive comparison of alphabetic characters（\"AAA\" Not Equal \"aaa\"）"))); 

	AjcTipTextAddW(GetDlgItem(hDlg, IDC_CHK_SEMICOLON ), AJCLNGSEL(TEXT("複数の文字列を指定する場合は、セミコロン（ ; ）で区切って指定します。(ex. “ABC\x1B[T;\x1B[tXYZ”)"),
																   TEXT("To specify multiple strings, separate them with a semicolon ( ; )."))); 

	AjcTipTextAddW(GetDlgItem(hDlg, IDC_CHK_ASTARISK  ), AJCLNGSEL(TEXT("検索文字列中にアスタリスク(*)が存在する場合、当該文字を任意の（０桁以上の）文字列として扱います。\n")
																   TEXT("つまり、アスタリスク(*)で分離された文字列群は、文字列の出現順を示すことになります。\n")
																   TEXT("例えば、検索文字列= \"\x1B[31mBCD\x1B[0m*\x1B[31mOPQ\x1B[0m*\x1B[31mVWX\x1B[0m\" と指定した場合、\"\x1B[31mBCD\x1B[0m\"，\"\x1B[31mOPQ\x1B[0m\"，\"\x1B[31mVWX\x1B[0m\" が順に出現することを意味します。\n")
																   TEXT("この時、文字列 \"A\x1B[31mBCD\x1B[0mEFGHIJKLMN\x1B[31mOPQ\x1B[0mRSTU\x1B[31mVWX\x1B[0mYZ\" が存在する場合、検索文字列が「見つかった」と判断されます。\n"),
																   TEXT("If there is an asterisk (*) in the search string, it will be treated as any string (0 or more characters).\n")
																   TEXT("That is, strings separated by asterisks (*) indicate the order in which the strings appear.\n")
																   TEXT("For example, if you specify the search string = \"\x1B[31mBCD\x1B[0m*\x1B[31mOPQ\x1B[0m*\x1B[31mVWX\x1B[0m\", it means that \"\x1B[31mBCD\x1B[0m\", \"\x1B[31mOPQ\x1B[0m\", and \"\x1B[31mVWX\x1B[0m\" appear in that order.\n")
																   TEXT("In this case, if the string \"A\x1B[31mBCD\x1B[0mEFGHIJKLMN\x1B[31mOPQ\x1B[0mRSTU\x1B[31mVWX\x1B[0mYZ\" exists, the search string is considered to be 'found'."))); 

	AjcTipTextAddW(GetDlgItem(hDlg, IDC_CHK_TRIM	  ), AJCLNGSEL(TEXT("検索文字列両端の空白を除去します。(ex. \"  ABC DEF  \" -> \"ABC DEF\")\n")
																   TEXT("また、セミコロン( \x1B[T;\x1B[t )やアスタリスク( * )で分離された部分文字列も両端の空白を除去します。\n")
																   TEXT(" (ex. \"  ABC  \x1B[T;\x1B[t  DEF  \x1B[T;\x1B[t  123  *  456  \" -> \"ABC\x1B[T;\x1B[tDEF\x1B[T;\x1B[t123*456\" )"),
																   TEXT("Removes spaces from both ends of the search string.(ex. \"  ABC DEF  \" -> \"ABC DEF\")\n")
																   TEXT("Also, substrings separated by semicolons ( \x1B[T;\x1B[t ) or asterisks ( * ) will have whitespace removed from both ends too.\n")
																   TEXT(" (ex. \"  ABC  \x1B[T;\x1B[t  DEF  \x1B[T;\x1B[t  123  *  456  \" -> \"ABC\x1B[T;\x1B[tDEF\x1B[T;\x1B[t123*456\" )"))); 

	AjcTipTextAddW(GetDlgItem(hDlg, IDC_CHK_ENCLOSE	  ), AJCLNGSEL(TEXT("ダブルクォート( \" )で囲んだ文字列は、純粋な文字列として扱う\n")
																   TEXT("この文字列には、空白、セミコロン( ; )や、アスタリスク( * )を含めることができます。\n")
																   TEXT("但し、「\\」はエスケープ文字として機能し、「\\」の次の文字を有効とします。(「\\\"」 -> 「\"」, 「\\\\」->「\\」)"),
																   TEXT("A string enclosed in double quotes ( \" ) is treated as the string itself.\n")
																   TEXT("This string can contain spaces, semicolons ( ; ), and asterisks ( * ).")
																   TEXT("However, <\\> functions as an escape character and makes the next character valid.((\\\") -> (\"), (\\\\) -> (\\))")));

	AjcTipTextAddW(GetDlgItem(hDlg, IDC_CMD_UP		  ), AJCLNGSEL(TEXT("上方向に文字列の検索を行います\n")
																   TEXT("検索文字列にフォーカスがある状態で、Shift+F3 押下でも上検索可"),
																   TEXT("Searches upwards for a string\n")
																   TEXT("When the search string has focus, you can also search up by pressing Shift+F3"))); 
	AjcTipTextAddW(GetDlgItem(hDlg, IDC_CMD_DOWN	  ), AJCLNGSEL(TEXT("下方向に文字列の検索を行います\n")
																   TEXT("検索文字列にフォーカスがある状態で、F3 押下でも下検索可"),
																   TEXT("Searches downward for a string\n")
																   TEXT("When the search string has focus, you can also search down by pressing F3"))); 
	AjcTipTextAddW(GetDlgItem(hDlg, IDC_CMD_CANCEL	  ), AJCLNGSEL(TEXT("設定内容を保存しないで ダイアログを閉じます\n")
																   TEXT("設定内容を保存して終了するには、ダイアログ右上の\x1B[31m Ｘ \x1B[0mボタンを押します"),
																   TEXT("Close the dialog without saving the settings.\n")
																   TEXT("To save the settings and exit, click the \x1B[31mX\x1B[0m button in the upper right corner of the dialog."))); 
	AjcTipTextAddW(GetDlgItem(hDlg, IDC_CHK_CLOSE	  ), AJCLNGSEL(TEXT("上／下方向検索ボタンを押したら設定内容を退避してダイアログを閉じます"),
																   TEXT("Pressing the up/down search button will save the settings and close the dialog."))); 

	//	コンボボックスサブクラス化
	AjcSbcComboBoxEx(pW->hWndCbo, 40, MAX_FINDSTR - 1, AJCSBCF_IGNORWIDTH);
	AjcSbcTipCtrl (pW->hWndCbo, TRUE);

	//	ダイアログ／テキストボックスサブクラス化
	SetProp(pW->hWndTxt,  L"AjcVthFind", (HANDLE)pW);
	MAjcMmpSetSubclass( SbcTxt, hDlg);
	MAjcMmpSetSubclass( SbcTxt, pW->hWndTxt);

	//	プロファイルからロード
	if (pW->FindSect[0] != 0) {
		VthLoadStrFindInfo(pW);
		//	検索文字列コンボボックスのリスト情報ロード
		AjcSbcLoadItemsW(pW->hWndCbo, pW->FindSect);
	}

	//	ダイアログ項目設定
	AjcSetDlgItemChk (hDlg, IDC_CHK_EXACTWIDTH	, pW->fExactWidth);
	AjcSetDlgItemChk (hDlg, IDC_CHK_SEMICOLON	, pW->fSemicolon);
	AjcSetDlgItemChk (hDlg, IDC_CHK_ASTARISK	, pW->fAstarisk);
	AjcSetDlgItemChk (hDlg, IDC_CHK_TRIM		, pW->fTrim);
	AjcSetDlgItemChk (hDlg, IDC_CHK_ENCLOSE		, pW->fEnclose);
	AjcSetDlgItemChk (hDlg, IDC_CHK_CLOSE		, pW->fClose);
	AjcSetCtrlStrW(pW->hWndTxt, pW->SrhStr);

	//	ダイアログ移動
	{	RECT rect;
		GetWindowRect(pW->hBack, &rect);
		SetWindowPos(hDlg, NULL, rect.left + 20, rect.top + 10, 0, 0, SWP_NOSIZE);
		AjcMoveWndIntoMonitor(hDlg);
	}

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Find, WM_DESTROY	)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthFind");

	pW->hDlgFind = NULL;
	pW->hWndCbo  = NULL;
	pW->hWndTxt  = NULL;

	SetFocus(pW->hMain);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Find, IDC_CMD_UP	)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthFind");

	//	現表示項目を最新項目に設定
	AjcSbcSetMostNew(pW->hWndCbo);

	//	ダイアログ項目読み出し
	SubReadDialogItems(pW, hDlg);

	//	上方向検索
	AjcGetCtrlStr(pW->hWndTxt, pW->SrhStr, MAX_FINDSTR);
	AjcVthSearchAboveExW(pW->hBack, pW->SrhStr, 
						 pW->fSemicolon ? L";" : NULL,
						 pW->fAstarisk	? L"*" : NULL,
						 pW->fEnclose	? L"\"": NULL,
						 pW->fTrim, !pW->fExactWidth);

	if (AjcGetDlgItemChk(hDlg, IDC_CHK_CLOSE)) {
		//	セーブして終了
		SendMessage(hDlg, WM_COMMAND, MAKELONG(IDCANCEL, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDCANCEL));
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Find, IDC_CMD_DOWN	)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthFind");

	//	現表示項目を最新項目に設定
	AjcSbcSetMostNew(pW->hWndCbo);

	//	ダイアログ項目読み出し
	SubReadDialogItems(pW, hDlg);

	//	下方向検索
	AjcGetCtrlStr(pW->hWndTxt, pW->SrhStr, MAX_FINDSTR);
	AjcVthSearchBelowExW(pW->hBack, pW->SrhStr, 
						 pW->fSemicolon ? L";" : NULL,
						 pW->fAstarisk	? L"*" : NULL,
						 pW->fEnclose	? L"\"": NULL,
						 pW->fTrim, !pW->fExactWidth);

	if (AjcGetDlgItemChk(hDlg, IDC_CHK_CLOSE)) {
		//	セーブして終了
		SendMessage(hDlg, WM_COMMAND, MAKELONG(IDCANCEL, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDCANCEL));
	}
	return TRUE;
}
//----- セーブしないで終了 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Find, IDC_CMD_CANCEL)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthFind");

	DestroyWindow(hDlg);
	return TRUE;
}
//----- セーブして終了 -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Find, IDCANCEL		)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthFind");

	//	ダイアログ項目読み出し
	SubReadDialogItems(pW, hDlg);

	//	プロファイルへセーブ
	if (pW->FindSect[0] != 0) {
		VthSaveStrFindInfo(pW);
		//	検索文字列コンボボックスのリスト情報セーブ
		AjcSbcSaveItemsW(pW->hWndCbo, pW->FindSect);
	}

	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Find)
	AJC_DLGMAP_MSG(Find, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Find, WM_DESTROY		)
	AJC_DLGMAP_CMD(Find, IDC_CMD_UP		)
	AJC_DLGMAP_CMD(Find, IDC_CMD_DOWN	)
	AJC_DLGMAP_CMD(Find, IDC_CMD_CANCEL	)
	AJC_DLGMAP_CMD(Find, IDCANCEL		)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	テキストボックスのサブクラスプロシージャ																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcTxt, WM_KEYDOWN		)
{
	LRESULT	rc = 0;
	PWRKVT100	pW = (PWRKVT100)GetProp(hwnd, L"AjcVthFind");

	if (wParam == pW->FindKey) {
		if (GetKeyState(VK_CONTROL) >= 0 && GetKeyState(VK_MENU) >= 0) {
			//	ダイアログ項目読み出し
			SubReadDialogItems(pW, pW->hDlgFind);
			//	文字列検索
			if (GetKeyState(VK_SHIFT) < 0) {	//	Shift + F3
				//	上方向検索
				AjcGetCtrlStr(pW->hWndTxt, pW->SrhStr, MAX_FINDSTR);
				AjcVthSearchAboveExW(pW->hBack, pW->SrhStr, 
									 pW->fSemicolon ? L";" : NULL,
									 pW->fAstarisk	? L"*" : NULL,
									 pW->fEnclose	? L"\"": NULL,
									 pW->fTrim, !pW->fExactWidth);
			}
			else {								//	F3
				//	下方向検索
				AjcGetCtrlStr(pW->hWndTxt, pW->SrhStr, MAX_FINDSTR);
				AjcVthSearchBelowExW(pW->hBack, pW->SrhStr, 
									 pW->fSemicolon ? L";" : NULL,
									 pW->fAstarisk	? L"*" : NULL,
									 pW->fEnclose	? L"\"": NULL,
									 pW->fTrim, !pW->fExactWidth);
			}
		}
		rc = 0;
	}
	else {
		rc = MAjcMmpCallOrgWndProc(SbcTxt);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcTxt, WM_KEYUP		)
{
	LRESULT	rc = 0;
	PWRKVT100	pW = (PWRKVT100)GetProp(hwnd, L"AjcVthFind");

	if (wParam == pW->FindKey) {
		rc = 0;
	}
	else {
		rc = MAjcMmpCallOrgWndProc(SbcTxt);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SbcTxt)
AJC_WNDMAP_MSG(SbcTxt, WM_KEYDOWN	)
AJC_WNDMAP_MSG(SbcTxt, WM_KEYUP		)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ダイアログ項目読み出し																						//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubReadDialogItems(PWRKVT100 pW, HWND hDlg)
{
	pW->fExactWidth = AjcGetDlgItemChk(hDlg, IDC_CHK_EXACTWIDTH);
	pW->fSemicolon	= AjcGetDlgItemChk(hDlg, IDC_CHK_SEMICOLON);
	pW->fAstarisk	= AjcGetDlgItemChk(hDlg, IDC_CHK_ASTARISK);
	pW->fTrim		= AjcGetDlgItemChk(hDlg, IDC_CHK_TRIM);
	pW->fEnclose	= AjcGetDlgItemChk(hDlg, IDC_CHK_ENCLOSE);
	pW->fClose		= AjcGetDlgItemChk(hDlg, IDC_CHK_CLOSE);
	AjcGetCtrlStrW(pW->hWndTxt, pW->SrhStr, AJCTSIZE(pW->SrhStr));
}
//==============================================================================================================//
//	文字列検索開始位置リセット（次回検索時、検索開始位置をウインド上端／下端とする）							//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pStr		- 検索文字列																		//
//				delimiter	- 区切り文字（０の場合は区切り文字無し）											//
//																												//
//	戻り値	：	≠ -1 : 行スクロール位置																		//
//				＝ -1 : エラー																					//
//==============================================================================================================//
VO		VthResetFindSrtPos(PWRKVT100 pW)
{
	pW->fResetPos = TRUE;
}
//==============================================================================================================//
//	文字列検索情報ロード（セクションが無い場合はデフォルト設定）												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//																												//
//	戻り値	：	≠ -1 : 行スクロール位置																		//
//				＝ -1 : - エラー																				//
//==============================================================================================================//
VO		VthLoadStrFindInfo(PWRKVT100 pW)
{
	pW->fExactWidth = AjcGetProfileUInt(pW->FindSect, L"fExactWidth", FALSE);
	pW->fSemicolon	= AjcGetProfileUInt(pW->FindSect, L"fSemicolon" , FALSE);
	pW->fAstarisk	= AjcGetProfileUInt(pW->FindSect, L"fAstarisk"	, FALSE);
	pW->fTrim		= AjcGetProfileUInt(pW->FindSect, L"fTrim"		, FALSE);
	pW->fEnclose	= AjcGetProfileUInt(pW->FindSect, L"fEnclose"	, FALSE);
	pW->fClose		= AjcGetProfileUInt(pW->FindSect, L"fClose" 	, FALSE);
	AjcGetProfileStr(pW->FindSect, L"SrhStr", L"", pW->SrhStr, AJCTSIZE(pW->SrhStr));
}
//==============================================================================================================//
//	文字列検索情報セーブ																						//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//																												//
//	戻り値	：	≠ -1 : 行スクロール位置																		//
//				＝ -1 : - エラー																				//
//==============================================================================================================//
VO		VthSaveStrFindInfo(PWRKVT100 pW)
{
	if (pW->FindSect[0] != 0) {
		AjcPutProfileUInt(pW->FindSect, L"fExactWidth", pW->fExactWidth);
		AjcPutProfileUInt(pW->FindSect, L"fSemicolon" , pW->fSemicolon );
		AjcPutProfileUInt(pW->FindSect, L"fAstarisk"  , pW->fAstarisk  );
		AjcPutProfileUInt(pW->FindSect, L"fTrim"	  , pW->fTrim	   );
		AjcPutProfileUInt(pW->FindSect, L"fEnclose"   , pW->fEnclose   );
		AjcPutProfileUInt(pW->FindSect, L"fClose"	  , pW->fClose	   );
		AjcPutProfileStr (pW->FindSect, L"SrhStr"	  , pW->SrhStr);
	}
}
//==============================================================================================================//
//	文字列の下方向検索とスクロール																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pStr		- 検索文字列																		//
//				pDlm		- 区切り文字（NULLの場合は区切り文字無し）											//
//				pAny		- ０桁以上の任にの文字列と認識する文字（NULLの場合は認識しない）					//
//				pEnc		- 過去も文字（NULLの場合は囲み文字無し）											//
//				fTrim		- TRUE : 検索文字列両端の空白除去													//
//				fIgnoreWidth- TRUE : 英字の大小を区別しない														//
//																												//
//	戻り値	：	≠ -1 : 行スクロール位置																		//
//				＝ -1 : - エラー																				//
//==============================================================================================================//
//----- ワイド文字（文字列の下方向検索とスクロール（拡張）） ---------------------------------------------------//
UI		VthFindStrBelowW(PWRKVT100 pW, C_WCP pStr, C_WCP pDlm, C_WCP pAny, C_WCP pEnc, BOOL fTrim, BOOL fIgnoreWidth)
{
	UI				rc	  = -1;
	int				lTxt;					//	テキストバッファ長
	WCP				pTxt = NULL;			//	テキストバッファポインタ
	int				xSrt, ySrt;				//	文字列検索位置
	int				stl  = 0;				//	検索文字列長
	AJCSTRFIND		info;					//	文字列検出情報
	POINT			sp;						//	検索位置

	if (*pStr != 0) {
		//	ツールチップを消す
		AjcTipTextHide();
		do {
			//	パラメタチェック
			if (pStr == NULL) break;
			//	テキストバッファ確保
			lTxt = pW->prop.VramW + 1;
			if ((pTxt = AjcTAllocW(lTxt)) == NULL) break;
			//	スクロール等で検索位置リセット要ならば、検索開始位置＝ウインド上端
			if (pW->fResetPos) {
				//	フラグ解除
				pW->fResetPos = FALSE;
				//	検索開始位置ウインド上端
				pW->SrhPos.y = VthIxToLno(pW, pW->IxWTop);
				pW->SrhPos.x = 0;
				//	検索位置の行テキスト取得
				AjcVthGetLineTextW(pW->hBack, pW->SrhPos.y, pTxt, lTxt);
				//	検索開始位置設定（次の位置）
				memcpy(&sp, &pW->SrhPos, sizeof(POINT));
			}
			//	続けて検索ならば、検索開始位置＝次の桁位置
			else {
				//	検索位置の行テキスト取得
				AjcVthGetLineTextW(pW->hBack, pW->SrhPos.y, pTxt, lTxt);
				//	検索開始位置設定（次の位置）
				memcpy(&sp, &pW->SrhPos, sizeof(POINT));
				SubSetNxtPoint(pW, pTxt, lTxt, &sp);
			}
			//	検索開始位置退避
			ySrt = sp.y;
			xSrt = sp.x;
			//	文字列の検索処理
			while (sp.y < (int)pW->LCnt) {
				//	行テキスト内検索
				if (fIgnoreWidth) stl = AjcStrIFindExW(pTxt + sp.x, pStr, pDlm, pAny, pEnc, fTrim, 0, &info);
				else			  stl = AjcStrFindExW (pTxt + sp.x, pStr, pDlm, pAny, pEnc, fTrim, 0, &info);
				//	文字列が見つかった・・
				if (stl > 0) {
					//	スクロール
					SubFindScroll(pW, pTxt, sp.y, sp.x + info.pos, stl);
					//	文字列選択
					AjcVthSelect(pW->hBack, sp.y, sp.x + info.pos, sp.y, sp.x + info.pos + stl);
					//	検索位置＝見つかった文字列位置
					sp.x += info.pos;
					//	見つかった位置設定
					memcpy(&pW->SrhPos, &sp, sizeof(POINT));
					//	終了
					break;
				}
				//	文字列は見つからない
				else {
					//	行スキップの為、行末の位置を設定
					sp.x = (int)wcslen(pTxt);
					//	次の検索位置設定（行位置オーバーならば終了）
					if (SubSetNxtPoint(pW, pTxt, lTxt, &sp)) {
						break;
					}
				}
			}
			//	戻り値＝行スクロール位置
			rc = VthIxToLno(pW, pW->IxWTop);
		} while(0);
		//	文字列が見つからない場合・・
		if (stl <= 0) {
			WC	txt[128];
			//	ツールチップ表示
			AjcSnPrintFW(txt, AJCTSIZE(txt), AJCLNGSEL(L"\n\x1B[31m  行=%d, 桁=%d から前方検索  \n"
														   L"\x1B[T  文字列が見つかりません  \n",
													   L"\n\x1B[31m  Search forward from line=%d, column=%d  \n"
														   L"\x1B[T  Strings not found  \n"), ySrt, xSrt);
			AjcTipTextShowCenterW(pW->hBack, txt, 2000, NULL);
		}
		//	テキストバッファ解放
		if (pTxt != NULL) AjcTFree(pTxt);
	}
	return rc;
}
//==============================================================================================================//
//	文字列の上方向検索とスクロール																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pStr		- 検索文字列																		//
//				pDlm		- 区切り文字（NULLの場合は区切り文字無し）											//
//				pAny		- ０桁以上の任にの文字列と認識する文字（NULLの場合は認識しない）					//
//				pEnc		- 過去も文字（NULLの場合は囲み文字無し）											//
//				fTrim		- TRUE : 検索文字列両端の空白除去													//
//				fIgnoreWidth- TRUE : 英字の大小を区別しない														//
//																												//
//	戻り値	：	≠ -1 : 行スクロール位置																		//
//				＝ -1 : エラー																					//
//==============================================================================================================//
//----- ワイド文字（文字列の上方向検索とスクロール（拡張）） ---------------------------------------------------//
UI		VthFindStrAboveW(PWRKVT100 pW, C_WCP pStr, C_WCP pDlm, C_WCP pAny, C_WCP pEnc, BOOL fTrim, BOOL fIgnoreWidth)
{
	UI				rc	  = -1;
	int				lTxt;					//	テキストバッファ長
	WCP				pTxt = NULL;			//	テキストバッファポインタ
	int				xSrt, ySrt;				//	文字列検索位置
	int				stl = 0;				//	検索文字列長
	AJCSTRFIND		info;
	POINT			sp;						//	検索位置

	if (*pStr != 0) {
		//	ツールチップを消す
		AjcTipTextHide();
		do {
			//	パラメタチェック
			if (pStr == NULL) break;
			//	テキストバッファ確保
			lTxt = pW->prop.VramW + 1;
			if ((pTxt = AjcTAllocW(lTxt)) == NULL) break;
			//	スクロール等で検索位置リセット要ならば、検索開始位置＝ウインド下端
			if (pW->fResetPos) {
				//	フラグ解除
				pW->fResetPos = FALSE;
				//	検索開始位置ウインド下端
				pW->SrhPos.y = VthIxToLno(pW, pW->IxWTop) + (pW->wh / pW->cyChar);
				if (pW->LCnt > 0) pW->SrhPos.y = __min(pW->SrhPos.y, (LONG)(pW->LCnt - 1));
				else			  pW->SrhPos.y = 0;
				pW->SrhPos.x = 0;
				//	検索位置の行テキスト取得
				AjcVthGetLineTextW(pW->hBack, pW->SrhPos.y, pTxt, lTxt);
				//	検索開始位置設定
				memcpy(&sp, &pW->SrhPos, sizeof(POINT));
			}
			//	続けて検索ならば、検索開始位置＝次の桁位置
			else {
				//	検索位置の行テキスト取得
				AjcVthGetLineTextW(pW->hBack, pW->SrhPos.y, pTxt, lTxt);
				//	検索開始位置設定（１つ前の位置）
				memcpy(&sp, &pW->SrhPos, sizeof(POINT));
				SubSetBfrPoint(pW, pTxt, lTxt, &sp);
			}
			//	検索開始位置退避
			ySrt = sp.y;
			xSrt = sp.x;
			//	テキスト先頭行までループ
			do {
				//	行頭までループ
				do {
					//	行テキスト行内検索
					if (fIgnoreWidth) stl = AjcStrIFindExW(pTxt + sp.x, pStr, pDlm, pAny, pEnc, fTrim, AJCSFO_HIGHPOS, &info);
					else			  stl = AjcStrFindExW (pTxt + sp.x, pStr, pDlm, pAny, pEnc, fTrim, AJCSFO_HIGHPOS, &info);
					//	検索開始位置の左側で見つかった文字列あり
					if ((stl > 0) && (sp.y < ySrt || (sp.y == ySrt && sp.x + info.pos <= xSrt))) {
						//	スクロール
						SubFindScroll(pW, pTxt, sp.y, sp.x + info.pos, stl);
						//	文字列選択
						AjcVthSelect(pW->hBack, sp.y, sp.x + info.pos, sp.y, sp.x + info.pos + stl);
						//	検索位置＝見つかった文字列位置
						sp.x += info.pos;
						//	見つかった位置設定
						memcpy(&pW->SrhPos, &sp, sizeof(POINT));
						//	終了
						goto vfs_exit;
					}
					//	見つからない旨設定
					else stl = 0;	
					//	1つ前の桁位置設定
					if (sp.x > 0) sp.x--;
					//	行頭の場合は、前の行へ・・
					else break;
				} while (sp.x >= 0);
			} while (!SubSetBfrPoint(pW, pTxt, lTxt, &sp));	//	行アンダーフローまでループ
vfs_exit:;
		} while(0);

		//	文字列が見つからない場合・・
		if (stl <= 0) {
			WC	txt[128];
			//	ツールチップ表示
			AjcSnPrintFW(txt, AJCTSIZE(txt), AJCLNGSEL(L"\n\x1B[31m  行=%d, 桁=%d から後方検索  \n"
														   L"\x1B[T  文字列が見つかりません  \n",
													   L"\n\x1B[31m  Search backward from line=%d, column=%d  \n"
														   L"\x1B[T  Strings not found  \n"), ySrt, xSrt);
			AjcTipTextShowCenterW(pW->hBack, txt, 2000, NULL);
		}
		//	テキストバッファ解放
		if (pTxt != NULL) AjcTFree(pTxt);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	１つ次の検索位置設定																						//
//																												//
//	引　数	：	pW		- インスタンスワーク																	//
//				pTxt	- 現テキスト																			//
//				lTxt	- テキストバッファサイズ																//
//				pPos	- 検索位置																				//
//																												//
//	戻り値	：	TRUE	- 行位置オーバーフロー																	//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubSetNxtPoint(PWRKVT100 pW, WCP pTxt, UI lTxt, LPPOINT pPos)
{
	BOOL	rc = FALSE;

	//	現文字＝サロゲート1文字目
	if (MAjcIsLeadW(pTxt[pPos->x])) {
		pPos->x++;
		if (MAjcIsTrailW(pTxt[pPos->x])) {
			pPos->x++;
		}
	}
	//	現文字＝サロゲート１文字目以外
	else {
		//	行末以外ならば、１文字進める
		if (pTxt[pPos->x] != 0) {
			pPos->x++;
		}
		//	行末ならば、直後の行を読み出し、行頭設定
		else {
			pPos->y++;
			pPos->x = 0;
			if (pPos->y < (int)pW->LCnt) {
				AjcVthGetLineTextW(pW->hBack, pPos->y, pTxt, lTxt);
				pPos->x = 0;
			}
			//	行位置オーバーフロー
			else {
				pPos->y = pW->LCnt;
				pPos->x = 0;
				rc = TRUE;
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	１つ前の検索位置設定																						//
//																												//
//	引　数	：	pW		- インスタンスワーク																	//
//				pPos	- 検索位置																				//
//																												//
//	戻り値	：	TRUE	- 行位置アンダーフロー																	//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubSetBfrPoint(PWRKVT100 pW, WCP pTxt, UI lTxt, LPPOINT pPos)
{
	BOOL	rc = FALSE;

	//	行頭以外ならば、１文字戻す
	if (pPos->x >= 1) {
		pPos->x--;
		//	サロゲート２ワード目ならば、さらに１つ戻す
		if (MAjcIsTrailW(pTxt[pPos->x])) {
			if (pPos->x > 0) {
				pPos->x--;
			}
		}
	}
	//	行頭ならば・・
	else {
		//	先頭行以外ならば、前行を読み出し、行末設定
		if (pPos->y > 0) {
			pPos->y--;
			AjcVthGetLineTextW(pW->hBack, pPos->y, pTxt, lTxt);
			pPos->x = (int)wcslen(pTxt);
		}
		//	行位置アンダーフロー
		else {
			pPos->y = 0;
			pPos->x = 0;
			rc = TRUE;
		}
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	検索文字を表示するようにスクロール																			//
//																												//
//	引　数	：	pW		- インスタンスワーク																	//
//				pLine	- 文字列が見つかった行テキスト															//
//				lp		- 文字列が見つかった行位置																//
//				cp		- 文字列が見つかった桁位置																//
//				stl		- 文字列の長さ																			//
//																												//
//	戻り値	：	≠NULL - 選択中のテキストあり（バッファにテキストを格納した）									//
//				＝NULL - 選択中のテキストなし/バッファ確保不能													//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubFindScroll(PWRKVT100 pW, C_WCP pLine, int lp, int cp, int stl)
{
	HDC				hdc;
	int				wcp, wlp;	//	ウインドの左端桁位置，上端行位置
	int				wcy;		//	ウインドの行数
	int				pws;		//	テキスト先頭～ウインド先頭までのピクセル数
	int				pxs;		//	ウインド先頭～検索文字列先頭までのピクセル数
	int				pxe;		//	ウインド先頭～検索文字列末尾までのピクセル数
	int				ov;			//	ウインド右端をオーバーする文字数
	SIZE			sz;			//	ピスクsる数取得ワーク
	//	ＤＣ取得
	hdc = GetDC(pW->hMain);
	//	ウインドの左端桁位置，上端行位置設定
	wcp = pW->IxOfs;
	wlp = VthIxToLno(pW, pW->IxWTop);
	//	ウインドの行数算出
	wcy	= pW->wh / pW->cyChar;
	//	テキスト先頭～ウインド先頭までのピクセル数算出
	pws		= pW->cxChar * wcp;
	//	ウインド先頭～検索文字列先頭までのピクセル数算出
	VthGetTextExtentPoint(pW, hdc, pLine, cp	  , &sz);
	pxs = sz.cx - pws;
	//	ウインド先頭～検索文字列末尾までのピクセル数算出
	VthGetTextExtentPoint(pW, hdc, pLine, cp + stl, &sz);
	pxe = sz.cx - pws;
	//	検索文字列のピクセル数
	VthGetTextExtentPoint(pW, hdc, pLine + cp, stl, &sz);
	//	スクロール文字位置設定
	if (sz.cx > (int)pW->ww) {						//	検索文字列がウインド幅より大きい？
		pW->ScrPos.x = cp;
	}
	else if (pxs < 0) {								//	検索文字列先頭がウインド左端より左？
		int		len = (-pxs / pW->cxChar);
		if (wcp >= len) pW->ScrPos.x = wcp - len;
		else			pW->ScrPos.x = 0;
	}
	else if (pxe > (int)pW->ww) {					//	検索文字列末尾がウインド右端より右？
		ov = (pxe - pW->ww) / pW->cxChar + 1;
		pW->ScrPos.x = wcp + ov;
	}
	else {											//	検索文字列はウインド内？
		pW->ScrPos.x = wcp;
	}
	//	スクロール行位置設定
	if (lp < wlp  ||  lp >= wlp + wcy) {			//	検索行はウインド範囲外？
		if (lp >= (wcy / 2)) pW->ScrPos.y = lp - (wcy / 2);
		else				 pW->ScrPos.y = 0;
	}
	else {											//	検索行はウインド範囲内？
		pW->ScrPos.y = wlp;							//		スクロール無し（現行位置設定）
	}
	//	スクロール
	AjcVthSetHScrollPos(pW->hBack, pW->ScrPos.x);
	AjcVthSetVScrollPos(pW->hBack, pW->ScrPos.y);
	//	ＤＣ解放
	ReleaseDC(pW->hMain, hdc);
}
