﻿#include	"AjcInternal.h"
#include	"AjcCtrlVT100Def.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		その他の設定ダイアログ								//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Other);

//==============================================================================================================//
//																												//
//	その他の設定ダイアログ生成																					//
//																												//
//==============================================================================================================//
HWND	VthCreateDlgSetOther(PWRKVT100 pW)
{
	HWND	rc = NULL;
	rc = (HWND)DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_VTHSETOTHER), pW->hMain, AJC_DLGPROC_NAME(Other), (LPARAM)pW);
	return	rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	その他の設定ダイアログプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Other, WM_INITDIALOG	)
{
	PWRKVT100	pW = (PWRKVT100)lParam;

	SetProp(hDlg, L"AjcVthOther", pW);

	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);
	SetWindowText (hDlg, LNGSEL(L"その他の設定", L"Set Others"));
	SetDlgItemText(hDlg, IDC_VTHLBL_VRAMW	 , LNGSEL(L"描画メモリの文字数 (※1)"  , L"Drawing memory width  (*1)" ));
	SetDlgItemText(hDlg, IDC_VTHLBL_VRAMH	 , LNGSEL(L"描画メモリの行数   (※1)"  , L"Drawing memory height (*1)" ));
	SetDlgItemText(hDlg, IDC_VTHLBL_MAXLINES , LNGSEL(L"最大行数 (※1)"			   , L"Max lines (*1)"			   ));
	SetDlgItemText(hDlg, IDC_VTHLBL_TABSTEP	 , LNGSEL(L"タブステップ数"			   , L"Tab step"				   ));
	SetDlgItemText(hDlg, IDC_VTHLBL_LSPACE	 , LNGSEL(L"行間スペース"			   , L"Line space"				   ));
	SetDlgItemText(hDlg, IDC_VTHLBL_PENDSIZE , LNGSEL(L"最大描画テキスト保留サイズ", L"Drawing text pending size"  ));
	SetDlgItemText(hDlg, IDC_VTHLBL_NOTE	 , LNGSEL(L"※1: これらの値を変更すると,画面がクリアーされます。",
													  L"*1 : Changing these values will clear the screen."	));
	SetDlgItemText(hDlg, IDOK				 , LNGSEL(L"ＯＫ"					   , L"OK"					));
	SetDlgItemText(hDlg, IDCANCEL			 , LNGSEL(L"キャンセル"				   , L"Cancel"				));

	AjcSetDlgItemUInt(hDlg, IDC_VTHTXT_VRAMW	, pW->prop.VramW		  );
	AjcSetDlgItemUInt(hDlg, IDC_VTHTXT_VRAMH	, pW->prop.VramH		  );
	AjcSetDlgItemUInt(hDlg, IDC_VTHTXT_MAXLINES , pW->prop.MaxLines		  );
	AjcSetDlgItemUInt(hDlg, IDC_VTHTXT_TABSTEP	, pW->prop.TabStep		  );
	AjcSetDlgItemUInt(hDlg, IDC_VTHTXT_LSPACE	, pW->prop.LSpace		  );
	AjcSetDlgItemUInt(hDlg, IDC_VTHTXT_PENDSIZE , pW->prop.PendSize / 1024);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Other, IDOK			)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthOther");
	AJCVTHPROP	prop;

	memcpy(&prop, &pW->prop, sizeof(AJCVTHPROP));

	prop.VramW	  = AjcGetDlgItemUInt(hDlg, IDC_VTHTXT_VRAMW	);
	prop.VramH	  = AjcGetDlgItemUInt(hDlg, IDC_VTHTXT_VRAMH	);
	prop.MaxLines = AjcGetDlgItemUInt(hDlg, IDC_VTHTXT_MAXLINES );
	prop.TabStep  = AjcGetDlgItemUInt(hDlg, IDC_VTHTXT_TABSTEP	);
	prop.LSpace	  = AjcGetDlgItemUInt(hDlg, IDC_VTHTXT_LSPACE	);
	prop.PendSize = AjcGetDlgItemUInt(hDlg, IDC_VTHTXT_PENDSIZE ) * 1024;

	if (pW->LCnt != 0 && (prop.VramW	!= pW->prop.VramW ||
						  prop.VramH	!= pW->prop.VramH ||
						  prop.MaxLines != pW->prop.MaxLines)) {
		if (MessageBox(hDlg, LNGSEL(L"この設定を行うと、表示内容がクリアーされます。よろしいですか？",
									L"This setting clears the displayed contents. Are you sure you want to do this?"), AppName, MB_YESNO) == IDYES) {
			VthSetCtrlProp(pW, &prop);
		}
	}
	else {
		VthSetCtrlProp(pW, &prop);
	}
	EndDialog(hDlg, IDOK);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Other, IDCANCEL		)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthOther");

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Other)
	AJC_DLGMAP_MSG(Other, WM_INITDIALOG	)
	AJC_DLGMAP_CMD(Other, IDOK			)
	AJC_DLGMAP_CMD(Other, IDCANCEL		)
AJC_DLGMAP_END
