﻿#include	"AjcInternal.h"
#include	"AjcCtrlVT100Def.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		ファイルへセーブ ダイアログ							//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(SaveToFile);

//==============================================================================================================//
//																												//
//	テキストをファイルへセーブ ダイアログ生成																	//
//																												//
//==============================================================================================================//
HWND	VthCreateDlgSaveToFile(PWRKVT100 pW)
{
	HWND	rc = NULL;
	rc = (HWND)DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_VTHSAVETOFILE), pW->hMain, AJC_DLGPROC_NAME(SaveToFile), (LPARAM)pW);
	return	rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	テキストをファイルへセーブ ダイアログプロシージャ															//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SaveToFile, WM_INITDIALOG	)
{
	PWRKVT100	pW = (PWRKVT100)lParam;

	SetProp(hDlg, L"AjcVthSaveToFile", pW);

	//----- 日英テキスト ---------------------------------------------------------------------------------------//
	SetWindowText (hDlg, LNGSEL(L"テキストをファイルへセーブ", L"Save text to file"));
	SetDlgItemText(hDlg, IDC_LBL_FILE			, LNGSEL(L"ファイル・パス"		, L"File path"		));
	SetDlgItemText(hDlg, IDC_GRP_FORMAT	 		, LNGSEL(L"形式"				, L"Format"	   		));
	SetDlgItemText(hDlg, IDC_RBT_TEXT			, LNGSEL(L"テキスト"			, L"TEXT"			));
	SetDlgItemText(hDlg, IDC_LBL_FONTSIZE		, LNGSEL(L"フォントサイズ"		, L"Font size"		));
	SetDlgItemText(hDlg, IDC_GRP_ENCODE			, LNGSEL(L"テキスト エンコード"	, L"Text Encode"	));
	SetDlgItemText(hDlg, IDC_RBT_MBC			, szMyMbc											 );
	SetDlgItemText(hDlg, IDC_CHK_BOM			, LNGSEL(L"ＢＯＭを付加する"	, L"Write BOM"		));
	SetDlgItemText(hDlg, IDC_GRP_OUTPUT			, LNGSEL(L"出力範囲"			, L"Output range"	));
	SetDlgItemText(hDlg, IDC_RBT_ALL	 		, LNGSEL(L"全テキスト"			, L"All text"		));
	SetDlgItemText(hDlg, IDC_RBT_SEL 			, LNGSEL(L"選択されている部分"	, L"Selected part"	));
	SetDlgItemText(hDlg, IDOK		 			, LNGSEL(L"ＯＫ"				, L"OK"				));
	SetDlgItemText(hDlg, IDCANCEL	 			, LNGSEL(L"キャンセル"			, L"Cancel"			));

	//----- ラジオボタングループ化 -----------------------------------------------------------------------------//
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_FORMAT));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_ENCODE));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_OUTPUT));

	//----- S-JIS以外の場合、「EUC」非表示 ---------------------------------------------------------------------//
	if (CpInfo.CodePage != CP_932) {
		//	「EUC」非表示
		ShowWindow(GetDlgItem(hDlg, IDC_RBT_EUC), SW_HIDE);
		//	「EUC」→「MBC」に訂正
		if (pW->SvTxtEncode == 2) pW->SvTxtEncode = 0;
	}

	//----- 項目設定 -------------------------------------------------------------------------------------------//
	AjcSetDlgItemUInt(hDlg, IDC_GRP_FORMAT	, pW->SvTxtFormat  );
	AjcSetDlgItemUInt(hDlg, IDC_GRP_ENCODE	, pW->SvTxtEncode  );
	AjcSetDlgItemUInt(hDlg, IDC_GRP_OUTPUT	, pW->SvTxtOutput  );
	AjcSetDlgItemUInt(hDlg, IDC_INP_FONTSIZE, pW->SvTxtFontSize);
	AjcSetDlgItemChk (hDlg, IDC_CHK_BOM 	, pW->SvBom 	   );
	AjcSetDlgItemStr (hDlg, IDC_TXT_FILE	, pW->SvTxtPath    );

	//----- ラジオボタン ダミークリック ------------------------------------------------------------------------//
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_FORMAT, AJCRBTN_SELECT), pW->SvTxtFormat);
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_ENCODE, AJCRBTN_SELECT), pW->SvTxtEncode);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SaveToFile, IDC_CMD_FILE	)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthSaveToFile");
	WCP		pFilt, pExt;
	WC		path[MAX_PATH];

	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetDlgItemUInt(hDlg, IDC_GRP_FORMAT) == 0) {pExt = L"txt";  pFilt = L"Text(*.txt)/*.txt/AllFiles(*.*)/*.*";}
		else											  {pExt = L"html"; pFilt = L"HTML(*.html)/*.html/HTML(*.htm)/*.htm/AllFiles(*.*)/*.*";}
		AjcSnPrintF(path, AJCTSIZE(path), L"%s", pW->SvTxtPath);
		if (AjcGetSaveFile(hDlg, LNGSEL(L"テキストをファイルへセーブ", L"Save text to file"), pFilt, pExt, path, MAX_PATH)) {
			AjcSnPrintF(pW->SvTxtPath, AJCTSIZE(pW->SvTxtPath), L"%s", path);
			AjcSetDlgItemStr(hDlg, IDC_TXT_FILE, path);
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SaveToFile, IDC_GRP_FORMAT	)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthSaveToFile");

	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		if (lParam == 0) {		//	TEXT?
			AjcEnableDlgGroup(hDlg, IDC_GRP_ENCODE	, TRUE, TRUE );
			AjcEnableDlgGroup(hDlg, IDC_GRP_FONTSIZE, TRUE, FALSE);
			//	ラジオボタン ダミークリック
			SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_ENCODE, AJCRBTN_SELECT), pW->SvTxtEncode);
		}
		else {					//	HTML?
			AjcEnableDlgGroup(hDlg, IDC_GRP_ENCODE	, TRUE, FALSE);
			AjcEnableDlgGroup(hDlg, IDC_GRP_FONTSIZE, TRUE, TRUE );
		}
	}

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SaveToFile, IDC_GRP_ENCODE	)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthSaveToFile");

	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		if (lParam == 1 || lParam == 3 || lParam == 4) {	//	UTF-8, UTF-16LE or UTF-16BE ?
			AjcEnableDlgItem(hDlg, IDC_CHK_BOM, TRUE);
		}
		else {
			AjcEnableDlgItem(hDlg, IDC_CHK_BOM, FALSE);
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SaveToFile, IDOK			)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthSaveToFile");
	EAJCTEC		tec = AJCTEC_MBC;
	BOOL		rsu;

	//	設定項目退避
	pW->SvTxtFormat   = (UB)AjcGetDlgItemUInt(hDlg, IDC_GRP_FORMAT	);
	pW->SvTxtEncode   = (UB)AjcGetDlgItemUInt(hDlg, IDC_GRP_ENCODE	);
	pW->SvTxtOutput   = (UB)AjcGetDlgItemUInt(hDlg, IDC_GRP_OUTPUT	);
	pW->SvTxtFontSize = (UB)AjcGetDlgItemUInt(hDlg, IDC_INP_FONTSIZE);
	pW->SvBom		  = 	AjcGetDlgItemChk (hDlg, IDC_CHK_BOM 	);
	AjcGetDlgItemStr(hDlg, IDC_TXT_FILE, pW->SvTxtPath, AJCTSIZE(pW->SvTxtPath));

	//	文字コード種別設定
	switch (pW->SvTxtEncode) {
		default:
		case 0:  tec = AJCTEC_MBC;		break;
		case 1:  tec = AJCTEC_UTF_8;	break;
		case 2:  tec = AJCTEC_EUC_J;	break;
		case 3:  tec = AJCTEC_UTF_16LE;	break;
		case 4:  tec = AJCTEC_UTF_16BE;	break;
	}
	//	グレー化
	AjcEnableCtrlsInWnd(hDlg, FALSE);

	//	ファイル書き込み
	switch (pW->SvTxtFormat) {
		default:
		case 0: rsu = AjcVthSaveTextToFile(pW->hBack, pW->SvTxtPath, pW->SvTxtOutput == 0, tec, pW->SvBom	 );	break;
		case 1: rsu = AjcVthSaveHtmlToFile(pW->hBack, pW->SvTxtPath, pW->SvTxtOutput == 0, pW->SvTxtFontSize);	break;
	}
	//	グレー化解除
	AjcEnableCtrlsInWnd(hDlg, TRUE);

	//	ラジオボタン ダミークリック（グレー項目の設定）
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_FORMAT, AJCRBTN_SELECT), pW->SvTxtFormat);
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_ENCODE, AJCRBTN_SELECT), pW->SvTxtEncode);

	//	終了／エラーメッセージ
	if (rsu) {
		EndDialog(hDlg, IDOK);
	}
	else {
		MessageBox(pW->hBack, LNGSEL(L"ファイルの書き込みを失敗しました。", L"File writing failure."), 
							  LNGSEL(L"テキストをファイルへセーブ", AppName), MB_ICONERROR);
	}

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SaveToFile, IDCANCEL		)
{
	PWRKVT100	pW = (PWRKVT100)GetProp(hDlg, L"AjcVthSaveToFile");

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(SaveToFile)
	AJC_DLGMAP_MSG(SaveToFile, WM_INITDIALOG	)

	AJC_DLGMAP_CMD(SaveToFile, IDC_CMD_FILE		)
	AJC_DLGMAP_CMD(SaveToFile, IDC_GRP_FORMAT	)
	AJC_DLGMAP_CMD(SaveToFile, IDC_GRP_ENCODE	)
	AJC_DLGMAP_CMD(SaveToFile, IDOK				)
	AJC_DLGMAP_CMD(SaveToFile, IDCANCEL			)
AJC_DLGMAP_END
