﻿#include	"AjcInternal.h"
#include	"AjcCtrlVT100Def.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		ＶＲＡＭ描画処理									//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO			AnalizeEsc			 (PWRKVT100 pW);
static	UL			EscSub_MakeNtb		 (WCP str, UIP ntb, UW num);
static	VO			VrmSetCurPos		 (PWRKVT100 pW, UL	lp, UL	cp);
static	VO			VrmGetCurPos		 (PWRKVT100 pW, UL *lp, UL *cp);
static	VO			VrmCurMoveU			 (PWRKVT100 pW, UL len);
static	VO			VrmCurMoveD			 (PWRKVT100 pW, UL len);
static	VO			VrmCurMoveL			 (PWRKVT100 pW, UL len);
static	VO			VrmCurMoveR			 (PWRKVT100 pW, UL len);
static	VO			VrmSetCpxByCp		 (PWRKVT100 pW, UI lp, UI cp);
static	VO			VrmSetCpByCpx		 (PWRKVT100 pW, UI lp, UI cpx);
static	VO			VrmClearAll			 (PWRKVT100 pW);
static	VO			VrmClearToEnd		 (PWRKVT100 pW);
static	VO			VrmClearFromTop		 (PWRKVT100 pW);
static	VO			VrmClearToEndLine	 (PWRKVT100 pW);
static	VO			VrmClearFromTopLine	 (PWRKVT100 pW);
static	VO			VrmClearLine		 (PWRKVT100 pW);
static	VO			VrmSetAtt			 (PWRKVT100 pW, UB att);
static	VO			VrmSetTxtAtt		 (PWRKVT100 pW, UB att);
static	VO			VrmSetBkgAtt		 (PWRKVT100 pW, UB att);
static	VO			VrmRevAtt			 (PWRKVT100 pW);
static	VO			VrmCurON			 (PWRKVT100 pW);
static	VO			VrmCurOFF			 (PWRKVT100 pW);
static	VO			VrmScrollUp			 (PWRKVT100 pW, UL len);
static	VO			VrmScrollDown		 (PWRKVT100 pW, UL len);
static	VO			VramSlide			 (PWRKVT100 pW);
static	VO			VrmPrint			 (PWRKVT100 pW, WCP pTxt, UL len);
static	VO			PrtSub_UpdLCnt		 (PWRKVT100 pW);
static	VO			PrtSub_ScrollUp		 (PWRKVT100 pW);
static	VO			PrtSub_PutChar		 (PWRKVT100 pW, WC c);
static	VO			PrtSub_PutSurr		 (PWRKVT100 pW, WC sur2);
static	PLINEPTR	GetVramLPtr			 (PWRKVT100 pW, UI line);
static	VO			CnvVTxtToITxt		 (PWRKVT100 pW, PLINEPTR pL);

//==============================================================================================================//
//																												//
//	ＶＲＡＭ描画																								//
//																												//
//==============================================================================================================//
VO	VthPutTextToVRAM(PWRKVT100 pW)
{
	UL		i, j, bfl, dl;
	WC		buf[8192];
	WC		lgf[8193];

	if (pW->Mode == MD_NORMAL) {											//ノーマルモード？

		bfl = AjcRngGetData(pW->hRngTxt, (VOP)buf, sizeof buf) / 2;			//	描画データ取得

		if (bfl != 0) {														//	描画データあり？
			//	ＶＲＡＭ描画
			while (bfl) {													//		テキストあり中ループ
				i = 0;														//			ﾃｷｽﾄﾊﾞｯﾌｧｲﾝﾃﾞｸｽ＝０
				while (i < bfl) {											//			ﾃｷｽﾄﾊﾞｯﾌｧﾙｰﾌﾟ
					if (pW->EscIx == 0) {									//				テキスト処理中？
						j = i;
						while (j < bfl && buf[j] != CC_ESC) {
							if (j + 1 < bfl) {
								if (MAjcIsLeadW(buf[j]) && MAjcIsTrailW(buf[j + 1])) j += 2;
								else												 j++;
							}
							else j++;
						}

						dl = j - i;											//					dl=ESCｺｰﾄﾞ直前までのワード数
						if (dl != 0) {										//					ﾃｷｽﾄﾃﾞｰﾀあり？
							VrmPrint(pW, &buf[i], dl);						//						VRAM描画
							if (pW->hWndLgf != NULL) {						//						LogFile出力
								memcpy(lgf, &buf[i], dl * 2);
								lgf[dl] = 0;
								AjcLgfPutText(pW->hWndLgf, NULL, FALSE, lgf);
							}
						}
						if (j < bfl) {										//					ESCｺｰﾄﾞあり？
							pW->EscBuf[pW->EscIx++] = buf[j];				//						ESCﾊﾞｯﾌｧへﾃﾞｰﾀ格納
							i = j + 1;										//						ｲﾝﾃﾞｸｽ=ESCｺｰﾄﾞの直後
						}
						else {												//					ESCｺｰﾄﾞなし？
							i = j;											//						ｲﾝﾃﾞｸｽ=ﾊﾞｯﾌｧ末尾(終了)
						}
					}
					else {													//				ＥＳＣ処理中？
						if (pW->EscIx < sizeof pW->EscBuf - 1) {			//					ESCﾊﾞｯﾌｧに空あり？
							if (MAjcAscIsPrintW(buf[i])) {					//						ESC有効文字？
								pW->EscBuf[pW->EscIx++] = buf[i];			//							ESCﾊﾞｯﾌｧへﾃﾞｰﾀ格納
								if (MAjcAscIsAlphaW(buf[i]) ||				//							英字／'*' ？
													buf[i] == L'*') {		//							・
									pW->EscBuf[pW->EscIx] = 0;				//								文字列終端設定
									AnalizeEsc(pW);							//								ESC解析
									pW->EscIx = 0;							//								ESCﾊﾞｯﾌｧを空
								}
							}
							else {											//						ESC無効文字？
								pW->EscIx = 0;								//							ESCデータ破棄
							}					}
						else {												//					ESCﾊﾞｯﾌｧに空なし？
							pW->EscIx = 0;									//						ESCデータ破棄
						}
						i++;												//					ESCﾃﾞｰﾀﾊﾞｲﾄ ｽｷｯﾌﾟ
					}
				}															//			LoopEnd
				bfl = AjcRngGetData(pW->hRngTxt, (VOP)buf, sizeof buf) / 2;	//			次の退避テキスト取得
			}																//		LoopEnd

			if (!pW->fPause) {												//		表示停止中以外？
				VthSetCaret(pW);											//			キャレット設定
				InvalidateRect(pW->hMain, NULL, FALSE);						//			ＷＮＤ再描画
			}
			//	次回文字列検索時、検索開始位置を再設定する
			VthResetFindSrtPos(pW);
		}	// if (bfl != 0)
	}	// if (pW->Mode == MD_NORMAL) 
}
//--------------------------------------------------------------------------------------------------------------//
//	エスケープシーケンス解析																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO	AnalizeEsc(PWRKVT100 pW)
{
	WC		top = pW->EscBuf[1];
	WC		las = pW->EscBuf[pW->EscIx - 1];
	UI		ntb[8];
	UI		i, n;

	if		(top == L'[') {
		if		(wcscmp(&pW->EscBuf[1], L"[0J" ) == 0) {		//	● [0J		: カーソル位置～最終行右端クリアー
			VrmClearToEnd(pW);
		}
		else if (wcscmp(&pW->EscBuf[1], L"[1J" ) == 0) {		//	● [1J		: 先頭行左端～カーソル位置クリアー
			VrmClearFromTop(pW);
		}
		else if (wcscmp(&pW->EscBuf[1], L"[2J" ) == 0) {		//	● [2J		: 画面クリアー，ホーム移動
			VrmClearAll(pW);
			pW->lp = pW->cp = pW->cpx = 0;
		}
		else if (wcscmp(&pW->EscBuf[1], L"[0K" ) == 0 ||		//	● [0K / [K	: カーソル位置～同行右端クリアー
				 wcscmp(&pW->EscBuf[1], L"[K" )	== 0) {
			VrmClearToEndLine(pW);
		}
		else if (wcscmp(&pW->EscBuf[1], L"[1K" ) == 0) {		//	● [1K		: 行の左端～カーソル位置クリアー
			VrmClearFromTopLine(pW);
		}
		else if (wcscmp(&pW->EscBuf[1], L"[2K" ) == 0) {		//	● [2K		: カーソル行クリアー
			VrmClearLine(pW);
		}
		else if (wcscmp(&pW->EscBuf[1], L"[s"  ) == 0) {		//	● [s		: カーソル位置退避
			VrmGetCurPos(pW, &pW->svlp, &pW->svcp);
		}
		else if (wcscmp(&pW->EscBuf[1], L"[u"  ) == 0) {		//	● [u		: カーソル位置回復
			VrmSetCurPos(pW, pW->svlp, pW->svcp);
		}
		else if (wcscmp(&pW->EscBuf[1], L"[>5l") == 0) {		//	● [>5l		: カーソル表示
			VrmCurON(pW);
		}
		else if (wcscmp(&pW->EscBuf[1], L"[>5h") == 0) {		//	● [>5h		: カーソル非表示
			VrmCurOFF(pW);
		}
		else if (las == L'H' || las == L'f') {					//	● [pl;pcH	: カーソル位置設定
			ntb[0] = ntb[1] = 0;
			n = EscSub_MakeNtb(&pW->EscBuf[2], ntb, 2);
			if (ntb[0] != 0) ntb[0]--;
			if (ntb[1] != 0) ntb[1]--;
			VrmSetCurPos(pW, ntb[0], ntb[1]);
		}
		else if (las == L'A') {									//	● [pnA		: カーソル上移動
			ntb[0] = 0;
			n = EscSub_MakeNtb(&pW->EscBuf[2], ntb, 1);
			if (ntb[0] == 0) ntb[0] = 1;
			VrmCurMoveU(pW, ntb[0]);
		}
		else if (las == L'B') {									//	● [pnB		: カーソル下移動
			ntb[0] = 0;
			n = EscSub_MakeNtb(&pW->EscBuf[2], ntb, 1);
			if (ntb[0] == 0) ntb[0] = 1;
			VrmCurMoveD(pW, ntb[0]);
		}
		else if (las == L'C') {									//	● [pnC		: カーソル右移動
			ntb[0] = 0;
			n = EscSub_MakeNtb(&pW->EscBuf[2], ntb, 1);
			if (ntb[0] == 0) ntb[0] = 1;
			VrmCurMoveR(pW, ntb[0]);
		}
		else if (las == L'D') {									//	● [pnD		: カーソル左移動
			ntb[0] = 0;
			n = EscSub_MakeNtb(&pW->EscBuf[2], ntb, 1);
			if (ntb[0] == 0) ntb[0] = 1;
			VrmCurMoveL(pW, ntb[0]);
		}
		else if (las == L'M') {									//	● [pnM		: カーソル行以降をスクロールアップ
			ntb[0] = 0;
			n = EscSub_MakeNtb(&pW->EscBuf[2], ntb, 1);
			if (ntb[0] == 0) ntb[0] = 1;
			VrmScrollUp(pW, ntb[0]);
		}
		else if (las == L'L') {									//	● [pnL		: カーソル行以降をスクロールダウン
			ntb[0] = 0;
			n = EscSub_MakeNtb(&pW->EscBuf[2], ntb, 1);
			if (ntb[0] == 0) ntb[0] = 1;
			VrmScrollDown(pW, ntb[0]);
		}
		else if (las == L'm') {									//	● [ps;...m	: 表示属性設定
			memset(ntb, -1, sizeof ntb);
			n = EscSub_MakeNtb(&pW->EscBuf[2], ntb, 8);
			for (i = 0; i < n; i++) {
				if		(ntb[i] == 0) {							//		0m		  : 描画属性リセット
					VrmSetAtt(pW, VAT_DEFAULT);
				}
				else if (ntb[i] == 1) {							//		1m		  : ボールド
					/* 未サポート */
				}
				else if (ntb[i] == 2) {							//		2m		  : 薄い色
					/* 未サポート */
				}
				else if (ntb[i] == 3) {							//		3m		  : イタリック
					/* 未サポート */
				}
				else if (ntb[i] == 7) {							//		7m		  : 反転
					VrmRevAtt(pW);
				}
				else if (ntb[i] >= 30 && ntb[i] <= 37) {		//		30m - 37m : 文字色設定
					VrmSetTxtAtt(pW, (UB)(ntb[i] - 30));
				}
				else if (ntb[i] == 39) {						//		39m 	  : 文字色リセット
					VrmSetTxtAtt(pW, 0);
				}
				else if (ntb[i] >= 40 && ntb[i] <= 47) {		//		40m - 47m : 背景色設定
					VrmSetBkgAtt(pW, (UB)(ntb[i] - 40));
				}
				else if (ntb[i] == 49) {						//		49m 	  : 背景色リセット
					VrmSetBkgAtt(pW, 7);
				}
			}
		}
	}
	else if (top == L'*') {										//	● *		: 画面クリアー，ホーム移動
		VrmClearAll(pW);
		pW->lp = pW->cp = pW->cpx = 0;
	}
	else if (top == L'D') {										//	● D		: カーソルを下へ１行移動
		VrmCurMoveD(pW, 1);
	}
	else if (top == L'E') {										//	● E		: カーソルを１行下の左端へ移動
		VrmCurMoveD(pW, 1);
		VrmCurMoveL(pW, INT_MAX);
	}
	else if (top == L'M') {										//	● M		: カーソルを１行上へ移動
		VrmCurMoveU(pW, 1);
	}
}
//--------------------------------------------------------------------------------------------------------------//
static	UL	EscSub_MakeNtb(WCP str, UIP ntb, UW num)
{
	UI		rc = 0;

	while ((MAjcAscIsDigitW(*str) || *str == L';')	&&	rc < num) {
		if (MAjcAscIsDigitW(*str)) {
			ntb[rc] = _wtoi(str);
			for (; MAjcAscIsDigitW(*str); str++);
		}
		rc++;
		if (*str == L';') {
			str++;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル位置設定																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmSetCurPos (PWRKVT100 pW, UL	lp, UL	cp)
{
	//	行位置設定
	if (lp < pW->prop.VramH) pW->lp = lp;
	else					 pW->lp = pW->prop.VramH - 1;

	//	桁位置設定
	VrmSetCpxByCp (pW, pW->lp, cp);
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル位置取得																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmGetCurPos (PWRKVT100 pW, UL *lp, UL *cp)
{
	*lp = pW->lp;
	*cp = pW->cp;
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル上移動																								//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmCurMoveU	 (PWRKVT100 pW, UL len)
{
	if (pW->lp >= len) pW->lp -= len;
	else			   pW->lp  = 0;

	//	桁位置設定（インデクス→桁位置）
	VrmSetCpxByCp (pW, pW->lp, pW->cp);
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル下移動																								//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmCurMoveD	 (PWRKVT100 pW, UL len)
{
	if (pW->lp + len < pW->prop.VramH - 1) pW->lp += len;
	else								   pW->lp  = pW->prop.VramH - 1;

	//	桁位置設定（インデクス→桁位置）
	VrmSetCpxByCp (pW, pW->lp, pW->cp);
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル左移動																								//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmCurMoveL	 (PWRKVT100 pW, UL len)
{
	PLINEPTR	pL	 = GetVramLPtr(pW, pW->lp);
	WCP			pTxt = pL->pTxt;
	UBP			pAtt = ATT_PTR(pTxt);
	UL			cnt = 0;

	while (cnt < len) {
		//	行頭以外？
		if (pW->cpx > 0) {
			//	インデクス減算
			pW->cpx--;
			if (pAtt[pW->cpx] & VAT_SUR2) {
				pW->cpx--;
				_ASSERT((pAtt[pW->cpx] & VAT_SUR1) != 0);
			}
			//	桁位置減算
			if (AjcIsBigChar(&pTxt[pW->cpx])) {
				_ASSERT(pW->cp >= 2);
				pW->cp -= 2;
				cnt += 2;
			}
			else {
				_ASSERT(pW->cp >= 1);
				pW->cp--;
				cnt++;	
			}
		}
		//	行頭？
		else {
			//	ＶＲＡＭ先頭行以外ならば、前行右端へ移動
			if (pW->lp > 0) {
				pW->lp--;
				pL		= GetVramLPtr(pW, pW->lp);
				pTxt	= pL->pTxt;
				pAtt	= ATT_PTR(pTxt);
				pW->cpx = pW->prop.VramW - 1;
				if (pAtt[pW->cpx] & VAT_SUR2) pW->cpx--;
				VrmSetCpByCpx(pW, pW->lp, pW->cpx);
				cnt++;
			}
			//	ＶＲＡＭ先頭行ならば、桁位置＝０で終了
			else {
				pW->cp = 0;
				break;
			}
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル右移動																								//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmCurMoveR	 (PWRKVT100 pW, UL len)
{
	PLINEPTR	pL	 = GetVramLPtr(pW, pW->lp);
	WCP			pTxt = pL->pTxt;
	UBP			pAtt = ATT_PTR(pTxt);
	UL			cnt = 0;

	while (cnt < len && !(pW->lp == pW->prop.VramH - 1 && pW->cpx == pW->prop.VramW - 1)) {
		//	行末以外？
		if (pW->cpx < pW->prop.VramW) {
			//	桁位置加算
			if (AjcIsBigChar(&pTxt[pW->cpx])) {
				pW->cp += 2;
				cnt    += 2;
			}
			else {
				pW->cp++;
				cnt++;	
			}
			//	インデクス加算
			if (pAtt[pW->cpx] & VAT_SUR1) {
				pW->cpx++;
				_ASSERT(pAtt[pW->cpx] & VAT_SUR2);
				pW->cpx++;
			}
			else {
				pW->cpx++;
			}
			_ASSERT(pW->cpx <= pW->prop.VramW);
		}
		//	行末？
		if (pW->cpx >= pW->prop.VramW) {
			//	ＶＲＡＭ最終行以外ならば、次行左端へ移動
			if (pW->lp < pW->prop.VramH - 1) {
				pW->lp++;
				pL		= GetVramLPtr(pW, pW->lp);
				pTxt	= pL->pTxt;
				pAtt	= ATT_PTR(pTxt);
				pW->cp = pW->cpx = 0;
				cnt++;
			}
			//	ＶＲＡＭ最終行ならば、桁位置を設定し終了
			else {
				VrmSetCpByCpx(pW, pW->lp, pW->cpx);
				break;
			}
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	桁位置からテキストインデクス設定																			//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				lp	  - 行位置																					//
//				cp	  - 桁位置																					//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmSetCpxByCp(PWRKVT100 pW, UI lp, UI cp)
{
	if (lp < pW->prop.VramH) {
		PLINEPTR	pL	 = GetVramLPtr(pW, pW->lp);
		WCP			pTxt = pL->pTxt;
		UBP			pAtt = ATT_PTR(pTxt);
		UI			ix	= 0; 
		UI			cnt = 0;
		while (cnt < cp && ((pAtt[ix] & VAT_SUR1) ? (ix <  pW->prop.VramW - 2) : (ix < pW->prop.VramW - 1))) {
			//	桁位置更新
			if (AjcIsBigChar(&pTxt[ix])) {
				if (cnt + 2 <= cp) {
					cnt += 2;
				}
				else break;
			}
			else cnt++;
			//	インデクス更新
			if (pAtt[ix] & VAT_SUR1) {
				ix++;
				_ASSERT((pAtt[ix] & VAT_SUR2) != 0);
				ix++;
			}
			else {
				_ASSERT((pAtt[ix] & VAT_SUR2) == 0);
				ix++;
			}
			_ASSERT(ix < pW->prop.VramW);
		}
		pW->cp	= cnt;
		pW->cpx = ix;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	テキストインデクスから桁位置設定																			//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				lp	  - 行位置																					//
//				cp	  - 桁位置																					//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmSetCpByCpx(PWRKVT100 pW, UI lp, UI cpx)
{
	if (lp < pW->prop.VramH) {
		PLINEPTR	pL	 = GetVramLPtr(pW, pW->lp);
		WCP			pTxt = pL->pTxt;
		UBP			pAtt = ATT_PTR(pTxt);
		UI			cp	= 0;
		UI			ix	= 0;
		UI			ixe = __min(cpx, pW->prop.VramW - 1);
		while (ix < ixe && ((pAtt[ix] & VAT_SUR1) ? (ix + 2 <= ixe) : (ix + 1 <= ixe))) {
			//	桁位置更新
			if (AjcIsBigChar(&pTxt[ix])) cp += 2;
			else						 cp++;
			//	インデクス更新
			if (pAtt[ix] & VAT_SUR1) {
				ix++;
				_ASSERT((pAtt[ix] & VAT_SUR2) != 0);
				ix++;
			}
			else {
				_ASSERT((pAtt[ix] & VAT_SUR2) == 0);
				ix++;
			}
		}
		pW->cp	= cp;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	VRAM全体クリアー																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO			 VrmClearAll	   (PWRKVT100 pW)
{
	UI			i;
	UI			ix = pW->IxVTop;
	PLINEPTR	pL;
	WCP			pTxt;
	UBP			pAtt;

	for (i=0; i<pW->prop.VramH; i++) {
		pL = pW->pLPtr + ix;
		pL->fUpd = TRUE;
		pL->len  = 0;
		pTxt	 = pL->pTxt;
		pAtt	 = (UBP)(pTxt + pW->prop.VramW);
		VthMemSetW(pTxt, 0x20		, pW->prop.VramW);
		VthMemSetA(pAtt, VAT_DEFAULT, pW->prop.VramW);
		ix = ((ix + 1) % pW->prop.MaxLines);
	}
	//	次回文字列検索時、検索開始位置を再設定する
	VthResetFindSrtPos(pW);
}
//--------------------------------------------------------------------------------------------------------------//
//	ｶｰｿﾙ位置～ENDｸﾘｱｰ																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO			 VrmClearToEnd		 (PWRKVT100 pW)
{
	UI			i, n, ix;
	PLINEPTR	pL;
	WCP			pTxt;
	UBP			pAtt;

	//----- 現行の後部クリアー ------------------------------------------------------//
	VrmClearToEndLine(pW);

	//----- 次行から最終行クリアー --------------------------------------------------//
	if (pW->prop.VramH > pW->lp + 1) {
		ix = ((pW->IxVTop + pW->lp + 1) % pW->prop.MaxLines);
		n = pW->prop.VramH - (pW->lp + 1);
		for (i = 0; i < n; i++) {
			pL		 = pW->pLPtr + ix;
			pL->fUpd = TRUE;
			pL->len  = 0;
			pTxt	 = pL->pTxt;
			pAtt	 = (UBP)(pTxt + pW->prop.VramW);
			VthMemSetW(pTxt, 0x20		, pW->prop.VramW);
			VthMemSetA(pAtt, VAT_DEFAULT, pW->prop.VramW);
			ix = ((ix + 1) % pW->prop.MaxLines);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	TOP～ｶｰｿﾙ位置ｸﾘｱｰ																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO			 VrmClearFromTop	 (PWRKVT100 pW)
{
	UI			i, ix;
	PLINEPTR	pL;
	WCP			pTxt;
	UBP			pAtt;

	//----- 先頭行から直前行クリアー ------------------------------------------------//
	if (pW->lp != 0) {
		ix = pW->IxVTop;
		for (i=0; i<pW->lp; i++) {
			pL		= pW->pLPtr + ix;
			pTxt	= pL->pTxt;
			pAtt	= (UBP)(pTxt + pW->prop.VramW);
			VthMemSetW(pTxt, 0x20		 , pW->prop.VramW);
			VthMemSetA(pAtt, VAT_DEFAULT, pW->prop.VramW);
			pL->len = 0;
			ix = ((ix + 1) % pW->prop.MaxLines);
		}
	}
	//----- 現行の前部クリアー ------------------------------------------------------//
	VrmClearFromTopLine(pW);

	VrmSetCpByCpx(pW, pW->lp, pW->cpx);
}
//--------------------------------------------------------------------------------------------------------------//
//	現行のｶｰｿﾙ位置～ENDｸﾘｱｰ																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO			 VrmClearToEndLine	 (PWRKVT100 pW)
{
	UI			ix, len;
	PLINEPTR	pL;
	WCP			pTxt;
	UBP			pAtt;

	ix		 = ((pW->IxVTop + pW->lp) % pW->prop.MaxLines);
	pL		 = pW->pLPtr + ix;
	pL->fUpd = TRUE;
	pTxt	 = pL->pTxt;
	pAtt	 = ATT_PTR(pTxt);;
	len		 = pW->prop.VramW - pW->cpx;
	VthMemSetW(pTxt + pW->cpx, 0x20 	  , len);
	VthMemSetA(pAtt + pW->cpx, VAT_DEFAULT, len);
	if (pL->len > pW->cpx) {
		pL->len = pW->cpx;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	現行のTOP～ｶｰｿﾙ位置ｸﾘｱｰ																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO			 VrmClearFromTopLine (PWRKVT100 pW)
{
	UI			ix;
	PLINEPTR	pL;
	WCP			pTxt;
	UBP			pAtt;

	ix	 	 = ((pW->IxVTop + pW->lp) % pW->prop.MaxLines);
	pL	 	 = pW->pLPtr + ix;
	pL->fUpd = TRUE;
	pTxt 	 = pL->pTxt;
	pAtt 	 = ATT_PTR(pTxt);
	VthMemSetW(pTxt, 0x20		, pW->cpx);
	VthMemSetA(pAtt, VAT_DEFAULT, pW->cpx);
	if (pL->len <= pW->cpx) {
		pL->len = 0;
	}
	VrmSetCpByCpx(pW, pW->lp, pW->cpx);
}
//--------------------------------------------------------------------------------------------------------------//
//	現行ｸﾘｱｰ																									//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO			 VrmClearLine		 (PWRKVT100 pW)
{
	UI			ix;
	PLINEPTR	pL;
	WCP			pTxt;
	UBP			pAtt;

	ix		 = ((pW->IxVTop + pW->lp) % pW->prop.MaxLines);
	pL		 = pW->pLPtr + ix;
	pL->fUpd = TRUE;
	pTxt	 = pL->pTxt;
	pAtt	 = ATT_PTR(pTxt);
	VthMemSetW(pTxt, 0x20		, pW->prop.VramW);
	VthMemSetA(pAtt, VAT_DEFAULT, pW->prop.VramW);
	pL->len = 0;
}
//--------------------------------------------------------------------------------------------------------------//
//	描画属性設定																								//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				att	  - 描画属性（Bit7-4:背景，Bit3-0:テキスト）												//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmSetAtt	 (PWRKVT100 pW, UB att)
{
	pW->att = (att & (VAT_BC | VAT_FC));
}
//--------------------------------------------------------------------------------------------------------------//
//	テキスト描画属性設定																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				att	  - テキストの属性（０～７）																//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmSetTxtAtt	(PWRKVT100 pW, UB att)
{
	pW->att = ((pW->att & ~VAT_FC) | (att & VAT_FC));
}
//--------------------------------------------------------------------------------------------------------------//
//	背景描画属性設定																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				att	  - 背景の属性（０～７）																	//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmSetBkgAtt	(PWRKVT100 pW, UB att)
{
	pW->att = ((pW->att & ~VAT_BC) | ((att << 4) & VAT_BC));
}
//--------------------------------------------------------------------------------------------------------------//
//	属性反転																									//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmRevAtt	 (PWRKVT100 pW)
{
	pW->att = ((pW->att << 4) | (pW->att >> 4));
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル表示ＯＮ																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmCurON	 (PWRKVT100 pW)
{
	pW->fCaret = TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル表示ＯＦＦ																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmCurOFF	 (PWRKVT100 pW)
{
	pW->fCaret = FALSE;
}
//--------------------------------------------------------------------------------------------------------------//
//	スクロールアップ																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmScrollUp	 (PWRKVT100 pW, UL len)
{
	UI			ixS, ixD, n, i;
	PLINEPTR	pLS, pLD;

	if (len != 0) {
		len = __min(len, pW->prop.VramH - pW->lp);
		//----- スクロール移動 ----------------------//
		n	= pW->prop.VramH - (pW->lp + len);
		ixS = ((pW->IxVTop + (pW->lp + len)) % pW->prop.MaxLines);
		ixD = ((pW->IxVTop + (pW->lp	  )) % pW->prop.MaxLines);
		for (i=0; i<n; i++) {
			pLD = pW->pLPtr + ixD;
			pLS = pW->pLPtr + ixS;
			memcpy(pLD->pTxt, pLS->pTxt, pW->prop.VramW * 3);
			pLD->fUpd = TRUE;
			pLD->len  = pLS->len;
			ixS = ((ixS + 1) % pW->prop.MaxLines);
			ixD = ((ixD + 1) % pW->prop.MaxLines);
		}
		//----- 後部余白クリアー --------------------//
		for (i=0; i<len; i++) {
			pLD = pW->pLPtr + ixD;
			VthMemSetW(pLD->pTxt				 , 0x20 	  , pW->prop.VramW);
			VthMemSetA(pLD->pTxt + pW->prop.VramW, VAT_DEFAULT, pW->prop.VramW);
			pLD->fUpd = TRUE;
			pLD->len  = 0;
			ixD = ((ixD + 1) % pW->prop.MaxLines);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	スクロールダウン																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmScrollDown(PWRKVT100 pW, UL len)
{
	UI			ixS, ixD, n, i;
	PLINEPTR	pLS, pLD;

	if (len != 0) {
		len = __min(len, pW->prop.VramH - pW->lp);
		//----- スクロール移動 ----------------------//
		n	= pW->prop.VramH - (pW->lp + len);
		ixS = ((pW->IxVTop + (pW->prop.VramH - (len + 1))) % pW->prop.MaxLines);
		ixD = ((pW->IxVTop + (pW->prop.VramH - 1		)) % pW->prop.MaxLines);
		for (i=0; i<n; i++) {
			pLD = pW->pLPtr + ixD;
			pLS = pW->pLPtr + ixS;
			memcpy(pLD->pTxt, pLS->pTxt, pW->prop.VramW * 3);
			pLD->fUpd = TRUE;
			pLD->len  = pLS->len;
			ixS = (ixS == 0 ? pW->prop.MaxLines - 1 : ixS - 1);
			ixD = (ixD == 0 ? pW->prop.MaxLines - 1 : ixD - 1);
		}
		//----- 前部余白クリアー --------------------//
		for (i=0; i<len; i++) {
			pLD = pW->pLPtr + ixD;
			VthMemSetW(pLD->pTxt				 , 0x20 	  , pW->prop.VramW);
			VthMemSetA(pLD->pTxt + pW->prop.VramW, VAT_DEFAULT, pW->prop.VramW);
			pLD->fUpd = TRUE;
			pLD->len  = 0;
			ixD = (ixD == 0 ? pW->prop.MaxLines - 1 : ixD - 1);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ＶＲＡＭスライド（ＶＲＡＭ先頭を内部テキスト化し、ＶＲＡＭポインタスライド）								//
//																												//
//	引	数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VramSlide(PWRKVT100 pW)
{

	if (pW->prop.MaxLines == pW->prop.VramH) {
		UI			ixE = ((pW->IxVTop + pW->prop.VramH) % pW->prop.MaxLines);
		PLINEPTR	pLS = pW->pLPtr + pW->IxVTop;
		PLINEPTR	pLE = pW->pLPtr + ixE;

		//----- ＶＲＡＭ先頭行ポインタを最終行へ移動 --------------------//
		memcpy(pLE, pLS, sizeof(LINEPTR));
		//----- ＶＲＡＭ最終行クリアー ----------------------------------//
		pLE->len = 0;
		VthMemSetW(pLE->pTxt				 , 0x20 	  , pW->prop.VramW);
		VthMemSetA(pLE->pTxt + pW->prop.VramW, VAT_DEFAULT, pW->prop.VramW);
		//----- ＶＲＡＭ先頭インデクス更新 ------------------------------//
		pW->IxVTop = (pW->IxVTop + 1) % pW->prop.MaxLines;
	}
	else {
		UI			ixE = ((pW->IxVTop + pW->prop.VramH) % pW->prop.MaxLines);
		PLINEPTR	pLS = pW->pLPtr + pW->IxVTop;
		PLINEPTR	pLE = pW->pLPtr + ixE;

		//----- バッファ最古行位置のテキスト開放 ------------------------//
		if (pLE->fAlloc && pLE->pTxt != NULL) {
			free(pLE->pTxt);
		}
		//----- ＶＲＡＭ先頭行ポインタをバッファ最古行へ移動 ------------//
		memcpy(pLE, pLS, sizeof(LINEPTR));
		//----- ＶＲＡＭ先頭行を内部テキスト化 --------------------------//
		CnvVTxtToITxt (pW, pLS);
		//----- バッファ最終行クリアー ----------------------------------//
		pLE->len = 0;
		VthMemSetW(pLE->pTxt				 , 0x20 	  , pW->prop.VramW);
		VthMemSetA(pLE->pTxt + pW->prop.VramW, VAT_DEFAULT, pW->prop.VramW);
		//----- ＶＲＡＭ先頭インデクス更新 ------------------------------//
		pW->IxVTop = (pW->IxVTop + 1) % pW->prop.MaxLines;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ＶＲＡＭへテキスト描画																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	VrmPrint	 (PWRKVT100 pW, WCP pTxt, UL len)
{
	UI		SvLCnt = pW->LCnt;

	while (len != 0) {												//	全テキスト文字ループ
		if (pW->sur1) {												//	直前の文字はサロゲート1文字目？
			if (MAjcIsTrailW(*pTxt)) {								//		現文字はサロゲート２文字目？
				PrtSub_PutSurr(pW, *pTxt);							//			サロゲート１文字描画
			}
			pW->sur1 = 0;											//		サロゲートモード解除
		}
		else {														//	直前の文字はサロゲート１文字目以外？
			if (iswcntrl(*pTxt)) {									//		●現文字は制御コード？
				switch (*pTxt) {

					case CC_BS:										//			◎ＢＳ
						if (pW->cp > 0) {							//				行頭以外？
							VrmCurMoveL(pW, 1);						//					カーソル左移動
						}
						break;

					case CC_TAB:									//			◎ＴＡＢ
						VrmCurMoveR(pW, pW->prop.TabStep - (pW->cp % pW->prop.TabStep));
						break;

					case CC_CR:										//			◎Ｃ／Ｒ
						pW->cp = pW->cpx = 0;						//				桁位置，インデクス＝０
						if (pW->style & AJCVTHS_CRCTRL) {			//				Ｃ／Ｒ＝復帰改行？
							if (++pW->lp >= pW->prop.VramH) {		//					行位置更新，オーバー？
								pW->lp = pW->prop.VramH - 1;		//						行位置＝最下端行
								PrtSub_ScrollUp(pW);				//						スクロールアップ
							}
							PrtSub_UpdLCnt(pW);						//					有効行数更新
						}
						break;

					case CC_LF:										//			◎Ｌ／Ｆ
						if ((pW->style & AJCVTHS_LFCTRL) ||			//				Ｌ／Ｆ＝復帰改行？
							(pW->style & (AJCVTHS_CRLFCTRL | AJCVTHS_CRCTRL | AJCVTHS_LFCTRL)) == 0) {
							pW->cp = pW->cpx = 0;					//					桁位置，インデクス＝０
						}
						if (++pW->lp >= pW->prop.VramH) {			//				行位置更新，オーバー？
							pW->lp = pW->prop.VramH - 1;			//					行位置＝最下端行
							PrtSub_ScrollUp(pW);					//					スクロールアップ
						}
						PrtSub_UpdLCnt(pW);							//				有効行数更新
						break;
				}
			}
			else if (MAjcIsLead(*pTxt)) {							//		●現文字はサロゲート1文字目？
				pW->sur1 = *pTxt;									//			サロゲート１文字目退避
			}
			else {													//		●その他
				PrtSub_PutChar(pW, *pTxt);							//			サロゲート以外の文字描画
			}
		}
		pTxt++;														//	テキストアドレス更新
		len--;														//	残文字数減少
	}
	//	スクロール情報設定
	if (!pW->fPause) {
		//----- 最終ページへスクロール --------------------//
		if (!(pW->style & AJCVTHS_NOSCRL)) {
			VthScrollToBottom(pW);
		}
		//----- スクロール情報設定 ------------------------//
		else if (SvLCnt != pW->LCnt) {
			VthSetVScrollInfo(pW, -1);
		}
	}
}
//----- 有効行数更新 -------------------------------------------------------------------------------------------//
static	VO	PrtSub_UpdLCnt(PWRKVT100 pW)
{
	UI	LCnt;

	LCnt = VthIxToLno(pW, pW->IxVTop + pW->lp) + 1;
	pW->LCnt = __max(LCnt, pW->LCnt);
}
//----- ＶＲＡＭ１行スクロールアップ ---------------------------------------------------------------------------//
static	VO	PrtSub_ScrollUp(PWRKVT100 pW)
{
	//----- スクロールアウトなし ----------------------//
	if (pW->style & AJCVTHS_NOSCRLOUT) {
		pW->lp = 0;
	}
	//----- スクロールアウトあり ----------------------//
	else {
		//	ＶＲＡＭスライド
		VramSlide(pW);
		//	先頭位置（最古ラインインデクス）更新
		if (pW->LCnt >= pW->prop.MaxLines) {
			pW->IxSrt  = ((pW->IxSrt  + 1) % pW->prop.MaxLines);
			pW->IxWTop = ((pW->IxWTop + 1) % pW->prop.MaxLines);
		}
	}
}
//----- ＶＲＡＭへ１文字描画 -----------------------------------------------------------------------------------//
static	VO	PrtSub_PutChar(PWRKVT100 pW, WC c)
{
	PLINEPTR	pL	 = GetVramLPtr(pW, pW->lp);
	WCP			pTxtTop = pL->pTxt;
	UBP			pAttTop = (UBP)(pTxtTop + pW->prop.VramW);
	WCP			pTxt	= pTxtTop + pW->cpx;
	UBP			pAtt	= pAttTop + pW->cpx;
	WC			wc[2];

	_ASSERT((*pAtt & VAT_SUR2) == 0);

	//----- 更新フラグ設定 --------------------------------//
	pL->fUpd = TRUE;

	//----- 文字描画 --------------------------------------//
	//	描画位置がサロゲート１
	if (*pAtt & VAT_SUR1) {
		//	後続文字シフトして詰める
		UI	src = pW->cpx + 2;
		UI	dst = pW->cpx + 1;
		UI	len = pW->prop.VramW - src;
		if (len != 0) {
			//	サロゲート２ワード目以降１文字分詰める
			memmove(&pTxtTop[dst], &pTxtTop[src], len * 2);
			memmove(&pAttTop[dst], &pAttTop[src], len	 );
		}
		//	サロゲート１ワード目の部分に文字描画
		*pTxt = c;
		*pAtt = pW->att;
		//	テキスト末尾に空白を補填
		pTxtTop[pW->prop.VramW - 1] = L' ';
		pAttTop[pW->prop.VramW - 1] = pW->att;
	}
	//	描画位置は通常文字
	else {
		//	文字描画
		*pTxt = c;
		*pAtt = pW->att;
	}
	//----- カーソル位置更新と有効テキスト長更新 ----------//
	//	桁位置更新
	wc[0] = c; wc[1] = 0;
	if (AjcIsBigChar(wc)) pW->cp += 2;
	else				  pW->cp++;
	//	バッファインデクス更新
	pW->cpx++;
	//	有効テキスト長更新
	pL->len = __max(pL->len, pW->cpx);
	//----- 改行チェック ----------------------------------//
	if (pW->cpx >= pW->prop.VramW) {
		pW->cp = pW->cpx = 0;
		if (++pW->lp >= pW->prop.VramH) {
			pW->lp = pW->prop.VramH - 1;
			PrtSub_ScrollUp(pW);
		}
	}
	//----- 有効行数更新 ----------------------------------//
	PrtSub_UpdLCnt(pW);
}
//----- ＶＲＡＭへサロゲート文字描画 ---------------------------------------------------------------------------//
static	VO	PrtSub_PutSurr(PWRKVT100 pW, WC sur2)
{
	PLINEPTR	pL	 	= GetVramLPtr(pW, pW->lp);
	WCP			pTxtTop = pL->pTxt;
	UBP			pAttTop = ATT_PTR(pTxtTop);
	WCP			pTxt	= pTxtTop + pW->cpx;
	UBP			pAtt	= pAttTop + pW->cpx;
	WC			wc[2];

	_ASSERT((*pAtt & VAT_SUR2) == 0);

	//----- 行末チェック -----------------------------------//
	if (pW->cpx >= pW->prop.VramW - 1) {
		pW->cp = pW->cpx = 0;
		if (++pW->lp >= pW->prop.VramH) {
			pW->lp = pW->prop.VramH - 1;
			PrtSub_ScrollUp(pW);
		}
		//----- ＶＲＡＭポインタ再設定 ---------//
		pL	 = GetVramLPtr(pW, pW->lp);
		pTxtTop = pTxt = pL->pTxt;
		pAttTop = pAtt = (UBP)(pL->pTxt + pW->prop.VramW);
	}

	//----- 更新フラグ設定 ----------------------------------//
	pL->fUpd = TRUE;

	//----- サロゲート文字描画 ------------------------------//
	//	描画位置がサロゲート１
	if (*pAtt & VAT_SUR1) {
		*pTxt++ = pW->sur1;
		*pAtt++ = (pW->att | VAT_SUR1);
		*pTxt	= sur2;
		*pAtt	= (pW->att | VAT_SUR2);
	}
	//	描画位置がサロゲート２（この条件は発生しない）
	else if (*pAtt & VAT_SUR2) {
		*pTxt-- = sur2;
		*pAtt-- = (pW->att | VAT_SUR2);
		*pTxt	= pW->sur1;
		*pAtt	= (pW->att | VAT_SUR1);
	}
	//	その他（通常文字へ上書き）
	else {
		//	後続文字シフト
		UI	src = pW->cpx + 1;
		UI	dst = pW->cpx + 2;
		UI	len = pW->prop.VramW - dst;
		if (len != 0) {
			//	描画位置の次移行を右シフト
			memmove(&pTxtTop[dst], &pTxtTop[src], len * 2);
			memmove(&pAttTop[dst], &pAttTop[src], len	 );
			//	テキスト末尾がサロゲート１ワード目ならば空白を上書き
			if (pAttTop[pW->prop.VramW - 1] & VAT_SUR1) {
				pTxtTop[pW->prop.VramW - 1]  = L' ';
				pAttTop[pW->prop.VramW - 1] &= ~VAT_SUR1;
			}
		}
		//	サロゲート文字描画
		*pTxt++ = pW->sur1;
		*pAtt++ = (pW->att | VAT_SUR1);
		*pTxt	= sur2;
		*pAtt	= (pW->att | VAT_SUR2);
	}
	//----- カーソル位置更新と有効テキスト長更新 ------------//
	//	桁位置更新
	wc[0] = pW->sur1; wc[1] = sur2;
	if (AjcIsBigChar(wc)) pW->cp += 2;
	else				  pW->cp++;
	//	インデクス更新
	pW->cpx += 2;
	//	有効テキスト長更新
	pL->len = __max(pL->len, pW->cpx);
	//----- 改行チェック ------------------------------------//
	if (pW->cpx >= pW->prop.VramW) {
		pW->cp = pW->cpx = 0;
		if (++pW->lp >= pW->prop.VramH) {
			pW->lp = pW->prop.VramH - 1;
			PrtSub_ScrollUp(pW);
		}
	}
	//----- 有効行数更新 ------------------------------------//
	PrtSub_UpdLCnt(pW);
}
//--------------------------------------------------------------------------------------------------------------//
//	ＶＲＡＭ行ポインタ取得																						//
//																												//
//	引	数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	PLINEPTR	GetVramLPtr(PWRKVT100 pW, UI line)
{
	UI			ix;
	PLINEPTR	pL;

	ix = ((pW->IxVTop + line) % pW->prop.MaxLines);
	pL = pW->pLPtr + ix;

	return	pL;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＶＲＡＭテキストを内部テキストに変換																		//
//																												//
//	引	数	：	pL		- ラインポインタエントリアドレス														//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	CnvVTxtToITxt(PWRKVT100 pW, PLINEPTR pL)
{
	WCP		pNew;
	UBP		pAtt;

	if (pNew = (WCP)AJCMEM(pL->len * 3)) {	//	テキストと属性データ領域確保
		//----- テキスト，属性コピー --------------------------------//
		memcpy(pNew			 , pL->pTxt					, pL->len * 2);
		memcpy(pNew + pL->len, pL->pTxt + pW->prop.VramW, pL->len	 );
		//----- ライン情報設定 --------------------------------------//
		pAtt	   = ATT_PTR(pL->pTxt);
		pL->fVram  = FALSE;
		pL->fAlloc = TRUE;
		pL->pTxt   = pNew;
	}
	else {
		//----- エラーテキスト設定 ----------------------------------//
		pL->fVram  = FALSE;
		pL->fAlloc = FALSE;
		pL->len	   = VthErrTxtLen;
		pL->pTxt   = VthErrorTxt;
	}
}

