﻿#include	"AjcInternal.h"
#include	"AjcCtrlVT100Def.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		ＭＳＩＬ(.NET Framework)対応処理					//
//																												//
//**************************************************************************************************************//
#define	IDC_PARENT	5000
#define	IDC_CTRL	5001

//--------------------------------------------------------------------------------------------------------------//
//	ワーク形式																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HWND	hCtrl;			//	VT100ウインド
	VO (CALLBACK *cbNtcDblClk )(BOOL shift, BOOL ctrl);
	VO (CALLBACK *cbNtcKeyIn  )(UI key , UI RepCnt);
	VO (CALLBACK *cbNtcVKeyIn )(UI vkey, UI RepCnt);
	VO (CALLBACK *cbNtcVKeyOut)(UI vkey);
	VO (CALLBACK *cbFileDrop  )(UI n   );
	VO (CALLBACK *cbDirDrop   )(UI n   );
	VO (CALLBACK *cbCharInfo  )(UI LineHeight);
	VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl);
} WKMSIL, *PWKMSIL;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(MSIL);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		VthWndProcMSIL()
{
	return AJC_WNDPROC_NAME(MSIL);
}
//==============================================================================================================//
//																												//
//	コントロールウインド生成																					//
//																												//
//==============================================================================================================//
AJCEXPORT HWND WINAPI AjcVthCreateForMSIL(HWND hOwner,	VO (CALLBACK *cbNtcDblClk )(BOOL shift, BOOL ctrl),
														VO (CALLBACK *cbNtcKeyIn  )(UI key , UI fRepCnt),
														VO (CALLBACK *cbNtcVKeyIn )(UI vkey, UI fRepCnt),
														VO (CALLBACK *cbNtcVKeyOut)(UI vkey),
														VO (CALLBACK *cbFileDrop  )(UI n   ),
														VO (CALLBACK *cbDirDrop   )(UI n   ),
														VO (CALLBACK *cbCharInfo  )(UI LineHeight),
														VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl))
{
	HWND		hBack = NULL;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = NULL;
	RECT		rect;

	do {
		//----- 親ウインドハンドルチェック ---------------------------------------------------------------------//
		if (!IsWindow(hOwner)) break;
		//----- ワーク領域確保 ---------------------------------------------------------------------------------//
		if ((pWk = (PWKMSIL)AJCMEM(sizeof(WKMSIL))) == NULL) break;
		memset(pWk, 0, sizeof(WKMSIL));
		pWk->cbNtcDblClk = cbNtcDblClk;
		pWk->cbNtcKeyIn  = cbNtcKeyIn ;
		pWk->cbNtcVKeyIn = cbNtcVKeyIn;
		pWk->cbNtcVKeyOut= cbNtcVKeyOut;
		pWk->cbFileDrop  = cbFileDrop ;
		pWk->cbDirDrop	 = cbDirDrop  ;
		pWk->cbCharInfo  = cbCharInfo ;
		pWk->cbRClick	 = cbRClick;
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hOwner, &rect);
		//----- バックウインド生成 -----------------------------------------------------------------------------//
		hBack = CreateWindow((WCP)VthClassForMSIL,			// window class name
								L"",						// window caption
								WS_CHILD,					// window style
								0,							// initial x position
								0,							// initial y position
								rect.right - rect.left,		// initial x size
								rect.bottom - rect.top,		// initial y size
								hOwner,						// parent window handle
								(HMENU)IDC_PARENT,			// window menu handle
								hDllInst,					// program instance handle
								(VOP)pWk);					// creation parameters
		if (hBack == NULL) break;
		//----- 戻り値（コントロールハンドル）設定 -------------------------------------------------------------//
		hCtrl = pWk->hCtrl;
		//----- チップコントロール対象ウインド設定 -------------------------------------------------------------//
		AJCTIPCTRL_SETHWNDA(hOwner, hCtrl);
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hBack, SW_SHOW);
	} while(0);

	//----- エラーならばリソース解放 ---------------------------------------------------------------------------//
	if (hBack == NULL) {
		if (pWk != NULL) free(pWk);
	}
	return hCtrl;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドプロシージャ																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_CREATE		)
{
	LRESULT		rc	  = -1;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = (PWKMSIL)((LPCREATESTRUCT)lParam)->lpCreateParams;
	RECT		rect;

	do {
		//----- ワークポインタ退避 -----------------------------------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pWk);
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hwnd, &rect);
		//----- ＶＴ１００ウインド生成 -------------------------------------------------------------------------//
		hCtrl = CreateWindow(L"AjcCtrlVT100",										// window class name
							L"",													// window caption
							WS_CHILD | WS_VISIBLE | AJCVTHS_LFCTRL, 				// style
							0,														// initial x position
							0,														// initial y position
							rect.right - rect.left,									// initial x size
							rect.bottom - rect.top,									// initial y size
							hwnd,													// parent window handle
							(HMENU)IDC_CTRL,										// window menu handle
							hDllInst,												// program instance handle
							NULL);													// creation parameters
		if (hCtrl == NULL) break;
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hCtrl, SW_SHOW);
		//----- コントロールのハンドル退避 ---------------------------------------------------------------------//
		pWk->hCtrl = hCtrl;
		//----- 戻り値=正常 ------------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_DESTROY	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk != NULL) {
		if (pWk->hCtrl != NULL) {
			DestroyWindow(pWk->hCtrl);
			pWk->hCtrl = NULL;
		}
		free(pWk);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_SIZE		)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);
	int			width  = LOWORD(lParam);
	int			height = HIWORD(lParam);

	SetWindowPos(pWk->hCtrl, NULL, 0, 0, width, height, SWP_NOMOVE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_RBUTTONDOWN	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk->cbRClick != NULL) {
		pWk->cbRClick((int)LOWORD(lParam), (int)HIWORD(lParam), ((wParam & MK_SHIFT) != 0), ((wParam & MK_CONTROL) != 0));
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, IDC_CTRL		)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (LOWORD(wParam) == IDC_CTRL) {
		switch (HIWORD(wParam)) {
			case AJCVTHN_DBLCLK:						//	●ダブルクリック通知
				if (pWk->cbNtcDblClk != NULL) {
					pWk->cbNtcDblClk(((lParam & MK_SHIFT) != 0), ((lParam & MK_CONTROL) != 0));
				}
				break;

			case AJCVTHN_KEYIN:							//	●キー入力通知
				if (pWk->cbNtcKeyIn != NULL) {
					pWk->cbNtcKeyIn((UI)lParam, AjcVthGetNtcKeyRep(pWk->hCtrl));
				}
				break;

			case AJCVTHN_VKEYIN:						//	●特殊キー押下通知
				if (pWk->cbNtcVKeyIn != NULL) {
					pWk->cbNtcVKeyIn((UI)lParam, AjcVthGetNtcKeyRep(pWk->hCtrl));
				}
				break;

			case AJCVTHN_VKEYOUT:						//	●特殊キー離し通知
				if (pWk->cbNtcVKeyOut != NULL) {
					pWk->cbNtcVKeyOut((UI)lParam);
				}
				break;

			case AJCVTHN_DROPFILE:						//	●ファイルドロップ通知
				if (pWk->cbFileDrop != NULL) {
					pWk->cbFileDrop((UI)lParam);
				}
				break;

			case AJCVTHN_DROPDIR:						//	●ディレクトリドロップ通知
				if (pWk->cbDirDrop != NULL) {
					pWk->cbDirDrop((UI)lParam);
				}
				break;

			case AJCVTHN_CHARINFO:						//	●文字サイズ変更通知
				if (pWk->cbCharInfo != NULL) {
					pWk->cbCharInfo((UI)lParam);
				}
				break;

			case AJCVTHN_RCLICK:						//	●右クリック通知
			{	PAJCVTHRCLK	p = (PAJCVTHRCLK)lParam;
				if (pWk->cbRClick != NULL) {
					pWk->cbRClick(p->x, p->y, p->fShift, p->fCtrl);
				}
				break;
			}
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MSIL)
	AJC_WNDMAP_MSG(MSIL, WM_CREATE			)
	AJC_WNDMAP_MSG(MSIL, WM_DESTROY			)
	AJC_WNDMAP_MSG(MSIL, WM_SIZE			)
	AJC_WNDMAP_MSG(MSIL, WM_RBUTTONDOWN		)

	AJC_WNDMAP_CMD(MSIL, IDC_CTRL			)
AJC_WNDMAP_END
//==============================================================================================================//
//																												//
//	スタイルの設定／取得関数																					//
//																												//
//==============================================================================================================//
//----- スタイル取得マクロ -------------------------------------------------------------------------------------//
#define	MGET_STY(NAME)	AJCEXPORT BOOL WINAPI AjcVthGetSty_##NAME(HWND hwnd) {									\
	return (BOOL)((MAjcGetWindowLong(hwnd, GWL_STYLE) & AJCVTHS_##NAME) != 0);									\
}
//----- スタイル設定マクロ -------------------------------------------------------------------------------------//
#define	MSET_STY(NAME)	AJCEXPORT VO WINAPI AjcVthSetSty_##NAME(HWND hwnd, BOOL f) {							\
	if (f) MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) |	AJCVTHS_##NAME);			\
	else   MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) & ~AJCVTHS_##NAME);			\
}

//----- ファイル出力コントロール表示／非表示(AJCVTHS_LOGFILE	) ----------------------------------------------//
MGET_STY(LOGFILE)
MSET_STY(LOGFILE)

//----- 固定ピッチ							(AJCVTHS_FIXEDPITCH	) ----------------------------------------------//
MGET_STY(FIXEDPITCH)
MSET_STY(FIXEDPITCH)

//----- 高速表示							(AJCVTHS_FAST		) ----------------------------------------------//
MGET_STY(FAST)
MSET_STY(FAST)

//----- 画面クリアーボタン無効				(AJCVTHS_NOCLSBTN	) ----------------------------------------------//
MGET_STY(NOCLSBTN)
MSET_STY(NOCLSBTN)

//----- フォント固定						(AJCVTHS_FIXEDFONT	) ----------------------------------------------//
MGET_STY(FIXEDFONT)
MSET_STY(FIXEDFONT)

//----- 改行動作固定						(AJCVTHS_FIXEDLF	) ----------------------------------------------//
MGET_STY(FIXEDLF)
MSET_STY(FIXEDLF)

//----- 縦スクロールバー非表示				(AJCVTHS_NOVSCROLL	) ----------------------------------------------//
MGET_STY(NOVSCROLL)
MSET_STY(NOVSCROLL)

//----- 横スクロールバー非表示				(AJCVTHS_NOHSCROLL	) ----------------------------------------------//
MGET_STY(NOHSCROLL)
MSET_STY(NOHSCROLL)

//----- 自動スクロールの許可／禁止			(AJCVTHS_NOSCRL		) ----------------------------------------------//
MGET_STY(NOSCRL)
MSET_STY(NOSCRL)

//----- コントロール外枠の非表示／表示		(AJCVTHS_NOBORDER	) ----------------------------------------------//
MGET_STY(NOBORDER)
MSET_STY(NOBORDER)

//----- スクロールアウト許可／禁止			(AJCVTHS_NOSCRLOUT	) ----------------------------------------------//
MGET_STY(NOSCRLOUT)
MSET_STY(NOSCRLOUT)

//----- ＣＲで改行							(AJCVTHS_CRCTRL		) ----------------------------------------------//
MGET_STY(CRCTRL)
MSET_STY(CRCTRL)

//----- ＬＦで改行							(AJCVTHS_LFCTRL		) ----------------------------------------------//
MGET_STY(LFCTRL)
MSET_STY(LFCTRL)

//----- ＶＲＡＭとその他の領域分離			(AJCVTHS_SEPARATE	) ----------------------------------------------//
MGET_STY(SEPARATE)
MSET_STY(SEPARATE)

//==============================================================================================================//
//																												//
//	プロパティの設定／取得関数																					//
//																												//
//==============================================================================================================//
//----- プロパティ取得マクロ -----------------------------------------------------------------------------------//
#define	MGET_PROP(TYPE, NAME)		AJCEXPORT TYPE WINAPI AjcVthGetProp_##NAME(HWND hwnd) {						\
	AJCVTHPROP	p;																								\
	AjcVthGetProp(hwnd, &p);																					\
	return p.NAME;																								\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MGET_PROPIX(TYPE, NAME)	AJCEXPORT TYPE WINAPI AjcVthGetProp_##NAME(HWND hwnd, UI ix) {					\
	TYPE		rc	  = 0;																						\
	AJCVTHPROP	p;																								\
	if (ix < 8) {																								\
		AjcVthGetProp(hwnd, &p);																				\
		rc = p.NAME[ix];																						\
	}																											\
	return rc;																									\
}
//----- プロパティ設定マクロ -----------------------------------------------------------------------------------//
#define	MSET_PROP(TYPE, NAME)		AJCEXPORT VO WINAPI AjcVthSetProp_##NAME(HWND hwnd, TYPE n) {				\
	AJCVTHPROP p;																								\
	AjcVthGetProp(hwnd, &p);																					\
	p.NAME = n;																									\
	AjcVthSetProp(hwnd, &p);																					\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MSET_PROPIX(TYPE, NAME)		AJCEXPORT VO WINAPI AjcVthSetProp_##NAME(HWND hwnd, UI ix, TYPE n) {		\
	AJCVTHPROP p;																								\
	if (ix < 8) {																								\
		AjcVthGetProp(hwnd, &p);																				\
		p.NAME[ix] = n;																							\
		AjcVthSetProp(hwnd, &p);																				\
	}																											\
}
//----- ＶＲＡＭ文字数 		(VramW) ----------------------------------------------------------------------------//
MGET_PROP(UI, VramW)
MSET_PROP(UI, VramW)

//----- ＶＲＡＭ行数		(VramH) ----------------------------------------------------------------------------//
MGET_PROP(UI, VramH)
MSET_PROP(UI, VramH)

//----- キャレットの高さ	(CaretH) ---------------------------------------------------------------------------//
MGET_PROP(UI, CaretH)
MSET_PROP(UI, CaretH)

//----- 最大行数			(MaxLines) -------------------------------------------------------------------------//
MGET_PROP(UI, MaxLines)
MSET_PROP(UI, MaxLines)

//----- タブ・スキップ数	(TabStep) --------------------------------------------------------------------------//
MGET_PROP(UI, TabStep)
MSET_PROP(UI, TabStep)

//----- 行間スペース		(LSpace) ---------------------------------------------------------------------------//
MGET_PROP(UI, LSpace)
MSET_PROP(UI, LSpace)

//----- 一時保留サイズ		(PendSize) -------------------------------------------------------------------------//
MGET_PROP(UI, PendSize)
MSET_PROP(UI, PendSize)

//----- 表示色				(rgb[]) ----------------------------------------------------------------------------//
MGET_PROPIX(UI, rgb)
MSET_PROPIX(UI, rgb)

//----- 文字の幅 -----------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcVthGetProp_CharWidth(HWND hwnd)
{
	UI		cx = 1, cy = 1, ly = 1;
	AjcVthGetCharInfo(hwnd, &cx, &cy, &ly);
	return	cx;
}

//----- 文字の高さ ---------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcVthGetProp_CharHeight(HWND hwnd)
{
	UI		cx = 1, cy = 1, ly = 1;
	AjcVthGetCharInfo(hwnd, &cx, &cy, &ly);
	return	cy;
}

//----- 行の高さ -----------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcVthGetProp_LineHeight(HWND hwnd)
{
	UI		cx = 1, cy = 1, ly = 1;
	AjcVthGetCharInfo(hwnd, &cx, &cy, &ly);
	return	ly;
}

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcVthSetProp_WndSize(HWND hwnd, UI width, UI height)
{
	if (IsWindow(hwnd)) {
		HWND		hParent;

		if (hParent = GetParent(hwnd)) {
			SetWindowPos(hParent, NULL, 0, 0, width, height, SWP_NOMOVE);
		}
	}
}

//----- フォント表現文字列取得 ---------------------------------------------------------------------------------//
AJCEXPORT int WINAPI AjcVthGetProp_Font(C_WCP pS, WCP pD, int len)
{
	int				rc = -1;
	AJCCFFONTINFOW	FontInfo = {0};			//	LOGFONT，行間スペース
	AJCCFPERMINFOW	PermInfo = {0};			//	ダイアログ設定値

	//	戻り情報初期化
	AjcSnPrintFW(pD, len, L"%s", pS);

	//	フォント情報，ダイアログ設定値初期化
	AjcCfInitFontInfoW(NULL, &FontInfo);
	AjcCfInitPermInfoW(NULL, NULL, &PermInfo);

	//	ソーステキストから、フォント選択ダイアログ情報設定
	AjcCfTextToInfoExW(pS, &FontInfo, &PermInfo);
	AjcCfMergeToInfoW(&FontInfo, &PermInfo);

	//	フォント設定ダイアログ
	if (AjcCfFontDlg(NULL, AJCCFF_HIDELSPACE, &FontInfo, &PermInfo, 0, NULL, NULL)) {
		//	フォント表現文字列作成
		AjcCfInfoToTextExW(&FontInfo, &PermInfo, pD);
		//	戻り値（行間スペース設定）
		rc = FontInfo.lsp;
	}
	return rc;
}
//----- フォント表現文字列によるフォント設定 -------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcVthSetProp_Font(HWND hwnd, C_WCP pText)
{
	LOGFONTW	lf;

	if (IsWindow(hwnd)) {
		AjcTextToLogFontW(pText, &lf);
		AjcVthSetFontInfoW(hwnd, &lf, -1);
	}
}
//----- ファイル，フォルダ ドロップの許可／禁止 ----------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcVthSetProp_AcceptFiles(HWND hwnd, BOOL fEnable)
{
	if (IsWindow(hwnd)) {
		UX	ExSty = MAjcGetWindowLong(hwnd, GWL_EXSTYLE);

		if (fEnable) ExSty |=  WS_EX_ACCEPTFILES;
		else		 ExSty &= ~WS_EX_ACCEPTFILES;

		MAjcSetWindowLong(hwnd, GWL_EXSTYLE, ExSty);
	}
}
AJCEXPORT BOOL WINAPI AjcVthGetProp_AcceptFiles(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = ((MAjcGetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_ACCEPTFILES) != 0);
	}
	return rc;
}
//----- 表示ウインドの行数，文字数 -----------------------------------------------------------------------------//
AJCEXPORT int WINAPI AjcVthGetProp_WndHeight(HWND hwnd)
{
	SIZE	sz = {0, 0};

	AjcVthGetWindowSize(hwnd, &sz);

	return sz.cy;
}

AJCEXPORT int WINAPI AjcVthGetProp_WndWidth(HWND hwnd)
{
	SIZE	sz = {0, 0};

	AjcVthGetWindowSize(hwnd, &sz);

	return sz.cx;
}
//----- チップテキスト設定／取得 -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcVthSetTipTextForMSIL(HWND hwnd, C_WCP pTxt)
{
	BOOL	rc = FALSE;
	UI		stl;
	WCP		pTmp;

	if (pTxt == NULL) pTxt = L"";

	stl = (UI)wcslen(pTxt);
	if (pTmp = (WCP)AJCMEM((stl + 1) * 2)) {
		AjcCLangStrToBinW(pTxt, pTmp, stl + 1);
		rc = AjcVthSetTipTextW(hwnd, pTmp);
		free(pTmp);
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	UI	WINAPI	AjcVthGetTipTextForMSIL(HWND hwnd, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	WCP		pTmp;

	if (pTmp = (WCP)AJCMEM(lBuf * 2)) {
		AjcVthGetTipTextW(hwnd, pTmp, lBuf);
		rc = AjcBinToCLangStrW(pTmp, pBuf, lBuf);
		free(pTmp);
	}
	return rc;
}
//----- 初期プロパティ退避 -------------------------------------------------------------------------------------//
AJCEXPORT	VO	WINAPI	AjcVthSaveIniPropForMSIL(HWND hwnd)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	memcpy(&pW->IniProp, &pW->prop, sizeof pW->IniProp);
}
//==============================================================================================================//
//																												//
//	メソッドのサブ関数																							//
//																												//
//==============================================================================================================//
//----- フォント設定 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcVthSetFontForMSIL(HWND hwnd, HFONT hFont)
{
	BOOL		rc = FALSE;
	LOGFONTW	lf;

	if (GetObjectW(hFont, sizeof lf, &lf)) {
		AjcVthSetFontInfoW(hwnd, &lf, -1);
		rc = TRUE;
	}
	return rc;
}
//----- フォント取得 -------------------------------------------------------------------------------------------//
AJCEXPORT	HFONT	WINAPI	AjcVthGetFontForMSIL(HWND hwnd)
{
	HFONT		hFont = NULL;
	AJCVTHPROPW	prop;

	if (AjcVthGetPropW(hwnd, &prop)) {
		hFont = CreateFontIndirectW(&prop.LogFont);
	}
	return hFont;
}
