﻿#include	"AjcInternal.h"
#include	"AjcCtrlVT100Def.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		サブ関数											//
//																												//
//**************************************************************************************************************//

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO			ClearVram			(PWRKVT100 pW);
static	int			ConvXPosToTextIdx	(PWRKVT100 pW, int x, C_WCP pTxt, C_UBP pAtt, UI lTxt);
static	UI			SubGetHScrollPos	(PWRKVT100 pW);
static	UI			SubGetVScrollPos	(PWRKVT100 pW);

//==============================================================================================================//
//																												//
//	ウインド背景色のペン，ブラシ生成																			//
//																												//
//==============================================================================================================//
VO		VthCreateBkWndObj(PWRKVT100 pW)
{
	if (pW->SvRgbBkWnd != pW->prop.rgb[pW->IxBkWnd]) {
		//	前のペン，ブラシ破棄
		if (pW->hPenBkWnd  != NULL) {DeleteObject (pW->hPenBkWnd);}
		if (pW->hBruBkWnd  != NULL) {DeleteObject (pW->hBruBkWnd);}
		//	ペン，ブラシ生成
		pW->hPenBkWnd = CreatePen(PS_SOLID, 1, pW->prop.rgb[pW->IxBkWnd]);
		pW->hBruBkWnd = CreateSolidBrush(pW->prop.rgb[pW->IxBkWnd]);
		//	ウインドのブラシハンドル更新
		SetClassLongPtr(pW->hMain, GCL_HBRBACKGROUND, (UX)pW->hBruBkWnd);
		//	ウインド背景色退避
		pW->SvRgbBkWnd = pW->prop.rgb[pW->IxBkWnd];
	}
}
//==============================================================================================================//
//																												//
//	テキストのピクセル長取得																					//
//																												//
//==============================================================================================================//
BOOL	VthGetTextExtentPoint(PWRKVT100 pW, HDC hdc, C_WCP pTxt, int len, LPSIZE pSz)
{
	BOOL	rc = TRUE;

	//	強制的に固定ピッチで算出
	if (pW->fFixedFont && (pW->style & AJCVTHS_FIXEDPITCH)) {
		C_WCP	p;
		int		i, stl;
		pSz->cy = pW->cyCharOrg;
		pSz->cx = 0;
		for (p = pTxt, i = 0; *p != 0 && i < len; p += stl, i += stl) {
			pSz->cx += pW->cxChar;
			if (AjcIsBigChar(p)) {
				pSz->cx += pW->cxChar;
			}
			if (MAjcIsLead(*p)) stl = 2;
			else				stl = 1;
		}
	}
	//	フォント依存のピッチで算出
	else {
		rc = GetTextExtentPoint32W(hdc, pTxt, len, pSz);
	}

	return rc;
}
//==============================================================================================================//
//	文字列パラメタからプロパティ設定																			//
//																												//
//	引　数	：	pTxt  - パラメタ文字列																			//
//				pProp - 現在のプロパティ値（プロパティ変更時は上書き）											//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO	VthSetPropByText(PWRKVT100 pW, WCP pTxt, PAJCVTHPROP pProp)
{
	WCP			p  = NULL;
	UI			ix;
	int			fr=-1, fg=-1, fb=-1;

	if (wcsnicmp(pTxt, L"P:", 2) == 0) {
		//----- パラメタ解析 ---------------------------------------------------//
		p = pTxt + 2;
		if (p = AjcStrTokW(p, L",")) {
			do {
				while (MAjcIsBlankW(*p)) p++;
				if		(wcsnicmp(p, L"VW=", 3) == 0) pProp->VramW	  = AjcAscToInt(p + 3);
				else if (wcsnicmp(p, L"VH=", 3) == 0) pProp->VramH	  = AjcAscToInt(p + 3);
				else if (wcsnicmp(p, L"CH=", 3) == 0) pProp->CaretH	  = AjcAscToInt(p + 3);
				else if (wcsnicmp(p, L"ML=", 3) == 0) pProp->MaxLines = AjcAscToInt(p + 3);
				else if (wcsnicmp(p, L"TS=", 3) == 0) pProp->TabStep  = AjcAscToInt(p + 3);
				else if (wcsnicmp(p, L"LS=", 3) == 0) pProp->LSpace	  = AjcAscToInt(p + 3);
				else if (wcsnicmp(p, L"PS=", 3) == 0) pProp->PendSize = AjcAscToInt(p + 3);
				else if (wcsnicmp(p, L"FN=", 3) == 0) AjcSnPrintF(pProp->LogFont.lfFaceName, LF_FACESIZE, L"%s", p + 3);
				else if (wcsnicmp(p, L"BC=", 3) == 0) VthSetBorderColor(pW,  (COLORREF)AjcAscToInt(p + 3));
				else if (wcsnicmp(p, L"FS=", 3) == 0) AjcVthSetFindProfileSect(pW->hBack, p + 3);
				else if (wcsnicmp(p, L"LF=", 3) == 0) {
					p += 3;
					AjcGetSepNumbers(p, L'/', L"iiiiibbbbbbbb", &pProp->LogFont.lfHeight		,
																&pProp->LogFont.lfWidth			,
																&pProp->LogFont.lfEscapement	,
																&pProp->LogFont.lfOrientation	,
																&pProp->LogFont.lfWeight		,
																&pProp->LogFont.lfItalic		,
																&pProp->LogFont.lfUnderline		,
																&pProp->LogFont.lfStrikeOut		,
																&pProp->LogFont.lfCharSet		,
																&pProp->LogFont.lfOutPrecision	,
																&pProp->LogFont.lfClipPrecision	,
																&pProp->LogFont.lfQuality		,
																&pProp->LogFont.lfPitchAndFamily);
				}
				else if (*p >= L'0' && *p <= L'7' && *(p+1) == L'=') {
					ix = (*p & 15);
					p += 2;
					pProp->rgb[ix] = AjcHexToUI(p);
				}
			} while(p = AjcStrTokW(NULL, L","));
		}
	}
}
//==============================================================================================================//
//	プロパティ文字列生成																						//
//																												//
//	引　数	：	pTxt	- パラメタ文字列																		//
//				lTxt	- 文字列長																				//
//																												//
//	戻り値	：	テキスト長																						//
//==============================================================================================================//
UI		VthMakePropText	  (PWRKVT100 pW, WCP pTxt, UI lTxt)
{
	AjcSnPrintF(pTxt, lTxt, L"P: VW=%u, VH=%u, CH=%u, ML=%u, TS=%u, LS=%u, PS=%u, FN=%s, BC=0x%X, "
							L"LF=%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d, "
							L"0=0x%X, 1=0x%X, 2=0x%X, 3=0x%X, 4=0x%X, 5=0x%X, 6=0x%X, 7=0x%X",

							pW->prop.VramW						,
							pW->prop.VramH						,
							pW->prop.CaretH						,
							pW->prop.MaxLines					,
							pW->prop.TabStep					,
							pW->prop.LSpace						,
							pW->prop.PendSize					,
							pW->prop.LogFont.lfFaceName			,
							pW->RgbBorder						,
							pW->prop.LogFont.lfHeight			,
							pW->prop.LogFont.lfWidth			,
							pW->prop.LogFont.lfEscapement		,
							pW->prop.LogFont.lfOrientation		,
							pW->prop.LogFont.lfWeight			,
							pW->prop.LogFont.lfItalic			,
							pW->prop.LogFont.lfUnderline		,
							pW->prop.LogFont.lfStrikeOut		,
							pW->prop.LogFont.lfCharSet			,
							pW->prop.LogFont.lfOutPrecision		,
							pW->prop.LogFont.lfClipPrecision	,
							pW->prop.LogFont.lfQuality			,
							pW->prop.LogFont.lfPitchAndFamily	,
							pW->prop.rgb[0]						,
							pW->prop.rgb[1]						,
							pW->prop.rgb[2]						,
							pW->prop.rgb[3]						,
							pW->prop.rgb[4]						,
							pW->prop.rgb[5]						,
							pW->prop.rgb[6]						,
							pW->prop.rgb[7]);

	return (UI)wcslen(pTxt);
}
//==============================================================================================================//
//	プロパティ設定																								//
//																												//
//	引　数	：	pNewProp	- 新プロパティ																		//
//																												//
//	戻り値	：	TRUE - OK,	FALSE - Error																		//
//==============================================================================================================//
BOOL	VthSetCtrlProp(PWRKVT100 pW, PCAJCVTHPROP pNewProp)
{
	BOOL		rc	 = TRUE;
	PAJCVTHPROP pOld = &pW->prop;
	PAJCVTHPROP pNew;
	AJCVTHPROP	NewProp;

	BOOL		fNeedResetVramInfo = FALSE;

	UI			OldCxChar	 = pW->cxChar;
	UI			OldCyChar	 = pW->cyChar;
	UI			OldCyCharOrg = pW->cyCharOrg;

	//----- プロパティ値コピー -----------------------------------------------------------------------------//
	memcpy(&NewProp, pNewProp, sizeof NewProp);
	pNew = &NewProp;

	//----- プロパティ値調整 -------------------------------------------------------------------------------//
	if (pNew->VramW	   <  4			 ) pNew->VramW	  = 4;
	if (pNew->VramW	   >  32000		 ) pNew->VramW	  = 32000;
	if (pNew->VramH	   <  4			 ) pNew->VramH	  = 4;
	if (pNew->MaxLines <  pNew->VramH) pNew->MaxLines = pNew->VramH;

	//----- 行間スペース設定 -------------------------------------------------------------------------------//
	pOld->LSpace  = pNew->LSpace;
	pW->cyChar	  = pW->cyCharOrg + pNew->LSpace;

	//----- フォント生成 -----------------------------------------------------------------------------------//
	if (memcmp(&pOld->LogFont, &pNew->LogFont, sizeof(LOGFONT)) != 0 || pW->hFontText == NULL) {
		HFONT		hFont;
		LOGFONT		LogFont;
		UI			cxChar, cyChar;

		//	新フォント情報退避
		memcpy(&LogFont, &pNew->LogFont, sizeof(LOGFONT));
		LogFont.lfWidth = 0;

		//	フォントを強制的に作成＆フォント情報訂正
		hFont = AjcCreateFont(&LogFont);		//	
		//	フォントサイズ設定
		pW->fFixedFont = VthSetFontSize(pW->hBack, &LogFont, &cxChar, &cyChar);
		//----- 旧フォントハンドル削除 -------------------------------------//
		if (pW->hFontText != NULL) DeleteObject(pW->hFontText);
		//----- フォント情報設定 -------------------------------------------//
		memcpy(&pOld->LogFont, &LogFont, sizeof(LOGFONT));
		//----- 新フォントハンドル，フォントサイズ設定 ---------------------//
		pW->hFontText = hFont;
		pW->cxChar	  = cxChar;
		pW->cyCharOrg = cyChar;
		pW->cyChar	  = cyChar + pNew->LSpace;
		//----- フォーカス状態ならば、キャレット変更 -----------------------//
		if (pW->fFocus) {
			HideCaret(pW->hMain);
			DestroyCaret();
			CreateCaret(pW->hMain, NULL, 2, pW->cyChar);
			VthSetCaret(pW);
		}
		//----- フォントサイズ（前回値）退避 -------------------------------//
		pW->SvFontHeight = LogFont.lfHeight;
		//----- フォント情報をフォント選択ダイアログ情報へ反映 -------------//
		//	フォント情報
		memcpy(&pW->DwkFontInfo.lf, &pW->prop.LogFont, sizeof pW->DwkFontInfo.lf);
		pW->DwkFontInfo.lsp = pW->prop.LSpace;
		//	フォント選択ダイアログ情報
		AjcCfMergeToInfoW(&pW->DwkFontInfo, &pW->DwkPermInfo);
	}
	//----- ＶＲＡＭ生成 -----------------------------------------------------------------------------------//
	if (pOld->VramW != pNew->VramW || pOld->VramH != pNew->VramH || pW->pVram == NULL) {
		WCP		pVram;
		UI		lsz = pNew->VramW * 3;
		lsz = ((lsz + 1) & -2);	// ２バイト単位にバウンダリアップ
		if (pVram = (WCP)AJCMEM(lsz * pNew->VramH)) {
			if (pW->pVram != NULL) free(pW->pVram);
			pOld->VramW   = pNew->VramW;
			pOld->VramH   = pNew->VramH;
			pW->VramLSize = lsz;
			pW->pVram	  = pVram;
			fNeedResetVramInfo = TRUE;
		}
		else rc = FALSE;
	}
	//----- ラインポインタ生成 -----------------------------------------------------------------------------//
	if (pOld->MaxLines != pNew->MaxLines || pW->pLPtr == NULL) {
		PLINEPTR	pLPtr;
		if (pLPtr = (PLINEPTR)AJCMEM(sizeof(LINEPTR) * pNew->MaxLines)) {
			memset(pLPtr, 0, sizeof(LINEPTR) * pNew->MaxLines);
			if (pW->pLPtr != NULL) {
				VthReleaseAllLinePtrs(pW->pLPtr, pOld->MaxLines);
				free(pW->pLPtr);
			}
			pOld->MaxLines = pNew->MaxLines;
			pW->pLPtr = pLPtr;
			fNeedResetVramInfo = TRUE;
		}
		else rc = FALSE;
	}
	//----- キャレットの高さ／タブステップ -----------------------------------------------------------------//
	pOld->CaretH  = __min(pW->cyCharOrg, pNew->CaretH);
	pOld->TabStep = pNew->TabStep;
	//----- 描画色設定 -------------------------------------------------------------------------------------//
	memcpy(&pOld->rgb, &pNew->rgb, sizeof pOld->rgb);
	//----- 保留テキストサイズ設定 -------------------------------------------------------------------------//
	pOld->PendSize = pNew->PendSize;

	//----- ＶＲＡＭ情報リセット ---------------------------------------------------------------------------//
	if (fNeedResetVramInfo) {
		//----- ＶＲＡＭ行数調整 -----------//
		if (pW->prop.VramH > pW->prop.MaxLines) {
			pW->prop.VramH = pW->prop.MaxLines;
		}
		//----- 全テキストクリアー ---------//
		VthClearAllText(pW);
	}

	//----- スクロール情報調整 --------------//
	VthAdjustScrollInfo(pW);

	//----- 文字情報変化通知 ----------------//
	if (OldCxChar != pW->cxChar	 ||	 OldCyChar != pW->cyChar || OldCyCharOrg != pW->cyCharOrg) {
		pW->NtcCyLine = pW->cyChar;
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_CHARINFO),
						fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcCyLine);
	}

	//----- 高速モード時全テキスト表示 ------//
	pW->fFsDrawAll = TRUE;

	//----- 再描画 --------------------------//
	InvalidateRect(pW->hMain, NULL, FALSE);

	return rc;
}
//==============================================================================================================//
//	ボーダー色設定																								//
//																												//
//	引　数	：	color	- ボーダー色																			//
//																												//
//	戻り値	：	TRUE - OK,	FALSE - Error																		//
//==============================================================================================================//
BOOL	VthSetBorderColor(PWRKVT100 pW,  COLORREF color)
{
	BOOL	rc = FALSE;
	HPEN	hPen;

	if (hPen = CreatePen(PS_SOLID, 1, color)) {
		if (pW->hPenBorder != NULL) DeleteObject(pW->hPenBorder);
		pW->RgbBorder  = color;
		pW->hPenBorder = hPen;
		InvalidateRect(pW->hBack, NULL, FALSE);
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//																												//
//	モード設定																									//
//																												//
//==============================================================================================================//
VO		VthSetMode(PWRKVT100 pW, UI mode)
{
	UI		SvMode = pW->Mode;

	pW->Mode = mode;

	if ((SvMode & MD_SELECT) != (mode & MD_SELECT)) {
		//	バックウインドの上下左右の余白部描画
		POINT	pts [4][4];
		int		cnts[4] = {4, 4, 4, 4};
		HRGN	hRgn = NULL;

		//	上部矩形
		pts[0][0].x = 0;				pts[0][0].y = 0;
		pts[0][1].x = pW->bw;			pts[0][1].y = 0;
		pts[0][2].x = pW->bw;			pts[0][2].y = VMRG;
		pts[0][3].x = 0;				pts[0][3].y = VMRG;

		//	下部矩形
		pts[1][0].x = 0;				pts[1][0].y = pW->bh - VMRG;
		pts[1][1].x = pW->bw;			pts[1][1].y = pW->bh - VMRG;
		pts[1][2].x = pW->bw;			pts[1][2].y = pW->bh;
		pts[1][3].x = 0;				pts[1][3].y = pW->bh;

		//	左部矩形
		pts[2][0].x = 0;				pts[2][0].y = 0;
		pts[2][1].x = HMRG;				pts[2][1].y = 0;
		pts[2][2].x = HMRG;				pts[2][2].y = pW->bh;
		pts[2][3].x = 0;				pts[2][3].y = pW->bh;

		//	右部矩形
		pts[3][0].x = pW->bw - HMRG;	pts[3][0].y = 0;
		pts[3][1].x = pW->bw;			pts[3][1].y = 0;
		pts[3][2].x = pW->bw;			pts[3][2].y = pW->bh;
		pts[3][3].x = pW->bw - HMRG;	pts[3][3].y = pW->bh;

		hRgn = CreatePolyPolygonRgn(pts[0], cnts, 4, WINDING);
		InvalidateRgn(pW->hBack, hRgn, FALSE);
		DeleteObject(hRgn);
	}
}
//==============================================================================================================//
//	全ラインポインタ開放																						//
//																												//
//	引	数	：	pL		- ラインポインタ先頭エントリアドレス													//
//				n		- ラインポインタエントリ数																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		VthReleaseAllLinePtrs(PLINEPTR pL, UI n)
{
	UI		i;

	for (i=0; i<n; i++) {
		if (pL->fAlloc && pL->pTxt) {
			free(pL->pTxt);
			pL->fAlloc = FALSE;
			pL->len	   = 0;
			pL->pTxt   = NULL;
		}
		pL++;
	}
}
//==============================================================================================================//
//	フォントサイズ設定																							//
//																												//
//	引	数	：	hWndDmy - いずれかのウインドハンドル															//
//				pLogFont- フォント生成データ																	//
//				pCxChar - フォント幅サイズ格納バッファ															//
//				pCxChar - フォント高さサイズ格納バッファ														//
//																												//
//	戻り値	：	TRUE - 固定ピッチ, FALSE - 可変ピッチ															//
//==============================================================================================================//
BOOL	VthSetFontSize(HWND hWndDmy, LPLOGFONT pLogFont, UIP pCxChar, UIP pCyChar)
{
	BOOL		rc;
	HDC			hdc;
	TEXTMETRIC	tm;
	HFONT		hFont;

	hdc = GetDC(hWndDmy);											//	ＤＣハンドル取得

	hFont = (HFONT)SelectObject(hdc, CreateFontIndirect(pLogFont));
	GetTextMetrics(hdc, &tm);
	*pCxChar = __max(1, tm.tmAveCharWidth);
	*pCyChar = __max(1, tm.tmHeight);

	//	固定ピッチチェック
	rc = ((pLogFont->lfPitchAndFamily & 3) == FIXED_PITCH);

	DeleteObject(SelectObject(hdc, hFont));
	ReleaseDC(hWndDmy, hdc);										//	ＤＣハンドル解放

	return rc;
}
//==============================================================================================================//
//	スクロール情報調整																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		VthAdjustScrollInfo(PWRKVT100 pW)
{
	UI		cwWnd = pW->ww / pW->cxChar;
	UI		lwWnd = pW->wh / pW->cyChar;
	UI		LnoWTop, cp, lp;

	//----- 横スクロール情報設定 --------------------//
	if (pW->IxOfs + cwWnd > pW->prop.VramW) {
		if (pW->prop.VramW >= cwWnd) cp = pW->prop.VramW - cwWnd;
		else						 cp = 0;
	}
	else cp = pW->IxOfs;

	VthSetHScrollInfo(pW, cp);

	//----- 縦スクロール情報設定 --------------------//
	LnoWTop = VthIxToLno(pW, pW->IxWTop);
	if (LnoWTop + lwWnd > pW->LCnt) {
		if (pW->LCnt >= lwWnd) lp = pW->LCnt - lwWnd;
		else				   lp = 0;
	}
	else lp = LnoWTop;

	VthSetVScrollInfo(pW, lp);
}

//==============================================================================================================//
//	横スクロール情報設定																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				cp	  - 左端位置（－１の場合は位置設定しない）													//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		VthSetHScrollInfo(PWRKVT100 pW, UI cp)
{
	SCROLLINFO		si;		//	スクロール情報
	UI				wc;		//	ウインドに表示できる平均文字数

	//----- 横スクロール情報設定 --------------------------------//
	wc		  = pW->ww / pW->cxChar;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask  = SIF_PAGE | SIF_RANGE;
	if (cp != -1) si.fMask |= SIF_POS;
	si.nMin	  = 0;
	if (pW->fFixedFont) {
		si.nMax	  = pW->prop.VramW * 2;
	}
	else {
		si.nMax	  = pW->prop.VramW * 4;
	}
	si.nPage  = wc;
	si.nPos	  = cp;

	//----- スクロールバー設定 ＆ 表示／非表示 ------------------//
	//	NOHSCROLLスタイルの場合、スクロールバー非表示
	if		(pW->style & AJCVTHS_NOHSCROLL) {
		ShowScrollBar(pW->hMain, SB_HORZ, FALSE);
	}
	//	ＶＲＡＭ幅がウインド幅に満たない場合、スクロールバー非表示
	else if (pW->ww >= ((si.nMax + 1) * pW->cxChar)) {
		ShowScrollBar(pW->hMain, SB_HORZ, FALSE);
	}
	//	その他の場合、スクロールバーを設定＆表示
	else {
		ShowScrollBar(pW->hMain, SB_HORZ, TRUE);
		SetScrollInfo(pW->hMain, SB_HORZ, &si, TRUE);
	}

	//----- 表示先頭桁位置設定 ----------------------------------//
	if (cp != -1) {
		pW->IxOfs = cp;
	}
}
//==============================================================================================================//
//	縦スクロール情報設定																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				lp	  - 行位置（－１の場合は位置設定しない）													//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		VthSetVScrollInfo(PWRKVT100 pW, UI lp)
{
	SCROLLINFO		si;

	//----- 縦スクロール情報設定 --------------------------------//
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask  = SIF_PAGE | SIF_RANGE;
	if (lp != -1) si.fMask |= SIF_POS;
	si.nMin	  = 0;
	si.nMax	  = VthIxToLno(pW, pW->IxVTop + pW->prop.VramH - 1);
	si.nPage  = pW->wh / pW->cyChar;
	si.nPos	  = lp;

	//----- スクロールバー設定 ＆ 表示／非表示 ------------------//
	//	NOVSCROLLスタイルの場合、スクロールバー非表示
	if		(pW->style & AJCVTHS_NOVSCROLL) {
		ShowScrollBar(pW->hMain, SB_VERT, FALSE);
	}
	//	表示データがウインド行数に満たない場合、スクロールバー非表示
	else if (pW->wh >= ((si.nMax + 1) * pW->cyChar)) {
		ShowScrollBar(pW->hMain, SB_VERT, FALSE);
	}
	//	その他の場合、スクロールバーを設定＆表示
	else {
		ShowScrollBar(pW->hMain, SB_VERT, TRUE);
		SetScrollInfo(pW->hMain, SB_VERT, &si, TRUE);
	}

	//----- 表示先頭行インデクス設定 ----------------------------//
	if (lp != -1) {
		pW->IxWTop = VthLnoToIx(pW, lp);
	}
}
//==============================================================================================================//
//	行位置→インデクス変換																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				lp	  - 行位置																					//
//																												//
//	戻り値	：	インデクス																						//
//==============================================================================================================//
UI		VthLnoToIx(PWRKVT100 pW, UI lp)
{
	UI		rc;

	rc = ((pW->IxSrt + lp) % pW->prop.MaxLines);
	return rc;
}
//==============================================================================================================//
//	インデクス→行位置変換																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				lp	  - インデクス																				//
//																												//
//	戻り値	：	行位置																							//
//==============================================================================================================//
UI		VthIxToLno(PWRKVT100 pW, UI ix)
{
	UI		rc;

	if (ix >= pW->IxSrt) {
		rc = ix - pW->IxSrt;
	}
	else {
		rc = (pW->prop.MaxLines - pW->IxSrt) + ix;
	}
	return rc;
}
//==============================================================================================================//
//	全テキストクリアー																							//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO	VthClearAllText(PWRKVT100 pW)
{
	PLINEPTR	pLPtr;
	WCP			pTxt;
	UBP			pAtt;
	UI			i;

	//----- 全内部テキスト開放 ---------//
	VthReleaseAllLinePtrs(pW->pLPtr, pW->prop.MaxLines);
	//----- 保留テキスト破棄 -----------//
	AjcRngPurge(pW->hRngTxt);
	//----- ＶＲＡＭクリアー -----------//
	pTxt = pW->pVram;
	pAtt = ATT_PTR(pTxt);
	for (i=0; i<pW->prop.VramH; i++) {
		VthMemSetW(pTxt, 0x20		, pW->prop.VramW);
		VthMemSetA(pAtt, VAT_DEFAULT, pW->prop.VramW);
		pTxt = (WCP)((UBP)pTxt + pW->VramLSize);
		pAtt = ATT_PTR(pTxt);
	}
	//----- ＶＲＡＭポインタ設定 -------//
	pLPtr = pW->pLPtr;
	pTxt  = pW->pVram;
	for (i=0; i<pW->prop.VramH; i++) {
		pLPtr->fVram  = TRUE;
		pLPtr->fAlloc = FALSE;
		pLPtr->len	  = 0;
		pLPtr->pTxt	  = pTxt;
		pLPtr++;
		pTxt = (WCP)((UBP)pTxt + pW->VramLSize);
	}
	//----- 内部テキストインジケータ ---//
	for (; i<pW->prop.MaxLines; i++) {
		pLPtr->fVram  = FALSE;
		pLPtr->fAlloc = FALSE;
		pLPtr->len	  = 0;
		pLPtr->pTxt	  = NULL;
		pLPtr++;
	}
	//----- 表示位置リセット -----------//
	pW->IxSrt = pW->IxWTop = pW->IxVTop = 0;
	pW->lp = pW->cp = pW->cpx = 0;
	//----- 有効行数リセット -----------//
	pW->LCnt = 0;
	//----- スクロール情報設定 ---------//
	VthSetHScrollInfo(pW, 0);
	VthSetVScrollInfo(pW, 0);
	//----- 半端バイトクリアー ---------//
	pW->SvStl = 0;
	//----- キャレット設定 -------------//
	VthSetCaret(pW);
	//----- ドラッグ／選択状態解除 -----//
	if (pW->Mode & MD_DRAG) {
		ReleaseCapture();
		KillTimer(pW->hMain, 1);
	}
	VthSetMode(pW, pW->Mode & ~(MD_DRAG | MD_SELECT));
	//----- 高速モード時全テキスト表示 -//
	pW->fFsDrawAll = TRUE;
}
//==============================================================================================================//
//	マウスポイント→行位置，テキストインデクス変換																//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				x, y  - マウスポイント																			//
//				pLp	  - テキスト行位置格納バッファ			（－１：ＷＮＤより上，－２：ＷＮＤより下）			//
//				pIx	  - テキストインデクス位置格納バッファ	（－１：ＷＮＤより左，－２：ＷＮＤより右）			//
//				pCp   - 桁位置格納バッファ					（不要時はNULL)										//
//																												//
//	戻り値	：	≠NULL - マウスポイントはＷＮＤ上（行テキストへのポインタ）										//
//				＝NULL - マウスポイントはＷＮＤ外																//
//==============================================================================================================//
WCP		VthMusToTextIdx(PWRKVT100 pW, int x, int y, int *pLp, int *pIx, int *pCp)
{
	int		ix;
	WCP		pTxt = NULL;
	UBP		pAtt = NULL;
	int		len  = 0;

	//----- 行位置算出 ---------------------------------------------------------//
	if		(y < 0) {
		*pLp = -1;
	}
	else if (y > (int)pW->wh) {
		*pLp = -2;
	}
	else if (pW->LCnt > 0) {
		int		lix = ((pW->IxWTop + (y / pW->cyChar)) % pW->prop.MaxLines);
		*pLp = VthIxToLno(pW, lix);
		*pLp = __min(*pLp, (int)pW->LCnt - 1);
	}
	else {
		*pLp = 0;
	}
	//----- 文字インデクス算出 -------------------------------------------------//
	if		(x < 0) {				//	Ｘ位置はウインドより左側？
		*pIx = -1;
	}
	else if (x >= (int)pW->ww) {	//	Ｘ位置はウインドより右側？
		*pIx = -2;
	}
	else {
		if (*pLp >= 0) {			//	Ｙ位置はウインド内？
			int		lix = ((pW->IxWTop + (y / pW->cyChar)) % pW->prop.MaxLines);
			pTxt = pW->pLPtr[lix].pTxt;
			pAtt = (UBP)((pW->pLPtr[lix].fVram) ? (pW->pLPtr[lix].pTxt + pW->prop.VramW) :
												  (pTxt + pW->pLPtr[lix].len));
			len  = pW->pLPtr[lix].len;
			//	Ｘ位置が示すテキストの文字インデクス設定
			ix = ConvXPosToTextIdx(pW, x + (pW->IxOfs * pW->cxChar), pTxt, pAtt, len);
			//	戻り値（文字インデクス）設定
			*pIx = ix;
			//	戻り値（桁位置）格納バッファ
			if (pCp != NULL) {
				*pCp = VthIdxToCPos(pTxt, len, ix);
			}
		}
	}
	return pTxt;
}
//==============================================================================================================//
//	キャレット表示																								//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		VthSetCaret(PWRKVT100 pW)
{
	int			x;				//	キャレット表示Ｘ位置
	int			y;				//	キャレット表示Ｙ位置
	int			wl;				//	ウインド上端からの相対行数
	PLINEPTR	pL;				//	カーソル行のテキストポインタ情報
	WCP			pTxt;			//	カーソル行のテキストポインタ
	UBP			pAtt;			//	カーソル行の属性ポインタ

	if (pW->fFocus) {
		if (pW->fCaret) {
			//	ウインド先頭からの相対行数
			wl = VthIxToLno(pW, pW->IxVTop) + pW->lp - VthIxToLno(pW, pW->IxWTop);
			//	カーソル行のテキストポインタ設定
			pL	 = &pW->pLPtr[(pW->IxWTop + wl) % pW->prop.MaxLines];
			pTxt = pL->pTxt;
			pAtt = ATT_PTR(pTxt);
			//	カーソル位置がウインド先頭以降ならば、Ｘ位置算出
			if (wl >= 0) {
				int		ix;
				HDC		hdc   = GetDC(pW->hMain);
				HFONT	hFont = (HFONT)SelectObject(hdc, pW->hFontText);
				SIZE	sz;
				//	キャレットＹ位置算出
				y = wl * pW->cyChar;
				//	カーソルＸ位置設定（サロゲート２ワード目ならば１つ戻す）
				ix = pW->cpx;
				//	キャレットＸ位置算出
				_ASSERT((pAtt[ix] & VAT_SUR2) == 0);
				VthGetTextExtentPoint(pW, hdc, pTxt, ix, &sz);			//		カーソル位置までのピクセル数
				x = (sz.cx - (int)((pW->IxOfs) * pW->cxChar));			//		Ｘ＝ウインド左端からのピクセル数
				SelectObject(hdc, hFont);
				ReleaseDC(pW->hBack, hdc);
			}
			//	カーソル位置がウインド先頭以前ならば、ウインドから外す
			else {
				y = -10000;
				x = -10000;
			}
			//	キャレット位置設定
			ShowCaret(pW->hMain);
			SetCaretPos(x, y);
		}
		else {
			HideCaret(pW->hMain);
		}
	}
}
//==============================================================================================================//
//	テキストインデクス→桁位置変換																				//
//																												//
//	引　数	：	pTxt  - 行テキスト																				//
//				lTxt  - 行テキスト長																			//
//				cp	  - 桁位置																					//
//																												//
//	戻り値	：	桁位置に対応するインデクス値																	//
//==============================================================================================================//
UI		VthIdxToCPos(C_WCP pTxt, UI lTxt, UI idx)
{
	UI		ix	= 0;
	UI		cp	= 0;
	UI		len = __min(lTxt, idx + 1);

	while (pTxt[ix] != 0 && ((MAjcIsLeadW(pTxt[ix]) && MAjcIsTrailW(pTxt[ix + 1])) ? (ix + 2) < len : (ix + 1) < len)) {
		//	桁位置更新
		if (AjcIsBigChar(&pTxt[ix])) cp += 2;
		else						 cp++;
		//	インデクス更新
		if (MAjcIsLeadW(pTxt[ix]) && MAjcIsTrailW(pTxt[ix + 1])) ix += 2;
		else													 ix++;
	}
	return cp;
}

//==============================================================================================================//
//	桁位置→テキストインデクス変換																				//
//																												//
//	引　数	：	pTxt  - 行テキスト																				//
//				lTxt  - 行テキスト長																			//
//				pos   - 桁位置																					//
//																												//
//	戻り値	：	インデクスに対応する桁位置																		//
//==============================================================================================================//
UI		VthCPosToIdx(C_WCP pTxt, UI lTxt, UI pos)
{
	UI		ix	= 0;
	UI		cp	= 0;

	while (pTxt[ix] != 0 && (AjcIsBigChar(&pTxt[ix])							  ? (cp + 2) <= pos  : (cp + 1) <= pos ) &&
							(MAjcIsLeadW(pTxt[ix]) && MAjcIsTrailW(pTxt[ix + 1])  ? (ix + 2) <	lTxt : (ix + 1) <  lTxt)) {
		//	桁位置更新
		if (AjcIsBigChar(&pTxt[ix])) cp += 2;
		else						 cp++;
		//	インデクス更新
		if (MAjcIsLeadW(pTxt[ix]) && MAjcIsTrailW(pTxt[ix + 1])) ix += 2;
		else													 ix++;
	}
	return ix;
}
//==============================================================================================================//
//	最終ページへスクロール																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		VthScrollToBottom(PWRKVT100 pW)
{
	UI		pos;
	UI		lwWnd = pW->wh / pW->cyChar;

	if (pW->LCnt > lwWnd) {
		pos = pW->LCnt - lwWnd;
		VthSetVScrollInfo(pW, pos);
	}
}
//==============================================================================================================//
//	選択範囲補正値取得																							//
//																												//
//	引	数	：	pSL, pSC, pEL, pEC - 補正値格納バッファ															//
//																												//
//	戻り値	：	TRUE  - 選択範囲ＩＸが共に、先頭ＩＸの片側にある												//
//				FALSE - 選択範囲ＩＸが、先頭ＩＸの両側にある													//
//==============================================================================================================//
BOOL	VthAdjustSelectInfo(PWRKVT100 pW, UIP pSL, UIP pSC, UIP pEL, UIP pEC)
{
	BOOL	rc;

	//----- 選択範囲ＩＸが共に、先頭ＩＸの片側にある場合 ---------------------------//
	if ((pW->SelInf.ixSL >= pW->IxSrt && pW->SelInf.ixEL >= pW->IxSrt) ||
		(pW->SelInf.ixSL <	pW->IxSrt && pW->SelInf.ixEL <	pW->IxSrt)) {
		if		(pW->SelInf.ixEL == pW->SelInf.ixSL) {
			*pSL = pW->SelInf.ixSL; *pSC = __min(pW->SelInf.ixSC, pW->SelInf.ixEC);
			*pEL = pW->SelInf.ixEL; *pEC = __max(pW->SelInf.ixSC, pW->SelInf.ixEC);
		}
		else if (pW->SelInf.ixEL >	pW->SelInf.ixSL) {
			*pSL = pW->SelInf.ixSL; *pSC = pW->SelInf.ixSC;
			*pEL = pW->SelInf.ixEL; *pEC = pW->SelInf.ixEC;
		}
		else {
			*pSL = pW->SelInf.ixEL; *pSC = pW->SelInf.ixEC;
			*pEL = pW->SelInf.ixSL; *pEC = pW->SelInf.ixSC;
		}
		rc = TRUE;
	}
	//----- 選択範囲ＩＸが、先頭ＩＸの両側にある場合 ------------------------------//
	else {
		if (pW->SelInf.ixSL >= pW->IxSrt) {
			*pSL = pW->SelInf.ixSL; *pSC = pW->SelInf.ixSC;
			*pEL = pW->SelInf.ixEL; *pEC = pW->SelInf.ixEC;
		}
		else {
			*pSL = pW->SelInf.ixEL; *pSC = pW->SelInf.ixEC;
			*pEL = pW->SelInf.ixSL; *pEC = pW->SelInf.ixSC;
		}
		rc = FALSE;
	}

	return rc;
}



//--------------------------------------------------------------------------------------------------------------//
//	ＶＲＡＭクリアー																							//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ClearVram(PWRKVT100 pW)
{
	UI		i;
	WCP		pTxt;
	UBP		pAtt;

	//----- 保留テキスト破棄 -----------//
	AjcRngPurge(pW->hRngTxt);
	//----- ＶＲＡＭクリアー -----------//
	pTxt = pW->pVram;
	pAtt = ATT_PTR(pTxt);
	for (i=0; i<pW->prop.VramH; i++) {
		VthMemSetW(pTxt, 0x20		, pW->prop.VramW);
		VthMemSetA(pAtt, VAT_DEFAULT, pW->prop.VramW);
		pTxt = (WCP)((UBP)pTxt + pW->VramLSize);
		pAtt = ATT_PTR(pTxt);
	}
	//----- ドラッグ／選択状態解除 -----//
	if (pW->Mode & MD_DRAG) {
		ReleaseCapture();
		KillTimer(pW->hMain, 1);
	}
	VthSetMode(pW, pW->Mode & ~(MD_DRAG | MD_SELECT));
}
//--------------------------------------------------------------------------------------------------------------//
//	Ｘ位置から、テキストインデクスを算出	（行テキスト先頭をX=0としたワード位置を算出）						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//				x	  - Ｘ位置（０：テキストの先頭）															//
//				pTxt  - 行テキストへのポインタ																	//
//				lTxt  - テキストのバイト数																		//
//																												//
//	戻り値	：	ｘが示すインデクス位置	（０ ～ lTxt）															//
//--------------------------------------------------------------------------------------------------------------//
static	int		ConvXPosToTextIdx(PWRKVT100 pW, int x, C_WCP pTxt, C_UBP pAtt, UI lTxt)
{
	UI		ix	= 0;
	UI		stl = 0;
	HDC		hdc;
	HFONT	hFont;
	SIZE	sz1, sz2;

	hdc = GetDC(pW->hMain);
	hFont = (HFONT)SelectObject(hdc, pW->hFontText);
	if (lTxt != 0) {
		sz1.cx = 0;
		while (ix < lTxt) {
			if (pAtt[ix] & VAT_SUR1) {stl = 2;}
			else					 {stl = 1;}
			VthGetTextExtentPoint(pW, hdc, pTxt, ix + stl, &sz2);
			if (x >= sz1.cx && x < sz2.cx) {
				int		cw = sz2.cx - sz1.cx;
				if (x > (sz1.cx + (cw * 90 / 100))) {
					ix += stl;
				}
				break;
			}
			sz1.cx = sz2.cx;
			ix	  += stl;
		}
		_ASSERT(ix == lTxt || !(pAtt[ix] & VAT_SUR2));
	}
	SelectObject(hdc, hFont);
	ReleaseDC(pW->hMain, hdc);

	return ix;
}
//--------------------------------------------------------------------------------------------------------------//
//	横スクロール位置取得																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	横スクロール位置																				//
//--------------------------------------------------------------------------------------------------------------//
static	UI	SubGetHScrollPos(PWRKVT100 pW)
{
	SCROLLINFO		si;

	si.cbSize = sizeof(SCROLLINFO);
	si.fMask  = SIF_POS;
	GetScrollInfo(pW->hMain, SB_HORZ, &si);
	return si.nPos;
}
//--------------------------------------------------------------------------------------------------------------//
//	縦スクロール位置取得																						//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	横スクロール位置																				//
//--------------------------------------------------------------------------------------------------------------//
static	UI	SubGetVScrollPos(PWRKVT100 pW)
{
	SCROLLINFO		si;

	si.cbSize = sizeof(SCROLLINFO);
	si.fMask  = SIF_POS;
	GetScrollInfo(pW->hMain, SB_VERT, &si);
	return si.nPos;
}
