﻿#include	"AjcInternal.h"
#include	"AjcCtrlVT100Def.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）		バックウインド										//
//																												//
//**************************************************************************************************************//

#define	IDC_MAIN	5001

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);
static	VO			DeleteAllResource	 (PWRKVT100 pW);
static	VO			StyleSetting		 (PWRKVT100 pW);
static	VO			EnableCtrls			 (PWRKVT100 pW, BOOL fEnable);
static	VO			LgfWndCreate		 (PWRKVT100 pW);
static	VO			LgfWndDelete		 (PWRKVT100 pW);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		VthWndProcBack()
{
	return AJC_WNDPROC_NAME(Back);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	バックウインドプロシージャ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE		)
{
	PWRKVT100		pW;
	BOOL			rc = -1;
	RECT			r;
	UI				sty;

	do {
		//----- ウインドワーク生成 -----------------------------------------------------------------------------//
		if ((pW = (PWRKVT100)AJCMEM(sizeof(WRKVT100))) == NULL) break;
		memset(pW, 0, sizeof(WRKVT100));
		//----- インスタンス識別ＩＤ設定 -----------------------------------------------------------------------//
		pW->InstID = INST_ID;
		//----- デフォルトフォント情報設定 ---------------------------------------------------------------------//
		{	HWND	hP = GetParent(hwnd);
			HFONT	hF = NULL;
			//	親ウインドのフォントハンドル取得
			if (hP != NULL) hF = (HFONT)SendMessage(hP, WM_GETFONT, 0, 0);
			if (hF == NULL) hF = (HFONT)GetStockObject(SYSTEM_FONT);
			//	デフォルトフォント情報設定
			GetObject(hF, sizeof(LOGFONT), &pW->lfParentFont);
		}
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//----- バックウインドハンドル／ウインドサイズ初期化 ---------------------------------------------------//
		pW->hBack		= hwnd;											//	バックウインドハンドル
		GetClientRect(hwnd, &r);
		pW->bw = r.right - r.left;										//	バックウインドの幅
		pW->bh = r.bottom - r.top;										//	バックウインドの高さ
		//----- 変数初期化 -------------------------------------------------------------------------------------//
		pW->style		  = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);	//	ウインドスタイル
		pW->fEnable		  = !(pW->style & WS_DISABLED);					//	コントロールの有効状態
		pW->fFocus		  = FALSE;										//	フォーカス状態フラグ
		pW->fCaret		  = TRUE;										//	キャレット表示フラグ
		pW->fFirstGetText = TRUE;										//	最初のWM_GETTEXTを示すフラグ
		pW->Mode		  = MD_NORMAL;									//	処理モード
		pW->SvTxtFontSize = 3;											//	HTMLのフォントサイズ
		//----- テキスト一時保留バッファ生成 -------------------------------------------------------------------//
		pW->hRngTxt = AjcRngCreate(&pW->StaRngTxt, sizeof pW->StaRngTxt, 4096);
		if (pW->hRngTxt == NULL) break;
		//----- ドロップファイル名一時保留バッファ生成 ---------------------------------------------------------//
		pW->hRngFile = AjcRngCreate(&pW->StaRngFile, sizeof pW->StaRngFile, 4096);
		if (pW->hRngFile == NULL) break;
		//----- ドロップＤＩＲ名一時保留バッファ生成 -----------------------------------------------------------//
		pW->hRngDir	 = AjcRngCreate(&pW->StaRngDir , sizeof pW->StaRngDir , 4096);
		if (pW->hRngDir	 == NULL) break;
		//----- 文字コード判定用インスタンス生成 ---------------------------------------------------------------//
		pW->hMbc  = AjcMbcCreate(256, AJCMBC_SJIS);
		pW->SvMbk = AJCMBC_SJIS;
		if (pW->hMbc == NULL) break;
		//----- ＶＲＡＭ描画情報初期化 -------------------------------------------------------------------------//
		pW->lp	 = pW->cp	= pW->cpx   = 0;							//	カーソル位置
		pW->svlp = pW->svcp = pW->svcpx = 0;							//	カーソル退避
		pW->sur1 = 0;													//	漢字１バイト目退避
		pW->att	 = VAT_DEFAULT;											//	表示属性
		//----- 表示位置初期化 ---------------------------------------------------------------------------------//
		pW->IxSrt  = 0;													//	ラインポインタ先頭位置
		pW->IxVTop = 0;													//	ＶＲＡＭ先頭位置
		pW->IxWTop = 0;													//	表示先頭位置
		pW->IxOfs  = 0;													//	表示先頭桁位置
		//----- ＥＳＣバッファ情報初期化 -----------------------------------------------------------------------//
		pW->EscIx  = 0;													//	ＥＳＣバッファインデクス
		//----- 最初の WM_SETFONT を示すフラグ -----------------------------------------------------------------//
		pW->fFirstWmSetFont = TRUE;
		//----- ボーダーペン生成 -------------------------------------------------------------------------------//
		pW->RgbBorder = RGB_BLACK;
		if ((pW->hPenBorder = CreatePen(PS_SOLID, 1, pW->RgbBorder)) == NULL) break;
		//----- ウインドの背景色（パレット番号）----------------------------------------------------------------//
		pW->IxBkWnd  = 7;
		//----- チップテキスト表示条件 -------------------------------------------------------------------------//
		pW->fShowAlways = TRUE;
		//----- メインウインド生成 -----------------------------------------------------------------------------//
		sty = (UI)(MAjcGetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_ACCEPTFILES);
		pW->hMain = CreateWindowEx(	sty,
									(WCP)VthClassMain,					// window class name
									L"",								// window caption
									WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL | WS_CLIPCHILDREN,	// window style
									HMRG,								// initial x position
									VMRG,								// initial y position
									pW->bw - (HMRG * 2),				// initial x size
									pW->bh - (VMRG * 2),				// initial y size
									hwnd,								// parent window handle
									(HMENU)IDC_MAIN,					// window menu handle
									hDllInst,							// program instance handle
									pW);								// creation parameters
		if (pW->hMain == NULL) break;
		AJCTIP_SETFRIENDA(pW->hMain);
		ShowWindow		 (pW->hMain, SW_SHOW);
		//----- スタイル設定 -----------------------------------------------------------------------------------//
		StyleSetting(pW);
		//----- コントロールの有効状態設定 ---------------------------------------------------------------------//
		EnableCtrls(pW, pW->fEnable = !(pW->style & WS_DISABLED));
		//----- スクロール情報初期化 ---------------------------------------------------------------------------//
		VthSetHScrollInfo(pW, 0);
		VthSetVScrollInfo(pW, 0);
		//----- 戻り値＝正常終了 -------------------------------------------------------------------------------//
		rc = 0;

	} while(0);

	if (rc == -1) {
		DeleteAllResource(pW);
		MAjcSetWindowLong(hwnd, 0, (UX)NULL);
	}

	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	if (pW != NULL) {
		//----- 全リソース解放 -------------------------------------------------//
		DeleteAllResource(pW);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZE		)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	//----- ウインドサイズ設定 -----------------------------//
	pW->bw = LOWORD(lParam);
	pW->bh = HIWORD(lParam);
	MoveWindow(pW->hMain, HMRG, VMRG, pW->bw - (HMRG * 2), pW->bh - (VMRG * 2), TRUE);
	InvalidateRect(hwnd, NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_PAINT		)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;
	HBRUSH		hBrush;
	HPEN		hPen;
	RECT		r;

	//	描画開始
	hdc	  = BeginPaint(hwnd, &ps);

	//----- 描画ペン，ブラシ設定 --------------------//
	//	無効状態時
	if (!pW->fEnable) {
		hPen   = hPenGrayText;
		hBrush = hBruBtnFace;
	}
	//	テキスト選択時
	else if (pW->Mode & MD_SELECT) {
		if (pW->style & AJCVTHS_NOBORDER) hPen = hPenGrayText;
		else                              hPen = pW->hPenBorder;
		hBrush = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	}
	//	通常描画時
	else {
		if (pW->style & AJCVTHS_NOBORDER) hPen = pW->hPenBkWnd;
		else                              hPen = pW->hPenBorder;
		hBrush = pW->hBruBkWnd;
	}

	hPen   = SelectObject(hdc, hPen);
	hBrush = SelectObject(hdc, hBrush);

	//	外枠表示
	GetClientRect(hwnd, &r);
	Rectangle(hdc, r.left, r.top, r.right, r.bottom);
	//	描画オブジェクト回復
	SelectObject(hdc, hBrush);
	SelectObject(hdc, hPen);
	//	描画終了
	EndPaint(hwnd, &ps);

	//	ログファイルコントロール再表示 
	if (pW->hWndLgf != NULL) {
		MoveWindow(pW->hWndLgf, pW->ww - 17, 1, 16, 16, TRUE);
		ShowWindow(pW->hWndLgf, SW_SHOW);
		InvalidateRect(pW->hWndLgf, NULL, FALSE);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXTLENGTH)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	WC			txt[1024];

	VthMakePropText(pW, txt, AJCTSIZE(txt));

	return wcslen(txt);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXT	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	if (pW->fFirstGetText) {
		pW->fFirstGetText = FALSE;
		rc = AjcDefWindowProc(hwnd, msg, wParam, lParam);
	}
	else {
		rc = VthMakePropText(pW, (WCP)lParam, (UI)wParam);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETTEXT	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;
	AJCVTHPROP	prop;

	memcpy(&prop, &pW->prop, sizeof(AJCVTHPROP));
	VthSetPropByText(pW, (WCP)lParam, &prop);
	rc = VthSetCtrlProp(pW, &prop);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_STYLECHANGED)
{
	PWRKVT100		pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	LPSTYLESTRUCT	p  = (LPSTYLESTRUCT)lParam;

	if		(wParam == GWL_STYLE) {
		pW->style = p->styleNew;
		StyleSetting(pW);
	}
	else if (wParam == GWL_EXSTYLE) {
		MAjcSetWindowLong(pW->hMain, GWL_EXSTYLE, p->styleNew & WS_EX_ACCEPTFILES);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_ENABLE)
{
	PWRKVT100		pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	EnableCtrls(pW, pW->fEnable = (BOOL)wParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETFOCUS)
{
	PWRKVT100		pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	if (pW->hMain) {
		SetFocus(pW->hMain);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETFONT)
{
	PWRKVT100		pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	AJCVTHPROP		prop;

	if (pW->hMain) {
		//	最初の WM_SETFONT の場合、ウインドキャプションによるプロパティ設定を行う
		//	※	ダイアログ下のコントロールである場合、ダイアログからのWM_SETFONTによりフォントが設定されるが
		//		テキストでフォント設定を優先させるため、キャプションによるフォント設定がある場合は初回のWM_SETFONTをスキップする
		//		尚、キャプション中にフォントの記述が無ければ、SET_FONTの内容がそのまま有効となる。
		if (!pW->fFirstWmSetFont || !pW->fSkipFirstWmSetFont) {	//	２回目以降のWM_SETFONT or WM_SETFONTをスキップしない？
			memcpy(&prop, &pW->prop, sizeof prop);
			if (GetObject((HFONT)wParam, sizeof(LOGFONT), &prop.LogFont) == sizeof(LOGFONT)) {
				//	プロパティ（フォント情報）設定
				AjcVthSetProp(hwnd, &prop);
				//	描画
				InvalidateRect(hwnd 	, NULL, TRUE);
			}
		}
	}
	pW->fFirstWmSetFont = FALSE;

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETFONT)
{
	PWRKVT100		pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	HFONT			hFont = NULL;

	if (pW->hMain) {
		hFont = pW->hFontText;
	}

	return (LRESULT)hFont;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, AJCVTHM_SETFONT)
{
	PWRKVT100		pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	BOOL			rc = FALSE;
	AJCVTHPROP		prop;

	if (!(pW->style & AJCVTHS_FIXEDFONT)) {
		memcpy(&prop, &pW->prop, sizeof(AJCVTHPROP));
		if (GetObject((HFONT)wParam, sizeof(LOGFONT), &prop.LogFont) == sizeof(LOGFONT)) {
			prop.LSpace = (UI)lParam;
			rc = VthSetCtrlProp(pW, &prop);
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE				)
	AJC_WNDMAP_MSG(Back, WM_DESTROY				)
	AJC_WNDMAP_MSG(Back, WM_SIZE				)
	AJC_WNDMAP_MSG(Back, WM_PAINT				)
	AJC_WNDMAP_MSG(Back, WM_GETTEXTLENGTH		)
	AJC_WNDMAP_MSG(Back, WM_GETTEXT				)
	AJC_WNDMAP_MSG(Back, WM_SETTEXT				)
	AJC_WNDMAP_MSG(Back, WM_STYLECHANGED		)
	AJC_WNDMAP_MSG(Back, WM_ENABLE				)
	AJC_WNDMAP_MSG(Back, WM_SETFOCUS			)
	AJC_WNDMAP_MSG(Back, WM_SETFONT				)
	AJC_WNDMAP_MSG(Back, WM_GETFONT				)

	AJC_WNDMAP_MSG(Back, AJCVTHM_SETFONT		)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	全リソース開放																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DeleteAllResource(PWRKVT100 pW)
{
	if (pW != NULL) {
		if (pW->hFontText  != NULL) {DeleteObject (pW->hFontText);  pW->hFontText	= NULL;}
		if (pW->hPenBorder != NULL) {DeleteObject (pW->hPenBorder); pW->hPenBorder	= NULL;}
		if (pW->hPenBkWnd  != NULL) {DeleteObject (pW->hPenBkWnd);  pW->hPenBkWnd	= NULL;}
		if (pW->hBruBkWnd  != NULL) {DeleteObject (pW->hBruBkWnd);  pW->hBruBkWnd	= NULL;}
		if (pW->hWndLgf	   != NULL) {DestroyWindow(pW->hWndLgf);    pW->hWndLgf		= NULL;}
		if (pW->hMain	   != NULL) {DestroyWindow(pW->hMain);	    pW->hMain		= NULL;}
		if (pW->pVram	   != NULL) {free(pW->pVram);			    pW->pVram		= NULL;}
		if (pW->pLPtr	   != NULL) {VthReleaseAllLinePtrs(pW->pLPtr,  pW->prop.MaxLines);
									 free(pW->pLPtr);			    pW->pLPtr		= NULL;}

		if (pW->hRngTxt	   != NULL) {AjcRngDelete(pW->hRngTxt );    pW->hRngTxt		= NULL;}
		if (pW->hRngFile   != NULL) {AjcRngDelete(pW->hRngFile);    pW->hRngFile	= NULL;}
		if (pW->hRngDir	   != NULL) {AjcRngDelete(pW->hRngDir );    pW->hRngDir		= NULL;}
		if (pW->hMbc	   != NULL) {AjcMbcDelete(pW->hMbc);	    pW->hMbc		= NULL;}
		if (pW->pDblClkLine!= NULL) {free(pW->pDblClkLine);		    pW->pDblClkLine	= NULL;}
		if (pW->hBitmap	   != NULL) {DeleteObject(pW->hBitmap);	    pW->hBitmap	  	= NULL;}

		if (pW->pToolTipTxt != NULL) {free(pW->pToolTipTxt);	   pW->pToolTipTxt	= NULL;}

		SubTtlBmpRemv(&pW->TtlInfo);	//	タイトル描画オブジェクト

		free(pW);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	スタイル設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		StyleSetting(PWRKVT100 pW)
{
	//	ログファイルコントロール生成・削除
	if (pW->style & AJCVTHS_LOGFILE) {
		LgfWndCreate(pW);
	}
	else {
		LgfWndDelete(pW);
	}
	//	画面クリアーボタン非表示
	if (pW->style & AJCVTHS_NOCLSBTN) {
		ShowWindow(pW->hBtnCls, SW_HIDE);
	}
	//	高速モード時全テキスト表示
	pW->fFsDrawAll = TRUE;
	//	再描画
	InvalidateRect(pW->hBack , NULL, FALSE);
	//	スクロール情報設定
	VthSetHScrollInfo(pW, -1);
	VthSetVScrollInfo(pW, -1);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロールの有効状態設定																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		EnableCtrls(PWRKVT100 pW, BOOL fEnable)
{
	InvalidateRect(pW->hBack, NULL, FALSE);
	if (pW->hWndLgf) {
		EnableWindow(pW->hWndLgf, fEnable);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ログファイル出力コントロール生成																			//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	LgfWndCreate(PWRKVT100 pW)
{
	RECT	r;

	if (pW->hWndLgf == NULL) {
		pW->hWndLgf = CreateWindow(	L"AjcCtrlLogFile",	//	window class name
									L"",				//	window caption
									WS_CHILD,			//	window style
									0, 0, 0, 0,			//	initial position, size
									pW->hMain,			//	parent window handle
									NULL,				//	window menu handle
									hDllInst,			//	program instance handle
									NULL);				//	creation parameters

		if (pW->hWndLgf != NULL) {
			GetClientRect(pW->hMain, &r);
			MoveWindow(pW->hWndLgf, (r.right - r.left) - 24, 12, 16, 16, FALSE);
			ShowWindow(pW->hWndLgf, SW_SHOW);
		}
	}
}

//--------------------------------------------------------------------------------------------------------------//
//	ログファイル出力コントロール削除																			//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	LgfWndDelete(PWRKVT100 pW)
{
	if (pW->hWndLgf != NULL) {
		DestroyWindow(pW->hWndLgf);
		pW->hWndLgf = NULL;
	}
}
