﻿#include	"AjcInternal.h"
#include	"AjcCtrlVT100Def.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（ＶＴ１００エミュレーション）			メインウインド									//
//																												//
//**************************************************************************************************************//

//----- 画面クリアーボタン情報 ---------------------------------------------------------------------------------//
#define	BTN_CLS_WIDTH	32
#define	BTN_CLS_HEIGHT	28
#define	IDC_BTN_CLS		5001

//--------------------------------------------------------------------------------------------------------------//
//	タイマＩＤ																									//
//--------------------------------------------------------------------------------------------------------------//
enum {
	TID_DRAG	= 1	,			//	ドラッグ操作用タイマ
	TID_CLSBTN		,			//	画面クリアーボタン非表示監視タイマ
};

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Main);

static	int			BackToCharPosIf2ndSurrWord(PWRKVT100 pW, int lp, int cp);
static	int			ForwToCharPosIf2ndSurrWord(PWRKVT100 pW, int lp, int cp);
static	BOOL		SubTextOut			  (PWRKVT100 pW, HDC hdc, int x, int y, C_WCP pTxt, int len, COLORREF BakRgb);
static	VO			SetDefaultLogFont(LPLOGFONT pLogFont);
static	BOOL		IsSelect(PWRKVT100 pW, UI lLine, UI ixL, UI ixC);
static	COLORREF	DarkRgb(PWRKVT100 pW, COLORREF rgb);
static	VO			CopyFontAndLineSpace(PWRKVT100 pW);
static	VO			PasteFontAndLineSpace(PWRKVT100 pW);
static	VO			SetFontToAllSiblingsWindow(PWRKVT100 pW);
static	VO			SetFontToAllThreadWindow  (PWRKVT100 pW);
static	BOOL		IsExistVT100InThreadWindow	(PWRKVT100 pW);
static	BOOL		IsExistVT100InSiblingsWindow(PWRKVT100 pW);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		VthWndProcMain()
{
	return AJC_WNDPROC_NAME(Main);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メインウインドプロシージャ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE		)
{
	PWRKVT100		pW = (PWRKVT100)((LPCREATESTRUCT)lParam)->lpCreateParams;
	RECT			r;
	AJCVTHPROP		prop;
	WC				PropTxt[1024];

	//----- ウインド・エクストラ領域へワークポインタ設定 -------------------------------------------------------//
	MAjcSetWindowLong(hwnd, 0, (UX)pW);

	//----- メインウインドハンドルとサイズ設定 -----------------------------------------------------------------//
	pW->hMain = hwnd;
	GetClientRect(hwnd, &r);
	pW->ww = r.right - r.left;
	pW->wh = r.bottom - r.top;

	//----- デフォルト・プロパティ設定 -------------------------------------------------------------------------//
	memset(&prop, 0, sizeof prop);
	prop.VramW		= DEF_VRAMW;
	prop.VramH		= DEF_VRAMH;
	prop.CaretH		= 2;
	prop.MaxLines	= DEF_MAXLINES;
	prop.TabStep	= DEF_TABSTEP;
	prop.LSpace		= DEF_LSPACE;
	prop.PendSize	= DEF_PENDSIZE;
	memcpy(&prop.LogFont, &pW->lfParentFont, sizeof(LOGFONT));
	prop.rgb[0]		= RGB(	 0,	  0,   0 );		//	黒
	prop.rgb[1]		= RGB( 255,	  0,   0 );		//	赤
	prop.rgb[2]		= RGB(	 0, 192,   0 );		//	緑
	prop.rgb[3]		= RGB( 192, 192,   0 );		//	黄
	prop.rgb[4]		= RGB(	 0,	  0, 255 );		//	青
	prop.rgb[5]		= RGB( 192,	  0, 192 );		//	紫
	prop.rgb[6]		= RGB(	 0, 192, 192 );		//	水色
	prop.rgb[7]		= RGB( 255, 255, 255 );		//	白(グレー)

	//----- 検索文字列永続化セクション名初期化 -----------------------------------------------------------------//
	wcscpy(pW->FindSect, L"_DefaultStrFindInfoSect_");

	//----- ウインドキャプションからプロパティ情報設定 ---------------------------------------------------------//
	pW->fFirstGetText = TRUE;
	GetWindowText(pW->hBack, PropTxt, AJCTSIZE(PropTxt));
	//	キャプションでフォントが指定されている場合は、最初のWM_SETFONTをスキップする
	pW->fSkipFirstWmSetFont = (wcsistr(PropTxt, L"FN=") != NULL || wcsistr(PropTxt, L"LF=") != NULL);
	//	キャプションからプロパティ情報設定
	VthSetPropByText(pW, PropTxt, &prop);

	//----- デフォルトフォント設定 -----------------------------------------------------------------------------//
	memcpy(&pW->lfDefFont, &prop.LogFont, sizeof(LOGFONT));

	//----- ポップアップメニューのマスク値初期化 ---------------------------------------------------------------//
	pW->PopupMask = AJCVTHMM_ALL;

	//----- フォント選択ダイアログ情報初期化 -------------------------------------------------------------------//
	//	フォント情報
	memcpy(&pW->DwkFontInfo.lf, &pW->prop.LogFont, sizeof pW->DwkFontInfo.lf);
	pW->DwkFontInfo.lsp = pW->prop.LSpace;
	//	ダイアログ情報
	AjcCfInitPermInfoW(NULL, NULL, &pW->DwkPermInfo);

	//----- 文字列検索ダイアログ情報初期化 ---------------------------------------------------------------------//
	pW->fResetPos	= TRUE;					//	初回検索時は検索開始位置リセット要
	pW->FindKey		= VK_F3;
	//	プロファイルからロード
	VthLoadStrFindInfo(pW);

	//----- 初期プロパティ退避 ---------------------------------------------------------------------------------//
	memcpy(&pW->IniProp, &prop, sizeof pW->IniProp);

	//----- プロパティ設定 -------------------------------------------------------------------------------------//
	VthSetCtrlProp(pW, &prop);

	//----- ウインドの背景色のペン，ブラシ生成 -----------------------------------------------------------------//
	pW->SvRgbBkWnd = (COLORREF)-1;
	VthCreateBkWndObj(pW);

	//----- 画面クリアーボタン生成 -----------------------------------------------------------------------------//
	pW->hBtnCls = CreateWindow(L"BUTTON",								// window class name
							LNGSEL(L"クリアー",	L"Clear"),				// window caption
							WS_CHILD | BS_ICON,							// window style
							0,											// initial x position
							0,											// initial y position
							BTN_CLS_WIDTH,								// initial x size
							BTN_CLS_HEIGHT,								// initial y size
							hwnd,										// parent window handle
							(HMENU)IDC_BTN_CLS,							// window menu handle
							hDllInst,									// program instance handle
							NULL);										// creation parameters
	if (pW->hBtnCls != NULL) {
		SendMessage(pW->hBtnCls, WM_SETFONT, (WPARAM)hDefFontVar14 , TRUE); 
		SendMessage(pW->hBtnCls, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoWipe);
		AjcTipTextAdd(pW->hBtnCls, LNGSEL(L"画面クリアー", L"Clear screen"));
		ShowWindow (pW->hBtnCls, SW_HIDE);
	}

	//----- マウスホイール情報設定 -----------------------------------------------------------------------------//
	SendMessage(hwnd, WM_SETTINGCHANGE, 0, 0);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	//	文字列検索ダイアログ破棄
	VthDeleteDlgFind(pW);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SETTINGCHANGE)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	UL			ScrollLines;

	SystemParametersInfo(SPI_GETWHEELSCROLLLINES, 0, &ScrollLines, 0);
	if (ScrollLines) {
		pW->mhDeltaPerLine = WHEEL_DELTA / ScrollLines;
	}
	else {
		pW->mhDeltaPerLine = 0;
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	//----- ウインドサイズ設定 -----------------------------//
	pW->ww = LOWORD(lParam);
	pW->wh = HIWORD(lParam);

	//----- 画面クリアーボタン移動 -------------------------//
	SetWindowPos(pW->hBtnCls, NULL, (pW->ww - BTN_CLS_WIDTH) / 2, 1, 0, 0, SWP_NOSIZE);

	//----- ビットマップオブジェクト再生成 -----------------//
	if (pW->hBitmap != NULL) {
		DeleteObject(pW->hBitmap);
	}
	if (pW->hBitmap = AjcDibCreate(pW->ww, pW->wh, 32, &pW->DibInfo)) {
		AjcDibClear(&pW->DibInfo, pW->prop.rgb[pW->IxBkWnd]);
	}
	//----- 高速描画モード時、全ライン描画 -----------------//
	pW->fFsDrawAll = TRUE;

	//----- スクロール情報調整 -----------------------------//
	VthAdjustScrollInfo(pW);

	//----- キャレット表示 ---------------------------------//
	VthSetCaret(pW);

	//----- ログファイル出力コントロール配置 ---------------//
	if (pW->hWndLgf != NULL) {
		MoveWindow(pW->hWndLgf, pW->ww - 17, 1, 16, 16, TRUE);
		ShowWindow(pW->hWndLgf, SW_SHOW);
		InvalidateRect(pW->hWndLgf, NULL, FALSE);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubPaintNormal(HWND hwnd);
static	VO	SubPaintFast  (HWND hwnd);

AJC_WNDPROC(Main, WM_PAINT		)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	//	テキスト描画
	if (pW->style & AJCVTHS_FAST) {
		SubPaintFast  (hwnd);
	}
	else {
		SubPaintNormal(hwnd);
	}

	return 0;
}
//----- WM_PAINT : 通常描画 ------------------------------------------------------------------------------------//
static	VO	SubPaintNormal(HWND hwnd)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc, mdc;
	SIZE		sz;
	int			xs, xc, xe, y, txl;
	UI			ixL, len;
	PLINEPTR	pL;
	UI			ixS, ixC;
	UI			atS, atC;
	WCP			pTxtS, pTxtC;
	UBP			pAttS, pAttC;
	RECT		r;
	HFONT		hFont;
	COLORREF	SvTxtRgb, SvBakRgb, SvBruRgb;
	COLORREF	TxtRgb	,	BakRgb,	BruRgb;
	HBRUSH		hBru = NULL;

	//	ＤＣ設定
	hdc  = BeginPaint(hwnd, &ps);

	do {
		//	ディスプレィ互換ＤＣ作成
		if ((mdc = CreateCompatibleDC(hdc)) == NULL) {
			break;
		}

		//	画面サイズのビットマップ作成
		if (pW->hBitmap == NULL) {
			pW->hBitmap = AjcDibCreate(pW->ww, pW->wh, 32, &pW->DibInfo);
			if (pW->hBitmap == NULL) break;
		}
		SelectObject(mdc, pW->hBitmap);

		//	フォントセレクト
		hFont = (HFONT)SelectObject(mdc, pW->hFontText);

		//	ブラシハンドル，退避表示色無効化
		SvTxtRgb = SvBakRgb = SvBruRgb = -1;

		//	イネーブル状態時の塗りつぶし
		if (pW->fEnable) {
			//	バッファ部分とＶＲＡＭ部分をセパレート時
			if (pW->style & AJCVTHS_SEPARATE) {
				//	バッファ部分の矩形サイズ算出
				r.left = r.top = r.bottom = 0;
				r.right  = pW->ww;
				ixL	= pW->IxWTop;
				pL	= &pW->pLPtr[ixL];
				while (pL->pTxt != NULL && r.bottom < (int)pW->wh && !pL->fVram) {
					r.bottom += pW->cyChar;
					ixL = ((ixL + 1) % pW->prop.MaxLines);
					pL	= &pW->pLPtr[ixL];
				}
				//	バッファ部分を暗いウインド背景色で塗りつぶす
				if (r.bottom != 0) {
					BruRgb = DarkRgb(pW, pW->prop.rgb[pW->IxBkWnd]);
					hBru = CreateSolidBrush(BruRgb);
					FillRect(mdc, &r, hBru);
					DeleteObject(hBru); hBru = NULL;
				}
				//	VRAM部分（以降画面下端まで）をウインド背景色で塗りつぶす
				if ((int)pW->wh > r.bottom) {
					r.top	 = r.bottom;
					r.bottom = pW->wh;
					FillRect(mdc, &r, pW->hBruBkWnd);
				}
			}
			//	非セパレート時は全体をウインド背景色で塗りつぶす
			else {
				GetClientRect(hwnd, &r);
				FillRect(mdc, &r, pW->hBruBkWnd);
			}
		}
		//	ディスエーブル状態の場合、全体をボタンフェース色で塗りつぶす
		else {
			GetClientRect(hwnd, &r);
			FillRect(mdc, &r, hBruBtnFace);
		}

		//	テキスト描画
		y	= 0;																//	描画Ｙ位置＝０
		ixL	= pW->IxWTop;														//	表示先頭ラインインデクス
		pL	= &pW->pLPtr[ixL];													//	表示先頭ラインポインタ
		while (pL->pTxt != NULL && y < (int)pW->wh) {							//	ラインループ
			xc = -((int)(pW->IxOfs * pW->cxChar));								//		描画Ｘ位置初期化
			xe = xc;															//		テキストの描画ピクセル数初期化
			len = pL->len;														//		有効データ長設定
			ixC	  = 0;															//		先頭テキストインデクス置設定
			if (ixC < len) {													//		オフセット右端のテキストデータあり？
				pTxtC = pL->pTxt + ixC;											//			先頭テキストポインタ設定
				if (pL->fVram) pAttC = (UBP)(pL->pTxt + pW->prop.VramW) + ixC;	//			・
				else		   pAttC = (UBP)(pL->pTxt + pL->len) + ixC;			//			・
				atC = (*pAttC & (VAT_BC | VAT_FC));								//			先頭描画色設定
				if (IsSelect(pW, len, ixL, ixC)) {								//			・
					atC = (((atC << 4) | (atC >> 4)) & 0xFF);					//			・
				}
				xs	  = xc;														//			先頭描画位置退避
				atS	  = atC;													//			先頭描画色退避
				ixS	  = ixC;													//			先頭描画位置退避
				pTxtS = pTxtC;													//			先頭テキスト位置退避
				pAttS = pAttC;													//			・
				while (TRUE) {													//			文字描画ループ
					if (xc >= (int)pW->ww || ixC >= len || atC != atS) {		//				WND終端／テキスト終端／表示色変化？
						txl = ixC - ixS;										//					描画ワード数設定
						if (pW->fEnable) TxtRgb = pW->prop.rgb[atS & 7];		//					テキスト色設定
						else			 TxtRgb = GetSysColor(COLOR_GRAYTEXT);	//					・
						if (SvTxtRgb != TxtRgb) {								//					・
							SetTextColor(mdc, SvTxtRgb = TxtRgb);				//					・
						}
						if (pW->fEnable) BakRgb = pW->prop.rgb[(atS >> 4) & 7];	//					背景色設定
						else			 BakRgb = GetSysColor(COLOR_BTNFACE);	//					・
						if (!pL->fVram && (pW->style & AJCVTHS_SEPARATE)) {		//					・
							BakRgb = DarkRgb(pW, BakRgb);						//					・
						}														//					・
						if (SvBakRgb != BakRgb) {								//					・
							SetBkColor(mdc, SvBakRgb = BakRgb);					//					・
						}
						SubTextOut(pW, mdc, xs, y, pTxtS, txl, BakRgb);			//					前ワードまでのテキスト表示
						VthGetTextExtentPoint(pW, mdc, pTxtS, txl, &sz);		//					テキスト描画ピクセル数更新
						xe += sz.cx;											//					・
						xc += sz.cx;
						if (pW->prop.LSpace) {									//					行間スペースを背景色で塗りつぶし
							r.left	 = xs;										//					・
							r.right	 = xe;										//					・
							r.top	 = y  + pW->cyCharOrg;						//					・
							r.bottom = y  + pW->cyChar;							//					・
							BruRgb = BakRgb;									//					・
							if (SvBruRgb != BruRgb) {							//					・
								if (hBru != NULL) DeleteObject(hBru);			//					・
								hBru = CreateSolidBrush(BruRgb);				//					・
								SvBruRgb = BruRgb;								//					・
							}													//					・
							FillRect(mdc, &r, hBru);							//					・
						}
						if (xc >= (int)pW->ww || ixC >= len) {					//					ＷＮＤ終端／テキスト終端？
							break;												//						→終了
						}
						xs	= xe;												//					先頭描画位置退避
						atS = atC;												//					先頭描画色退避
						ixS = ixC;												//					先頭文字インデクス退避
						pTxtS = pTxtC;											//					先頭テキストポインタ退避
						pAttS = pAttC;											//					・
					}
					pTxtC++;													//				テキストポインタ更新
					pAttC++;													//				・
					ixC++;														//				文字インデクス更新
					if (ixC < len) {											//				テキスト終端以内？
						atC = *pAttC & (VAT_BC | VAT_FC);						//					描画色設定
						if (IsSelect(pW, len, ixL, ixC)) {						//					・
							atC = (((atC << 4) | (atC >> 4)) & 0xFF);			//					・
						}
					}
				}
			}
			y  += pW->cyChar;													//		描画Ｙ位置更新
			ixL = ((ixL + 1) % pW->prop.MaxLines);								//		ラインインデクス更新
			pL	= &pW->pLPtr[ixL];												//		ラインポインタ設定
			if (ixL == pW->IxSrt) {												//		バッファ先頭位置？
				break;															//			→終了
			}
		}

		//	タイトル描画
		if (pW->style & AJCVTHS_LOGFILE) 
			SubTtlBmpDrawC(&pW->TtlInfo, hwnd, mdc, 0, 18, pW->fEnable, pW->prop.rgb[pW->IxBkWnd]);
		else
			SubTtlBmpDrawC(&pW->TtlInfo, hwnd, mdc, 0,	0, pW->fEnable, pW->prop.rgb[pW->IxBkWnd]);

		//	フォントセレクト解除
		SelectObject(mdc, hFont);

		//	ウインド表示
		BitBlt(hdc, 0, 0, pW->ww, pW->wh, mdc, 0, 0, SRCCOPY);

		//	メモリＤＣ削除
		DeleteDC(mdc);

	} while(0);

	//	ＤＣ解放
	EndPaint(hwnd, &ps);

	//	ブラシハンドル破棄
	if (hBru != NULL) DeleteObject(hBru);
}
//----- WM_PAINT : 高速描画 ------------------------------------------------------------------------------------//
static	BOOL	SubPaintFast_ScrlUp		(PWRKVT100 pW, HDC mdc);
static	BOOL	SubPaintFast_ScrlDown	(PWRKVT100 pW, HDC mdc);
static	VO		SubPaintFast_Draw		(PWRKVT100 pW, HDC mdc, UI y, UI ixL, UI nLine, BOOL fUpdOnly);
static	VO		SubPaintFast_DrawSel	(PWRKVT100 pW, HDC mdc);

static	VO	SubPaintFast(HWND hwnd)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc, mdc;
	HFONT		hFont = NULL;

	//	ＤＣ設定
	hdc  = BeginPaint(hwnd, &ps);

	do {
		//	ディスプレィ互換ＤＣ作成
		if ((mdc = CreateCompatibleDC(hdc)) == NULL) {
			break;
		}

		//	背景色設定
		if (pW->fEnable) pW->FsBkColor = pW->prop.rgb[pW->IxBkWnd];
		else			 pW->FsBkColor = GetSysColor(COLOR_BTNFACE);

		//	画面サイズのビットマップ作成
		if (pW->hBitmap == NULL) {
			if (pW->hBitmap = AjcDibCreate(pW->ww, pW->wh, 32, &pW->DibInfo)) {
				AjcDibClear(&pW->DibInfo, pW->prop.rgb[pW->IxBkWnd]);
			}
			else break;
			AjcDibClear(&pW->DibInfo, pW->FsBkColor);
			pW->fFsDrawAll = TRUE;
		}
		SelectObject(mdc, pW->hBitmap);

		//	フォントセレクト
		hFont = (HFONT)SelectObject(mdc, pW->hFontText);

		do {
			//	選択／ドラッグ中は反転表示付きで描画
			if (pW->Mode & (MD_SELECT | MD_DRAG_C | MD_DRAG_L)) {
				//	画面クリアー
				AjcDibClear(&pW->DibInfo, pW->FsBkColor);
				//	選択状態反転で描画
				SubPaintFast_DrawSel(pW, mdc);
				break;
			}
			//	特定条件（スタイル／プロパティ／横スクロール位置変更）で全ライン描画
			if (pW->fFsDrawAll || pW->FsIxOfs != pW->IxOfs ) {
				//	画面クリアー
				AjcDibClear(&pW->DibInfo, pW->FsBkColor);
				//	テキスト描画
				SubPaintFast_Draw(pW, mdc,
								  0,					//	y = 0
								  pW->IxWTop,			//	描画先頭行
								  pW->wh / pW->cyChar,	//	描画行数
								  FALSE);				//	全ライン描画
				break;
			}
			//	スクロールアップ／スクロールダウンを実行できない場合は全ラインテキスト描画
			if (!SubPaintFast_ScrlUp(pW, mdc) && !SubPaintFast_ScrlDown(pW, mdc)) {
				//	画面クリアー
				AjcDibClear(&pW->DibInfo, pW->FsBkColor);
				//	テキスト描画
				SubPaintFast_Draw(pW, mdc,
								  0,					//	y = 0
								  pW->IxWTop,			//	描画先頭行
								  pW->wh / pW->cyChar,	//	描画行数
								  FALSE);				//	全ライン描画
			}
		} while(0);

		//	タイトル描画
		if (pW->style & AJCVTHS_LOGFILE) 
			SubTtlBmpDrawC(&pW->TtlInfo, hwnd, mdc, 0, 18, pW->fEnable, pW->prop.rgb[pW->IxBkWnd]);
		else
			SubTtlBmpDrawC(&pW->TtlInfo, hwnd, mdc, 0,	0, pW->fEnable, pW->prop.rgb[pW->IxBkWnd]);

		//	フォントセレクト解除
		SelectObject(mdc, hFont);

		//	ウインド表示
		BitBlt(hdc, 0, 0, pW->ww, pW->wh, mdc, 0, 0, SRCCOPY);

		//	メモリＤＣ削除
		DeleteDC(mdc);

		//	行頭ポインタ，横スクロール位置退避
		pW->pFsTxtTop = pW->pLPtr[pW->IxWTop].pTxt;
		pW->FsIxOfs   = pW->IxOfs;

		//	全行表示フラグクリアー
		pW->fFsDrawAll = FALSE;

	} while(0);

	//	ＤＣ解放
	EndPaint(hwnd, &ps);
}
//
//	WM_PAINT : 高速描画（スクロールアップ）
//
static	BOOL	SubPaintFast_ScrlUp(PWRKVT100 pW, HDC mdc)
{
	BOOL	rc = FALSE;		//	戻り値（TRUE:スクロールアップを実行した）
	UI		nLine = 0;		//	ウインドに表示可能な行数
	UI		nScrl = 0;		//	スクロール行数
	UI		ix, svIx;		//	行ポインタテーブルインデクス

	do {
		//	ウインドに表示可能な行数算出
		nLine = pW->wh / pW->cyChar;

		//	スクロールアップチェック
		for (nScrl = 0, ix = pW->IxWTop, svIx = -1;
			 nScrl < nLine && svIx != pW->IxSrt && pW->pLPtr[ix].pTxt != NULL && pW->pLPtr[ix].pTxt != pW->pFsTxtTop;
			 nScrl++, ix = (ix != 0) ? (ix - 1) : (pW->prop.MaxLines - 1)) {
			svIx = ix;
		}

		//	スクロールアップ処理
		if (pW->pLPtr[ix].pTxt == pW->pFsTxtTop && nScrl < nLine) {
			UBP		pSrc, pDst;
			UI		ySrc, yDst;
			UI		i, nLaster;
			if (nScrl != 0) {
				//	スクロールアップ（ＤＩＢメモリ移動）
				ySrc	= nScrl * pW->cyChar;
				yDst	= 0;
				nLaster = (nLine - nScrl) * pW->cyChar;
				for (i = 0; i < nLaster; i++) {
					pSrc = AjcDibGetLinrPtr(&pW->DibInfo, ySrc);
					pDst = AjcDibGetLinrPtr(&pW->DibInfo, yDst);
					memcpy(pDst, pSrc, pW->DibInfo.LineSize);
					ySrc++;
					yDst++;
				}
				//	スクロール内の更新ライン再描画
				SubPaintFast_Draw(pW, mdc,
								  0,				//	y = 0
								  pW->IxWTop,		//	描画先頭行
								  nLine - nScrl,	//	描画行数
								  TRUE);			//	更新ラインのみ描画
				//	スクロール後部の余白を埋める
				if (nLaster < pW->wh) {
					COLORREF	rev = pW->FsBkColor;
					rev = ((rev << 16) & 0x00FF0000) | (rev & 0x0000FF00) | ((rev >> 16) & 0x000000FF);
					nLaster = pW->wh - nLaster;
					AjcMemSet32(pW->DibInfo.pImage,
								rev,
								nLaster * pW->DibInfo.LineSize / 4);
				}
				//	スクロール後部のテキスト描画
				SubPaintFast_Draw(pW, mdc,
									  pW->cyChar * (nLine - nScrl),							//	y = スクロール部分の直後
									  (pW->IxWTop + (nLine - nScrl)) % pW->prop.MaxLines,	//	描画先頭行
									  nScrl,												//	描画行数
									  FALSE);												//	全ライン描画
				//	戻り値＝スクロールアップを実行した
				rc = TRUE;
			}
		}
	} while(0);

	return rc;
}
//
//	WM_PAINT : 高速描画（スクロールダウン）
//
static	BOOL	SubPaintFast_ScrlDown(PWRKVT100 pW, HDC mdc)
{
	BOOL	rc = FALSE;		//	戻り値（TRUE:スクロールダウンを実行した）

	//	スクロールダウンは未対応（スクロールダウン時は、全ラインテキストを描画）

	return rc;
}
//
//	WM_PAINT : 高速描画（テキスト描画，選択反転表示なし）
//		mdc		 - DCハンドル
//		y		 - 描画Ｙ位置
//		ixL		 - 描画先頭行ポインタインデクス
//		nLine	 - 描画行数
//		BkColor	 - 背景色
//		fUpdOnly - TRUE:更新ラインのみ描画
//
static	VO		SubPaintFast_Draw(PWRKVT100 pW, HDC mdc, UI y, UI ixL, UI nLine, BOOL fUpdOnly)
{
	PLINEPTR	pL = &pW->pLPtr[ixL];					//	表示先頭ラインポインタ設定
	int			x = -((int)(pW->IxOfs * pW->cxChar));	//	描画Ｘ位置設定
	UI			i;

	//	テキスト表示モード，表示色設定
	SetBkMode	(mdc, TRANSPARENT);

	//	テキスト表示色設定
	if (pW->fEnable) SetTextColor(mdc, pW->prop.rgb[pW->att & VAT_FC]);
	else			 SetTextColor(mdc, GetSysColor(COLOR_GRAYTEXT));

	pL = &pW->pLPtr[ixL];
	for (i = 0; i < nLine && y < pW->wh && pL->pTxt != NULL; i++) {
		if (!fUpdOnly || pL->fUpd) {										//		全ライン描画 or 更新ライン？
			if (fUpdOnly) {
				AjcDibFillRect(&pW->DibInfo, 0, y, pW->DibInfo.width, y + pW->cyChar, pW->FsBkColor);
			}
			SubTextOut(pW, mdc, x, y, pL->pTxt, pL->len, RGB_WHITE);		//			テキスト描画
		}
		pL->fUpd = FALSE;													//		更新ラインフラグ解除
		y  += pW->cyChar;													//		描画Ｙ位置更新
		ixL = ((ixL + 1) % pW->prop.MaxLines);								//		ラインインデクス更新
		pL	= &pW->pLPtr[ixL];												//		ラインポインタ設定
		if (ixL == pW->IxSrt) break;										//		バッファ先頭ならば終了
	}
}
//
//	WM_PAINT : 高速描画（全テキスト描画，選択反転表示あり）
//
static	VO		SubPaintFast_DrawSel(PWRKVT100 pW, HDC mdc)
{
	SIZE		sz;
	int			xs, xc, xe, y, txl;
	UI			ixL, len;
	PLINEPTR	pL;
	UI			ixS, ixC;
	UI			atS, atC;
	WCP			pTxtS, pTxtC;
	COLORREF	SvTxtRgb, SvBakRgb;
	COLORREF	TxtRgb	,	BakRgb;
	COLORREF	RgbTbl[2];

	RgbTbl[0] = pW->prop.rgb[pW->att & VAT_FC];
	RgbTbl[1] = pW->prop.rgb[pW->IxBkWnd];

	//	テキスト表示モード設定
	SetBkMode	(mdc, OPAQUE);

	//	退避表示色無効化
	SvTxtRgb = SvBakRgb = -1;

	y	= 0;																//	描画Ｙ位置＝０
	ixL	= pW->IxWTop;														//	表示先頭ラインインデクス
	pL	= &pW->pLPtr[ixL];													//	表示先頭ラインポインタ
	while (pL->pTxt != NULL && y < (int)pW->wh) {							//	ラインループ
		xc = -((int)(pW->IxOfs * pW->cxChar));								//		描画Ｘ位置初期化
		xe = xc;															//		テキストの描画ピクセル数初期化
		len = pL->len;														//		有効データ長設定
		ixC	  = 0;															//		先頭テキストインデクス置設定
		if (ixC < len) {													//		オフセット右端のテキストデータあり？
			pTxtC = pL->pTxt + ixC;											//			先頭テキストポインタ設定
			atC   = 0x10;													//			先頭描画色設定
			if (IsSelect(pW, pL->len, ixL, ixC)) {							//			・
				atC = 0x01;													//			・
			}
			xs	  = xc;														//			先頭描画位置退避
			atS	  = atC;													//			先頭描画色退避
			ixS	  = ixC;													//			先頭描画位置退避
			pTxtS = pTxtC;													//			先頭テキスト位置退避
			while (TRUE) {													//			文字描画ループ
				if (xc >= (int)pW->ww || ixC >= len || atC != atS) {		//				WND終端／テキスト終端／表示色変化？
					txl = ixC - ixS;										//					描画ワード数設定
					if (pW->fEnable) TxtRgb = RgbTbl[atS & 1];				//					テキスト色設定
					else			 TxtRgb = GetSysColor(COLOR_GRAYTEXT);	//					・
					if (SvTxtRgb != TxtRgb) {								//					・
						SetTextColor(mdc, SvTxtRgb = TxtRgb);				//					・
					}
					if (pW->fEnable) BakRgb = RgbTbl[(atS >> 4) & 1];		//					背景色設定
					else			 BakRgb = GetSysColor(COLOR_BTNFACE);	//					・
					if (SvBakRgb != BakRgb) {								//					・
						SetBkColor(mdc, SvBakRgb = BakRgb);					//					・
					}
					SubTextOut(pW, mdc, xs, y, pTxtS, txl, BakRgb);			//					前ワードまでのテキスト表示
					VthGetTextExtentPoint(pW, mdc, pTxtS, txl, &sz);		//					テキスト描画ピクセル数更新
					xe += sz.cx;											//					・
					xc += sz.cx;
					if (xc >= (int)pW->ww || ixC >= len) {					//					ＷＮＤ終端／テキスト終端？
						break;												//						→終了
					}
					xs	= xe;												//					先頭描画位置退避
					atS = atC;												//					先頭描画色退避
					ixS = ixC;												//					先頭文字インデクス退避
					pTxtS = pTxtC;											//					先頭テキストポインタ退避
				}
				pTxtC++;													//				テキストポインタ更新
				ixC++;														//				文字インデクス更新
				if (ixC < len) {											//				テキスト終端以内？
					atC = 0x10;												//					描画色設定
					if (IsSelect(pW, pL->len, ixL, ixC)) {					//					・
						atC = 0x01;											//					・
					}
				}
			}
		}
		y  += pW->cyChar;													//		描画Ｙ位置更新
		ixL = ((ixL + 1) % pW->prop.MaxLines);								//		ラインインデクス更新
		pL	= &pW->pLPtr[ixL];												//		ラインポインタ設定
		if (ixL == pW->IxSrt) {												//		バッファ先頭位置？
			break;															//			→終了
		}
	}
}

//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONDOWN)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	int			x = (SW)LOWORD(lParam);
	int			y = (SW)HIWORD(lParam);
	int			lp, tix;

	//	ツールチップ制御用にバックウインドへ通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	//	フォーカス設定
	SetFocus(hwnd);

	if (pW->LCnt != 0 && VthMusToTextIdx(pW, x, y, &lp, &tix, NULL)) {
		//----- 文字インデクスをデータ範囲内に訂正 ---------------------------//
		if (tix >= (int)pW->prop.VramW) tix = pW->prop.VramW;
		//----- クリック位置を検索開始位置とする -----------------------------//
		pW->SrhPos.x = VthIxToLno(pW, tix);
		pW->SrhPos.y = lp;
		pW->fResetPos = FALSE;
		//----- ドラッグ中，選択状態モード設定 -------------------------------//
		if (wParam & MK_CONTROL) VthSetMode(pW, pW->Mode | (MD_DRAG_L | MD_SELECT));
		else					 VthSetMode(pW, pW->Mode | (MD_DRAG_C | MD_SELECT));
		//----- 行位置をデータ範囲内に訂正 -----------------------------------//
		if (lp >= (int)pW->LCnt) lp = pW->LCnt - 1;
		//----- 文字単位ドラッグモード ---------------------------------------//
		if (pW->Mode & MD_DRAG_C) {
			//	非選択状態／シフト未押下ならば、開始／終了位置設定
			if (!(pW->Mode & MD_SELECT) || !(wParam & MK_SHIFT)) {
				pW->SelInf.ixSL = pW->SelInf.ixEL = VthLnoToIx(pW, lp);
				pW->SelInf.ixSC = pW->SelInf.ixEC = tix;
			}
			//	選択状態＆シフト押下ならば、終了位置更新
			else {
				pW->SelInf.ixEL = VthLnoToIx(pW, lp);
				pW->SelInf.ixEC = tix;
			}
		}
		//----- 行単位ドラッグモード -----------------------------------------//
		else {
			//	行頭へスクロール
			VthSetHScrollInfo(pW, 0);
			//	文字インデクスを行末に設定
			tix = pW->prop.VramW;
			//	非選択状態／シフト未押下ならば、開始／終了位置設定
			if (!(pW->Mode & MD_SELECT) || !(wParam & MK_SHIFT)) {
				pW->SelInf.ixSL = pW->SelInf.ixEL = VthLnoToIx(pW, lp);
				pW->SelInf.ixSC = 0;				//	開始インデクス＝行頭
				pW->SelInf.ixEC = pW->prop.VramW;	//	終了インデクス＝行末
			}
			//	選択状態＆シフト押下ならば、終了位置更新
			else {
				pW->SelInf.ixEL = VthLnoToIx(pW, lp);	//	終了行
				pW->SelInf.ixEC = pW->prop.VramW;	//	終了インデクス＝行末
			}
		}
		//----- マウスキャプチャー -------------------------------------------//
		SetCapture(hwnd);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONUP)
{
	PWRKVT100		pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	if (pW->Mode & MD_DRAG) {
		//----- マウスキャプチャー停止 ---------------------------------------//
		ReleaseCapture();
		//----- マウス移動監視タイマ停止 -------------------------------------//
		KillTimer(hwnd, TID_DRAG);
		//----- ドラッグモード解除 -------------------------------------------//
		VthSetMode(pW, pW->Mode & ~MD_DRAG);
		//----- 開始／終了位置が同じならば、選択状態解除 ---------------------//
		if (pW->SelInf.ixSL == pW->SelInf.ixEL && pW->SelInf.ixSC == pW->SelInf.ixEC) {
			VthSetMode(pW, pW->Mode & ~MD_SELECT);
		}
		//----- 再描画 -------------------------------------------------------//
		VthPutTextToVRAM(pW);
		InvalidateRect(hwnd, NULL, FALSE);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_MBUTTONDOWN)
{
	PWRKVT100		pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	UI				sty;

	//	ツールチップ制御用にバックウインドへ通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	//	ＶＲＡＭ領域の色分け有効／無効（反転）
	sty  = (UI)GetWindowLong(pW->hBack, GWL_STYLE);
	sty ^= AJCVTHS_SEPARATE;
	MAjcSetWindowLong(pW->hBack, GWL_STYLE, sty);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_MOUSEMOVE)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	int			x = (SW)LOWORD(lParam);
	int			y = (SW)HIWORD(lParam);
	int			lp, tix, top, end;

	//	ツールチップ制御用にバックウインドへ通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	//----- ドラッグ操作 ---------------------------------------------------------------------//
	if (pW->Mode & MD_DRAG) {
		//----- 行／文字インデクス設定 ----------------------//
		if (VthMusToTextIdx(pW, x, y, &lp, &tix, NULL)) {		//	マウスカーソルはウインド内？
			//----- マウス移動監視タイマ停止 ----------------//
			KillTimer(hwnd, TID_DRAG);
			//----- 行位置をデータ範囲内に訂正 --------------//
			if (lp >= (int)pW->LCnt) lp = pW->LCnt - 1;
			//----- サロゲート２ワード目ならば１つ戻す ------//
			tix = BackToCharPosIf2ndSurrWord(pW, lp, tix);
			//----- 文字単位ドラッグモード時の桁位置設定 ----//
			if (pW->Mode & MD_DRAG_C) {
				//	インデクスをデータ範囲内に訂正
				if (tix >= (int)pW->prop.VramW) {
					tix = pW->prop.VramW;
				}
			}
		}
		else {										//	マウスカーソルはウインド外？
			//----- マウス移動監視タイマ起動 ----------------//
			SetTimer(hwnd, TID_DRAG, 10, NULL);
			//----- 行位置設定 ------------------------------//
			top = VthIxToLno(pW, pW->IxWTop);
			end = top + (pW->wh / pW->cyChar);
			if		(lp == -1) {					//	マウスカーソルはウインドの上側？
				if (top > 0) {
					lp = top - 1;
					tix = BackToCharPosIf2ndSurrWord(pW, lp, tix);
					VthSetVScrollInfo(pW, lp);
				}
				else {
					lp = 0;
				}
			}
			else if (lp == -2) {					//	マウスカーソルはウインドの下側？
				if (end < (int)pW->LCnt - 1) {
					lp = end + 1;
					tix = ForwToCharPosIf2ndSurrWord(pW, lp, tix);
					VthSetVScrollInfo(pW, top + 1);
				}
				else {
					lp = pW->LCnt - 1;
					VthScrollToBottom(pW);
				}
			}
			//----- 文字単位ドラッグモード時のインデクス設定 //
			if (pW->Mode & MD_DRAG_C) {
				top = pW->IxOfs;
				end = top + (pW->ww / pW->cxChar);
				if		(tix == -1) {				//	マウスカーソルはウインドの左側？
					if (top > 0) {
						tix = BackToCharPosIf2ndSurrWord(pW, lp, top - 1);
						VthSetHScrollInfo(pW, tix);
					}
					else {
						tix = 0;
					}
				}
				else if (tix == -2) {				//	マウスカーソルはウインドの右側？
					if (end < (int)pW->prop.VramW) {
						tix = BackToCharPosIf2ndSurrWord(pW, lp, end + 1);
						VthSetHScrollInfo(pW, top + 1);
					}
					else {
						tix = pW->prop.VramW;
					}
				}
			}
		}
		//----- 行単位ドラッグモード時の文字インデクス設定 -----------------------------------//
		if (pW->Mode & MD_DRAG_L) {
			if ((int)pW->SelInf.ixSL <= lp) {
				pW->SelInf.ixSC = 0;
				tix				= pW->prop.VramW;
			}
			else {
				pW->SelInf.ixSC = pW->prop.VramW;;
				tix				= 0;
			}
		}
		//----- ↑↓キーによる選択時のインデクス設定 -----------------------------------------//
		pW->IxOfSelUpDnKey = tix;
		//----- 選択終了位置設定 -------------------------------------------------------------//
		pW->SelInf.ixEL = VthLnoToIx(pW, lp);
		pW->SelInf.ixEC = tix;
		//----- 再描画 -----------------------------------------------------------------------//
		InvalidateRect(hwnd, NULL, FALSE);
	}
	//----- 画面クリアーボタン表示／非表示 ---------------------------------------------------//
	else {
		if (!(pW->style & AJCVTHS_NOCLSBTN)) {
			POINT	pt;
			RECT	rt;
			GetCursorPos(&pt);
			GetWindowRect(pW->hBtnCls, &rt);
			if (pW->LCnt != 0 && pt.x >= rt.left && pt.x < rt.right && pt.y >= rt.top && pt.y < rt.bottom) {
				ShowWindow(pW->hBtnCls, SW_SHOW);
				SetTimer(hwnd, TID_CLSBTN, 500, NULL);
			}
			else {
				ShowWindow(pW->hBtnCls, SW_HIDE);
				InvalidateRect(pW->hMain, NULL, FALSE);
				KillTimer(hwnd, TID_CLSBTN);
			}
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_MOUSEWHEEL)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	//----- CTRL押下時はフォントサイズ変更 ---------------------------------------------------//
	if (wParam & MK_CONTROL) {
		AJCVTHPROP	prop;
		int			up_down = 0;
		WC			txt[256];

		if (!(pW->style & AJCVTHS_FIXEDFONT)) {		//	フォント固定以外？

			//	プロパティコピー
			memcpy(&prop, &pW->prop, sizeof prop);
   
			//	フォントサイズ退避値初期化
			if (pW->SvFontHeight == 0) {
				pW->SvFontHeight = pW->prop.LogFont.lfHeight;
			}
			pW->mhAccumDelta += (SW)HIWORD(wParam);
			while (pW->mhAccumDelta >= pW->mhDeltaPerLine) {
				up_down++;
				pW->mhAccumDelta -= pW->mhDeltaPerLine;
			}
			while (pW->mhAccumDelta <= -pW->mhDeltaPerLine) {
				up_down--;
				pW->mhAccumDelta += pW->mhDeltaPerLine;
			}
			if (pW->SvFontHeight >= 0) {
				if (up_down > 0) pW->SvFontHeight++;
				if (up_down < 0) pW->SvFontHeight--;
				pW->SvFontHeight = __min(pW->SvFontHeight, MAX_FONT_PIXELS);
				pW->SvFontHeight = __max(pW->SvFontHeight, MIN_FONT_PIXELS);
			}
			else {
				if (up_down > 0) pW->SvFontHeight--;
				if (up_down < 0) pW->SvFontHeight++;
				pW->SvFontHeight = __max(pW->SvFontHeight, -MAX_FONT_POINTS);
				pW->SvFontHeight = __min(pW->SvFontHeight, -MIN_FONT_POINTS);
			}
			prop.LogFont.lfHeight = pW->SvFontHeight;
			if (memcmp(&prop, &pW->prop, sizeof prop) != 0) {
				VthSetCtrlProp(pW, &prop);
			}
			//	フォントサイズをチップ表示
			AjcSnPrintFW(txt, AJCTSIZE(txt), L"%s, lfHeight : %d", prop.LogFont.lfFaceName, prop.LogFont.lfHeight);
			AjcTipTextShowCenter(pW->hBack , txt, 3000, NULL);
		}
	}
	//----- CTRL非押下時はスクロール ---------------------------------------------------------//
	else {
		if (pW->mhDeltaPerLine != 0) {
			pW->mhAccumDelta += (SW)HIWORD(wParam);
			while (pW->mhAccumDelta >= pW->mhDeltaPerLine) {
				SendMessage(hwnd, WM_VSCROLL, SB_LINEUP, 0);
				pW->mhAccumDelta -= pW->mhDeltaPerLine;
			}
			while (pW->mhAccumDelta <= -pW->mhDeltaPerLine) {
				SendMessage(hwnd, WM_VSCROLL, SB_LINEDOWN, 0);
				pW->mhAccumDelta += pW->mhDeltaPerLine;
			}
			SendMessage(hwnd, WM_VSCROLL, SB_ENDSCROLL, 0);
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	POINT		pt;
	RECT		rt;

	switch (wParam) {
		case TID_DRAG:							//	●ドラッグ操作用タイマ
			if (GetCursorPos(&pt)) {
				MapWindowPoints(NULL, hwnd, &pt, 1);
				SendMessage(hwnd, WM_MOUSEMOVE, 0, MAKELONG(pt.x, pt.y));
			}
			break;

		case TID_CLSBTN:						//	●画面クリアーボタン非表示監視タイマ
			if (GetCursorPos(&pt)) {
				GetWindowRect(pW->hBtnCls, &rt);
				if (!(pW->LCnt != 0 && pt.x >= rt.left && pt.x < rt.right && pt.y >= rt.top && pt.y < rt.bottom)) {
					ShowWindow(pW->hBtnCls, SW_HIDE);
					InvalidateRect(pW->hMain, NULL, FALSE);
					KillTimer(hwnd, TID_CLSBTN);
				}
			}
			break;
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
enum {
	IDM_SELALL	=	5001,		//	全て選択
	IDM_COPYTXT			,		//	コピー
	IDM_CLEAR			,		//	クリアー
	IDM_FINDSTR			,		//	文字列検索ダイアログ
	IDM_FIND_UP			,		//	上検索
	IDM_FIND_DOWN		,		//	下検索
	IDM_LF				,		//	ＬＦで復帰改行
	IDM_CR				,		//	ＣＲで復帰改行
	IDM_LFNORMAL		,		//	ＣＲで復帰，ＬＦで改行
	IDM_SHOWCARET		,		//	キャレット表示
	IDM_HIDECARET		,		//	キャレット非表示
	IDM_SAVE			,		//	ファイルへセーブ
	IDM_SETFONT			,		//	フォント設定
	IDM_SETDEFFONT		,		//	デフォルトフォント設定
	IDM_COPYFONT		,		//	フォント行間スペース コピー
	IDM_PASTEFONT		,		//	フォント行間スペース 貼り付け
	IDM_SETFONT_ALL_S	,		//	フォントを全兄弟ウインドに適用
	IDM_SETFONT_ALL_T	,		//	フォントを全スレッドウインドに適用
	IDM_SETOTHER		,		//	その他の設定
};

#define		LF_MASK		(AJCVTHS_CRLFCTRL | AJCVTHS_CRCTRL | AJCVTHS_LFCTRL)
#define		ISLF_LF		((pW->style & LF_MASK) == AJCVTHS_LFCTRL || (pW->style & LF_MASK) == 0)
#define		ISLF_CR		((pW->style & LF_MASK) == AJCVTHS_CRCTRL  )
#define		ISLF_NO		((pW->style & LF_MASK) == AJCVTHS_CRLFCTRL)

#define		RBTLF_LF	MFT_RADIOCHECK | (ISLF_LF ? MF_CHECKED : MF_UNCHECKED)
#define		RBTLF_CR	MFT_RADIOCHECK | (ISLF_CR ? MF_CHECKED : MF_UNCHECKED)
#define		RBTLF_NO	MFT_RADIOCHECK | (ISLF_NO ? MF_CHECKED : MF_UNCHECKED)

#define		SETF_S		MFT_RADIOCHECK | (!pW->fSetF_T ? MF_CHECKED : MF_UNCHECKED)
#define		SETF_T		MFT_RADIOCHECK | ( pW->fSetF_T ? MF_CHECKED : MF_UNCHECKED)

AJC_WNDPROC(Main, WM_RBUTTONDOWN	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	HMENU		hMenu	 = NULL;
	HMENU		hSubCrLf = NULL;
	HMENU		hSubSetF = NULL;
	int			id;
	POINT		pt;

	//	ツールチップ制御用にバックウインドへ通知
	SendMessage(pW->hBack, msg, wParam, lParam);

	//	右クリック通知設定時（親ウインドへ専用メッセージ通知）
	if (pW->fNtcRClk) {
		if (pW->MsgRBDown != 0) {
			PostMessage(GetParent(pW->hBack), pW->MsgRBDown, wParam, lParam);
		}
	}
	//	CTRL/SHIFT 押下時（親ウインドへWM_COMMAND(AJCVTHN_RCLICK)通知）
	else if (wParam & (MK_CONTROL | MK_SHIFT)) {
		pW->NtcRClk.x		= (SW)LOWORD(lParam);
		pW->NtcRClk.y		= (SW)HIWORD(lParam);
		pW->NtcRClk.fShift	= ((wParam & MK_SHIFT  ) != 0);
		pW->NtcRClk.fCtrl	= ((wParam & MK_CONTROL) != 0);
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_RCLICK),
						fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)&pW->NtcRClk);
	}
	//	CTRL/SHIFT 未押下時（ポップアップメニュー）
	else {
		hMenu = CreatePopupMenu();
		//	●全て選択．コピー
		if (pW->LCnt != 0 || (pW->Mode & MD_SELECT)) {
			BOOL	fSep = FALSE;
			if (pW->PopupMask & AJCVTHMM_SELALL) {
				if (pW->LCnt != 0		) {
					InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_SELALL , LNGSEL(L"全て選択(&S)", L"&Select All"));
					fSep = TRUE;
				}
			}
			if (pW->PopupMask & AJCVTHMM_COPYTXT) {
				if (pW->Mode & MD_SELECT) {
					InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_COPYTXT, LNGSEL(L"コピー(&C)"	, L"&Copy"));
					fSep = TRUE;
				}
			}
			if (fSep) {
				InsertMenu(hMenu, -1, MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
			}
		}
		//	●全てクリアー
		if (pW->LCnt != 0		) {
			if (pW->PopupMask & AJCVTHMM_CLEAR) {
				InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_CLEAR	 , LNGSEL(L"全てクリアー(&A)", L"Clear &All Text"));
				InsertMenu(hMenu, -1, MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
			}
		}
		//	●文字列検索，上方向検索，下方向検索
		if (pW->PopupMask & AJCVTHMM_FIND) {
			InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_FINDSTR , LNGSEL(L"文字列検索(&B)", L"Find String(&B)"));
			if (pW->FindKey != 0 && pW->SrhStr[0] != 0) {
				if (pW->FindKey == VK_F3) {
					InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_FIND_UP   , LNGSEL(L"上方向検索\tShift+F3", L"Search above\tShift + F3"));
					InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_FIND_DOWN , LNGSEL(L"下方向検索\tF3"	   , L"Search above\tF3"));
				}
				else {
					InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_FIND_UP   , LNGSEL(L"上方向検索"		   , L"Search above"));
					InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_FIND_DOWN , LNGSEL(L"下方向検索"		   , L"Search above"));
				}
			}
			InsertMenu(hMenu, -1, MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
		}
		//	●改行設定，キャレット表示／非表示
		if (pW->PopupMask & AJCOPT2(AJCVTHMM_, LINEFEED, CARET)) {
			BOOL	fSep = FALSE;
			//	・改行設定
			if (pW->PopupMask & AJCVTHMM_LINEFEED) {
				if (!(pW->style & AJCVTHS_FIXEDLF)) {
					hSubCrLf = CreatePopupMenu();
					InsertMenu(hSubCrLf, -1, MF_BYPOSITION | MF_STRING | RBTLF_LF, IDM_LF	   , LNGSEL(L"LF(0x0A)で復帰と改行(&L)", L"Return and line feed with &LF(0x0A)"));
					InsertMenu(hSubCrLf, -1, MF_BYPOSITION | MF_STRING | RBTLF_CR, IDM_CR	   , LNGSEL(L"CR(0x0D)で復帰と改行(&C)", L"Return and line feed with &CR(0x0D)"));
					InsertMenu(hSubCrLf, -1, MF_BYPOSITION | MF_STRING | RBTLF_NO, IDM_LFNORMAL, LNGSEL(L"CRで復帰、LFで改行(&N)"  , L"&Return with CR, Line feed at LF"));
					//	サブメニュー追加
					InsertMenu(hMenu, -1, MF_BYPOSITION | MF_POPUP | MF_STRING, (UX)hSubCrLf, LNGSEL(L"改行動作(&L)", L"&Line feed action"));
					fSep = TRUE;
				}
			}
			//	・キャレット表示／非表示
			if (pW->PopupMask & AJCVTHMM_CARET) {
				if (pW->fCaret			) InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_HIDECARET, LNGSEL(L"キャレット非表示(&H)", L"&Hide Caret"));
				else					  InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_SHOWCARET, LNGSEL(L"キャレット表示(&W)"	, L"Sho&w Caret"));
				fSep = TRUE;
			}
			//	・セパレータ
			if (fSep) {
				InsertMenu(hMenu, -1, MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
			}
		}
		//	●ファイルへセーブ
		if (pW->PopupMask & AJCVTHMM_SAVE) {
			//	・ファイルへセーブ
			InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_SAVE	 , LNGSEL(L"ファイルへセーブ(&V)", L"Sa&ve to file"));
			//	・セパレータ
			InsertMenu(hMenu, -1, MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
		}
		//	●フォント操作
		if (!(pW->style & AJCVTHS_FIXEDFONT)) {
			//	・フォント設定、デフォルト・フォント設定
			if (pW->PopupMask & AJCOPT2(AJCVTHMM_, SETFONT, SETDEFFONT)) {
				//	・フォント設定、
				if (pW->PopupMask & AJCVTHMM_SETDEFFONT) {
					InsertMenu(hMenu, -1, MF_STRING, IDM_SETFONT   , LNGSEL(L"フォント設定(&F)"				, L"Set &font"			));
				}
				//	・デフォルト・フォント設定
				if (pW->PopupMask & AJCVTHMM_SETDEFFONT) {
					InsertMenu(hMenu, -1, MF_STRING, IDM_SETDEFFONT, LNGSEL(L"デフォルト・フォント設定(&D)"	, L"Set &default font"	));
				}
				//	・セパレータ
				InsertMenu(hMenu, -1, MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
			}
			//	・フォントコピー／張り付け
			if (pW->PopupMask & AJCOPT2(AJCVTHMM_, COPYFONT, PASTEFONT)) {
				//	・フォントコピー
				if (pW->PopupMask & AJCVTHMM_COPYFONT) {
					InsertMenu(hMenu, -1, MF_STRING, IDM_COPYFONT , LNGSEL(L"フォント，行間スペース コピー(&Y)"  , L"Cop&y font, line-space"	));
				}
				//	・張り付け
				if (pW->PopupMask & AJCVTHMM_PASTEFONT) {
					InsertMenu(hMenu, -1, MF_STRING, IDM_PASTEFONT, LNGSEL(L"フォント，行間スペース 貼り付け(&P)", L"&Paste font, line-space"	));
				}
				//	・セパレータ
				InsertMenu(hMenu, -1, MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
			}
			//	・フォント適用
			if (pW->PopupMask & AJCVTHMM_THROWFONT) {
				BOOL	fSep = FALSE;
				BOOL	fExistT = IsExistVT100InThreadWindow  (pW);
				BOOL	fExistS = IsExistVT100InSiblingsWindow(pW);
				if (fExistT || fExistS) {
					hSubSetF = CreatePopupMenu();
					//	・全兄弟ウインドに適用
					if (fExistS) {
						InsertMenu(hSubSetF, -1, MF_BYPOSITION | MF_STRING | SETF_S, IDM_SETFONT_ALL_S, LNGSEL(L"全兄弟ウインドに適用(&S)    ", L"Applies to all &sibling windows"));
						fSep = TRUE;
					}
					//	・全スレッドウインドに適用
					if (fExistT) {
						InsertMenu(hSubSetF, -1, MF_BYPOSITION | MF_STRING | SETF_T, IDM_SETFONT_ALL_T, LNGSEL(L"全スレッドウインドに適用(&T)", L"Applies to all &thread windows"));
						fSep = TRUE;
					}
					//	・セパレータ
					if (fSep) {
						//	・サブメニュー追加
						InsertMenu(hMenu, -1, MF_BYPOSITION | MF_POPUP | MF_STRING, (UX)hSubSetF   , LNGSEL(L"フォント設定を全てのVT-100に適用(&G)"	, L"Set Font to &Global"	));
						//	・セパレータ
						InsertMenu(hMenu, -1, MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
					}
				}
			}
		}	//	!(pW->style & AJCVTHS_FIXEDFONT)

		//	●その他の設定
		if (pW->PopupMask & AJCVTHMM_SETOTHER) {
			InsertMenu(hMenu, -1, MF_BYPOSITION | MF_STRING, IDM_SETOTHER, LNGSEL(L"その他の設定(&O)"  , L"Set &Other"));
		}

		//	メニューの最後がセパレータである場合削除
		{	int	n;
			if ((n = GetMenuItemCount(hMenu)) > 0) {
				if (GetMenuItemID(hMenu,  n - 1) == 0) {
					DeleteMenu(hMenu,  n - 1, MF_BYPOSITION);
				}
			}
		}
		//	メニュー表示
		GetCursorPos(&pt);
		id = AjcDgcTrackPopupMenuEx(hMenu, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, hwnd, NULL);
		DestroyMenu(hMenu);
		if (hSubCrLf != NULL) DestroyMenu(hSubCrLf);
		if (hSubSetF != NULL) DestroyMenu(hSubSetF);

		//	メニューアクション
		switch (id) {
			case IDM_SELALL:	AjcVthSelectAll(pW->hBack);
								break;

			case IDM_COPYTXT:	AjcVthCopyText (pW->hBack);
								VthSetMode(pW, pW->Mode & ~MD_SELECT);
								InvalidateRect(pW->hMain, NULL, FALSE);
								break;

			case IDM_CLEAR:		if (MessageBoxW(hwnd, LNGSEL(L"データを全て破棄し、画面をクリアーします。よろしいですか？",
															 L"Discard all data and clear the screen. Is it OK?"), AppName, MB_YESNO) == IDYES) {
									AjcVthClearAllText(pW->hBack);
									SendMessage(GetParent(pW->hBack), WM_COMMAND, 
													MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_CLEAR), (LPARAM)pW->hBack);
								}
								break;

			case IDM_FINDSTR:	VthCreateDlgFind(pW);
								break;

			case IDM_FIND_UP:	AjcVthSearchAboveExW(pW->hBack, pW->SrhStr, 
													 pW->fSemicolon ? L";" : NULL,
													 pW->fAstarisk	? L"*" : NULL,
													 pW->fEnclose	? L"\"": NULL,
													 pW->fTrim, !pW->fExactWidth);

								break;

			case IDM_FIND_DOWN:	AjcVthSearchBelowExW(pW->hBack, pW->SrhStr, 
												 	 pW->fSemicolon ? L";" : NULL,
											 		 pW->fAstarisk	? L"*" : NULL,
													 pW->fEnclose	? L"\"": NULL,
													 pW->fTrim, !pW->fExactWidth);
								break;

			case IDM_LF:		MAjcSetWindowLong(pW->hBack, GWL_STYLE, (MAjcGetWindowLong(pW->hBack, GWL_STYLE) & ~LF_MASK) | AJCVTHS_LFCTRL);
								break;

			case IDM_CR:		MAjcSetWindowLong(pW->hBack, GWL_STYLE, (MAjcGetWindowLong(pW->hBack, GWL_STYLE) & ~LF_MASK) | AJCVTHS_CRCTRL);
								break;

			case IDM_LFNORMAL:	MAjcSetWindowLong(pW->hBack, GWL_STYLE, (MAjcGetWindowLong(pW->hBack, GWL_STYLE) & ~LF_MASK) | AJCVTHS_CRLFCTRL);
								break;

			case IDM_SHOWCARET:	AjcVthShowCaret(pW->hBack, TRUE);
								break;

			case IDM_SAVE:		VthCreateDlgSaveToFile(pW);
								break;

			case IDM_HIDECARET:	AjcVthShowCaret(pW->hBack, FALSE);
								break;

			case IDM_SETOTHER:	VthCreateDlgSetOther(pW);
								break;

			case IDM_SETFONT:	AjcVthSetFont  (pW->hBack);
								break;

			case IDM_SETDEFFONT:{
								WC	msg[256];
								AjcSnPrintF(msg, AJCTSIZE(msg), LNGSEL(L"デフォルト・フォントを設定します。よろしいですか？\n\n( Name=%s, Height=%d[%s] )",
																	   L"Sets the default font. Are you sure?\n\n( Name=%s, Height=%d[%s] )"), 
																pW->lfDefFont.lfFaceName,
																pW->lfDefFont.lfHeight >= 0 ? pW->lfDefFont.lfHeight : AjcCfPixelsToPoints(pW->lfDefFont.lfHeight),
																pW->lfDefFont.lfHeight >= 0 ? L"Pixels" 			 : L"Points");
								if (MessageBox(hwnd, msg, AppName, MB_YESNO) == IDYES) {
									AJCVTHPROP	prop;
									memcpy(&prop, &pW->prop, sizeof prop);
									memcpy(&prop.LogFont, &pW->lfDefFont, sizeof(LOGFONT));
									AjcVthSetProp(pW->hBack, &prop);
								}
								break;
			}
			case IDM_COPYFONT:			CopyFontAndLineSpace(pW);
										break;

			case IDM_PASTEFONT:			PasteFontAndLineSpace(pW);
										break;

			case IDM_SETFONT_ALL_S:		SetFontToAllSiblingsWindow(pW);
										pW->fSetF_T = FALSE;
										break;

			case IDM_SETFONT_ALL_T:		SetFontToAllThreadWindow(pW);
										pW->fSetF_T = TRUE;
										break;

		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_RBUTTONUP		)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	if (pW->fNtcRClk) {
		if (pW->MsgRBUp != 0) {
			PostMessage(GetParent(pW->hBack), pW->MsgRBUp, wParam, lParam);
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_HSCROLL	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	SCROLLINFO	si;
	SL			svPos;
	UW			knd = LOWORD(wParam);

	if (knd != SB_ENDSCROLL && knd != SB_THUMBPOSITION) {		//	スクロールバーを掴んだ？
		VthSetMode(pW, pW->Mode | MD_SCROLL);					//		「スクロール中モード」設定
	}
	else {														//	スクロールバーを離した？
		VthSetMode(pW, pW->Mode & ~MD_SCROLL);					//		「スクロール中モード」解除
		VthPutTextToVRAM(pW);									//		保留テキストをＶＲＡＭへ描画
		InvalidateRect(hwnd, NULL, FALSE);						//		ウィンドゥ描画
	}

	si.cbSize = sizeof(SCROLLINFO);								//	横スクロール情報取得
	si.fMask  = SIF_ALL;										//	・
	GetScrollInfo(hwnd, SB_HORZ, &si);							//	・
	svPos = si.nPos;											//	現在の横方向位置を退避

	switch (knd) {
		case SB_LINELEFT:	si.nPos -= 1;			break;		//	○ →１文字左へ移動
		case SB_LINERIGHT:	si.nPos += 1;			break;		//	○ →１文字右へ移動
		case SB_PAGELEFT:	si.nPos -= si.nPage;	break;		//	○ →１項左へ移動
		case SB_PAGERIGHT:	si.nPos += si.nPage;	break;		//	○ →１項右へ移動
		case SB_THUMBTRACK:	si.nPos = si.nTrackPos;	break;		//	○ →スクロールバーを離した位置へ移動
	}
	si.fMask = SIF_POS;											//	スクロール位置設定
	SetScrollInfo(hwnd, SB_HORZ, &si, TRUE);					//	・
	GetScrollInfo(hwnd, SB_HORZ, &si);							//	スクロール位置取得
	if (si.nPos != svPos) {										//	スクロール位置に変化あり？
		pW->IxOfs = si.nPos;									//		表示桁位置設定
		InvalidateRect(hwnd, NULL, FALSE);						//		ウィンドゥ描画
		//--- 横スクロール通知 ---//
		pW->NtcLeft = pW->IxOfs;
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_HSCROLL),
						fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcLeft);
	}

	VthSetCaret(pW);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_VSCROLL	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	SCROLLINFO	si;
	SL			svPos;
	UW			knd = LOWORD(wParam);

	if (knd != SB_ENDSCROLL && knd != SB_THUMBPOSITION) {		//	スクロールバーを掴んだ？
		VthSetMode(pW, pW->Mode | MD_SCROLL);					//		「スクロール中モード」設定
	}
	else {														//	スクロールバーを離した？
		VthSetMode(pW, pW->Mode & ~MD_SCROLL);					//		「スクロール中モード」解除
		VthPutTextToVRAM(pW);									//		保留テキストをＶＲＡＭへ描画
		InvalidateRect(hwnd, NULL, FALSE);						//		ウィンドゥ描画
	}

	si.cbSize = sizeof(SCROLLINFO);								//	縦スクロール情報取得
	si.fMask  = SIF_ALL;										//	・
	GetScrollInfo(hwnd, SB_VERT, &si);							//	・
	svPos = si.nPos;											//	現在の縦方向位置を退避

	switch (knd) {												//	
		case SB_TOP:		si.nPos = si.nMin;		break;		//	○ →先頭へ移動
		case SB_BOTTOM:		si.nPos = si.nMax;		break;		//	○ →末尾へ移動
		case SB_LINEUP:		si.nPos -= 1;			break;		//	○ →１行スクロールアップ
		case SB_LINEDOWN:	si.nPos += 1;			break;		//	○ →　〃　　　　　ダウン
		case SB_PAGEUP:		si.nPos -= si.nPage;	break;		//	○ →１項スクロールアップ
		case SB_PAGEDOWN:	si.nPos += si.nPage;	break;		//	○ →　〃　　　　　ダウン
		case SB_THUMBTRACK:	si.nPos = si.nTrackPos;	break;		//	○ →スクロールバーを離した位置へ移動
	}
	si.fMask = SIF_POS;											//	スクロール位置設定
	SetScrollInfo(hwnd, SB_VERT, &si, TRUE);					//	・
	GetScrollInfo(hwnd, SB_VERT, &si);							//	スクロール位置取得
	if (si.nPos != svPos) {										//	スクロール位置に変化あり？
		pW->IxWTop = VthLnoToIx(pW, si.nPos);					//		表示先頭インデクス設定
		InvalidateRect(hwnd, NULL, FALSE);						//		ウィンドゥ描画
		//--- 縦スクロール通知 ---//
		pW->NtcTop = AjcVthGetIxOfWndTopLine(pW->hBack);
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_VSCROLL),
						fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcTop);

		//	次回文字列検索時、検索開始位置を再設定する
		VthResetFindSrtPos(pW);
	}

	VthSetCaret(pW);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SETFOCUS	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	pW->fFocus = TRUE;
	CreateCaret(hwnd, NULL, 2, pW->cyChar);
	VthSetCaret(pW);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_KILLFOCUS	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	pW->fFocus = FALSE;
	HideCaret(hwnd);
	DestroyCaret();
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DROPFILES	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	HWND		hParent = GetParent(pW->hBack);
	HDROP	hDrop;
	UI		i, n, bytes;
	WC		path[MAX_PATH];

	//----- 前回のドロップデータ破棄 ----------------------------------//
	AjcRngPurge(pW->hRngDir);
	AjcRngPurge(pW->hRngFile);

	//----- カウンタクリアー ------------------------------------------//
	pW->NtcDirs = pW->NtcFiles = 0;
	//----- ドロップディレクトリ名／ファイル名取得 --------------------//
	hDrop = (HDROP)wParam;														//	ドロップハンドル設定
	n	  = DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);							//	ドロップファイル数取得
	for (i=0; i<n; i++) {														//	ドロップパス数ループ
		DragQueryFile(hDrop, i, path, MAX_PATH);								//	ドロップパス名取得
		if (AjcPathExists(path)) {												//	有効なパス？
			bytes = (UI)(wcslen(path) * 2 + 2);									//		パス名の長さ設定
			if (AjcPathIsDirectory(path)) {										//		ディレクトリ？
				pW->NtcDirs++;													//				DIR数更新
				AjcRngPutData(pW->hRngDir, (VOP)&bytes, sizeof bytes);			//				DIR名退避
				AjcRngPutData(pW->hRngDir, (VOP)path, bytes);						//				・
			}
			else {																//		ファイル？
				pW->NtcFiles++;													//				FILE数更新
				AjcRngPutData(pW->hRngFile, (VOP)&bytes, sizeof bytes);			//				ファイル名退避
				AjcRngPutData(pW->hRngFile, (VOP)path, bytes);					//				・
			}
		}
	}
	DragFinish(hDrop);															//	ドロップ終了

	//----- ディレクトリドロップイベント通知 --------------------------//
	if (pW->NtcDirs) {
		SendMessage(hParent, WM_COMMAND, MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_DROPDIR) ,
																	 fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcDirs);
	}
	//----- ファイルドロップイベント通知 ------------------------------//
	if (pW->NtcFiles) {
		SendMessage(hParent, WM_COMMAND, MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_DROPFILE),
																	 fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcFiles);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CHAR		)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	//----- キー押し続けによる繰り返し情報設定 -----------------------------//
	if (!(lParam & 0x40000000)) pW->KeyRep = 0;
	else						pW->KeyRep++;

	//----- 非選択状態＆非ドラッグモードならば、ユーザへキー入力通知 --//
	if (!(pW->Mode & (MD_SELECT | MD_DRAG))) {
		//	UNICODEモード
		if (IsWindowUnicode(GetParent(pW->hBack))) {
			pW->NtcKey = (UI)wParam;
			SendMessageW(GetParent(pW->hBack), WM_COMMAND, 
							MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_KEYIN),
							fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcKey);
		}
		//	バイト文字モード
		else {
			UI	i;
			WC	wc[2] = {0};
			BC	bc[3] = {0};
			//	バイト文字へ変換
			wc[0] = (WC)wParam;
			WideCharToMultiByte(CP_ACP, 0, wc, -1, bc, 3, NULL, NULL);
			bc[2] = 0;
			for (i = 0; i < 2 && bc[i] != 0; i++) {
				pW->NtcKey = (UI)bc[i];
				SendMessageA(GetParent(pW->hBack), WM_COMMAND, 
								MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_KEYIN),
								fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcKey);
			}
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_KEYDOWN	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	int			ix;
	PLINEPTR	pL;
	int			ltop, lend;
	int			ctop, cend;
	int			lp, tix;

	//----- キー押し続けによる繰り返し情報設定 -----------------------------//
	if (!(lParam & 0x40000000)) pW->KeyRep = 0;
	else						pW->KeyRep++;

	//----- シフトキー押下フラグ設定 ---------------------------------------//
	if (wParam == VK_SHIFT) {
		pW->fShift = TRUE;
	}
	//----- CTRLキー押下フラグ設定 -----------------------------------------//
	if (wParam == VK_CONTROL) {
		pW->fCtrl = TRUE;
	}

	//----- 選択状態ならば、選択範囲変更／選択解除処理 ---------------------//
	if (pW->Mode & MD_SELECT && wParam != pW->FindKey) {
		//	非ドラッグモード時のみ動作する
		if (!(pW->Mode & MD_DRAG)) {
			//	ＥＳＣ：選択解除
			if (wParam == VK_ESCAPE) {
				//	選択状態解除
				VthSetMode(pW, pW->Mode & ~MD_SELECT);
				//	再描画
				VthPutTextToVRAM(pW);
				InvalidateRect(hwnd, NULL, FALSE);
			}
			//	Ctrl + C : コピー
			else if (pW->fCtrl && wParam == 'C') {
				if (pW->PopupMask & AJCVTHMM_COPYTXT) {
					AjcVthCopyText(pW->hBack);
					VthSetMode(pW, pW->Mode & ~MD_SELECT);
					InvalidateRect(pW->hMain, NULL, FALSE);
				}
			}
			//	Shift + ↑↓←→：選択範囲変更
			else if (pW->fShift && (wParam == VK_UP || wParam == VK_DOWN || wParam == VK_LEFT || wParam == VK_RIGHT)) {
				//	行，文字インデクス設定
				ltop = VthIxToLno(pW, pW->IxWTop);		//	ウインド最上位行位置
				lend = ltop + (pW->wh / pW->cyChar);	//	ウインド最下位行位置＋１
				ctop = pW->IxOfs;						//	ウインド最左端文字インデクス
				cend = ctop + (pW->ww / pW->cxChar);	//	ウインド最右端文字インデクス＋１
				lp	 = VthIxToLno(pW, pW->SelInf.ixEL);	//	現在の行位置
				tix	 = pW->SelInf.ixEC;					//	現在の文字インデクス
				//	行，文字インデクス移動
				switch (wParam) {
					//	→キー
					case VK_RIGHT:	ix = VthLnoToIx(pW, lp);
									pL = pW->pLPtr + ix;
									if (tix < pL->len - 1) {
										//	文字インデクスを右へ移動
										tix++;
										//	サロゲート２ワード目ならば、さらに右へ移動
										tix = ForwToCharPosIf2ndSurrWord(pW, lp, tix);
										//	↑↓キーによる選択時のインデクス設定
										pW->IxOfSelUpDnKey = tix;
										break;
									}
									else {
										if (lp < (int)pW->LCnt - 1) {
											tix = 0;
										}
										//	↓キー処理へ続く・・・
									}
					//	↓キー
					case VK_DOWN:	if (lp < (int)pW->LCnt - 1) {
										//	行位置を下へ移動
										lp++;
										//	文字インデクス設定
										if (wParam == VK_DOWN) tix = pW->IxOfSelUpDnKey;
										//	文字インデクス補正
										ix = VthLnoToIx(pW, lp);
										pL = pW->pLPtr + ix;
										if (tix > pL->len) tix = pL->len;
										//	サロゲート２ワード目ならば、右へ進める
										tix = ForwToCharPosIf2ndSurrWord(pW, lp, tix);
									}
									break;
					//	←キー
					case VK_LEFT:	if (tix > 0) {
										//	インデクスを左へ移動
										tix--;
										//	サロゲート２ワード目ならば、さらに左へ移動
										tix = BackToCharPosIf2ndSurrWord(pW, lp, tix);
										//	↑↓キーによる選択時の文字インデクス設定
										pW->IxOfSelUpDnKey = tix;
										break;
									}
									else {
										if (lp > 0) {
											tix = pW->prop.VramW;
										}
										//	↑キー処理へ続く・・・
									}
					//	↑キー
					case VK_UP:		if (lp > 0) {
										//	行位置を上へ移動
										lp--;
										//	文字インデクス設定
										if (wParam == VK_UP) tix = pW->IxOfSelUpDnKey;
										//	文字インデクス補正
										ix = VthLnoToIx(pW, lp);
										pL = pW->pLPtr + ix;
										if (tix > pL->len) tix = pL->len;
										//	サロゲート２ワード目ならば１つ戻す
										tix = BackToCharPosIf2ndSurrWord(pW, lp, tix);
									}
									break;
				}
				//----- 選択範囲設定 ---------------------------------------//
				pW->SelInf.ixEL = VthLnoToIx(pW, lp);
				pW->SelInf.ixEC = tix;
				//----- 縦スクロール ---------------------------------------//
				if		(lp <  ltop) VthSetVScrollInfo(pW, ltop - 1);
				else if (lp >= lend) VthSetVScrollInfo(pW, ltop + 1);
				//----- 横スクロール ---------------------------------------//
				if		(tix <	ctop) VthSetHScrollInfo(pW, ctop - 1);
				else if (tix >= cend) VthSetHScrollInfo(pW, ctop + 1);
				//----- 再描画 ---------------------------------------------//
				InvalidateRect(hwnd, NULL, FALSE);
			}
		}
	}
	//----- 非選択状態ならば、ユーザへキー押下通知／検索 -------------------//
	else {
		//	文字列検索
		if (pW->FindKey != 0 && wParam == pW->FindKey	&&		//	検索キー(F3)押下
			pW->SrhStr[0] != 0 							&&		//	検索文字列は設定済み
			(pW->PopupMask & AJCVTHMM_FIND)) {					//	メニューで「文字列検索」許可

			if		(pW->fShift && !pW->fCtrl) {	//	Shift + F3
				AjcVthSearchAboveExW(pW->hBack,	pW->SrhStr, 
												pW->fSemicolon ? L";" : NULL,
												pW->fAstarisk  ? L"*" : NULL,
												pW->fEnclose   ? L"\"": NULL,
												pW->fTrim, !pW->fExactWidth);
			}
			else if (!pW->fShift && !pW->fCtrl) {	//	F3
				AjcVthSearchBelowExW(pW->hBack,	pW->SrhStr, 
												pW->fSemicolon ? L";" : NULL,
												pW->fAstarisk  ? L"*" : NULL,
												pW->fEnclose   ? L"\"": NULL,
												pW->fTrim, !pW->fExactWidth);
			}
		}
		else {
			pW->NtcKey = (UI)wParam;
			SendMessage(GetParent(pW->hBack), WM_COMMAND, 
							MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_VKEYIN),
							fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcKey);
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_KEYUP		)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	//----- シフトキー押下フラグクリアー -----------------------------------//
	if (wParam == VK_SHIFT) {
		pW->fShift = FALSE;
	}
	//----- CTRLキー押下フラグクリアー -------------------------------------//
	if (wParam == VK_CONTROL) {
		pW->fCtrl = FALSE;
	}
	//----- 非選択状態ならば、ユーザへキー離し通知 -------------------------//
	if (!(pW->Mode & MD_SELECT)) {
		pW->NtcKey = (UI)wParam;
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_VKEYOUT),
						fCmdWithHdl ? (LPARAM)pW->hBack : pW->NtcKey);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONDBLCLK)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);
	int			x = (SW)LOWORD(lParam);
	int			y = (SW)HIWORD(lParam);
	int			ix, lp, tix;
	PLINEPTR	pL;

	//----- 行テキストポインタ開放 --------------------------//
	if (pW->pDblClkLine != NULL) {
		free(pW->pDblClkLine);
		pW->pDblClkLine = NULL;
	}
	//----- 行テキスト退避 ----------------------------------//
	if (VthMusToTextIdx(pW, x, y, &lp, &tix, NULL)) {
		if (lp < (int)pW->LCnt) {
			ix = VthLnoToIx(pW, lp);
			pL = pW->pLPtr + ix;
			if (pW->pDblClkLine = AjcTAlloc(pL->len + 1)) {
				wcsncpy(pW->pDblClkLine, pL->pTxt, pL->len);
				pW->pDblClkLine[pL->len] = 0;
				pW->DblClkLPos	= lp;	//	行位置退避
				pW->DblClkTIdxW = tix;	//	文字インデクス退避
				//	バイト文字インデクス設定
				pW->DblClkTIdxA = WideCharToMultiByte(CP_ACP, 0, pW->pDblClkLine, tix, NULL, 0, NULL, NULL);
			}
		}
	}

	//----- Shft, Ctrl キー情報退避 -------------------------//
	pW->NtcDblClk = (UI)wParam;

	//----- メッセージ通知 ----------------------------------//
	pW->NtcKeyFlg = (UI)wParam;
	SendMessage(GetParent(pW->hBack), WM_COMMAND, 
					MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_DBLCLK),
					fCmdWithHdl ? (LPARAM)pW->hBack : wParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, IDC_BTN_CLS	)
{
	PWRKVT100	pW = (PWRKVT100)MAjcGetWindowLong(hwnd, 0);

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcVthClearAllText(pW->hBack);
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCVTHN_CLEAR), (LPARAM)pW->hBack);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE				)
	AJC_WNDMAP_MSG(Main, WM_DESTROY				)
	AJC_WNDMAP_MSG(Main, WM_SETTINGCHANGE		)
	AJC_WNDMAP_MSG(Main, WM_SIZE				)
	AJC_WNDMAP_MSG(Main, WM_PAINT				)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONDOWN			)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONUP			)
	AJC_WNDMAP_MSG(Main, WM_MBUTTONDOWN			)
	AJC_WNDMAP_MSG(Main, WM_MOUSEMOVE			)
	AJC_WNDMAP_MSG(Main, WM_MOUSEWHEEL			)
	AJC_WNDMAP_MSG(Main, WM_TIMER				)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONDOWN			)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONUP			)
	AJC_WNDMAP_MSG(Main, WM_HSCROLL				)
	AJC_WNDMAP_MSG(Main, WM_VSCROLL				)
	AJC_WNDMAP_MSG(Main, WM_SETFOCUS			)
	AJC_WNDMAP_MSG(Main, WM_KILLFOCUS			)
	AJC_WNDMAP_MSG(Main, WM_DROPFILES			)
	AJC_WNDMAP_MSG(Main, WM_CHAR				)
	AJC_WNDMAP_MSG(Main, WM_KEYDOWN				)
	AJC_WNDMAP_MSG(Main, WM_KEYUP				)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONDBLCLK		)

	AJC_WNDMAP_CMD(Main, IDC_BTN_CLS			)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	選択範囲補正処理（文字位置がサロゲート２ワード目ならば、文字位置を１つ戻す）								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	int		BackToCharPosIf2ndSurrWord(PWRKVT100 pW, int lp, int cp)
{
	int			ix;
	PLINEPTR	pL;
	UBP			pAtt;

	if (cp > 0) {
		ix = VthLnoToIx(pW, lp);
		pL = pW->pLPtr + ix;
		if (cp < pL->len) {
			if (pL->fVram) pAtt = (UBP)(pW->pLPtr[ix].pTxt + pW->prop.VramW);
			else		   pAtt = (UBP)(pW->pLPtr[ix].pTxt + pL->len);
			if (*(pAtt + cp) & VAT_SUR2) {
				cp--;
			}
		}
	}
	return cp;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	選択範囲補正処理（文字位置がサロゲート２ワード目ならば、文字位置を１つ進める）								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	int		ForwToCharPosIf2ndSurrWord(PWRKVT100 pW, int lp, int cp)
{
	int			ix;
	PLINEPTR	pL;
	UBP			pAtt;

	if (cp > 0) {
		ix = VthLnoToIx(pW, lp);
		pL = pW->pLPtr + ix;
		if (cp < pL->len) {
			if (pL->fVram) pAtt = (UBP)(pW->pLPtr[ix].pTxt + pW->prop.VramW);
			else		   pAtt = (UBP)(pW->pLPtr[ix].pTxt + pL->len);
			if (*(pAtt + cp) & VAT_SUR2) {
				cp++;
			}
		}
	}
	return cp;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	テキスト描画																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubTextOut(PWRKVT100 pW, HDC hdc, int x, int y, C_WCP pTxt, int len, COLORREF BakRgb)
{
	BOOL	rc = TRUE;

	//	強制的に固定ピッチで表示
	if (pW->fFixedFont && (pW->style & AJCVTHS_FIXEDPITCH)) {
		C_WCP	p;
		int		i, stl;
		SIZE	sz;
		RECT	r;
		HBRUSH	hBru;
		hBru = CreateSolidBrush(BakRgb);
		//	背景色設定
		VthGetTextExtentPoint(pW, hdc, pTxt, len, &sz);
		r.left = x;		r.right  = x + sz.cx;
		r.top  = y;		r.bottom = y + sz.cy;
		FillRect(hdc, &r, hBru);
		DeleteObject(hBru);
		//	テキスト描画
		for (p = pTxt, i = 0; *p != 0 && i < len;) {
			if (MAjcIsLeadW(*p)) stl = 2;
			else				 stl = 1;
			rc &= (TextOutW(hdc, x, y, p, stl) != 0);
			x += pW->cxChar;
			if (AjcIsBigChar(p)) {
				x += pW->cxChar;
			}
			p += stl;
			i += stl;
		}
	}
	//	フォント依存のピッチで表示
	else {
		rc &= (TextOutW(hdc, x, y, pTxt, len) != 0);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	デフォルトフォントデータ設定																				//
//																												//
//	引	数	：	pLogFont- フォント生成データ																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetDefaultLogFont(LPLOGFONT pLogFont)
{
	pLogFont->lfHeight		= 12;	pLogFont->lfStrikeOut		= 0;
	pLogFont->lfWidth		= 0;	pLogFont->lfCharSet			= DEFAULT_CHARSET;
	pLogFont->lfEscapement	= 0;	pLogFont->lfOutPrecision	= 0;
	pLogFont->lfOrientation	= 0;	pLogFont->lfClipPrecision	= 0;
	pLogFont->lfWeight		= 0;	pLogFont->lfQuality			= 0;
	pLogFont->lfItalic		= 0;	pLogFont->lfPitchAndFamily	= FIXED_PITCH;
	pLogFont->lfUnderline	= 0;	wcscpy(pLogFont->lfFaceName, L"FixedSys");
}
//--------------------------------------------------------------------------------------------------------------//
//	選択範囲チェック																							//
//																												//
//	引	数	：	lLine	- 行の有効ワード数																		//
//				ixL		- 行位置																				//
//				ixC		- 文字インデクス																		//
//																												//
//	戻り値	：	TRUE - 選択範囲内, FALSE - 選択範囲外															//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	IsSelect(PWRKVT100 pW, UI lLine, UI ixL, UI ixC)
{
	BOOL	rc = FALSE;
	UI		ixSL, ixSC, ixEL, ixEC;

	if (pW->Mode & MD_SELECT) {
		//----- 選択範囲ＩＸが共に、先頭ＩＸの片側にある場合 ---------------------------//
		if (VthAdjustSelectInfo(pW, &ixSL, &ixSC, &ixEL, &ixEC)) {
			if (ixL >= ixSL && ixL <= ixEL && ixC < lLine) {
				if (ixSL == ixL && ixEL == ixL) {
					rc = (ixC >= __min(ixSC, ixEC) && ixC < __max(ixSC, ixEC));
				}
				else if (ixSL == ixL) {
					rc = (ixC >= ixSC);
				}
				else if (ixEL == ixL) {
					rc = (ixC < ixEC);
				}
				else {
					rc = TRUE;
				}
			}
		}
		//----- 選択範囲ＩＸが、先頭ＩＸの両側にある場合 ------------------------------//
		else {
			if ((ixL >= ixSL || ixL <= ixEL) && ixC < lLine) {
				if (ixSL == ixL) {
					rc = (ixC >= ixSC);
				}
				else if (ixEL == ixL) {
					rc = (ixC < ixEC);
				}
				else {
					rc = TRUE;
				}
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	少し暗めの色取得																							//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static COLORREF	DarkRgb(PWRKVT100 pW, COLORREF rgb)
{
	UI	r = GetRValue(rgb) * 95 / 100;
	UI	g = GetGValue(rgb) * 95 / 100;
	UI	b = GetBValue(rgb) * 95 / 100;

	return RGB(r, g, b);
}
//--------------------------------------------------------------------------------------------------------------//
//	フォント，行間スペース コピー																				//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	CopyFontAndLineSpace(PWRKVT100 pW)
{
	HGLOBAL	hGlobal;
	UI		len;
	WCP		pTxt;
	WC		txt[256] = {0};

	//	フォント，行間スペースのテキスト作成
	AjcSnPrintF(txt, AJCTSIZE(txt), L"LS=%u, FN=%s, LF=%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d",
							pW->prop.LSpace						,
							pW->prop.LogFont.lfFaceName			,
							pW->prop.LogFont.lfHeight			,
							pW->prop.LogFont.lfWidth			,
							pW->prop.LogFont.lfEscapement		,
							pW->prop.LogFont.lfOrientation		,
							pW->prop.LogFont.lfWeight			,
							pW->prop.LogFont.lfItalic			,
							pW->prop.LogFont.lfUnderline		,
							pW->prop.LogFont.lfStrikeOut		,
							pW->prop.LogFont.lfCharSet			,
							pW->prop.LogFont.lfOutPrecision		,
							pW->prop.LogFont.lfClipPrecision	,
							pW->prop.LogFont.lfQuality			,
							pW->prop.LogFont.lfPitchAndFamily);

	if (len = (UI)wcslen(txt)) {
		len++;
		if (hGlobal = GlobalAlloc(GHND | GMEM_SHARE, len * 2 + 2)) {
			pTxt = (WCP)GlobalLock(hGlobal);
			GlobalUnlock(hGlobal);
			OpenClipboard(pW->hBack);
			EmptyClipboard();
			wcscpy(pTxt, txt);
			SetClipboardData(CF_UNICODETEXT, hGlobal);
			CloseClipboard();
		}
	}

}
//--------------------------------------------------------------------------------------------------------------//
//	フォント，行間スペース 貼り付け																				//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	PasteFontAndLineSpace(PWRKVT100 pW)
{
	HGLOBAL		hGlobal;
	AJCVTHPROP	prop;
	WCP			pClip, p;
	UI			i;

	//	クリップボードデータを読み出してプロパティ設定
	if (OpenClipboard(pW->hBack)) {
		if (hGlobal = GetClipboardData(CF_UNICODETEXT)) {
			if (pClip = (WCP)GlobalLock(hGlobal)) {
				//	プロパティ デフォルト値設定
				memcpy(&prop, &pW->prop, sizeof prop);
				//	行間スペース設定
				if (p = wcsstr(pClip, L"LS=")) {
					prop.LSpace = _wtoi(p + 3);
				}
				//	フォント名設定
				if (p = wcsstr(pClip, L"FN=")) {
					p += 3;
					for (i = 0; *p != 0 && *p != L',' && i < AJCTSIZE(prop.LogFont.lfFaceName) - 1; i++) {
						prop.LogFont.lfFaceName[i] = *p++;
					}
					prop.LogFont.lfFaceName[i] = 0;
				}
				//	フォント属性設定
				if (p = wcsstr(pClip, L"LF=")) {
					AjcGetSepNumbers(p + 3, L'/', L"iiiiibbbbbbbb", &prop.LogFont.lfHeight			,
																	&prop.LogFont.lfWidth			,
																	&prop.LogFont.lfEscapement		,
																	&prop.LogFont.lfOrientation		,
																	&prop.LogFont.lfWeight			,
																	&prop.LogFont.lfItalic			,
																	&prop.LogFont.lfUnderline		,
																	&prop.LogFont.lfStrikeOut		,
																	&prop.LogFont.lfCharSet			,
																	&prop.LogFont.lfOutPrecision		,
																	&prop.LogFont.lfClipPrecision	,
																	&prop.LogFont.lfQuality			,
																	&prop.LogFont.lfPitchAndFamily);
				}
				//	プロパティ設定
				VthSetCtrlProp(pW, &prop);
				//	クリップボード使用終了
				GlobalUnlock(hGlobal);
			}
		}
		CloseClipboard();
	}

}
//--------------------------------------------------------------------------------------------------------------//
//	フォント，行間スペースを全スレッドウインドへ適用															//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbSftatEnumChildWindows(HWND hwnd, LPARAM lParam)
{
	PWRKVT100 pW = (PWRKVT100)lParam;
	WC		cname[MAX_PATH];

	if (hwnd != pW->hBack) {
		GetClassName(hwnd, cname, AJCTSIZE(cname));
		if (wcscmp(cname, L"AjcCtrlVT100") == 0) {
			SendMessage(hwnd, AJCVTHM_SETFONT, (WPARAM)pW->hFontText, pW->prop.LSpace);
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbSftatEnumThreadWindows(HWND hwnd, LPARAM lParam)
{
	EnumChildWindows(hwnd, cbSftatEnumChildWindows, lParam);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
static VO	SetFontToAllThreadWindow(PWRKVT100 pW)
{
	EnumThreadWindows(GetCurrentThreadId(), (WNDENUMPROC)cbSftatEnumThreadWindows, (LPARAM)pW);
}
//--------------------------------------------------------------------------------------------------------------//
//	フォント，行間スペースを全兄弟ウインドへ適用																//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static VO	SetFontToAllSiblingsWindow(PWRKVT100 pW)
{
	HWND	hParent = GetParent(pW->hBack);
	WC		cname[MAX_PATH];

	//	親ウインドのクラス名取得
	GetClassName(hParent, cname, AJCTSIZE(cname));
	//	MSILならば、２世代祖先の子ウインド検索
	if (wcscmp(cname, L"AjcVthForMSIL") == 0) {
		if (hParent = GetParent(hParent)) {
			if (hParent = GetParent(hParent)) {
				EnumChildWindows(hParent, cbSftatEnumChildWindows, (LPARAM)pW);
			}
		}
	}
	//	WIN32ならば、親ウインドから兄弟検索
	else {
		HWND	hwnd = GetWindow(hParent, GW_CHILD);
		while (hwnd) {
			if (hwnd != pW->hBack) {
				GetClassName(hwnd, cname, AJCTSIZE(cname));
				if (wcscmp(cname, L"AjcCtrlVT100") == 0) {
					SendMessage(hwnd, AJCVTHM_SETFONT, (WPARAM)pW->hFontText, pW->prop.LSpace);
				}
			}
			hwnd = GetWindow(hwnd, GW_HWNDNEXT);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	スレッドウインド下に他ＶＴ１００ウインドが存在するかチェック												//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbIevitwEnumChildWindows(HWND hwnd, LPARAM lParam)
{
	PWRKVT100	pW = (PWRKVT100)lParam;
	BOOL		rc = TRUE;
	UI			sty;
	WC			cname[MAX_PATH];

	if (hwnd != pW->hBack) {
		GetClassName(hwnd, cname, AJCTSIZE(cname));
		if (wcscmp(cname, L"AjcCtrlVT100") == 0) {
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			if (!(sty & AJCVTHS_FIXEDFONT)) {
				pW->fExistWindow = TRUE;
				rc = FALSE;
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbIevitwEnumThreadWindows(HWND hwnd, LPARAM lParam)
{
	PWRKVT100	pW = (PWRKVT100)lParam;
	BOOL		rc = TRUE;

	EnumChildWindows(hwnd, cbIevitwEnumChildWindows, lParam);
	if (pW->fExistWindow) rc = FALSE;
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL	IsExistVT100InThreadWindow(PWRKVT100 pW)
{
	pW->fExistWindow = FALSE;
	EnumThreadWindows(GetCurrentThreadId(), (WNDENUMPROC)cbIevitwEnumThreadWindows, (LPARAM)pW);
	return pW->fExistWindow;
}
//--------------------------------------------------------------------------------------------------------------//
//	兄弟ウインドに他ＶＴ１００ウインドが存在するかチェック														//
//																												//
//	引　数	：	pW	  - 作業領域のアドレス																		//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static BOOL	IsExistVT100InSiblingsWindow(PWRKVT100 pW)
{
	HWND	hParent = GetParent(pW->hBack);
	WC		cname[MAX_PATH];

	//	検索結果フラグクリアー
	pW->fExistWindow = FALSE;

	//	親ウインドのクラス名取得
	GetClassName(hParent, cname, AJCTSIZE(cname));
	//	MSILならば、２世代祖先の子ウインド検索
	if (wcscmp(cname, L"AjcVthForMSIL") == 0) {
		if (hParent = GetParent(hParent)) {
			if (hParent = GetParent(hParent)) {
				EnumChildWindows(hParent, cbIevitwEnumChildWindows, (LPARAM)pW);
			}
		}
	}
	//	WIN32ならば、親ウインドから兄弟検索
	else {
		HWND	hwnd = GetWindow(hParent, GW_CHILD);
		while (hwnd) {
			if (hwnd != pW->hBack) {
				GetClassName(hwnd, cname, AJCTSIZE(cname));
				if (wcscmp(cname, L"AjcCtrlVT100") == 0) {
					pW->fExistWindow = TRUE;
				}
			}
			hwnd = GetWindow(hwnd, GW_HWNDNEXT);
		}
	}

	return pW->fExistWindow;
}
