﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	ダイアログとコントロール群の背景色とテキスト色設定															//
//																												//
//**************************************************************************************************************//

//	ダイアログ属性
#define	SBCDONE			L"_AJCCTRLSCOLOR_SBCDONE_"		/*	サブクラス済みフラグ								*/
#define	SBCSUPP			L"_AJCCTRLSCOLOR_SBCSUPP_"		/*	サブクラス抑止フラグ								*/
#define	BMPTRANS		L"_AJCCTRLSCOLOR_BMP_TRANS_"	/*	ビットマップの透明色								*/
#define	STRPOOL			L"_AJCCTRLSCOLOR_STRPOOL_"		/*	文字列プール										*/

#define	FLG_SBCDONE		0x7652BBC5
#define	FLG_SBCSUPP		0x43CFA63C

//	ボタン属性
#define	BTNATT			L"_AJCCTRLSCOLOR_BTNATT_"		/*	ボタン属性											*/

//--------------------------------------------------------------------------------------------------------------//
//	ボタンの属性																								//
//--------------------------------------------------------------------------------------------------------------//
#define	BTNATT_NOTZERO	0x80000000		/*	Bit31	 : ゼロ以外の値とするためのビット（１固定）	*/

#define	BTNATT_CHKMASK	0x0C000000		/*	Bit27-26 : チェックボックスステータス				*/
#define	BTNATT_CHKOFF	0x00000000		/*				チェック無し							*/
#define	BTNATT_CHKON	0x04000000		/*				チェック有り							*/
#define	BTNATT_3S		0x08000000		/*				不定									*/

#define	BTNATT_FOCUS	0x02000000		/*	Bit25	 : ボタンフォーカス状態						*/
#define	BTNATT_PUSH		0x01000000		/*	Bit24	 : ボタン押下状態							*/

#define	BTNATT_SKIPCLK	0x00100000		/*	Bit20	 : ダブルクリック直後のクリック通知を抑止	*/

#define	BTNATT_STYMASK	0x0000FFFF		/*	Bit15-0  : オリジナルのボタンスタイル				*/

//--------------------------------------------------------------------------------------------------------------//
//	サブクラス化した場合の変更可能なボタンスタイル																//
//--------------------------------------------------------------------------------------------------------------//
#define	BTNSTY_VALID	(BS_TEXT		|		\
						 BS_ICON		|		\
						 BS_BITMAP		|		\
						 BS_LEFT		|		\
						 BS_RIGHT		|		\
						 BS_CENTER		|		\
						 BS_TOP			|		\
						 BS_BOTTOM		|		\
						 BS_VCENTER		|		\
						 BS_MULTILINE	|		\
						 BS_NOTIFY		|		\
						 BS_FLAT		|		\
						 0)

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	HBRUSH			hBruBkGnd  = NULL;		//	背景色のブラシ
static	BOOL			fShowFocus = TRUE;		//	ボタンフォーカス時の点線枠表示フラグ
static	AJCDLGCOLORS	Cols;					//	ダイアログ，コントロール群の描画色
static	AJCMENUCOLORS	Mncs;					//	メニュー描画色
static	HFONT			hSysMnuFont= NULL;		//	システムのデフォルトメニュー・フォント
static	HFONT			hMnuFont   = NULL;		//	メニューのフォント

//	メニュー項目表示マージン
static	int		MnuLMrg	= 6;
static	int		MnuUMrg	= 2;
static	int		MnuDMrg	= 2;

//	可変メッセージコード
static	UI		WMSG_CTLCOLOR_ANY = 0;	//	WMSG_CTLCOLOR_ANY メッセージコード
static	UI		WMSG_CTLCOLOR_BTN = 0;	//	WMSG_CTLCOLOR_BTN メッセージコード
static	UI		WMSG_CTLCOLOR_LSI = 0;	//	WMSG_CTLCOLOR_LSI メッセージコード
static	UI		WMSG_CTLDRAW_LSI  = 0;	//	WMSG_CTLDRAW_LSI  メッセージコード

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(SBC_DIALOG	);
AJC_WNDPROC_DEF(SBC_AUTORBT );
AJC_WNDPROC_DEF(SBC_PUSHBTN );
AJC_WNDPROC_DEF(SBC_PUSHLIKE);

static	BOOL CALLBACK	cbEnumMenuSetOwnerDraw(HMENU hMenu, UI ix, UX id, UI type, UI state, HMENU hSubMenu, UX cbp);

static	BOOL CALLBACK	cbSccEnumChildWindows(HWND hwnd, LPARAM lParam);
static	VO				ResetAllRbtInGroup(HWND hMyRbt, BOOL fOnlyOwnerDraw);

static	VO				DrawButton	   (HWND hBtn, HDC btdc, LPRECT pRect, int width, int height);
static	VO				SubDrawIcon 		 (HDC btdc, int width, int height, HICON   hIco, UI att, BOOL fDisabled, COLORREF ccTrans);
static	VO				SubDrawBitmap		 (HDC btdc, int width, int height, HBITMAP hIco, UI att, BOOL fDisabled, COLORREF ccTrans);
static	VO				DrawBitmapGray		 (HDC hdc, int x, int y, int cx, int cy, HBITMAP hBmp, COLORREF ccTrans, COLORREF ccGray);
static	VO				DrawBitmapNormal	 (HDC hdc, int x, int y, int cx, int cy, HBITMAP hBmp, COLORREF ccTrans);
static	VO				DrawGrayBmpIcon 	 (HDC btdc, int dx, int dy, PAJCDIBINFO pDif, HDC mdc, int cx, int cy, COLORREF ccGray, COLORREF ccTrans);
static	VO				SubDrawFramePushBtn  (HDC btdc, LPRECT pRect, UI att, BOOL fShowFocus);
static	VO				SubDrawFramePushLike (HDC btdc, LPRECT pRect, UI att, BOOL fShowFocus);

static	VO				DrawLineLU	   (HDC btdc, COLORREF cc, LPRECT pRc, int rel, BOOL fDotLine);
static	VO				DrawLineRD	   (HDC btdc, COLORREF cc, LPRECT pRc, int rel, BOOL fDotLine);
static	VO				DrawLineRC	   (HDC btdc, COLORREF cc, LPRECT pRc, int rel, BOOL fDotLine);
static	VO				DotLineVert    (HDC btdc, COLORREF cc, int x, int y1, int y2);
static	VO				DotLineHori    (HDC btdc, COLORREF cc, int x1, int x2, int y);

static	WCP				AmpCreateExcText(WCP pTxt, UI lTxt, BOOL fMulti, BOOL fRemoveTAB);

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcDgcInit(VO)
{
	NONCLIENTMETRICS ncMetrics;

	//	AJCM_CTLCOLORメッセージコード設定
	WMSG_CTLCOLOR_ANY = RegisterWindowMessage(AJCM_CTLCOLOR_ANY_STR);
	WMSG_CTLCOLOR_BTN = RegisterWindowMessage(AJCM_CTLCOLOR_BTN_STR);
	WMSG_CTLCOLOR_LSI = RegisterWindowMessage(AJCM_CTLCOLOR_LSI_STR);
	WMSG_CTLDRAW_LSI  = RegisterWindowMessage(AJCM_CTLDRAW_LSI_STR);

	//	ウインド／コントロール描画色初期化
	Cols.ccBkGnd		= RGB(220, 250, 220);	//	ウインド背景色（薄緑）
	Cols.ccTextColor 	= RGB(	0,	 0, 180);	//	テキスト色（青）
	Cols.ccGrayText	 	= RGB(160, 160, 160);	//	無効テキスト色
	Cols.ccLtGray	 	= RGB(227, 227, 227);	//	薄い影（薄いグレー）
	Cols.ccGray		 	= RGB(160, 160, 160);	//	通常影（グレー）
	Cols.ccDark		 	= RGB(105, 105, 105);	//	暗い影（濃いグレー）
	Cols.ccBright	 	= RGB(255, 255, 255);	//	明るい色（白）
	Cols.ccHatch	 	= RGB(255, 255, 255);	//	ハッチ模様（白，BS_PUSHLIKEスタイル時の背景）
	Cols.ccDefOutL		= RGB(	0, 100, 215);	//	デフォルトプッシュボタンの外枠

	//	メニュー描画色初期化
	Mncs.ccBkColor.std		= RGB(220, 250, 220);	//	背景色（通常時，薄緑）
	Mncs.ccBkColor.sel		= RGB(183, 212, 240);	//	背景色（選択時，濃水色）
	Mncs.ccBkColor.dis		= RGB(220, 250, 220);	//	背景色（無効時，グレー）
	Mncs.ccBkColor.both		= RGB(200, 200, 200);	//	背景色（選＆無，濃いめのグレー）

	Mncs.ccBkOnBar.std		= RGB(220, 250, 220);	//	メニューバー項目の背景色（通常時，薄緑）
	Mncs.ccBkOnBar.sel		= RGB(204, 232, 255);	//	メニューバー項目の背景色（選択時，濃水色）
	Mncs.ccBkOnBar.dis		= RGB(220, 250, 220);	//	メニューバー項目の背景色（無効時，グレー）
	Mncs.ccBkOnBar.both		= RGB(200, 200, 200);	//	メニューバー項目の背景色（選＆無，濃いめのグレー）

	Mncs.ccTextColor.std	= RGB(	0,	 0, 240);	//	テキスト色（通常時，青）
	Mncs.ccTextColor.sel	= RGB(	0,	 0, 240);	//	テキスト色（選択時，青）
	Mncs.ccTextColor.dis	= RGB(160, 160, 160);	//	テキスト色（無効時，グレー）
	Mncs.ccTextColor.both	= RGB(255, 255, 255);	//	テキスト色（選＆無，白）

	Mncs.ccChkMark.std		= RGB(	0,	 0, 240);	//	チェックマーク（通常時，青）
	Mncs.ccChkMark.sel		= RGB(	0,	 0, 240);	//	チェックマーク（選択時，青）
	Mncs.ccChkMark.dis		= RGB(160, 160, 160);	//	チェックマーク（無効時，グレー）
	Mncs.ccChkMark.both		= RGB(160, 160, 160);	//	チェックマーク（選＆無，グレー）

	Mncs.ccChkBack.std		= RGB(145, 201, 247);	//	チェック背景色（通常時，背景色（選択時）と同じ）
	Mncs.ccChkBack.sel		= RGB( 86, 176, 250);	//	チェック背景色（選択時，背景色よりやや暗めの薄緑）
	Mncs.ccChkBack.dis		= RGB(228, 228, 228);	//	チェック背景色（無効時，薄いグレー）
	Mncs.ccChkBack.both		= RGB(216, 216, 216);	//	チェック背景色（選＆無，上記よりやや暗いグレー）

	Mncs.ccBitmap.std		= RGB(	0,	 0,   0);	//	ビットマップ色（通常時，未使用）
	Mncs.ccBitmap.sel		= RGB(	0,	 0,   0);	//	ビットマップ色（選択時，未使用）
	Mncs.ccBitmap.dis		= RGB(160, 160, 160);	//	ビットマップ色（無効時，グレー）
	Mncs.ccBitmap.both		= RGB(255, 255, 255);	//	ビットマップ色（選＆無，白）

	Mncs.ccTriangle.std		= RGB(	0,	 0, 240);	//	サブメニューインジケータ（三角マーク）の色（通常時，青）
	Mncs.ccTriangle.sel		= RGB(	0,	 0, 240);	//	サブメニューインジケータ（三角マーク）の色（選択時，青）
	Mncs.ccTriangle.dis		= RGB(160, 160, 160);	//	サブメニューインジケータ（三角マーク）の色（無効時，グレー）
	Mncs.ccTriangle.both	= RGB(160, 160, 160);	//	サブメニューインジケータ（三角マーク）の色（選＆無，グレー）

	Mncs.ccSepLine			= RGB(160, 160, 160);	//	セパレータライン色
	Mncs.ccUnderLine		= RGB(105, 105, 105);	//	ショートカットキーの下線色（濃いグレー）

	//	デフォルトメニューフォント設定
	ncMetrics.cbSize = sizeof(NONCLIENTMETRICS);
	SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICS), &ncMetrics, 0);	
	hSysMnuFont = CreateFontIndirect(&ncMetrics.lfMenuFont);

	return TRUE;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO	AjcDgcEnd(VO)
{
	//	ブラシ破棄
	if (hBruBkGnd != NULL) {
		DeleteObject(hBruBkGnd);
		hBruBkGnd = NULL;
	}
	//	システムのデフォルトメニューフォント破棄
	if (hSysMnuFont != NULL) {
		DeleteObject(hSysMnuFont);
		hSysMnuFont = NULL;
	}
}
//==============================================================================================================//
//	セットアップ																								//
//																												//
//	引　数：	pBuf - 描画色を格納するバッファのアドレス														//
//																												//
//	戻り値：	フォーカス表示フラグ																			//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcSetup(VO)
{
	BOOL	rc = FALSE;

	//	ブラシ生成
	if (hBruBkGnd == NULL) {
		if ((hBruBkGnd = CreateSolidBrush(Cols.ccBkGnd)) != NULL) {
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	背景色とテキスト色設定																						//
//																												//
//	引　数：	BkColor   - 背景色																				//
//				TextColor - 文字色																				//
//																												//
//	戻り値：	TRUE ：成功																						//
//				FALSE：失敗																						//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcSetColors(COLORREF BkColor, COLORREF TextColor)
{
	BOOL	rc = FALSE;

	if (hBruBkGnd != NULL) {
		//	描画色設定
		if ((int)BkColor  != -1) {
			//	コントロール背景色設定
			Cols.ccBkGnd		= BkColor;
			//	メニュー背景色設定
			Mncs.ccBkColor.std = BkColor;
			Mncs.ccBkColor.dis = BkColor;
			Mncs.ccBkOnBar.std = BkColor;
			Mncs.ccBkOnBar.dis = BkColor;
		}
		if ((int)TextColor != -1) {
			//	コントロールテキスト色設定
			Cols.ccTextColor	= TextColor;
			//	メニューテキスト色設定
			Mncs.ccTextColor.std = TextColor;
			Mncs.ccTextColor.sel = TextColor;
			Mncs.ccChkMark.std	 = TextColor;
			Mncs.ccChkMark.sel	 = TextColor;
			Mncs.ccTriangle.std  = TextColor;
			Mncs.ccTriangle.sel  = TextColor;
		}
		//	背景ブラシ再設定
		DeleteObject(hBruBkGnd);
		hBruBkGnd = CreateSolidBrush(Cols.ccBkGnd);

		rc = TRUE;
	}
	return TRUE;
}
//==============================================================================================================//
//	描画色の詳細情報取得																						//
//																												//
//	引　数：	pCtlColors	- コントロールの描画色を格納するバッファのアドレス	（不要時はNULL）				//
//				pMnuColors	- メニュ^の描画色を格納するバッファのアドレス		（不要時はNULL）				//
//																												//
//	戻り値：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcGetColorInfo(PAJCDLGCOLORS  pCtlColors, PAJCMENUCOLORS pMnuColors)
{
	BOOL	rc = FALSE;

	if (hBruBkGnd != NULL) {
		if (pCtlColors != NULL) {
			memcpy(pCtlColors, &Cols, sizeof(AJCDLGCOLORS));
		}
		if (pMnuColors != NULL) {
			memcpy(pMnuColors, &Mncs, sizeof(AJCMENUCOLORS));
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	描画色の詳細情報設定																						//
//																												//
//	引　数：	pCtlColors	- コントロールの描画色を格納するバッファのアドレス	（不要時はNULL）				//
//				pMnuColors	- メニュ^の描画色を格納するバッファのアドレス		（不要時はNULL）				//
//																												//
//	戻り値：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcSetColorInfo(PCAJCDLGCOLORS pCtlColors, PCAJCMENUCOLORS pMnuColors)
{
	BOOL	rc = FALSE;

	if (hBruBkGnd != NULL) {
		if (pCtlColors != NULL) {
			memcpy(&Cols, pCtlColors, sizeof(AJCDLGCOLORS));
			//	背景ブラシ再設定
			DeleteObject(hBruBkGnd);
			hBruBkGnd = CreateSolidBrush(Cols.ccBkGnd);
		}
		if (pMnuColors != NULL) {
			memcpy(&Mncs, pMnuColors, sizeof(AJCMENUCOLORS));
		}
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	フォーカス表示フラグ取得																					//
//																												//
//	引　数：	なし																							//
//																												//
//	戻り値：	TRUE  : フォーカス表示																			//
//				FALSE : フォーカス非表示																		//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcGetShowFocus(VO)
{
	BOOL	rc = FALSE;

	if (hBruBkGnd != NULL) {
		rc = fShowFocus;
	}
	return rc;
}
//==============================================================================================================//
//	フォーカス表示フラグ設定																					//
//																												//
//	引　数：	fShow	- フォーカス表示フラグ																	//
//																												//
//	戻り値：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcSetShowFocus(BOOL fShow)
{
	BOOL	rc = FALSE;

	if (hBruBkGnd != NULL) {
		fShowFocus = fShow;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	メニューフォント取得																						//
//																												//
//	引　数：	なし																							//
//																												//
//	戻り値：	メニューフォント																				//
//==============================================================================================================//
AJCEXPORT HFONT	 WINAPI AjcDgcGetMenuFont(VO)
{
	HFONT	rc = NULL;

	if (hBruBkGnd != NULL) {
		if (hMnuFont != NULL) rc = hMnuFont;
		else				  rc = hSysMnuFont;
	}
	return rc;
}
//==============================================================================================================//
//	メニューフォント設定																						//
//																												//
//	引　数：	hFont	- フォントハンドル（NULL:デフォルトフォント）											//
//																												//
//	戻り値：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcSetMenuFont(HFONT hFont)
{
	BOOL	rc = FALSE;

	if (hBruBkGnd != NULL) {
		hMnuFont = hFont;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	サブクラス化																								//
//																												//
//	引　数：	hDlg	  - ダイアログウインドハンドル															//
//																												//
//	戻り値：	TRUE ：成功																						//
//				FALSE：失敗																						//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcSubclass(HWND hDlg)
{
	return AjcDgcSubclassEx(hDlg, (COLORREF)-1);
}
//==============================================================================================================//
//	サブクラス化（ビットマップの透明色指定）																	//
//																												//
//	引　数：	hDlg			 - ダイアログウインドハンドル													//
//				ccBmpTransparent - ビットマップ透明色（-1:透明化しない）										//
//																												//
//	戻り値：	TRUE ：成功																						//
//				FALSE：失敗																						//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcSubclassEx(HWND hDlg, COLORREF ccBmpTransparent)
{
	BOOL	rc = FALSE;
	HMENU	hMenu;
	HAJCSPL	hSpl;
	UI		id, att;
	HWND	hBtn;

	if (IsWindow(hDlg) && hBruBkGnd != NULL) {
		//	サブクラス抑止チェック
		if (GetProp(hDlg, SBCSUPP) == NULL) {
			//	二重登録抑止
			if (GetProp(hDlg, SBCDONE) == NULL) {
				SetProp(hDlg, SBCDONE , (HANDLE)((UX)FLG_SBCDONE));
				//	文字列プール作成
				hSpl = AjcSplCreate(AJCCMP_EXACT_WIDTH);
				SetProp(hDlg, STRPOOL, (HANDLE)hSpl);
				//	ＢＭＰ透明色を登録
				SetProp(hDlg, BMPTRANS, (HANDLE)((UX)ccBmpTransparent));
				//	ダイアログをサブクラス化
				if (MAjcMmpSetSubclass(SBC_DIALOG, hDlg) != NULL) {
					//	プッシュボタン，プッシュボタン風チェックボックス／ラジオボタン，オートラジオボタンをサブクラス化
					EnumChildWindows(hDlg, cbSccEnumChildWindows, (LPARAM)hDlg);
					//	デフォルトプッシュボタン設定
					if ((id = (UI)SendMessage(hDlg, DM_GETDEFID, 0, 0)) && HIWORD(id) == DC_HASDEFID) {
						if (hBtn = GetDlgItem(hDlg, LOWORD(id))) {
							if (att = (UI)((UX)GetProp(hBtn, BTNATT))) {
								att &= ~BS_TYPEMASK;
								att |=	BS_DEFPUSHBUTTON;
								SetProp(hBtn, BTNATT, (HANDLE)((UX)att));
							}
						}
					}
					//	メニューをオーナー描画に変更
					if (hMenu = GetMenu(hDlg)) {
						AjcEnumMenuItems(hMenu, TRUE, (UX)hDlg, cbEnumMenuSetOwnerDraw);
					}
					rc = TRUE;
				}
			}
		}
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
static BOOL CALLBACK cbEnumMenuSetOwnerDraw(HMENU hMenu, UI ix, UX id, UI type, UI state, HMENU hSubMenu, UX cbp)
{
	UI			 stl = 0;
	MENUITEMINFO mii = {sizeof(MENUITEMINFO)};
	WCP			 pTxt = NULL;
	WCP			 pTmp = NULL;

	if (!(type & MFT_OWNERDRAW)) {
		//	ユーザデータ設定
		//	・ビットマップ
		if		(type & MFT_BITMAP) {
			BITMAP	bm;
			//	マップハンドル取得
			mii.fMask = MIIM_BITMAP;
			GetMenuItemInfo(hMenu, ix, TRUE, &mii);
			//	有効なビットマップハンドルならば、ユーザデータに人マップハンドル設定
			if (GetObject(mii.hbmpItem, sizeof bm, &bm) == sizeof bm) {
				mii.dwItemData = (UX)mii.hbmpItem;
				//	ビットマップはオーナー描画できないので、テキストに変える
				type &= ~MFT_BITMAP;
			}
			//	無効なビットマップハンドルならば、無効なテキストに変える
			else {
				type  &= ~MFT_BITMAP;
				state |=  MFS_DISABLED;
				mii.dwItemData = (UX)L"No BMP";
			}
		}
		//	・セパレータ
		else if (type & MFT_SEPARATOR) {
			//	ユーザデータに NULL 設定
			mii.dwItemData = (UX)0;
		}
		//	・テキスト
		else {
			HAJCSPL	hSpl  = (HAJCSPL)GetProp((HWND)cbp, STRPOOL);
			HMENU	hMTop = GetMenu((HWND)cbp);
			stl = (UI)GetMenuString(hMenu, ix, NULL, 0, MF_BYPOSITION);
			//	ユーザデータ（テキスト）設定
			if (stl != 0 && (pTxt = AjcTAllocW(stl + 2))) {
				//	メニューバー上のメニューテキスト設定
				if (hMenu == hMTop) {
					*pTxt = 0xFEFF;		//	先頭に0xFEFFを設定
					GetMenuString(hMenu, ix, pTxt + 1, stl + 1, MF_BYPOSITION);
					pTxt[stl + 1] = 0;
				}
				//	メニューバー以外のメニューテキスト設定
				else {
					GetMenuString(hMenu, ix, pTxt, stl + 1, MF_BYPOSITION);
					pTxt[stl] = 0;
				}
				if ((mii.dwItemData = (UX)AjcSplRegist(hSpl, pTxt)) == 0) {
					mii.dwItemData = (UX)"";
				}
				AjcTFree(pTxt);
			}
			else mii.dwItemData = (UX)"";
		}
		//	メニュー項目設定
		mii.fMask  = MIIM_FTYPE | MIIM_STATE | MIIM_DATA;
		mii.fType  = (type | MFT_OWNERDRAW);
		mii.fState = state;
		SetMenuItemInfo(hMenu, ix, TRUE, &mii);
	}
	return TRUE;
}
//==============================================================================================================//
//	サブクラス化抑止																							//
//																												//
//	引　数：	hDlg	  - ダイアログウインドハンドル															//
//																												//
//	戻り値：	TRUE ：成功																						//
//				FALSE：失敗																						//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcSuppressSubclassing(HWND hDlg)
{
	BOOL	rc = FALSE;

	if (IsWindow(hDlg) && hBruBkGnd != NULL) {
		if (GetProp(hDlg, SBCSUPP) == NULL) {
			SetProp(hDlg, SBCSUPP, (HANDLE)((UX)FLG_SBCSUPP));
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	メニューをオーナー描画化する																				//
//																												//
//	引　数：	hMenu			- メニューハンドル																//
//				hOwner			- オーナーウインド																//
//																												//
//	戻り値：	TRUE ：成功																						//
//				FALSE：失敗																						//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcMakeMenuOwnerDraw(HMENU hMenu, HWND hOwner)
{
	BOOL	rc = FALSE;

	if (hBruBkGnd != NULL && IsMenu(hMenu) && IsWindow(hOwner) && GetProp(hOwner, SBCDONE) == (HANDLE)FLG_SBCDONE) {
		AjcEnumMenuItems(hMenu, TRUE, (UX)hOwner, cbEnumMenuSetOwnerDraw);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ポップアップメニュー																						//
//																												//
//	引　数：	hMenu		- メニューハンドル																	//
//				uFlag		- オプションフラッグ（TPM_XXXXX）													//
//				x, y		- ポップアップメニューの表示位置													//
//				nReserved	- 未使用（０固定）																	//
//				hwnd		- オーナーウインドハンドル															//
//																												//
//	戻り値：	≠０：成功（TPM_RETURNCMD指定時はメニュー識別ＩＤ）												//
//				＝０：失敗																						//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcTrackPopupMenu(HMENU hMenu, UI uFlags, int x, int y, int nReserved, HWND hwnd, const RECT *prcRect)
{
	BOOL	rc;

	//	カラー設定時は、オーナー描画設定し、ポップアップメニュー実行
	if (rc = AjcDgcMakeMenuOwnerDraw(hMenu, hwnd)) {
		rc = TrackPopupMenu(hMenu, uFlags, x, y, nReserved, hwnd, prcRect);
	}
	//	カラー設定時以外の場合は、単に、ポップアップメニュー実行
	else {
		rc = TrackPopupMenu(hMenu, uFlags, x, y, nReserved, hwnd, prcRect);
	}
	return rc;
}
//==============================================================================================================//
//	ポップアップメニュー（拡張）																				//
//																												//
//	引　数：	hMenu		- メニューハンドル																	//
//				uFlag		- オプションフラッグ（TPM_XXXXX）													//
//				x, y		- ポップアップメニューの表示位置													//
//				nReserved	- 未使用（０固定）																	//
//				hwnd		- オーナーウインドハンドル															//
//																												//
//	戻り値：	≠０：成功（TPM_RETURNCMD指定時はメニュー識別ＩＤ）												//
//				＝０：失敗																						//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcTrackPopupMenuEx(HMENU hMenu, UI uFlags, int x, int y, HWND hWnd, LPTPMPARAMS lptpm)
{
	BOOL	rc;

	//	カラー設定時は、オーナー描画設定し、ポップアップメニュー実行
	if (rc = AjcDgcMakeMenuOwnerDraw(hMenu, hWnd)) {
		rc = TrackPopupMenuEx(hMenu, uFlags, x, y, hWnd, lptpm);
	}
	//	カラー設定時以外の場合は、単に、ポップアップメニュー実行
	else {
		rc = TrackPopupMenuEx(hMenu, uFlags, x, y, hWnd, lptpm);
	}
	return rc;
}
//==============================================================================================================//
//	サブクラス化したボタンのスタイル取得																		//
//																												//
//	引　数：	hwnd	  - ボタンのウインドハンドル															//
//				pStyle	  - スタイル格納バッファ（不要時はNULL）												//
//																												//
//	戻り値：	TRUE ：成功																						//
//				FALSE：失敗（サブクラス化したボタン以外）														//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcGetSbcButtonStyle(HWND hwnd, UIP pStyle)
{
	BOOL	rc = FALSE;
	UI		att;

	if (hBruBkGnd != NULL && IsWindow(hwnd)) {
		//	サブクラス化したオーナー描画ボタン？
		if (att = (UI)((UX)GetProp(hwnd, BTNATT))) {
			if (pStyle != NULL) {
				*pStyle = (att & BTNATT_STYMASK);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	サブクラス化したボタンのスタイル設定（但し、ボタンタイプは設定不可）										//
//																												//
//	引　数：	hwnd	  - ウインドのハンドル																	//
//				style	  - ウインドのスタイル																	//
//																												//
//	戻り値：	TRUE ：成功																						//
//				FALSE：失敗（サブクラス化したボタン以外）														//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcDgcSetSbcButtonStyle(HWND hwnd, UI style)
{
	BOOL	rc = FALSE;
	UI		att;

	if (hBruBkGnd != NULL && IsWindow(hwnd)) {
		//	サブクラス化したオーナー描画ボタン？
		if (att = (UI)((UX)GetProp(hwnd, BTNATT))) {
			//	ボタン属性のスタイル部分設定（但し、ボタンタイプは変更しない）
			att &= (~BTNATT_STYMASK | BS_TYPEMASK | ~BTNSTY_VALID);
			att |= ((style & BTNSTY_VALID) & BTNATT_STYMASK);
			SetProp(hwnd, BTNATT, (HANDLE)((UX)att));
			//	再描画
			InvalidateRect(hwnd, NULL, FALSE);
			//	戻り値=正常
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	サブクラス化済みチェック																					//
//																												//
//	引　数：	hwnd	  - ウインドのハンドル																	//
//																												//
//	戻り値：	TRUE  ：サブクラス済																			//
//				FALSE ：サブクラスされていない																	//
//==============================================================================================================//
AJCEXPORT UI	 WINAPI AjcDgcIsSubclassed(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (hBruBkGnd != NULL && IsWindow(hwnd)) {
		rc = ((UI)((UX)GetProp(hwnd, SBCDONE)) == FLG_SBCDONE);
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	コントロールををサブクラス化																				//
//																												//
//	引　数	：	hwnd	- サブクラス化するウインドのハンドル													//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbSccEnumChildWindows(HWND hwnd, LPARAM lParam)
{
	HWND		hDlg = (HWND)lParam;
	UI			att, sty, typ;
	WC			cname[MAX_PATH];

	if (GetParent(hwnd) == hDlg) {
		GetClassName(hwnd, cname, AJCTSIZE(cname));
		//	●ボタン
		if (wcsicmp(cname, L"Button") == 0) {
			//	スタイル取得
			sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
			//	ボタンタイプ設定
			typ = (sty & BS_TYPEMASK);
			//	プッシュボタン／プッシュボタン風チェックボックスをサブクラス化
			switch (typ) {
				//	プッシュボタンをサブクラス化
				case BS_DEFPUSHBUTTON:
					//	BS_DEFPUSHBUTTONスタイルは 一旦、BS_PUSHBUTTONに変更する
					sty &= ~BS_TYPEMASK;
					sty |=	BS_PUSHBUTTON;
					//	Continue
				case BS_PUSHBUTTON:
					//	ボタン属性初期化（オリジナルのボタンスタイルと「NotZero」インジケータ設定）
					att = (BTNATT_NOTZERO | (sty & BTNATT_STYMASK));
					//	オーナー描画スタイル設定
					sty &= ~BS_TYPEMASK;
					sty |=	BS_OWNERDRAW;
					MAjcSetWindowLong(hwnd, GWL_STYLE, sty);
					//	フォーカス状態設定
					if (hwnd == GetFocus()) {
						att |= BTNATT_FOCUS;
					}
					//	ボタン属性登録
					SetProp(hwnd, BTNATT, (HANDLE)((UX)att));
					//	サブクラス化
					MAjcMmpSetSubclass(SBC_PUSHBTN, hwnd);
					//	再描画
					InvalidateRect(hwnd, NULL, FALSE);
					break;
				//	PUSHLIKEチェックボックス／ラジオボタンをサブクラス化
				case BS_CHECKBOX:
				case BS_AUTOCHECKBOX:
				case BS_3STATE:
				case BS_AUTO3STATE:
				case BS_RADIOBUTTON:
				case BS_AUTORADIOBUTTON:
					//	プッシュボタン風チェックボックス／ラジオボタンをサブクラス化
					if (sty & BS_PUSHLIKE) {
						//	ボタン属性初期化（オリジナルのボタンスタイルと「NotZero」インジケータ設定）
						att = (BTNATT_NOTZERO | (sty & BTNATT_STYMASK));
						//	オーナー描画スタイル設定
						sty &= ~BS_TYPEMASK;
						sty |=	BS_OWNERDRAW;
						MAjcSetWindowLong(hwnd, GWL_STYLE, sty);
						//	チェック状態設定
						switch (AjcGetCtrlChk(hwnd)) {
							case 0:	 att = ((att & ~BTNATT_CHKMASK) | BTNATT_CHKOFF);	break;
							case 1:	 att = ((att & ~BTNATT_CHKMASK) | BTNATT_CHKON );	break;
							default: att = ((att & ~BTNATT_CHKMASK) | BTNATT_3S    );	break;
						}
						//	フォーカス状態設定
						if (hwnd == GetFocus()) {
							att |= BTNATT_FOCUS;
						}
						//	ボタン属性登録
						SetProp(hwnd, BTNATT, (HANDLE)((UX)att));
						//	サブクラス化
						MAjcMmpSetSubclass(SBC_PUSHLIKE, hwnd);
						//	再描画
						InvalidateRect(hwnd, NULL, FALSE);
					}
					//	オートラジオボタンをサブクラス化
					else if (typ == BS_AUTORADIOBUTTON) {
						//	サブクラス化
						MAjcMmpSetSubclass(SBC_AUTORBT, hwnd);
					}
					break;
			}
		}
	}
	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ダイアログのサブクラスプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	HBRUSH	SubSetCtrlColor(HWND hDlg, HDC hdc, HWND hCtrl)
{
	HBRUSH			rc = NULL;
	AJCDGCCTLCOLOR	CtlColor = {0};

	//	自ダイアログ（元プロシージャ）にメッセージ送信
	CtlColor.hBrush    = hBruBkGnd;
	CtlColor.TextColor = Cols.ccTextColor;
	CtlColor.BkColor   = Cols.ccBkGnd;
	SendMessage(hDlg, WMSG_CTLCOLOR_ANY, (WPARAM)&CtlColor, (LPARAM)hCtrl);

	//	テキスト色設定
	SetTextColor(hdc, CtlColor.TextColor);
	//	テキスト背景色設定
	if (CtlColor.BkColor == (COLORREF)-1) {
		SetBkMode	(hdc, TRANSPARENT);
	}
	else {
		int		sty;
		WC		cname[MAX_PATH];
		SetBkMode	(hdc, OPAQUE);
		GetClassName(hCtrl, cname, AJCTSIZE(cname));
		if (wcsicmp(cname, L"Edit") == 0) {
			sty = (int)MAjcGetWindowLong(hCtrl, GWL_STYLE);
			if (sty & (WS_DISABLED | ES_READONLY)) {
				UI	r = GetRValue(Cols.ccBkGnd) * 95 / 100;
				UI	g = GetGValue(Cols.ccBkGnd) * 95 / 100;
				UI	b = GetBValue(Cols.ccBkGnd) * 95 / 100;
				SetBkColor(hdc, RGB(r, g, b));
			}
			else {
				SetBkColor(hdc, CtlColor.BkColor);
			}
		}
		else {
			SetBkColor(hdc, CtlColor.BkColor);
		}
	}

	rc = CtlColor.hBrush;

	return rc;
}
//----- WM_CTLCOLORDLG -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_DIALOG, WM_CTLCOLORDLG		)
{
	return (LRESULT)SubSetCtrlColor(hwnd, (HDC)wParam, (HWND)lParam);
}
//----- WM_CTLCOLORBTN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_DIALOG, WM_CTLCOLORBTN		)
{
	return (LRESULT)SubSetCtrlColor(hwnd, (HDC)wParam, (HWND)lParam);
}
//----- WM_CTLCOLORSTATIC --------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_DIALOG, WM_CTLCOLORSTATIC	)
{
	return (LRESULT)SubSetCtrlColor(hwnd, (HDC)wParam, (HWND)lParam);
}
//----- WM_CTLCOLOREDIT ----------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_DIALOG, WM_CTLCOLOREDIT		)
{
	return (LRESULT)SubSetCtrlColor(hwnd, (HDC)wParam, (HWND)lParam);
}
//----- WM_CTLCOLORLISTBOX -------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_DIALOG, WM_CTLCOLORLISTBOX	)
{
	return (LRESULT)SubSetCtrlColor(hwnd, (HDC)wParam, (HWND)lParam);
}
//----- WM_CTLCOLORSCROLLBAR -----------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_DIALOG, WM_CTLCOLORSCROLLBAR)
{
	return (LRESULT)SubSetCtrlColor(hwnd, (HDC)wParam, (HWND)lParam);
}
//----- WM_INITMENU --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_DIALOG, WM_INITMENU			)
{
	LRESULT	rc;

	//	オリジナルのプロシージャ実行
	rc = MAjcMmpCallOrgWndProc(SBC_DIALOG);

	//	メニューアイテム設定（オーナー描画化）
	AjcDgcMakeMenuOwnerDraw((HMENU)wParam, hwnd);

	return rc;
}
//----- WM_MEASUREITEM -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_DIALOG, WM_MEASUREITEM		)
{
	LRESULT		rc;
	HDC			hdc = GetDC(hwnd);
	LPMEASUREITEMSTRUCT pMis  = (LPMEASUREITEMSTRUCT)lParam;

	if (pMis->CtlType == ODT_MENU) {
		//	●セパレータ
		if (pMis->itemData == 0) {
			pMis->itemWidth  = GetSystemMetrics(SM_CXMENUCHECK);
			pMis->itemHeight = 5;
		}
		else {
			BITMAP	bm;
			SIZE	sz;
			UI		len;
			//	●ビットマップ
			if ((len = GetObject((HANDLE)pMis->itemData, sizeof bm, &bm)) == sizeof bm) {
				//
				//	※ビットマップの場合「WM_MEASUREITEM」は発行されない！（ここは、実行されない）
				//	　InsertMenu()の時点で、ビットマップサイズで把握されている？
				//
				pMis->itemWidth  = GetSystemMetrics(SM_CXMENUCHECK) + MnuLMrg + bm.bmWidth + 20;
				pMis->itemHeight = MnuUMrg + bm.bmHeight + MnuDMrg;
			}
			//	●テキスト
			else {
				HDC		hdc 	 = GetDC(hwnd);
				HFONT	hFontSv  = NULL;
				WCP		pTxt	 = (WCP)pMis->itemData;
				WCP		pBuf	 = NULL;
				BOOL	fMenuBar = FALSE;
				int		len;
				//	メニューバー上のメニュー項目を示すフラグ設定
				if ((UW)*pTxt == 0xFEFF) {
					fMenuBar = TRUE;
					pTxt++;
				}
				//	フォント設定
				if (hMnuFont != NULL) hFontSv = (HFONT)SelectObject(hdc, hMnuFont);
				else				  hFontSv = (HFONT)SelectObject(hdc, hSysMnuFont);
				//	＆を処理したテキスト生成（ウインドメニュー時はＴＡＢ削除）
				len = (int)wcslen(pTxt);
				if (pBuf = AmpCreateExcText(pTxt, len, FALSE, fMenuBar)) {
					HAJCTXO	hTxo = NULL;
					//	ＴＸＯインスタンス生成
					if (hTxo = AjcTxoCreate(hdc, 0, 0, 0)) {	// x=0, y=0, 行間スペース=0
						//	メニューバー上のメニュー時は、テキスト整列 = 中央揃え
						if (fMenuBar) {
							AjcTxoSetAlign(hTxo, AJCTXOALIGN_CENTER);
						}
						//	メニューバー上以外の場合は、テキスト整列 = タブ以降右詰め
						else {
							AjcTxoSetAlign(hTxo, AJCTXOALIGN_TAB_RIGHT);
						}
						//	文字列サイズ取得
						AjcTxoGetExtent	(hTxo, pBuf, &sz);
						//	メニューバー上のメニュー項目
						if (fMenuBar) {
							pMis->itemWidth  = sz.cx;
							pMis->itemHeight = MnuUMrg + sz.cy + MnuDMrg;
						}
						//	メニューバー以外のメニュー項目
						else {
							//	ＴＡＢを含む場合のマージン追加
							if (wcsstr(pBuf, L"\t")) {
								sz.cx += 10;
							}
							//	マージンサイズ追加
							pMis->itemWidth  = GetSystemMetrics(SM_CXMENUCHECK) + MnuLMrg + sz.cx;
							pMis->itemHeight = MnuUMrg + sz.cy + MnuDMrg;
						}
						//	ＴＸＯインスタンス破棄
						AjcTxoDelete(hTxo, TRUE);
					}
					//	＆を処理したテキスト解放
					AjcTFree(pBuf);
				}
				//	フォント回復
				if (hFontSv != NULL) {
					SelectObject(hdc, hFontSv);
				}
				//	ＤＣ解放
				ReleaseDC(hwnd, hdc); 
			}
		}
		rc = TRUE;
	}
	else {
		rc = MAjcMmpCallOrgWndProc(SBC_DIALOG);
	}
	return rc;
}
//----- WM_DRAWITEM --------------------------------------------------------------------------------------------//

#define		MNUCOLOR(NAME)	MnuColor(&Mncs.NAME, pDis->itemState)

static	COLORREF	MnuColor(PCAJCSTACOLORS pSc, UI state)
{
	COLORREF	rc;
	if ((state & (ODS_SELECTED | ODS_DISABLED)) == (ODS_SELECTED | ODS_DISABLED)) rc = pSc->both;
	else if (state & ODS_SELECTED) rc = pSc->sel;
	else if (state & ODS_DISABLED) rc = pSc->dis;
	else						   rc = pSc->std;
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJC_WNDPROC(SBC_DIALOG, WM_DRAWITEM			)
{
	LRESULT			 rc    = TRUE;
	LPDRAWITEMSTRUCT pDis  = (LPDRAWITEMSTRUCT)lParam;
	HDC				 hdc   = pDis->hDC;
	HBRUSH			 hBru;

	switch (pDis->CtlType) {
		case ODT_MENU:								//	●メニュー
		{
			HMENU		hWndMenu = GetMenu(hwnd);
			HFONT		hFontSv  = NULL;
			//	フォント割り当て
			if (hMnuFont != NULL) hFontSv = (HFONT)SelectObject(hdc, hMnuFont);
			else				  hFontSv = (HFONT)SelectObject(hdc, hSysMnuFont);
			//	背景描画
			hBru = CreateSolidBrush(MNUCOLOR(ccBkColor));
			FillRect(hdc, &pDis->rcItem, hBru);
			DeleteObject(hBru);

			//	●セパレータ
			if (pDis->itemData == 0) {
				HPEN	hPen;
				int		x1, x2, y;
				//	背景描画
				FillRect(hdc, &pDis->rcItem, hBruBkGnd);
				//	横線描画
				hPen = (HPEN)SelectObject(hdc, CreatePen(PS_SOLID, 1, Mncs.ccSepLine));
				x1 = pDis->rcItem.left + GetSystemMetrics(SM_CXMENUCHECK) + MnuLMrg;
				x2 = pDis->rcItem.right;
				y  = (pDis->rcItem.top + pDis->rcItem.bottom) / 2;
				MoveToEx(hdc, x1, y, NULL);
				LineTo	(hdc, x2, y);
				SelectObject(hdc, hPen);
			}
			else {
				BITMAP		bm;
				UI			len;
				HPEN		hPen;
				HBRUSH		hBru;
				int			MrkUM = 0;		//	チェックマーク／ラジオボタン描画時の上マージン
				int			MrkDM = 0;		//			〃							下マージン

				//	●ビットマップ
				if ((len = GetObject((HANDLE)pDis->itemData, sizeof bm, &bm)) == sizeof bm) {
					int			x, y;
					TEXTMETRIC	tm;
					//	チェックマーク／ラジオボタン描画時の上下マージン設定
					GetTextMetrics(hdc, &tm);
					if (bm.bmHeight > tm.tmHeight) {
						MrkUM = (bm.bmHeight - tm.tmHeight) / 2;
						MrkDM = (bm.bmHeight - tm.tmHeight) / 2;
					}
					else {
						MrkUM = 0;
						MrkDM = 0;
					}
					//	ビットマップ描画（ビットマップは WM_MEASUREITEM が実行されない為 MnuUMrg, MnuDMrg は無効）
					x = pDis->rcItem.left;
					y = pDis->rcItem.top; 
					x += (GetSystemMetrics(SM_CXMENUCHECK) + MnuLMrg);
					if (pDis->itemState & ODS_DISABLED) {
						COLORREF	bmc = MNUCOLOR(ccBitmap);
						DrawBitmapGray (hdc, x, y, bm.bmWidth, bm.bmHeight, (HBITMAP)pDis->itemData, (COLORREF)((UX)GetProp(hwnd, BMPTRANS)), bmc);
					}
					else {
						DrawBitmapNormal(hdc, x, y, bm.bmWidth, bm.bmHeight, (HBITMAP)pDis->itemData, (COLORREF)((UX)GetProp(hwnd, BMPTRANS)));
					}
				}
				//	●テキスト
				else {
					int			x, y, cx;
					WCP			pTxt	 = (WCP)pDis->itemData;
					WCP			pBuf 	 = NULL;
					BOOL		fMenuBar = FALSE;
					//	メニューバー上のメニュー項目を示すフラグ設定
					if ((UW)*pTxt == 0xFEFF) {
						fMenuBar = TRUE;
						pTxt++;
					}
					//	チェックマーク／ラジオボタン描画時の上下マージン設定
					MrkUM = MnuUMrg;
					MrkDM = MnuDMrg;

					//	＆を処理したテキスト生成
					len = (int)wcslen(pTxt);
					if (pBuf = AmpCreateExcText(pTxt, len, FALSE, fMenuBar)) {	//	ウインドメニュー時はＴＡＢ削除
						HAJCTXO	hTxo = NULL;
						//	ＴＸＯインスタンス生成
						if (hTxo = AjcTxoCreate(hdc, pDis->rcItem.left, pDis->rcItem.top, 0)) {	// x,y = テキスト描画域左上, 行間スペース=0
							//	ＤＣサイズ設定
							AjcTxoSetDcBmpSize(hTxo, pDis->rcItem.right, pDis->rcItem.bottom);
							//	タブステップ設定（システムがタブサイズ分の余白設定する為、最小値とする（０は設定不可））
							AjcTxoSetTabStep(hTxo, -1);
							//	メニューバー上のメニュー時は、テキスト整列 = 中央揃え
							if (fMenuBar) {
								AjcTxoSetAlign(hTxo, AJCTXOALIGN_CENTER);
							}
							//	メニューバー上以外の場合は、テキスト整列 = タブ以降右詰め
							else {
								AjcTxoSetAlign(hTxo, AJCTXOALIGN_TAB_RIGHT);
							}
							//	デフォルトテキスト色設定
							AjcTxoSetDefTextColor(hTxo, MNUCOLOR(ccTextColor));
							//	文字背景色モード＝透明
							AjcTxoSetBkMode(hTxo, AJCTXO_TRANSPARENT);
							//	表示位置設定（メニューバー上のメニュー項目）
							if (fMenuBar) {
								x  = 0;
								y  = AJCTXO_CENTER;
								cx = (pDis->rcItem.right - pDis->rcItem.left);
								//	テキスト描画
								AjcTxoTextOutExEx(hTxo, x, y, cx, pBuf);
							}
							//	表示位置設定（メニューバー以外のメニュー項目）
							else {
								x  = (GetSystemMetrics(SM_CXMENUCHECK) + MnuLMrg);
								y  = AJCTXO_CENTER;
								cx = (pDis->rcItem.right - pDis->rcItem.left) - (GetSystemMetrics(SM_CXMENUCHECK) + MnuLMrg );
								//	テキスト描画
								AjcTxoTextOutExEx(hTxo, x, y, cx - 30, pBuf);
							}
							//	ＴＸＯインスタンス破棄
							AjcTxoDelete(hTxo, TRUE);
						}
						//	＆を処理したテキスト解放
						AjcTFree(pBuf);
					}
				}
				//	チェックボックス／ラジオボタン表示
				if (pDis->itemState & ODS_CHECKED) {
					RECT			rcChk;
					MENUITEMINFO	miif;
					HBRUSH			hBru;
					HPEN			hPen;
					int				x, y;
					//	チェックマークの背景描画
					rcChk.left	 = pDis->rcItem.left;
					rcChk.top	 = pDis->rcItem.top + MrkUM;
					rcChk.right  = pDis->rcItem.left + GetSystemMetrics(SM_CXMENUCHECK);
					rcChk.bottom = pDis->rcItem.bottom - MrkDM;
					hBru = CreateSolidBrush(MNUCOLOR(ccChkBack));
					FillRect(hdc, &rcChk, hBru);
					DeleteObject(hBru);
					//	マーク種別取得
					miif.cbSize = sizeof(MENUITEMINFO);
					miif.fMask	= MIIM_FTYPE;
					GetMenuItemInfo((HMENU)pDis->hwndItem, pDis->itemID, FALSE, &miif);
					//	ラジオボタン表示
					if (miif.fType & MFT_RADIOCHECK) {
						hBru = (HBRUSH)SelectObject(hdc, CreateSolidBrush(MNUCOLOR(ccChkMark)));
						hPen = (HPEN  )SelectObject(hdc, CreatePen		 (PS_SOLID, 1, MNUCOLOR(ccChkMark)));
						x = pDis->rcItem.left + (GetSystemMetrics(SM_CXMENUCHECK) - 6) / 2;
						y = pDis->rcItem.top  + MrkUM + (pDis->rcItem.bottom - pDis->rcItem.top - (MrkUM + MrkDM) - 6) / 2 ;
						Ellipse(hdc, x, y, x + 6, y + 6);
						DeleteObject(SelectObject(hdc, hBru));
						DeleteObject(SelectObject(hdc, hPen));
					}
					//	チェックマーク表示
					else {
						hPen = (HPEN  )SelectObject(hdc, CreatePen(PS_SOLID, 2, MNUCOLOR(ccChkMark)));
						x = pDis->rcItem.left + (GetSystemMetrics(SM_CXMENUCHECK)) / 2;
						y = pDis->rcItem.top  +  MrkUM + (pDis->rcItem.bottom - pDis->rcItem.top - (MrkUM + MrkDM)) / 2;
						MoveToEx(hdc, x - 4, y, NULL);
						LineTo	(hdc, x    , y + 4);
						LineTo	(hdc, x + 5, y - 4);
						DeleteObject(SelectObject(hdc, hPen));
					}

				}
				//	ウインドメニューならば、下線描画
				if (hWndMenu == (HMENU)pDis->hwndItem) {
					if ((int)Mncs.ccUnderLine != -1) {
						hPen = (HPEN)SelectObject(hdc, CreatePen(PS_SOLID, 1, Mncs.ccUnderLine));
						MoveToEx(hdc, pDis->rcItem.left  + 3, pDis->rcItem.bottom - 1, NULL);
						LineTo	(hdc, pDis->rcItem.right - 3, pDis->rcItem.bottom - 1);
						SelectObject(hdc, hPen);
					}
				}
				//	ウインドメニュー以外
				else {
					MENUITEMINFO	miif;
					miif.cbSize = sizeof(MENUITEMINFO);
					miif.fMask	= (MIIM_SUBMENU);
					GetMenuItemInfo((HMENU)pDis->hwndItem, pDis->itemID, FALSE, &miif);
					//	サブメニュー有りならば、サブメニューへの三角描画
					if (miif.hSubMenu != NULL) {
						struct {POINT p1, p2, p3;} pt;
						int		yc = (pDis->rcItem.top + pDis->rcItem.bottom) / 2;
						pt.p1.x = pDis->rcItem.right - 12;	pt.p1.y = yc - 3;
						pt.p2.x = pDis->rcItem.right -	9;	pt.p2.y = yc;
						pt.p3.x = pDis->rcItem.right - 12;	pt.p3.y = yc + 3;
						hPen = (HPEN  )SelectObject(hdc, CreatePen(PS_SOLID, 1, MNUCOLOR(ccTriangle)));
						hBru = (HBRUSH)SelectObject(hdc, CreateSolidBrush(MNUCOLOR(ccTriangle)));
						Polygon(hdc, &pt.p1, 3);
						SelectObject(hdc, hPen);
						SelectObject(hdc, hBru);
					}
				}
			}
			//	サブメニュー有りの場合、勝手に描画されるサブメニューへの矢印描画を抑止
			ExcludeClipRect(hdc, pDis->rcItem.left, pDis->rcItem.top, pDis->rcItem.right, pDis->rcItem.bottom);
			//	フォント割り当て解除
			if (hFontSv != NULL) {
				SelectObject(hdc, hFontSv);
			}
			rc = TRUE;
			break;
		}
		case ODT_LISTBOX:							//	●リストボックス
		case ODT_COMBOBOX:							//	●コンボボックス
		{
			int		x, y, cx;
			UI		len;
			WCP		pBuf = NULL;
			HAJCTXO	hTxo = NULL;
			HBRUSH	hBru = NULL;
			AJCDGCCTLCOLOR	ctlc = {0};
			AJCDGCDRAWITEM	dis  = {0};

			//	ブラシハンドル生成
			hBru = CreateSolidBrush(MNUCOLOR(ccBkColor));
			//	描画色情報設定
			ctlc.hBrush    = hBru;
			ctlc.TextColor = MNUCOLOR(ccTextColor);			//	テキスト描画色
			ctlc.BkColor   = MNUCOLOR(ccBkColor);			//	テキスト背景色（-1:透明）
			//	描画情報設定
			dis.kind	= pDis->CtlType;					//	コントロール種別(ODT_XXXXX)
			dis.id		= pDis->CtlID;						//	コントロールのＩＤ(IDC_XXXXX)
			dis.ix		= pDis->itemID;						//	リストボックス／コンボボックス項目のインデクス（０～）
			dis.act		= pDis->itemAction;					//	必要な描画アクション(ODA_XXXXX)
			dis.state	= pDis->itemState;					//	現在の描画アクションが実行された後のアイテムの表示状態(ODS_XXXXX)
			dis.hWnd	= pDis->hwndItem;					//	リストボックス／コンボボックスのウインドハンドル
			dis.hDC		= pDis->hDC;						//	デバイスコンテキストハンドル
			memcpy(&dis.rect, &pDis->rcItem, sizeof(RECT));	//	描画するコントロールの境界を定義する四角形
			dis.data	= pDis->itemData;					//	リストボックス／コンボボックス項目に関連つけられたデータ
			dis.hLbx	= (HWND)GetProp(dis.hWnd, L"_AJCPROP_LBX_HANDLE_");			//	拡張リストボックスハンドル
			if (dis.hLbx != NULL) dis.idLbx = (UI)MAjcGetWindowLong(dis.hLbx, GWL_ID);	//	拡張リストボックスＩＤ
			dis.fDrawn	= FALSE;							//	描画済フラグ（AJCM_CTLDRAW_LSIメッセージ時のみ有効）
			//	リスト項目描画メッセージ送信
			SendMessage(hwnd, WMSG_CTLDRAW_LSI, (WPARAM)&ctlc, (LPARAM)&dis);
			if (!dis.fDrawn) {		//	未描画？
				//	描画色問い合わせメッセージ送信
				SendMessage(hwnd, WMSG_CTLCOLOR_LSI, (WPARAM)&ctlc, (LPARAM)&dis);
				//	背景描画
				FillRect(hdc, &pDis->rcItem, ctlc.hBrush);

				if (hTxo = AjcTxoCreate(hdc, pDis->rcItem.left, pDis->rcItem.top, 0)) {	// x,y = テキスト描画域左上, 行間スペース=0
					//	ＤＣサイズ設定
					AjcTxoSetDcBmpSize(hTxo, pDis->rcItem.right, pDis->rcItem.bottom);
					//	テキスト整列 = 左揃え
					AjcTxoSetAlign(hTxo, AJCTXOALIGN_LEFT);
					//	テキスト色設定
					AjcTxoSetDefTextColor(hTxo, ctlc.TextColor);
					//	文字背景色設定
					if (ctlc.BkColor == (COLORREF)-1) {
						AjcTxoSetBkMode(hTxo, AJCTXO_TRANSPARENT);	//	透明
					}
					else {
						AjcTxoSetBkMode(hTxo, AJCTXO_OPAQUE);		//	非透明
						AjcTxoSetDefBkColor(hTxo, ctlc.BkColor);	//	背景色
					}
					//	表示位置設定
					x  = 3;
					y  = AJCTXO_CENTER;
					cx = (pDis->rcItem.right - pDis->rcItem.left);
					//	テキスト描画
					if (pDis->itemID != CB_ERR) {
						if (pDis->CtlType == ODT_LISTBOX) len = (UI)SendMessage(pDis->hwndItem, LB_GETTEXTLEN  , pDis->itemID, 0);
						else							  len = (UI)SendMessage(pDis->hwndItem, CB_GETLBTEXTLEN, pDis->itemID, 0);
						if (pBuf = AjcTAllocW(len + 1)) {
							if (pDis->CtlType == ODT_LISTBOX) SendMessage(pDis->hwndItem, LB_GETTEXT  , pDis->itemID, (LPARAM)pBuf);
							else							  SendMessage(pDis->hwndItem, CB_GETLBTEXT, pDis->itemID, (LPARAM)pBuf);
							AjcTxoTextOutExEx(hTxo, x, y, cx, pBuf);
							AjcTFree(pBuf);
						}
					}
					//	ＴＸＯインスタンス破棄
					AjcTxoDelete(hTxo, TRUE);
					rc = TRUE;
				}
			}
			//	ブラシ消去
			if (hBru != NULL) DeleteObject(hBru);
			break;
		}
		default:									//	●その他
			rc = MAjcMmpCallOrgWndProc(SBC_DIALOG);
			break;
	}
	return rc;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_DIALOG, WM_DESTROY			)
{
	HAJCSPL	hSpl;
	//	文字列プール破棄
	if ((hSpl = (HAJCSPL)GetProp(hwnd, STRPOOL)) != NULL) {
		AjcSplDelete(hSpl);
	}
	//	ダイアログ関連付け情報破棄
	RemoveProp(hwnd, SBCDONE);
	RemoveProp(hwnd, SBCSUPP);
	RemoveProp(hwnd, BMPTRANS);
	RemoveProp(hwnd, STRPOOL);
	return MAjcMmpCallOrgWndProc(SBC_DIALOG);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_DIALOG)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_CTLCOLORDLG		)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_CTLCOLORBTN		)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_CTLCOLORSTATIC	)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_CTLCOLOREDIT		)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_CTLCOLORLISTBOX	)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_CTLCOLORSCROLLBAR	)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_INITMENU			)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_MEASUREITEM		)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_DRAWITEM			)
	AJC_WNDMAP_MSG(SBC_DIALOG, WM_DESTROY			)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	オートラジオボタンのサブクラスプロシージャ（BS_PUSHLIKE以外）												//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_LBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_AUTORBT, WM_LBUTTONDOWN	)
{
	//	オリジナルプロシージャ実行
	return MAjcMmpCallOrgWndProc(SBC_AUTORBT);
}
//----- WM_LBUTTONUP -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_AUTORBT, WM_LBUTTONUP	)
{
	//	他のラジオボタンのチェック解除（通常のラジオボタンはシステムが行うので、オーナー描画化したラジオボタンのみ）
	ResetAllRbtInGroup(hwnd, TRUE);

	//	オリジナルプロシージャ実行
	return MAjcMmpCallOrgWndProc(SBC_AUTORBT);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_AUTORBT)
	AJC_WNDMAP_MSG(SBC_AUTORBT, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(SBC_AUTORBT, WM_LBUTTONUP	)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	プッシュボタンのサブクラスプロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_SETTEXT ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_SETTEXT		)
{
	LRESULT	rc;

	//	オリジナルプロシージャ実行
	rc = MAjcMmpCallOrgWndProc(SBC_PUSHBTN);

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return rc;
}
//----- WM_ENABLE ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_ENABLE		)
{
	LRESULT	rc;

	//	オリジナルプロシージャ実行
	rc = MAjcMmpCallOrgWndProc(SBC_PUSHBTN);

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return rc;
}
//----- WM_LBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_LBUTTONDOWN	)
{
	LRESULT	rc = 0;
	UI	att;

	//	ボタン押下状態登録
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	SetProp(hwnd, BTNATT, (HANDLE)((UX)(att | BTNATT_PUSH)));
	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	//	ツールチップ非表示（LB_BUTTONDOWNはインターセプトされ、拡張ツールチップへ通知されない為、ここで非表示する）
	if (AjcTipTextGetEnableState(hwnd)) {
		AjcTipTextEnable(hwnd, FALSE);
		AjcTipTextEnable(hwnd, TRUE);
	}

	return 0;		//	インターセプト
}
//----- WM_LBUTTONUP -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_LBUTTONUP	)
{
	UI	att;

	//	ボタン離し状態登録
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	SetProp(hwnd, BTNATT, (HANDLE)((UX)(att & ~BTNATT_PUSH)));

	//	自ボタンをフォーカス
	SetFocus(hwnd);

	//	クリック抑止ならば、クリック通知抑止フラグクリアー
	if (att & BTNATT_SKIPCLK) {
		SetProp(hwnd, BTNATT, (HANDLE)((UX)(att & ~BTNATT_SKIPCLK)));
	}
	//	親ウインドへクリック通知
	else {
		UI	id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
		SendMessage(GetParent(hwnd), WM_COMMAND, MAKELONG(id, BN_CLICKED), (LPARAM)hwnd);
	}

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return 0;		//	インターセプト
}
//----- WM_LBUTTONDBLCLK ---------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_LBUTTONDBLCLK	)
{
	UI	att, id;

	att = (UI)((UX)GetProp(hwnd, BTNATT));
	if (att & BS_NOTIFY) {
		//	親ウインドへダブルクリック通知
		id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
		SendMessage(GetParent(hwnd), WM_COMMAND, MAKELONG(id, BN_DBLCLK), (LPARAM)hwnd);
		//	次のクリックを抑止
		SetProp(hwnd, BTNATT, (HANDLE)((UX)(att | BTNATT_SKIPCLK)));
	}
	return 0;		//	インターセプト
}
//----- WM_KEYDOWN ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_KEYDOWN		)
{
	//	空白キーならば左ボタン押下
	if (wParam == VK_SPACE) {
		SendMessage(hwnd, WM_LBUTTONDOWN, MK_LBUTTON, 0);
	}
	return 0;		//	インターセプト
}
//----- WM_KEYUP -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_KEYUP		)
{
	//	空白キーならば左ボタン離し
	if (wParam == VK_SPACE) {
		SendMessage(hwnd, WM_LBUTTONUP, MK_LBUTTON, 0);
	}
	return 0;		//	インターセプト
}
//----- WM_SETFOCUS --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_SETFOCUS	)
{
	UI	att;

	//	ボタンフォーカス状態登録
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	SetProp(hwnd, BTNATT, (HANDLE)((UX)(att | BTNATT_FOCUS)));
	//	フォーカス通知
	if (att & BS_NOTIFY) {
		UI	id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
		SendMessage(GetParent(hwnd), WM_COMMAND, MAKELONG(id, BN_SETFOCUS), (LPARAM)hwnd);
	}
	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return 0;		//	インターセプト
}
//----- WM_KILLFOCUS -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_KILLFOCUS	)
{
	UI	att, id;

	//	ボタンフォーカス状態登録
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	SetProp(hwnd, BTNATT, (HANDLE)((UX)(att & ~BTNATT_FOCUS)));
	//	フォーカス通知
	if (att & BS_NOTIFY) {
		id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
		SendMessage(GetParent(hwnd), WM_COMMAND, MAKELONG(id, BN_KILLFOCUS), (LPARAM)hwnd);
	}
	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return 0;		//	インターセプト
}
//----- WM_ERASEBKGND ------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_ERASEBKGND	)
{
	return 1;		//	インターセプト
}
//----- WM_PAINT -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_PAINT		)
{
	PAINTSTRUCT	ps;
	HDC			hdc, btdc;
	RECT		r;
	int			width, height;
	HBITMAP		hBmpSv , hBmp  = NULL;
	HFONT		hFontSv, hFont = NULL;

	//	ＤＣ設定
	hdc	   = BeginPaint(hwnd, &ps);

	do {
		//	ボタンウインドサイズ設定
		GetClientRect(hwnd, &r);
		width  = r.right - r.left;
		height = r.bottom - r.top;
		//	メモリＤＣ，ビットマップ作成
		if ((btdc	= CreateCompatibleDC	(hdc			   )) == NULL) break;
		if ((hBmp	= CreateCompatibleBitmap(hdc, width, height)) == NULL) break;
		//	フォント，ビットマップ割り当て
		hFont	= (HFONT  )SendMessage(hwnd, WM_GETFONT, 0, 0);
		hFontSv = (HFONT  )SelectObject(btdc, hFont);
		hBmpSv	= (HBITMAP)SelectObject(btdc, hBmp);
		//	ボタン描画
		DrawButton(hwnd, btdc, &r, width, height);
		//	ボタンウインドへ描画
		BitBlt(hdc, 0, 0, width, height, btdc, 0, 0, SRCCOPY);
		//	フォント，ビットマップ割り当て解除
		SelectObject(btdc, hFontSv);
		SelectObject(btdc, hBmpSv);
	} while(0);

	//	リソース破棄
	if (btdc != NULL) DeleteDC	  (btdc );
	if (hBmp != NULL) DeleteObject(hBmp);

	//	描画終了
	EndPaint(hwnd, &ps);

	return 0;		//	インターセプト
}
//----- BM_GETSTATE --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, BM_GETSTATE	)
{
	LRESULT rc = 0;
	UI		att;

	//	ボタン状態取得
	att = (UI)((UX)GetProp(hwnd, BTNATT));

	//	押下状態／フォーカス状態設定
	if (att & BTNATT_PUSH ) rc |= BST_PUSHED;
	if (att & BTNATT_FOCUS) rc |= BST_FOCUS;

	return rc;	//	インターセプト（ボタン状態を返す）

}
//----- BM_SETSTATE --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, BM_SETSTATE	)
{
	LRESULT rc = 0;
	UI		att;

	//	ボタン押下状態設定（ハイライト状態設定）
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	if (wParam == 0) att &= ~BTNATT_PUSH;
	else			 att |=  BTNATT_PUSH;
	SetProp(hwnd, BTNATT, (HANDLE)((UX)att));

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return 0;	//	インターセプト

}
//----- BM_SETSTYLE --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, BM_SETSTYLE	)
{
	UI	att;

	att = (UI)((UX)GetProp(hwnd, BTNATT));
	att &= (~BTNATT_STYMASK | BS_TYPEMASK);
	att |= (UI)(wParam & ~BS_TYPEMASK);
	SetProp(hwnd, BTNATT, (HANDLE)((UX)att));

	//	再描画
	if (LOWORD(lParam)) {
		RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);
	}
	return 0;	//	インターセプト
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHBTN, WM_DESTROY		)
{
	//	インスタンスワーク破棄
	RemoveProp(hwnd, BTNATT);
	//	オリジナルプロシージャ実行
	return MAjcMmpCallOrgWndProc(SBC_PUSHBTN);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_PUSHBTN)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_SETTEXT		)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_ENABLE		)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_LBUTTONUP	)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_LBUTTONDBLCLK)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_KEYDOWN		)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_KEYUP		)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_SETFOCUS		)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_KILLFOCUS	)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_ERASEBKGND	)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_PAINT		)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, BM_GETSTATE		)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, BM_SETSTATE		)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, BM_SETSTYLE		)
	AJC_WNDMAP_MSG(SBC_PUSHBTN, WM_DESTROY		)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	プッシュボタン風チェックボックスのサブクラスプロシージャ													//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_SETTEXT ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_SETTEXT	)
{
	LRESULT	rc;
	
	//	オリジナルプロシージャ実行
	rc = MAjcMmpCallOrgWndProc(SBC_PUSHBTN);

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return rc;
}
//----- WM_ENABLE ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_ENABLE		)
{
	LRESULT	rc;
	
	//	オリジナルプロシージャ実行
	rc = MAjcMmpCallOrgWndProc(SBC_PUSHBTN);

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return rc;
}
//----- WM_LBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_LBUTTONDOWN)
{
	UI		att;

	//	ボタン押下状態登録
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	SetProp(hwnd, BTNATT, (HANDLE)((UX)(att | BTNATT_PUSH)));

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	//	ツールチップ非表示（LB_BUTTONDOWNはインターセプトされ、拡張ツールチップへ通知されない為、ここで非表示する）
	if (AjcTipTextGetEnableState(hwnd)) {
		AjcTipTextEnable(hwnd, FALSE);
		AjcTipTextEnable(hwnd, TRUE);
	}
	return 0;		//	インターセプト
}
//----- WM_LBUTTONUP -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_LBUTTONUP	)
{
	UI	att;
	int	id;

	//	ボタン離し状態登録
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	SetProp(hwnd, BTNATT, (HANDLE)((UX)(att & ~BTNATT_PUSH)));

	//	クリック抑止ならば、クリック通知抑止フラグクリアー
	if (att & BTNATT_SKIPCLK) {
		SetProp(hwnd, BTNATT, (HANDLE)((UX)(att & ~BTNATT_SKIPCLK)));
	}
	//	クリック抑止以外・・
	else {
		//	チェック状態登録
		att = (UI)((UX)GetProp(hwnd, BTNATT));
		switch (att & BS_TYPEMASK) {
			//	●自動３ステート・チェックボックス
			case BS_AUTO3STATE:
				switch (att & BTNATT_CHKMASK) {
					case BTNATT_CHKOFF:	att = ((att & ~BTNATT_CHKMASK) | BTNATT_CHKON );	break;
					case BTNATT_CHKON:	att = ((att & ~BTNATT_CHKMASK) | BTNATT_3S	  );	break;
					default:			att = ((att & ~BTNATT_CHKMASK) | BTNATT_CHKOFF);	break;
				}
				break;
			//	●自動チェックボックス
			case BS_AUTOCHECKBOX:
				if ((att & BTNATT_CHKMASK) == BTNATT_CHKOFF) att = ((att & ~BTNATT_CHKMASK) | BTNATT_CHKON );
				else										 att = ((att & ~BTNATT_CHKMASK) | BTNATT_CHKOFF);
				break;
			//	●自動ラジオボタン
			case BS_AUTORADIOBUTTON:
				//	ラジオボタンにチェック付与
				att = ((att & ~BTNATT_CHKMASK) | BTNATT_CHKON );
				//	他のラジオボタンのチェック解除（オーナー描画化したラジオボタンを含め、全てのラジオボタン）
				ResetAllRbtInGroup(hwnd, FALSE);
				break;
		}
		//	チェック状態登録
		SetProp(hwnd, BTNATT, (HANDLE)((UX)(att & ~BTNATT_PUSH)));

		//	フォーカス設定
		SetFocus(hwnd);

		//	親ウインドへクリック通知
		id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
		SendMessage(GetParent(hwnd), WM_COMMAND, MAKELONG(id, BN_CLICKED), (LPARAM)hwnd);
	}

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return 0;		//	インターセプト
}
//----- WM_LBUTTONDBLCLK ---------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_LBUTTONDBLCLK	)
{
	UI	att, id;

	att = (UI)((UX)GetProp(hwnd, BTNATT));
	if ((att & BS_NOTIFY) || (att & BS_TYPEMASK) == BS_RADIOBUTTON){
		//	親ウインドへダブルクリック通知
		id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
		SendMessage(GetParent(hwnd), WM_COMMAND, MAKELONG(id, BN_DBLCLK), (LPARAM)hwnd);
		//	次のクリックを抑止
		SetProp(hwnd, BTNATT, (HANDLE)((UX)(att | BTNATT_SKIPCLK)));
	}

	return 0;		//	インターセプト
}
//----- WM_KEYDOWN ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_KEYDOWN		)
{
	//	空白キーならば左ボタン押下
	if (wParam == VK_SPACE) {
		SendMessage(hwnd, WM_LBUTTONDOWN, MK_LBUTTON, 0);
	}
	return 0;		//	インターセプト
}
//----- WM_KEYUP -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_KEYUP		)
{
	//	空白キーならば左ボタン離し
	if (wParam == VK_SPACE) {
		SendMessage(hwnd, WM_LBUTTONUP, MK_LBUTTON, 0);
	}
	return 0;		//	インターセプト
}
//----- WM_SETFOCUS --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_SETFOCUS	)
{
	UI	att, id;

	//	ボタンフォーカス状態登録
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	SetProp(hwnd, BTNATT, (HANDLE)((UX)(att | BTNATT_FOCUS)));
	//	フォーカス通知
	if (att & BS_NOTIFY) {
		id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
		SendMessage(GetParent(hwnd), WM_COMMAND, MAKELONG(id, BN_SETFOCUS), (LPARAM)hwnd);
	}
	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return 0;		//	インターセプト
}
//----- WM_KILLFOCUS -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_KILLFOCUS	)
{
	UI	att, id;

	//	ボタンフォーカス状態登録
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	SetProp(hwnd, BTNATT, (HANDLE)((UX)(att & ~BTNATT_FOCUS)));
	//	フォーカス通知
	if (att & BS_NOTIFY) {
		id = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
		SendMessage(GetParent(hwnd), WM_COMMAND, MAKELONG(id, BN_KILLFOCUS), (LPARAM)hwnd);
	}
	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return 0;		//	インターセプト
}
//----- WM_ERASEBKGND ------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_ERASEBKGND	)
{
	return 1;		//	インターセプト
}
//----- WM_PAINT -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_PAINT		)
{
	PAINTSTRUCT	ps;
	HDC			hdc, btdc;
	RECT		r;
	int			width, height;
	HBITMAP		hBmpSv , hBmp  = NULL;
	HFONT		hFontSv, hFont = NULL;

	//	ＤＣ設定
	hdc	   = BeginPaint(hwnd, &ps);

	do {
		//	ボタンウインドサイズ設定
		GetClientRect(hwnd, &r);
		width  = r.right - r.left;
		height = r.bottom - r.top;
		//	メモリＤＣ，ビットマップ作成
		if ((btdc	= CreateCompatibleDC	(hdc			   )) == NULL) break;
		if ((hBmp	= CreateCompatibleBitmap(hdc, width, height)) == NULL) break;
		//	フォント，ビットマップ割り当て
		hFont	= (HFONT  )SendMessage(hwnd, WM_GETFONT, 0, 0);
		hFontSv = (HFONT  )SelectObject(btdc, hFont);
		hBmpSv	= (HBITMAP)SelectObject(btdc, hBmp);
		//	ボタン描画
		DrawButton(hwnd, btdc, &r, width, height);
		//	ボタンウインドへ描画
		BitBlt(hdc, 0, 0, width, height, btdc, 0, 0, SRCCOPY);
		//	フォント，ビットマップ割り当て解除
		SelectObject(btdc, hFontSv);
		SelectObject(btdc, hBmpSv);
	} while(0);

	//	リソース破棄
	if (btdc != NULL) DeleteDC	  (btdc);
	if (hBmp != NULL) DeleteObject(hBmp);

	//	描画終了
	EndPaint(hwnd, &ps);

	return 0;		//	インターセプト
}
//----- BM_GETCHECK --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, BM_GETCHECK	)
{
	LRESULT rc = 0;
	UI		att;

	//	戻り値設定
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	switch (att & BTNATT_CHKMASK) {
		case BTNATT_CHKOFF:	rc = 0; break;
		case BTNATT_CHKON:	rc = 1; break;
		case BTNATT_3S:		rc = 2; break;
	}
	return rc;	//	インターセプト（チェック状態を返す）

}
//----- BM_SETCHECK --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, BM_SETCHECK	)
{
	UI	att, typ;

	//	チェックボックス状態設定
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	typ = att & (BS_TYPEMASK);
	switch (wParam) {
		case 0: att &= ~BTNATT_CHKMASK; att |= BTNATT_CHKOFF; break;
		case 1: att &= ~BTNATT_CHKMASK; att |= BTNATT_CHKON;  break;
		case 2: if (typ == BS_3STATE || typ == BS_AUTO3STATE) {
					att &= ~BTNATT_CHKMASK;
					att |= BTNATT_3S;
				}
				break;
	}
	SetProp(hwnd, BTNATT, (HANDLE)((UX)att));

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return 0;	//	インターセプト
}
//----- BM_GETSTATE --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, BM_GETSTATE	)
{
	LRESULT rc = 0;
	UI		att;

	//	ボタン状態取得
	att = (UI)((UX)GetProp(hwnd, BTNATT));

	//	押下状態／フォーカス状態設定
	if (att & BTNATT_PUSH ) rc |= BST_PUSHED;
	if (att & BTNATT_FOCUS) rc |= BST_FOCUS;

	//	チェック状態設定
	switch (att & BTNATT_CHKMASK) {
		case BTNATT_CHKOFF:	rc |= BST_UNCHECKED;	 break;
		case BTNATT_CHKON:	rc |= BST_CHECKED;		 break;
		case BTNATT_3S:		rc |= BST_INDETERMINATE; break;
	}
	return rc;	//	インターセプト（ボタン状態を返す）

}
//----- BM_SETSTATE --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, BM_SETSTATE	)
{
	LRESULT rc = 0;
	UI		att;

	//	ボタン押下状態設定（ハイライト状態設定）
	att = (UI)((UX)GetProp(hwnd, BTNATT));
	if (wParam == 0) att &= ~BTNATT_PUSH;
	else			 att |=  BTNATT_PUSH;
	SetProp(hwnd, BTNATT, (HANDLE)((UX)att));

	//	再描画
	RedrawWindow(hwnd, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);

	return 0;	//	インターセプト

}
//----- BM_SETSTYLE --------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, BM_SETSTYLE	)
{
	UI	att;

	att = (UI)((UX)GetProp(hwnd, BTNATT));
	att &= (~BTNATT_STYMASK | BS_TYPEMASK);
	att |= (UI)(wParam & ~BS_TYPEMASK);
	SetProp(hwnd, BTNATT, (HANDLE)((UX)att));

	return 0;	//	インターセプト
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_PUSHLIKE, WM_DESTROY	)
{
	//	インスタンスワーク破棄
	RemoveProp(hwnd, BTNATT);
	//	オリジナルプロシージャ実行
	return MAjcMmpCallOrgWndProc(SBC_PUSHBTN);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_PUSHLIKE)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_SETTEXT			)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_ENABLE			)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_LBUTTONDOWN		)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_LBUTTONUP		)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_LBUTTONDBLCLK	)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_KEYDOWN			)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_KEYUP			)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_SETFOCUS		)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_KILLFOCUS		)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_ERASEBKGND		)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_PAINT			)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, BM_GETCHECK		)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, BM_SETCHECK		)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, BM_GETSTATE		)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, BM_SETSTATE		)
	AJC_WNDMAP_MSG(SBC_PUSHLIKE, WM_DESTROY			)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	グループ内の他のラジオボタンのチェック解除																	//
//																												//
//	引数	：	hMyRbt			- 自ラジオボタンのハンドル														//
//				fOnlyOwnerDraw	- FALSE : グループ内のすべての他のラジオボタンのチェック解除					//
//								  TRUE	: グループ内のオーナー描画化したラジオボタンのみをチェック解除			//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
VO		ResetAllRbtInGroup(HWND hMyRbt, BOOL fOnlyOwnerDraw)
{
	HWND	hCur, hTop;

	//	グループ先頭検索
	hTop = hCur = hMyRbt;
	while ((MAjcGetWindowLong(hTop, GWL_STYLE) & WS_GROUP) == 0) {
		if ((hCur = GetWindow(hCur, GW_HWNDPREV)) == NULL) {
			break;
		}
		hTop = hCur;
	}
	//	グループ終端まで、グループ内の他のラジオボタンのチェック解除
	hCur = hTop;
	do	{
		UI	typ;
		WC	cname[MAX_PATH];
		if (hCur != hMyRbt) {
			GetClassName(hCur, cname, AJCTSIZE(cname));
			if (wcsicmp(cname, L"Button") == 0) {
				typ = (UI)(MAjcGetWindowLong(hCur, GWL_STYLE) & BS_TYPEMASK);
				//	オーナー描画化したラジオボタンのみ解除
				if (fOnlyOwnerDraw) {
					if (typ = ((UI)((UX)GetProp(hCur, BTNATT)) & BS_TYPEMASK)) {
						if (typ == BS_AUTORADIOBUTTON || typ == BS_RADIOBUTTON) {
							SendMessage(hCur, BM_SETCHECK, 0, 0);
						}
					}
				}
				//	全てのラジオボタンを解除
				else {
					if (typ == BS_AUTORADIOBUTTON || typ == BS_RADIOBUTTON) {
						SendMessage(hCur, BM_SETCHECK, 0, 0);
					}
				}
			}
		}
	} while((hCur = GetWindow(hCur, GW_HWNDNEXT)) && (MAjcGetWindowLong(hCur, GWL_STYLE) & WS_GROUP) == 0);
}

//--------------------------------------------------------------------------------------------------------------//
//	ボタン描画																									//
//																												//
//	引数	：	hBtn	- 描画するボタンのハンドル																//
//				btdc	- ボタン描画ＤＣ																		//
//				width	- ボタンウインドの幅																	//
//				height	- ボタンウインドの高さ																	//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DrawButton(HWND hBtn, HDC btdc, LPRECT pRect, int width, int height)
{
	BOOL		fDisabled = ((MAjcGetWindowLong(hBtn, GWL_STYLE) & WS_DISABLED) != 0);
	UI			att  = (UI)((UX)GetProp(hBtn, BTNATT));
	UI			typ  = (att & BS_TYPEMASK);
	HWND		hDlg = GetParent(hBtn);
	HICON		hIco = NULL;
	HBITMAP		hBmp = NULL;
	COLORREF	ccTrans;

	AJCDGCCTLCOLOR	CtlColor = {0};

	//	個別のウインドカラー指定
	CtlColor.hBrush		= hBruBkGnd;
	CtlColor.TextColor	= Cols.ccTextColor;
	CtlColor.BkColor	= -1;
	SendMessage(hDlg, WMSG_CTLCOLOR_BTN, (WPARAM)&CtlColor, (LPARAM)hBtn);

	//	背景塗りつぶし
	FillRect(btdc, pRect, CtlColor.hBrush);

	//	プッシュボタン風チェックボックス／ラジオボタン
	if (att & BS_PUSHLIKE) {
		//	チェックＯＮ／３Ｓ状態ならば背景＝ハッチパターン
		if ((att & BTNATT_CHKMASK) != BTNATT_CHKOFF) {
			if (Cols.ccHatch != Cols.ccBkGnd) {
				int		y;
				for (y = pRect->top + 1; y < pRect->bottom - 2; y++) {
					DotLineHori(btdc, Cols.ccHatch, pRect->left + 2 + (y & 1), pRect->right - 3, y);
				}
			}
		}
	}

	//	アイコン描画時の透明化色設定（未指定時は、-1）
	ccTrans = (COLORREF)((UX)GetProp(hDlg, BMPTRANS));

	//	●アイコン描画
	if		(hIco = (HICON	)SendMessage(hBtn, BM_GETIMAGE, IMAGE_ICON	, 0)) {
		SubDrawIcon(btdc, width, height, hIco, att, fDisabled, ccTrans);
	}
	//	●ビットマップ描画
	else if (hBmp = (HBITMAP)SendMessage(hBtn, BM_GETIMAGE, IMAGE_BITMAP, 0)) {
		SubDrawBitmap(btdc, width, height, hBmp, att, fDisabled, ccTrans);
	}
	//	●テキスト描画
	else {
		HFONT	hFont, hFSv;
		UI		len;
		WCP		pTxt, pBuf;

		hFont = (HFONT)SendMessage(hBtn, WM_GETFONT, 0, 0);
		hFSv  = (HFONT)SelectObject(btdc, hFont);
		//	文字列取得
		len = GetWindowTextLength(hBtn);
		if (pTxt = AjcTAlloc(len + 1)) {
			//	テキスト取得
			GetWindowText(hBtn, pTxt, len + 1);
			//	＆を処理したテキスト生成
			if (pBuf = AmpCreateExcText(pTxt, len, (att & BS_MULTILINE) != 0, FALSE)) {
				HAJCTXO	hTxo = NULL;
				//	ＴＸＯインスタンス生成
				if (hTxo = AjcTxoCreate(btdc, 0, 0, 1)) {	// x=0, y=0, 行間スペース=1
					int		dx, dy;
					//	ＤＣサイズ設定
					AjcTxoSetDcBmpSize(hTxo, width, height);
					//	Ｘ位置設定
					switch (att & BS_CENTER) {
						case BS_LEFT:	dx = 3;					AjcTxoSetAlign(hTxo, AJCTXOALIGN_LEFT);		break;
						case BS_RIGHT:	dx = AJCTXO_RIGHT - 4;	AjcTxoSetAlign(hTxo, AJCTXOALIGN_RIGHT);	break;
						default:
						case BS_CENTER:	dx = AJCTXO_CENTER;		AjcTxoSetAlign(hTxo, AJCTXOALIGN_CENTER);	break;
					}
					//	Ｙ位置設定
					switch (att & BS_VCENTER) {
						case BS_TOP:	 dy = 3;					break;
						case BS_BOTTOM:	 dy = AJCTXO_BOTTOM - 4;	break;
						default:
						case BS_VCENTER: dy = AJCTXO_CENTER;		break;
					}
					//	デフォルトテキスト色設定
					if (fDisabled || (att & BTNATT_CHKMASK) == BTNATT_3S) AjcTxoSetDefTextColor (hTxo, Cols.ccGrayText);
					else												  AjcTxoSetDefTextColor (hTxo, CtlColor.TextColor);
					//	デフォルト背景色設定
					AjcTxoSetDefBkColor (hTxo, CtlColor.BkColor);
					//	テキスト描画
					if (att & BTNATT_PUSH) AjcTxoTextOutEx(hTxo, dx + 1, dy + 1, pBuf);
					else				   AjcTxoTextOutEx(hTxo, dx    , dy    , pBuf);
					//	ＴＸＯインスタンス破棄
					AjcTxoDelete(hTxo, TRUE);
				}
				AjcTFree(pBuf);
			}
			free(pTxt);
		}
		//	フォント割り当て解除
		SelectObject(btdc, hFSv);
	}
	//	外枠描画（プッシュボタン）
	if (typ == BS_PUSHBUTTON || typ == BS_DEFPUSHBUTTON) {
		//	外枠描画
		SubDrawFramePushBtn(btdc, pRect, att, fShowFocus);
	}
	//	外枠描画（プッシュボタン風チェックボックス／ラジオボタン）
	else {
		//	外枠描画
		SubDrawFramePushLike(btdc, pRect, att, fShowFocus);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	アイコン描画																								//
//																												//
//	引数	：	btdc	  - ボタン描画ＤＣ																		//
//				width	  - ボタンウインドの幅																	//
//				height	  - ボタンウインドの高さ																//
//				hIco	  - アイコンハンドル																	//
//				att		  - ボタン属性																			//
//				fDisabled - 使用不可状態フラグ																	//
//				ccTrans	  - 透明化色																			//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubDrawIcon(HDC btdc, int width, int height, HICON hIco, UI att, BOOL fDisabled, COLORREF ccTrans)
{
	SIZE	sz;
	if (AjcGetIconSize(hIco, &sz)) {
		int		dx, dy;
		//	Ｘ位置設定
		switch (att & BS_CENTER) {
			case BS_LEFT:	dx = 3;						break;
			case BS_RIGHT:	dx = (width - sz.cx) - 4;	break;
			default:
			case BS_CENTER:	dx = (width - sz.cx) / 2;	break;
		}
		//	Ｙ位置設定
		switch (att & BS_VCENTER) {
			case BS_TOP:	 dy = 3;					break;
			case BS_BOTTOM:	 dy = height - sz.cy - 4;	break;
			default:
			case BS_VCENTER: dy = (height - sz.cy) / 2;	break;
		}
		//	描画（グレー表示）
		if (fDisabled || (att & BTNATT_CHKMASK) == BTNATT_3S) {
			AJCDIBINFO	dif;
			HBITMAP		hDib;
			//	ＤＩＢ作成して描画
			if (hDib = AjcDibCreate(sz.cx, sz.cy, 32, &dif)) {
				HBITMAP		hBmpSv;
				HDC			ddc;
				//	ｍｄｃ作成し、ＤＩＢを割り当て
				ddc    = CreateCompatibleDC(btdc);
				hBmpSv = (HBITMAP)SelectObject(ddc, hDib);
				//	ＤＩＢを白でクリアー
				AjcDibClear(&dif, RGB(255, 255, 255));
				//	アイコン描画
				DrawIconEx(ddc, 0, 0, hIco, sz.cx, sz.cy, 0, NULL, DI_NORMAL);
				//	図形部分をグレー描画
				if ((int)ccTrans == -1) ccTrans = RGB(255, 255, 255);
				DrawGrayBmpIcon(btdc, dx, dy, &dif, ddc, sz.cx, sz.cy, fDisabled ? Cols.ccGray : Cols.ccDark, ccTrans);
				//	ＢＭＰ割り当て解除しｍｄｃ破棄
				SelectObject(ddc, hBmpSv);
				DeleteDC(ddc);
				//	ＤＩＢ破棄
				DeleteObject(hDib);
			}
		}
		//	描画（通常表示）
		else {
			DrawIconEx(btdc, dx, dy, hIco, sz.cx, sz.cy, 0, NULL, DI_NORMAL);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ビットマップ描画																							//
//																												//
//	引数	：	btdc	  - ボタン描画ＤＣ																		//
//				width	  - ボタンウインドの幅																	//
//				height	  - ボタンウインドの高さ																//
//				hBmp	  - ビットマップハンドル																//
//				att		  - ボタン属性																			//
//				fDisabled - 使用不可状態フラグ																	//
//				ccTrans	  - 透明化色																			//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubDrawBitmap(HDC btdc, int width, int height, HBITMAP hBmp, UI att, BOOL fDisabled, COLORREF ccTrans)
{
	SIZE	sz;
	if (AjcGetBitmapSize(hBmp, &sz)) {
		int		dx, dy;
		//	Ｘ位置設定
		switch (att & BS_CENTER) {
			case BS_LEFT:	dx = 3;						break;
			case BS_RIGHT:	dx = (width - sz.cx) - 4;	break;
			default:
			case BS_CENTER:	dx = (width - sz.cx) / 2;	break;
		}
		//	Ｙ位置設定
		switch (att & BS_VCENTER) {
			case BS_TOP:	 dy = 3;					break;
			case BS_BOTTOM:	 dy = height - sz.cy - 4;	break;
			default:
			case BS_VCENTER: dy = (height - sz.cy) / 2;	break;
		}
		//	描画（グレー表示）
		if (fDisabled || (att & BTNATT_CHKMASK) == BTNATT_3S) {
			DrawBitmapGray(btdc, dx, dy, sz.cx, sz.cy, hBmp, ccTrans, fDisabled ? Cols.ccGray : Cols.ccDark);
		}
		//	描画（通常表示）
		else {
			DrawBitmapNormal(btdc, dx, dy, sz.cx, sz.cy, hBmp, ccTrans);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ビットマップ描画（グレー表示）																				//
//																												//
//	引数	：	hdc		  - 描画ＤＣ																			//
//				dx, dy	  - 描画位置																			//
//				cx, cy	  - ビットマップの幅，高さ																//
//				hBmp	  - ビットマップハンドル																//
//				ccTrans	  - 透明化色																			//
//				ccGray	  - 図形部分描画グレー色																//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DrawBitmapGray(HDC hdc, int dx, int dy, int cx, int cy, HBITMAP hBmp, COLORREF ccTrans, COLORREF ccGray)
{
	AJCDIBINFO	dif;
	HBITMAP		hDib;

	//	ＤＩＢ作成して描画
	if (hDib = AjcDibCreate(cx, cy, 32, &dif)) {
		HBITMAP	hBmpSv;
		HDC		ddc;
		//	ＤＩＢへビットマップをコピー
		AjcDibCopyBitmap (&dif, 0, 0, cx, cy, hBmp, 0, 0, cx, cy, SRCCOPY);
		//	ｍｄｃ作成し、ＤＩＢを割り当て
		ddc    = CreateCompatibleDC(hdc);
		hBmpSv = (HBITMAP)SelectObject(ddc, hDib);
		//	図形部分をグレー描画
		if ((int)ccTrans == -1) ccTrans = RGB(255, 255, 255);
		DrawGrayBmpIcon(hdc, dx, dy, &dif, ddc, cx, cy, ccGray, ccTrans);
		//	ＢＭＰ割り当て解除しｍｄｃ破棄
		SelectObject(ddc, hBmpSv);
		DeleteDC(ddc);
		//	ＤＩＢ破棄
		DeleteObject(hDib);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ビットマップ描画（通常表示）																				//
//																												//
//	引数	：	hdc		  - 描画ＤＣ																			//
//				dx, dy	  - 描画位置																			//
//				cx, cy	  - ビットマップの幅，高さ																//
//				hBmp	  - ビットマップハンドル																//
//				ccTrans	  - 透明化色																			//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DrawBitmapNormal(HDC hdc, int dx, int dy, int cx, int cy, HBITMAP hBmp, COLORREF ccTrans)
{
	HBITMAP		hBmpSv;
	HDC			mdc;

	//	透明化しないで描画
	if ((int)ccTrans == -1) {
		mdc = CreateCompatibleDC(hdc);
		hBmpSv = (HBITMAP)SelectObject(mdc, hBmp);
		BitBlt(hdc, dx, dy, cx, cy, mdc, 0, 0, SRCCOPY);
		SelectObject(mdc, hBmpSv);
		DeleteDC(mdc);
	}
	//	透明化して描画
	else {
		AJCDIBINFO	dif;
		HBITMAP		hDib;
		//	ＤＩＢを作成し描画
		if (hDib = AjcDibCreate(cx, cy, 32, &dif)) {
			int x, y;
			//	ｍｄｃ作成
			mdc = CreateCompatibleDC(hdc);
			//	ＤＩＢへビットマップをコピー
			AjcDibCopyBitmap (&dif, 0, 0, cx, cy, hBmp, 0, 0, cx, cy, SRCCOPY);
			//	透明色→白，図形部分（透明色以外の部分）を黒に変換
			for (y = 0; y < cy; y++) {
				COLORREF *p = (COLORREF*)AjcDibGetLinrPtr(&dif, y);
				for (x = 0; x < cx; x++, p++) {
					if (*p != ccTrans) *p = RGB(0, 0, 0);
					else			   *p = RGB(255, 255, 255);
				}
			}
			//	描画先の図形部分を黒色で、繰り抜く
			hBmpSv = (HBITMAP)SelectObject(mdc, hDib);
			BitBlt(hdc, dx, dy, cx, cy, mdc, 0, 0, SRCAND);
			SelectObject(mdc, hBmpSv);

			//	ＤＩＢへビットマップをコピー
			AjcDibCopyBitmap (&dif, 0, 0, cx, cy, hBmp, 0, 0, cx, cy, SRCCOPY);
			//	透明色→黒 に変換
			for (y = 0; y < cy; y++) {
				COLORREF *p = (COLORREF*)AjcDibGetLinrPtr(&dif, y);
				for (x = 0; x < cx; x++, p++) {
					if (*p == ccTrans) *p = RGB(0, 0, 0);
				}
			}
			//	描画先へ図形描画
			hBmpSv = (HBITMAP)SelectObject(mdc, hDib);
			BitBlt(hdc, dx, dy, cx, cy, mdc, 0, 0, SRCPAINT);
			SelectObject(mdc, hBmpSv);
			//	ｍｄｃ破棄
			DeleteDC(mdc);
			//	ＤＩＢ破棄
			DeleteObject(hDib);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	外枠描画（プッシュボタン）																					//
//																												//
//	引数	：	btdc	   - ボタン描画ＤＣ																		//
//				width	   - ボタンウインドの幅																	//
//				height	   - ボタンウインドの高さ																//
//				att		   - ボタン属性																			//
//				fShowFocus - フォーカス表示フラグ（点線枠表示）													//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubDrawFramePushBtn(HDC btdc, LPRECT pRect, UI att, BOOL fShowFocus)
{
	//	ボタン押下時の描画
	if (att & BTNATT_PUSH) {
		if ((att & BS_TYPEMASK) == BS_DEFPUSHBUTTON) {
			if (att & BS_FLAT) {
				DrawLineRC(btdc, Cols.ccDefOutL, pRect,	0, FALSE);	//	濃枠
				DrawLineRC(btdc, Cols.ccDefOutL, pRect,	1, FALSE);	//	濃枠
				DrawLineRC(btdc, Cols.ccBright , pRect,	2, FALSE);	//	白枠
			}
			else {
				DrawLineRC(btdc, Cols.ccGray   , pRect, 0, FALSE);	//	灰枠
				DrawLineRC(btdc, Cols.ccDefOutL, pRect, 1, FALSE);	//	濃枠
			}
		}
		else {
			if (att & BS_FLAT) {
				DrawLineRC(btdc, Cols.ccDark  , pRect,	0, FALSE);	//	濃枠
				DrawLineRC(btdc, Cols.ccDark  , pRect,	1, FALSE);	//	濃枠
				DrawLineRC(btdc, Cols.ccBright, pRect,	2, FALSE);	//	白枠
			}
			else {
				DrawLineRC(btdc, Cols.ccGray, pRect, 0, FALSE);		//	灰枠
				DrawLineRC(btdc, Cols.ccDark, pRect, 1, FALSE);		//	濃枠
			}
		}
	}
	//	ボタン離し時の描画
	else {
		//	大きいボタン
		if ((pRect->right - pRect->left) > 32) {
			//	デフォルトプッシュボタン ＆ ダイアログはアクティブ？
			if ((att & BS_TYPEMASK) == BS_DEFPUSHBUTTON) {
				if (att & BS_FLAT) {
					DrawLineRC(btdc, Cols.ccDefOutL, pRect,	0, FALSE);	//	濃枠
					DrawLineRC(btdc, Cols.ccLtGray , pRect,	1, FALSE);	//	白枠
				}
				else {
					DrawLineRC(btdc, Cols.ccDefOutL, pRect,	0, FALSE);	//	濃枠
					DrawLineLU(btdc, Cols.ccBright , pRect,	1, FALSE);	//	白枠
					DrawLineRD(btdc, Cols.ccDark   , pRect,	1, FALSE);	//	濃枠
					DrawLineLU(btdc, Cols.ccLtGray , pRect,	2, FALSE);	//	薄枠
					DrawLineRD(btdc, Cols.ccGray   , pRect,	2, FALSE);	//	灰枠
				}
				//	フォーカス表示（点線）
				if ((att & BTNATT_FOCUS) && fShowFocus) {
					DrawLineRC(btdc, Cols.ccDark, pRect, 4, TRUE);
				}
			}
			//	通常のボタン or ダイアログは非アクティブ？
			else {
				if (att & BS_FLAT) {
					DrawLineRC(btdc, Cols.ccDark  , pRect,	0, FALSE);	//	濃枠
					DrawLineRC(btdc, Cols.ccBright, pRect,	1, FALSE);	//	白枠
				}
				else {
					DrawLineLU(btdc, Cols.ccBright, pRect,	0, FALSE);	//	白枠
					DrawLineLU(btdc, Cols.ccLtGray, pRect,	1, FALSE);	//	薄枠
					DrawLineRD(btdc, Cols.ccGray  , pRect,	1, FALSE);	//	灰枠
					DrawLineRD(btdc, Cols.ccDark  , pRect,	0, FALSE);	//	濃枠
				}
				//	フォーカス表示（点線）
				if ((att & BTNATT_FOCUS) && fShowFocus) {
					DrawLineRC(btdc, Cols.ccDark, pRect, 3, TRUE);
				}
			}
		}
		//	小さいボタン
		else {
			//	デフォルトプッシュボタン ＆ ダイアログはアクティブ？
			if ((att & BS_TYPEMASK) == BS_DEFPUSHBUTTON) {
				if (att & BS_FLAT) {
					DrawLineRC(btdc, Cols.ccDefOutL, pRect,	0, FALSE);	//	灰枠
				}
				else {
					DrawLineLU(btdc, Cols.ccGray   , pRect,	0, FALSE);	//	灰枠
					DrawLineRD(btdc, Cols.ccDefOutL, pRect,	0, FALSE);	//	濃枠
				}
			}
			else {
				if (att & BS_FLAT) {
					DrawLineRC(btdc, Cols.ccDark  , pRect,	0, FALSE);	//	灰枠
				}
				else {
					DrawLineLU(btdc, Cols.ccLtGray, pRect,	0, FALSE);	//	薄枠
					DrawLineRD(btdc, Cols.ccDark  , pRect,	0, FALSE);	//	濃枠
				}
			}
			//	フォーカス表示（点線）
			if ((att & BTNATT_FOCUS) && fShowFocus) {
				DrawLineRC(btdc, Cols.ccDark, pRect, 2, TRUE);
			}
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	外枠描画（プッシュボタン風チェックボックス／ラジオボタン）													//
//																												//
//	引数	：	btdc	   - ボタン描画ＤＣ																		//
//				width	   - ボタンウインドの幅																	//
//				height	   - ボタンウインドの高さ																//
//				att		   - ボタン属性																			//
//				fShowFocus - フォーカス表示フラグ（点線枠表示）													//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubDrawFramePushLike (HDC btdc, LPRECT pRect, UI att, BOOL fShowFocus)
{
	if (att & BS_FLAT) {
		DrawLineRC(btdc, Cols.ccDark  , pRect,	0, FALSE);	//	濃枠
		DrawLineRC(btdc, Cols.ccBright, pRect,	1, FALSE);	//	灰枠
	}
	else {
		//	チェック時／押下状態時の描画
		if ((att & BTNATT_CHKMASK) != BTNATT_CHKOFF || (att & BTNATT_PUSH)) {
			DrawLineLU(btdc, Cols.ccDark  , pRect,	0, FALSE);	//	濃枠
			DrawLineLU(btdc, Cols.ccGray  , pRect,	1, FALSE);	//	灰枠
			DrawLineRD(btdc, Cols.ccBright, pRect,	0, FALSE);	//	白枠
			DrawLineRD(btdc, Cols.ccLtGray, pRect,	1, FALSE);	//	薄枠
		}
		//	未チェック＆離し状態時の描画
		else {
			DrawLineLU(btdc, Cols.ccBright, pRect,	0, FALSE);	//	白枠
			DrawLineLU(btdc, Cols.ccLtGray, pRect,	1, FALSE);	//	薄枠
			DrawLineRD(btdc, Cols.ccDark  , pRect,	0, FALSE);	//	濃枠
			DrawLineRD(btdc, Cols.ccGray  , pRect,	1, FALSE);	//	灰枠
		}
	}
	//	フォーカス表示（点線）
	if ((att & BTNATT_FOCUS) && fShowFocus) {
		DrawLineRC(btdc, Cols.ccDark, pRect, 4, TRUE);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	図形部分をグレー表示																						//
//																												//
//	引数	：	btdc	- ボタン描画ＤＣ																		//
//				dx, dy	- 描画先の描画位置																		//
//				pDif	- ＤＩＢ情報へのポインタ																//
//				mdc		- 描画元ＤＣ（背景＝白でアイコン／ビットマップ描画済み）								//
//				cx, cy	- 描画元ＤＣのビットマップサイズ														//
//				ccGray	- グレー色																				//
//				ccTrans - 透明色																				//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DrawGrayBmpIcon(HDC btdc, int dx, int dy, PAJCDIBINFO pDif, HDC mdc, int cx, int cy, COLORREF ccGray, COLORREF ccTrans)
{
	int		x, y;

	//	透明色→白，図形部分（透明色以外の部分）を黒に変換
	for (y = 0; y < cy; y++) {
		COLORREF *p = (COLORREF*)AjcDibGetLinrPtr(pDif, y);
		for (x = 0; x < cx; x++, p++) {
			if (*p == ccTrans) *p = RGB(255, 255, 255);
			else			   *p = RGB(  0,   0,	0);
		}
	}
	//	描画先の図形部分を黒色で、繰り抜く
	BitBlt(btdc, dx, dy, cx, cy, mdc, 0, 0, SRCAND);
	//	透明色→黒，黒→グレー に変換
	for (y = 0; y < cy; y++) {
		COLORREF *p = (COLORREF*)AjcDibGetLinrPtr(pDif, y);
		for (x = 0; x < cx; x++, p++) {
			if (*p == ccTrans) *p = RGB(0, 0, 0);
			else			   *p = ccGray;
		}
	}
	//	描画先へ図形描画
	BitBlt(btdc, dx, dy, cx, cy, mdc, 0, 0, SRCPAINT);
}
//--------------------------------------------------------------------------------------------------------------//
//	枠線描画（左と上側）									｜ポイント割り当て：	pt3				pt4			//
//															｜						・－－－－－－－・			//
//	引数	：	btdc	 - ボタン描画ＤＣ					｜				pt2	・								//
//				cc		 - 描画色							｜					｜								//
//				pRc		 - 描画域矩形へのポインタ			｜					｜								//
//				rel		 - 最外枠(=0) → 内枠への相対値		｜					｜								//
//				fDotLine - 直線を点線で描画					｜				pt1	・								//
//															｜													//
//	戻り値	:	なし										｜													//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DrawLineLU(HDC btdc, COLORREF cc, LPRECT pRc, int rel, BOOL fDotLine)
{
	POINT	pt1 = {pRc->left  + (rel + 0), pRc->bottom - (rel + 3)};
	POINT	pt2 = {pRc->left  + (rel + 0), pRc->top    + (rel + 3)};
	POINT	pt3 = {pRc->left  + (rel + 3), pRc->top    + (rel + 0)};
	POINT	pt4 = {pRc->right - (rel + 3), pRc->top    + (rel + 0)};

	//	終端店を実位置に補正
	pt1.y--;
	pt4.x--;

	if (fDotLine) {
		//	点線描画
		DotLineVert(btdc, cc, pt1.x, pt2.y, pt1.y);		//	pt2:左上 → pt1:左下
		DotLineHori(btdc, cc, pt3.x, pt4.x, pt3.y);		//	pt3:左上 → pt4:右上

		//	左下コーナー
		SetPixel(btdc, pt1.x + 1, pt1.y + 1, cc);
		SetPixel(btdc, pt1.x + 2, pt1.y + 2, cc);

		//	左上コーナー
		SetPixel(btdc, pt2.x + 1, pt2.y - 1, cc);
		SetPixel(btdc, pt2.x + 2, pt2.y - 2, cc);

		//	右上コーナー
		SetPixel(btdc, pt4.x + 1, pt4.y + 1, cc);
		SetPixel(btdc, pt4.x + 2, pt4.y + 2, cc);
	}
	else {
		HPEN hPen = (HPEN)SelectObject(btdc, CreatePen(PS_SOLID, 1, cc));
		MoveToEx(btdc, pt2.x	, pt2.y    , NULL);		//	pt2:左上 →
		LineTo	(btdc, pt1.x	, pt1.y + 1);			//	pt1:左下
		MoveToEx(btdc, pt3.x	, pt3.y    , NULL);		//	pt3:左上 →
		LineTo	(btdc, pt4.x + 1, pt4.y    );			//	pt4:右上
		DeleteObject(SelectObject(btdc, hPen));

		//	右上コーナー
		SetPixel(btdc, pt4.x + 1, pt4.y + 1, cc);
		SetPixel(btdc, pt4.x + 2, pt4.y + 2, cc);
		SetPixel(btdc, pt4.x + 0, pt4.y + 1, cc);
		SetPixel(btdc, pt4.x + 1, pt4.y + 2, cc);
		SetPixel(btdc, pt4.x + 2, pt4.y + 3, cc);

		//	左下コーナー
		SetPixel(btdc, pt1.x + 1, pt1.y + 1, cc);
		SetPixel(btdc, pt1.x + 2, pt1.y + 2, cc);
		SetPixel(btdc, pt1.x + 1, pt1.y + 0, cc);
		SetPixel(btdc, pt1.x + 2, pt1.y + 1, cc);
		SetPixel(btdc, pt1.x + 3, pt1.y + 2, cc);

		//	左上コーナー
		SetPixel(btdc, pt2.x + 1, pt2.y - 1, cc);
		SetPixel(btdc, pt2.x + 2, pt2.y - 2, cc);
		SetPixel(btdc, pt2.x + 1, pt2.y - 0, cc);
		SetPixel(btdc, pt2.x + 2, pt2.y - 1, cc);
		SetPixel(btdc, pt2.x + 3, pt2.y - 2, cc);

	}
}
//--------------------------------------------------------------------------------------------------------------//
//	枠線描画（右と下側）									｜ポイント割り当て：								//
//															｜											・pt5	//
//	引数	：	btdc	 - ボタン描画ＤＣ					｜											｜		//
//				cc		 - 描画色							｜											｜		//
//				pRc		 - 描画域矩形へのポインタ			｜											｜		//
//				rel		 - 最外枠(=0) → 内枠への相対値		｜											・pt6	//
//				fDotLine - 直線を点線で描画					｜						・－－－－－－－・			//
//															｜						pt8				pt7			//
//	戻り値	:	なし										｜													//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DrawLineRD(HDC btdc, COLORREF cc, LPRECT pRc, int rel, BOOL fDotLine)
{

	POINT	pt5 = {pRc->right - (rel + 0), pRc->top    + (rel + 3)};
	POINT	pt6 = {pRc->right - (rel + 0), pRc->bottom - (rel + 3)};
	POINT	pt7 = {pRc->right - (rel + 3), pRc->bottom - (rel + 0)};
	POINT	pt8 = {pRc->left  + (rel + 3), pRc->bottom - (rel + 0)};

	//	終端店を実位置に補正
	pt5.x--;
	pt6.x--;  pt6.y--;
	pt7.x--;  pt7.y--;
			  pt8.y--;

	if (fDotLine) {
		//	点線描画
		DotLineVert(btdc, cc, pt5.x, pt5.y, pt6.y);		//	pt5:右上 → pt6:右下
		DotLineHori(btdc, cc, pt8.x, pt7.x, pt7.y);		//	pt8:左下 → pt7:右下

		//	右下コーナー
		SetPixel(btdc, pt6.x - 1, pt6.y + 1, cc);
		SetPixel(btdc, pt6.x - 2, pt6.y + 2, cc);
	}
	else {
		HPEN hPen = (HPEN)SelectObject(btdc, CreatePen(PS_SOLID, 1, cc));
		MoveToEx(btdc, pt5.x	, pt5.y    , NULL);		//	pt5:右上 →
		LineTo	(btdc, pt6.x	, pt6.y + 1);			//	pt6:右下
		MoveToEx(btdc, pt8.x	, pt8.y    , NULL);		//	pt8:左下→
		LineTo	(btdc, pt7.x + 1, pt7.y    );			//	pt7:右下
		DeleteObject(SelectObject(btdc, hPen));

		//	右下コーナー
		SetPixel(btdc, pt6.x - 1, pt6.y + 1, cc);
		SetPixel(btdc, pt6.x - 2, pt6.y + 2, cc);
		SetPixel(btdc, pt6.x - 1, pt6.y + 0, cc);
		SetPixel(btdc, pt6.x - 2, pt6.y + 1, cc);
		SetPixel(btdc, pt6.x - 3, pt6.y + 2, cc);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	枠線描画（矩形）																							//
//																												//
//	引数	：	btdc	 - ボタン描画ＤＣ																		//
//				cc		 - 描画色																				//
//				pRc		 - 描画域矩形へのポインタ																//
//				rel		 - 最外枠(=0) → 内枠への相対値															//
//				fDotLine - 直線を点線で描画																		//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DrawLineRC(HDC btdc, COLORREF cc, LPRECT pRc, int rel, BOOL fDotLine)
{
	DrawLineLU(btdc, cc, pRc, rel, fDotLine);
	DrawLineRD(btdc, cc, pRc, rel, fDotLine);
}
//--------------------------------------------------------------------------------------------------------------//
//	点線描画（縦線）																							//
//																												//
//	引数	：	btdc	 - ボタン描画ＤＣ																		//
//				cc		 - 描画色																				//
//				x		 - Ｘ位置																				//
//				y1, y2	 - Ｙ位置端点																			//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DotLineVert(HDC btdc, COLORREF cc, int x, int y1, int y2)
{
	int		y;
	int		ymin = __min(y1, y2);
	int		ymax = __max(y1, y2);

	for (y = ymin; y <= ymax; y += 2) {
		SetPixel(btdc, x, y, cc);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	点線描画（横線）																							//
//																												//
//	引数	：	btdc	 - ボタン描画ＤＣ																		//
//				cc		 - 描画色																				//
//				x1, x2	 - Ｘ位置端点																			//
//				y		 - Ｙ位置																				//
//																												//
//	戻り値	:	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DotLineHori(HDC btdc, COLORREF cc, int x1, int x2, int y)
{
	int		x;
	int		xmin = __min(x1, x2);
	int		xmax = __max(x1, x2);

	for (x = xmin; x <= xmax; x += 2) {
		SetPixel(btdc, x, y, cc);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	'＆'を処理したテキスト生成（連続する＆は１つの＆に変換，１つの'＆'は消去、最初の'＆'後にアンダーライン）	//
//																												//
//	引数	：	pTxt	- テキスト																				//
//				lTxt	- テキストの文字数																		//
//				fMulti	- 複数行許可フラグ																		//
//																												//
//	戻り値	:	≠NULL : '＆'を除いた文字列バッファへのポインタ													//
//				＝NULL : 失敗																					//
//--------------------------------------------------------------------------------------------------------------//
static	WCP	AmpCreateExcText(WCP pTxt, UI lTxt, BOOL fMulti, BOOL fRemoveTAB)
{
	WCP		pBuf = NULL;
	WCP		p, q;
	BOOL	fAmpNxt = FALSE;
	BOOL	fAmpUL	= FALSE;
	UI		i;

	if (pBuf = AjcTAllocW(lTxt + 16)) {
		q = pBuf;
		for (i = 0, p = pTxt; i < lTxt && *p != 0; i++, p++) {
			//	＆の直後以外？
			if (!fAmpNxt) {
				//	＆
				if (*p == L'&') {
					fAmpNxt = TRUE;
				}
				//	改行
				else if (*p == '\n') {
					//	複数行許可ならば、改行設定
					if (fMulti) *q++ = L'\n';
				}
				//	ＴＡＢ削除
				else if (*p == '\t' && fRemoveTAB) {
					//	NOP
				}
				//	その他
				else {
					*q++ = *p;
				}
			}
			//	＆の直後？
			else {
				//	＆＆（２つ連続）？
				if (*p == L'&') {
					*q++ = L'&';
				}
				//	＆直後は制御文字以外？
				else if (!iswcntrl(*p)) {
					//	＆直後に下線未設定？
					if (!fAmpUL) {
						fAmpUL = TRUE;
						//	下線設定
						wcscpy(q, L"\x1B[U");
						q += 3;
						//	文字設定
						*q++ = *p;
						//	下線解除
						wcscpy(q, L"\x1B[u");
						q += 3;
					}
					//	＆直後に下線設定済み？
					else {
						*q++ = *p;
					}
				}
				fAmpNxt = FALSE;
			}
		}
		*q = 0;
	}
	return pBuf;
}

