﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	ダイアログボックス項目																						//
//																												//
//**************************************************************************************************************//

#define	HWCTRL	GetDlgItem(hDlg, id)

//==============================================================================================================//
//	ダイアログ項目　数値取得																					//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	読み出した値（失敗時は０）																		//
//==============================================================================================================//
AJCEXPORT UI	 WINAPI AjcGetDlgItemUInt(HWND hDlg, int id) {return AjcGetCtrlUInt(HWCTRL);}
AJCEXPORT SI	 WINAPI AjcGetDlgItemSInt(HWND hDlg, int id) {return AjcGetCtrlSInt(HWCTRL);}
AJCEXPORT UI	 WINAPI AjcGetDlgItemHex (HWND hDlg, int id) {return AjcGetCtrlHex (HWCTRL);}
AJCEXPORT double WINAPI AjcGetDlgItemReal(HWND hDlg, int id) {return AjcGetCtrlReal(HWCTRL);}
AJCEXPORT ULL	 WINAPI AjcGetDlgItemUI64(HWND hDlg, int id) {return AjcGetCtrlUI64(HWCTRL);}
AJCEXPORT SLL	 WINAPI AjcGetDlgItemSI64(HWND hDlg, int id) {return AjcGetCtrlSI64(HWCTRL);}
AJCEXPORT ULL	 WINAPI AjcGetDlgItemH64 (HWND hDlg, int id) {return AjcGetCtrlH64 (HWCTRL);}

//==============================================================================================================//
//	ダイアログ項目　数値設定																					//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//				value	- 設定値																				//
//				opt		- 書式オプション																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL WINAPI AjcSetOptDlgItemUInt(HWND hDlg, int id, UI	 value, BOOL fComma  ) {return AjcSetOptCtrlUInt(HWCTRL, value, fComma	 );}
AJCEXPORT BOOL WINAPI AjcSetOptDlgItemSInt(HWND hDlg, int id, SI	 value, BOOL fComma  ) {return AjcSetOptCtrlSInt(HWCTRL, value, fComma	 );}
AJCEXPORT BOOL WINAPI AjcSetOptDlgItemHex (HWND hDlg, int id, UI	 value, int digits	 ) {return AjcSetOptCtrlHex (HWCTRL, value, digits	 );}
AJCEXPORT BOOL WINAPI AjcSetOptDlgItemReal(HWND hDlg, int id, double value, int precision) {return AjcSetOptCtrlReal(HWCTRL, value, precision);}
AJCEXPORT BOOL WINAPI AjcSetOptDlgItemUI64(HWND hDlg, int id, ULL	 value, BOOL fComma  ) {return AjcSetOptCtrlUI64(HWCTRL, value, fComma	 );}
AJCEXPORT BOOL WINAPI AjcSetOptDlgItemSI64(HWND hDlg, int id, SLL	 value, BOOL fComma  ) {return AjcSetOptCtrlSI64(HWCTRL, value, fComma	 );}
AJCEXPORT BOOL WINAPI AjcSetOptDlgItemH64 (HWND hDlg, int id, ULL	 value, int digits	 ) {return AjcSetOptCtrlH64 (HWCTRL, value, digits	 );}

//----- 10進の区切りをつけない／16進を桁揃えしない -------------------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcSetDlgItemUInt(HWND hDlg, int id, UI	  value)		   {return AjcSetCtrlUInt(HWCTRL, value);	   }
AJCEXPORT BOOL WINAPI AjcSetDlgItemSInt(HWND hDlg, int id, SI	  value)		   {return AjcSetCtrlSInt(HWCTRL, value);	   }
AJCEXPORT BOOL WINAPI AjcSetDlgItemHex (HWND hDlg, int id, UI	  value)		   {return AjcSetCtrlHex (HWCTRL, value);	   }
AJCEXPORT BOOL WINAPI AjcSetDlgItemReal(HWND hDlg, int id, double value, int prec) {return AjcSetCtrlReal(HWCTRL, value, prec);}
AJCEXPORT BOOL WINAPI AjcSetDlgItemUI64(HWND hDlg, int id, ULL	  value)		   {return AjcSetCtrlUI64(HWCTRL, value);	   }
AJCEXPORT BOOL WINAPI AjcSetDlgItemSI64(HWND hDlg, int id, SLL	  value)		   {return AjcSetCtrlSI64(HWCTRL, value);	   }
AJCEXPORT BOOL WINAPI AjcSetDlgItemH64 (HWND hDlg, int id, ULL	  value)		   {return AjcSetCtrlH64 (HWCTRL, value);	   }

//----- 10進の区切りをつける／16進を桁揃えする -----------------------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcSepDlgItemUInt(HWND hDlg, int id, UI	  value)		   {return AjcSepCtrlUInt(HWCTRL, value);	   }
AJCEXPORT BOOL WINAPI AjcSepDlgItemSInt(HWND hDlg, int id, SI	  value)		   {return AjcSepCtrlSInt(HWCTRL, value);	   }
AJCEXPORT BOOL WINAPI AjcSepDlgItemHex (HWND hDlg, int id, UI	  value, int col ) {return AjcSepCtrlHex (HWCTRL, value, col); }
AJCEXPORT BOOL WINAPI AjcSepDlgItemReal(HWND hDlg, int id, double value, int prec) {return AjcSepCtrlReal(HWCTRL, value, prec);}
AJCEXPORT BOOL WINAPI AjcSepDlgItemUI64(HWND hDlg, int id, ULL	  value)		   {return AjcSepCtrlUI64(HWCTRL, value);	   }
AJCEXPORT BOOL WINAPI AjcSepDlgItemSI64(HWND hDlg, int id, SLL	  value)		   {return AjcSepCtrlSI64(HWCTRL, value);	   }
AJCEXPORT BOOL WINAPI AjcSepDlgItemH64 (HWND hDlg, int id, ULL	  value, int col ) {return AjcSepCtrlH64 (HWCTRL, value, col); }

//==============================================================================================================//
//	ダイアログ項目　文字列取得																					//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//				pBuf	- 取得した文字列を格納するバッファのアドレス											//
//				lBuf	- 取得した文字列を格納するバッファの文字数												//
//																												//
//	戻り値：	≠０：取得した文字長																			//
//				＝０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcGetDlgItemStrA(HWND hDlg, int id, BCP pBuf, UI lBuf) 
{
	return AjcGetCtrlStrA(HWCTRL, pBuf, lBuf);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcGetDlgItemStrW(HWND hDlg, int id, WCP pBuf, UI lBuf) 
{
	return AjcGetCtrlStrW(HWCTRL, pBuf, lBuf);
}

//==============================================================================================================//
//	ダイアログ項目　文字列の長さ取得																			//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	≠０：文字長																					//
//				＝０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcGetDlgItemStrLenA(HWND hDlg, int id) 
{
	return AjcGetCtrlStrLenA(HWCTRL);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcGetDlgItemStrLenW(HWND hDlg, int id) 
{
	return AjcGetCtrlStrLenW(HWCTRL);
}

//==============================================================================================================//
//	ダイアログ項目　文字列設定																					//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//				pStr	- 設定する文字列のアドレス																//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemStrA (HWND hDlg, int id, C_BCP pStr) 
{
	return AjcSetCtrlStrA(HWCTRL, pStr);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemStrW (HWND hDlg, int id, C_WCP pStr) 
{
	return AjcSetCtrlStrW(HWCTRL, pStr);
}

//==============================================================================================================//
//	ダイアログ項目　書式文字列設定																				//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//				pFmt	- 書式文字列のアドレス																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemFStrA (HWND hDlg, int id, C_BCP pFmt, ...) 
{
	BOOL	rc = FALSE;
	va_list	vls;
	BC		txt[1024];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf(txt, 1024, pFmt, vls);
		va_end	(vls);
		txt[1023] = 0;
		rc = AjcSetCtrlStrA(HWCTRL, txt);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemFStrW (HWND hDlg, int id, C_WCP pFmt, ...) 
{
	BOOL	rc = FALSE;
	va_list	vls;
	WC		txt[1024];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf(txt, 1024, pFmt, vls);
		va_end	(vls);
		txt[1023] = 0;
		rc = AjcSetCtrlStrW(HWCTRL, txt);
	}
	return rc;
}

//==============================================================================================================//
//	ダイアログ項目　チェックボックス状態取得																	//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	チェック状態																					//
//==============================================================================================================//
AJCEXPORT UI	 WINAPI AjcGetDlgItemChk(HWND hDlg, int id)
{
	return AjcGetCtrlChk(HWCTRL);
}

//==============================================================================================================//
//	ダイアログ項目　チェックボックス状態設定																	//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//				state	- 設定する状態																			//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemChk(HWND hDlg, int id, UI state) 
{
	return AjcSetCtrlChk(HWCTRL, state);
}

//==============================================================================================================//
//	ダイアログ項目　ラジオボタン設定																			//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- チェックするラジオボタンのＩＤ														//
//				idFirst	- グループ内の最初のラジオボタンのＩＤ													//
//				idLast	- グループ内の最後のラジオボタンのＩＤ													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemRbt	(HWND hDlg, int id, int idFirst, int idLast)
{
	return CheckRadioButton(hDlg, idFirst, idLast, id);
}
//==============================================================================================================//
//	ダイアログ項目　エディットコントロールの入力可能文字数設定													//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//				state	- 設定する状態																			//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemEdtLimitA(HWND hDlg, int id, UI limit) 
{
	return AjcSetCtrlEdtLimitA(HWCTRL, limit);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemEdtLimitW(HWND hDlg, int id, UI limit) 
{
	return AjcSetCtrlEdtLimitW(HWCTRL, limit);
}

//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックス選択項目のインデクス取得										//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	選択されている項目のインデクス／CB_ERR															//
//==============================================================================================================//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstIx(HWND hDlg, int id) 
{
	return AjcGetCtrlLstIx(HWCTRL);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboIx(HWND hDlg, int id) 
{
	return AjcGetCtrlCboIx(HWCTRL);
}

//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックスの項目数取得													//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	コンボボックスの項目数																			//
//==============================================================================================================//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstCount(HWND hDlg, int id)
{
	return AjcGetCtrlLstCount(HWCTRL);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboCount(HWND hDlg, int id)
{
	return AjcGetCtrlCboCount(HWCTRL);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックス項目のテキスト長取得											//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				ix		  - 項目インデクス（－１の場合は現在の選択項目）										//
//																												//
//	戻り値：	コンボボックス項目の文字列長																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstLenA (HWND hDlg, int id, UI ix)
{
	return AjcGetCtrlLstLenA (HWCTRL, ix);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboLenA (HWND hDlg, int id, UI ix)
{
	return AjcGetCtrlCboLenA (HWCTRL, ix);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstLenW (HWND hDlg, int id, UI ix)
{
	return AjcGetCtrlLstLenW (HWCTRL, ix);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboLenW (HWND hDlg, int id, UI ix)
{
	return AjcGetCtrlCboLenW (HWCTRL, ix);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックス項目のテキスト取得											//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				ix		  - 項目インデクス（－１の場合は現在の選択項目）										//
//				pBuf	  - 取得したテキストを格納するバッファのアドレス										//
//				lBuf	  - 取得したテキストを格納するバッファの文字数											//
//																												//
//	戻り値：	コンボボックス項目のテキスト長																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstItemA(HWND hDlg, int id, UI ix, BCP pBuf, UI lBuf)
{
	return AjcGetCtrlLstItemA(HWCTRL, ix, pBuf, lBuf);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboItemA(HWND hDlg, int id, UI ix, BCP pBuf, UI lBuf)
{
	return AjcGetCtrlCboItemA(HWCTRL, ix, pBuf, lBuf);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstItemW(HWND hDlg, int id, UI ix, WCP pBuf, UI lBuf)
{
	return AjcGetCtrlLstItemW(HWCTRL, ix, pBuf, lBuf);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboItemW(HWND hDlg, int id, UI ix, WCP pBuf, UI lBuf)
{
	return AjcGetCtrlCboItemW(HWCTRL, ix, pBuf, lBuf);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックス項目に関連付けられた数値取得									//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	コンボボックス項目に関連付けられた数値															//
//==============================================================================================================//
//	リストボックス
AJCEXPORT SX	 WINAPI AjcGetDlgItemLstData (HWND hDlg, int id, UI ix)
{
	return AjcGetCtrlLstData (HWCTRL, ix);
}
//	コンボボックス
AJCEXPORT SX	 WINAPI AjcGetDlgItemCboData (HWND hDlg, int id, UI ix)
{
	return AjcGetCtrlCboData (HWCTRL, ix);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックス項目の文字列検索												//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				ix		  - 検索開始項目インデクス（指定された次の項目から開始，－１の場合は先頭から開始する）	//
//				pStr	  - 検索する文字列のアドレス															//
//				flag	  - 検索方法（AJCCBF_EXACT_STR, AJCCBF_EXACT_WIDTH)										//
//																												//
//	戻り値：	≠－１：見つかった項目のインデクス																//
//				＝－１：文字列は見つからない																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstFindA (HWND hDlg, int id, UI ix, C_BCP pStr, UI flag)
{
	return AjcGetCtrlLstFindA (HWCTRL, ix, pStr, flag);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboFindA (HWND hDlg, int id, UI ix, C_BCP pStr, UI flag)
{
	return AjcGetCtrlCboFindA (HWCTRL, ix, pStr, flag);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstFindW (HWND hDlg, int id, UI ix, C_WCP pStr, UI flag)
{
	return AjcGetCtrlLstFindW (HWCTRL, ix, pStr, flag);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboFindW (HWND hDlg, int id, UI ix, C_WCP pStr, UI flag)
{
	return AjcGetCtrlCboFindW (HWCTRL, ix, pStr, flag);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックス項目群の最大文字列長取得										//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	≠－１：最大文字列長（終端(0x00)を含まない，項目が1つも無い場合は０を返す）						//
//				＝－１：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstMaxLenA(HWND hDlg, int id)
{
	return AjcGetCtrlLstMaxLenA (HWCTRL);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboMaxLenA(HWND hDlg, int id)
{
	return AjcGetCtrlCboMaxLenA (HWCTRL);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstMaxLenW(HWND hDlg, int id)
{
	return AjcGetCtrlLstMaxLenW (HWCTRL);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboMaxLenW(HWND hDlg, int id)
{
	return AjcGetCtrlCboMaxLenW (HWCTRL);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックス項目の高さ取得												//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	≠－１：項目の高さ																				//
//				＝－１：エラー																					//
//==============================================================================================================//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemLstHeight (HWND hDlg, int id, UI ix)
{
	return AjcGetCtrlLstHeight (HWCTRL, ix);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcGetDlgItemCboHeight (HWND hDlg, int id, UI ix)
{
	return AjcGetCtrlCboHeight (HWCTRL, ix);
}
//==============================================================================================================//
//	ダイアログ項目　コンボボックス下のエディットコントロールのハンドルを取得する								//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	≠－１：項目の高さ																				//
//				＝－１：エラー																					//
//==============================================================================================================//
AJCEXPORT HWND	 WINAPI AjcGetDlgItemCboEditHandle(HWND hDlg, int id)
{
	return AjcGetCtrlCboEditHandle(HWCTRL);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックス選択項目のインデクス設定										//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				ix		  - 設定するインデクス																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemLstIx(HWND hDlg, int id, UI ix)
{
	return AjcSetCtrlLstIx(HWCTRL, ix);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemCboIx(HWND hDlg, int id, UI ix)
{
	return AjcSetCtrlCboIx(HWCTRL, ix);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックスへ項目追加													//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				ix		  - 設定するインデクス（－１の場合は最後尾）											//
//				pItem	  - 追加する項目文字列のアドレス														//
//				flag	  - 追加方法（AJCCBF_EXACT_WIDTH, EXCLUSION, SAME_IX, SELECT)							//
//																												//
//	戻り値：	≠-1 - 挿入した位置（０～）																		//
//				＝-1 - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcSetDlgItemLstAddA (HWND hDlg, int id, UI ix, C_BCP pItem, UI flag)
{
	return AjcSetCtrlLstAddA (HWCTRL, ix, pItem, flag);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcSetDlgItemCboAddA (HWND hDlg, int id, UI ix, C_BCP pItem, UI flag)
{
	return AjcSetCtrlCboAddA (HWCTRL, ix, pItem, flag);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcSetDlgItemLstAddW (HWND hDlg, int id, UI ix, C_WCP pItem, UI flag)
{
	return AjcSetCtrlLstAddW (HWCTRL, ix, pItem, flag);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcSetDlgItemCboAddW (HWND hDlg, int id, UI ix, C_WCP pItem, UI flag)
{
	return AjcSetCtrlCboAddW (HWCTRL, ix, pItem, flag);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックスへ項目挿入													//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				ix		  - 設定するインデクス／挿入位置指定（AJCCBI_XXXXXXX）									//
//				pItem	  - 追加する項目文字列のアドレス														//
//				flag	  - 追加方法（AJCCBF_EXACT_WIDTH, EXCLUSION, SAME_IX, SELECT)							//
//																												//
//	戻り値：	≠-1 - 挿入した位置（０～）																		//
//				＝-1 - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcSetDlgItemLstInsA (HWND hDlg, int id, UI ix, C_BCP pItem, UI flag)
{
	return AjcSetCtrlLstInsA (HWCTRL, ix, pItem, flag);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcSetDlgItemCboInsA (HWND hDlg, int id, UI ix, C_BCP pItem, UI flag)
{
	return AjcSetCtrlCboInsA (HWCTRL, ix, pItem, flag);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT UI	 WINAPI AjcSetDlgItemLstInsW (HWND hDlg, int id, UI ix, C_WCP pItem, UI flag)
{
	return AjcSetCtrlLstInsW (HWCTRL, ix, pItem, flag);
}
//	コンボボックス
AJCEXPORT UI	 WINAPI AjcSetDlgItemCboInsW (HWND hDlg, int id, UI ix, C_WCP pItem, UI flag)
{
	return AjcSetCtrlCboInsW (HWCTRL, ix, pItem, flag);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックスから項目削除													//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				ix		  - 削除する項目のインデクス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemLstDel (HWND hDlg, int id, UI ix)
{
	return AjcSetCtrlLstDel (HWCTRL, ix);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemCboDel (HWND hDlg, int id, UI ix)
{
	return AjcSetCtrlCboDel (HWCTRL, ix);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックス項目に関連付ける数値を設定									//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				ix		  - 項目インデクス（－１の場合は現在の選択項目）										//
//				data	  - 関連付ける数値																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemLstData  (HWND hDlg, int id, UI ix, SX data)
{
	return AjcSetCtrlLstData(HWCTRL, ix, data);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemCboData  (HWND hDlg, int id, UI ix, SX data)
{
	return AjcSetCtrlCboData(HWCTRL, ix, data);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックスの項目群を一括設定											//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pList	  - 設定する文字列群（多重文字列）のアドレス											//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemLstListA(HWND hDlg, int id, C_BCP pList)
{
	return AjcSetCtrlLstListA(HWCTRL, pList);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemCboListA(HWND hDlg, int id, C_BCP pList)
{
	return AjcSetCtrlCboListA(HWCTRL, pList);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemLstListW(HWND hDlg, int id, C_WCP pList)
{
	return AjcSetCtrlLstListW(HWCTRL, pList);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemCboListW(HWND hDlg, int id, C_WCP pList)
{
	return AjcSetCtrlCboListW(HWCTRL, pList);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックスの全項目をリセット											//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemLstReset (HWND hDlg, int id)
{
	return AjcSetCtrlLstReset(HWCTRL);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemCboReset (HWND hDlg, int id)
{
	return AjcSetCtrlCboReset(HWCTRL);
}
//==============================================================================================================//
//	ダイアログ項目　リストボックス／コンボボックスの項目の高さ設定												//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//	リストボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemLstHeight (HWND hDlg, int id, UI ix, UI height)
{
	return AjcSetCtrlLstHeight(HWCTRL, ix, height);
}
//	コンボボックス
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemCboHeight (HWND hDlg, int id, UI ix, UI height)
{
	return AjcSetCtrlCboHeight(HWCTRL, ix, height);
}
//==============================================================================================================//
//	ダイアログ項目　コンボボックスの入力可能文字数設定															//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				limit	  - 入力可能な文字長																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemCboLimitA(HWND hDlg, int id, UI limit)
{
	return AjcSetCtrlCboLimitA(HWCTRL, limit);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemCboLimitW(HWND hDlg, int id, UI limit)
{
	return AjcSetCtrlCboLimitW(HWCTRL, limit);
}
//==============================================================================================================//
//	ダイアログ項目　プログレスバーのレンジ設定																	//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				low, high - 設定するレンジ																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemPgsRange(HWND hDlg, int id, int low, int high)
{
	return AjcSetCtrlPgsRange(HWCTRL, low, high);
}
//==============================================================================================================//
//	ダイアログ項目　プログレスバー位置設定																		//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//				pos		- 設定する位置																			//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemPgsPos(HWND hDlg, int id, int pos)
{
	return AjcSetCtrlPgsPos(HWCTRL, pos);
}

//==============================================================================================================//
//	ダイアログ項目　スライダのレンジとページサイズ設定															//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				low, high - 設定するレンジ																		//
//				page	  - ページサイズ																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemSldRange(HWND hDlg, int id, int low, int high, int page)
{
	return AjcSetCtrlSldRange(HWCTRL, low, high, page);
}
//==============================================================================================================//
//	ダイアログ項目　スライダの位置設定																			//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//				pos		- 設定する位置																			//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error（設置位置が範囲外）																//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemSldPos(HWND hDlg, int id, int pos)
{
	 return AjcSetCtrlSldPos(HWCTRL, pos);
}
//==============================================================================================================//
//	ダイアログ項目　スライダの位置取得																			//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- ダイアログ項目ＩＤ																	//
//																												//
//	戻り値：	スライダの位置																					//
//==============================================================================================================//
AJCEXPORT int	 WINAPI AjcGetDlgItemSldPos (HWND hDlg, int id)
{
	 return AjcGetCtrlSldPos(HWCTRL);
}

//==============================================================================================================//
//	ダイアログ項目　スピンボタンのレンジとバディーウインド設定													//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				low, high - 設定するレンジ																		//
//				idBuddy	  - バディーウインドのダイアログ項目ＩＤ												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemSpnInfo (HWND hDlg, int id, int low, int high, int idBuddy)
{
	return AjcSetCtrlSpnInfo(HWCTRL, low, high, GetDlgItem(hDlg, idBuddy));
}
//==============================================================================================================//
//	ダイアログ項目　スピンボタンのレンジ設定																	//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				low, high - 設定するレンジ																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemSpnRange(HWND hDlg, int id, int low, int high)
{
	return AjcSetCtrlSpnRange(HWCTRL, low, high);
}
//==============================================================================================================//
//	ダイアログ項目　スピンボタンのバディーウインド設定															//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				idBuddy	  - バディーウインドのダイアログ項目ＩＤ												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemSpnBuddy(HWND hDlg, int id, int idBuddy)
{
	return AjcSetCtrlSpnBuddy(HWCTRL, GetDlgItem(hDlg, idBuddy));
}
//==============================================================================================================//
//	コントロールを兄弟ウインド中で最前面に設定する																//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//																												//
//	戻り値：	≠ NULL - 直前の最前面ウインド																	//
//				＝ NULL	- Error																					//
//==============================================================================================================//
AJCEXPORT HWND	 WINAPI AjcSetDlgItemTopMostInSiblings	(HWND hDlg, int id)
{
	return AjcSetCtrlTopMostInSiblings(GetDlgItem(hDlg, id));
}
//==============================================================================================================//
//	コントロールを兄弟ウインド中で最背面に設定する																//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//																												//
//	戻り値：	≠ NULL - 直前の最背面ウインド																	//
//				＝ NULL	- Error																					//
//==============================================================================================================//
AJCEXPORT HWND	 WINAPI AjcSetDlgItemBackMostInSiblings(HWND hDlg, int id)
{
	return AjcSetCtrlBackMostInSiblings(GetDlgItem(hDlg, id));
}
//==============================================================================================================//
//	EDITコントロールにフォルダ／ファイルをドロップ可能にする													//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				id		  - コントロールＩＤ																	//
//				opt		  - ドロップ種別（AJCDROP_{DIR/FILE/CONNECT}）											//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcEnableDlgItemToDrop			(HWND hDlg, int id, UI optDrop)
{
	return AjcEnableCtrlToDrop(GetDlgItem(hDlg, id), optDrop);
}
//==============================================================================================================//
//	EDITコントロールにフォルダ／ファイルをドロップ可能にする（グループボックス指定）							//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				id		  - コントロールＩＤ																	//
//				idGrp	  - グループボックスのコントロールＩＤ													//
//				opt		  - ドロップ種別（AJCDROP_{DIR/FILE/CONNECT}）											//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcEnableDlgItemToDropEx		(HWND hDlg, int id, int idGrp, UI optDrop)
{
	BOOL	rc = FALSE;

	if (idGrp != 0) rc = AjcEnableCtrlToDropEx(GetDlgItem(hDlg, id), GetDlgItem(hDlg, idGrp), optDrop);
	else			rc = AjcEnableCtrlToDropEx(GetDlgItem(hDlg, id), NULL					, optDrop);

	return rc;
}
/****************************************************************************************************************/
/*																												*/
/*	コントロールの位置や矩形 取得/設定																			*/
/*																												*/
/****************************************************************************************************************/
//==============================================================================================================//
//	コントロールの位置取得																						//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pPoint	  - コントロールの位置を格納するバッファのアドレス										//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcGetDlgItemPos   (HWND hDlg, int id, LPPOINT pPoint)
{
	return AjcGetCtrlPos(HWCTRL, pPoint);
}
//==============================================================================================================//
//	コントロールのサイズ取得																					//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pPoint	  - コントロールのサイズを格納するバッファのアドレス									//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcGetDlgItemSize  (HWND hDlg, int id, LPSIZE pSize)
{
	return AjcGetCtrlSize(HWCTRL, pSize);
}
//==============================================================================================================//
//	コントロールの矩形取得																						//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pRect	  - コントロールの矩形を格納するバッファのアドレス										//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcGetDlgItemRect  (HWND hDlg, int id, LPRECT pRect)
{
	return AjcGetCtrlRect(HWCTRL, pRect);
}
//==============================================================================================================//
//	コントロールの位置設定																						//
//																												//
//	引　数：	hwnd		  - コントロールハンドル															//
//				x, y, pPos	  - コントロールの位置																//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemPos	(HWND hDlg, int id, int x, int y)
{
	return AjcSetCtrlPos(HWCTRL, x, y);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemPosV	(HWND hDlg, int id, const POINT *pPos)
{
	return AjcSetCtrlPosV(HWCTRL, pPos);
}

//==============================================================================================================//
//	コントロールのサイズ設定																					//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				pPoint	  - コントロールの位置を格納するバッファのアドレス										//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemSize	(HWND hDlg, int id, int cx, int cy)
{
	return AjcSetCtrlSize(HWCTRL, cx, cy);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemSizeV	(HWND hDlg, int id, const SIZE *pSize)
{
	return AjcSetCtrlSizeV(HWCTRL, pSize);
}

//==============================================================================================================//
//	コントロールの矩形設定																						//
//																												//
//	引　数：	hwnd	  - コントロールハンドル																//
//				pPoint	  - コントロールの位置を格納するバッファのアドレス										//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemRect	(HWND hDlg, int id, int x, int y, int cx, int cy)
{
	return AjcSetCtrlRect(HWCTRL, x, y, cx, cy);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	 WINAPI AjcSetDlgItemRectV	(HWND hDlg, int id, const RECT *pRect)
{
	return AjcSetCtrlRectV(HWCTRL, pRect);
}
/****************************************************************************************************************/
/*																												*/
/*	コントロールのグレィ設定																					*/
/*																												*/
/****************************************************************************************************************/
//==============================================================================================================//
//	コントロールの許可／禁止																					//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				fEnable   - TRUE  : コントロール許可（グレィ解除）												//
//							FALSE : コントロール禁止（グレィ化）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcEnableDlgItem (HWND hDlg, int id, BOOL fEnable)
{
	return AjcEnableCtrl(HWCTRL, fEnable);
}
//==============================================================================================================//
//	コントロールの表示／非表示																					//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				fShow	  - TRUE  : コントロール表示															//
//							FALSE : コントロール非表示															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcShowDlgItem	   (HWND hDlg, int id	, BOOL fShow)
{
	return AjcShowCtrl(HWCTRL, fShow);
}
//==============================================================================================================//
//	コントロールの表示／非表示 と 許可／禁止																	//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				fShow	  - TRUE  : コントロール表示															//
//							FALSE : コントロール非表示															//
//				fEnable	  - TRUE  : コントロール許可（グレィ解除）												//
//							FALSE : コントロール禁止（グレィ化）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcShowAndEnableDlgItem	   (HWND hDlg, int id, BOOL fShow, BOOL fEnable)
{
	return AjcShowAndEnableCtrl(HWCTRL, fShow, fEnable);
}

//==============================================================================================================//
//	グループボックス内の全コントロール許可／禁止																//
//																												//
//	引　数：	hDlg	   - ダイアログハンドル																	//
//				idGrp	   - ダイアログ項目ＩＤ（グループボックス）												//
//				fEnaGrpBox - グループボックスのグレィ設定														//
//							 TRUE  : グループボックス許可（グレィ解除）											//
//							 FALSE : グループボックス禁止（グレィ化）											//
//				fEnaCtrls  - グループボックス内の全コントロールのグレィ設定										//
//							 TRUE  : コントロール許可（グレィ解除）												//
//							 FALSE : コントロール禁止（グレィ化）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcEnableDlgGroup(HWND hDlg, int idGrp, BOOL fEnaGrpBox, BOOL fEnaCtrls)
{
	return AjcEnableGroup(GetDlgItem(hDlg, idGrp), fEnaGrpBox, fEnaCtrls);
}
//==============================================================================================================//
//	グループボックスとグループボックス内の全コントロール表示／非表示（１）										//
//																												//
//	引　数：	hDlg	   - ダイアログハンドル																	//
//				idGrp	   - ダイアログ項目ＩＤ（グループボックス）												//
//				fShow	   - 表示(TRUE)／非表示(FALSE)フラグ													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcShowDlgGroup(HWND hDlg, int idGrp, BOOL fShow)
{
	return AjcShowGroup(GetDlgItem(hDlg, idGrp), fShow);
}
//==============================================================================================================//
//	グループボックスとグループボックス内の全コントロール表示／非表示（２）										//
//																												//
//	引　数：	hDlg	   	- ダイアログハンドル																//
//				idGrp	  	- ダイアログ項目ＩＤ（グループボックス）											//
//				fShowGrpBox - グループボックスの表示フラグ														//
//				fShowCtrls	- グループボックス内の全コントロールの表示フラグ									//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI AjcShowDlgGroupEx(HWND hDlg, int idGrp, BOOL fShowGrpBox, BOOL fShowCtrls)
{
	return AjcShowGroupEx(GetDlgItem(hDlg, idGrp), fShowGrpBox, fShowCtrls);
}
//==============================================================================================================//
//	グループボックスの移動																						//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				idGrp	- ダイアログ項目ＩＤ（グループボックス）												//
//				x, y	- 移動先の位置																			//
//				idCtl	- 移動先のコントロールＩＤ																//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- 指定ロケーション位置へ移動 -----------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcMoveDlgGroupToLoc(HWND hDlg, int idGrp, int x, int y)
{
	return AjcMoveGroupToLoc(GetDlgItem(hDlg, idGrp), x, y);
}
//----- 指定コントロール位置へ移動 -----------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcMoveDlgGroupToCtl(HWND hDlg, int idGrp, int idCtl)
{
	return AjcMoveGroupToCtl(GetDlgItem(hDlg, idGrp), GetDlgItem(hDlg, idCtl));
}
//----- 元の位置へ移動 -----------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcMoveDlgGroupToOrg(HWND hDlg, int idGrp)
{
	return AjcMoveGroupToOrg(GetDlgItem(hDlg, idGrp));
}

//==============================================================================================================//
//	グループボックス内コントロールの列挙																		//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				idGrp	- グループボックスのコントロールＩＤ													//
//				cbp		- コールバックパラメタ																	//
//				cbEnum	- コントロール通知用コールバック関数													//
//																												//
//	戻り値：	通知したコントロールの個数																		//
//==============================================================================================================//
AJCEXPORT UI	WINAPI AjcDlgItemEnumInGroup(HWND hDlg, int idGrp, UX cbp, BOOL (CALLBACK *cbEnum)(HWND hCtrl, UX cbp))
{
	return AjcCtrlEnumInGroup(GetDlgItem(hDlg, idGrp), cbp, cbEnum);
}
