﻿#include	"AjcInternal.h"
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
/*																												*/
/*	プロファイル／変数のエクスチェンジ																			*/
/*																												*/
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

#define	HWCTRL	GetDlgItem(hDlg, id)

//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ設定（１０進整数項目）														//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pKey	  - プロファイル・キー名																//
//				defValue  - デフォルト値																		//
//				fComma	  - 整数部の分離フラグ（３桁枚のカンマ等）												//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropUIntA	(HWND hDlg, int id, C_BCP pKey, UI	   defValue, BOOL fComma  , UI	   *pVar)
{
	return AjcSetCtrlPropUIntA(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropSIntA	(HWND hDlg, int id, C_BCP pKey, SI	   defValue, BOOL fComma  , SI	   *pVar)
{
	return AjcSetCtrlPropSIntA(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropUI8A  (HWND hDlg, int id, C_BCP pKey, UB	  defValue, BOOL fComma  , UB	  *pVar)
{
	return AjcSetCtrlPropUI8A(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropSI8A  (HWND hDlg, int id, C_BCP pKey, SB	  defValue, BOOL fComma  , SB	  *pVar)
{
	return AjcSetCtrlPropSI8A(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropUI16A	(HWND hDlg, int id, C_BCP pKey, UW	   defValue, BOOL fComma  , UW	   *pVar)
{
	return AjcSetCtrlPropUI16A(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropSI16A	(HWND hDlg, int id, C_BCP pKey, SW	   defValue, BOOL fComma  , SW	   *pVar)
{
	return AjcSetCtrlPropSI16A(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropUI64A	(HWND hDlg, int id, C_BCP pKey, ULL    defValue, BOOL fComma  , ULL    *pVar)
{
	return AjcSetCtrlPropUI64A	(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropSI64A	(HWND hDlg, int id, C_BCP pKey, SLL    defValue, BOOL fComma  , SLL    *pVar)
{
	return AjcSetCtrlPropSI64A	(HWCTRL, pKey, defValue, fComma  , pVar);
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropUIntW	(HWND hDlg, int id, C_WCP pKey, UI	   defValue, BOOL fComma  , UI	   *pVar)
{
	return AjcSetCtrlPropUIntW(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropSIntW	(HWND hDlg, int id, C_WCP pKey, SI	   defValue, BOOL fComma  , SI	   *pVar)
{
	return AjcSetCtrlPropSIntW(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropUI8W  (HWND hDlg, int id, C_WCP pKey, UB	  defValue, BOOL fComma  , UB	  *pVar)
{
	return AjcSetCtrlPropUI8W(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropSI8W  (HWND hDlg, int id, C_WCP pKey, SB	  defValue, BOOL fComma  , SB	  *pVar)
{
	return AjcSetCtrlPropSI8W(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropUI16W	(HWND hDlg, int id, C_WCP pKey, UW	   defValue, BOOL fComma  , UW	   *pVar)
{
	return AjcSetCtrlPropUI16W(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropSI16W	(HWND hDlg, int id, C_WCP pKey, SW	   defValue, BOOL fComma  , SW	   *pVar)
{
	return AjcSetCtrlPropSI16W(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropUI64W	(HWND hDlg, int id, C_WCP pKey, ULL    defValue, BOOL fComma  , ULL    *pVar)
{
	return AjcSetCtrlPropUI64W	(HWCTRL, pKey, defValue, fComma  , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropSI64W	(HWND hDlg, int id, C_WCP pKey, SLL    defValue, BOOL fComma  , SLL    *pVar)
{
	return AjcSetCtrlPropSI64W	(HWCTRL, pKey, defValue, fComma  , pVar);
}
//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ設定（１６進整数項目）														//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pKey	  - プロファイル・キー名																//
//				defValue  - デフォルト値																		//
//				digits	  - 表示桁数（０の場合は桁揃えしない）													//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropHexA	(HWND hDlg, int id, C_BCP pKey, UI	   defValue, int digits   , UI	   *pVar)
{
	return AjcSetCtrlPropHexA	(HWCTRL, pKey, defValue, digits   , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropH8A   (HWND hDlg, int id, C_BCP pKey, UB	  defValue, int digits	 , UB	  *pVar)
{
	return AjcSetCtrlPropH8A   (HWCTRL, pKey, defValue, digits	 , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropH16A	(HWND hDlg, int id, C_BCP pKey, UW	   defValue, int digits   , UW	   *pVar)
{
	return AjcSetCtrlPropH16A	(HWCTRL, pKey, defValue, digits   , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropH64A	(HWND hDlg, int id, C_BCP pKey, ULL    defValue, int digits   , ULL    *pVar)
{
	return AjcSetCtrlPropH64A	(HWCTRL, pKey, defValue, digits   , pVar);
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropHexW	(HWND hDlg, int id, C_WCP pKey, UI	   defValue, int digits   , UI	   *pVar)
{
	return AjcSetCtrlPropHexW	(HWCTRL, pKey, defValue, digits   , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropH8W   (HWND hDlg, int id, C_WCP pKey, UB	  defValue, int digits	 , UB	  *pVar)
{
	return AjcSetCtrlPropH8W   (HWCTRL, pKey, defValue, digits	 , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropH16W	(HWND hDlg, int id, C_WCP pKey, UW	   defValue, int digits   , UW	   *pVar)
{
	return AjcSetCtrlPropH16W	(HWCTRL, pKey, defValue, digits   , pVar);
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropH64W	(HWND hDlg, int id, C_WCP pKey, ULL    defValue, int digits   , ULL    *pVar)
{
	return AjcSetCtrlPropH64W	(HWCTRL, pKey, defValue, digits   , pVar);
}
//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ設定（実数）																	//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pKey	  - プロファイル・キー名																//
//				defValue  - デフォルト値																		//
//				fComma	  - 整数部の分離フラグ（３桁枚のカンマ等）												//
//				prec	  - 小数部の桁数																		//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropRealA	(HWND hDlg, int id, C_BCP pKey, double defValue, BOOL fComma  , int prec, double *pVar)
{
	return AjcSetCtrlPropRealA	(HWCTRL, pKey, defValue, fComma  , prec, pVar);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropRealW	(HWND hDlg, int id, C_WCP pKey, double defValue, BOOL fComma  , int prec, double *pVar)
{
	return AjcSetCtrlPropRealW	(HWCTRL, pKey, defValue, fComma  , prec, pVar);
}

//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ設定（チェックボックス）														//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pKey	  - プロファイル・キー名																//
//				defState  - デフォルト状態																		//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropChkA	(HWND hDlg, int id, C_BCP pKey, UI	   defState 			  , UI	   *pVar)
{
	return AjcSetCtrlPropChkA	(HWCTRL, pKey, defState, pVar);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropChkW	(HWND hDlg, int id, C_WCP pKey, UI	   defState 			  , UI	   *pVar)
{
	return AjcSetCtrlPropChkW	(HWCTRL, pKey, defState, pVar);
}
//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ設定（テキスト）																//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pKey	  - プロファイル・キー名																//
//				pDefStr   - デフォルト文字列のアドレス															//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//				lVar	  - 変数の文字数																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropStrA	(HWND hDlg, int id, C_BCP pKey, C_BCP pDefStr, BCP pVar, int lVar)
{
	return AjcSetCtrlPropStrA	(HWCTRL, pKey, pDefStr, pVar, lVar);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropStrW	(HWND hDlg, int id, C_WCP pKey, C_WCP pDefStr, WCP pVar, int lVar)
{
	return AjcSetCtrlPropStrW	(HWCTRL, pKey, pDefStr, pVar, lVar);
}
//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ設定（コンボボックス）														//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				id		  - ダイアログ項目ＩＤ																	//
//				pKey	  - プロファイル・キー名																//
//				pDefLst   - デフォルトリスト項目群のアドレス（多重文字列へのポインタ）							//
//				DefIx	  - デフォルトの選択項目インデクス														//
//				pVar	  - 変数のアドレス（不要時はＮＵＬＬ）													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropCboA	(HWND hDlg, int id, C_BCP pKey, C_BCP pDefLst, UI DefIx, UIP pVar)
{
	return AjcSetCtrlPropCboA	(HWCTRL, pKey, pDefLst, DefIx, pVar);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgPropCboW	(HWND hDlg, int id, C_WCP pKey, C_WCP pDefLst, UI DefIx, UIP pVar)
{
	return AjcSetCtrlPropCboW	(HWCTRL, pKey, pDefLst, DefIx, pVar);
}
//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ（プロファイルからダイアログ項目の読み出し）									//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				pSec	  - プロファイルセクション名															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLoadDlgProfilesA (HWND hDlg, C_BCP pSec)
{
	return AjcLoadCtrlProfilesA (hDlg, pSec);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcLoadDlgProfilesW (HWND hDlg, C_WCP pSec)
{
	return AjcLoadCtrlProfilesW (hDlg, pSec);
}
//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ（プロファイルへダイアログ項目の書き込み）									//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//				pSec	  - プロファイルセクション名															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSaveDlgProfilesA (HWND hDlg, C_BCP pSec)
{
	return AjcSaveCtrlProfilesA (hDlg, pSec);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSaveDlgProfilesW (HWND hDlg, C_WCP pSec)
{
	return AjcSaveCtrlProfilesW (hDlg, pSec);
}
//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ（数値項目の表示リフレッシュ）												//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcRefreshDlgValuesA(HWND hDlg)
{
	return AjcRefreshCtrlValuesA(hDlg);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcRefreshDlgValuesW(HWND hDlg)
{
	return AjcRefreshCtrlValuesW(hDlg);
}

//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ（ダイアログの内容を変数に設定）												//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcGetDlgValuesA	(HWND hDlg)
{
	return AjcGetCtrlValuesA	(hDlg);
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcGetDlgValuesW	(HWND hDlg)
{
	return AjcGetCtrlValuesW	(hDlg);
}

//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ（変数の内容をダイアログに設定）												//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetDlgValuesA	(HWND hDlg)
{
	return AjcSetCtrlValuesA	(hDlg);
}

AJCEXPORT BOOL	 WINAPI AjcSetDlgValuesW	(HWND hDlg)
{
	return AjcSetCtrlValuesW	(hDlg);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
//==============================================================================================================//
//	ダイアログ項目群エクスチェンジ（設定解除）																	//
//																												//
//	引　数：	hDlg	  - ダイアログハンドル																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcReleaseDlgPropsA (HWND hDlg)
{
	return AjcReleaseCtrlPropsA (hDlg);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcReleaseDlgPropsW (HWND hDlg)
{
	return AjcReleaseCtrlPropsW (hDlg);
}

