﻿#include	"AjcInternal.h"
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	コントロールの永続化																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

//==============================================================================================================//
//	グループボックス内全コントロールの永続化情報読み出し														//
//																												//
//	引　数：	hDlg	- ダイアログウインドハンドル															//
//				idGrp	- グループボックスのコントロールＩＤ（ゼロ指定時はウインド内全コントロール）			//
//				pSect	- プロファイルセクション名のアドレス													//
//				act		- コントロールの選択動作指定															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgLoadGrpControlSettingsA(HWND hDlg, int idGrp, C_BCP pSect, UI act)
{
	HWND	hGrp = ((idGrp == 0) ? NULL : GetDlgItem(hDlg, idGrp));
	return AjcLoadGrpControlSettingsA(hDlg, hGrp, pSect, act);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgLoadGrpControlSettingsW(HWND hDlg, int idGrp, C_WCP pSect, UI act)
{
	HWND	hGrp = ((idGrp == 0) ? NULL : GetDlgItem(hDlg, idGrp));
	return AjcLoadGrpControlSettingsW(hDlg, hGrp, pSect, act);
}

//==============================================================================================================//
//	グループボックス内全コントロールの永続化情報書き込み														//
//																												//
//	引　数：	hwnd	- コントロールの親ウインドハンドル														//
//				idGrp	- グループボックスのコントロールＩＤ（ゼロ指定時はウインド内全コントロール）			//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT 	BOOL	WINAPI	AjcDlgSaveGrpControlSettings(HWND hDlg, int idGrp)
{
	HWND	hGrp = ((idGrp == 0) ? NULL : GetDlgItem(hDlg, idGrp));
	return AjcSaveGrpControlSettings(hDlg, hGrp);
}
//==============================================================================================================//
//	グループボックス内全コントロールの永続化情報書き込み（拡張）												//
//																												//
//	引　数：	hDlg	- ダイアログウインドハンドル															//
//				idGrp	- グループボックスのコントロールＩＤ（ゼロ指定時はウインド内全コントロール）			//
//				pSect	- プロファイルセクション名のアドレス													//
//				act		- コントロールの選択動作指定															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgSaveGrpControlSettingsExA(HWND hDlg, int idGrp, C_BCP pSect, UI act)
{
	HWND	hGrp = ((idGrp == 0) ? NULL : GetDlgItem(hDlg, idGrp));
	return AjcSaveGrpControlSettingsExA(hDlg, hGrp, pSect, act);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgSaveGrpControlSettingsExW(HWND hDlg, int idGrp, C_WCP pSect, UI act)
{
	HWND	hGrp = ((idGrp == 0) ? NULL : GetDlgItem(hDlg, idGrp));
	return AjcSaveGrpControlSettingsExW(hDlg, hGrp, pSect, act);
}
//==============================================================================================================//
//	コントロールの永続化設定／解除																				//
//																												//
//	引　数：	hwnd	  - コントロールのウインドハンドル														//
//				att		  - 永続化属性（０：属性解除）															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSetPermAtt(HWND hDlg, UI id, UI att)
{
	BOOL	rc = FALSE;

	if (IsWindow(hDlg)) {
		rc = AjcCtrlSetPermAtt(GetDlgItem(hDlg, id), att);
	}
	return rc;
}
//==============================================================================================================//
//	グループボックス内全コントロールの永続化設定／解除															//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				att		- 永続化属性（０：属性解除）															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSetPermAttGrp(HWND hDlg, UI idGrp, UI att)
{
	BOOL	rc = FALSE;

	if (IsWindow(hDlg)) {
		rc = AjcCtrlSetPermAttGrp(GetDlgItem(hDlg, idGrp), att);
	}
	return rc;
}
//==============================================================================================================//
//	テキストボックスロード																						//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadTextBoxA(HWND hDlg, UI id, C_BCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadTextBoxExA(GetDlgItem(hDlg, id), pSect, TRUE);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadTextBoxW(HWND hDlg, UI id, C_WCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadTextBoxExW(GetDlgItem(hDlg, id), pSect, TRUE);
	return rc;
}
//==============================================================================================================//
//	テキストボックスロード（拡張）																				//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//				fExcRdOnly	- TRUE:読み出し専用を除外															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadTextBoxExA(HWND hDlg, UI id, C_BCP pSect, BOOL fExcRdOnly)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadTextBoxExA(GetDlgItem(hDlg, id), pSect, fExcRdOnly);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadTextBoxExW(HWND hDlg, UI id, C_WCP pSect, BOOL fExcRdOnly)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadTextBoxExW(GetDlgItem(hDlg, id), pSect, fExcRdOnly);
	return rc;
}
//==============================================================================================================//
//	テキストボックスセーブ																						//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveTextBoxA(HWND hDlg, UI id, C_BCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveTextBoxExA(GetDlgItem(hDlg, id), pSect, TRUE);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveTextBoxW(HWND hDlg, UI id, C_WCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveTextBoxExW(GetDlgItem(hDlg, id), pSect, TRUE);
	return rc;
}
//==============================================================================================================//
//	テキストボックスセーブ（拡張）																				//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//				fExcRdOnly	- TRUE:読み出し専用を除外															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveTextBoxExA(HWND hDlg, UI id, C_BCP pSect, BOOL fExcRdOnly)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveTextBoxExA(GetDlgItem(hDlg, id), pSect, fExcRdOnly);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveTextBoxExW(HWND hDlg, UI id, C_WCP pSect, BOOL fExcRdOnly)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveTextBoxExW(GetDlgItem(hDlg, id), pSect, fExcRdOnly);
	return rc;
}
//==============================================================================================================//
//	チェックボックス／ラジオボタンロード																		//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//				fNtc	- イベント通知フラグ																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadChkBoxA(HWND hDlg, UI id, C_BCP pSect, BOOL fNtc)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadChkBoxA(GetDlgItem(hDlg, id), pSect, fNtc);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadChkBoxW(HWND hDlg, UI id, C_WCP pSect, BOOL fNtc)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadChkBoxW(GetDlgItem(hDlg, id), pSect, fNtc);
	return rc;
}
//==============================================================================================================//
//	チェックボックス／ラジオボタンセーブ																		//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveChkBoxA(HWND hDlg, UI id, C_BCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveChkBoxA(GetDlgItem(hDlg, id), pSect);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveChkBoxW(HWND hDlg, UI id, C_WCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveChkBoxW(GetDlgItem(hDlg, id), pSect);
	return rc;
}
//==============================================================================================================//
//	コンボボックスロード																						//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//				sel 	- 永続化項目の指定（AJCCTL_PSEL_INC{DATA/TEXT} | EXC{SEL/TEXT/EDIT}）					//
//				fNtc	- イベント通知フラグ																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Comboboxコントロール以外																//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadComboBoxA(HWND hDlg, UI id, C_BCP pSect, UI sel, BOOL fNtc)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadComboBoxA(GetDlgItem(hDlg, id), pSect, sel, fNtc);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadComboBoxW(HWND hDlg, UI id, C_WCP pSect, UI sel, BOOL fNtc)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadComboBoxW(GetDlgItem(hDlg, id), pSect, sel, fNtc);
	return rc;
}
//==============================================================================================================//
//	コンボボックスセーブ																						//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//				sel 	- 永続化項目の指定（AJCCTL_PSEL_INC{DATA/TEXT} | EXC{SEL/TEXT/EDIT}）					//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Comboboxコントロール以外																//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveComboBoxA(HWND hDlg, UI id, C_BCP pSect, UI sel)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveComboBoxA(GetDlgItem(hDlg, id), pSect, sel);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveComboBoxW(HWND hDlg, UI id, C_WCP pSect, UI sel)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveComboBoxW(GetDlgItem(hDlg, id), pSect, sel);
	return rc;
}
//==============================================================================================================//
//	セーブ済みコンボボックスデータがあるかチェック																//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//																												//
//	戻り値：	TRUE  - セーブ済みコンボボックスデータ有り														//
//				FALSE - セーブ済みコンボボックスデータなし														//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemIsComboBoxSavedA(HWND hDlg, UI id, C_BCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlIsComboBoxSavedA(GetDlgItem(hDlg, id), pSect);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemIsComboBoxSavedW(HWND hDlg, UI id, C_WCP pSect)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlIsComboBoxSavedW(GetDlgItem(hDlg, id), pSect);
	return rc;
}
//==============================================================================================================//
//	リストボックスロード																						//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//				sel 	- 永続化項目の指定（AJCCTL_PSEL_INCDATA）												//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Listboxコントロール以外																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadListBoxA(HWND hDlg, UI id, C_BCP pSect, UI sel)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadListBoxA(GetDlgItem(hDlg, id), pSect, sel);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemLoadListBoxW(HWND hDlg, UI id, C_WCP pSect, UI sel)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlLoadListBoxW(GetDlgItem(hDlg, id), pSect, sel);
	return rc;
}
//==============================================================================================================//
//	リストボックスセーブ																						//
//																												//
//	引　数：	hDlg	- ダイアログハンドル																	//
//				id		- コントロールＩＤ																		//
//				pSect	- プロファイルセクション名のアドレス													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Listboxコントロール以外																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveListBoxA(HWND hDlg, UI id, C_BCP pSect, UI sel)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveListBoxA(GetDlgItem(hDlg, id), pSect, sel);
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcDlgItemSaveListBoxW(HWND hDlg, UI id, C_WCP pSect, UI sel)
{
	BOOL	rc = FALSE;
	rc = AjcCtrlSaveListBoxW(GetDlgItem(hDlg, id), pSect, sel);
	return rc;
}

